/* accounts.c generated by valac 0.9.7, the Vala compiler
 * generated from accounts.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <json-glib/json-glib.h>


#define TYPE_ACCOUNTS_INTERFACE (accounts_interface_get_type ())
#define ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterface))
#define IS_ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_INTERFACE))
#define ACCOUNTS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterfaceIface))

typedef struct _AccountsInterface AccountsInterface;
typedef struct _AccountsInterfaceIface AccountsInterfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountsInterfaceDBusProxy AccountsInterfaceDBusProxy;
typedef DBusGProxyClass AccountsInterfaceDBusProxyClass;

#define GWIBBER_TYPE_ACCOUNTS (gwibber_accounts_get_type ())
#define GWIBBER_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_ACCOUNTS, GwibberAccounts))
#define GWIBBER_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_ACCOUNTS, GwibberAccountsClass))
#define GWIBBER_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_ACCOUNTS))
#define GWIBBER_IS_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_ACCOUNTS))
#define GWIBBER_ACCOUNTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_ACCOUNTS, GwibberAccountsClass))

typedef struct _GwibberAccounts GwibberAccounts;
typedef struct _GwibberAccountsClass GwibberAccountsClass;
typedef struct _GwibberAccountsPrivate GwibberAccountsPrivate;

#define GWIBBER_TYPE_UTILS (gwibber_utils_get_type ())
#define GWIBBER_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_UTILS, GwibberUtils))
#define GWIBBER_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_UTILS, GwibberUtilsClass))
#define GWIBBER_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_UTILS))
#define GWIBBER_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_UTILS))
#define GWIBBER_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_UTILS, GwibberUtilsClass))

typedef struct _GwibberUtils GwibberUtils;
typedef struct _GwibberUtilsClass GwibberUtilsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _AccountsInterfaceIface {
	GTypeInterface parent_iface;
	char* (*List) (AccountsInterface* self, GError** error);
	char* (*Get) (AccountsInterface* self, const char* id, GError** error);
	void (*SendEnabled) (AccountsInterface* self, const char* id, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _AccountsInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _GwibberAccounts {
	GObject parent_instance;
	GwibberAccountsPrivate * priv;
};

struct _GwibberAccountsClass {
	GObjectClass parent_class;
};

struct _GwibberAccountsPrivate {
	AccountsInterface* accounts_service;
	GHashTable* accounts_table;
	GHashTable* account_table;
	GwibberUtils* utils;
};


static gpointer gwibber_accounts_parent_class = NULL;

AccountsInterface* accounts_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType accounts_interface_get_type (void) G_GNUC_CONST;
char* accounts_interface_List (AccountsInterface* self, GError** error);
char* accounts_interface_Get (AccountsInterface* self, const char* id, GError** error);
void accounts_interface_SendEnabled (AccountsInterface* self, const char* id, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void accounts_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _accounts_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult accounts_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_accounts_interface_introspect (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_accounts_interface_property_get_all (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_accounts_interface_List (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_accounts_interface_Get (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_accounts_interface_SendEnabled (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_accounts_interface_updated (GObject* _sender, const char* account, DBusConnection* _connection);
static void _dbus_accounts_interface_created (GObject* _sender, const char* account, DBusConnection* _connection);
static void _dbus_accounts_interface_deleted (GObject* _sender, const char* account, DBusConnection* _connection);
GType accounts_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_accounts_interface_updated (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_accounts_interface_created (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_accounts_interface_deleted (AccountsInterface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult accounts_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	ACCOUNTS_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static char* accounts_interface_dbus_proxy_List (AccountsInterface* self, GError** error);
static char* accounts_interface_dbus_proxy_Get (AccountsInterface* self, const char* id, GError** error);
static void accounts_interface_dbus_proxy_SendEnabled (AccountsInterface* self, const char* id, GError** error);
static void accounts_interface_dbus_proxy_accounts_interface__interface_init (AccountsInterfaceIface* iface);
static void accounts_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void accounts_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gwibber_accounts_get_type (void) G_GNUC_CONST;
GType gwibber_utils_get_type (void) G_GNUC_CONST;
#define GWIBBER_ACCOUNTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_ACCOUNTS, GwibberAccountsPrivate))
enum  {
	GWIBBER_ACCOUNTS_DUMMY_PROPERTY
};
#define GWIBBER_ACCOUNTS_accounts_name "com.Gwibber.Accounts"
#define GWIBBER_ACCOUNTS_accounts_path "/com/gwibber/Accounts"
#define GWIBBER_ACCOUNTS_accounts_iface "com.Gwibber.Accounts"
GwibberAccounts* gwibber_accounts_new (void);
GwibberAccounts* gwibber_accounts_construct (GType object_type);
GwibberUtils* gwibber_utils_new (void);
GwibberUtils* gwibber_utils_construct (GType object_type);
void gwibber_utils_setup (GwibberUtils* self, const char* name, GError** error);
void gwibber_accounts_accounts_available (GwibberAccounts* self, gboolean is_up);
static void _gwibber_accounts_accounts_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void _lambda0_ (const char* source, GwibberAccounts* self);
void gwibber_accounts_updated (GwibberAccounts* self, const char* account_in);
static void __lambda0__accounts_interface_updated (AccountsInterface* _sender, const char* account, gpointer self);
GHashTable* gwibber_accounts_list (GwibberAccounts* self);
static void _g_hash_table_remove_all_gdestroy_notify (void* data);
static GValue* _g_value_dup (GValue* self);
GHashTable* gwibber_accounts_lookup_by_id (GwibberAccounts* self, const char* id);
void gwibber_accounts_send_enabled (GwibberAccounts* self, const char* id);
static void gwibber_accounts_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _accounts_interface_dbus_path_vtable = {_accounts_interface_dbus_unregister, accounts_interface_dbus_message};
static const _DBusObjectVTable _accounts_interface_dbus_vtable = {accounts_interface_dbus_register_object};

static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

char* accounts_interface_List (AccountsInterface* self, GError** error) {
	return ACCOUNTS_INTERFACE_GET_INTERFACE (self)->List (self, error);
}


char* accounts_interface_Get (AccountsInterface* self, const char* id, GError** error) {
	return ACCOUNTS_INTERFACE_GET_INTERFACE (self)->Get (self, id, error);
}


void accounts_interface_SendEnabled (AccountsInterface* self, const char* id, GError** error) {
	ACCOUNTS_INTERFACE_GET_INTERFACE (self)->SendEnabled (self, id, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _accounts_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_accounts_interface_introspect (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.Gwibber.Accounts\">\n  <method name=\"List\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"Get\">\n    <arg name=\"id\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"SendEnabled\">\n    <arg name=\"id\" type=\"s\" direction=\"in\"/>\n  </method>\n  <signal name=\"Updated\">\n    <arg name=\"account\" type=\"s\"/>\n  </signal>\n  <signal name=\"Created\">\n    <arg name=\"account\" type=\"s\"/>\n  </signal>\n  <signal name=\"Deleted\">\n    <arg name=\"account\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_accounts_interface_property_get_all (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.Gwibber.Accounts") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_accounts_interface_List (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp1_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = accounts_interface_List (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp1_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_accounts_interface_Get (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* id = NULL;
	const char* _tmp2_;
	char* result;
	DBusMessage* reply;
	const char* _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	id = g_strdup (_tmp2_);
	result = accounts_interface_Get (self, id, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (id);
	_tmp3_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp3_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_accounts_interface_SendEnabled (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* id = NULL;
	const char* _tmp4_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	id = g_strdup (_tmp4_);
	accounts_interface_SendEnabled (self, id, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (id);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult accounts_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_accounts_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_accounts_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Accounts", "List")) {
		result = _dbus_accounts_interface_List (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Accounts", "Get")) {
		result = _dbus_accounts_interface_Get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Accounts", "SendEnabled")) {
		result = _dbus_accounts_interface_SendEnabled (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_accounts_interface_updated (GObject* _sender, const char* account, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp5_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.Gwibber.Accounts", "Updated");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp5_ = account;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp5_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_accounts_interface_created (GObject* _sender, const char* account, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp6_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.Gwibber.Accounts", "Created");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp6_ = account;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp6_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_accounts_interface_deleted (GObject* _sender, const char* account, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp7_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.Gwibber.Accounts", "Deleted");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp7_ = account;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp7_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void accounts_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_accounts_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_accounts_interface_updated, connection);
	g_signal_connect (object, "created", (GCallback) _dbus_accounts_interface_created, connection);
	g_signal_connect (object, "deleted", (GCallback) _dbus_accounts_interface_deleted, connection);
}


static void accounts_interface_base_init (AccountsInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("updated", TYPE_ACCOUNTS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("created", TYPE_ACCOUNTS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("deleted", TYPE_ACCOUNTS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_type_set_qdata (TYPE_ACCOUNTS_INTERFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_accounts_interface_dbus_vtable));
	}
}


GType accounts_interface_get_type (void) {
	static volatile gsize accounts_interface_type_id__volatile = 0;
	if (g_once_init_enter (&accounts_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountsInterfaceIface), (GBaseInitFunc) accounts_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType accounts_interface_type_id;
		accounts_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (accounts_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (accounts_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &accounts_interface_dbus_proxy_get_type);
		g_once_init_leave (&accounts_interface_type_id__volatile, accounts_interface_type_id);
	}
	return accounts_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (AccountsInterfaceDBusProxy, accounts_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_ACCOUNTS_INTERFACE, accounts_interface_dbus_proxy_accounts_interface__interface_init) );
AccountsInterface* accounts_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	AccountsInterface* self;
	self = g_object_new (accounts_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.Gwibber.Accounts", NULL);
	return self;
}


static GObject* accounts_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (accounts_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), accounts_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_accounts_interface_updated (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* account = NULL;
	const char* _tmp11_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	account = g_strdup (_tmp11_);
	g_signal_emit_by_name (self, "updated", account);
	_g_free0 (account);
}


static void _dbus_handle_accounts_interface_created (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* account = NULL;
	const char* _tmp12_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	account = g_strdup (_tmp12_);
	g_signal_emit_by_name (self, "created", account);
	_g_free0 (account);
}


static void _dbus_handle_accounts_interface_deleted (AccountsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* account = NULL;
	const char* _tmp13_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	account = g_strdup (_tmp13_);
	g_signal_emit_by_name (self, "deleted", account);
	_g_free0 (account);
}


DBusHandlerResult accounts_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "com.Gwibber.Accounts", "Updated")) {
			_dbus_handle_accounts_interface_updated (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "com.Gwibber.Accounts", "Created")) {
			_dbus_handle_accounts_interface_created (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "com.Gwibber.Accounts", "Deleted")) {
			_dbus_handle_accounts_interface_deleted (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void accounts_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((AccountsInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((AccountsInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), accounts_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (accounts_interface_dbus_proxy_parent_class)->dispose (self);
}


static void accounts_interface_dbus_proxy_class_init (AccountsInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = accounts_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = accounts_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = accounts_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = accounts_interface_dbus_proxy_set_property;
}


static void accounts_interface_dbus_proxy_init (AccountsInterfaceDBusProxy* self) {
}


static char* accounts_interface_dbus_proxy_List (AccountsInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp14_;
	if (((AccountsInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Accounts", "List");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp15_;
			_edomain = DBUS_GERROR;
			_tmp15_ = _dbus_error.name + 27;
			if (strcmp (_tmp15_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp15_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp15_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp15_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp15_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp15_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp15_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp15_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp15_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp15_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp15_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp15_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp15_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp15_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp15_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp15_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp15_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp15_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp15_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp15_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp15_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp15_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp15_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp15_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp15_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp15_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp15_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp15_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp15_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp15_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp15_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp15_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp15_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp14_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp14_);
	dbus_message_unref (_reply);
	return _result;
}


static char* accounts_interface_dbus_proxy_Get (AccountsInterface* self, const char* id, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp16_;
	char* _result;
	const char* _tmp17_;
	if (((AccountsInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Accounts", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp16_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp16_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp18_;
			_edomain = DBUS_GERROR;
			_tmp18_ = _dbus_error.name + 27;
			if (strcmp (_tmp18_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp18_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp18_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp18_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp18_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp18_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp18_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp18_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp18_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp18_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp18_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp18_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp18_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp18_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp18_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp18_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp18_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp18_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp18_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp18_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp18_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp18_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp18_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp18_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp18_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp18_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp18_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp18_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp18_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp17_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp17_);
	dbus_message_unref (_reply);
	return _result;
}


static void accounts_interface_dbus_proxy_SendEnabled (AccountsInterface* self, const char* id, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp19_;
	if (((AccountsInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Accounts", "SendEnabled");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp19_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp20_;
			_edomain = DBUS_GERROR;
			_tmp20_ = _dbus_error.name + 27;
			if (strcmp (_tmp20_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp20_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp20_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp20_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp20_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp20_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp20_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp20_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp20_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp20_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp20_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp20_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp20_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp20_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp20_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp20_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp20_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp20_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp20_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp20_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp20_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp20_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp20_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp20_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp20_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp20_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp20_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp20_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp20_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void accounts_interface_dbus_proxy_accounts_interface__interface_init (AccountsInterfaceIface* iface) {
	iface->List = accounts_interface_dbus_proxy_List;
	iface->Get = accounts_interface_dbus_proxy_Get;
	iface->SendEnabled = accounts_interface_dbus_proxy_SendEnabled;
}


static void accounts_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void accounts_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _gwibber_accounts_accounts_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_accounts_accounts_available (self, up);
}


static void _lambda0_ (const char* source, GwibberAccounts* self) {
	g_return_if_fail (source != NULL);
	gwibber_accounts_updated (self, source);
}


static void __lambda0__accounts_interface_updated (AccountsInterface* _sender, const char* account, gpointer self) {
	_lambda0_ (account, self);
}


GwibberAccounts* gwibber_accounts_construct (GType object_type) {
	GwibberAccounts * self;
	GError * _inner_error_ = NULL;
	self = (GwibberAccounts*) g_object_new (object_type, NULL);
	{
		DBusGConnection* dbus_conn;
		AccountsInterface* _tmp0_;
		GwibberUtils* _tmp1_;
		dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		self->priv->accounts_service = (_tmp0_ = accounts_interface_dbus_proxy_new (dbus_conn, GWIBBER_ACCOUNTS_accounts_name, GWIBBER_ACCOUNTS_accounts_path), _g_object_unref0 (self->priv->accounts_service), _tmp0_);
		self->priv->utils = (_tmp1_ = gwibber_utils_new (), _g_object_unref0 (self->priv->utils), _tmp1_);
		gwibber_utils_setup (self->priv->utils, GWIBBER_ACCOUNTS_accounts_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			_dbus_g_connection_unref0 (dbus_conn);
			goto __catch10_g_error;
		}
		g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_accounts_accounts_available_gwibber_utils_available, self, 0);
		g_signal_connect_object (self->priv->accounts_service, "updated", (GCallback) __lambda0__accounts_interface_updated, self, 0);
		_dbus_g_connection_unref0 (dbus_conn);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("accounts.vala:85: Unable to get Gwibber accounts");
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


GwibberAccounts* gwibber_accounts_new (void) {
	return gwibber_accounts_construct (GWIBBER_TYPE_ACCOUNTS);
}


static void _g_hash_table_remove_all_gdestroy_notify (void* data) {
	g_hash_table_remove_all (data);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


GHashTable* gwibber_accounts_list (GwibberAccounts* self) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->accounts_table = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _g_hash_table_remove_all_gdestroy_notify), _g_hash_table_unref0 (self->priv->accounts_table), _tmp0_);
	{
		char* accounts;
		JsonParser* parser;
		accounts = accounts_interface_List (self->priv->accounts_service, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch11_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		parser = json_parser_new ();
		{
			JsonArray* nodeArray;
			json_parser_load_from_data (parser, accounts, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			nodeArray = _json_array_ref0 (json_node_get_array (json_parser_get_root (parser)));
			{
				gint i;
				i = 0;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						char* id;
						GHashTable* _tmp2_;
						if (!_tmp1_) {
							i++;
						}
						_tmp1_ = FALSE;
						if (!(i < json_array_get_length (nodeArray))) {
							break;
						}
						id = g_strdup (json_object_get_string_member (json_node_get_object (json_array_get_element (nodeArray, (guint) i)), "id"));
						self->priv->account_table = (_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->account_table), _tmp2_);
						{
							GList* member_collection;
							GList* member_it;
							member_collection = json_object_get_members (json_node_get_object (json_array_get_element (nodeArray, (guint) i)));
							for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
								const char* member;
								member = (const char*) member_it->data;
								{
									gboolean _tmp3_ = FALSE;
									if (_vala_strcmp0 (member, "_conflicts") != 0) {
										_tmp3_ = _vala_strcmp0 (member, "_deleted_conflicts") != 0;
									} else {
										_tmp3_ = FALSE;
									}
									if (_tmp3_) {
										GValue value = {0};
										if (json_node_is_null (json_object_get_member (json_node_get_object (json_array_get_element (nodeArray, (guint) i)), member))) {
											G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
											continue;
										} else {
											if (_vala_strcmp0 (json_node_type_name (json_object_get_member (json_node_get_object (json_array_get_element (nodeArray, (guint) i)), member)), "gboolean") == 0) {
												GValue _tmp4_ = {0};
												GValue _tmp5_;
												value = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp4_, json_node_get_boolean (json_object_get_member (json_node_get_object (json_array_get_element (nodeArray, (guint) i)), member))), _tmp4_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp5_);
											} else {
												GValue _tmp6_ = {0};
												GValue _tmp7_;
												json_node_get_value (json_object_get_member (json_node_get_object (json_array_get_element (nodeArray, (guint) i)), member), &_tmp6_);
												value = (_tmp7_ = _tmp6_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp7_);
											}
										}
										g_hash_table_insert (self->priv->account_table, g_strdup (member), __g_value_dup0 (&value));
										G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
									}
								}
							}
							_g_list_free0 (member_collection);
						}
						g_hash_table_insert (self->priv->accounts_table, g_strdup (id), _g_hash_table_ref0 (self->priv->account_table));
						_g_free0 (id);
					}
				}
			}
			result = _g_hash_table_ref0 (self->priv->accounts_table);
			_json_array_unref0 (nodeArray);
			_g_object_unref0 (parser);
			_g_free0 (accounts);
			return result;
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("accounts.vala:118: %s", e->message);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (parser);
				_g_free0 (accounts);
				return result;
			}
		}
		__finally12:
		{
			_g_object_unref0 (parser);
			_g_free0 (accounts);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch11_dbus_gerror;
			}
			_g_object_unref0 (parser);
			_g_free0 (accounts);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (parser);
		_g_free0 (accounts);
	}
	goto __finally11;
	__catch11_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("accounts.vala:122: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally11:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


GHashTable* gwibber_accounts_lookup_by_id (GwibberAccounts* self, const char* id) {
	GHashTable* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		char* account;
		GHashTable* _tmp0_;
		JsonParser* parser;
		account = accounts_interface_Get (self->priv->accounts_service, id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch13_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->account_table = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->account_table), _tmp0_);
		parser = json_parser_new ();
		{
			JsonObject* root_object;
			json_parser_load_from_data (parser, account, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch14_g_error;
			}
			root_object = _json_object_ref0 (json_node_get_object (json_parser_get_root (parser)));
			{
				GList* param_collection;
				GList* param_it;
				param_collection = json_object_get_members (root_object);
				for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
					const char* param;
					param = (const char*) param_it->data;
					{
						GValue* value;
						value = NULL;
						if (json_node_is_null (json_object_get_member (root_object, param))) {
							_g_free0 (value);
							continue;
						} else {
							if (_vala_strcmp0 (json_node_type_name (json_object_get_member (root_object, param)), "gboolean") == 0) {
								GValue* _tmp1_ = NULL;
								GValue* _tmp2_;
								value = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), g_value_init (_tmp1_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp1_, json_node_get_boolean (json_object_get_member (root_object, param))), _tmp1_), _g_free0 (value), _tmp2_);
							} else {
								GValue _tmp3_ = {0};
								GValue* _tmp4_;
								GValue _tmp5_;
								GValue _tmp6_;
								json_node_get_value (json_object_get_member (root_object, param), &_tmp3_);
								value = (_tmp4_ = __g_value_dup0 ((_tmp6_ = _tmp5_ = _tmp3_, &_tmp6_)), _g_free0 (value), _tmp4_);
								G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
							}
						}
						g_hash_table_insert (self->priv->account_table, g_strdup (param), __g_value_dup0 (value));
						_g_free0 (value);
					}
				}
				_g_list_free0 (param_collection);
			}
			result = _g_hash_table_ref0 (self->priv->account_table);
			_json_object_unref0 (root_object);
			_g_object_unref0 (parser);
			_g_free0 (account);
			return result;
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("accounts.vala:149: %s", e->message);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (parser);
				_g_free0 (account);
				return result;
			}
		}
		__finally14:
		{
			_g_object_unref0 (parser);
			_g_free0 (account);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch13_dbus_gerror;
			}
			_g_object_unref0 (parser);
			_g_free0 (account);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (parser);
		_g_free0 (account);
	}
	goto __finally13;
	__catch13_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("accounts.vala:153: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally13:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


/**
            send_enabled:

            Toggle the value of send_enabled for an account.
        */
void gwibber_accounts_send_enabled (GwibberAccounts* self, const char* id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	{
		accounts_interface_SendEnabled (self->priv->accounts_service, id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch15_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally15;
	__catch15_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("accounts.vala:169: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_accounts_updated (GwibberAccounts* self, const char* account_in) {
	char* account;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account_in != NULL);
	account = g_strdup ((const char*) account_in);
	{
		GHashTable* _tmp0_;
		JsonParser* parser;
		JsonObject* root_object;
		self->priv->account_table = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->account_table), _tmp0_);
		parser = json_parser_new ();
		json_parser_load_from_data (parser, account, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch16_g_error;
		}
		root_object = _json_object_ref0 (json_node_get_object (json_parser_get_root (parser)));
		{
			GList* param_collection;
			GList* param_it;
			param_collection = json_object_get_members (root_object);
			for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
				const char* param;
				param = (const char*) param_it->data;
				{
					GValue* value;
					value = NULL;
					if (json_node_is_null (json_object_get_member (root_object, param))) {
						_g_free0 (value);
						continue;
					} else {
						if (_vala_strcmp0 (json_node_type_name (json_object_get_member (root_object, param)), "gboolean") == 0) {
							GValue* _tmp1_ = NULL;
							GValue* _tmp2_;
							value = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), g_value_init (_tmp1_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp1_, json_node_get_boolean (json_object_get_member (root_object, param))), _tmp1_), _g_free0 (value), _tmp2_);
						} else {
							GValue _tmp3_ = {0};
							GValue* _tmp4_;
							GValue _tmp5_;
							GValue _tmp6_;
							json_node_get_value (json_object_get_member (root_object, param), &_tmp3_);
							value = (_tmp4_ = __g_value_dup0 ((_tmp6_ = _tmp5_ = _tmp3_, &_tmp6_)), _g_free0 (value), _tmp4_);
							G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
						}
					}
					g_hash_table_insert (self->priv->account_table, g_strdup (param), __g_value_dup0 (value));
					_g_free0 (value);
				}
			}
			_g_list_free0 (param_collection);
		}
		g_signal_emit_by_name (self, "account-updated", self->priv->account_table);
		_json_object_unref0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("accounts.vala:194: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_free0 (account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (account);
}


void gwibber_accounts_accounts_available (GwibberAccounts* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


static void gwibber_accounts_class_init (GwibberAccountsClass * klass) {
	gwibber_accounts_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberAccountsPrivate));
	G_OBJECT_CLASS (klass)->finalize = gwibber_accounts_finalize;
	/** 
	            Accounts::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Accounts availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	/** 
	            Accounts::account_updated:
	            @arg0: HashTable of an account
	
	            Emitted when an account has changed
	        */
	g_signal_new ("account_updated", GWIBBER_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_HASH_TABLE);
}


static void gwibber_accounts_instance_init (GwibberAccounts * self) {
	self->priv = GWIBBER_ACCOUNTS_GET_PRIVATE (self);
}


static void gwibber_accounts_finalize (GObject* obj) {
	GwibberAccounts * self;
	self = GWIBBER_ACCOUNTS (obj);
	_g_object_unref0 (self->priv->accounts_service);
	_g_hash_table_unref0 (self->priv->accounts_table);
	_g_hash_table_unref0 (self->priv->account_table);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_accounts_parent_class)->finalize (obj);
}


GType gwibber_accounts_get_type (void) {
	static volatile gsize gwibber_accounts_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_accounts_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberAccountsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_accounts_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberAccounts), 0, (GInstanceInitFunc) gwibber_accounts_instance_init, NULL };
		GType gwibber_accounts_type_id;
		gwibber_accounts_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberAccounts", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_accounts_type_id__volatile, gwibber_accounts_type_id);
	}
	return gwibber_accounts_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}



