/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QINDICATEINDICATOR_H
#define QINDICATEINDICATOR_H

// Qt
#include <QMetaType>
#include <QObject>

// Local

class QDateTime;
class QImage;
class QStringList;
class QTime;

struct _IndicateIndicator;

namespace QIndicate
{

struct IndicatorPrivate;
class Indicator : public QObject
{
Q_OBJECT
public:
    Indicator(QObject* parent=0);
    ~Indicator();

    void setIndicatorProperty(const QString& key, const char* value);
    void setIndicatorProperty(const QString& key, const QString& value);
    void setIndicatorProperty(const QString& key, const QDateTime& value);
    void setIndicatorProperty(const QString& key, const QImage& value);
    void setIndicatorProperty(const QString& key, int value);
    void setIndicatorProperty(const QString& key, bool value);

    QByteArray indicatorProperty(const QString& key) const;

    /**
     * Convenience method to define icon
     */
    void setIconProperty(const QImage&);

    /**
     * Convenience method to read icon
     */
    QImage iconProperty() const;

    /**
     * Convenience method to define time
     */
    void setTimeProperty(const QDateTime&);

    /**
     * Convenience method to read time
     */
    QDateTime timeProperty() const;

    /**
     * Convenience method to define name
     */
    void setNameProperty(const QString&);

    /**
     * Convenience method to read name
     */
    QString nameProperty() const;

    /**
     * Convenience method to define count
     */
    void setCountProperty(int);

    /**
     * Convenience method to read count
     */
    int countProperty() const;

    /**
     * Convenience method to define draw_attention
     */
    void setDrawAttentionProperty(bool);

    /**
     * Convenience method to read draw_attention
     */
    bool drawAttentionProperty() const;

    /**
     * Returns a list containing all the property keys
     */
    QStringList propertyList() const;

    void show();
    void hide();

    uint id() const;

    /**
     * Emit the display() signal
     */
    void emitDisplay();

Q_SIGNALS:
    /**
     * Emitted when the user has clicked on this indicator.  In the messaging
     * indicator this would be when someone clicks on the menu item for the
     * indicator.
     *
     * @since 0.2.0
     */
    void display(QIndicate::Indicator*);

protected:
    Indicator(struct _IndicateIndicator*, QObject* parent);

private:
    IndicatorPrivate* const d;
};

} // namespace

Q_DECLARE_METATYPE(QIndicate::Indicator*);

#endif /* QINDICATEINDICATOR_H */
