/*
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Some functions in this file use the VSOP87 solution by
 *  Messrs. Bretagnon and Francou.
 * 
 *  Copyright (C) 2000 - 2005 Liam Girdwood  
 */

#include <math.h>
#include <libnova/mercury.h>
#include <libnova/vsop87.h>
#include <libnova/solar.h>
#include <libnova/earth.h>
#include <libnova/transform.h>
#include <libnova/rise_set.h>
#include <libnova/utility.h>

#define LONG_L0 1583
#define LONG_L1 931
#define LONG_L2 438
#define LONG_L3 162
#define LONG_L4 23
#define LONG_L5 12
#define LAT_B0 818
#define LAT_B1 492
#define LAT_B2 231
#define LAT_B3 39
#define LAT_B4 13
#define LAT_B5 10
#define RADIUS_R0 1209
#define RADIUS_R1 706
#define RADIUS_R2 318
#define RADIUS_R3 111
#define RADIUS_R4 17
#define RADIUS_R5 10

/* cache variables */
static double cJD = 0, cL = 0, cB = 0, cR = 0;

static const struct ln_vsop mercury_longitude_l0[LONG_L0] = {
    {     4.40250710144,  0.00000000000,        0.00000000000}, 
    {     0.40989414977,  1.48302034195,    26087.90314157420}, 
    {     0.05046294200,  4.47785489551,    52175.80628314840}, 
    {     0.00855346844,  1.16520322459,    78263.70942472259}, 
    {     0.00165590362,  4.11969163423,   104351.61256629678}, 
    {     0.00034561897,  0.77930768443,   130439.51570787099}, 
    {     0.00007583476,  3.71348404924,   156527.41884944518}, 
    {     0.00003559745,  1.51202675145,     1109.37855209340}, 
    {     0.00001726011,  0.35832267096,   182615.32199101939}, 
    {     0.00001803464,  4.10333184211,     5661.33204915220}, 
    {     0.00001364681,  4.59918328256,    27197.28169366760}, 
    {     0.00001589923,  2.99510423560,    25028.52121138500}, 
    {     0.00001017332,  0.88031393824,    31749.23519072640}, 
    {     0.00000714182,  1.54144862493,    24978.52458948080}, 
    {     0.00000643759,  5.30266166599,    21535.94964451540}, 
    {     0.00000404200,  3.28228953196,   208703.22513259358}, 
    {     0.00000352442,  5.24156372447,    20426.57109242200}, 
    {     0.00000343312,  5.76531703870,      955.59974160860}, 
    {     0.00000339215,  5.86327825226,    25558.21217647960}, 
    {     0.00000451137,  6.04989282259,    51116.42435295920}, 
    {     0.00000325329,  1.33674488758,    53285.18483524180}, 
    {     0.00000259588,  0.98732774234,     4551.95349705880}, 
    {     0.00000345213,  2.79211954198,    15874.61759536320}, 
    {     0.00000272948,  2.49451165014,      529.69096509460}, 
    {     0.00000234831,  0.26672019191,    11322.66409830440}, 
    {     0.00000238793,  0.11343914400,     1059.38193018920}, 
    {     0.00000264336,  3.91705105199,    57837.13833230060}, 
    {     0.00000216645,  0.65987085507,    13521.75144159140}, 
    {     0.00000183358,  2.62878694178,    27043.50288318280}, 
    {     0.00000175965,  4.53636943501,    51066.42773105500}, 
    {     0.00000181629,  2.43413603252,    25661.30495069820}, 
    {     0.00000208996,  2.09178645677,    47623.85278608960}, 
    {     0.00000172642,  2.45200139206,    24498.83024629040}, 
    {     0.00000142317,  3.36004060149,    37410.56723987860}, 
    {     0.00000137943,  0.29098540695,    10213.28554621100}, 
    {     0.00000118233,  2.78149967294,    77204.32749453338}, 
    {     0.00000096860,  6.20398934398,   234791.12827416777}, 
    {     0.00000125219,  3.72079967668,    39609.65458316560}, 
    {     0.00000086819,  2.64218953915,    51646.11531805379}, 
    {     0.00000086723,  1.95952945936,    46514.47423399620}, 
    {     0.00000088330,  5.41338287192,    26617.59410666880}, 
    {     0.00000106422,  4.20572143374,    19804.82729158280}, 
    {     0.00000089987,  5.85243663953,    41962.52073693740}, 
    {     0.00000084970,  4.33100839394,    79373.08797681599}, 
    {     0.00000069247,  4.19446500577,       19.66976089979}, 
    {     0.00000063462,  3.14700988911,     7238.67559160000}, 
    {     0.00000068493,  0.63424913908,    83925.04147387479}, 
    {     0.00000069728,  3.57201999194,    25132.30339996560}, 
    {     0.00000059481,  2.74692562834,    16983.99614745660}, 
    {     0.00000064830,  0.04762450218,    33326.57873317420}, 
    {     0.00000055377,  4.05313774098,    30639.85663863300}, 
    {     0.00000054443,  3.14332489827,    27147.28507176339}, 
    {     0.00000047560,  5.49722123456,        3.88133535800}, 
    {     0.00000049567,  3.98985799218,     6770.71060124560}, 
    {     0.00000056532,  5.11921332252,    73711.75592766379}, 
    {     0.00000041764,  5.64184020485,    53131.40602475700}, 
    {     0.00000051459,  5.47786791090,    50586.73338786459}, 
    {     0.00000044745,  1.22367821919,    77154.33087262919}, 
    {     0.00000041882,  5.19309331936,     6283.07584999140}, 
    {     0.00000038045,  2.43118010131,    12566.15169998280}, 
    {     0.00000035627,  0.81389896255,    32858.61374281979}, 
    {     0.00000048008,  5.49260945754,    51749.20809227239}, 
    {     0.00000035393,  3.36964017301,    36301.18868778519}, 
    {     0.00000033952,  2.78617956300,    14765.23904326980}, 
    {     0.00000030560,  5.84043579595,    43071.89928903080}, 
    {     0.00000035964,  1.42379903884,     2218.75710418680}, 
    {     0.00000034044,  0.47470616849,    65697.55772473979}, 
    {     0.00000030800,  5.77017754761,   103292.23063610759}, 
    {     0.00000028497,  0.65049545721,      426.59819087600}, 
    {     0.00000026215,  5.24159685130,    22645.32819660879}, 
    {     0.00000026253,  0.64808296487,     1589.07289528380}, 
    {     0.00000029538,  0.69772207795,      213.29909543800}, 
    {     0.00000027505,  0.98011083160,    45892.73043315699}, 
    {     0.00000022347,  5.65336593067,    77734.01845962799}, 
    {     0.00000022047,  4.93396759824,    72602.37737557039}, 
    {     0.00000022275,  2.17909946933,    52705.49724824299}, 
    {     0.00000024253,  4.39994479508,        7.11354700080}, 
    {     0.00000026751,  1.06147352850,     3442.57494496540}, 
    {     0.00000023656,  2.84171550782,   260879.03141574195}, 
    {     0.00000022908,  2.58461108154,    68050.42387851159}, 
    {     0.00000027087,  0.08501671340,    63498.47038145279}, 
    {     0.00000022247,  3.22418752189,    25448.00585526019}, 
    {     0.00000017803,  3.61202758583,   110012.94461544899}, 
    {     0.00000022407,  1.02519770236,   105460.99111839019}, 
    {     0.00000017576,  4.71743981697,    25874.60404613620}, 
    {     0.00000018587,  4.52707983519,    28306.66024576099}, 
    {     0.00000014176,  6.12393941824,    53235.18821333759}, 
    {     0.00000014185,  5.14248515833,    26068.23338067440}, 
    {     0.00000017244,  0.28394283830,    51220.20654153979}, 
    {     0.00000017176,  3.26084148462,      153.77881048480}, 
    {     0.00000014939,  1.83543553823,    99799.65906923798}, 
    {     0.00000013389,  0.76569062416,    56727.75978020720}, 
    {     0.00000013978,  2.30196369782,    76674.63652943878}, 
    {     0.00000014428,  0.96645616238,    26107.57290247399}, 
    {     0.00000011991,  6.20493040602,    18849.22754997420}, 
    {     0.00000014381,  1.90954650143,    23969.13928119580}, 
    {     0.00000011233,  2.04816282167,    32370.97899156560}, 
    {     0.00000013387,  4.51756775840,    26080.78959457339}, 
    {     0.00000011632,  2.38496112750,    79219.30916633119}, 
    {     0.00000012412,  2.22281109320,    77837.11123384659}, 
    {     0.00000009950,  2.04595599803,    48733.23133818299}, 
    {     0.00000009803,  2.26703539620,    26091.78447693220}, 
    {     0.00000009361,  5.44289482405,    38654.05484155699}, 
    {     0.00000009746,  3.83975715814,    26084.02180621620}, 
    {     0.00000009264,  4.02987321949,      467.96499035440}, 
    {     0.00000008961,  0.11065043662,    62389.09182935939}, 
    {     0.00000011544,  4.17786977391,   103242.23401420339}, 
    {     0.00000011146,  3.78295646170,    26301.20223701220}, 
    {     0.00000009677,  2.98528938781,    59414.48187474840}, 
    {     0.00000008977,  3.47890335185,    91785.46086631398}, 
    {     0.00000009664,  5.77943268592,    25938.33994443960}, 
    {     0.00000008855,  2.84674490228,    25035.63475838580}, 
    {     0.00000008180,  5.77857984038,    40853.14218484400}, 
    {     0.00000008033,  2.45698456693,   129380.13377768178}, 
    {     0.00000008343,  5.34502885776,    19317.19254032860}, 
    {     0.00000007425,  4.71160285382,        6.62855890001}, 
    {     0.00000009001,  6.23397065428,    25021.40766438420}, 
    {     0.00000008126,  1.12294678263,    26095.01668857500}, 
    {     0.00000006568,  3.66246087364,    26514.50133245020}, 
    {     0.00000007038,  3.99042086727,    71980.63357473118}, 
    {     0.00000006956,  1.62821293256,    23869.14603738740}, 
    {     0.00000007595,  0.18335017533,    12432.04265039780}, 
    {     0.00000006061,  3.67045619806,    27676.97603685800}, 
    {     0.00000005896,  5.57171840811,    94138.32702008578}, 
    {     0.00000005716,  5.18202059613,    78793.40038981718}, 
    {     0.00000005854,  2.14305101727,    20760.42703319140}, 
    {     0.00000005680,  1.60728089799,    98690.28051714458}, 
    {     0.00000005789,  2.35464263941,   103821.92160120218}, 
    {     0.00000005124,  3.77854984569,    58946.51688439399}, 
    {     0.00000005869,  5.76284651190,   286966.93455731616}, 
    {     0.00000005858,  6.12539769557,    26011.63707029860}, 
    {     0.00000005216,  3.29188857438,    38519.94579197200}, 
    {     0.00000006000,  0.00056823654,    51535.90899683439}, 
    {     0.00000004647,  0.29029324438,   136100.84775702319}, 
    {     0.00000005787,  4.44778418175,    19406.67828817460}, 
    {     0.00000005908,  4.12201530508,    29530.47808653960}, 
    {     0.00000005917,  3.98935947283,   131548.89425996438}, 
    {     0.00000005729,  3.02328937218,    89586.37352302698}, 
    {     0.00000003928,  4.81446546705,   125887.56221081219}, 
    {     0.00000003930,  2.48445582384,    69159.80243060499}, 
    {     0.00000003681,  2.80184812919,    79323.09135491178}, 
    {     0.00000004497,  1.50332900944,    51962.50718771040}, 
    {     0.00000003687,  5.33731853178,   102762.53967101299}, 
    {     0.00000003495,  1.85405073784,    52156.13652224860}, 
    {     0.00000003868,  1.25354721052,    54394.56338733519}, 
    {     0.00000004459,  4.88906500860,    50057.04242277000}, 
    {     0.00000003397,  3.73895635453,    82815.66292178139}, 
    {     0.00000003524,  6.07665334083,    25934.12433108940}, 
    {     0.00000003492,  1.28212999580,    52168.69273614759}, 
    {     0.00000003410,  6.13975533859,      639.89728631400}, 
    {     0.00000004396,  3.25474698374,    77308.10968311399}, 
    {     0.00000002990,  5.27320912825,    46848.33017476560}, 
    {     0.00000003218,  5.20951952570,   103925.01437542078}, 
    {     0.00000002899,  5.08446931064,    58458.88213313979}, 
    {     0.00000003708,  0.02716119180,    26241.68195205900}, 
    {     0.00000002991,  2.92282776454,    44937.13069154840}, 
    {     0.00000003177,  0.05757316718,    22747.29071487440}, 
    {     0.00000003163,  5.38719447649,   105307.21230790539}, 
    {     0.00000003556,  3.96232550668,    52195.47604404819}, 
    {     0.00000002786,  0.54711208086,    52389.10537858640}, 
    {     0.00000002458,  1.14914981714,     2333.19639287200}, 
    {     0.00000002492,  5.24929906471,    25668.41849769900}, 
    {     0.00000002408,  2.14206640426,    64741.95798313119}, 
    {     0.00000002512,  0.61953030750,    85034.42002596818}, 
    {     0.00000002416,  5.26205009423,    52179.68761850640}, 
    {     0.00000002296,  3.09905229352,    88476.99497093359}, 
    {     0.00000002357,  0.17755751938,   117873.36400788819}, 
    {     0.00000003012,  0.83692018918,   129330.13715577759}, 
    {     0.00000002421,  3.95905297486,       49.99662190420}, 
    {     0.00000002198,  2.56141354099,     3340.61242669980}, 
    {     0.00000002402,  0.55122303655,    52171.92494779040}, 
    {     0.00000002106,  5.41293286528,   155468.03691925599}, 
    {     0.00000002566,  3.00613732096,    51109.31080595839}, 
    {     0.00000002392,  0.17900577928,      103.09277421860}, 
    {     0.00000002737,  1.08182962639,      632.78373931320}, 
    {     0.00000002523,  5.90364727370,    51123.53789995999}, 
    {     0.00000002098,  2.47134468716,    66941.04532641819}, 
    {     0.00000002003,  3.75400419522,    16066.06586147480}, 
    {     0.00000002187,  1.18677902826,     2118.76386037840}, 
    {     0.00000002592,  2.55125611209,    25654.19140369739}, 
    {     0.00000002558,  1.18092756650,    45494.58142974879}, 
    {     0.00000001918,  0.79900663165,    26555.86813192860}, 
    {     0.00000001819,  0.69190176381,    98068.53671630539}, 
    {     0.00000002470,  2.55063539113,    52026.24308601380}, 
    {     0.00000001703,  0.36707055030,    52602.40447402440}, 
    {     0.00000002128,  2.66244619788,    18093.37469954999}, 
    {     0.00000001715,  4.62167075193,    49957.04917896160}, 
    {     0.00000001916,  5.83738859952,    85502.38501632259}, 
    {     0.00000001975,  3.57371472249,    24395.73747207180}, 
    {     0.00000001589,  1.33529471080,      114.43928868521}, 
    {     0.00000001580,  0.36965179736,    53764.87917843220}, 
    {     0.00000002040,  2.05393633143,    45405.09568190280}, 
    {     0.00000001538,  2.25451813652,   120226.23016165999}, 
    {     0.00000001525,  1.48227419795,    26094.53170047421}, 
    {     0.00000002055,  4.16318224321,    52182.91983014920}, 
    {     0.00000001829,  0.38851668054,      522.57741809380}, 
    {     0.00000002105,  4.04134275183,    25234.70675982219}, 
    {     0.00000001480,  1.87649882402,   104881.30353139139}, 
    {     0.00000001460,  1.01787199022,    25455.11940226100}, 
    {     0.00000001452,  0.34126077893,     1052.26838318840}, 
    {     0.00000001449,  3.39746980273,    24505.94379329119}, 
    {     0.00000001480,  4.55091353969,   124778.18365871879}, 
    {     0.00000001481,  3.62243153520,      149.56319713460}, 
    {     0.00000001515,  5.32310335641,   129909.82474277639}, 
    {     0.00000001594,  3.00904352013,    77623.81213840858}, 
    {     0.00000001927,  3.90375426022,       74.78159856730}, 
    {     0.00000001374,  4.32416902448,    80482.46652890938}, 
    {     0.00000001420,  3.90107663911,     7880.08915333899}, 
    {     0.00000001525,  4.62447824359,    26081.27458267419}, 
    {     0.00000001567,  0.65986586630,   157636.79740153858}, 
    {     0.00000001725,  4.40110982693,      316.39186965660}, 
    {     0.00000001263,  4.96345861180,    74821.13447975718}, 
    {     0.00000001472,  5.56023083923,    95247.70557217918}, 
    {     0.00000001315,  1.83261160452,    76144.94556434419}, 
    {     0.00000001439,  0.83307888017,    55618.38122811380}, 
    {     0.00000001355,  3.15836403543,     1066.49547719000}, 
    {     0.00000001223,  3.24039981367,   162188.75089859738}, 
    {     0.00000001390,  5.13722781530,      419.48464387520}, 
    {     0.00000001309,  5.28240557347,    25619.93815121980}, 
    {     0.00000001477,  2.40286418702,   313054.83769889036}, 
    {     0.00000001252,  5.65232980046,    26013.12154300690}, 
    {     0.00000001143,  0.38696459711,    42153.96900304900}, 
    {     0.00000001082,  2.56546867715,    26190.99591579279}, 
    {     0.00000001493,  2.89979127265,    52099.54021187280}, 
    {     0.00000001468,  5.71541196756,    24491.71669928959}, 
    {     0.00000001034,  1.49588002262,   151975.46535238638}, 
    {     0.00000001315,  5.91525944336,   115674.27666460119}, 
    {     0.00000001065,  3.61056177659,      206.18554843720}, 
    {     0.00000001053,  5.18007204084,    23754.70674870219}, 
    {     0.00000000963,  2.05291382470,   128850.44281258718}, 
    {     0.00000001031,  3.39058255009,    25551.09862947879}, 
    {     0.00000001065,  3.38232835239,    25863.55834587229}, 
    {     0.00000001153,  5.76502004439,    44181.27784112419}, 
    {     0.00000000960,  5.74762439771,   105410.99449648599}, 
    {     0.00000001137,  6.20916641857,   103396.01282468818}, 
    {     0.00000000914,  4.28846119946,    78256.59587772179}, 
    {     0.00000000918,  3.27512590931,       76.26607127560}, 
    {     0.00000000892,  4.82401266810,    78244.03966382280}, 
    {     0.00000000977,  4.86447903869,    25131.61398560359}, 
    {     0.00000001086,  0.73421207473,    33967.99229491319}, 
    {     0.00000001162,  4.52149319583,    78050.41032928458}, 
    {     0.00000000868,  2.78832869275,    52022.02747266360}, 
    {     0.00000000944,  4.09732379319,    26720.68688088739}, 
    {     0.00000000973,  4.54021116854,    24925.42843716640}, 
    {     0.00000000845,  5.05428850137,    25977.69682035479}, 
    {     0.00000000841,  1.89439003615,   130012.91751699499}, 
    {     0.00000000920,  3.02491491588,    52329.58509363319}, 
    {     0.00000000813,  3.15301734719,    48835.19385644859}, 
    {     0.00000000877,  0.41324612537,   108903.56606335558}, 
    {     0.00000000819,  1.61521143447,    40565.25432477420}, 
    {     0.00000001075,  1.37287014880,    23439.44831610119}, 
    {     0.00000000812,  2.82158357641,    25984.81036735560}, 
    {     0.00000000775,  2.86885996155,    26727.80042788820}, 
    {     0.00000000755,  5.44067758231,    24609.03656750980}, 
    {     0.00000000919,  4.72527676083,    14477.35118320000}, 
    {     0.00000000914,  4.70822051956,     6681.22485339960}, 
    {     0.00000000749,  1.80266552461,    84546.78527471398}, 
    {     0.00000000906,  0.64975766863,    78283.37918562238}, 
    {     0.00000000855,  5.05062817348,      307.55762096960}, 
    {     0.00000000766,  5.89903011866,    71025.03383312259}, 
    {     0.00000000713,  3.55177815121,    78477.00852016058}, 
    {     0.00000000719,  1.85087720309,   100909.03762133139}, 
    {     0.00000000858,  5.43952313313,      536.80451209540}, 
    {     0.00000000794,  3.77060303998,   155418.04029735178}, 
    {     0.00000000848,  2.08846185252,   131395.11544947959}, 
    {     0.00000000623,  3.14632637321,   143961.26714946238}, 
    {     0.00000000623,  5.10465766894,    90829.86112470538}, 
    {     0.00000000621,  4.59014649415,     9103.90699411760}, 
    {     0.00000000706,  4.19528422791,    71582.48457132299}, 
    {     0.00000000739,  0.15975550376,    24712.12934172840}, 
    {     0.00000000714,  1.88028345040,     2199.08734328700}, 
    {     0.00000000677,  6.01432060800,    77197.21394753258}, 
    {     0.00000000620,  1.32853841881,     3328.13565628019}, 
    {     0.00000000650,  5.51234531031,    29428.51556827400}, 
    {     0.00000000657,  2.03363099847,    51756.32163927320}, 
    {     0.00000000594,  6.06826637505,   114564.89811250778}, 
    {     0.00000000666,  0.70705130538,    26162.68474014150}, 
    {     0.00000000598,  5.15770220681,      333.85594076940}, 
    {     0.00000000616,  1.94904709349,    78267.59076008058}, 
    {     0.00000000774,  2.84218106686,    13655.86049117640}, 
    {     0.00000000697,  5.60799904851,    51742.09454527159}, 
    {     0.00000000556,  2.07542224847,   181555.94006083018}, 
    {     0.00000000548,  3.17702541600,    90695.75207512038}, 
    {     0.00000000541,  4.20819062980,    28421.09953444620}, 
    {     0.00000000638,  5.55947577602,    78114.14622758799}, 
    {     0.00000000529,  3.60221910186,     1911.19948321720}, 
    {     0.00000000619,  4.87812731811,    25771.51127191760}, 
    {     0.00000000570,  3.56318859887,   111122.32316754239}, 
    {     0.00000000510,  4.20288540310,    28206.66700195260}, 
    {     0.00000000539,  5.42636252112,    93028.94846799239}, 
    {     0.00000000658,  3.45393169676,    26610.48055966799}, 
    {     0.00000000613,  3.52134452894,    78259.82808936459}, 
    {     0.00000000577,  0.81666137084,    51322.60990139639}, 
    {     0.00000000594,  1.16298541260,    26404.29501123080}, 
    {     0.00000000497,  5.37653944274,    26037.90651966999}, 
    {     0.00000000663,  2.63276230593,    77211.44104153418}, 
    {     0.00000000486,  1.96691155158,    26507.38778544939}, 
    {     0.00000000474,  3.65214522517,   124156.43985787958}, 
    {     0.00000000550,  5.81053917486,     1731.12235293260}, 
    {     0.00000000472,  3.79306901191,    52643.77127350280}, 
    {     0.00000000467,  4.50162371638,      110.20632121940}, 
    {     0.00000000592,  3.04748129459,    12725.45343477500}, 
    {     0.00000000551,  0.68606702543,    26137.89976347840}, 
    {     0.00000000600,  0.33955465102,    50483.64061364600}, 
    {     0.00000000525,  0.87914542260,    78270.82297172339}, 
    {     0.00000000443,  3.33347421396,    78690.30761559859}, 
    {     0.00000000439,  1.30939082033,    76044.95232053580}, 
    {     0.00000000588,  2.37059415297,   121335.60871375339}, 
    {     0.00000000426,  0.14790973129,    50593.84693486539}, 
    {     0.00000000413,  3.33312213477,    79852.78232000639}, 
    {     0.00000000403,  5.20675969218,   146314.13330323418}, 
    {     0.00000000524,  5.02826409094,    71492.99882347698}, 
    {     0.00000000417,  5.99136591640,   103711.71527998279}, 
    {     0.00000000389,  4.44187693350,    29416.03879785439}, 
    {     0.00000000389,  4.02257298908,    51543.02254383520}, 
    {     0.00000000442,  2.37195011319,   111590.28815789679}, 
    {     0.00000000375,  4.47560820150,    52182.43484204840}, 
    {     0.00000000387,  4.83554303442,   130969.20667296558}, 
    {     0.00000000389,  1.20251530573,   150866.08680029298}, 
    {     0.00000000407,  0.52988897291,      433.71173787680}, 
    {     0.00000000416,  3.60366729170,   183724.70054311278}, 
    {     0.00000000439,  2.45449965869,    50579.61984086379}, 
    {     0.00000000412,  0.50038241185,    27999.10262479140}, 
    {     0.00000000392,  0.68295335891,      134.10904958500}, 
    {     0.00000000399,  1.99463585522,   155997.72788435058}, 
    {     0.00000000422,  5.83266410745,    38813.35657634920}, 
    {     0.00000000346,  3.40284434869,    27140.17152476259}, 
    {     0.00000000368,  3.80729957662,    81706.28436968799}, 
    {     0.00000000342,  0.83873809330,    25764.39772491679}, 
    {     0.00000000358,  1.99506378254,     1089.70879119360}, 
    {     0.00000000463,  3.33594289344,    25440.89230825939}, 
    {     0.00000000331,  0.37072554435,    26237.46633870879}, 
    {     0.00000000330,  6.19220570613,   188276.65404017158}, 
    {     0.00000000408,  2.17144409714,      641.41356173899}, 
    {     0.00000000321,  5.02563588253,   102232.84870591838}, 
    {     0.00000000330,  5.51852292754,    10021.83728009940}, 
    {     0.00000000334,  2.49304639997,    25344.91308104160}, 
    {     0.00000000381,  5.90959254017,    78187.44335344699}, 
    {     0.00000000316,  2.42543561835,    52101.02468458109}, 
    {     0.00000000331,  4.38957047363,    26202.34243025941}, 
    {     0.00000000401,  1.99445200318,    49842.60989027639}, 
    {     0.00000000422,  0.46556007098,        1.48447270830}, 
    {     0.00000000310,  6.18778948056,    27154.39861876420}, 
    {     0.00000000302,  4.68609762435,    25565.32572348040}, 
    {     0.00000000297,  1.70847616577,    25973.46385288896}, 
    {     0.00000000375,  5.32471088557,   339142.74084046457}, 
    {     0.00000000328,  5.32599595480,      853.19638175200}, 
    {     0.00000000299,  5.81110649116,     1692.16566950240}, 
    {     0.00000000378,  1.33738289334,    52169.17772424839}, 
    {     0.00000000289,  6.20208961953,    25881.71759313700}, 
    {     0.00000000277,  4.45045644666,   178063.36849396059}, 
    {     0.00000000291,  4.44971680232,      579.68758699880}, 
    {     0.00000000316,  1.96022181583,    51707.84129279399}, 
    {     0.00000000337,  4.21436282894,    34282.17847478280}, 
    {     0.00000000334,  3.00242982742,    23866.04650697719}, 
    {     0.00000000268,  1.34364307187,    35191.81013569180}, 
    {     0.00000000308,  5.94802883612,    64607.84893354619}, 
    {     0.00000000283,  0.96217168652,     1639.06951718800}, 
    {     0.00000000287,  1.28056998141,    51013.33157874059}, 
    {     0.00000000270,  0.55824473532,     3462.24470586520}, 
    {     0.00000000274,  5.60833767567,    52278.89905736699}, 
    {     0.00000000352,  0.49345825951,    26294.08869001139}, 
    {     0.00000000358,  1.23398111485,     1223.81784077861}, 
    {     0.00000000344,  4.29281175054,    49527.35145767539}, 
    {     0.00000000255,  5.03014367020,   154938.34595416138}, 
    {     0.00000000297,  2.87098037822,   129483.91596626239}, 
    {     0.00000000253,  0.09066729355,    13541.42120249119}, 
    {     0.00000000301,  1.22703459160,   104138.31347085879}, 
    {     0.00000000274,  3.67743328955,    68241.87214462319}, 
    {     0.00000000321,  2.49935317919,   141762.17980617538}, 
    {     0.00000000290,  1.02140013440,     8194.27533320860}, 
    {     0.00000000239,  0.99187379290,   104344.49901929598}, 
    {     0.00000000277,  0.53135196296,      949.17560896980}, 
    {     0.00000000248,  2.39745008860,   131498.89763806018}, 
    {     0.00000000274,  2.09609851306,    26624.70765366959}, 
    {     0.00000000240,  0.85016661328,    52808.59002246159}, 
    {     0.00000000266,  0.18316540889,     2168.76048228260}, 
    {     0.00000000237,  3.15135087265,    23976.25282819660}, 
    {     0.00000000229,  2.19886640826,    50696.93970908399}, 
    {     0.00000000225,  4.85647140456,   156100.82065856918}, 
    {     0.00000000231,  1.49530886624,   104331.94280539699}, 
    {     0.00000000282,  1.63421453401,    51219.51712717779}, 
    {     0.00000000245,  4.68702231602,     5327.47610838280}, 
    {     0.00000000220,  5.75804546531,    78109.93061423779}, 
    {     0.00000000218,  5.42845467468,    18207.81398823521}, 
    {     0.00000000227,  6.02399891588,     1581.95934828300}, 
    {     0.00000000232,  5.99760045579,    78417.48823520739}, 
    {     0.00000000220,  3.72002247582,     7994.52844202420}, 
    {     0.00000000271,  0.20761446669,    51639.00177105299}, 
    {     0.00000000243,  2.33618213590,    25138.72753260440}, 
    {     0.00000000253,  5.46291034047,      621.74380083920}, 
    {     0.00000000280,  0.15532838705,    51951.46148744649}, 
    {     0.00000000209,  0.01830817650,    26164.16921284980}, 
    {     0.00000000208,  6.17986143435,    74923.09699802278}, 
    {     0.00000000206,  1.61576904815,    25241.82030682300}, 
    {     0.00000000236,  4.28926910244,    24079.34560241519}, 
    {     0.00000000211,  1.95574736110,      735.87651353180}, 
    {     0.00000000206,  5.86779636866,    52072.71350892979}, 
    {     0.00000000235,  3.60456469848,   104371.28232719658}, 
    {     0.00000000228,  3.66072813155,     1596.18644228460}, 
    {     0.00000000198,  5.85490519500,    52815.70356946240}, 
    {     0.00000000198,  1.02967825338,    25867.49049913539}, 
    {     0.00000000219,  1.39355980522,    32769.12799497380}, 
    {     0.00000000229,  3.36247801855,   134991.46920492979}, 
    {     0.00000000197,  4.77851384259,   110634.68841628819}, 
    {     0.00000000213,  0.77959231227,      917.93028598180}, 
    {     0.00000000190,  4.24426555817,       14.22709400160}, 
    {     0.00000000209,  5.44598697132,   147423.51185532758}, 
    {     0.00000000229,  0.76395418391,      220.41264243880}, 
    {     0.00000000185,  0.24825412134,   104564.91166173479}, 
    {     0.00000000189,  3.32749048432,       30.32686100440}, 
    {     0.00000000182,  2.31699263584,     9384.84100807520}, 
    {     0.00000000209,  1.81798829614,    52065.59996192899}, 
    {     0.00000000191,  0.91256199920,    97670.38771289718}, 
    {     0.00000000209,  0.41166983619,   181505.94343892598}, 
    {     0.00000000195,  1.96978627522,      314.18617986960}, 
    {     0.00000000185,  2.71647255738,   103285.11708910679}, 
    {     0.00000000188,  4.30567171912,     1884.90116341740}, 
    {     0.00000000225,  5.05990359517,   157483.01859105378}, 
    {     0.00000000194,  0.98119689475,    26049.77010593640}, 
    {     0.00000000193,  4.82115364463,   126996.94076290558}, 
    {     0.00000000185,  0.67159839253,   106570.36967048359}, 
    {     0.00000000167,  5.70903987089,    96357.08412427259}, 
    {     0.00000000200,  2.57264462597,    97112.93697469679}, 
    {     0.00000000184,  2.33825467783,    77829.99768684579}, 
    {     0.00000000176,  3.20477474376,    39629.32434406539}, 
    {     0.00000000169,  2.30516506046,      101.96251826560}, 
    {     0.00000000224,  3.20562091672,    50800.03248330259}, 
    {     0.00000000195,  5.18234930994,    99024.13645791399}, 
    {     0.00000000163,  6.10607233599,   170049.17029103659}, 
    {     0.00000000176,  4.28787695022,    25780.34552060460}, 
    {     0.00000000165,  6.00499743312,      224.34479570190}, 
    {     0.00000000160,  1.94771721315,    26421.75908234360}, 
    {     0.00000000167,  3.75605549998,    52250.58788171570}, 
    {     0.00000000164,  1.77310680762,   116917.76426627958}, 
    {     0.00000000216,  2.59043583275,    27819.02549450680}, 
    {     0.00000000154,  1.63000015144,    24815.22211594700}, 
    {     0.00000000155,  4.49642342619,      956.28915597060}, 
    {     0.00000000165,  3.81500359793,    77410.51304297059}, 
    {     0.00000000153,  3.95671977623,    24601.92302050899}, 
    {     0.00000000151,  5.03883003223,   207643.84320240439}, 
    {     0.00000000158,  4.95378278448,    35472.74414964940}, 
    {     0.00000000180,  5.62656169139,   103299.34418310839}, 
    {     0.00000000165,  2.25891713026,   104202.04936916218}, 
    {     0.00000000166,  1.72114015725,     2648.45482547300}, 
    {     0.00000000173,  2.62016482892,    26086.41866886590}, 
    {     0.00000000156,  1.62948955004,    51859.41441349179}, 
    {     0.00000000145,  2.63569129484,    24292.64469785319}, 
    {     0.00000000166,  0.21317040603,    52698.38370124219}, 
    {     0.00000000155,  1.79976780999,        3.93215326310}, 
    {     0.00000000151,  2.74555154751,   140652.80125408198}, 
    {     0.00000000170,  0.79077348232,    72936.23331633979}, 
    {     0.00000000177,  5.06186919984,    77844.22478084739}, 
    {     0.00000000150,  4.93080506410,    28286.99048486120}, 
    {     0.00000000175,  5.79341041658,    39743.76363275060}, 
    {     0.00000000163,  3.37027230636,    76571.54375522019}, 
    {     0.00000000186,  1.81335534539,    26395.46076254379}, 
    {     0.00000000159,  4.90444632725,   104355.49390165479}, 
    {     0.00000000149,  4.20183170995,    52492.19815280499}, 
    {     0.00000000146,  1.31209567772,    26198.10946279360}, 
    {     0.00000000163,  2.25608093049,    55516.41870984820}, 
    {     0.00000000131,  0.90558224757,    54294.57014352679}, 
    {     0.00000000142,  1.71011577241,    92741.06060792258}, 
    {     0.00000000138,  0.64118842478,    86143.79857806159}, 
    {     0.00000000165,  4.72014033895,     4083.98850670440}, 
    {     0.00000000132,  0.92042529620,    54509.00267602040}, 
    {     0.00000000125,  0.31897986681,   150244.34299945379}, 
    {     0.00000000144,  1.05243628393,     1083.08023229360}, 
    {     0.00000000144,  4.17447706870,    24822.33566294780}, 
    {     0.00000000151,  0.38915510192,      487.63475125420}, 
    {     0.00000000134,  3.86340442367,   104358.72611329758}, 
    {     0.00000000123,  2.08423913645,    52125.80966124419}, 
    {     0.00000000122,  5.01127438966,    52595.29092702359}, 
    {     0.00000000140,  2.08502567831,   119116.85160956658}, 
    {     0.00000000158,  5.19357058726,    23962.02573419499}, 
    {     0.00000000134,  6.25970085732,      636.99627202420}, 
    {     0.00000000135,  0.57090512541,    25936.85547173129}, 
    {     0.00000000118,  3.30558637192,     1263.15736257819}, 
    {     0.00000000127,  0.19814904969,       38.13303563780}, 
    {     0.00000000164,  3.27172225246,    26089.38761428249}, 
    {     0.00000000131,  3.65063342527,    29550.14784743939}, 
    {     0.00000000139,  4.69100415119,     2014.98167179780}, 
    {     0.00000000116,  2.69254429880,   129799.61842155698}, 
    {     0.00000000159,  0.19389508543,   104347.73123093879}, 
    {     0.00000000119,  0.49364918929,    78731.67441507700}, 
    {     0.00000000122,  5.26003763179,    26729.31670331319}, 
    {     0.00000000115,  1.35337166628,    75615.25459924959}, 
    {     0.00000000112,  4.26094907654,   102132.85546210999}, 
    {     0.00000000119,  5.54566614405,    76667.52298243798}, 
    {     0.00000000135,  1.69822927449,    97580.90196505119}, 
    {     0.00000000120,  3.20629586215,    76681.75007643958}, 
    {     0.00000000113,  6.26294483694,   104778.21075717278}, 
    {     0.00000000127,  0.11236915083,    51528.79544983359}, 
    {     0.00000000145,  3.61600835664,    52225.80290505260}, 
    {     0.00000000108,  5.72635533853,    24176.70365835700}, 
    {     0.00000000132,  1.56301672659,    25939.82441714789}, 
    {     0.00000000124,  4.17936911601,    25754.04720080480}, 
    {     0.00000000117,  1.71758893092,    22759.76748529401}, 
    {     0.00000000111,  3.52660271138,    24356.78078864160}, 
    {     0.00000000112,  0.28845559419,   209812.60368468695}, 
    {     0.00000000106,  6.26831675546,   105940.68546158058}, 
    {     0.00000000104,  1.87785131678,   172402.03644480839}, 
    {     0.00000000108,  2.96242441236,     1375.77379984580}, 
    {     0.00000000101,  3.85084997066,     1478.86657406440}, 
    {     0.00000000114,  5.20579936690,   137678.19129947099}, 
    {     0.00000000100,  1.55712053447,    25973.50403466079}, 
    {     0.00000000115,  5.15253758124,     1135.67687189320}, 
    {     0.00000000101,  0.73572502180,    77630.92568540938}, 
    {     0.00000000101,  0.25974575144,      160.40736938481}, 
    {     0.00000000106,  0.03739242592,      180.07713028460}, 
    {     0.00000000105,  0.00912179296,    13362.44970679920}, 
    {     0.00000000096,  1.18770041705,    78270.33798362259}, 
    {     0.00000000125,  4.60962604344,    11610.55195837420}, 
    {     0.00000000096,  0.48777092970,   107794.18751126219}, 
    {     0.00000000101,  4.13659062020,   176953.98994186718}, 
    {     0.00000000099,  1.50710271888,   157057.10981453978}, 
    {     0.00000000094,  3.53697478079,    26521.61487945100}, 
    {     0.00000000106,  4.57421536992,    26073.67604757259}, 
    {     0.00000000091,  3.12915113312,    64901.25971792339}, 
    {     0.00000000106,  4.04251666854,    27726.97265876220}, 
    {     0.00000000091,  3.88291208024,    51852.30086649099}, 
    {     0.00000000087,  5.20300185641,     1485.29070670320}, 
    {     0.00000000115,  5.97185006663,    24182.43837663380}, 
    {     0.00000000099,  2.12029899747,    66653.15746634839}, 
    {     0.00000000094,  2.62091616233,   104275.34649502118}, 
    {     0.00000000112,  6.04706301250,    49953.94964855139}, 
    {     0.00000000106,  2.06630121790,   125112.03959948818}, 
    {     0.00000000083,  3.35095689116,    52325.36948028299}, 
    {     0.00000000083,  2.82819081777,   214364.55718174578}, 
    {     0.00000000082,  4.04236392434,   132658.27281205778}, 
    {     0.00000000102,  4.95574370006,   182085.63102592478}, 
    {     0.00000000081,  5.45741776539,    78188.92782615528}, 
    {     0.00000000096,  5.55885300690,    51432.81622261579}, 
    {     0.00000000090,  1.00092960433,     9745.32055585660}, 
    {     0.00000000084,  0.11009911861,    53228.07466633679}, 
    {     0.00000000080,  6.13435930809,   137210.22630911658}, 
    {     0.00000000080,  2.72523265777,    25042.74830538660}, 
    {     0.00000000081,  1.88879072729,   128320.75184749259}, 
    {     0.00000000091,  4.44731219389,    26091.83529483729}, 
    {     0.00000000078,  4.29086934596,    77101.23472031478}, 
    {     0.00000000079,  1.07554886014,    50167.24874398939}, 
    {     0.00000000083,  0.96682340020,    25788.77674730500}, 
    {     0.00000000077,  3.73919172780,    26222.01219115920}, 
    {     0.00000000075,  2.88523920506,    53242.30176033840}, 
    {     0.00000000075,  1.15216528271,   204151.27163553478}, 
    {     0.00000000104,  4.31779632686,    23888.81579828719}, 
    {     0.00000000075,  2.56714081506,    19202.75325164339}, 
    {     0.00000000094,  4.32366559460,    78257.08086582259}, 
    {     0.00000000088,  3.55952578858,    52381.99183158559}, 
    {     0.00000000088,  3.52519120352,    60055.89543648739}, 
    {     0.00000000071,  4.96476508038,    26823.77965510599}, 
    {     0.00000000077,  5.82847259563,   155571.81910783658}, 
    {     0.00000000099,  3.23844307345,    28256.66362385679}, 
    {     0.00000000070,  4.31065427591,    86457.98475793119}, 
    {     0.00000000076,  2.22271998217,    36109.74042167360}, 
    {     0.00000000076,  1.00884250882,    25352.02662804239}, 
    {     0.00000000095,  5.99918199930,    19958.60610206760}, 
    {     0.00000000080,  1.13460275260,    52290.24557183361}, 
    {     0.00000000087,  1.31383914626,    26667.59072857300}, 
    {     0.00000000073,  2.05114043397,    26941.09952332620}, 
    {     0.00000000075,  1.56761266225,    51653.22886505459}, 
    {     0.00000000074,  4.24204028736,   130226.21661243298}, 
    {     0.00000000071,  4.73961301470,    52061.36699446317}, 
    {     0.00000000095,  1.93406737148,   365230.64398203876}, 
    {     0.00000000073,  2.96407551460,    25024.58905812189}, 
    {     0.00000000070,  2.23536123203,   173511.41499690177}, 
    {     0.00000000069,  2.26111089193,      159.30173479220}, 
    {     0.00000000076,  5.58932777184,    13675.53025207620}, 
    {     0.00000000066,  2.59450231797,    27780.06881107659}, 
    {     0.00000000066,  1.14753207913,    55503.94193942859}, 
    {     0.00000000075,  4.29563438170,    27311.72098235281}, 
    {     0.00000000066,  2.92871283816,    23919.14265929160}, 
    {     0.00000000081,  5.35656494266,   167850.08294774959}, 
    {     0.00000000065,  1.76581252465,   181026.24909573558}, 
    {     0.00000000064,  0.55885405924,    34082.43158359840}, 
    {     0.00000000068,  5.13310648307,    52712.61079524379}, 
    {     0.00000000063,  3.98734650866,   130432.40216087017}, 
    {     0.00000000073,  5.05540467899,    27177.61193276780}, 
    {     0.00000000081,  0.87794410758,    25446.48957983520}, 
    {     0.00000000072,  2.75418245422,       11.04570026390}, 
    {     0.00000000071,  6.19433993178,    50064.15596977079}, 
    {     0.00000000078,  4.91889852543,    77795.74443436819}, 
    {     0.00000000062,  3.90028384133,    27005.83342755599}, 
    {     0.00000000085,  3.57336994355,    27037.07875054399}, 
    {     0.00000000063,  5.38131021751,    51226.63067417859}, 
    {     0.00000000060,  3.86941305331,    78896.49316403578}, 
    {     0.00000000084,  3.73808276953,    26308.31578401300}, 
    {     0.00000000067,  2.33716983257,    78366.80219894118}, 
    {     0.00000000060,  2.70936065867,   104505.39137678158}, 
    {     0.00000000058,  4.70485127291,      103.78218858060}, 
    {     0.00000000058,  4.90593616982,    25508.21555457540}, 
    {     0.00000000063,  5.19084024444,    76784.84285065818}, 
    {     0.00000000072,  3.44175435793,    54087.00576636560}, 
    {     0.00000000066,  2.97381764080,    51969.62073471119}, 
    {     0.00000000058,  1.54682427778,   182188.72380014337}, 
    {     0.00000000057,  2.46940249341,   104197.83375581198}, 
    {     0.00000000065,  5.33114478447,   157586.80077963437}, 
    {     0.00000000066,  6.05053372563,      647.01083331480}, 
    {     0.00000000065,  4.63705403958,    61279.71327726600}, 
    {     0.00000000060,  4.42236493104,   130419.84594697120}, 
    {     0.00000000056,  4.63022377760,    51329.72344839720}, 
    {     0.00000000060,  1.90391714646,   102018.41617342478}, 
    {     0.00000000056,  2.17285982642,      323.50541665740}, 
    {     0.00000000061,  0.24700789346,   130459.18546877075}, 
    {     0.00000000054,  1.65192940412,    31415.37924995700}, 
    {     0.00000000069,  4.68284550055,    77307.42026875199}, 
    {     0.00000000056,  4.05991604789,    32132.13172294960}, 
    {     0.00000000054,  2.49487716279,    22625.65843570900}, 
    {     0.00000000059,  1.82755627609,   183570.92173262799}, 
    {     0.00000000066,  3.17086218594,    78039.36462902068}, 
    {     0.00000000052,  2.12945044983,    44295.71712980940}, 
    {     0.00000000072,  6.17318529798,    25032.45336464809}, 
    {     0.00000000054,  2.05026185233,    17893.62780836560}, 
    {     0.00000000051,  2.50572759919,    78903.60671103658}, 
    {     0.00000000053,  0.21211371229,     2221.85663459700}, 
    {     0.00000000061,  1.22064448269,    26083.97098831109}, 
    {     0.00000000064,  2.36532888601,    25953.79409198919}, 
    {     0.00000000052,  3.92321101844,   123758.29085447139}, 
    {     0.00000000051,  4.74694757019,     5193.36705879780}, 
    {     0.00000000051,  2.91556516001,   101011.00013959699}, 
    {     0.00000000050,  2.62878188924,    78160.61665050399}, 
    {     0.00000000060,  6.20060892122,    76887.93562487679}, 
    {     0.00000000066,  3.23190763248,    77726.90491262719}, 
    {     0.00000000069,  0.82568775458,    22909.75735100660}, 
    {     0.00000000059,  1.52387880104,     6044.22858137540}, 
    {     0.00000000051,  1.99922535685,    24448.83362438620}, 
    {     0.00000000049,  2.99170950627,    52252.07235442399}, 
    {     0.00000000051,  0.76458856785,     2703.61615467560}, 
    {     0.00000000049,  3.19808614252,   130652.81480330898}, 
    {     0.00000000067,  0.59116991791,    94329.77528619739}, 
    {     0.00000000048,  4.05385765670,    51955.39364070959}, 
    {     0.00000000054,  1.48701637895,   136722.59155786238}, 
    {     0.00000000057,  1.10836716608,    26102.13023557580}, 
    {     0.00000000050,  5.32021242336,   103917.90082841998}, 
    {     0.00000000056,  1.63440457571,       61.72597474020}, 
    {     0.00000000057,  1.08524195162,    27972.80430499159}, 
    {     0.00000000051,  4.31886984362,    58857.03113654799}, 
    {     0.00000000061,  0.04364409986,   161079.37234650398}, 
    {     0.00000000046,  2.24836751862,      425.90877651400}, 
    {     0.00000000049,  5.71448553374,    50380.54783942739}, 
    {     0.00000000048,  0.40868412712,    27684.08958385880}, 
    {     0.00000000064,  5.06730157028,       73.29712585900}, 
    {     0.00000000053,  3.29314433670,   207593.84658050018}, 
    {     0.00000000052,  4.05836292463,    26010.15259759030}, 
    {     0.00000000046,  5.69622642147,   129373.02023068098}, 
    {     0.00000000049,  0.77406531565,    50689.82616208319}, 
    {     0.00000000047,  4.71730919604,    50903.12525752120}, 
    {     0.00000000045,  0.16928967852,    24918.31489016559}, 
    {     0.00000000045,  4.07905982522,    52137.67324751059}, 
    {     0.00000000055,  1.48552179353,    30171.89164827860}, 
    {     0.00000000043,  1.05458495911,    51868.24866217880}, 
    {     0.00000000048,  5.33528588129,      846.08283475120}, 
    {     0.00000000050,  5.63036834479,    53906.92863608099}, 
    {     0.00000000043,  0.58293994614,     1243.48760167840}, 
    {     0.00000000045,  2.34759373560,   129387.24732468258}, 
    {     0.00000000051,  2.87841847345,    27669.86248985719}, 
    {     0.00000000042,  2.78081946255,   196137.07343261078}, 
    {     0.00000000044,  3.49994820098,    26575.53789282839}, 
    {     0.00000000044,  0.12140582521,   102659.44689679438}, 
    {     0.00000000045,  2.04695118037,    27573.19384827740}, 
    {     0.00000000041,  0.47941299466,    78338.49102328988}, 
    {     0.00000000047,  1.92333552585,    50049.92887576919}, 
    {     0.00000000045,  4.77215729269,   143005.66740785378}, 
    {     0.00000000054,  1.46122428139,    28102.88481337200}, 
    {     0.00000000042,  1.96361292970,    27223.58001346740}, 
    {     0.00000000041,  2.30268380021,    26709.64694241340}, 
    {     0.00000000041,  1.92747555556,     3308.46589538040}, 
    {     0.00000000045,  4.86855086637,    52483.36390411799}, 
    {     0.00000000043,  0.50216349819,    80174.90890793978}, 
    {     0.00000000039,  0.91312968484,   112231.70171963578}, 
    {     0.00000000043,  3.10730855142,    26126.03617721200}, 
    {     0.00000000053,  5.56781441388,   123200.84011627098}, 
    {     0.00000000040,  0.92168760069,    50910.23880452200}, 
    {     0.00000000038,  1.36640441348,    70269.18098269838}, 
    {     0.00000000043,  2.46038752343,    65831.66677432480}, 
    {     0.00000000040,  5.66552759512,    52174.32181044009}, 
    {     0.00000000041,  0.24350307899,      742.99006053260}, 
    {     0.00000000037,  5.02758418587,    24203.00197815680}, 
    {     0.00000000050,  4.86639882575,    78153.50310350319}, 
    {     0.00000000038,  0.49931267586,   103498.41618454478}, 
    {     0.00000000038,  5.01896816519,    26402.08932144380}, 
    {     0.00000000044,  2.59329487932,     6720.71397934140}, 
    {     0.00000000036,  0.09348706711,    26118.23000257860}, 
    {     0.00000000039,  5.17129107574,   151199.94274106238}, 
    {     0.00000000038,  5.23608148918,   130289.95251073639}, 
    {     0.00000000036,  0.02519747828,     2111.65031337760}, 
    {     0.00000000036,  1.71850590197,    54374.89362643540}, 
    {     0.00000000045,  4.12023391118,    25227.59321282139}, 
    {     0.00000000036,  0.13280688272,    27351.06050415239}, 
    {     0.00000000035,  4.16108423219,     2686.72209454120}, 
    {     0.00000000035,  5.73702300793,    45290.65639321759}, 
    {     0.00000000038,  3.17189584793,    78786.28684281638}, 
    {     0.00000000049,  4.14640458599,    27170.98337386779}, 
    {     0.00000000038,  5.67662667380,   166740.70439565618}, 
    {     0.00000000037,  0.76533217080,    16703.06213349900}, 
    {     0.00000000035,  5.00372443548,    52509.66222391780}, 
    {     0.00000000042,  1.55456747560,   130443.39704322898}, 
    {     0.00000000043,  3.12511204668,    91805.13062721379}, 
    {     0.00000000034,  4.65510552531,    77947.31755506598}, 
    {     0.00000000034,  3.88709177637,    80382.47328510099}, 
    {     0.00000000039,  2.12675603585,     3492.57156686960}, 
    {     0.00000000036,  2.01530773081,     1162.47470440780}, 
    {     0.00000000033,  0.74851795223,    25985.94062330859}, 
    {     0.00000000034,  6.26508471441,      202.25339517410}, 
    {     0.00000000036,  4.68450442674,   123668.80510662538}, 
    {     0.00000000033,  3.05683945691,     2820.83114412620}, 
    {     0.00000000039,  2.76389328557,    50270.34151820800}, 
    {     0.00000000033,  1.78770441039,    19336.86230122839}, 
    {     0.00000000042,  3.12796548551,   130435.63437251298}, 
    {     0.00000000035,  4.65699216390,    22003.91463486980}, 
    {     0.00000000037,  6.01381885159,    26057.57628056979}, 
    {     0.00000000036,  4.94463357606,    29396.36903695460}, 
    {     0.00000000041,  5.09084582162,   145204.75475114079}, 
    {     0.00000000032,  0.94969843186,    78580.10129437919}, 
    {     0.00000000044,  0.02248588790,    25014.29411738339}, 
    {     0.00000000031,  6.11767685934,    21716.02677480000}, 
    {     0.00000000042,  2.27375823663,    25169.97285559240}, 
    {     0.00000000036,  3.78048388974,     8989.46770543239}, 
    {     0.00000000031,  3.20777738129,   176332.24614102798}, 
    {     0.00000000042,  1.80282357417,   103932.12792242158}, 
    {     0.00000000030,  2.35954766344,     2383.19301477620}, 
    {     0.00000000034,  5.35878796647,    26189.86565983980}, 
    {     0.00000000039,  1.48269177389,     4022.26253196420}, 
    {     0.00000000030,  1.47612019208,   233731.74634397858}, 
    {     0.00000000035,  0.17499181765,     6129.29703950660}, 
    {     0.00000000038,  1.08833775351,    25773.71696170459}, 
    {     0.00000000035,  3.98231389633,     1300.82681820500}, 
    {     0.00000000030,  4.73794492601,    24072.92146977640}, 
    {     0.00000000029,  2.49485056149,   102755.42612401219}, 
    {     0.00000000029,  3.33146370824,   235900.50682626116}, 
    {     0.00000000030,  0.63651362988,    35077.37084700659}, 
    {     0.00000000034,  0.04811451681,    52177.29075585669}, 
    {     0.00000000035,  4.36523032466,    81591.84508100279}, 
    {     0.00000000035,  0.38273412507,      515.46387109300}, 
    {     0.00000000040,  3.08977629569,     8014.19820292400}, 
    {     0.00000000040,  0.60182722935,    24388.62392507099}, 
    {     0.00000000039,  3.37554049867,    23549.65463732060}, 
    {     0.00000000038,  4.59287461574,    26076.85744131030}, 
    {     0.00000000029,  4.79176575333,    28736.35796704720}, 
    {     0.00000000034,  2.41562403618,    61560.64729122359}, 
    {     0.00000000028,  1.26404438296,    27044.19229754480}, 
    {     0.00000000031,  3.42953745446,    24402.85101907260}, 
    {     0.00000000028,  2.76913598494,    26312.24793727610}, 
    {     0.00000000029,  3.06982412427,    76041.85279012559}, 
    {     0.00000000034,  3.23742666170,    28791.51929624980}, 
    {     0.00000000030,  1.64025002898,   163766.09444104518}, 
    {     0.00000000028,  0.87242954200,   128220.75860368418}, 
    {     0.00000000028,  5.09736276985,    78213.71280281838}, 
    {     0.00000000037,  0.28351092178,    78313.70604662679}, 
    {     0.00000000038,  4.09691356449,    35833.22369743080}, 
    {     0.00000000031,  0.65724812619,     1535.97674296940}, 
    {     0.00000000031,  1.36667591862,    37698.45509994840}, 
    {     0.00000000027,  0.27133102944,    50444.68393021580}, 
    {     0.00000000029,  3.19360520586,    23762.95373275860}, 
    {     0.00000000031,  5.97147065077,   122444.98726584678}, 
    {     0.00000000029,  2.90797073636,   130866.11389874699}, 
    {     0.00000000031,  4.69284912548,    27250.37784598199}, 
    {     0.00000000034,  4.72391913604,    22065.64060961000}, 
    {     0.00000000028,  3.80715503127,    24513.05734029200}, 
    {     0.00000000032,  4.51091012068,     3776.43088573480}, 
    {     0.00000000027,  1.41755601588,    52161.57918914679}, 
    {     0.00000000034,  2.44729988472,    23336.35554188260}, 
    {     0.00000000031,  6.18521142908,   102769.65321801379}, 
    {     0.00000000026,  5.33349284702,   199599.31813847595}, 
    {     0.00000000031,  4.33951803932,    52286.01260436779}, 
    {     0.00000000026,  2.51322393927,     1353.74874501680}, 
    {     0.00000000026,  0.99927277404,     1322.67764753140}, 
    {     0.00000000029,  4.43628976720,    25450.90686955000}, 
    {     0.00000000027,  2.91198700644,   132028.58860315479}, 
    {     0.00000000026,  2.03567536503,    52817.21984488739}, 
    {     0.00000000027,  3.39103592839,   104819.57755665119}, 
    {     0.00000000025,  1.75972456058,    78683.19406859778}, 
    {     0.00000000026,  5.30421942727,    24864.08530079559}, 
    {     0.00000000026,  5.36078058708,      412.37109687440}, 
    {     0.00000000026,  2.07200432690,    25004.82290928060}, 
    {     0.00000000026,  5.53069670975,    25657.37279743509}, 
    {     0.00000000031,  4.78180598437,    75930.51303185058}, 
    {     0.00000000033,  5.22716597630,    81604.32185142238}, 
    {     0.00000000032,  2.69632977953,    25647.07785669659}, 
    {     0.00000000025,  3.50647425364,    15406.65260500879}, 
    {     0.00000000032,  5.18753945619,     2008.55753915900}, 
    {     0.00000000026,  1.17353987461,   153084.84390447979}, 
    {     0.00000000034,  2.39619895259,    39763.43339365039}, 
    {     0.00000000025,  3.04307664595,    26724.89941359840}, 
    {     0.00000000030,  4.90635260381,   116783.65521669458}, 
    {     0.00000000025,  1.59985699911,    31281.27020037200}, 
    {     0.00000000027,  5.86374680669,     5815.11085963699}, 
    {     0.00000000030,  1.12362303179,      625.67019231240}, 
    {     0.00000000025,  0.50599655672,   130446.62925487179}, 
    {     0.00000000024,  3.36738491746,   133882.09065283638}, 
    {     0.00000000025,  1.23585314301,       53.09615231440}, 
    {     0.00000000026,  1.21618229660,    49976.71893986139}, 
    {     0.00000000023,  4.72011826154,   198489.93958638258}, 
    {     0.00000000026,  0.93376725671,   158746.17595363196}, 
    {     0.00000000029,  2.71422590007,    25600.26839032000}, 
    {     0.00000000023,  1.46742391676,     1272.68102562720}, 
    {     0.00000000030,  4.64969871478,    52027.72755872209}, 
    {     0.00000000023,  0.95810401383,    28774.62523611540}, 
    {     0.00000000032,  3.69056811040,    52024.75861330549}, 
    {     0.00000000031,  3.86645564887,    25466.15934073500}, 
    {     0.00000000024,  3.15839525203,    77616.69859140778}, 
    {     0.00000000026,  3.93909230070,    80596.90581759460}, 
    {     0.00000000024,  1.30934055878,   163298.12945069079}, 
    {     0.00000000023,  5.77389485042,   240452.46032331996}, 
    {     0.00000000022,  1.95823889628,   177287.84588263658}, 
    {     0.00000000022,  6.04180912528,    50007.04580086580}, 
    {     0.00000000022,  2.96772486295,    12546.48193908300}, 
    {     0.00000000022,  3.02308458897,    39450.35284837340}, 
    {     0.00000000026,  0.28424456166,     1265.56747862640}, 
    {     0.00000000021,  6.03673087116,    27463.67694142000}, 
    {     0.00000000021,  1.44442495819,     5687.63036895200}, 
    {     0.00000000021,  0.22636621533,    52609.51802102519}, 
    {     0.00000000021,  4.08328280632,   104358.24112519680}, 
    {     0.00000000021,  3.98455360039,     6191.02301424680}, 
    {     0.00000000028,  0.93280167770,    51841.95034237900}, 
    {     0.00000000020,  4.59350193239,    52061.40717623499}, 
    {     0.00000000021,  5.71487101033,     2840.50090502600}, 
    {     0.00000000023,  0.43226688693,    24285.53115085240}, 
    {     0.00000000021,  1.98572602434,     7392.45440208480}, 
    {     0.00000000024,  0.82344555863,     2698.45144737720}, 
    {     0.00000000020,  5.43337501787,     1485.98012106520}, 
    {     0.00000000025,  5.01531560459,   101703.15774082378}, 
    {     0.00000000020,  3.31281154655,    26248.31051095900}, 
    {     0.00000000024,  3.19969282574,    47803.92991637420}, 
    {     0.00000000020,  5.21639602111,    76137.83201734339}, 
    {     0.00000000020,  5.58624181701,   155887.52156313117}, 
    {     0.00000000021,  3.09198846094,    26267.98027185880}, 
    {     0.00000000025,  5.43422956232,        2.96894541660}, 
    {     0.00000000022,  0.58074025919,    25672.35065096209}, 
    {     0.00000000026,  1.34785586419,      309.27832265580}, 
    {     0.00000000021,  6.10721760956,    24824.74577899600}, 
    {     0.00000000020,  2.62628682595,      164.43591058941}, 
    {     0.00000000020,  1.38930287323,      952.07662325960}, 
    {     0.00000000019,  3.02128285607,     9123.57675501740}, 
    {     0.00000000020,  0.47663702299,   203041.89308344138}, 
    {     0.00000000021,  4.32357573082,   183145.01295611398}, 
    {     0.00000000022,  1.67611192774,    23113.29318696320}, 
    {     0.00000000020,  0.68567124507,       42.88307490340}, 
    {     0.00000000027,  1.27457872442,     7860.41939243920}, 
    {     0.00000000025,  3.05401652463,    76152.05911134499}, 
    {     0.00000000025,  4.23522536960,    24952.22626968100}, 
    {     0.00000000021,  3.62099370643,     5635.03372935240}, 
    {     0.00000000021,  4.44062433316,    25862.07387316400}, 
    {     0.00000000020,  2.13621746848,       26.29831979980}, 
    {     0.00000000019,  4.16952441021,    24602.61243487099}, 
    {     0.00000000021,  3.90484373725,    51534.39272140940}, 
    {     0.00000000026,  2.47222104372,    25665.23710396129}, 
    {     0.00000000025,  5.79456184716,    26098.94884183810}, 
    {     0.00000000019,  4.95422682882,   209658.82487420218}, 
    {     0.00000000021,  2.28837738298,    25865.04281858059}, 
    {     0.00000000018,  0.50891176228,    52309.91533273340}, 
    {     0.00000000019,  5.79715725254,    26279.35140768579}, 
    {     0.00000000025,  4.73465324099,   391318.54712361297}, 
    {     0.00000000019,  1.23662681079,    52179.73843641149}, 
    {     0.00000000018,  1.52837590084,      107.30530692960}, 
    {     0.00000000019,  0.76735048216,    52396.21892558720}, 
    {     0.00000000019,  1.55096040730,      148.07872442630}, 
    {     0.00000000021,  6.27787013701,    54344.56676543099}, 
    {     0.00000000025,  5.13456064718,    12382.04602849360}, 
    {     0.00000000022,  4.76661068718,    48847.67062686820}, 
    {     0.00000000019,  5.02228884604,    26114.20146137400}, 
    {     0.00000000018,  2.45809868831,    50264.60679993120}, 
    {     0.00000000022,  3.85509627645,     6885.14988993081}, 
    {     0.00000000020,  0.64660197557,    77940.20400806518}, 
    {     0.00000000020,  2.79332004367,    25927.49577218939}, 
    {     0.00000000018,  5.83348216244,      293.41078437720}, 
    {     0.00000000023,  4.64720241213,   112545.88789950538}, 
    {     0.00000000018,  0.60198526172,    27566.76971563859}, 
    {     0.00000000020,  2.63916620118,     7768.36655669460}, 
    {     0.00000000020,  0.71397154242,      959.12285995760}, 
    {     0.00000000019,  1.79653943961,       89.48574784600}, 
    {     0.00000000021,  1.51443251611,   208173.53416749898}, 
    {     0.00000000021,  4.16640140039,     2125.87740737920}, 
    {     0.00000000018,  1.11242384108,    87367.61641884019}, 
    {     0.00000000020,  5.93006048006,    11852.35506339900}, 
    {     0.00000000017,  3.93966914970,    25459.05155552409}, 
    {     0.00000000023,  2.99103906198,    23446.56186310200}, 
    {     0.00000000018,  0.74408260155,     1795.25844372100}, 
    {     0.00000000020,  0.59479884317,       95.97922721780}, 
    {     0.00000000021,  1.90510484926,   193937.98608932378}, 
    {     0.00000000021,  3.01566725550,    25907.82601128960}, 
    {     0.00000000018,  3.09035824301,      838.96928775040}, 
    {     0.00000000017,  6.26002814839,   233681.74972207438}, 
    {     0.00000000016,  1.73589266057,    52911.68279668019}, 
    {     0.00000000017,  4.10264599764,   189386.03259226495}, 
    {     0.00000000021,  0.43840312896,    55638.05098901359}, 
    {     0.00000000016,  2.13276366606,    16342.58258571760}, 
    {     0.00000000019,  5.53134137122,     9591.54174537180}, 
    {     0.00000000016,  1.15891409897,   237009.88537835456}, 
    {     0.00000000016,  2.62905988628,      191.44826611160}, 
    {     0.00000000016,  4.36751801210,   120417.67842777158}, 
    {     0.00000000020,  1.12978867673,    25650.25925043430}, 
    {     0.00000000016,  4.29882054111,    76255.15188556358}, 
    {     0.00000000016,  1.14702353715,    53399.62412392700}, 
    {     0.00000000016,  3.57235087963,   103718.82882698359}, 
    {     0.00000000017,  5.76960454227,    51130.65144696079}, 
    {     0.00000000016,  4.53670173929,     2667.05233364140}, 
    {     0.00000000021,  0.46791872189,    19367.18916223280}, 
    {     0.00000000018,  5.19929902272,     2544.67263689240}, 
    {     0.00000000015,  3.98281479283,   230239.17477710896}, 
    {     0.00000000017,  4.87067876483,    45424.76544280259}, 
    {     0.00000000015,  0.79205322004,    25928.60140678200}, 
    {     0.00000000017,  2.81666385261,   102975.83876645098}, 
    {     0.00000000015,  4.52789927390,    25984.12095299360}, 
    {     0.00000000020,  5.26775931269,    60370.08161635699}, 
    {     0.00000000016,  0.88949240489,   156314.11975400719}, 
    {     0.00000000015,  3.38506105616,   129586.31932611899}, 
    {     0.00000000019,  5.28475048168,   154408.65498906678}, 
    {     0.00000000015,  4.71428343288,     2974.60995461100}, 
    {     0.00000000018,  4.01766399485,    51876.67988887919}, 
    {     0.00000000015,  0.63968350199,    53093.73656913019}, 
    {     0.00000000020,  5.58915267196,     1423.56473196300}, 
    {     0.00000000015,  3.27898899275,   117893.03376878797}, 
    {     0.00000000016,  0.20415665801,    41494.55574658299}, 
    {     0.00000000017,  1.85003466180,   102872.74599223239}, 
    {     0.00000000015,  1.38086670918,    77417.62658997139}, 
    {     0.00000000016,  2.32863321036,   181659.72224941078}, 
    {     0.00000000017,  5.37350443158,    25384.26995695679}, 
    {     0.00000000020,  3.62690837800,    48997.66049258080}, 
    {     0.00000000015,  3.10421184998,   128747.35003836859}, 
    {     0.00000000018,  4.06067303164,    51439.92976961659}, 
    {     0.00000000016,  2.42412026249,   128106.31931499895}, 
    {     0.00000000017,  1.33866516494,   103395.32341032618}, 
    {     0.00000000016,  3.64720066701,    24072.23205541439}, 
    {     0.00000000015,  2.96793644807,    24719.24288872919}, 
    {     0.00000000014,  2.19807995874,    50951.98844236979}, 
    {     0.00000000014,  1.98624084691,   225687.22128005016}, 
    {     0.00000000014,  5.35774038541,      896.07945665540}, 
    {     0.00000000014,  4.49215712633,    57503.28239153120}, 
    {     0.00000000017,  0.94769327499,   104344.98400739678}, 
    {     0.00000000014,  2.61818604050,      151.04766984290}, 
    {     0.00000000014,  2.15994876258,   104276.83096772949}, 
    {     0.00000000019,  4.61702547610,    16028.39640584800}, 
    {     0.00000000014,  4.46499375434,   208276.62694171758}, 
    {     0.00000000014,  5.03809675504,    53029.00266490040}, 
    {     0.00000000014,  3.98620415374,   263097.78851992876}, 
    {     0.00000000016,  2.13499283716,    78129.60037513758}, 
    {     0.00000000016,  1.96317271676,   183674.70392120858}, 
    {     0.00000000014,  0.54684500137,   138319.60486120995}, 
    {     0.00000000016,  2.76397470223,    46046.50924364180}, 
    {     0.00000000014,  5.52483338141,   130363.24963659538}, 
    {     0.00000000013,  0.79709975404,    78225.57638908479}, 
    {     0.00000000013,  0.98317849568,   103189.13786188899}, 
    {     0.00000000019,  4.91561037107,      277.03499374140}, 
    {     0.00000000014,  2.61194442842,     7830.09253143480}, 
    {     0.00000000014,  5.00788361103,   144916.86689107098}, 
    {     0.00000000014,  0.85520701494,    78043.29678228378}, 
    {     0.00000000015,  1.37228117638,    18043.37807764579}, 
    {     0.00000000013,  4.33964770436,      117.31986822020}, 
    {     0.00000000014,  3.64749226957,    78484.12206716138}, 
    {     0.00000000014,  4.75183782414,    78999.58593825439}, 
    {     0.00000000017,  5.38779546100,    52041.69723356339}, 
    {     0.00000000018,  3.66718937351,   104028.10714963939}, 
    {     0.00000000013,  6.00410401507,    28908.73428570040}, 
    {     0.00000000017,  2.88265913843,   128857.55635958798}, 
    {     0.00000000014,  1.73651187343,     2912.88397987080}, 
    {     0.00000000013,  2.10940309095,    77314.53381575279}, 
    {     0.00000000013,  4.28715947323,   190809.59732422797}, 
    {     0.00000000013,  5.75312146188,   222224.97657418498}, 
    {     0.00000000015,  3.12808384217,      173.44857138459}, 
    {     0.00000000016,  5.33449282836,    25970.58327335399}, 
    {     0.00000000013,  2.93774353095,      533.62311835770}, 
    {     0.00000000016,  0.76587038276,      557.45073820040}, 
    {     0.00000000018,  2.30655980174,    77520.71936418998}, 
    {     0.00000000013,  0.04322502004,    54879.42243782400}, 
    {     0.00000000015,  0.93774708323,      461.33643145440}, 
    {     0.00000000015,  6.01552400160,    51112.49219969609}, 
    {     0.00000000012,  4.96649539823,    50536.73676596039}, 
    {     0.00000000013,  5.79333684284,     1685.05212250160}, 
    {     0.00000000013,  3.37185657268,    79212.88503369238}, 
    {     0.00000000014,  5.75421332040,    72134.41238521598}, 
    {     0.00000000017,  0.64086930843,     5131.64108405760}, 
    {     0.00000000012,  6.24722203509,    49850.85687433279}, 
    {     0.00000000013,  1.38408689559,     4885.80943782820}, 
    {     0.00000000012,  6.17819404999,    78413.27262185719}, 
    {     0.00000000012,  1.86846407635,   102225.73515891758}, 
    {     0.00000000012,  6.15305377435,    35211.47989659159}, 
    {     0.00000000012,  0.60231036252,   156520.30530244438}, 
    {     0.00000000013,  4.53618198307,    56259.79478985279}, 
    {     0.00000000013,  3.44123266792,    27623.87988454360}, 
    {     0.00000000012,  5.14707166267,   103402.43695732698}, 
    {     0.00000000012,  3.67164611321,    79181.63971070439}, 
    {     0.00000000014,  2.94493679739,    51120.35650622229}, 
    {     0.00000000014,  4.85835532315,   207114.15223730978}, 
    {     0.00000000014,  5.14050840336,      726.48201987020}, 
    {     0.00000000012,  2.50220281722,    26183.88236879199}, 
    {     0.00000000012,  5.13091142343,   203375.74902421077}, 
    {     0.00000000016,  0.78825622002,    53814.87580033639}, 
    {     0.00000000015,  0.44405836757,     2751.54759969160}, 
    {     0.00000000012,  2.82956991193,    26290.15653674829}, 
    {     0.00000000012,  2.84166479969,    25885.64974640009}, 
    {     0.00000000013,  3.00745306846,    79315.97780791098}, 
    {     0.00000000013,  1.88395137670,    26161.20026743319}, 
    {     0.00000000013,  1.01105657732,   156507.74908854539}, 
    {     0.00000000013,  1.24212367708,     4437.51420837359}, 
    {     0.00000000012,  5.92057732534,   129063.74190802519}, 
    {     0.00000000015,  1.46838291003,   103883.64757594238}, 
    {     0.00000000012,  5.75930846692,    79330.20490191258}, 
    {     0.00000000014,  0.83818630211,   215473.93573383916}, 
    {     0.00000000012,  1.60578990904,   171004.77003264519}, 
    {     0.00000000012,  2.95802141114,   182828.62108645738}, 
    {     0.00000000013,  2.19092122373,    51745.27593900929}, 
    {     0.00000000012,  5.23164825285,    26411.40855823160}, 
    {     0.00000000012,  4.69895639838,   259819.64948555276}, 
    {     0.00000000012,  0.75426704696,    75085.56363415498}, 
    {     0.00000000011,  4.28892572000,    78267.64157798568}, 
    {     0.00000000014,  2.98871686554,     1073.60902419080}, 
    {     0.00000000012,  4.61671703735,    57369.17334194619}, 
    {     0.00000000015,  2.90757589820,   187167.27548807819}, 
    {     0.00000000011,  5.43931897089,   181548.82651382938}, 
    {     0.00000000013,  3.80987567817,    79902.77894191058}, 
    {     0.00000000011,  3.97843637033,    76998.14194609619}, 
    {     0.00000000012,  4.40009190504,   133767.65136415116}, 
    {     0.00000000011,  1.83887545163,    70069.43409151399}, 
    {     0.00000000015,  3.94865416467,    27665.24668402200}, 
    {     0.00000000013,  5.32692215409,   103608.62250576419}, 
    {     0.00000000013,  2.57664086838,     1116.49209909420}, 
    {     0.00000000011,  2.08178776420,   181563.05360783098}, 
    {     0.00000000011,  6.16260267843,   103704.60173298199}, 
    {     0.00000000013,  2.57288307747,    52186.85198341230}, 
    {     0.00000000012,  4.53320021239,    30110.16567353840}, 
    {     0.00000000011,  0.42392733510,   289185.69166150296}, 
    {     0.00000000013,  3.08655281854,    27353.47062020059}, 
    {     0.00000000011,  5.31849553869,   128843.32926558638}, 
    {     0.00000000015,  1.73060252282,      114.39910691340}, 
    {     0.00000000014,  0.92426206484,     1577.34354244780}, 
    {     0.00000000011,  5.29480881265,    52797.55008398759}, 
    {     0.00000000011,  4.68388844445,    77684.02183772379}, 
    {     0.00000000013,  4.84220246179,    79353.41821591619}, 
    {     0.00000000013,  0.54230990449,    50600.96048186620}, 
    {     0.00000000012,  0.31807521148,    78469.89497315978}, 
    {     0.00000000011,  0.00425376917,    90989.16285949759}, 
    {     0.00000000014,  2.98013751433,    51102.19725895759}, 
    {     0.00000000011,  3.59702354156,     1905.46476494040}, 
    {     0.00000000011,  3.26875143851,   143980.93691036216}, 
    {     0.00000000015,  4.29683167838,    52171.87412988529}, 
    {     0.00000000011,  4.72219805551,    80462.79676800959}, 
    {     0.00000000012,  3.49543725775,   241561.83887541336}, 
    {     0.00000000011,  1.27219939260,    78843.39701172139}, 
    {     0.00000000015,  4.82058460939,    77741.13200662879}, 
    {     0.00000000011,  1.83973749004,   154194.22245657316}, 
    {     0.00000000011,  2.94887593762,     5039.58824831300}, 
    {     0.00000000011,  1.06186939541,   216897.50046580215}, 
    {     0.00000000014,  2.07353096792,   130542.60848208958}, 
    {     0.00000000011,  1.72854679046,    76624.63990753458}, 
    {     0.00000000013,  1.92207364074,     2962.88060177500}, 
    {     0.00000000011,  6.13912703925,   154835.25317994278}, 
    {     0.00000000011,  2.76325252261,    25572.43927048119}, 
    {     0.00000000012,  4.55048857833,    52755.49387014719}, 
    {     0.00000000012,  4.51348351634,    54190.78795494619}, 
    {     0.00000000011,  2.78880372821,    76094.94894243999}, 
    {     0.00000000011,  5.78732279706,    76358.24465978218}, 
    {     0.00000000012,  6.17213642404,   104127.26777059489}, 
    {     0.00000000011,  1.27458486402,    82347.69793142698}, 
    {     0.00000000010,  0.05959891479,   261988.40996783535}, 
    {     0.00000000010,  6.12251295566,   156740.71794488319}, 
    {     0.00000000011,  1.80239315901,    78800.51393681798}, 
    {     0.00000000010,  0.18800956280,   155674.22246769318}, 
    {     0.00000000010,  0.25622286707,    52663.44103440259}, 
    {     0.00000000014,  3.41659141429,    26603.36701266720}, 
    {     0.00000000010,  4.66171161353,   197092.67317421938}, 
    {     0.00000000011,  5.43581617959,     4398.17468657401}, 
    {     0.00000000015,  5.81769607175,   102239.96225291918}, 
    {     0.00000000011,  3.08658188433,    80432.46990700519}, 
    {     0.00000000010,  4.59460664618,   104659.17018726638}, 
    {     0.00000000012,  0.33304920988,   142871.55835826878}, 
    {     0.00000000011,  2.04909853861,    26933.98597632540}, 
    {     0.00000000010,  4.99843585518,    42430.48572729180}, 
    {     0.00000000012,  5.87342153519,   156954.01704032118}, 
    {     0.00000000010,  0.94936373883,   102343.05502713779}, 
    {     0.00000000011,  0.51569476586,   210614.42461581076}, 
    {     0.00000000014,  4.15042375832,    52190.03337714999}, 
    {     0.00000000011,  2.31402246192,   130336.42293365239}, 
    {     0.00000000010,  0.77651929350,   104044.05494532720}, 
    {     0.00000000011,  3.45756625090,    50373.43429242659}, 
    {     0.00000000012,  5.44549783030,    56777.75640211140}, 
    {     0.00000000012,  2.53814691384,   248312.87971575916}, 
    {     0.00000000011,  5.81248587528,    51688.17153189420}, 
    {     0.00000000010,  5.02934387609,       63.73589830340}, 
    {     0.00000000011,  1.48790524324,    58220.03486452380}, 
    {     0.00000000013,  1.73084719204,    55484.27217852879}, 
    {     0.00000000010,  3.07696158333,   259769.65286364855}, 
    {     0.00000000014,  0.80260135302,    77527.83291119078}, 
    {     0.00000000010,  5.92438780788,   102129.75593169978}, 
    {     0.00000000014,  0.09133406732,      138.51749687070}, 
    {     0.00000000012,  1.46736907113,    76991.02839909539}, 
    {     0.00000000011,  3.69737943157,    60170.33472517260}, 
    {     0.00000000011,  0.91716465178,   103829.03514820298}, 
    {     0.00000000012,  2.48001423636,    76468.45098100159}, 
    {     0.00000000012,  3.63244499225,    50476.52706664519}, 
    {     0.00000000012,  0.15820265323,    49637.55777889479}, 
    {     0.00000000013,  2.21304135803,      287.88786006980}, 
    {     0.00000000011,  3.04909618741,   156547.08861034496}, 
    {     0.00000000013,  5.42354700318,    51753.14024553549}, 
    {     0.00000000014,  2.17544501087,     2506.64496425660}, 
    {     0.00000000010,  2.03757692776,    78885.45322556178}, 
    {     0.00000000012,  6.18435893480,   103814.80805420138}, 
    {     0.00000000010,  5.01102689994,    53311.48315504160}, 
    {     0.00000000011,  2.67328823906,    26734.91397488900}, 
    {     0.00000000013,  2.15288344965,    82865.65954368559}, 
    {     0.00000000011,  2.26046112925,    74801.46471885739}, 
    {     0.00000000012,  0.91311461577,    53258.88651544199}, 
    {     0.00000000010,  5.07907315221,   156093.70711156838}, 
    {     0.00000000012,  6.05275501244,   105403.88094948517}, 
    {     0.00000000011,  5.19596855548,   104454.70534051539}, 
    {     0.00000000011,  5.87059533653,   158116.49174472898}, 
    {     0.00000000011,  0.38514839596,    53124.98189211819}, 
    {     0.00000000010,  1.59386679469,    51596.11869614960}, 
    {     0.00000000010,  4.41461079699,   257436.45647077652}, 
    {     0.00000000014,  1.74381856487,       36.64856292950}, 
    {     0.00000000010,  1.24965183253,    80278.69109652039}, 
    {     0.00000000010,  0.61741652170,   149846.19399604558}, 
    {     0.00000000012,  2.86918517100,     2045.30853280220}, 
    {     0.00000000010,  5.38944159655,       77.75054398390}, 
    {     0.00000000010,  3.80043163945,   104313.47953065898}, 
    {     0.00000000014,  6.10459624713,      454.90936652730}, 
    {     0.00000000011,  1.99827759086,     1088.60315660100}, 
    {     0.00000000011,  2.62058705881,   153186.80642274539}, 
    {     0.00000000010,  2.41417743630,   155460.92337225519}, 
    {     0.00000000010,  4.48839233108,   180282.12559814737}, 
    {     0.00000000010,  1.76037317626,    52489.99246301800}, 
    {     0.00000000013,  4.11972652561,    54060.70744656579}, 
    {     0.00000000010,  3.55061763662,    78397.81847430758}, 
    {     0.00000000012,  3.81883856360,    76777.72930365738}, 
    {     0.00000000010,  4.45423293249,     5469.88378304060}, 
    {     0.00000000010,  0.26898429031,     5019.91848741320}, 
    {     0.00000000010,  2.26378618368,   179172.74704605396}, 
    {     0.00000000010,  3.66756317752,   175934.09713761978}, 
    {     0.00000000011,  4.42724223352,   103505.52973154558}, 
    {     0.00000000009,  5.26539502261,   130285.73689738619}, 
    {     0.00000000010,  3.94785662225,    54862.52837768960}, 
    {     0.00000000012,  1.55587525404,    74935.57376844239}, 
    {     0.00000000009,  0.36164076660,     1045.15483618760}, 
    {     0.00000000009,  6.21588367959,    54397.66291774539}, 
    {     0.00000000013,  2.54150715208,    23735.03698780239}, 
    {     0.00000000009,  5.54583366059,    53867.97195265079}, 
    {     0.00000000010,  5.50923146669,   130593.29451835579}, 
    {     0.00000000010,  1.41367771097,    48091.81777644400}, 
    {     0.00000000009,  0.13225241168,    52918.79634368100}, 
    {     0.00000000009,  1.67266340956,   231348.55332920236}, 
    {     0.00000000010,  1.53965688146,   156107.93420556998}, 
    {     0.00000000011,  3.53206613269,    51760.25379253629}, 
    {     0.00000000009,  3.84605705988,   154308.66174525839}, 
    {     0.00000000009,  3.21918850161,    51006.21803173979}, 
    {     0.00000000011,  0.73383746517,    17605.73994829580}, 
    {     0.00000000009,  3.11807738536,    52206.13314415280}, 
    {     0.00000000009,  1.44205716141,   106550.69990958378}, 
    {     0.00000000011,  0.98740615700,    78259.77727145949}, 
    {     0.00000000009,  5.35123385110,   155475.15046625677}, 
    {     0.00000000009,  5.13834653276,   205260.65018762815}, 
    {     0.00000000009,  1.24238636220,   234364.53008329177}, 
    {     0.00000000009,  2.36679030684,   181975.42470470538}, 
    {     0.00000000011,  3.44695207326,   189853.99758261938}, 
    {     0.00000000009,  3.49327430300,   156534.53239644598}, 
    {     0.00000000011,  3.71214400776,    27883.16158529519}, 
    {     0.00000000009,  1.31408788661,   223180.57631579356}, 
    {     0.00000000010,  3.84128789715,   104131.19992385797}, 
    {     0.00000000011,  4.08487611085,    78378.14871340781}, 
    {     0.00000000009,  4.42707219551,     6751.04084034580}, 
    {     0.00000000011,  0.77879332032,    80148.61058813999}, 
    {     0.00000000009,  0.86214296870,    50690.51557644519}, 
    {     0.00000000010,  5.91391218935,     2538.24850425360}, 
    {     0.00000000010,  5.18315351919,     1382.19793248460}, 
    {     0.00000000010,  3.50888471315,    45455.09230380700}, 
    {     0.00000000009,  2.96380369810,    25991.92391435639}, 
    {     0.00000000009,  0.12768153485,    27993.36790651460}, 
    {     0.00000000011,  0.86259686023,    78277.93651872419}, 
    {     0.00000000010,  1.97201206656,    52499.31169980579}, 
    {     0.00000000009,  3.32039369507,    61165.27398858079}, 
    {     0.00000000009,  1.76555912471,   235746.72801577636}, 
    {     0.00000000011,  0.24999283383,   117077.06600107178}, 
    {     0.00000000011,  2.52816309211,    79845.66877300559}, 
    {     0.00000000011,  1.61182880702,   104241.40624507738}, 
    {     0.00000000009,  0.74096037377,   153878.96402397218}, 
    {     0.00000000012,  5.83966176266,    11790.62908865880}, 
    {     0.00000000010,  0.18030878839,    71542.99544538118}, 
    {     0.00000000011,  4.45519879833,   162810.49469943657}, 
    {     0.00000000009,  2.18403728707,    71378.55953479178}, 
    {     0.00000000012,  5.23790242966,    29580.47470844380}, 
    {     0.00000000010,  6.01456569334,   213255.17862965238}, 
    {     0.00000000011,  3.67835925409,    22595.33157470459}, 
    {     0.00000000009,  0.49720666294,   104984.39630560997}, 
    {     0.00000000011,  5.30179052357,    51257.87599716660}, 
    {     0.00000000009,  3.34551904925,    40738.70289615879}, 
    {     0.00000000010,  0.84359833351,    61921.12683900499}, 
    {     0.00000000010,  0.88211385824,    51315.49635439559}, 
    {     0.00000000010,  2.29548861266,     1211.34107035900}, 
    {     0.00000000008,  3.27342696125,    78751.34417597679}, 
    {     0.00000000009,  2.92305082370,   182611.44065566138}, 
    {     0.00000000010,  0.17758007636,    50490.75416064679}, 
    {     0.00000000008,  5.04021823877,    78905.12298646157}, 
    {     0.00000000010,  4.16632261841,     1130.15394758580}, 
    {     0.00000000010,  1.35239689601,    48153.54375118419}, 
    {     0.00000000009,  2.28938084617,    79994.83177765518}, 
    {     0.00000000008,  4.78894704907,    78577.89560459220}, 
    {     0.00000000009,  1.74700345208,   417406.45026518717}, 
    {     0.00000000008,  2.07572920434,   130005.80396999417}, 
    {     0.00000000008,  3.77310827048,    52073.84376488279}, 
    {     0.00000000008,  1.95594241501,   156377.85565231058}, 
    {     0.00000000011,  4.91839370629,   128960.64913380658}, 
    {     0.00000000008,  3.31138265156,    28309.75977617119}, 
    {     0.00000000011,  5.32356537706,    49424.25868345679}, 
    {     0.00000000008,  2.26325075185,      299.12639426920}, 
    {     0.00000000008,  5.50980958231,    48713.56157728320}, 
    {     0.00000000011,  6.05884458684,    78057.52387628538}, 
    {     0.00000000008,  0.74893403497,   103086.04508767038}, 
    {     0.00000000010,  5.24386890264,      860.30992875280}, 
    {     0.00000000009,  3.53361712213,     1169.58825140860}, 
    {     0.00000000009,  5.69975856885,    27441.65188659100}, 
    {     0.00000000008,  0.40730399000,     5852.78031526380}, 
    {     0.00000000008,  4.15882544767,    79487.52726550119}, 
    {     0.00000000009,  2.19047368741,   174620.79354899516}, 
    {     0.00000000008,  5.10790930441,   278972.40611529196}, 
    {     0.00000000009,  1.39060893451,    78149.27013603736}, 
    {     0.00000000010,  1.44918586530,   285907.55262712695}, 
    {     0.00000000011,  0.82192814161,    52098.05573916449}, 
    {     0.00000000008,  5.87534994551,   127098.90328117118}, 
    {     0.00000000008,  3.51413526661,   104426.39416486409}, 
    {     0.00000000009,  5.16378342721,   130364.73410930368}, 
    {     0.00000000010,  5.09176211486,    53661.09698985160}, 
    {     0.00000000010,  4.71864870979,     1865.23140251760}, 
    {     0.00000000010,  3.44260638200,    81725.95413058778}, 
    {     0.00000000008,  2.89381740957,   247223.17092456557}, 
    {     0.00000000008,  1.50495995792,    50160.82461135059}, 
    {     0.00000000008,  5.93652948222,    31127.49138988719}, 
    {     0.00000000011,  1.88655043160,    53265.51507434200}, 
    {     0.00000000008,  5.51368993901,   104248.51979207818}, 
    {     0.00000000008,  2.26525606520,    79955.87509422498}, 
    {     0.00000000009,  1.58093065123,   224577.84272795678}, 
    {     0.00000000008,  3.29049117119,   104557.79811473397}, 
    {     0.00000000008,  3.98360451030,   182402.02289558138}, 
    {     0.00000000011,  2.68727695708,    31903.01400121119}, 
    {     0.00000000009,  5.43307011162,    65851.33653522459}, 
    {     0.00000000011,  0.51898586475,   129806.73196855778}, 
    {     0.00000000008,  4.45045824026,   175844.61138977378}, 
    {     0.00000000009,  1.36295509329,    78115.63070029629}, 
    {     0.00000000009,  5.08922937782,    62197.64356324779}, 
    {     0.00000000009,  1.19274985025,   106262.81204951399}, 
    {     0.00000000010,  3.84482406254,      199.07200143640}, 
    {     0.00000000008,  4.31142679779,    76064.62208143558}, 
    {     0.00000000008,  3.35473584304,    99979.73619952259}, 
    {     0.00000000010,  5.93947627346,   154945.45950116219}, 
    {     0.00000000009,  2.84548380902,   195047.36464141717}, 
    {     0.00000000010,  3.05711078565,    12098.18670962840}, 
    {     0.00000000011,  6.21650368713,    52213.93931878620}, 
    {     0.00000000008,  0.37369030169,    31722.93687092660}, 
    {     0.00000000008,  6.14665125818,    78294.03628572699}, 
    {     0.00000000008,  2.45482949143,    78262.22495201428}, 
    {     0.00000000008,  0.05965725544,   182634.99175191917}, 
    {     0.00000000008,  2.39708295298,    24551.92639860479}, 
    {     0.00000000010,  2.67934627998,   104145.42701785959}, 
    {     0.00000000008,  4.55751882694,    31775.53351052620}, 
    {     0.00000000008,  3.16773434441,    53438.96364572659}, 
    {     0.00000000008,  6.22544072035,   202420.14928260217}, 
    {     0.00000000008,  5.81704618147,    51734.98099827079}, 
    {     0.00000000008,  1.78435325528,     4743.40176317040}, 
    {     0.00000000009,  3.83707765982,    79346.78965701618}, 
    {     0.00000000010,  5.71688904375,    97466.46267636596}, 
    {     0.00000000008,  2.03894332579,    77345.77913874079}, 
    {     0.00000000008,  4.13054556768,   111032.83741969639}, 
    {     0.00000000008,  4.60922012110,   130329.30938665158}, 
    {     0.00000000008,  5.35165926588,   106082.73491922939}, 
    {     0.00000000008,  5.39530906170,     1168.89883704660}, 
    {     0.00000000009,  3.93805662188,    77929.85348395319}, 
    {     0.00000000007,  5.21488891735,    43981.53094993980}, 
    {     0.00000000008,  2.01003440428,   252884.50297371777}, 
    {     0.00000000010,  4.11323982627,    51861.62010327879}, 
    {     0.00000000008,  5.44182392744,    24844.41553989579}, 
    {     0.00000000009,  1.74545022265,    25778.62481891839}, 
    {     0.00000000007,  3.82338680251,   220025.88923089796}, 
    {     0.00000000007,  6.24768089702,   104874.18998439058}, 
    {     0.00000000009,  2.34086101872,   192828.60753723037}, 
    {     0.00000000009,  0.48166296597,     4571.62325795859}, 
    {     0.00000000010,  3.98285678625,    26014.60601571519}, 
    {     0.00000000008,  1.39482440025,   169093.57054942798}, 
    {     0.00000000008,  2.14139660009,   154931.23240716058}, 
    {     0.00000000007,  4.40965228112,    78249.48233072099}, 
    {     0.00000000009,  2.75553561717,    52145.47942214399}, 
    {     0.00000000007,  2.57942012432,     3178.14579056760}, 
    {     0.00000000008,  1.43006670657,    52164.76058288449}, 
    {     0.00000000007,  2.62316145982,   127791.06088239799}, 
    {     0.00000000008,  4.14250630085,    26713.57333388659}, 
    {     0.00000000007,  1.85653633566,    24765.22549404280}, 
    {     0.00000000008,  3.34882273958,       92.05283574460}, 
    {     0.00000000007,  4.79266143108,    76378.80826130520}, 
    {     0.00000000007,  3.97155618165,    77956.15180375299}, 
    {     0.00000000007,  1.40803692928,    78149.31031780918}, 
    {     0.00000000007,  0.70961929454,   212031.36078887376}, 
    {     0.00000000007,  3.85508188374,    27410.58078910560}, 
    {     0.00000000007,  2.26884263391,   118007.47305747319}, 
    {     0.00000000007,  5.09321484473,    51092.72605085480}, 
    {     0.00000000007,  6.12403557988,    65538.25598994759}, 
    {     0.00000000007,  4.39083508021,   129483.22655190038}, 
    {     0.00000000008,  5.83553684097,   102182.85208401419}, 
    {     0.00000000007,  4.33543927503,    74179.72091801820}, 
    {     0.00000000008,  4.79819281031,   130020.03106399579}, 
    {     0.00000000008,  0.41203822272,    78112.66175487968}, 
    {     0.00000000007,  2.68129663526,   104427.87863757239}, 
    {     0.00000000009,  0.29724852145,     2352.86615377180}, 
    {     0.00000000007,  5.93637605025,    21067.98465416099}, 
    {     0.00000000007,  5.92819269793,   221135.26778299136}, 
    {     0.00000000007,  1.93364234480,    26500.27423844859}, 
    {     0.00000000007,  1.41532885394,   104035.22069664019}, 
    {     0.00000000009,  5.67763971529,    33856.26969826880}, 
    {     0.00000000009,  5.98755838226,    18073.70493865020}, 
    {     0.00000000009,  2.10050473205,    52277.76880141400}, 
    {     0.00000000009,  2.08883097836,   149288.74325784518}, 
    {     0.00000000007,  2.37722377692,    30689.85326053720}, 
    {     0.00000000007,  3.10792403028,   288076.31310940956}, 
    {     0.00000000007,  4.88415129602,   104888.41707839219}, 
    {     0.00000000009,  3.27631582216,   118828.96374949679}, 
    {     0.00000000007,  1.38768372670,    29864.33402730900}, 
    {     0.00000000007,  5.72644167523,    52822.81711646319}, 
    {     0.00000000007,  2.76782011856,    53551.58008299420}, 
    {     0.00000000007,  1.51124075560,    78571.26704569219}, 
    {     0.00000000007,  2.26442292058,   131079.41299418498}, 
    {     0.00000000007,  5.31640546842,    26247.20487636640}, 
    {     0.00000000007,  0.09686245345,    79859.89586700719}, 
    {     0.00000000007,  6.10844494934,    52812.80255517260}, 
    {     0.00000000007,  1.87174516455,    96471.52341295779}, 
    {     0.00000000007,  2.87375591411,    80967.32557939820}, 
    {     0.00000000007,  1.29457274547,   113736.45357437199}, 
    {     0.00000000007,  0.89009344126,    28213.78054895339}, 
    {     0.00000000007,  4.25473641206,    26140.99929388859}, 
    {     0.00000000008,  4.82798273493,   197380.56103428919}, 
    {     0.00000000007,  3.09825871823,    78265.19389743089}, 
    {     0.00000000008,  4.34888971439,   235320.81923926238}, 
    {     0.00000000006,  5.42495897529,   104350.12809358849}, 
    {     0.00000000006,  3.99182956098,   104668.00443595338}, 
    {     0.00000000007,  5.34185785375,   175376.64639941938}, 
    {     0.00000000008,  0.86389617056,   104466.05185498200}, 
    {     0.00000000007,  1.33899601862,   149756.70824819959}, 
    {     0.00000000008,  3.10920439449,   228508.05242417638}, 
    {     0.00000000007,  4.30741955939,   158438.61833266239}, 
    {     0.00000000006,  5.17419549153,   104991.50985261079}, 
    {     0.00000000007,  2.20450442762,   156373.64003896038}, 
    {     0.00000000006,  2.90224060475,   129792.50487455618}, 
    {     0.00000000006,  4.54232458825,    26235.98186600050}, 
    {     0.00000000007,  4.42850204913,    27039.97976483379}, 
    {     0.00000000009,  1.73966926518,   171292.65789271498}, 
    {     0.00000000006,  0.11815278939,   159969.99379441059}, 
    {     0.00000000006,  4.04317848847,   129277.04100346318}, 
    {     0.00000000009,  6.01200767870,   168959.46149984296}, 
    {     0.00000000007,  1.85751313511,    28096.46068073319}, 
    {     0.00000000007,  2.12438011211,    84307.93800609799}, 
    {     0.00000000006,  2.48582215527,   156681.19765992998}, 
    {     0.00000000007,  3.73735796662,   182608.20844401857}, 
    {     0.00000000006,  2.28958252031,   156451.15277816958}, 
    {     0.00000000008,  3.69992350848,   132772.71210074300}, 
    {     0.00000000007,  1.41866016352,   130859.00035174617}, 
    {     0.00000000006,  2.21936307079,   180496.55813064099}, 
    {     0.00000000009,  3.06339763309,   104401.60918820098}, 
    {     0.00000000008,  1.18565300113,   209232.91609768818}, 
    {     0.00000000007,  3.94128798915,    25675.53204469980}, 
    {     0.00000000008,  3.78904655885,   229129.79622501558}, 
    {     0.00000000006,  5.00477784596,   182465.75879388479}, 
    {     0.00000000007,  5.14936294952,    33480.35754365900}, 
    {     0.00000000008,  4.60188784024,   234261.43730907318}, 
    {     0.00000000008,  4.47296414448,   104237.17327761157}, 
    {     0.00000000007,  0.75480073977,    84944.93427812219}, 
    {     0.00000000006,  4.68210231273,   261834.63115735054}, 
    {     0.00000000007,  1.33270050713,   182619.20332637738}, 
    {     0.00000000007,  5.60721965283,   148532.89040742096}, 
    {     0.00000000008,  5.13602967530,   209762.60706278277}, 
    {     0.00000000006,  0.03219084009,    25896.45487546260}, 
    {     0.00000000008,  3.93608578931,   156534.04740834518}, 
    {     0.00000000008,  4.22645360520,   182595.65223011958}, 
    {     0.00000000007,  6.06363932610,   156523.53751408719}, 
    {     0.00000000007,  4.74656613678,   104685.46850706618}, 
    {     0.00000000008,  1.89526023726,    25462.23294926180}, 
    {     0.00000000006,  1.48316940910,    26191.68533015479}, 
    {     0.00000000008,  4.07650178940,    13705.85711308060}, 
    {     0.00000000007,  1.81299543472,    78597.56536549199}, 
    {     0.00000000006,  6.09713561414,   104353.09703900508}, 
    {     0.00000000006,  5.60796663267,   207747.62539098498}, 
    {     0.00000000006,  2.16536179089,    27573.88326263939}, 
    {     0.00000000006,  1.42098831764,    26026.17716683400}, 
    {     0.00000000006,  1.69671918811,    20043.67456019880}, 
    {     0.00000000006,  5.11260117805,   443494.35340676131}, 
    {     0.00000000006,  5.22497762448,   107679.74822257696}, 
    {     0.00000000006,  1.74905384462,    50290.90511973100}, 
    {     0.00000000006,  0.30422543700,   182622.43553802017}, 
    {     0.00000000008,  4.49860671318,   195181.47369100217}, 
    {     0.00000000007,  3.45347996125,      430.53034413910}, 
    {     0.00000000006,  0.74258274172,   256327.07791868312}, 
    {     0.00000000008,  2.76506053583,   183041.92018189539}, 
    {     0.00000000006,  2.89935798569,   239343.08177122659}, 
    {     0.00000000006,  4.96619008761,    70383.62027138360}, 
    {     0.00000000007,  1.84903088230,    28632.57577846660}, 
    {     0.00000000006,  0.68234531723,   104017.75662552739}, 
    {     0.00000000006,  3.11962389893,   184834.07909520617}, 
    {     0.00000000006,  3.60993416994,   131072.29944718418}, 
    {     0.00000000006,  0.03251101986,   102620.49021336419}, 
    {     0.00000000006,  5.50368260841,    26238.95081141709}, 
    {     0.00000000007,  1.97599718563,   107692.22499299659}, 
    {     0.00000000006,  5.77774149400,    78339.97549599818}, 
    {     0.00000000008,  1.97853905449,    88285.54670482199}, 
    {     0.00000000006,  2.44688578354,    28928.40404660019}, 
    {     0.00000000007,  1.78303012604,    26034.80698925980}, 
    {     0.00000000006,  0.43137293270,    27388.72995977919}, 
    {     0.00000000006,  4.76836779722,   104771.09721017198}, 
    {     0.00000000006,  3.63313984470,    77641.96562388338}, 
    {     0.00000000007,  5.22121198783,    91919.56991589899}, 
    {     0.00000000007,  4.48679862542,   156531.30018480319}, 
    {     0.00000000007,  2.61368067822,   266540.36346489414}, 
    {     0.00000000007,  0.12862048714,   130907.48069822539}, 
    {     0.00000000006,  0.43577629069,   106470.37642667518}, 
    {     0.00000000006,  3.82921450071,    27047.02600153180}, 
    {     0.00000000006,  0.70928978057,    26061.60482177439}, 
    {     0.00000000005,  1.08303549554,    22779.43724619380}, 
    {     0.00000000006,  0.25448993981,   146505.58156934578}, 
    {     0.00000000007,  4.06478627606,   104461.81888751619}, 
    {     0.00000000006,  5.60793166576,   131506.01118506098}, 
    {     0.00000000008,  1.69064312952,    38469.94917006779}, 
    {     0.00000000008,  2.44994557596,   164407.50800278416}, 
    {     0.00000000007,  3.54872847011,   155894.63511013199}, 
    {     0.00000000005,  1.10994023578,    52072.02409456780}, 
    {     0.00000000006,  3.73225568492,    26084.93419615759}, 
    {     0.00000000005,  5.58167272835,   101173.46677572919}, 
    {     0.00000000005,  0.70846557489,   208489.92603715559}, 
    {     0.00000000006,  4.59921393870,    20894.53608277640}, 
    {     0.00000000005,  3.75647355566,   242985.40360737636}, 
    {     0.00000000005,  6.27502785749,   104785.32430417358}, 
    {     0.00000000006,  2.00142473286,     1699.27921650320}, 
    {     0.00000000007,  2.76050255944,   184204.39488630318}, 
    {     0.00000000005,  5.47987179385,    26252.33905216361}, 
    {     0.00000000007,  2.00462922304,    26090.87208699080}, 
    {     0.00000000007,  1.62322254368,    18227.48374913500}, 
    {     0.00000000006,  5.70254081987,    33917.99567300899}, 
    {     0.00000000006,  5.97919634831,    77208.25964779648}, 
    {     0.00000000006,  2.16791372283,    26045.02006667080}, 
    {     0.00000000007,  2.57095095237,    77218.55458853499}, 
    {     0.00000000005,  0.25701311411,    25923.46723098479}, 
    {     0.00000000007,  4.14777314934,    33948.32253401340}, 
    {     0.00000000005,  5.29140115995,    28471.09615635040}, 
    {     0.00000000006,  3.53925621297,    26130.78621647760}, 
    {     0.00000000005,  6.11594062706,    52355.88341343300}, 
    {     0.00000000006,  5.57961940155,    76352.50994150538}, 
    {     0.00000000006,  0.83576004159,   130446.14426677099}, 
    {     0.00000000005,  0.43431985985,    23704.71012679799}, 
    {     0.00000000007,  2.28014965021,    35679.44488694599}, 
    {     0.00000000006,  5.37355955737,    17098.43543614181}, 
    {     0.00000000005,  5.97244139790,   123554.36581794015}, 
    {     0.00000000006,  3.95779909916,   130432.88714897096}, 
    {     0.00000000005,  4.47086994601,    27360.58416720139}, 
    {     0.00000000006,  3.02938887393,    26830.89320210680}, 
    {     0.00000000005,  2.94688436969,   129902.71119577558}, 
    {     0.00000000005,  2.93317711504,   130215.17091216908}, 
    {     0.00000000006,  3.75147408015,    42790.96527507320}, 
    {     0.00000000006,  1.00428918941,    51040.12941125520}, 
    {     0.00000000005,  2.78041305143,   143164.96914264598}, 
    {     0.00000000005,  1.86000796030,   469582.25654833551}, 
    {     0.00000000006,  0.74710746073,   132350.71519108818}, 
    {     0.00000000005,  2.39844344347,    23389.45169419700}, 
    {     0.00000000006,  3.58468768151,    23247.40223654820}, 
    {     0.00000000006,  0.82589150780,    77964.58303045339}, 
    {     0.00000000006,  4.53833067121,   101023.47691001659}, 
    {     0.00000000005,  0.57407761078,    24734.15439655740}, 
    {     0.00000000005,  2.25316144259,      415.55249061210}, 
    {     0.00000000006,  4.70935000739,    65717.22748563958}, 
    {     0.00000000005,  0.05510253171,    52336.21365253320}, 
    {     0.00000000005,  5.35670099063,    26513.81191808820}, 
    {     0.00000000006,  2.32062527661,    23384.28698689860}, 
    {     0.00000000005,  1.32520906706,    25980.59783464459}, 
    {     0.00000000005,  0.80991017339,    25661.99436506020}, 
    {     0.00000000006,  6.08272643182,   130589.07890500558}, 
    {     0.00000000005,  4.38196086874,    26195.20844850380}, 
    {     0.00000000005,  0.41357636643,    87253.17713015496}, 
    {     0.00000000005,  1.29167077496,   164721.69418265378}, 
    {     0.00000000005,  0.71179831125,   180396.56488683258}, 
    {     0.00000000006,  1.47416646071,   233202.05537888398}, 
    {     0.00000000005,  6.23460200611,    34102.10134449819}, 
    {     0.00000000005,  5.35033090355,    26397.18146422999}, 
    {     0.00000000005,  4.93083299042,    23401.18104703300}, 
    {     0.00000000005,  2.81440459099,    91626.15913152178}, 
    {     0.00000000005,  3.34946974145,    76532.58707178998}, 
    {     0.00000000006,  2.87843300002,    50912.64892057020}, 
    {     0.00000000005,  0.98613060394,   208683.55537169379}, 
    {     0.00000000006,  0.63843906657,   255217.69936658978}, 
    {     0.00000000006,  3.68754775281,    53654.67285721279}, 
    {     0.00000000005,  1.77640278232,    79116.90580647459}, 
    {     0.00000000006,  1.22686507612,    51538.81001112419}, 
    {     0.00000000006,  0.36168067626,      422.66603761290}, 
    {     0.00000000005,  4.10167099677,   249268.47945736776}, 
    {     0.00000000005,  2.94751779171,   130962.09312596478}, 
    {     0.00000000006,  2.79032706562,   131491.78409105938}, 
    {     0.00000000006,  5.45598380433,   218916.51067880458}, 
    {     0.00000000005,  5.72733360293,     2324.94940881560}, 
    {     0.00000000005,  1.55205182092,   305060.30925686615}, 
    {     0.00000000006,  1.11542763194,    78373.91574594198}, 
    {     0.00000000005,  0.22456206035,   130514.29730643828}, 
    {     0.00000000005,  6.19195128172,      440.82528487760}, 
    {     0.00000000006,  4.68979746907,    26149.62911631439}, 
    {     0.00000000005,  0.04773374920,   130489.51232977519}, 
    {     0.00000000005,  4.35334090897,   260452.43322486595}, 
    {     0.00000000004,  1.80325861170,   104301.61594439259}, 
    {     0.00000000004,  5.90731736703,    38634.38508065720}, 
    {     0.00000000005,  5.85937874289,    41520.85406638280}, 
    {     0.00000000004,  5.81033465121,    52378.05967832249}, 
    {     0.00000000005,  2.38959621917,    77776.07467346839}, 
    {     0.00000000005,  0.89819672775,    52102.50915728939}, 
    {     0.00000000004,  1.04050915609,   283524.35961235073}, 
    {     0.00000000004,  5.74543005216,    79639.48322456839}, 
    {     0.00000000005,  3.24374045161,    53771.99272543299}, 
    {     0.00000000006,  5.37158640221,    49822.94012937659}, 
    {     0.00000000004,  0.06769738532,     4371.87636677420}, 
    {     0.00000000006,  1.18638011360,   188898.39784101078}, 
    {     0.00000000005,  6.05867525779,    77190.10040053178}, 
    {     0.00000000004,  5.01707452403,   169252.87228422018}, 
    {     0.00000000004,  4.30493132325,   206370.02873972156}, 
    {     0.00000000004,  2.06448884635,   201464.54954099358}, 
    {     0.00000000004,  5.27718401223,    20452.86941222180}, 
    {     0.00000000005,  0.64823272639,   106684.80895916879}, 
    {     0.00000000004,  1.34518506056,    20400.27277262220}, 
    {     0.00000000005,  3.64294402199,    27331.39074325260}, 
    {     0.00000000005,  1.10711421942,    79219.99858069318}, 
    {     0.00000000004,  5.70143283690,   267649.74201698754}, 
    {     0.00000000004,  5.61867141715,    32808.61712091560}, 
    {     0.00000000004,  3.40787680501,    74771.13785785298}, 
    {     0.00000000004,  4.89347322243,    52249.10340900739}, 
    {     0.00000000004,  4.50626285230,    80912.16425019559}, 
    {     0.00000000004,  5.79752206360,   273311.07406613971}, 
    {     0.00000000004,  3.59370702464,    46564.47085590040}, 
    {     0.00000000006,  3.80547114091,    28786.35458895140}, 
    {     0.00000000004,  3.61797134303,   132558.27956824939}, 
    {     0.00000000004,  5.02120058481,   133780.12813457078}, 
    {     0.00000000004,  0.69875295873,    77622.29586298359}, 
    {     0.00000000004,  5.47230241775,    50639.82954017899}, 
    {     0.00000000005,  5.60595541866,   200708.69669056936}, 
    {     0.00000000004,  4.57945769995,    46131.57770177300}, 
    {     0.00000000004,  2.90774078461,    61299.38303816579}, 
    {     0.00000000005,  5.95351319448,    93696.66034953119}, 
    {     0.00000000005,  6.04114354784,    51995.72915286380}, 
    {     0.00000000004,  5.11154568183,   251775.12442162436}, 
    {     0.00000000004,  4.37488020826,   130123.12383821438}, 
    {     0.00000000005,  0.61091062956,   102865.63244523159}, 
    {     0.00000000004,  2.83395761015,   128217.65907327399}, 
    {     0.00000000005,  6.05511428388,    49534.46500467620}, 
    {     0.00000000004,  0.70993360491,    51554.06248230919}, 
    {     0.00000000005,  2.16220422308,    54221.11481595060}, 
    {     0.00000000005,  6.25732449440,    18319.53658487960}, 
    {     0.00000000004,  6.03004085628,    54287.45659652599}, 
    {     0.00000000004,  5.94971817133,    16964.32638655680}, 
    {     0.00000000004,  3.56233707368,    20272.79228193720}, 
    {     0.00000000004,  1.59742075675,    79399.38629661579}, 
    {     0.00000000004,  2.94685386221,    28199.55345495179}, 
    {     0.00000000005,  1.93137641145,    83591.18553310538}, 
    {     0.00000000004,  0.66487328583,   130755.90757752759}, 
    {     0.00000000004,  3.15266411510,   170068.84005193636}, 
    {     0.00000000004,  2.50489173450,   102446.14780135639}, 
    {     0.00000000005,  4.20320779124,   113455.51956041438}, 
    {     0.00000000005,  5.87958723384,    53757.76563143139}, 
    {     0.00000000005,  1.86517289834,    24510.55959912640}, 
    {     0.00000000004,  1.47938914186,    54824.26110862140}, 
    {     0.00000000004,  0.34491990622,    78161.74690645699}, 
    {     0.00000000004,  4.91765582326,    54184.36382230739}, 
    {     0.00000000004,  1.66609260552,    25135.82651831460}, 
    {     0.00000000005,  2.71496730071,    77200.39534127028}, 
    {     0.00000000004,  5.13273546829,    26387.02953584340}, 
    {     0.00000000004,  4.81872093221,    56573.98096972240}, 
    {     0.00000000004,  5.08493147041,     1574.84580128220}, 
    {     0.00000000004,  5.61971860281,    52400.15107885030}, 
    {     0.00000000004,  1.10830702595,    51949.97701473820}, 
    {     0.00000000004,  2.49860728014,   105418.10804348679}, 
    {     0.00000000005,  4.53061477023,   259289.95852045812}, 
    {     0.00000000004,  1.43177381452,    51086.09749195479}, 
    {     0.00000000004,  1.78993265235,    34570.06633485260}, 
    {     0.00000000004,  2.89498773739,     4601.95011896300}, 
    {     0.00000000004,  3.81752951238,    52016.50454835620}, 
    {     0.00000000004,  3.00793368756,    92914.50917930716}, 
    {     0.00000000004,  3.19503794912,    67582.45888815718}, 
    {     0.00000000004,  2.20034975861,    78167.73019750479}, 
    {     0.00000000004,  0.67177464579,    53753.14982559620}, 
    {     0.00000000005,  2.94612400422,     1055.44977692610}, 
    {     0.00000000004,  5.01204521255,    77020.22182304418}, 
    {     0.00000000004,  5.37296944146,   208063.32784627957}, 
    {     0.00000000005,  5.81879633601,    52015.39891376359}, 
    {     0.00000000004,  2.52609846916,    52367.25454925999}, 
    {     0.00000000004,  0.65214215474,   185943.45764729957}, 
    {     0.00000000004,  3.13387849279,   186057.89693598478}, 
    {     0.00000000004,  2.21635240969,   215941.90072419358}, 
    {     0.00000000004,  5.48439088692,   182769.10080150417}, 
    {     0.00000000004,  1.64336565163,   246113.79237247216}
};

 
   
static const struct ln_vsop mercury_longitude_l1[LONG_L1] = {
    { 26087.90313685529,  0.00000000000,        0.00000000000}, 
    {     0.01131199811,  6.21874197797,    26087.90314157420}, 
    {     0.00292242298,  3.04449355541,    52175.80628314840}, 
    {     0.00075775081,  6.08568821653,    78263.70942472259}, 
    {     0.00019676525,  2.80965111777,   104351.61256629678}, 
    {     0.00005119883,  5.79432353574,   130439.51570787099}, 
    {     0.00001336324,  2.47909947012,   156527.41884944518}, 
    {     0.00000352230,  3.05246348628,     1109.37855209340}, 
    {     0.00000350236,  5.43397743985,   182615.32199101939}, 
    {     0.00000093444,  6.11761855456,    27197.28169366760}, 
    {     0.00000090588,  0.00053733031,    24978.52458948080}, 
    {     0.00000092259,  2.09530377053,   208703.22513259358}, 
    {     0.00000051943,  5.62157845897,     5661.33204915220}, 
    {     0.00000044343,  4.57417248957,    25028.52121138500}, 
    {     0.00000027651,  3.03660330131,    51066.42773105500}, 
    {     0.00000021994,  0.86475182160,      955.59974160860}, 
    {     0.00000020378,  3.71392682666,    20426.57109242200}, 
    {     0.00000020226,  0.52020649631,    21535.94964451540}, 
    {     0.00000024445,  5.03171884876,   234791.12827416777}, 
    {     0.00000017507,  5.72782246025,     4551.95349705880}, 
    {     0.00000016673,  1.34980149127,      529.69096509460}, 
    {     0.00000015305,  1.79227510901,    11322.66409830440}, 
    {     0.00000015398,  5.74259119660,       19.66976089979}, 
    {     0.00000013960,  3.59440619771,    24498.83024629040}, 
    {     0.00000013163,  2.71002769534,    53285.18483524180}, 
    {     0.00000012621,  3.89533871193,        3.88133535800}, 
    {     0.00000012503,  4.70133552340,     1059.38193018920}, 
    {     0.00000007967,  4.17175470880,    26617.59410666880}, 
    {     0.00000008012,  3.92669813128,    27043.50288318280}, 
    {     0.00000007703,  0.49609224180,    46514.47423399620}, 
    {     0.00000007496,  2.47774652170,    57837.13833230060}, 
    {     0.00000008388,  6.05157476676,    77154.33087262919}, 
    {     0.00000006840,  2.77393722430,        7.11354700080}, 
    {     0.00000006554,  5.53499608280,     6770.71060124560}, 
    {     0.00000005846,  4.28173811514,    16983.99614745660}, 
    {     0.00000007178,  2.97769079034,     2218.75710418680}, 
    {     0.00000006358,  2.13820928214,    25132.30339996560}, 
    {     0.00000005879,  2.19602452599,    13521.75144159140}, 
    {     0.00000005065,  2.48292263185,    30639.85663863300}, 
    {     0.00000006517,  1.67892400042,   260879.03141574195}, 
    {     0.00000004850,  4.84628981357,    37410.56723987860}, 
    {     0.00000005019,  3.94203732877,    25661.30495069820}, 
    {     0.00000004392,  1.54280887262,    27147.28507176339}, 
    {     0.00000004382,  4.94443288387,      213.29909543800}, 
    {     0.00000004017,  5.52771226937,    83925.04147387479}, 
    {     0.00000004299,  5.08757395593,    10213.28554621100}, 
    {     0.00000004588,  0.82044096381,    25558.21217647960}, 
    {     0.00000003569,  2.34319180460,    32858.61374281979}, 
    {     0.00000003549,  3.59449539427,    26068.23338067440}, 
    {     0.00000004456,  5.79195846107,     3442.57494496540}, 
    {     0.00000003418,  0.49892587318,    22645.32819660879}, 
    {     0.00000003473,  1.39724118346,    77204.32749453338}, 
    {     0.00000003186,  1.25564690041,    14765.23904326980}, 
    {     0.00000003029,  4.45211520724,     7238.67559160000}, 
    {     0.00000002980,  0.13991629145,    50586.73338786459}, 
    {     0.00000003284,  5.23011989016,    25448.00585526019}, 
    {     0.00000002857,  0.67101346147,    26091.78447693220}, 
    {     0.00000003133,  6.21363252783,    26080.78959457339}, 
    {     0.00000002724,  5.64058806769,     1589.07289528380}, 
    {     0.00000002628,  0.87590020075,    52705.49724824299}, 
    {     0.00000002641,  3.52814897103,    72602.37737557039}, 
    {     0.00000003124,  6.07149300722,    28306.66024576099}, 
    {     0.00000002797,  2.51124084505,    26107.57290247399}, 
    {     0.00000002403,  1.15501613908,    25035.63475838580}, 
    {     0.00000002503,  4.35025740225,    41962.52073693740}, 
    {     0.00000002241,  1.84953945797,    36301.18868778519}, 
    {     0.00000002320,  5.44243110370,    26084.02180621620}, 
    {     0.00000002534,  5.80058447871,    26095.01668857500}, 
    {     0.00000002871,  1.63509831596,    25021.40766438420}, 
    {     0.00000002063,  1.07103665169,    43071.89928903080}, 
    {     0.00000001986,  2.95920226047,    23969.13928119580}, 
    {     0.00000002508,  2.76403654972,   103242.23401420339}, 
    {     0.00000001961,  0.83450558631,    12566.15169998280}, 
    {     0.00000001846,  4.42974192764,   103292.23063610759}, 
    {     0.00000001651,  1.25437456685,    33326.57873317420}, 
    {     0.00000001786,  1.81010822680,    26301.20223701220}, 
    {     0.00000001594,  2.26867962790,   110012.94461544899}, 
    {     0.00000001579,  4.61224012719,    53235.18821333759}, 
    {     0.00000001779,  5.17437777314,      426.59819087600}, 
    {     0.00000001601,  5.53140059013,    56727.75978020720}, 
    {     0.00000002099,  5.15770653744,    51220.20654153979}, 
    {     0.00000001590,  0.07655136418,    23869.14603738740}, 
    {     0.00000001748,  4.60419259590,   286966.93455731616}, 
    {     0.00000001593,  4.86694690893,    79373.08797681599}, 
    {     0.00000001525,  3.75842012487,    73711.75592766379}, 
    {     0.00000001358,  1.44570665984,    51646.11531805379}, 
    {     0.00000001324,  1.13417813347,    68050.42387851159}, 
    {     0.00000001345,  3.80182679561,    19317.19254032860}, 
    {     0.00000001242,  3.79390052115,    25874.60404613620}, 
    {     0.00000001132,  1.24723676020,    31749.23519072640}, 
    {     0.00000001259,  1.73164966232,    12432.04265039780}, 
    {     0.00000001035,  4.30505315648,    40853.14218484400}, 
    {     0.00000001010,  3.57886637986,    48733.23133818299}, 
    {     0.00000000981,  0.32956536507,    52156.13652224860}, 
    {     0.00000001031,  3.72181647641,     6283.07584999140}, 
    {     0.00000001015,  4.34316985494,    77734.01845962799}, 
    {     0.00000001143,  2.56497190480,    29530.47808653960}, 
    {     0.00000000976,  5.29476493474,    65697.55772473979}, 
    {     0.00000000849,  4.90682657214,    62389.09182935939}, 
    {     0.00000000861,  0.48881788219,    99799.65906923798}, 
    {     0.00000000872,  4.78830513218,    18849.22754997420}, 
    {     0.00000000849,  3.87015948421,    78793.40038981718}, 
    {     0.00000000855,  0.25155177774,    98690.28051714458}, 
    {     0.00000000809,  2.35162494261,    27676.97603685800}, 
    {     0.00000000756,  3.91466184753,    38654.05484155699}, 
    {     0.00000000777,  3.69099415988,    52179.68761850640}, 
    {     0.00000000741,  0.37372573509,   105460.99111839019}, 
    {     0.00000000744,  2.09528358878,    51535.90899683439}, 
    {     0.00000000736,  6.05485667197,      114.43928868521}, 
    {     0.00000000729,  1.15635861097,   129380.13377768178}, 
    {     0.00000000699,  3.14468277514,    47623.85278608960}, 
    {     0.00000000698,  2.99353080731,    52168.69273614759}, 
    {     0.00000000828,  0.03967891327,    53131.40602475700}, 
    {     0.00000000751,  4.22622963362,    51123.53789995999}, 
    {     0.00000000752,  4.70040857872,    51109.31080595839}, 
    {     0.00000000651,  5.87353892190,     2333.19639287200}, 
    {     0.00000000698,  4.82796933102,    38519.94579197200}, 
    {     0.00000000656,  3.65489167792,    25668.41849769900}, 
    {     0.00000000740,  5.74343325106,   129330.13715577759}, 
    {     0.00000000640,  1.96265162206,    26514.50133245020}, 
    {     0.00000000753,  5.64825867964,    45892.73043315699}, 
    {     0.00000000610,  1.21211116825,      153.77881048480}, 
    {     0.00000000811,  4.22901744472,    25654.19140369739}, 
    {     0.00000000584,  2.65166793147,    76674.63652943878}, 
    {     0.00000000671,  1.88069825702,    77308.10968311399}, 
    {     0.00000000559,  5.26845568234,   136100.84775702319}, 
    {     0.00000000567,  6.08799470543,    25234.70675982219}, 
    {     0.00000000523,  4.17422789646,    94138.32702008578}, 
    {     0.00000000527,  5.83366532230,    50057.04242277000}, 
    {     0.00000000523,  2.45663231877,      467.96499035440}, 
    {     0.00000000526,  2.06863255789,    91785.46086631398}, 
    {     0.00000000697,  2.57166718581,    52182.91983014920}, 
    {     0.00000000523,  1.35829138439,    79323.09135491178}, 
    {     0.00000000554,  3.10829478558,    15874.61759536320}, 
    {     0.00000000546,  2.77273663291,    54394.56338733519}, 
    {     0.00000000491,  0.38994513676,    32370.97899156560}, 
    {     0.00000000505,  2.27352111828,    82815.66292178139}, 
    {     0.00000000586,  5.45833122512,    52195.47604404819}, 
    {     0.00000000616,  4.18181890063,      639.89728631400}, 
    {     0.00000000501,  2.12293246629,    52171.92494779040}, 
    {     0.00000000444,  3.09631644931,    49957.04917896160}, 
    {     0.00000000427,  5.35376808888,       49.99662190420}, 
    {     0.00000000470,  1.23850164176,   313054.83769889036}, 
    {     0.00000000469,  1.46518006720,     1066.49547719000}, 
    {     0.00000000400,  5.24589064914,    58946.51688439399}, 
    {     0.00000000521,  4.92377177140,    52389.10537858640}, 
    {     0.00000000404,  2.49441656744,    71980.63357473118}, 
    {     0.00000000442,  1.05846681262,   103821.92160120218}, 
    {     0.00000000509,  1.03889091502,    24491.71669928959}, 
    {     0.00000000421,  0.36954299695,    51962.50718771040}, 
    {     0.00000000386,  0.92423685606,    77837.11123384659}, 
    {     0.00000000363,  3.08451517102,   131548.89425996438}, 
    {     0.00000000400,  3.51672858608,    20760.42703319140}, 
    {     0.00000000358,  0.02964909169,     2118.76386037840}, 
    {     0.00000000356,  2.03742854569,     1052.26838318840}, 
    {     0.00000000352,  3.49165605975,   125887.56221081219}, 
    {     0.00000000423,  4.21490947326,    18093.37469954999}, 
    {     0.00000000336,  1.55219177388,    24505.94379329119}, 
    {     0.00000000328,  5.45155251381,     7880.08915333899}, 
    {     0.00000000333,  1.04986280945,    66941.04532641819}, 
    {     0.00000000305,  1.70579427712,    79219.30916633119}, 
    {     0.00000000294,  0.89719097618,    63498.47038145279}, 
    {     0.00000000289,  1.66524837037,    88476.99497093359}, 
    {     0.00000000321,  5.58902496814,    55618.38122811380}, 
    {     0.00000000381,  2.16600770844,      522.57741809380}, 
    {     0.00000000389,  0.54659889883,    45405.09568190280}, 
    {     0.00000000305,  1.52082857349,    44937.13069154840}, 
    {     0.00000000275,  3.32813520041,    78244.03966382280}, 
    {     0.00000000266,  0.68060995712,    64741.95798313119}, 
    {     0.00000000288,  4.98360015732,    25551.09862947879}, 
    {     0.00000000260,  5.34007178889,    53764.87917843220}, 
    {     0.00000000255,  4.14975855255,   155468.03691925599}, 
    {     0.00000000264,  0.57786571512,   104881.30353139139}, 
    {     0.00000000266,  3.23724695644,   124778.18365871879}, 
    {     0.00000000265,  1.04240124690,    25938.33994443960}, 
    {     0.00000000242,  0.44807424920,    23754.70674870219}, 
    {     0.00000000222,  0.45066526427,    51116.42435295920}, 
    {     0.00000000218,  5.05361806009,    52602.40447402440}, 
    {     0.00000000211,  5.09174612431,   117873.36400788819}, 
    {     0.00000000282,  3.81278076218,      536.80451209540}, 
    {     0.00000000207,  3.49711450533,    58458.88213313979}, 
    {     0.00000000200,  5.41587372095,    16066.06586147480}, 
    {     0.00000000202,  2.38190671463,    23439.44831610119}, 
    {     0.00000000214,  0.40710565979,    78267.59076008058}, 
    {     0.00000000215,  2.42593080866,   155418.04029735178}, 
    {     0.00000000196,  3.91420687435,   103925.01437542078}, 
    {     0.00000000201,  2.73171980030,    59414.48187474840}, 
    {     0.00000000207,  4.87003667439,   103396.01282468818}, 
    {     0.00000000188,  3.84383993794,    69159.80243060499}, 
    {     0.00000000184,  0.90817110368,   120226.23016165999}, 
    {     0.00000000215,  5.35772672442,      206.18554843720}, 
    {     0.00000000178,  1.25170210270,      103.09277421860}, 
    {     0.00000000186,  1.97860871529,   162188.75089859738}, 
    {     0.00000000183,  2.87999350716,     3328.13565628019}, 
    {     0.00000000195,  0.44655194207,    51756.32163927320}, 
    {     0.00000000217,  4.48208092219,    26241.68195205900}, 
    {     0.00000000215,  2.26829365379,    33967.99229491319}, 
    {     0.00000000200,  1.01165670813,    51742.09454527159}, 
    {     0.00000000179,  1.42332722447,    77197.21394753258}, 
    {     0.00000000223,  0.97930066855,    77211.44104153418}, 
    {     0.00000000193,  5.59216636360,    78270.82297172339}, 
    {     0.00000000162,  5.55703825820,    98068.53671630539}, 
    {     0.00000000161,  5.51813734364,    26555.86813192860}, 
    {     0.00000000197,  4.80011640279,    25455.11940226100}, 
    {     0.00000000173,  4.35603175355,   105307.21230790539}, 
    {     0.00000000158,  2.63936949472,    28421.09953444620}, 
    {     0.00000000163,  2.82189871585,    26202.34243025941}, 
    {     0.00000000154,  2.25328873364,    89586.37352302698}, 
    {     0.00000000155,  5.21123811238,    77623.81213840858}, 
    {     0.00000000195,  1.02146810928,    44181.27784112419}, 
    {     0.00000000187,  4.98586575384,   102762.53967101299}, 
    {     0.00000000179,  5.11429722880,    25440.89230825939}, 
    {     0.00000000152,  5.99106319634,    78256.59587772179}, 
    {     0.00000000164,  4.36120554838,   105410.99449648599}, 
    {     0.00000000184,  0.26387432742,      419.48464387520}, 
    {     0.00000000144,  2.90699736539,    51322.60990139639}, 
    {     0.00000000143,  5.95657669344,   157636.79740153858}, 
    {     0.00000000149,  5.77248289868,    80482.46652890938}, 
    {     0.00000000160,  1.00653088516,    26727.80042788820}, 
    {     0.00000000160,  1.39442186441,    26011.63707029860}, 
    {     0.00000000139,  0.27101064668,    46848.33017476560}, 
    {     0.00000000133,  3.26795404064,    25973.46385288896}, 
    {     0.00000000141,  3.31881997762,    78050.41032928458}, 
    {     0.00000000131,  0.69874834090,     3340.61242669980}, 
    {     0.00000000152,  1.72125145972,    78477.00852016058}, 
    {     0.00000000154,  5.27681182377,   108903.56606335558}, 
    {     0.00000000126,  0.20427766386,   151975.46535238638}, 
    {     0.00000000165,  4.06407630596,   129909.82474277639}, 
    {     0.00000000147,  4.06027405748,    50579.61984086379}, 
    {     0.00000000125,  6.09822754682,    76044.95232053580}, 
    {     0.00000000163,  6.16787830179,    19406.67828817460}, 
    {     0.00000000138,  5.11907374655,      433.71173787680}, 
    {     0.00000000128,  4.15814269417,   339142.74084046457}, 
    {     0.00000000133,  5.23408461673,    26610.48055966799}, 
    {     0.00000000153,  1.29821059795,    13655.86049117640}, 
    {     0.00000000114,  4.61849532926,    50593.84693486539}, 
    {     0.00000000122,  2.53164787291,    76144.94556434419}, 
    {     0.00000000113,  4.51202339397,    27154.39861876420}, 
    {     0.00000000102,  3.96711417536,    26037.90651966999}, 
    {     0.00000000110,  3.45975317150,    25565.32572348040}, 
    {     0.00000000101,  0.11486997352,    74821.13447975718}, 
    {     0.00000000100,  1.88687551078,    85034.42002596818}, 
    {     0.00000000099,  5.98979152528,    29416.03879785439}, 
    {     0.00000000132,  5.44331228630,    51749.20809227239}, 
    {     0.00000000097,  3.01165560161,    28206.66700195260}, 
    {     0.00000000096,  5.22162983089,    85502.38501632259}, 
    {     0.00000000132,  5.94907535629,     1223.81784077861}, 
    {     0.00000000113,  3.55407420407,    71492.99882347698}, 
    {     0.00000000123,  2.05111107086,    78283.37918562238}, 
    {     0.00000000090,  5.94701228084,    25131.61398560359}, 
    {     0.00000000109,  5.03445354966,    78259.82808936459}, 
    {     0.00000000093,  2.31189694942,    81706.28436968799}, 
    {     0.00000000095,  4.68010019254,   114564.89811250778}, 
    {     0.00000000103,  4.05747443320,    93028.94846799239}, 
    {     0.00000000097,  2.65105244357,     9103.90699411760}, 
    {     0.00000000087,  0.84408485633,   181555.94006083018}, 
    {     0.00000000088,  3.70188799404,    90829.86112470538}, 
    {     0.00000000098,  0.52096836281,    26624.70765366959}, 
    {     0.00000000083,  2.12974304987,    42153.96900304900}, 
    {     0.00000000098,  3.31309863421,      853.19638175200}, 
    {     0.00000000081,  1.81824819424,   143961.26714946238}, 
    {     0.00000000084,  5.18245305336,      220.41264243880}, 
    {     0.00000000101,  4.52477254053,    71025.03383312259}, 
    {     0.00000000077,  0.62552658856,   130012.91751699499}, 
    {     0.00000000076,  1.62946702195,    25984.81036735560}, 
    {     0.00000000076,  5.02442522075,   115674.27666460119}, 
    {     0.00000000080,  1.97972400646,      149.56319713460}, 
    {     0.00000000080,  2.03736548887,    79852.78232000639}, 
    {     0.00000000103,  4.71419562154,    12725.45343477500}, 
    {     0.00000000075,  0.26953948526,    84546.78527471398}, 
    {     0.00000000079,  0.04694250450,   104331.94280539699}, 
    {     0.00000000075,  5.08156452710,    27140.17152476259}, 
    {     0.00000000076,  0.97242106203,   131395.11544947959}, 
    {     0.00000000083,  2.04932157543,     1596.18644228460}, 
    {     0.00000000071,  5.07452765154,     1911.19948321720}, 
    {     0.00000000078,  2.06201411500,    26137.89976347840}, 
    {     0.00000000075,  5.47582690516,      134.10904958500}, 
    {     0.00000000070,  3.68283702967,    24609.03656750980}, 
    {     0.00000000070,  1.81758262361,    78690.30761559859}, 
    {     0.00000000082,  3.56719394593,   130969.20667296558}, 
    {     0.00000000069,  1.56209488244,    19804.82729158280}, 
    {     0.00000000081,  6.21759166284,   150866.08680029298}, 
    {     0.00000000079,  1.36891218086,    52329.58509363319}, 
    {     0.00000000063,  1.65140982876,    13541.42120249119}, 
    {     0.00000000068,  4.75308792133,    25881.71759313700}, 
    {     0.00000000061,  3.48595464034,    24925.42843716640}, 
    {     0.00000000063,  1.57827554991,   129483.91596626239}, 
    {     0.00000000078,  3.56226703365,    49842.60989027639}, 
    {     0.00000000062,  5.39835646220,   181505.94343892598}, 
    {     0.00000000061,  3.91406670110,   146314.13330323418}, 
    {     0.00000000059,  2.97195438319,      110.20632121940}, 
    {     0.00000000068,  2.32821809900,    26294.08869001139}, 
    {     0.00000000058,  3.88873694244,    18207.81398823521}, 
    {     0.00000000058,  3.71053330388,    29428.51556827400}, 
    {     0.00000000075,  1.41437208584,   128850.44281258718}, 
    {     0.00000000078,  6.14359232239,    14477.35118320000}, 
    {     0.00000000056,  2.29859296005,   124156.43985787958}, 
    {     0.00000000066,  1.69753750078,    51543.02254383520}, 
    {     0.00000000056,  5.26803267928,    49527.35145767539}, 
    {     0.00000000054,  2.60951368247,   183724.70054311278}, 
    {     0.00000000069,  1.78610678374,    51639.00177105299}, 
    {     0.00000000054,  2.29388731799,    52643.77127350280}, 
    {     0.00000000066,  4.00966591652,   103299.34418310839}, 
    {     0.00000000056,  4.96631677002,   188276.65404017158}, 
    {     0.00000000065,  4.49060152064,      636.99627202420}, 
    {     0.00000000060,  3.40809070256,   104355.49390165479}, 
    {     0.00000000053,  2.32227902289,   104358.72611329758}, 
    {     0.00000000050,  2.13377899787,     7994.52844202420}, 
    {     0.00000000055,  2.95916513077,    40565.25432477420}, 
    {     0.00000000062,  0.58557454545,      307.55762096960}, 
    {     0.00000000047,  1.21556523304,    23976.25282819660}, 
    {     0.00000000060,  3.69214546142,      641.41356173899}, 
    {     0.00000000046,  4.41061598045,   103285.11708910679}, 
    {     0.00000000047,  4.02740344259,    77829.99768684579}, 
    {     0.00000000046,  4.06742204523,    52815.70356946240}, 
    {     0.00000000046,  1.91809870879,    51528.79544983359}, 
    {     0.00000000061,  1.28766566948,    38813.35657634920}, 
    {     0.00000000045,  0.02404887996,   104138.31347085879}, 
    {     0.00000000046,  3.38507597830,    26507.38778544939}, 
    {     0.00000000056,  2.67487495081,    25934.12433108940}, 
    {     0.00000000043,  2.29690412567,    25764.39772491679}, 
    {     0.00000000053,  3.48804345716,    77844.22478084739}, 
    {     0.00000000053,  2.82902106909,     6681.22485339960}, 
    {     0.00000000043,  6.22587772111,    26094.53170047421}, 
    {     0.00000000045,  1.62188507140,       76.26607127560}, 
    {     0.00000000042,  3.85973680463,    10021.83728009940}, 
    {     0.00000000044,  4.79295047779,   104564.91166173479}, 
    {     0.00000000054,  0.75825267175,   155997.72788435058}, 
    {     0.00000000043,  3.21677125258,   178063.36849396059}, 
    {     0.00000000043,  4.90471393771,    24395.73747207180}, 
    {     0.00000000040,  4.13303476978,    26190.99591579279}, 
    {     0.00000000051,  0.49016223108,    23962.02573419499}, 
    {     0.00000000049,  1.06876913146,   131498.89763806018}, 
    {     0.00000000040,  1.47589588843,    76681.75007643958}, 
    {     0.00000000041,  0.46266264380,    25619.93815121980}, 
    {     0.00000000042,  5.68209077980,    54509.00267602040}, 
    {     0.00000000040,  0.39115190758,     1089.70879119360}, 
    {     0.00000000039,  2.75514812039,    25867.49049913539}, 
    {     0.00000000052,  3.69276520556,    39609.65458316560}, 
    {     0.00000000038,  4.64939276647,    90695.75207512038}, 
    {     0.00000000048,  1.65661010519,     1581.95934828300}, 
    {     0.00000000038,  0.95035569681,    76667.52298243798}, 
    {     0.00000000037,  3.99657674443,     9384.84100807520}, 
    {     0.00000000038,  1.84533474277,    27999.10262479140}, 
    {     0.00000000042,  5.85699892180,    52290.24557183361}, 
    {     0.00000000036,  2.82272277217,   102132.85546210999}, 
    {     0.00000000039,  0.16689114463,    22759.76748529401}, 
    {     0.00000000041,  1.21766150084,    64607.84893354619}, 
    {     0.00000000037,  1.88934655832,    26521.61487945100}, 
    {     0.00000000036,  4.75190829106,    39629.32434406539}, 
    {     0.00000000034,  1.73557945245,   111590.28815789679}, 
    {     0.00000000047,  2.00316977982,   134991.46920492979}, 
    {     0.00000000040,  3.07506618678,    26081.27458267419}, 
    {     0.00000000032,  5.94771139984,    77410.51304297059}, 
    {     0.00000000031,  2.67093301110,   104344.49901929598}, 
    {     0.00000000034,  0.29046758495,    97580.90196505119}, 
    {     0.00000000038,  5.08542116385,    25863.55834587229}, 
    {     0.00000000037,  4.28144356206,    39743.76363275060}, 
    {     0.00000000030,  0.64719060865,     2648.45482547300}, 
    {     0.00000000032,  3.88808183601,   157483.01859105378}, 
    {     0.00000000033,  5.37394711310,   102232.84870591838}, 
    {     0.00000000033,  1.96187028937,       74.78159856730}, 
    {     0.00000000033,  0.73726931669,   365230.64398203876}, 
    {     0.00000000030,  2.98247268132,   100909.03762133139}, 
    {     0.00000000031,  0.01609173971,    52061.36699446317}, 
    {     0.00000000030,  1.22842683538,    53242.30176033840}, 
    {     0.00000000029,  5.72086729674,      579.68758699880}, 
    {     0.00000000029,  0.73428938505,    52125.80966124419}, 
    {     0.00000000037,  1.60845101133,      333.85594076940}, 
    {     0.00000000028,  0.41550063520,    35472.74414964940}, 
    {     0.00000000028,  0.53073222303,    50696.93970908399}, 
    {     0.00000000028,  6.11780804536,    25977.69682035479}, 
    {     0.00000000028,  5.95593416963,    54294.57014352679}, 
    {     0.00000000027,  2.00186979186,    52698.38370124219}, 
    {     0.00000000026,  5.31661191916,   107794.18751126219}, 
    {     0.00000000026,  1.60908008816,   141762.17980617538}, 
    {     0.00000000026,  5.92563636648,    35191.81013569180}, 
    {     0.00000000026,  5.05695617382,    26237.46633870879}, 
    {     0.00000000030,  1.96093367442,    26308.31578401300}, 
    {     0.00000000029,  1.40377849854,   140652.80125408198}, 
    {     0.00000000026,  4.47118604310,    78417.48823520739}, 
    {     0.00000000030,  4.35157546455,   154938.34595416138}, 
    {     0.00000000024,  0.08450572691,    51013.33157874059}, 
    {     0.00000000025,  3.61161212347,   156100.82065856918}, 
    {     0.00000000026,  6.02329577077,    25227.59321282139}, 
    {     0.00000000032,  0.29338720910,    51653.22886505459}, 
    {     0.00000000031,  1.27169874011,    97112.93697469679}, 
    {     0.00000000027,  0.43436351538,   116917.76426627958}, 
    {     0.00000000025,  3.56464874860,    52712.61079524379}, 
    {     0.00000000025,  4.83140440999,   170049.17029103659}, 
    {     0.00000000024,  4.15688353859,    19202.75325164339}, 
    {     0.00000000025,  5.22158703638,    25241.82030682300}, 
    {     0.00000000026,  2.09788180403,   103711.71527998279}, 
    {     0.00000000026,  2.73620097953,    27311.72098235281}, 
    {     0.00000000025,  3.31719041454,   110634.68841628819}, 
    {     0.00000000023,  3.42018225470,      956.28915597060}, 
    {     0.00000000024,  4.58737053626,      632.78373931320}, 
    {     0.00000000025,  3.83768999695,   207643.84320240439}, 
    {     0.00000000022,  4.60495557405,    52072.71350892979}, 
    {     0.00000000022,  0.81962371662,      314.18617986960}, 
    {     0.00000000031,  0.78529600723,   119116.85160956658}, 
    {     0.00000000028,  5.28999472918,    26162.68474014150}, 
    {     0.00000000029,  2.32148522569,    26720.68688088739}, 
    {     0.00000000022,  2.40798298166,     8194.27533320860}, 
    {     0.00000000026,  5.94441879648,    95247.70557217918}, 
    {     0.00000000024,  5.01838309036,   105940.68546158058}, 
    {     0.00000000020,  2.47683833264,     2703.61615467560}, 
    {     0.00000000020,  2.55917238627,    51219.51712717779}, 
    {     0.00000000027,  4.25138184607,      647.01083331480}, 
    {     0.00000000020,  3.02046049418,    52182.43484204840}, 
    {     0.00000000021,  4.84549558153,   104778.21075717278}, 
    {     0.00000000019,  3.68979639516,      735.87651353180}, 
    {     0.00000000025,  5.57998927338,    34282.17847478280}, 
    {     0.00000000021,  1.10992644362,   121335.60871375339}, 
    {     0.00000000019,  3.83331533037,     5327.47610838280}, 
    {     0.00000000022,  3.00327681149,   130419.84594697120}, 
    {     0.00000000020,  3.23786060546,     1083.08023229360}, 
    {     0.00000000019,  2.02512845515,    22747.29071487440}, 
    {     0.00000000023,  1.66833589775,   104347.73123093879}, 
    {     0.00000000025,  3.72802716994,      621.74380083920}, 
    {     0.00000000018,  1.62490267654,    48835.19385644859}, 
    {     0.00000000024,  4.88511578720,   104371.28232719658}, 
    {     0.00000000023,  3.20407513183,     6044.22858137540}, 
    {     0.00000000018,  2.74020165764,    55503.94193942859}, 
    {     0.00000000020,  2.16894744006,   106570.36967048359}, 
    {     0.00000000017,  4.26021716269,    24176.70365835700}, 
    {     0.00000000023,  2.89452389903,   176953.98994186718}, 
    {     0.00000000020,  4.62650989512,    13362.44970679920}, 
    {     0.00000000022,  0.13700318671,    26941.09952332620}, 
    {     0.00000000017,  4.53180927338,   155571.81910783658}, 
    {     0.00000000017,  5.27323351022,   150244.34299945379}, 
    {     0.00000000020,  0.88920884923,    52022.02747266360}, 
    {     0.00000000017,  0.66438061926,    44295.71712980940}, 
    {     0.00000000018,  4.22801345450,    78114.14622758799}, 
    {     0.00000000018,  6.10669263205,    26198.10946279360}, 
    {     0.00000000019,  5.88397827824,    32132.13172294960}, 
    {     0.00000000022,  0.27997322515,   157057.10981453978}, 
    {     0.00000000018,  5.25487083597,    68241.87214462319}, 
    {     0.00000000017,  5.12957293922,    27684.08958385880}, 
    {     0.00000000021,  2.44454107206,    24822.33566294780}, 
    {     0.00000000016,  4.30778552752,    50064.15596977079}, 
    {     0.00000000016,  4.85996294185,    77630.92568540938}, 
    {     0.00000000016,  2.24217976098,    26222.01219115920}, 
    {     0.00000000019,  1.94778680051,      487.63475125420}, 
    {     0.00000000017,  0.51733791920,    55516.41870984820}, 
    {     0.00000000019,  2.59562362231,    71582.48457132299}, 
    {     0.00000000016,  4.18243271644,   147423.51185532758}, 
    {     0.00000000015,  0.42980730987,      101.96251826560}, 
    {     0.00000000016,  2.16628656707,    86143.79857806159}, 
    {     0.00000000020,  6.16417051409,    52169.17772424839}, 
    {     0.00000000016,  0.59073234751,   172402.03644480839}, 
    {     0.00000000016,  1.72028680267,    53228.07466633679}, 
    {     0.00000000015,  1.01843035425,    25138.72753260440}, 
    {     0.00000000017,  1.63141160811,   214364.55718174578}, 
    {     0.00000000015,  3.75399093257,      159.30173479220}, 
    {     0.00000000015,  1.95481617109,   207593.84658050018}, 
    {     0.00000000016,  4.96142627268,    52225.80290505260}, 
    {     0.00000000014,  0.95351554243,    96357.08412427259}, 
    {     0.00000000015,  5.76671377675,       14.22709400160}, 
    {     0.00000000014,  5.57769049264,   209812.60368468695}, 
    {     0.00000000014,  0.61729981227,   183570.92173262799}, 
    {     0.00000000017,  5.07627546033,    60055.89543648739}, 
    {     0.00000000016,  2.54178935302,    25780.34552060460}, 
    {     0.00000000014,  4.28355124764,     1692.16566950240}, 
    {     0.00000000015,  5.01473605278,    28791.51929624980}, 
    {     0.00000000013,  0.98344727754,    45290.65639321759}, 
    {     0.00000000013,  4.76112297900,    26164.16921284980}, 
    {     0.00000000017,  1.58612856328,    51969.62073471119}, 
    {     0.00000000015,  5.36372773071,    78731.67441507700}, 
    {     0.00000000013,  5.39542347713,    52381.99183158559}, 
    {     0.00000000013,  4.87338812455,    64901.25971792339}, 
    {     0.00000000017,  2.39131877144,    75615.25459924959}, 
    {     0.00000000017,  0.07084676538,     2199.08734328700}, 
    {     0.00000000012,  1.63509087059,    72936.23331633979}, 
    {     0.00000000013,  0.40053805312,     1162.47470440780}, 
    {     0.00000000014,  0.74485553956,   129387.24732468258}, 
    {     0.00000000016,  5.91696544650,    32769.12799497380}, 
    {     0.00000000013,  4.28055749070,    23866.04650697719}, 
    {     0.00000000012,  0.87706609381,    24292.64469785319}, 
    {     0.00000000013,  2.01208885170,   128320.75184749259}, 
    {     0.00000000013,  1.30119195062,    26724.89941359840}, 
    {     0.00000000012,  1.81653810675,    22909.75735100660}, 
    {     0.00000000014,  3.14098076689,    11610.55195837420}, 
    {     0.00000000011,  5.30288510851,    24601.92302050899}, 
    {     0.00000000013,  3.84039381809,    25953.79409198919}, 
    {     0.00000000011,  0.81162414242,    78903.60671103658}, 
    {     0.00000000013,  3.72512024241,   182085.63102592478}, 
    {     0.00000000011,  5.26526210273,   130446.62925487179}, 
    {     0.00000000011,  1.49242011592,   130652.81480330898}, 
    {     0.00000000014,  2.81964511477,     1639.06951718800}, 
    {     0.00000000013,  4.02613728949,   111122.32316754239}, 
    {     0.00000000011,  2.35461773070,    35077.37084700659}, 
    {     0.00000000011,  2.11106605234,    52250.58788171570}, 
    {     0.00000000011,  5.51868182222,    52808.59002246159}, 
    {     0.00000000013,  3.24055544955,   102018.41617342478}, 
    {     0.00000000013,  0.04071468744,   130443.39704322898}, 
    {     0.00000000014,  4.77952737392,    77726.90491262719}, 
    {     0.00000000013,  5.60037794332,    25446.48957983520}, 
    {     0.00000000011,  0.66633124661,    36109.74042167360}, 
    {     0.00000000010,  4.33936275875,       95.97922721780}, 
    {     0.00000000014,  4.03073574294,   157586.80077963437}, 
    {     0.00000000010,  2.92400898739,   130226.21661243298}, 
    {     0.00000000011,  4.50828985072,    78187.44335344699}, 
    {     0.00000000012,  6.08801478006,    25450.90686955000}, 
    {     0.00000000011,  6.23593133377,   204151.27163553478}, 
    {     0.00000000010,  1.01377621126,    65831.66677432480}, 
    {     0.00000000011,  3.04942272888,      309.27832265580}, 
    {     0.00000000011,  4.87839287541,    54087.00576636560}, 
    {     0.00000000009,  3.68149837141,   199599.31813847595}, 
    {     0.00000000012,  1.94632930172,     1135.67687189320}, 
    {     0.00000000010,  2.75654212398,      103.78218858060}, 
    {     0.00000000009,  5.23889079020,      160.40736938481}, 
    {     0.00000000009,  0.95715458203,   129373.02023068098}, 
    {     0.00000000010,  1.77424642113,    25754.04720080480}, 
    {     0.00000000011,  3.45442974499,    27177.61193276780}, 
    {     0.00000000010,  5.44116629906,    16703.06213349900}, 
    {     0.00000000010,  0.44395632018,    26729.31670331319}, 
    {     0.00000000009,  3.06481394039,    77101.23472031478}, 
    {     0.00000000010,  3.60324717226,    76784.84285065818}, 
    {     0.00000000012,  0.43935234109,   125112.03959948818}, 
    {     0.00000000010,  4.51325369042,   102769.65321801379}, 
    {     0.00000000010,  5.29423372003,     8989.46770543239}, 
    {     0.00000000009,  1.73463346908,      949.17560896980}, 
    {     0.00000000010,  3.39439566279,    25771.51127191760}, 
    {     0.00000000009,  2.00243027457,   133882.09065283638}, 
    {     0.00000000010,  2.40498617897,     3462.24470586520}, 
    {     0.00000000009,  4.39382176626,      224.34479570190}, 
    {     0.00000000010,  5.92210377632,    26404.29501123080}, 
    {     0.00000000008,  3.16962446824,    24079.34560241519}, 
    {     0.00000000008,  5.48696113187,    34082.43158359840}, 
    {     0.00000000008,  1.24488871988,   104275.34649502118}, 
    {     0.00000000008,  0.76238121766,    52101.02468458109}, 
    {     0.00000000008,  1.48210524716,    12546.48193908300}, 
    {     0.00000000008,  0.46458507594,       11.04570026390}, 
    {     0.00000000008,  4.87977464179,    52609.51802102519}, 
    {     0.00000000009,  3.55766276536,   391318.54712361297}, 
    {     0.00000000008,  3.76663108473,    26395.46076254379}, 
    {     0.00000000008,  5.75209002292,    86457.98475793119}, 
    {     0.00000000009,  3.51397928160,    50049.92887576919}, 
    {     0.00000000008,  5.49730957340,    25352.02662804239}, 
    {     0.00000000010,  0.22640990790,   103932.12792242158}, 
    {     0.00000000008,  4.94949508683,     1263.15736257819}, 
    {     0.00000000008,  5.75024943815,    97670.38771289718}, 
    {     0.00000000008,  3.55911690335,    25508.21555457540}, 
    {     0.00000000008,  0.49323679798,   173511.41499690177}, 
    {     0.00000000008,  4.25787691147,    78109.93061423779}, 
    {     0.00000000009,  0.48205382916,   233731.74634397858}, 
    {     0.00000000008,  5.02364007454,    77616.69859140778}, 
    {     0.00000000008,  3.61376880135,    28736.35796704720}, 
    {     0.00000000009,  2.48423459733,    58220.03486452380}, 
    {     0.00000000007,  5.29831732661,    51852.30086649099}, 
    {     0.00000000007,  0.35423551089,   225687.22128005016}, 
    {     0.00000000007,  0.75465996591,   103917.90082841998}, 
    {     0.00000000007,  5.46797664245,    25928.60140678200}, 
    {     0.00000000007,  5.70423964424,   128220.75860368418}, 
    {     0.00000000007,  3.66110166412,   151199.94274106238}, 
    {     0.00000000008,  0.97149572453,   181026.24909573558}, 
    {     0.00000000007,  5.12413207903,    26421.75908234360}, 
    {     0.00000000009,  4.75911094540,    27669.86248985719}, 
    {     0.00000000008,  5.95900851407,      625.67019231240}, 
    {     0.00000000007,  0.32910184643,   179172.74704605396}, 
    {     0.00000000007,  0.91475243663,   104202.04936916218}, 
    {     0.00000000008,  1.54770113018,   196137.07343261078}, 
    {     0.00000000007,  3.01695574126,    70269.18098269838}, 
    {     0.00000000009,  5.83594884566,   203041.89308344138}, 
    {     0.00000000007,  5.10008456774,   233681.74972207438}, 
    {     0.00000000007,  0.14157653167,    51859.41441349179}, 
    {     0.00000000009,  4.93367100659,   161079.37234650398}, 
    {     0.00000000007,  5.75255600320,    53399.62412392700}, 
    {     0.00000000008,  0.35259207804,   102872.74599223239}, 
    {     0.00000000007,  0.34512186024,    54824.26110862140}, 
    {     0.00000000007,  4.05167497620,    53867.97195265079}, 
    {     0.00000000007,  2.69373957868,    52492.19815280499}, 
    {     0.00000000006,  4.72368015481,    74923.09699802278}, 
    {     0.00000000006,  0.36906501806,    26823.77965510599}, 
    {     0.00000000007,  2.60864499567,   229129.79622501558}, 
    {     0.00000000007,  5.03378015347,   159969.99379441059}, 
    {     0.00000000007,  2.21848820219,   235900.50682626116}, 
    {     0.00000000006,  4.20176618520,   130363.24963659538}, 
    {     0.00000000006,  5.89471215179,    84944.93427812219}, 
    {     0.00000000006,  4.91837821889,   102659.44689679438}, 
    {     0.00000000008,  1.09478757087,   192828.60753723037}, 
    {     0.00000000008,  1.86475123525,     2168.76048228260}, 
    {     0.00000000007,  4.68299502093,      838.96928775040}, 
    {     0.00000000006,  1.24133628165,   123554.36581794015}, 
    {     0.00000000006,  1.20512971524,   181659.72224941078}, 
    {     0.00000000007,  3.89067266316,    77795.74443436819}, 
    {     0.00000000006,  5.98763670044,   156314.11975400719}, 
    {     0.00000000006,  3.89399244971,    78188.92782615528}, 
    {     0.00000000006,  5.34622852527,   104984.39630560997}, 
    {     0.00000000006,  2.32335163581,    78896.49316403578}, 
    {     0.00000000006,  1.68227658104,   103718.82882698359}, 
    {     0.00000000006,  2.48458298163,   123758.29085447139}, 
    {     0.00000000006,  5.66247708666,    78580.10129437919}, 
    {     0.00000000006,  6.27477830501,    31415.37924995700}, 
    {     0.00000000007,  3.79210797900,      846.08283475120}, 
    {     0.00000000007,  5.53045913585,      917.93028598180}, 
    {     0.00000000006,  0.38100676678,   182188.72380014337}, 
    {     0.00000000007,  1.25845018875,   128857.55635958798}, 
    {     0.00000000007,  5.96731031430,   156507.74908854539}, 
    {     0.00000000008,  3.49733249703,   259819.64948555276}, 
    {     0.00000000008,  3.80991558396,    99024.13645791399}, 
    {     0.00000000006,  1.45803753709,   101011.00013959699}, 
    {     0.00000000006,  2.51991869762,    79487.52726550119}, 
    {     0.00000000007,  5.27159282206,   126996.94076290558}, 
    {     0.00000000006,  4.53802387387,   156740.71794488319}, 
    {     0.00000000006,  4.38922472191,    38634.38508065720}, 
    {     0.00000000006,  1.24138581934,    78160.61665050399}, 
    {     0.00000000006,  1.96194064026,   176332.24614102798}, 
    {     0.00000000006,  4.50123750445,    78339.97549599818}, 
    {     0.00000000006,  3.99725647445,   130285.73689738619}, 
    {     0.00000000006,  3.69420394003,    78213.71280281838}, 
    {     0.00000000008,  3.17275221265,    77741.13200662879}, 
    {     0.00000000008,  4.42357793667,   166740.70439565618}, 
    {     0.00000000007,  2.50899938142,    78378.14871340781}, 
    {     0.00000000006,  0.43130071950,   104301.61594439259}, 
    {     0.00000000008,  5.01521520904,    52396.21892558720}, 
    {     0.00000000006,  6.09163087172,    51955.39364070959}, 
    {     0.00000000007,  0.91553963150,    25600.26839032000}, 
    {     0.00000000007,  2.89187371967,   230239.17477710896}, 
    {     0.00000000006,  2.03170180629,    76571.54375522019}, 
    {     0.00000000005,  3.91400123749,   130289.95251073639}, 
    {     0.00000000006,  0.99207626768,    50264.60679993120}, 
    {     0.00000000005,  1.59855381219,    90989.16285949759}, 
    {     0.00000000006,  1.01911419114,    26734.91397488900}, 
    {     0.00000000006,  3.17211165890,   123668.80510662538}, 
    {     0.00000000006,  4.74438520416,    48997.66049258080}, 
    {     0.00000000007,  3.22371847471,   183145.01295611398}, 
    {     0.00000000006,  2.90289315925,    61279.71327726600}, 
    {     0.00000000006,  0.00896880815,   103829.03514820298}, 
    {     0.00000000005,  0.00751955508,   149756.70824819959}, 
    {     0.00000000005,  4.51218979337,   137678.19129947099}, 
    {     0.00000000007,  3.68922759436,    81604.32185142238}, 
    {     0.00000000006,  4.26037526854,   104248.51979207818}, 
    {     0.00000000005,  4.39017426465,    65538.25598994759}, 
    {     0.00000000006,  3.23714935766,   208276.62694171758}, 
    {     0.00000000006,  3.25754449540,    27250.37784598199}, 
    {     0.00000000005,  0.50823677768,   417406.45026518717}, 
    {     0.00000000007,  3.25874001817,    48847.67062686820}, 
    {     0.00000000005,  2.79144107928,    51315.49635439559}, 
    {     0.00000000007,  0.15300257128,     2014.98167179780}, 
    {     0.00000000006,  5.45690475475,     1243.48760167840}, 
    {     0.00000000005,  5.63427188169,    51868.24866217880}, 
    {     0.00000000005,  1.31846740403,    94329.77528619739}, 
    {     0.00000000005,  5.08511501937,    51841.95034237900}, 
    {     0.00000000006,  3.24078877347,   130020.03106399579}, 
    {     0.00000000005,  2.39019816175,    77956.15180375299}, 
    {     0.00000000006,  0.09300008200,    75930.51303185058}, 
    {     0.00000000006,  0.57847576593,    26709.64694241340}, 
    {     0.00000000006,  6.02384295193,   104237.17327761157}, 
    {     0.00000000005,  1.17804180960,   104505.39137678158}, 
    {     0.00000000006,  1.53496281816,   130866.11389874699}, 
    {     0.00000000005,  5.47810909806,   149846.19399604558}, 
    {     0.00000000007,  1.59214422735,    50800.03248330259}, 
    {     0.00000000006,  2.37957772692,    80596.90581759460}, 
    {     0.00000000005,  5.20070080185,    78338.49102328988}, 
    {     0.00000000007,  3.70877081633,   145204.75475114079}, 
    {     0.00000000007,  2.08384940658,    52065.59996192899}, 
    {     0.00000000006,  2.82731949689,    52286.01260436779}, 
    {     0.00000000007,  6.09436652634,    81591.84508100279}, 
    {     0.00000000006,  3.54654895094,   198489.93958638258}, 
    {     0.00000000005,  6.14985688293,    79116.90580647459}, 
    {     0.00000000006,  4.85208852587,    91805.13062721379}, 
    {     0.00000000006,  3.78495993627,   207114.15223730978}, 
    {     0.00000000005,  4.00009786605,    51226.63067417859}, 
    {     0.00000000007,  4.56758670190,   156954.01704032118}, 
    {     0.00000000005,  3.75488202656,   155475.15046625677}, 
    {     0.00000000007,  4.71928298002,   158116.49174472898}, 
    {     0.00000000006,  6.24134016928,   209232.91609768818}, 
    {     0.00000000006,  0.35400062059,   208173.53416749898}, 
    {     0.00000000006,  0.05507363760,   136722.59155786238}, 
    {     0.00000000005,  6.03052619166,    50167.24874398939}, 
    {     0.00000000005,  2.79008591575,   154194.22245657316}, 
    {     0.00000000006,  1.87811621270,    80174.90890793978}, 
    {     0.00000000006,  4.20369832735,   123200.84011627098}, 
    {     0.00000000005,  3.51935800778,   209658.82487420218}, 
    {     0.00000000005,  1.86237962806,   259769.65286364855}, 
    {     0.00000000005,  1.05147991932,    27780.06881107659}, 
    {     0.00000000005,  1.07470529653,    76152.05911134499}, 
    {     0.00000000005,  5.15226478485,   261988.40996783535}, 
    {     0.00000000005,  1.28225132870,    39450.35284837340}, 
    {     0.00000000006,  3.39529287695,   143005.66740785378}, 
    {     0.00000000005,  2.74556405934,    51329.72344839720}, 
    {     0.00000000006,  5.93028775117,     1478.86657406440}, 
    {     0.00000000005,  4.03764312401,    78153.50310350319}, 
    {     0.00000000007,  0.41429504672,   137210.22630911658}, 
    {     0.00000000007,  1.33294768928,     1731.12235293260}, 
    {     0.00000000006,  4.97923764806,   202420.14928260217}, 
    {     0.00000000006,  4.74759480967,    26575.53789282839}, 
    {     0.00000000005,  2.53784371972,   154308.66174525839}, 
    {     0.00000000005,  1.76156503657,    78484.12206716138}, 
    {     0.00000000005,  0.25034623664,    78800.51393681798}, 
    {     0.00000000005,  5.51979105321,    50910.23880452200}, 
    {     0.00000000006,  2.79878095447,   182595.65223011958}, 
    {     0.00000000005,  2.18860356832,    42790.96527507320}, 
    {     0.00000000005,  0.55904094194,     2383.19301477620}, 
    {     0.00000000005,  5.27380977719,    52309.91533273340}, 
    {     0.00000000005,  1.99514162070,   156534.53239644598}, 
    {     0.00000000005,  3.08962146646,    77947.31755506598}, 
    {     0.00000000005,  2.53115311032,    80382.47328510099}, 
    {     0.00000000006,  0.72483599766,   183674.70392120858}, 
    {     0.00000000006,  5.87094389034,   129586.31932611899}, 
    {     0.00000000004,  3.38538707199,   174620.79354899516}, 
    {     0.00000000005,  1.69610535490,   189386.03259226495}, 
    {     0.00000000005,  4.44041391120,   127098.90328117118}, 
    {     0.00000000005,  1.91636184492,    52325.36948028299}, 
    {     0.00000000004,  4.33627478046,       89.48574784600}, 
    {     0.00000000005,  2.78454061573,   103498.41618454478}, 
    {     0.00000000005,  2.80022335340,     4437.51420837359}, 
    {     0.00000000006,  4.57903777326,   240452.46032331996}, 
    {     0.00000000005,  1.82284966431,     1884.90116341740}, 
    {     0.00000000004,  3.54115739914,    70383.62027138360}, 
    {     0.00000000006,  4.44862307428,    78057.52387628538}, 
    {     0.00000000005,  5.60499626286,    87253.17713015496}, 
    {     0.00000000004,  0.60639839734,    77314.53381575279}, 
    {     0.00000000006,  3.07379721651,   156531.30018480319}, 
    {     0.00000000005,  3.05321446236,    78257.08086582259}, 
    {     0.00000000004,  1.72880081184,     2111.65031337760}, 
    {     0.00000000005,  5.08493502101,   112231.70171963578}, 
    {     0.00000000004,  3.17961386708,   107679.74822257696}, 
    {     0.00000000004,  0.99061214587,   153084.84390447979}, 
    {     0.00000000004,  2.65750466453,    92741.06060792258}, 
    {     0.00000000004,  0.58713530175,      323.50541665740}, 
    {     0.00000000004,  3.71119398255,    26411.40855823160}, 
    {     0.00000000004,  5.18520847948,    77307.42026875199}, 
    {     0.00000000005,  0.32192884992,   103127.79472551816}, 
    {     0.00000000004,  4.23880044095,   207747.62539098498}, 
    {     0.00000000004,  3.32663238546,   104888.41707839219}, 
    {     0.00000000005,  5.64530641830,   106470.37642667518}, 
    {     0.00000000004,  0.76539963317,   142871.55835826878}, 
    {     0.00000000004,  5.77831885615,    25466.15934073500}, 
    {     0.00000000005,  4.50048062606,   222224.97657418498}, 
    {     0.00000000005,  0.43033089417,   107692.22499299659}, 
    {     0.00000000005,  1.77942359129,    24356.78078864160}, 
    {     0.00000000004,  0.27323680716,    52278.89905736699}, 
    {     0.00000000004,  0.98450071759,   130459.18546877075}, 
    {     0.00000000004,  0.22797244893,    26247.20487636640}, 
    {     0.00000000005,  6.27987613458,    74935.57376844239}, 
    {     0.00000000005,  2.73561601564,    51538.81001112419}, 
    {     0.00000000004,  4.52036588311,   163298.12945069079}, 
    {     0.00000000004,  1.46002058771,      935.92998070881}, 
    {     0.00000000005,  4.66040678637,   102755.42612401219}, 
    {     0.00000000004,  3.44653657726,    43981.53094993980}, 
    {     0.00000000004,  4.04811362371,    50380.54783942739}, 
    {     0.00000000004,  0.10638912543,       38.13303563780}, 
    {     0.00000000004,  4.61058187343,   118828.96374949679}, 
    {     0.00000000004,  2.75690095352,   144916.86689107098}, 
    {     0.00000000005,  5.65870377214,     1300.82681820500}, 
    {     0.00000000004,  4.38451994728,   167850.08294774959}, 
    {     0.00000000004,  0.90103901385,    24864.08530079559}, 
    {     0.00000000004,  4.23072497017,   130593.29451835579}, 
    {     0.00000000004,  6.07315852038,    78270.33798362259}, 
    {     0.00000000004,  0.80000960641,     1485.29070670320}, 
    {     0.00000000004,  4.09184420375,    79330.20490191258}, 
    {     0.00000000004,  5.92521638136,   104344.98400739678}, 
    {     0.00000000004,  0.50584296046,    17893.62780836560}, 
    {     0.00000000005,  4.15661237129,    61560.64729122359}, 
    {     0.00000000004,  1.86779221331,   104874.18998439058}, 
    {     0.00000000004,  2.38956841519,    51534.39272140940}, 
    {     0.00000000004,  4.95493599731,   101703.15774082378}, 
    {     0.00000000004,  1.02712382423,   193937.98608932378}, 
    {     0.00000000004,  1.73223710668,   187167.27548807819}, 
    {     0.00000000004,  0.71864596336,      164.43591058941}, 
    {     0.00000000004,  4.71994756800,   215473.93573383916}, 
    {     0.00000000004,  0.86915287934,   104276.83096772949}, 
    {     0.00000000005,  0.18360546450,   169093.57054942798}, 
    {     0.00000000004,  1.68517945931,   103704.60173298199}, 
    {     0.00000000004,  3.31690695818,   234261.43730907318}, 
    {     0.00000000004,  5.30812522197,   130432.40216087017}, 
    {     0.00000000004,  4.71379720816,   129806.73196855778}, 
    {     0.00000000004,  1.51496580365,    99979.73619952259}, 
    {     0.00000000004,  2.71144440911,     4083.98850670440}, 
    {     0.00000000004,  2.79035446022,   104358.24112519680}, 
    {     0.00000000004,  3.72751712279,   209762.60706278277}, 
    {     0.00000000005,  1.29231046489,   266540.36346489414}, 
    {     0.00000000004,  5.59214940732,   104466.05185498200}, 
    {     0.00000000004,  4.67135290282,   154408.65498906678}, 
    {     0.00000000004,  0.18672297599,    76137.83201734339}, 
    {     0.00000000004,  4.03785678727,    52822.81711646319}, 
    {     0.00000000004,  6.06255798891,   103189.13786188899}, 
    {     0.00000000004,  3.25792439793,    28286.99048486120}, 
    {     0.00000000004,  6.26318566840,   156107.93420556998}, 
    {     0.00000000003,  2.12202622054,    78469.89497315978}, 
    {     0.00000000004,  6.24222910156,    52595.29092702359}, 
    {     0.00000000003,  4.35697420988,    52812.80255517260}, 
    {     0.00000000003,  1.97566398707,   138319.60486120995}, 
    {     0.00000000004,  0.47445141807,   171292.65789271498}, 
    {     0.00000000003,  1.85052127026,    54879.42243782400}, 
    {     0.00000000004,  4.19697241788,   130435.63437251298}, 
    {     0.00000000004,  2.99013118992,    78149.27013603736}, 
    {     0.00000000004,  1.59255142342,   103814.80805420138}, 
    {     0.00000000003,  1.97075256428,   104426.39416486409}, 
    {     0.00000000003,  4.71189048263,   195047.36464141717}, 
    {     0.00000000004,  6.27859532373,   234364.53008329177}, 
    {     0.00000000004,  0.28730856803,   233202.05537888398}, 
    {     0.00000000004,  5.94325529240,    20043.67456019880}, 
    {     0.00000000004,  1.12779733765,   139543.42270198859}, 
    {     0.00000000003,  3.00327186987,   155887.52156313117}, 
    {     0.00000000004,  2.10267022472,   104819.57755665119}, 
    {     0.00000000004,  1.77647068401,   132028.58860315479}, 
    {     0.00000000004,  0.24214782588,   224577.84272795678}, 
    {     0.00000000004,  4.79211826277,    79315.97780791098}, 
    {     0.00000000003,  1.77481925226,    53771.99272543299}, 
    {     0.00000000004,  4.24020912823,   156547.08861034496}, 
    {     0.00000000004,  5.44046981103,   106684.80895916879}, 
    {     0.00000000004,  0.35504698785,    27044.19229754480}, 
    {     0.00000000003,  3.15293616281,   195181.47369100217}, 
    {     0.00000000003,  4.31718868652,    57503.28239153120}, 
    {     0.00000000003,  2.68109664026,    58857.03113654799}, 
    {     0.00000000003,  3.65528504142,    66653.15746634839}, 
    {     0.00000000003,  0.88720012673,   105418.10804348679}, 
    {     0.00000000003,  0.47019728706,   181563.05360783098}, 
    {     0.00000000003,  5.67402424686,    61165.27398858079}, 
    {     0.00000000003,  2.67128283641,    24998.19435038059}, 
    {     0.00000000003,  3.80325286994,    26402.08932144380}, 
    {     0.00000000003,  1.32004244110,    26312.24793727610}, 
    {     0.00000000003,  0.57514622273,   156377.85565231058}, 
    {     0.00000000003,  4.10353520436,   218916.51067880458}, 
    {     0.00000000003,  3.63684349571,    26073.67604757259}, 
    {     0.00000000004,  5.49029205076,     2125.87740737920}, 
    {     0.00000000003,  0.83452068925,   149288.74325784518}, 
    {     0.00000000003,  0.99067389256,   104197.83375581198}, 
    {     0.00000000003,  3.16251732649,    53029.00266490040}, 
    {     0.00000000003,  3.95355121933,    91919.56991589899}, 
    {     0.00000000003,  6.17342775574,    37698.45509994840}, 
    {     0.00000000004,  3.89947841403,    53906.92863608099}, 
    {     0.00000000003,  4.11078389229,   155460.92337225519}, 
    {     0.00000000003,  0.87067834834,   181548.82651382938}, 
    {     0.00000000003,  1.57982618450,   104501.17576343138}, 
    {     0.00000000003,  4.12548682099,    71378.55953479178}, 
    {     0.00000000003,  1.52477907436,    78366.80219894118}, 
    {     0.00000000003,  0.87753609725,     3178.14579056760}, 
    {     0.00000000003,  6.07282705878,    50483.64061364600}, 
    {     0.00000000003,  4.43072727499,    50007.04580086580}, 
    {     0.00000000004,  5.32328931391,   129799.61842155698}, 
    {     0.00000000003,  1.48103473704,    53757.76563143139}, 
    {     0.00000000004,  0.00252046526,   103883.64757594238}, 
    {     0.00000000003,  4.53573697740,   129902.71119577558}, 
    {     0.00000000003,  4.81232864254,    79859.89586700719}, 
    {     0.00000000003,  1.66108176894,    78697.42116259939}, 
    {     0.00000000003,  1.84684752446,   288076.31310940956}, 
    {     0.00000000003,  4.82712248849,    25991.92391435639}, 
    {     0.00000000003,  2.39725254140,   156520.30530244438}, 
    {     0.00000000003,  0.93947739163,    26183.88236879199}, 
    {     0.00000000003,  0.70521684460,    23384.28698689860}, 
    {     0.00000000003,  0.97960195128,   156681.19765992998}, 
    {     0.00000000003,  4.71243430522,    76887.93562487679}, 
    {     0.00000000003,  3.82703641143,   130005.80396999417}, 
    {     0.00000000003,  4.79848480761,    27223.58001346740}, 
    {     0.00000000003,  3.56807161466,    26189.86565983980}, 
    {     0.00000000003,  5.49802214625,    87367.61641884019}, 
    {     0.00000000004,  3.04198191749,   162810.49469943657}, 
    {     0.00000000003,  5.99674961720,   231348.55332920236}, 
    {     0.00000000003,  2.33106741466,    51439.92976961659}, 
    {     0.00000000003,  2.61733694893,   130432.88714897096}, 
    {     0.00000000002,  5.22176508298,    78786.28684281638}, 
    {     0.00000000003,  4.88028231088,   132658.27281205778}, 
    {     0.00000000003,  0.90903803463,    24952.22626968100}, 
    {     0.00000000003,  4.44359777408,     6885.14988993081}, 
    {     0.00000000002,  0.09332198439,    54374.89362643540}, 
    {     0.00000000002,  1.50420025300,    52252.07235442399}, 
    {     0.00000000003,  0.62857388379,    77039.89158394396}, 
    {     0.00000000002,  3.69661372368,    45494.58142974879}, 
    {     0.00000000003,  1.28130112897,   156523.53751408719}, 
    {     0.00000000003,  3.10706736688,    53132.09543911899}, 
    {     0.00000000002,  2.39688673711,    52137.67324751059}, 
    {     0.00000000003,  6.03996003965,   188898.39784101078}, 
    {     0.00000000003,  1.12896001904,   102975.83876645098}, 
    {     0.00000000003,  1.06608582202,   128843.32926558638}, 
    {     0.00000000003,  2.04617498651,    51707.84129279399}, 
    {     0.00000000002,  4.71560069328,   164407.50800278416}, 
    {     0.00000000002,  2.70764577076,   182402.02289558138}, 
    {     0.00000000002,  2.82013540933,    63786.35824152260}, 
    {     0.00000000002,  2.54951394512,    25985.94062330859}, 
    {     0.00000000003,  0.19858896817,    53265.51507434200}, 
    {     0.00000000003,  4.34325432962,   168959.46149984296}, 
    {     0.00000000003,  3.74410347667,    62197.64356324779}, 
    {     0.00000000002,  0.52642258950,   171004.77003264519}, 
    {     0.00000000003,  2.31120031707,    26013.12154300690}, 
    {     0.00000000003,  5.59058462965,   180396.56488683258}, 
    {     0.00000000002,  2.51510994796,    26667.59072857300}, 
    {     0.00000000003,  1.48135858208,   105403.88094948517}, 
    {     0.00000000002,  1.09140996130,   180496.55813064099}, 
    {     0.00000000003,  1.22647733767,   248312.87971575916}, 
    {     0.00000000002,  0.36339757941,    96471.52341295779}, 
    {     0.00000000002,  1.35408345025,    23919.14265929160}, 
    {     0.00000000003,  2.80629290854,    78043.29678228378}, 
    {     0.00000000002,  3.31876051250,   205260.65018762815}, 
    {     0.00000000002,  0.20681692579,    51596.11869614960}, 
    {     0.00000000002,  1.53176493082,   158746.17595363196}, 
    {     0.00000000002,  1.48023064256,   184204.39488630318}, 
    {     0.00000000003,  1.49887007773,   106262.81204951399}, 
    {     0.00000000003,  5.05636989583,   130907.48069822539}, 
    {     0.00000000003,  0.54238316070,    52041.69723356339}, 
    {     0.00000000003,  5.75431374896,   130446.14426677099}, 
    {     0.00000000002,  2.93093373409,   159855.55450572536}, 
    {     0.00000000002,  3.56437176463,    52797.55008398759}, 
    {     0.00000000002,  2.62047980540,    78683.19406859778}, 
    {     0.00000000002,  2.11384955087,    25773.71696170459}, 
    {     0.00000000002,  4.15782415140,    52400.15107885030}, 
    {     0.00000000002,  5.89562175995,   133767.65136415116}, 
    {     0.00000000002,  1.35665861508,   183041.92018189539}, 
    {     0.00000000002,  0.11609465401,    27170.98337386779}, 
    {     0.00000000002,  3.03178665319,   112545.88789950538}, 
    {     0.00000000002,  4.10556118800,   113455.51956041438}, 
    {     0.00000000002,  2.14271307715,    51951.46148744649}, 
    {     0.00000000002,  1.68546478089,    78313.70604662679}, 
    {     0.00000000003,  6.19908560971,    25004.82290928060}, 
    {     0.00000000002,  2.84045476324,   155303.60100866656}, 
    {     0.00000000002,  2.26145864726,    76998.14194609619}, 
    {     0.00000000002,  4.74126987497,   213255.17862965238}, 
    {     0.00000000002,  2.40187436652,    52509.66222391780}, 
    {     0.00000000002,  0.23208171234,    24448.83362438620}, 
    {     0.00000000002,  2.50290073656,    26102.13023557580}, 
    {     0.00000000002,  1.36349447497,   234798.24182116857}, 
    {     0.00000000002,  2.02736374318,    60170.33472517260}, 
    {     0.00000000002,  3.57423748725,   175730.17210108857}, 
    {     0.00000000002,  2.55875179877,    76255.15188556358}, 
    {     0.00000000002,  5.00767344604,    50444.68393021580}, 
    {     0.00000000002,  4.87112232665,    78413.27262185719}, 
    {     0.00000000003,  5.80075910765,    78373.91574594198}, 
    {     0.00000000002,  3.44901114128,   251775.12442162436}, 
    {     0.00000000002,  5.01117672779,   182622.43553802017}, 
    {     0.00000000002,  5.77978141973,    77403.39949596979}, 
    {     0.00000000002,  2.01783291860,    78397.81847430758}, 
    {     0.00000000002,  1.16361857643,   104145.42701785959}, 
    {     0.00000000002,  0.28513369746,   235746.72801577636}, 
    {     0.00000000002,  0.47269960302,   156093.70711156838}, 
    {     0.00000000002,  3.62048919482,    17098.43543614181}, 
    {     0.00000000002,  0.12909617158,    52161.57918914679}, 
    {     0.00000000002,  2.17258312431,   308502.88420183153}
};



static const struct ln_vsop mercury_longitude_l2[LONG_L2] = {
    {     0.00016395129,  4.67759555504,    26087.90314157420}, 
    {     0.00008123865,  1.40305644134,    52175.80628314840}, 
    {     0.00003208170,  4.49577853102,    78263.70942472259}, 
    {     0.00001128209,  1.27901273779,   104351.61256629678}, 
    {     0.00000877186,  3.14159265359,        0.00000000000}, 
    {     0.00000371058,  4.31735787338,   130439.51570787099}, 
    {     0.00000116931,  1.04943307731,   156527.41884944518}, 
    {     0.00000035802,  4.04587257390,   182615.32199101939}, 
    {     0.00000014897,  4.63345988506,     1109.37855209340}, 
    {     0.00000010747,  0.74352925179,   208703.22513259358}, 
    {     0.00000005244,  4.71804553686,    24978.52458948080}, 
    {     0.00000003182,  3.71128464182,   234791.12827416777}, 
    {     0.00000002547,  1.43801901419,    27197.28169366760}, 
    {     0.00000002033,  1.49538090708,    51066.42773105500}, 
    {     0.00000000972,  1.80406148095,      955.59974160860}, 
    {     0.00000000933,  0.38508064082,   260879.03141574195}, 
    {     0.00000000628,  6.18336027299,      529.69096509460}, 
    {     0.00000000628,  4.84993612548,    24498.83024629040}, 
    {     0.00000000748,  4.53886632656,    77154.33087262919}, 
    {     0.00000000652,  0.98244103623,     5661.33204915220}, 
    {     0.00000000570,  5.93087624804,    25028.52121138500}, 
    {     0.00000000554,  2.13567295803,    20426.57109242200}, 
    {     0.00000000508,  4.11405647413,     4551.95349705880}, 
    {     0.00000000608,  4.54161712968,     2218.75710418680}, 
    {     0.00000000439,  3.40841487365,    11322.66409830440}, 
    {     0.00000000383,  2.84041448501,    26617.59410666880}, 
    {     0.00000000371,  0.82325076093,     6770.71060124560}, 
    {     0.00000000321,  5.20252163124,    46514.47423399620}, 
    {     0.00000000310,  3.21458500897,     1059.38193018920}, 
    {     0.00000000332,  0.97193908732,    25132.30339996560}, 
    {     0.00000000328,  2.23586205224,    21535.94964451540}, 
    {     0.00000000303,  4.67984690863,    27043.50288318280}, 
    {     0.00000000272,  3.33112990946,   286966.93455731616}, 
    {     0.00000000247,  5.87790567404,    16983.99614745660}, 
    {     0.00000000311,  4.22425838013,     3442.57494496540}, 
    {     0.00000000237,  4.37072058392,      114.43928868521}, 
    {     0.00000000230,  0.93160807269,    30639.85663863300}, 
    {     0.00000000264,  1.28267621568,   103242.23401420339}, 
    {     0.00000000209,  3.30050747071,      213.29909543800}, 
    {     0.00000000197,  2.07978399454,    22645.32819660879}, 
    {     0.00000000175,  6.23699804715,    27147.28507176339}, 
    {     0.00000000182,  0.62557819405,    25448.00585526019}, 
    {     0.00000000219,  1.34273602039,    28306.66024576099}, 
    {     0.00000000155,  3.92088824161,    32858.61374281979}, 
    {     0.00000000161,  5.79480893327,    52705.49724824299}, 
    {     0.00000000153,  4.33625862893,     1589.07289528380}, 
    {     0.00000000160,  4.80006144385,    23869.14603738740}, 
    {     0.00000000149,  1.98766674679,    72602.37737557039}, 
    {     0.00000000146,  5.95917025706,    14765.23904326980}, 
    {     0.00000000129,  4.15874670686,    23969.13928119580}, 
    {     0.00000000135,  3.86681741058,    51220.20654153979}, 
    {     0.00000000141,  3.66926746092,    25558.21217647960}, 
    {     0.00000000113,  3.90421550560,    83925.04147387479}, 
    {     0.00000000108,  1.38888153019,    50586.73338786459}, 
    {     0.00000000115,  0.15119470114,    26301.20223701220}, 
    {     0.00000000119,  3.62238641476,    53285.18483524180}, 
    {     0.00000000098,  3.99032605577,    56727.75978020720}, 
    {     0.00000000094,  2.05358227305,    26068.23338067440}, 
    {     0.00000000102,  0.85715423056,    57837.13833230060}, 
    {     0.00000000086,  3.04235521268,    53235.18821333759}, 
    {     0.00000000104,  5.32353970232,     7238.67559160000}, 
    {     0.00000000088,  4.29297146473,   129330.13715577759}, 
    {     0.00000000096,  2.24007027333,    19317.19254032860}, 
    {     0.00000000099,  0.99982390475,    29530.47808653960}, 
    {     0.00000000079,  6.26974865489,   313054.83769889036}, 
    {     0.00000000075,  5.40697085015,    26091.78447693220}, 
    {     0.00000000074,  4.30770581759,     2333.19639287200}, 
    {     0.00000000081,  0.96615031171,    26107.57290247399}, 
    {     0.00000000068,  0.70236298544,   110012.94461544899}, 
    {     0.00000000084,  3.28239679269,    12432.04265039780}, 
    {     0.00000000069,  3.55775707713,    13521.75144159140}, 
    {     0.00000000077,  0.27361110210,    37410.56723987860}, 
    {     0.00000000066,  5.08814197377,    79373.08797681599}, 
    {     0.00000000064,  2.75924146152,    40853.14218484400}, 
    {     0.00000000067,  3.89692983127,    26084.02180621620}, 
    {     0.00000000062,  5.77595948720,    12566.15169998280}, 
    {     0.00000000062,  2.68303226418,    43071.89928903080}, 
    {     0.00000000068,  3.44188386122,    10213.28554621100}, 
    {     0.00000000059,  0.86974939194,    53131.40602475700}, 
    {     0.00000000061,  0.16326480892,    36301.18868778519}, 
    {     0.00000000062,  5.03081926384,    98690.28051714458}, 
    {     0.00000000063,  2.49283930330,    78793.40038981718}, 
    {     0.00000000055,  1.00982472538,    27676.97603685800}, 
    {     0.00000000054,  1.15894540115,    26202.34243025941}, 
    {     0.00000000052,  1.55698657263,    49957.04917896160}, 
    {     0.00000000051,  5.13863384999,    52156.13652224860}, 
    {     0.00000000050,  1.60202945983,    25234.70675982219}, 
    {     0.00000000053,  2.66625298995,   103292.23063610759}, 
    {     0.00000000052,  0.53816996194,    77308.10968311399}, 
    {     0.00000000053,  5.48671975064,    25661.30495069820}, 
    {     0.00000000047,  5.18449121077,    48733.23133818299}, 
    {     0.00000000054,  5.50628728318,    77204.32749453338}, 
    {     0.00000000045,  4.98425073175,    25973.46385288896}, 
    {     0.00000000049,  0.54622585936,    51646.11531805379}, 
    {     0.00000000053,  0.33861329992,    25874.60404613620}, 
    {     0.00000000041,  2.21595927672,    52179.68761850640}, 
    {     0.00000000041,  2.78727398693,    41962.52073693740}, 
    {     0.00000000036,  5.03373039765,    26080.78959457339}, 
    {     0.00000000037,  5.80421105052,    68050.42387851159}, 
    {     0.00000000039,  0.07497517201,    38519.94579197200}, 
    {     0.00000000035,  3.29702164337,    62389.09182935939}, 
    {     0.00000000043,  3.24027622244,    52389.10537858640}, 
    {     0.00000000042,  2.42467105416,      639.89728631400}, 
    {     0.00000000037,  6.10413466135,    79323.09135491178}, 
    {     0.00000000038,  0.75728548339,    82815.66292178139}, 
    {     0.00000000039,  5.83856275214,    31749.23519072640}, 
    {     0.00000000033,  2.45594764622,    38654.05484155699}, 
    {     0.00000000040,  1.13429314401,    51116.42435295920}, 
    {     0.00000000041,  4.30596946224,    26095.01668857500}, 
    {     0.00000000040,  3.14916876711,      426.59819087600}, 
    {     0.00000000039,  1.79865756533,    33326.57873317420}, 
    {     0.00000000031,  5.81703678643,   129380.13377768178}, 
    {     0.00000000032,  3.75967831149,   136100.84775702319}, 
    {     0.00000000031,  0.71579629690,    50057.04242277000}, 
    {     0.00000000034,  4.04941185304,    55618.38122811380}, 
    {     0.00000000030,  1.57910338320,    52168.69273614759}, 
    {     0.00000000031,  0.09729309307,    47623.85278608960}, 
    {     0.00000000029,  3.72168845249,    51535.90899683439}, 
    {     0.00000000039,  4.04661946156,    52195.47604404819}, 
    {     0.00000000038,  3.74329013991,    18849.22754997420}, 
    {     0.00000000030,  0.74969213513,     7880.08915333899}, 
    {     0.00000000028,  1.00979692149,   155418.04029735178}, 
    {     0.00000000033,  5.78833433505,    18093.37469954999}, 
    {     0.00000000033,  0.72168395673,    52171.92494779040}, 
    {     0.00000000034,  5.29277111978,    45405.09568190280}, 
    {     0.00000000025,  5.17302047914,    99799.65906923798}, 
    {     0.00000000029,  4.27878688840,    54394.56338733519}, 
    {     0.00000000023,  2.91420022643,   339142.74084046457}, 
    {     0.00000000029,  3.06502211848,    77734.01845962799}, 
    {     0.00000000029,  1.05041966879,    52182.91983014920}, 
    {     0.00000000023,  5.05463364253,     2118.76386037840}, 
    {     0.00000000025,  5.79963493025,    66941.04532641819}, 
    {     0.00000000022,  2.60637985278,    94138.32702008578}, 
    {     0.00000000023,  2.16401194556,    73711.75592766379}, 
    {     0.00000000025,  0.08404534895,    26514.50133245020}, 
    {     0.00000000021,  4.43708040700,     3328.13565628019}, 
    {     0.00000000020,  1.08338958579,    28421.09953444620}, 
    {     0.00000000020,  1.88500536861,    78244.03966382280}, 
    {     0.00000000023,  1.77623772399,   124778.18365871879}, 
    {     0.00000000023,  5.48177653849,   104881.30353139139}, 
    {     0.00000000021,  3.97578154158,    53764.87917843220}, 
    {     0.00000000018,  3.51290465186,   103396.01282468818}, 
    {     0.00000000019,  1.96045370871,    23754.70674870219}, 
    {     0.00000000018,  2.89112115044,     6283.07584999140}, 
    {     0.00000000016,  4.59238950011,    76044.95232053580}, 
    {     0.00000000019,  3.14667729625,    51109.31080595839}, 
    {     0.00000000018,  5.83387936093,    32370.97899156560}, 
    {     0.00000000016,  0.09294518979,    88476.99497093359}, 
    {     0.00000000015,  5.46245475561,    64741.95798313119}, 
    {     0.00000000016,  0.03607120436,    15874.61759536320}, 
    {     0.00000000016,  2.61537304697,    51123.53789995999}, 
    {     0.00000000017,  5.25094113087,    78267.59076008058}, 
    {     0.00000000014,  2.60868275590,   155468.03691925599}, 
    {     0.00000000019,  4.41133632855,     1223.81784077861}, 
    {     0.00000000014,  1.94550512688,   125887.56221081219}, 
    {     0.00000000014,  4.09356954849,    51962.50718771040}, 
    {     0.00000000013,  1.69184734385,   105460.99111839019}, 
    {     0.00000000013,  0.42992478235,    91785.46086631398}, 
    {     0.00000000014,  4.22260830493,    52290.24557183361}, 
    {     0.00000000014,  0.84325677092,    78283.37918562238}, 
    {     0.00000000015,  3.81728490126,    33967.99229491319}, 
    {     0.00000000015,  6.08137402799,    13655.86049117640}, 
    {     0.00000000016,  5.91267910196,   103821.92160120218}, 
    {     0.00000000012,  4.62244083876,    78256.59587772179}, 
    {     0.00000000013,  4.11184990100,    78270.82297172339}, 
    {     0.00000000013,  0.51159953038,   162188.75089859738}, 
    {     0.00000000016,  0.27438111404,    44937.13069154840}, 
    {     0.00000000015,  0.06283579474,    78477.00852016058}, 
    {     0.00000000012,  3.74786317614,    79219.30916633119}, 
    {     0.00000000014,  3.73252208342,    76674.63652943878}, 
    {     0.00000000013,  2.85873269026,   105410.99449648599}, 
    {     0.00000000011,  3.31652116583,    52602.40447402440}, 
    {     0.00000000011,  0.85286372231,    81706.28436968799}, 
    {     0.00000000014,  3.80403488700,   108903.56606335558}, 
    {     0.00000000010,  1.28396028602,    29416.03879785439}, 
    {     0.00000000010,  5.65745629948,   120226.23016165999}, 
    {     0.00000000012,  2.03863313977,    71492.99882347698}, 
    {     0.00000000012,  3.78051451699,    78259.82808936459}, 
    {     0.00000000012,  3.58068127033,    65697.55772473979}, 
    {     0.00000000009,  6.26481642814,    77197.21394753258}, 
    {     0.00000000010,  1.74557548628,    52061.36699446317}, 
    {     0.00000000011,  5.51854977063,    26727.80042788820}, 
    {     0.00000000009,  0.87609670035,    71980.63357473118}, 
    {     0.00000000012,  2.78603563772,      636.99627202420}, 
    {     0.00000000011,  2.55599225548,    44181.27784112419}, 
    {     0.00000000008,  3.96918329614,   181505.94343892598}, 
    {     0.00000000010,  4.03307160926,    45892.73043315699}, 
    {     0.00000000008,  0.26156604139,    58946.51688439399}, 
    {     0.00000000008,  3.43030220559,    23439.44831610119}, 
    {     0.00000000007,  2.31338515724,    18207.81398823521}, 
    {     0.00000000007,  2.30432003862,    58458.88213313979}, 
    {     0.00000000007,  3.55312224720,   117873.36400788819}, 
    {     0.00000000009,  5.71593232265,    77211.44104153418}, 
    {     0.00000000007,  4.76096150126,    51322.60990139639}, 
    {     0.00000000008,  2.48388995708,    93028.94846799239}, 
    {     0.00000000007,  4.09761336373,    39609.65458316560}, 
    {     0.00000000007,  5.75283699646,   365230.64398203876}, 
    {     0.00000000006,  3.99273743908,    59414.48187474840}, 
    {     0.00000000007,  1.69373822080,    28206.66700195260}, 
    {     0.00000000006,  3.28204561721,    64607.84893354619}, 
    {     0.00000000006,  1.54444675453,      853.19638175200}, 
    {     0.00000000008,  0.57761210288,    60055.89543648739}, 
    {     0.00000000006,  5.01805475025,   151975.46535238638}, 
    {     0.00000000006,  2.55446300163,    69159.80243060499}, 
    {     0.00000000005,  1.51210885797,     9103.90699411760}, 
    {     0.00000000006,  4.89525469227,   104331.94280539699}, 
    {     0.00000000006,  4.92564085258,    22759.76748529401}, 
    {     0.00000000005,  2.15346448287,    90829.86112470538}, 
    {     0.00000000006,  0.65350116108,    79852.78232000639}, 
    {     0.00000000005,  3.37193629625,    76144.94556434419}, 
    {     0.00000000005,  2.04815817656,    74821.13447975718}, 
    {     0.00000000005,  0.17834300374,   129483.91596626239}, 
    {     0.00000000005,  6.16414846947,    90695.75207512038}, 
    {     0.00000000005,  5.28415472245,     3340.61242669980}, 
    {     0.00000000005,  3.17894500374,    13541.42120249119}, 
    {     0.00000000005,  5.69793800429,   181555.94006083018}, 
    {     0.00000000006,  2.66476961863,   129909.82474277639}, 
    {     0.00000000005,  5.74228939026,    51742.09454527159}, 
    {     0.00000000005,  4.26343733232,    54509.00267602040}, 
    {     0.00000000004,  4.06123952598,    98068.53671630539}, 
    {     0.00000000006,  4.74202735513,   150866.08680029298}, 
    {     0.00000000004,  3.22245789732,    85034.42002596818}, 
    {     0.00000000006,  2.16211417117,   130969.20667296558}, 
    {     0.00000000005,  1.17994620591,    27311.72098235281}, 
    {     0.00000000004,  3.13862707016,   114564.89811250778}, 
    {     0.00000000004,  0.70841826293,   207593.84658050018}, 
    {     0.00000000004,  2.34774987498,   103925.01437542078}, 
    {     0.00000000005,  0.77949940918,    80482.46652890938}, 
    {     0.00000000004,  2.88313720641,    39743.76363275060}, 
    {     0.00000000005,  3.52886643334,   188276.65404017158}, 
    {     0.00000000004,  0.28788817018,   143961.26714946238}, 
    {     0.00000000004,  4.49043760994,   157636.79740153858}, 
    {     0.00000000004,  4.21873573827,   209812.60368468695}, 
    {     0.00000000004,  2.41403274829,   146314.13330323418}, 
    {     0.00000000005,  1.28701603504,    78050.41032928458}, 
    {     0.00000000004,  5.65308073974,     9384.84100807520}, 
    {     0.00000000004,  2.64375080194,   391318.54712361297}, 
    {     0.00000000003,  3.98926197489,    26555.86813192860}, 
    {     0.00000000004,  0.55808934316,   134991.46920492979}, 
    {     0.00000000004,  4.63875050061,   104138.31347085879}, 
    {     0.00000000004,  5.06700980379,    51749.20809227239}, 
    {     0.00000000004,  3.15594088685,   104564.91166173479}, 
    {     0.00000000003,  5.53916777863,   103917.90082841998}, 
    {     0.00000000003,  3.83058994037,   107794.18751126219}, 
    {     0.00000000004,  5.62157545863,   155997.72788435058}, 
    {     0.00000000003,  4.96842214526,    46848.33017476560}, 
    {     0.00000000003,  1.31101001889,   102132.85546210999}, 
    {     0.00000000004,  3.23824792927,    71025.03383312259}, 
    {     0.00000000003,  0.56485784658,   133882.09065283638}, 
    {     0.00000000003,  5.99223512848,    76681.75007643958}, 
    {     0.00000000003,  2.53782771703,    77829.99768684579}, 
    {     0.00000000003,  5.43159187626,    26624.70765366959}, 
    {     0.00000000004,  1.90489089366,    77844.22478084739}, 
    {     0.00000000004,  6.20678215413,   140652.80125408198}, 
    {     0.00000000003,  5.70654241974,    70269.18098269838}, 
    {     0.00000000003,  1.75060320928,   178063.36849396059}, 
    {     0.00000000003,  0.83065498350,    16066.06586147480}, 
    {     0.00000000004,  2.57176066723,   103299.34418310839}, 
    {     0.00000000003,  1.14659714282,   183724.70054311278}, 
    {     0.00000000003,  5.14785501146,    51756.32163927320}, 
    {     0.00000000003,  2.57903197263,   102769.65321801379}, 
    {     0.00000000003,  3.76793354375,   233681.74972207438}, 
    {     0.00000000004,  0.24142818439,   214364.55718174578}, 
    {     0.00000000003,  2.82633220723,    78417.48823520739}, 
    {     0.00000000003,  1.50791196104,   176953.98994186718}, 
    {     0.00000000003,  0.75025191061,   124156.43985787958}, 
    {     0.00000000003,  0.11585083927,    78690.30761559859}, 
    {     0.00000000004,  1.63233334725,    48847.67062686820}, 
    {     0.00000000003,  0.91669674969,   104358.72611329758}, 
    {     0.00000000003,  4.73790735448,   204151.27163553478}, 
    {     0.00000000004,  5.28351285620,    77837.11123384659}, 
    {     0.00000000003,  5.18374032893,    84546.78527471398}, 
    {     0.00000000003,  5.43488671242,   172402.03644480839}, 
    {     0.00000000003,  3.09682427852,   103285.11708910679}, 
    {     0.00000000003,  2.63284986442,   157586.80077963437}, 
    {     0.00000000004,  2.00317069167,   104355.49390165479}, 
    {     0.00000000003,  2.90251399696,    26241.68195205900}, 
    {     0.00000000003,  5.12222648436,    49842.60989027639}, 
    {     0.00000000003,  0.06488467746,   128850.44281258718}, 
    {     0.00000000003,  0.33684256012,    26521.61487945100}, 
    {     0.00000000003,  1.51588259549,   130226.21661243298}, 
    {     0.00000000003,  3.67637303983,    78731.67441507700}, 
    {     0.00000000003,  2.28131524438,   145204.75475114079}, 
    {     0.00000000003,  5.33066683612,   130012.91751699499}, 
    {     0.00000000003,  3.17481622020,   155571.81910783658}, 
    {     0.00000000003,  5.98255863935,   129373.02023068098}, 
    {     0.00000000003,  5.18830885909,   157057.10981453978}, 
    {     0.00000000003,  2.11070427503,    26037.90651966999}, 
    {     0.00000000004,  5.90634627780,   131498.89763806018}, 
    {     0.00000000003,  3.25172738866,    77726.90491262719}, 
    {     0.00000000003,  6.06137411612,    25035.63475838580}, 
    {     0.00000000003,  2.38439906684,    52815.70356946240}, 
    {     0.00000000003,  5.77780259515,   417406.45026518717}, 
    {     0.00000000003,  0.15017953018,    77623.81213840858}, 
    {     0.00000000003,  2.53692197918,    50579.61984086379}, 
    {     0.00000000003,  3.79850964717,   104371.28232719658}, 
    {     0.00000000003,  0.87877269577,    78378.14871340781}, 
    {     0.00000000003,  4.51815882357,   203041.89308344138}, 
    {     0.00000000003,  5.05030622136,    97580.90196505119}, 
    {     0.00000000003,  3.55526005414,   161079.37234650398}, 
    {     0.00000000003,  3.81129932602,   150244.34299945379}, 
    {     0.00000000003,  4.34998476289,   128220.75860368418}, 
    {     0.00000000003,  4.99282876183,   130443.39704322898}, 
    {     0.00000000003,  6.00078316095,    52329.58509363319}, 
    {     0.00000000002,  2.32406988994,   182085.63102592478}, 
    {     0.00000000003,  1.60886376627,   130419.84594697120}, 
    {     0.00000000003,  3.55274488009,    86143.79857806159}, 
    {     0.00000000003,  6.17525348034,    25021.40766438420}, 
    {     0.00000000002,  5.36948228729,    52125.80966124419}, 
    {     0.00000000003,  0.38599144893,    51639.00177105299}, 
    {     0.00000000002,  1.40074676993,   104344.49901929598}, 
    {     0.00000000002,  0.51392978593,    63498.47038145279}, 
    {     0.00000000002,  2.78225137127,    50593.84693486539}, 
    {     0.00000000002,  1.64621651211,    72936.23331633979}, 
    {     0.00000000003,  5.96023706521,    19804.82729158280}, 
    {     0.00000000002,  1.34569479881,   131548.89425996438}, 
    {     0.00000000002,  4.53808407131,    52595.29092702359}, 
    {     0.00000000002,  1.80494920501,   110634.68841628819}, 
    {     0.00000000002,  2.69270456478,    79330.20490191258}, 
    {     0.00000000002,  0.70786002104,    52643.77127350280}, 
    {     0.00000000002,  5.42134269606,   102232.84870591838}, 
    {     0.00000000003,  4.62281494277,    26941.09952332620}, 
    {     0.00000000002,  3.87566264385,   130446.62925487179}, 
    {     0.00000000002,  0.50212033869,   130459.18546877075}, 
    {     0.00000000002,  3.32954668287,   170049.17029103659}, 
    {     0.00000000002,  3.32826941964,    52609.51802102519}, 
    {     0.00000000002,  1.81888146102,   123668.80510662538}, 
    {     0.00000000002,  1.88539548859,   183145.01295611398}, 
    {     0.00000000002,  5.60036800049,    76667.52298243798}, 
    {     0.00000000002,  2.38004834270,   207643.84320240439}, 
    {     0.00000000003,  5.59960600075,   119116.85160956658}, 
    {     0.00000000002,  0.66616627126,     7994.52844202420}, 
    {     0.00000000002,  6.13884922945,    97112.93697469679}, 
    {     0.00000000002,  6.15194762770,   130652.81480330898}, 
    {     0.00000000002,  3.41632104466,    26237.46633870879}, 
    {     0.00000000002,  3.37420001521,    89586.37352302698}, 
    {     0.00000000003,  6.22021545847,    51543.02254383520}, 
    {     0.00000000002,  4.70019386461,    54294.57014352679}, 
    {     0.00000000002,  3.55423380171,    26610.48055966799}, 
    {     0.00000000002,  2.08199940627,   156100.82065856918}, 
    {     0.00000000002,  1.89771335613,    78213.71280281838}, 
    {     0.00000000002,  2.38063752275,   157483.01859105378}, 
    {     0.00000000002,  0.60609897326,   104347.73123093879}, 
    {     0.00000000002,  3.06733001438,    27154.39861876420}, 
    {     0.00000000002,  4.30652780573,    55503.94193942859}, 
    {     0.00000000002,  3.61289373324,   105940.68546158058}, 
    {     0.00000000002,  1.33899945209,    80382.47328510099}, 
    {     0.00000000002,  4.35432942939,   130432.40216087017}, 
    {     0.00000000002,  5.52246085185,   129387.24732468258}, 
    {     0.00000000002,  3.93624681676,   104466.05185498200}, 
    {     0.00000000002,  1.66120849950,    77410.51304297059}, 
    {     0.00000000002,  2.83496672989,   154938.34595416138}, 
    {     0.00000000002,  3.23031513148,   104778.21075717278}, 
    {     0.00000000002,  1.99889615003,    52712.61079524379}, 
    {     0.00000000002,  4.87996577249,   103932.12792242158}, 
    {     0.00000000002,  2.17758238884,   104991.50985261079}, 
    {     0.00000000002,  4.59207105340,   156507.74908854539}, 
    {     0.00000000002,  3.45973208971,   130435.63437251298}, 
    {     0.00000000002,  1.36100413352,   103711.71527998279}, 
    {     0.00000000002,  5.69915132155,    95247.70557217918}, 
    {     0.00000000002,  2.14140115476,   198489.93958638258}, 
    {     0.00000000002,  2.54868088019,   443494.35340676131}, 
    {     0.00000000002,  4.27290052093,    99024.13645791399}, 
    {     0.00000000002,  5.27508077587,   116917.76426627958}, 
    {     0.00000000002,  0.58370421848,   156534.53239644598}, 
    {     0.00000000002,  5.06923503966,    44295.71712980940}, 
    {     0.00000000002,  2.89478714851,   166740.70439565618}, 
    {     0.00000000002,  3.46374286920,    68241.87214462319}, 
    {     0.00000000001,  2.56009054796,    91919.56991589899}, 
    {     0.00000000002,  5.33102101065,   233731.74634397858}, 
    {     0.00000000001,  0.46871348267,    52698.38370124219}, 
    {     0.00000000002,  0.23345180862,    53228.07466633679}, 
    {     0.00000000001,  1.21219589371,   229129.79622501558}, 
    {     0.00000000002,  1.47208764937,   104237.17327761157}, 
    {     0.00000000001,  0.46249615021,   259769.65286364855}, 
    {     0.00000000001,  3.55153457062,   156547.08861034496}, 
    {     0.00000000002,  3.25214023282,    79315.97780791098}, 
    {     0.00000000001,  2.91709276484,   156740.71794488319}, 
    {     0.00000000002,  2.16887025342,    25881.71759313700}, 
    {     0.00000000002,  5.43830783518,    35191.81013569180}, 
    {     0.00000000002,  0.32055505807,    26294.08869001139}, 
    {     0.00000000002,  1.32421298950,   230239.17477710896}, 
    {     0.00000000001,  2.75656573698,   123200.84011627098}, 
    {     0.00000000001,  1.05519423362,   154308.66174525839}, 
    {     0.00000000001,  2.22706049163,   155475.15046625677}, 
    {     0.00000000001,  1.21096629701,    26507.38778544939}, 
    {     0.00000000001,  4.95426332586,    78800.51393681798}, 
    {     0.00000000002,  1.36857099558,    53029.00266490040}, 
    {     0.00000000001,  5.86456165793,    26724.89941359840}, 
    {     0.00000000002,  5.28892226268,   131395.11544947959}, 
    {     0.00000000001,  4.79216778650,   149756.70824819959}, 
    {     0.00000000001,  3.20732407966,   137678.19129947099}, 
    {     0.00000000001,  2.96638995325,    78786.28684281638}, 
    {     0.00000000001,  4.91638002448,    24864.08530079559}, 
    {     0.00000000001,  6.14910679680,    53242.30176033840}, 
    {     0.00000000001,  6.14706636431,   181659.72224941078}, 
    {     0.00000000001,  5.29736708948,   171292.65789271498}, 
    {     0.00000000001,  5.77778470867,    65831.66677432480}, 
    {     0.00000000001,  1.66692640402,   156531.30018480319}, 
    {     0.00000000001,  4.19906782881,    53399.62412392700}, 
    {     0.00000000001,  3.61349005003,    25551.09862947879}, 
    {     0.00000000001,  4.94658254745,   182188.72380014337}, 
    {     0.00000000001,  4.73509857811,    78149.27013603736}, 
    {     0.00000000001,  0.21694564359,   156523.53751408719}, 
    {     0.00000000001,  2.70464721604,   155460.92337225519}, 
    {     0.00000000001,  6.01917565203,    87367.61641884019}, 
    {     0.00000000001,  0.58964848166,    25934.12433108940}, 
    {     0.00000000001,  0.69637868067,      419.48464387520}, 
    {     0.00000000001,  1.58879127003,   105307.21230790539}, 
    {     0.00000000001,  2.21200704215,    29428.51556827400}, 
    {     0.00000000001,  1.88555101140,   143005.66740785378}, 
    {     0.00000000001,  5.87073148723,        7.11354700080}, 
    {     0.00000000001,  0.98630669719,    80596.90581759460}, 
    {     0.00000000001,  0.32313752445,   111590.28815789679}, 
    {     0.00000000001,  3.57120770556,    27684.08958385880}, 
    {     0.00000000001,  5.31615183025,    25619.93815121980}, 
    {     0.00000000001,  4.96737024920,   100909.03762133139}, 
    {     0.00000000001,  1.98399612179,    70383.62027138360}, 
    {     0.00000000001,  5.76820474986,   181026.24909573558}, 
    {     0.00000000001,  2.17985292285,   106570.36967048359}, 
    {     0.00000000001,  0.33589246093,    51528.79544983359}, 
    {     0.00000000001,  2.30304143694,   102755.42612401219}, 
    {     0.00000000001,  2.60522245307,      632.78373931320}, 
    {     0.00000000001,  2.12902252288,    85502.38501632259}, 
    {     0.00000000001,  5.48182021001,    78903.60671103658}, 
    {     0.00000000001,  5.81614944128,       19.66976089979}, 
    {     0.00000000001,  0.28057913034,    25450.90686955000}, 
    {     0.00000000001,  0.23368034121,   187167.27548807819}, 
    {     0.00000000001,  5.27687922240,   183570.92173262799}, 
    {     0.00000000001,  0.55131065335,    26137.89976347840}, 
    {     0.00000000001,  6.11149192748,   196137.07343261078}, 
    {     0.00000000001,  5.21786187975,    36109.74042167360}, 
    {     0.00000000001,  5.69487692949,    25565.32572348040}, 
    {     0.00000000001,  0.66528112216,    42153.96900304900}, 
    {     0.00000000001,  1.31014433957,   128320.75184749259}, 
    {     0.00000000001,  0.30267346719,   132028.58860315479}, 
    {     0.00000000001,  5.29138018584,   208173.53416749898}, 
    {     0.00000000001,  5.56586628815,   183674.70392120858}
};

 
 
static const struct ln_vsop mercury_longitude_l3[LONG_L3] = {
    {     0.00000169496,  3.20221586818,    26087.90314157420}, 
    {     0.00000155725,  6.23814315369,    52175.80628314840}, 
    {     0.00000090555,  2.96712953186,    78263.70942472259}, 
    {     0.00000042769,  6.01870391709,   104351.61256629678}, 
    {     0.00000017760,  2.78750960026,   130439.51570787099}, 
    {     0.00000006774,  5.82756176337,   156527.41884944518}, 
    {     0.00000003486,  0.00000000000,        0.00000000000}, 
    {     0.00000002435,  2.56963684564,   182615.32199101939}, 
    {     0.00000000838,  5.58026725886,   208703.22513259358}, 
    {     0.00000000279,  2.29386373858,   234791.12827416777}, 
    {     0.00000000117,  3.16711243445,    24978.52458948080}, 
    {     0.00000000091,  5.27797094839,   260879.03141574195}, 
    {     0.00000000077,  6.24118948880,    51066.42773105500}, 
    {     0.00000000059,  6.13122855286,    27197.28169366760}, 
    {     0.00000000029,  1.96984426125,   286966.93455731616}, 
    {     0.00000000038,  3.01313871348,    77154.33087262919}, 
    {     0.00000000026,  3.07099212705,    53285.18483524180}, 
    {     0.00000000016,  6.05402853609,   103242.23401420339}, 
    {     0.00000000009,  0.58761405280,    20426.57109242200}, 
    {     0.00000000008,  4.91858279103,   313054.83769889036}, 
    {     0.00000000008,  3.65754213465,    46514.47423399620}, 
    {     0.00000000007,  5.80852764666,    25132.30339996560}, 
    {     0.00000000006,  2.80645454084,   129330.13715577759}, 
    {     0.00000000005,  0.42790495669,    72602.37737557039}, 
    {     0.00000000005,  1.38013899810,    26617.59410666880}, 
    {     0.00000000006,  6.21321941701,    79373.08797681599}, 
    {     0.00000000004,  2.57269000597,    51220.20654153979}, 
    {     0.00000000004,  4.35146183280,    52705.49724824299}, 
    {     0.00000000004,  3.23908636136,    23869.14603738740}, 
    {     0.00000000004,  3.11816146331,    27043.50288318280}, 
    {     0.00000000003,  5.65361012794,    30639.85663863300}, 
    {     0.00000000003,  6.24088426744,    50586.73338786459}, 
    {     0.00000000003,  4.71793214076,    27147.28507176339}, 
    {     0.00000000003,  1.56503904911,   339142.74084046457}, 
    {     0.00000000003,  4.40817083916,    14765.23904326980}, 
    {     0.00000000003,  1.36263896645,    53235.18821333759}, 
    {     0.00000000003,  2.55349503543,    56727.75978020720}, 
    {     0.00000000002,  1.57411546608,    25558.21217647960}, 
    {     0.00000000002,  5.82296227978,   155418.04029735178}, 
    {     0.00000000003,  6.04743500801,    28306.66024576099}, 
    {     0.00000000002,  3.56825195678,    78267.59076008058}, 
    {     0.00000000002,  0.67646904345,    19317.19254032860}, 
    {     0.00000000002,  0.80653697687,   155468.03691925599}, 
    {     0.00000000002,  2.56516361004,   181505.94343892598}, 
    {     0.00000000002,  0.04355188842,    49957.04917896160}, 
    {     0.00000000002,  5.46649056139,   110012.94461544899}, 
    {     0.00000000002,  4.44350451862,    79323.09135491178}, 
    {     0.00000000002,  2.80769531030,    83925.04147387479}, 
    {     0.00000000002,  0.87954898432,   103292.23063610759}, 
    {     0.00000000002,  2.87146263097,    54394.56338733519}, 
    {     0.00000000002,  4.72727579494,   365230.64398203876}, 
    {     0.00000000002,  3.49243086623,    98690.28051714458}, 
    {     0.00000000002,  0.13491885197,    57837.13833230060}, 
    {     0.00000000001,  5.93623181057,     4551.95349705880}, 
    {     0.00000000001,  0.68876175865,    51116.42435295920}, 
    {     0.00000000001,  2.22622522074,   136100.84775702319}, 
    {     0.00000000002,  2.02950867590,    78259.82808936459}, 
    {     0.00000000002,  2.76244130660,    79219.30916633119}, 
    {     0.00000000002,  1.75174914928,    77734.01845962799}, 
    {     0.00000000002,  5.53512457012,    82815.66292178139}, 
    {     0.00000000001,  5.85249550691,    80482.46652890938}, 
    {     0.00000000001,  3.81987601159,   181555.94006083018}, 
    {     0.00000000002,  4.40970001516,   103821.92160120218}, 
    {     0.00000000001,  5.22138031517,   162188.75089859738}, 
    {     0.00000000001,  3.73642972825,    77204.32749453338}, 
    {     0.00000000002,  0.49707359743,    71492.99882347698}, 
    {     0.00000000001,  1.38660659950,    40853.14218484400}, 
    {     0.00000000001,  2.95221907246,    76674.63652943878}, 
    {     0.00000000002,  1.29222474765,   105410.99449648599}, 
    {     0.00000000002,  2.25962890984,   108903.56606335558}, 
    {     0.00000000002,  1.16550489633,    78793.40038981718}, 
    {     0.00000000001,  0.36415945149,   125887.56221081219}, 
    {     0.00000000002,  4.08854513089,   104881.30353139139}, 
    {     0.00000000001,  3.08110954685,    76044.95232053580}, 
    {     0.00000000001,  3.03258348439,    78256.59587772179}, 
    {     0.00000000001,  3.77632466126,    64741.95798313119}, 
    {     0.00000000002,  3.64167234446,    45405.09568190280}, 
    {     0.00000000001,  4.69654806259,    88476.99497093359}, 
    {     0.00000000001,  2.51395607415,    55618.38122811380}, 
    {     0.00000000001,  1.62785445812,    52389.10537858640}, 
    {     0.00000000001,  1.72317308732,    62389.09182935939}, 
    {     0.00000000001,  0.02541044713,    52168.69273614759}, 
    {     0.00000000001,  5.45367779477,    77308.10968311399}, 
    {     0.00000000001,  4.37214899281,    26301.20223701220}, 
    {     0.00000000001,  2.06676015946,   103396.01282468818}, 
    {     0.00000000002,  1.72366900008,    63498.47038145279}, 
    {     0.00000000001,  4.26409824775,    68050.42387851159}, 
    {     0.00000000001,  1.13384949570,    73711.75592766379}, 
    {     0.00000000001,  2.59146532084,    52290.24557183361}, 
    {     0.00000000001,  0.57771259518,    52179.68761850640}, 
    {     0.00000000001,  6.05911204257,   102132.85546210999}, 
    {     0.00000000002,  5.08007258698,    51646.11531805379}, 
    {     0.00000000001,  0.89506331110,    43071.89928903080}, 
    {     0.00000000001,  2.32962526981,    32858.61374281979}, 
    {     0.00000000001,  5.33639855920,    78283.37918562238}, 
    {     0.00000000001,  0.21578309169,   124778.18365871879}, 
    {     0.00000000001,  0.97190581639,    94138.32702008578}, 
    {     0.00000000001,  3.63988900749,    99799.65906923798}, 
    {     0.00000000001,  0.31092877030,    78244.03966382280}, 
    {     0.00000000001,  0.88240174201,    38654.05484155699}, 
    {     0.00000000001,  5.51352755464,    81706.28436968799}, 
    {     0.00000000001,  4.29818815666,    25874.60404613620}, 
    {     0.00000000001,  3.25355593666,   150866.08680029298}, 
    {     0.00000000001,  5.83277482201,    26202.34243025941}, 
    {     0.00000000001,  5.56400642740,    50057.04242277000}, 
    {     0.00000000001,  4.10855423897,   129380.13377768178}, 
    {     0.00000000001,  3.53026214100,    52156.13652224860}, 
    {     0.00000000001,  4.62648721501,    78477.00852016058}, 
    {     0.00000000001,  4.93260671151,    37410.56723987860}, 
    {     0.00000000001,  6.23775561663,    53131.40602475700}, 
    {     0.00000000001,  4.28468625710,    66941.04532641819}, 
    {     0.00000000001,  2.44665953571,    52195.47604404819}, 
    {     0.00000000001,  5.05730214410,   129483.91596626239}, 
    {     0.00000000001,  3.01159658549,   105460.99111839019}, 
    {     0.00000000001,  5.36784540343,    26107.57290247399}, 
    {     0.00000000001,  3.37141132304,    48733.23133818299}, 
    {     0.00000000001,  2.29657920020,    51535.90899683439}, 
    {     0.00000000001,  5.38152228973,    52171.92494779040}, 
    {     0.00000000001,  4.95743222375,    35191.81013569180}, 
    {     0.00000000001,  0.72632545829,   130969.20667296558}, 
    {     0.00000000001,  5.86529301658,   102762.53967101299}, 
    {     0.00000000001,  2.57174065725,    26095.01668857500}, 
    {     0.00000000001,  1.32180905788,   391318.54712361297}, 
    {     0.00000000001,  3.24565029816,    26080.78959457339}, 
    {     0.00000000001,  4.99798388110,    36301.18868778519}, 
    {     0.00000000001,  3.27865480193,     2118.76386037840}, 
    {     0.00000000001,  2.32578126782,    78270.82297172339}, 
    {     0.00000000001,  2.58055096142,    53764.87917843220}, 
    {     0.00000000001,  5.70846453783,    58946.51688439399}, 
    {     0.00000000001,  0.94894417845,    93028.94846799239}, 
    {     0.00000000001,  1.66220417885,    52602.40447402440}, 
    {     0.00000000001,  4.44449056230,   417406.45026518717}, 
    {     0.00000000001,  6.15060120914,    27676.97603685800}, 
    {     0.00000000001,  0.21740755726,    52061.36699446317}, 
    {     0.00000000001,  4.14022222533,    25028.52121138500}, 
    {     0.00000000001,  5.30484938123,    79852.78232000639}, 
    {     0.00000000001,  0.35499536460,    90829.86112470538}, 
    {     0.00000000001,  5.28585833455,    29530.47808653960}, 
    {     0.00000000001,  1.83471944738,   188276.65404017158}, 
    {     0.00000000001,  3.40823920724,    25973.46385288896}, 
    {     0.00000000001,  2.06905416268,   104371.28232719658}, 
    {     0.00000000001,  0.22297971328,   104355.49390165479}, 
    {     0.00000000001,  2.52348712557,   106570.36967048359}, 
    {     0.00000000001,  5.16350389418,    26514.50133245020}, 
    {     0.00000000001,  4.60303527476,    78690.30761559859}, 
    {     0.00000000001,  5.48255968908,   207593.84658050018}, 
    {     0.00000000001,  5.91676661035,   104344.49901929598}, 
    {     0.00000000001,  5.79807025509,    52182.91983014920}, 
    {     0.00000000001,  0.77021074284,   155997.72788435058}, 
    {     0.00000000001,  4.00131880946,   120226.23016165999}, 
    {     0.00000000001,  5.24158680760,    11322.66409830440}, 
    {     0.00000000001,  3.99128397668,     5661.33204915220}, 
    {     0.00000000000,  3.20297505882,    21535.94964451540}, 
    {     0.00000000001,  4.13603433748,     1109.37855209340}, 
    {     0.00000000001,  3.31920881622,    22645.32819660879}, 
    {     0.00000000001,  5.42291311668,   105307.21230790539}, 
    {     0.00000000000,  5.99626390068,   131548.89425996438}, 
    {     0.00000000000,  1.73722721022,    13521.75144159140}, 
    {     0.00000000001,  3.35669906644,   104331.94280539699}, 
    {     0.00000000000,  1.63336362157,     9103.90699411760}, 
    {     0.00000000000,  2.95763935965,    54294.57014352679}, 
    {     0.00000000000,  3.34933555413,    24498.83024629040}
};



static const struct ln_vsop mercury_longitude_l4[LONG_L4] = {
    {     0.00000002671,  4.76418299344,    52175.80628314840}, 
    {     0.00000002079,  2.01782765964,    26087.90314157420}, 
    {     0.00000002071,  1.47603650163,    78263.70942472259}, 
    {     0.00000001248,  4.50170414847,   104351.61256629678}, 
    {     0.00000000641,  1.26049541246,   130439.51570787099}, 
    {     0.00000000293,  4.30408398706,   156527.41884944518}, 
    {     0.00000000124,  1.05833043353,   182615.32199101939}, 
    {     0.00000000049,  4.08707632054,   208703.22513259358}, 
    {     0.00000000047,  3.14159265359,        0.00000000000}, 
    {     0.00000000018,  0.82373729208,   234791.12827416777}, 
    {     0.00000000006,  3.82469204536,   260879.03141574195}, 
    {     0.00000000002,  0.50074116156,   286966.93455731616}, 
    {     0.00000000002,  4.68954881838,    51066.42773105500}, 
    {     0.00000000001,  1.63693177813,    24978.52458948080}, 
    {     0.00000000001,  3.50676934033,   313054.83769889036}, 
    {     0.00000000001,  4.59925122335,    27197.28169366760}, 
    {     0.00000000001,  4.34568926758,    79373.08797681599}, 
    {     0.00000000001,  1.32214662513,    53285.18483524180}, 
    {     0.00000000001,  1.23275471446,   129330.13715577759}, 
    {     0.00000000001,  1.52702783547,    77154.33087262919}, 
    {     0.00000000001,  4.47013011557,   103242.23401420339}, 
    {     0.00000000001,  0.25254465674,   339142.74084046457}, 
    {     0.00000000000,  4.19908374167,   155418.04029735178}
};



static const struct ln_vsop mercury_longitude_l5[LONG_L5] = {
    {     0.00000000039,  6.22596606829,    78263.70942472259}, 
    {     0.00000000035,  3.08442751462,    52175.80628314840}, 
    {     0.00000000036,  5.58268731752,    26087.90314157420}, 
    {     0.00000000030,  2.98600396234,   104351.61256629678}, 
    {     0.00000000019,  6.02016521976,   130439.51570787099}, 
    {     0.00000000010,  2.77948950109,   156527.41884944518}, 
    {     0.00000000005,  5.82587725191,   182615.32199101939}, 
    {     0.00000000002,  2.57971347645,   208703.22513259358}, 
    {     0.00000000001,  5.62474344959,   234791.12827416777}, 
    {     0.00000000001,  2.30011142231,   260879.03141574195}, 
    {     0.00000000000,  5.32570213434,   286966.93455731616}, 
    {     0.00000000000,  0.00000000000,        0.00000000000}
};



static const struct ln_vsop mercury_latitude_b0[LAT_B0] = {
    {     0.11737528961,  1.98357498767,    26087.90314157420}, 
    {     0.02388076996,  5.03738959686,    52175.80628314840}, 
    {     0.01222839532,  3.14159265359,        0.00000000000}, 
    {     0.00543251810,  1.79644363964,    78263.70942472259}, 
    {     0.00129778770,  4.83232503958,   104351.61256629678}, 
    {     0.00031866927,  1.58088495658,   130439.51570787099}, 
    {     0.00007963301,  4.60972126127,   156527.41884944518}, 
    {     0.00002014189,  1.35324164377,   182615.32199101939}, 
    {     0.00000513953,  4.37835406663,   208703.22513259358}, 
    {     0.00000207674,  4.91772567908,    27197.28169366760}, 
    {     0.00000208584,  2.02020295489,    24978.52458948080}, 
    {     0.00000132013,  1.11908482553,   234791.12827416777}, 
    {     0.00000100454,  5.65684757892,    20426.57109242200}, 
    {     0.00000121395,  1.81271747279,    53285.18483524180}, 
    {     0.00000091566,  2.28163127292,    25028.52121138500}, 
    {     0.00000099214,  0.09391887897,    51116.42435295920}, 
    {     0.00000094574,  1.24184920920,    31749.23519072640}, 
    {     0.00000078785,  4.40725881159,    57837.13833230060}, 
    {     0.00000077747,  0.52557074433,     1059.38193018920}, 
    {     0.00000084264,  5.08510405853,    51066.42773105500}, 
    {     0.00000049948,  3.49752943761,     5661.33204915220}, 
    {     0.00000046454,  3.23739220729,    77204.32749453338}, 
    {     0.00000044767,  4.87849798560,    79373.08797681599}, 
    {     0.00000040766,  2.46558335253,    46514.47423399620}, 
    {     0.00000037378,  4.45768804232,     4551.95349705880}, 
    {     0.00000034082,  4.14209218714,   260879.03141574195}, 
    {     0.00000035911,  1.09057337889,     1109.37855209340}, 
    {     0.00000031953,  1.18516370205,    83925.04147387479}, 
    {     0.00000030954,  3.50327936487,    21535.94964451540}, 
    {     0.00000031808,  2.41474596045,    47623.85278608960}, 
    {     0.00000028691,  1.84828593103,    77154.33087262919}, 
    {     0.00000025765,  2.77593431876,    27043.50288318280}, 
    {     0.00000025199,  3.59062253553,    27147.28507176339}, 
    {     0.00000020244,  3.06833786595,    51646.11531805379}, 
    {     0.00000018591,  5.58427343534,    73711.75592766379}, 
    {     0.00000016971,  0.02791235969,   103292.23063610759}, 
    {     0.00000020099,  4.06592941642,    25132.30339996560}, 
    {     0.00000017002,  6.13739539823,    41962.52073693740}, 
    {     0.00000014984,  1.64717988399,   105460.99111839019}, 
    {     0.00000014186,  0.33074004324,    10213.28554621100}, 
    {     0.00000015577,  6.07693636260,    53131.40602475700}, 
    {     0.00000015795,  3.79629550117,      529.69096509460}, 
    {     0.00000014011,  5.52786584585,    72602.37737557039}, 
    {     0.00000012309,  3.16626255554,    14765.23904326980}, 
    {     0.00000011261,  0.11326489831,    13521.75144159140}, 
    {     0.00000012448,  4.05109307874,    39609.65458316560}, 
    {     0.00000013044,  3.48016460676,    37410.56723987860}, 
    {     0.00000011042,  4.23192795686,   110012.94461544899}, 
    {     0.00000011152,  0.55658540702,    63498.47038145279}, 
    {     0.00000010717,  1.53686088392,    25661.30495069820}, 
    {     0.00000010213,  2.87881154880,    12566.15169998280}, 
    {     0.00000009924,  0.94824538375,    65697.55772473979}, 
    {     0.00000011047,  5.79741513221,    51749.20809227239}, 
    {     0.00000010460,  5.82962192197,    50586.73338786459}, 
    {     0.00000009774,  1.66272232331,    24498.83024629040}, 
    {     0.00000009412,  1.82364862409,    15874.61759536320}, 
    {     0.00000012866,  4.81650992216,    30639.85663863300}, 
    {     0.00000009123,  4.88604621694,   103242.23401420339}, 
    {     0.00000009011,  1.04262054312,      426.59819087600}, 
    {     0.00000008735,  3.04135873601,    68050.42387851159}, 
    {     0.00000008491,  1.05130636798,     1589.07289528380}, 
    {     0.00000008835,  0.88128578222,   286966.93455731616}, 
    {     0.00000008823,  5.81343394292,    11322.66409830440}, 
    {     0.00000008196,  0.84015152502,    51220.20654153979}, 
    {     0.00000007640,  3.43583985772,    36301.18868778519}, 
    {     0.00000009175,  6.16060208369,    77734.01845962799}, 
    {     0.00000008897,  0.39691887001,    53235.18821333759}, 
    {     0.00000007253,  2.37180881419,    99799.65906923798}, 
    {     0.00000007104,  5.73556965976,    26617.59410666880}, 
    {     0.00000008322,  5.27157093377,    25558.21217647960}, 
    {     0.00000006578,  2.66741919711,    52705.49724824299}, 
    {     0.00000005825,  6.25072209775,    33326.57873317420}, 
    {     0.00000005625,  3.08030235705,   129380.13377768178}, 
    {     0.00000005295,  1.35863384912,    45892.73043315699}, 
    {     0.00000005116,  2.67577088825,    76674.63652943878}, 
    {     0.00000005035,  2.66615253453,    77837.11123384659}, 
    {     0.00000004762,  4.68983281649,   131548.89425996438}, 
    {     0.00000005714,  2.87338979816,    79219.30916633119}, 
    {     0.00000005602,  5.37191138944,      955.59974160860}, 
    {     0.00000004965,  3.47619928213,    59414.48187474840}, 
    {     0.00000005468,  1.43781628125,    56727.75978020720}, 
    {     0.00000004080,  4.01668024064,    91785.46086631398}, 
    {     0.00000003971,  5.44452628396,     6283.07584999140}, 
    {     0.00000004063,  5.64286268741,    26068.23338067440}, 
    {     0.00000003878,  3.60888347246,    89586.37352302698}, 
    {     0.00000004047,  5.95237490666,    38654.05484155699}, 
    {     0.00000004064,  1.46277908490,    26107.57290247399}, 
    {     0.00000003681,  0.47366868505,    62389.09182935939}, 
    {     0.00000004247,  6.23163524997,    40853.14218484400}, 
    {     0.00000003694,  2.75543299806,     7238.67559160000}, 
    {     0.00000003348,  5.91870267340,    43071.89928903080}, 
    {     0.00000004475,  2.28938990458,    98690.28051714458}, 
    {     0.00000003115,  0.74944300245,    32858.61374281979}, 
    {     0.00000003100,  3.35203539679,    19804.82729158280}, 
    {     0.00000003215,  6.11377023104,    94138.32702008578}, 
    {     0.00000003558,  0.98821355044,   136100.84775702319}, 
    {     0.00000002908,  4.06284717343,    26514.50133245020}, 
    {     0.00000002799,  1.63603233307,   129330.13715577759}, 
    {     0.00000002800,  3.88358973835,    77308.10968311399}, 
    {     0.00000002680,  4.48236519244,    71980.63357473118}, 
    {     0.00000002767,  4.12702608202,    27676.97603685800}, 
    {     0.00000003285,  0.39398351530,    18849.22754997420}, 
    {     0.00000003290,  2.93489975877,   103821.92160120218}, 
    {     0.00000003048,  0.67698956234,     9103.90699411760}, 
    {     0.00000002484,  5.42344230141,   125887.56221081219}, 
    {     0.00000002663,  1.70279606207,    16983.99614745660}, 
    {     0.00000002791,  2.76842339360,    26091.78447693220}, 
    {     0.00000002747,  5.75135690787,    19317.19254032860}, 
    {     0.00000002676,  5.73637768264,    78793.40038981718}, 
    {     0.00000002710,  4.31274423123,    58946.51688439399}, 
    {     0.00000002877,  3.45421450693,    79323.09135491178}, 
    {     0.00000002791,  4.34021895901,    26084.02180621620}, 
    {     0.00000002097,  2.09090395873,    23869.14603738740}, 
    {     0.00000002297,  3.90330505329,   313054.83769889036}, 
    {     0.00000002535,  3.05171357512,    69159.80243060499}, 
    {     0.00000002211,  4.65120829674,    28306.66024576099}, 
    {     0.00000001912,  5.78419180084,   102762.53967101299}, 
    {     0.00000002265,  3.34480087923,    22645.32819660879}, 
    {     0.00000001817,  5.74263950195,   103925.01437542078}, 
    {     0.00000001961,  5.94579007147,   105307.21230790539}, 
    {     0.00000001922,  4.43763750052,    82815.66292178139}, 
    {     0.00000001667,  4.51885560989,    52195.47604404819}, 
    {     0.00000001771,  6.12283446589,   155468.03691925599}, 
    {     0.00000001515,  1.72460827268,    54394.56338733519}, 
    {     0.00000001585,  0.23900607949,    85502.38501632259}, 
    {     0.00000001477,  4.73358609259,    29530.47808653960}, 
    {     0.00000001470,  1.44576864221,   157636.79740153858}, 
    {     0.00000001652,  2.41345125134,    52156.13652224860}, 
    {     0.00000001377,  0.59981275344,    26080.78959457339}, 
    {     0.00000001430,  0.78425681154,   117873.36400788819}, 
    {     0.00000001680,  3.42686804945,     6770.71060124560}, 
    {     0.00000001604,  4.52048713019,     3442.57494496540}, 
    {     0.00000001345,  0.31855634174,    51535.90899683439}, 
    {     0.00000001357,  3.17346823148,    25874.60404613620}, 
    {     0.00000001250,  2.33381266189,    25448.00585526019}, 
    {     0.00000001196,  2.09281738041,    48733.23133818299}, 
    {     0.00000001195,  0.36393992281,   115674.27666460119}, 
    {     0.00000001443,  2.73206411694,    64741.95798313119}, 
    {     0.00000001375,  5.32685986405,   124778.18365871879}, 
    {     0.00000001325,  3.57822655677,    88476.99497093359}, 
    {     0.00000001115,  0.26093704362,      639.89728631400}, 
    {     0.00000001094,  2.22756345548,    32370.97899156560}, 
    {     0.00000001433,  3.03965823547,    66941.04532641819}, 
    {     0.00000001370,  3.45925392964,    44937.13069154840}, 
    {     0.00000001003,  0.28767648474,    25934.12433108940}, 
    {     0.00000001136,  1.11056761130,    52171.92494779040}, 
    {     0.00000000999,  0.52453704666,    26241.68195205900}, 
    {     0.00000001033,  2.55559915330,    45405.09568190280}, 
    {     0.00000001096,  5.01258599679,        7.11354700080}, 
    {     0.00000001146,  5.40632535415,      213.29909543800}, 
    {     0.00000001080,  5.97872394252,   129909.82474277639}, 
    {     0.00000000988,  1.25836520092,    98068.53671630539}, 
    {     0.00000001062,  2.88170970708,   120226.23016165999}, 
    {     0.00000000892,  0.63718796304,   103396.01282468818}, 
    {     0.00000001041,  0.89366857677,    52602.40447402440}, 
    {     0.00000000978,  0.93100566720,    53764.87917843220}, 
    {     0.00000001136,  5.82021916863,    52179.68761850640}, 
    {     0.00000000838,  4.66564092179,   155418.04029735178}, 
    {     0.00000000910,  5.53570859596,    58458.88213313979}, 
    {     0.00000000834,  5.16157375656,    49957.04917896160}, 
    {     0.00000001100,  4.02186957760,   162188.75089859738}, 
    {     0.00000000805,  1.03424867259,    23969.13928119580}, 
    {     0.00000000835,  5.28207308572,    50057.04242277000}, 
    {     0.00000000891,  0.21549052344,   105410.99449648599}, 
    {     0.00000000743,  0.86942889867,    52389.10537858640}, 
    {     0.00000000783,  3.32305564501,    26301.20223701220}, 
    {     0.00000000711,  1.57776037431,     2118.76386037840}, 
    {     0.00000000801,  2.18307947662,   151975.46535238638}, 
    {     0.00000000915,  1.71248761076,    51962.50718771040}, 
    {     0.00000000832,  5.53504230089,    74821.13447975718}, 
    {     0.00000000750,  2.16182593895,    52168.69273614759}, 
    {     0.00000000923,  2.50216511819,   104881.30353139139}, 
    {     0.00000000727,  6.05391736381,    95247.70557217918}, 
    {     0.00000000640,  2.71757218637,   131395.11544947959}, 
    {     0.00000000628,  1.43928263436,    55618.38122811380}, 
    {     0.00000000622,  3.46096554268,    77623.81213840858}, 
    {     0.00000000825,  1.00555394841,    85034.42002596818}, 
    {     0.00000000611,  0.99681307094,     2218.75710418680}, 
    {     0.00000000605,  4.68162394146,    52182.91983014920}, 
    {     0.00000000646,  2.57909918586,   128850.44281258718}, 
    {     0.00000000621,  1.16585050910,   108903.56606335558}, 
    {     0.00000000651,  1.60040358652,    26095.01668857500}, 
    {     0.00000000599,  2.51220320140,   130012.91751699499}, 
    {     0.00000000570,  1.27723576108,    78283.37918562238}, 
    {     0.00000000616,  2.88988928491,    52026.24308601380}, 
    {     0.00000000553,  5.17653433760,    25938.33994443960}, 
    {     0.00000000560,  3.32832430147,    51109.31080595839}, 
    {     0.00000000538,  4.74589660911,    80482.46652890938}, 
    {     0.00000000514,  5.52495100856,    25021.40766438420}, 
    {     0.00000000512,  2.12028030770,    25035.63475838580}, 
    {     0.00000000545,  1.31026218764,    26555.86813192860}, 
    {     0.00000000475,  4.05388482000,      149.56319713460}, 
    {     0.00000000464,  3.26227850989,   111590.28815789679}, 
    {     0.00000000460,  5.34045473945,    46848.33017476560}, 
    {     0.00000000550,  5.84636209826,    25619.93815121980}, 
    {     0.00000000447,  3.57688662734,     1066.49547719000}, 
    {     0.00000000550,  6.22076738343,    51123.53789995999}, 
    {     0.00000000596,  0.64537969407,   339142.74084046457}, 
    {     0.00000000484,  3.16179359489,    38519.94579197200}, 
    {     0.00000000441,  0.67390934097,     1052.26838318840}, 
    {     0.00000000477,  0.22612097814,    71025.03383312259}, 
    {     0.00000000423,  2.08217197834,    76144.94556434419}, 
    {     0.00000000418,  3.57900885312,    52329.58509363319}, 
    {     0.00000000472,  3.35497952386,    35191.81013569180}, 
    {     0.00000000441,  4.91198712765,    78050.41032928458}, 
    {     0.00000000440,  4.47943362012,   183724.70054311278}, 
    {     0.00000000435,  1.98195617971,    26094.53170047421}, 
    {     0.00000000564,  5.45425629323,    78244.03966382280}, 
    {     0.00000000540,  2.87640883368,   181555.94006083018}, 
    {     0.00000000450,  6.09068205356,    93028.94846799239}, 
    {     0.00000000462,  3.82441945925,   143961.26714946238}, 
    {     0.00000000408,  3.34306652412,    52022.02747266360}, 
    {     0.00000000412,  2.07642366233,   150866.08680029298}, 
    {     0.00000000435,  5.12506127285,    26081.27458267419}, 
    {     0.00000000409,  0.56814053300,    64607.84893354619}, 
    {     0.00000000388,  4.16031676214,    78259.82808936459}, 
    {     0.00000000393,  3.23714650276,    13655.86049117640}, 
    {     0.00000000375,  5.33297139411,    26011.63707029860}, 
    {     0.00000000467,  5.77560193533,    90829.86112470538}, 
    {     0.00000000350,  5.62305509992,    71492.99882347698}, 
    {     0.00000000352,  3.27694424296,    26727.80042788820}, 
    {     0.00000000351,  3.39353257328,   141762.17980617538}, 
    {     0.00000000390,  2.58789385607,    78267.59076008058}, 
    {     0.00000000365,  3.19923510350,    52099.54021187280}, 
    {     0.00000000433,  1.55191555585,    20760.42703319140}, 
    {     0.00000000327,  5.69237369433,    12432.04265039780}, 
    {     0.00000000339,  1.58087406629,    45494.58142974879}, 
    {     0.00000000338,  2.73269880607,   155997.72788435058}, 
    {     0.00000000315,  4.00042191791,    78477.00852016058}, 
    {     0.00000000435,  0.36539433019,   114564.89811250778}, 
    {     0.00000000344,  5.02598371077,    78256.59587772179}, 
    {     0.00000000346,  4.14119753561,   111122.32316754239}, 
    {     0.00000000286,  5.40508625698,     6681.22485339960}, 
    {     0.00000000283,  3.65514316990,       76.26607127560}, 
    {     0.00000000325,  4.30579452294,   124156.43985787958}, 
    {     0.00000000364,  2.32783082897,    84546.78527471398}, 
    {     0.00000000331,  0.77022299532,   188276.65404017158}, 
    {     0.00000000267,  3.81782594348,    19406.67828817460}, 
    {     0.00000000270,  6.02001495547,    78114.14622758799}, 
    {     0.00000000273,  3.66893645163,   129483.91596626239}, 
    {     0.00000000263,  0.18734818549,    77197.21394753258}, 
    {     0.00000000268,  3.25183532034,   131498.89763806018}, 
    {     0.00000000284,  1.93841351149,    76044.95232053580}, 
    {     0.00000000295,  5.54100863182,   130969.20667296558}, 
    {     0.00000000246,  1.45339450432,    78270.82297172339}, 
    {     0.00000000259,  3.08233305443,    77211.44104153418}, 
    {     0.00000000335,  5.92215647534,   146314.13330323418}, 
    {     0.00000000253,  2.86398839801,   121335.60871375339}, 
    {     0.00000000338,  3.95834695582,    78690.30761559859}, 
    {     0.00000000317,  3.98389279162,    79852.78232000639}, 
    {     0.00000000232,  4.66675132764,    28206.66700195260}, 
    {     0.00000000247,  1.40502512052,   181505.94343892598}, 
    {     0.00000000228,  0.25670025260,   103711.71527998279}, 
    {     0.00000000219,  4.69778127839,    71582.48457132299}, 
    {     0.00000000221,  4.46397767224,    81706.28436968799}, 
    {     0.00000000254,  1.43722023804,     5327.47610838280}, 
    {     0.00000000199,  5.76845937762,   157483.01859105378}, 
    {     0.00000000253,  2.47477562856,    72936.23331633979}, 
    {     0.00000000191,  4.17878596373,   134991.46920492979}, 
    {     0.00000000246,  5.21482964733,   178063.36849396059}, 
    {     0.00000000182,  4.31642421149,   104371.28232719658}, 
    {     0.00000000206,  1.62001821938,   106570.36967048359}, 
    {     0.00000000234,  2.18969474341,   100909.03762133139}, 
    {     0.00000000176,  3.58295520082,    48835.19385644859}, 
    {     0.00000000188,  2.58568213426,    51707.84129279399}, 
    {     0.00000000177,  1.89452084301,    52169.17772424839}, 
    {     0.00000000168,  3.01268585761,    23754.70674870219}, 
    {     0.00000000222,  4.35554033541,    52643.77127350280}, 
    {     0.00000000169,  5.25191713657,   102232.84870591838}, 
    {     0.00000000188,  5.55461046577,   156100.82065856918}, 
    {     0.00000000163,  1.72111046975,   104138.31347085879}, 
    {     0.00000000204,  5.64364799554,   154938.34595416138}, 
    {     0.00000000161,  0.06505273733,    78187.44335344699}, 
    {     0.00000000155,  3.29528249467,    97112.93697469679}, 
    {     0.00000000152,  1.66427224942,    25654.19140369739}, 
    {     0.00000000179,  2.20391378287,   104331.94280539699}, 
    {     0.00000000157,  5.91591630738,    51742.09454527159}, 
    {     0.00000000176,  5.03398977770,    52182.43484204840}, 
    {     0.00000000145,  0.34805544633,    78417.48823520739}, 
    {     0.00000000151,  0.84018770177,    26237.46633870879}, 
    {     0.00000000143,  0.36103472282,    27154.39861876420}, 
    {     0.00000000142,  5.87483350318,    26037.90651966999}, 
    {     0.00000000167,  4.43526495468,    25668.41849769900}, 
    {     0.00000000137,  2.85270426804,   119116.85160956658}, 
    {     0.00000000161,  5.91460332085,   207643.84320240439}, 
    {     0.00000000130,  6.26916213189,   137678.19129947099}, 
    {     0.00000000130,  0.93333784378,      433.71173787680}, 
    {     0.00000000140,  1.22461009264,    26137.89976347840}, 
    {     0.00000000144,  4.56299590276,      419.48464387520}, 
    {     0.00000000145,  2.53286017990,   116917.76426627958}, 
    {     0.00000000145,  3.74606623720,    27140.17152476259}, 
    {     0.00000000155,  3.66242807884,   365230.64398203876}, 
    {     0.00000000124,  0.92717268171,   104347.73123093879}, 
    {     0.00000000140,  0.11273697711,    78109.93061423779}, 
    {     0.00000000126,  1.13792891192,    51322.60990139639}, 
    {     0.00000000146,  3.25663561950,     3340.61242669980}, 
    {     0.00000000121,  5.11057976962,   176953.98994186718}, 
    {     0.00000000125,  5.63667517623,   104355.49390165479}, 
    {     0.00000000155,  2.30838615600,    51756.32163927320}, 
    {     0.00000000136,  3.42158321317,   140652.80125408198}, 
    {     0.00000000115,  6.25287963576,    39743.76363275060}, 
    {     0.00000000113,  0.79347022340,     7994.52844202420}, 
    {     0.00000000126,  0.12477471678,    52815.70356946240}, 
    {     0.00000000121,  0.68062705120,    50483.64061364600}, 
    {     0.00000000118,  0.87289599411,   137210.22630911658}, 
    {     0.00000000112,  2.41400200785,    97580.90196505119}, 
    {     0.00000000130,  1.22636157340,   209812.60368468695}, 
    {     0.00000000110,  3.15710759789,    25234.70675982219}, 
    {     0.00000000109,  2.85474641096,    24395.73747207180}, 
    {     0.00000000108,  5.73546302458,      853.19638175200}, 
    {     0.00000000141,  4.76861590569,    28421.09953444620}, 
    {     0.00000000143,  0.57981900049,   170049.17029103659}, 
    {     0.00000000127,  5.39584845133,   110634.68841628819}, 
    {     0.00000000110,  0.79295057311,   104564.91166173479}, 
    {     0.00000000102,  5.77868711823,   182085.63102592478}, 
    {     0.00000000108,  0.78119056015,    42153.96900304900}, 
    {     0.00000000101,  6.24154568899,     1692.16566950240}, 
    {     0.00000000125,  1.72826454224,   104344.49901929598}, 
    {     0.00000000112,  1.53710769184,    18093.37469954999}, 
    {     0.00000000100,  6.03680991052,   147423.51185532758}, 
    {     0.00000000102,  2.16764418605,    32769.12799497380}, 
    {     0.00000000127,  5.69553247654,    44181.27784112419}, 
    {     0.00000000096,  2.81661028351,   104202.04936916218}, 
    {     0.00000000095,  6.16381857353,   103299.34418310839}, 
    {     0.00000000095,  3.08577324660,    70269.18098269838}, 
    {     0.00000000096,  3.26683160108,   103285.11708910679}, 
    {     0.00000000101,  1.49873307582,    40565.25432477420}, 
    {     0.00000000099,  0.12170167751,   167850.08294774959}, 
    {     0.00000000099,  3.80889608656,   214364.55718174578}, 
    {     0.00000000093,  3.27145572677,    90695.75207512038}, 
    {     0.00000000104,  5.35399197115,   126996.94076290558}, 
    {     0.00000000105,  0.73047337573,   104778.21075717278}, 
    {     0.00000000089,  2.82729264680,    50579.61984086379}, 
    {     0.00000000098,  0.55396763839,    33967.99229491319}, 
    {     0.00000000087,  1.47914076091,    97670.38771289718}, 
    {     0.00000000089,  0.41556188853,    26164.16921284980}, 
    {     0.00000000117,  0.17847108292,    61279.71327726600}, 
    {     0.00000000103,  2.68612271799,   172402.03644480839}, 
    {     0.00000000091,  2.29372021338,   157057.10981453978}, 
    {     0.00000000084,  4.31845216169,    60055.89543648739}, 
    {     0.00000000085,  4.50689362891,   104358.72611329758}, 
    {     0.00000000098,  0.75115343364,   105940.68546158058}, 
    {     0.00000000082,  2.80073166731,    52101.02468458109}, 
    {     0.00000000086,  0.38064985881,    74923.09699802278}, 
    {     0.00000000077,  4.91622546328,    24491.71669928959}, 
    {     0.00000000104,  6.08675041589,    10021.83728009940}, 
    {     0.00000000094,  2.21717937515,    25973.46385288896}, 
    {     0.00000000079,  4.63581240332,     2333.19639287200}, 
    {     0.00000000076,  4.09099479123,     1596.18644228460}, 
    {     0.00000000076,  0.07595547847,   157586.80077963437}, 
    {     0.00000000089,  0.51924284800,    50593.84693486539}, 
    {     0.00000000078,  5.85409167716,    18207.81398823521}, 
    {     0.00000000083,  1.48349269554,    54294.57014352679}, 
    {     0.00000000102,  1.11721130868,   150244.34299945379}, 
    {     0.00000000081,  0.43636227439,   155571.81910783658}, 
    {     0.00000000072,  2.77542766328,    77829.99768684579}, 
    {     0.00000000098,  3.04610370668,    16066.06586147480}, 
    {     0.00000000089,  3.91490438550,    68241.87214462319}, 
    {     0.00000000076,  3.32866048942,   129799.61842155698}, 
    {     0.00000000091,  4.99129744497,   102132.85546210999}, 
    {     0.00000000088,  4.54427823805,    51543.02254383520}, 
    {     0.00000000092,  4.88784734744,    26202.34243025941}, 
    {     0.00000000066,  1.97294274713,      632.78373931320}, 
    {     0.00000000066,  1.34878248252,    52808.59002246159}, 
    {     0.00000000071,  1.21542275966,   107794.18751126219}, 
    {     0.00000000088,  3.90645324859,       74.78159856730}, 
    {     0.00000000076,  1.11687579908,    78731.67441507700}, 
    {     0.00000000060,  4.94675806504,    78257.08086582259}, 
    {     0.00000000069,  5.46700599210,    77844.22478084739}, 
    {     0.00000000067,  4.25059971851,    14477.35118320000}, 
    {     0.00000000060,  2.79968815396,    25863.55834587229}, 
    {     0.00000000060,  4.24009349898,    52225.80290505260}, 
    {     0.00000000059,  3.80960613484,    76571.54375522019}, 
    {     0.00000000059,  5.90296243964,      103.09277421860}, 
    {     0.00000000060,  5.62071455354,    77795.74443436819}, 
    {     0.00000000069,  4.37177618753,   207593.84658050018}, 
    {     0.00000000066,  0.49864122197,    51951.46148744649}, 
    {     0.00000000058,  4.28165906216,    77410.51304297059}, 
    {     0.00000000058,  1.63829215440,    51013.33157874059}, 
    {     0.00000000066,  0.61355815218,    51639.00177105299}, 
    {     0.00000000057,  3.15664991567,   104275.34649502118}, 
    {     0.00000000058,  4.41184070176,    26720.68688088739}, 
    {     0.00000000075,  0.13948969985,     1581.95934828300}, 
    {     0.00000000057,  0.42010984372,    23439.44831610119}, 
    {     0.00000000069,  6.03960082139,    29428.51556827400}, 
    {     0.00000000055,  0.87572150774,   161079.37234650398}, 
    {     0.00000000054,  2.10493067106,     2648.45482547300}, 
    {     0.00000000070,  1.89517732514,   204151.27163553478}, 
    {     0.00000000054,  3.73432597012,    24925.42843716640}, 
    {     0.00000000055,  4.74357158199,    49527.35145767539}, 
    {     0.00000000071,  2.67042805934,    24505.94379329119}, 
    {     0.00000000057,  1.10423273567,   130459.18546877075}, 
    {     0.00000000068,  5.29165355820,    26013.12154300690}, 
    {     0.00000000054,  0.06015891365,    52072.71350892979}, 
    {     0.00000000053,  0.06492319557,      536.80451209540}, 
    {     0.00000000053,  5.00803045767,    25977.69682035479}, 
    {     0.00000000052,  4.17449418547,    25131.61398560359}, 
    {     0.00000000052,  3.31068956896,     7880.08915333899}, 
    {     0.00000000070,  6.10736618856,    52278.89905736699}, 
    {     0.00000000052,  0.17906201530,      224.34479570190}, 
    {     0.00000000059,  1.97907742423,    51219.51712717779}, 
    {     0.00000000057,  2.64610234569,    52125.80966124419}, 
    {     0.00000000051,  2.51000813692,   183570.92173262799}, 
    {     0.00000000050,  4.67879007204,   130226.21661243298}, 
    {     0.00000000050,  4.77338184815,    25780.34552060460}, 
    {     0.00000000053,  2.81565030425,    55516.41870984820}, 
    {     0.00000000057,  2.13334998272,   128320.75184749259}, 
    {     0.00000000049,  2.32089689347,    26395.46076254379}, 
    {     0.00000000049,  4.95995730259,      956.28915597060}, 
    {     0.00000000047,  4.20639928841,    52250.58788171570}, 
    {     0.00000000058,  2.23088726891,    52065.59996192899}, 
    {     0.00000000048,  5.31281750704,     1162.47470440780}, 
    {     0.00000000062,  6.11760884137,    22747.29071487440}, 
    {     0.00000000051,  5.16824462074,   130419.84594697120}, 
    {     0.00000000058,  1.50489246106,    54509.00267602040}, 
    {     0.00000000060,  0.43878956930,   116783.65521669458}, 
    {     0.00000000059,  1.50481526118,    26507.38778544939}, 
    {     0.00000000047,  3.28472646958,    25565.32572348040}, 
    {     0.00000000056,  2.45380736735,   181026.24909573558}, 
    {     0.00000000045,  0.64406765475,    52698.38370124219}, 
    {     0.00000000051,  3.46813739714,    53242.30176033840}, 
    {     0.00000000049,  0.43567376549,    27999.10262479140}, 
    {     0.00000000046,  0.93498183343,    26162.68474014150}, 
    {     0.00000000043,  5.95322613197,    76667.52298243798}, 
    {     0.00000000060,  1.79766045757,    78270.33798362259}, 
    {     0.00000000056,  2.27821469853,   182188.72380014337}, 
    {     0.00000000043,  2.06804186419,    51859.41441349179}, 
    {     0.00000000043,  3.95891822367,    26521.61487945100}, 
    {     0.00000000044,  1.68132632019,    23888.81579828719}, 
    {     0.00000000051,  5.32970797935,    66653.15746634839}, 
    {     0.00000000054,  3.94227996000,    52325.36948028299}, 
    {     0.00000000043,  5.13712390348,    11610.55195837420}, 
    {     0.00000000042,  4.61414913450,    52492.19815280499}, 
    {     0.00000000046,  3.39644477960,   104505.39137678158}, 
    {     0.00000000046,  4.83404952611,      110.20632121940}, 
    {     0.00000000045,  3.54033283524,    50800.03248330259}, 
    {     0.00000000041,  5.69274197267,    24712.12934172840}, 
    {     0.00000000040,  0.05183500108,   123200.84011627098}, 
    {     0.00000000053,  0.61041631437,    53228.07466633679}, 
    {     0.00000000039,  3.11160576014,    25984.81036735560}, 
    {     0.00000000046,  2.53560218838,    50696.93970908399}, 
    {     0.00000000038,  4.44347866550,    29416.03879785439}, 
    {     0.00000000041,  2.65684897050,   233731.74634397858}, 
    {     0.00000000037,  3.37391100283,     1375.77379984580}, 
    {     0.00000000038,  5.61387655032,   143005.66740785378}, 
    {     0.00000000037,  5.42858193090,    28286.99048486120}, 
    {     0.00000000049,  5.33663311556,    99024.13645791399}, 
    {     0.00000000040,  5.63437453789,      522.57741809380}, 
    {     0.00000000036,  5.94438052681,   145204.75475114079}, 
    {     0.00000000037,  5.22344534146,    52595.29092702359}, 
    {     0.00000000039,  3.40316202566,    25551.09862947879}, 
    {     0.00000000038,  2.07724899910,   153084.84390447979}, 
    {     0.00000000039,  3.20082564706,   163766.09444104518}, 
    {     0.00000000042,  4.90498753252,    25771.51127191760}, 
    {     0.00000000041,  2.99014186750,    26190.99591579279}, 
    {     0.00000000044,  1.11568032791,    26404.29501123080}, 
    {     0.00000000045,  4.61945019127,   132658.27281205778}, 
    {     0.00000000037,  0.21864451347,   166740.70439565618}, 
    {     0.00000000034,  1.94277190876,   203041.89308344138}, 
    {     0.00000000045,  3.16163643681,   104197.83375581198}, 
    {     0.00000000046,  4.46390395917,      316.39186965660}, 
    {     0.00000000039,  2.02714443659,   136722.59155786238}, 
    {     0.00000000034,  1.34251978696,      467.96499035440}, 
    {     0.00000000043,  3.34502651928,    78903.60671103658}, 
    {     0.00000000039,  3.65197311309,   196137.07343261078}, 
    {     0.00000000037,  0.36873111038,   391318.54712361297}, 
    {     0.00000000037,  2.88381301226,    36109.74042167360}, 
    {     0.00000000037,  1.66449371180,    52290.24557183361}, 
    {     0.00000000036,  3.91802057863,    54087.00576636560}, 
    {     0.00000000034,  0.07829118699,    26294.08869001139}, 
    {     0.00000000033,  2.57632788743,    26941.09952332620}, 
    {     0.00000000034,  1.66576107128,    49842.60989027639}, 
    {     0.00000000042,  3.65180415116,    76681.75007643958}, 
    {     0.00000000032,  4.02686738221,    24356.78078864160}, 
    {     0.00000000041,  3.48139478644,    26610.48055966799}, 
    {     0.00000000042,  4.68451282229,    24609.03656750980}, 
    {     0.00000000040,  1.30779951065,    77630.92568540938}, 
    {     0.00000000033,  3.31610603906,    65831.66677432480}, 
    {     0.00000000031,  0.54967680937,    13362.44970679920}, 
    {     0.00000000034,  2.43294564200,    26421.75908234360}, 
    {     0.00000000031,  2.40792798784,   130443.39704322898}, 
    {     0.00000000035,  5.90129083656,    78188.92782615528}, 
    {     0.00000000032,  5.58376072198,    25881.71759313700}, 
    {     0.00000000031,  3.98178993050,   130435.63437251298}, 
    {     0.00000000032,  3.03405555905,    27780.06881107659}, 
    {     0.00000000031,  5.37276115971,    75930.51303185058}, 
    {     0.00000000038,  4.61595624173,   130432.40216087017}, 
    {     0.00000000034,  4.68012563436,    25754.04720080480}, 
    {     0.00000000030,  2.76994252191,   173511.41499690177}, 
    {     0.00000000037,  4.37555392925,     1478.86657406440}, 
    {     0.00000000030,  2.69926409993,   208173.53416749898}, 
    {     0.00000000039,  4.04332875289,    34282.17847478280}, 
    {     0.00000000033,  1.47225901574,    55503.94193942859}, 
    {     0.00000000029,  3.09378372977,    27819.02549450680}, 
    {     0.00000000030,  2.31018804154,    26624.70765366959}, 
    {     0.00000000027,  0.66232275031,   240452.46032331996}, 
    {     0.00000000035,  2.18492047595,    22759.76748529401}, 
    {     0.00000000035,  5.40621887499,    58857.03113654799}, 
    {     0.00000000028,  5.46919985489,   123668.80510662538}, 
    {     0.00000000028,  3.82777149286,   130866.11389874699}, 
    {     0.00000000027,  3.91211962905,   163298.12945069079}, 
    {     0.00000000032,  3.55778676569,    52252.07235442399}, 
    {     0.00000000036,  5.27162720206,    52061.36699446317}, 
    {     0.00000000027,  0.81850160176,    25455.11940226100}, 
    {     0.00000000030,  6.23443583867,    24176.70365835700}, 
    {     0.00000000025,  1.48733698955,    60370.08161635699}, 
    {     0.00000000025,  3.33473959558,      206.18554843720}, 
    {     0.00000000025,  2.23020748610,    12725.45343477500}, 
    {     0.00000000027,  4.42031362938,    78896.49316403578}, 
    {     0.00000000025,  5.37655641321,   183145.01295611398}, 
    {     0.00000000026,  3.84636156987,   132028.58860315479}, 
    {     0.00000000025,  2.93714796459,   129387.24732468258}, 
    {     0.00000000024,  4.03438874235,    26089.38761428249}, 
    {     0.00000000024,  4.80804047978,    27311.72098235281}, 
    {     0.00000000025,  5.86264185382,   130289.95251073639}, 
    {     0.00000000024,  3.09117849899,    26086.41866886590}, 
    {     0.00000000024,  1.40367634737,    25446.48957983520}, 
    {     0.00000000034,  3.35416716912,   193937.98608932378}, 
    {     0.00000000033,  4.25244677806,   235900.50682626116}, 
    {     0.00000000024,  2.35927539622,    25440.89230825939}, 
    {     0.00000000027,  2.64020366218,    44295.71712980940}, 
    {     0.00000000024,  2.60446530529,   125112.03959948818}, 
    {     0.00000000028,  3.86103745286,   130652.81480330898}, 
    {     0.00000000026,  3.37480543898,    87367.61641884019}, 
    {     0.00000000024,  3.83246872537,    52381.99183158559}, 
    {     0.00000000023,  0.19120233351,      647.01083331480}, 
    {     0.00000000027,  4.14812612960,   176332.24614102798}, 
    {     0.00000000023,  5.73059971283,    26729.31670331319}, 
    {     0.00000000025,  0.03995490746,   129373.02023068098}, 
    {     0.00000000028,  6.14165948724,    38813.35657634920}, 
    {     0.00000000025,  5.64177196482,   198489.93958638258}, 
    {     0.00000000026,  2.77862008850,    64901.25971792339}, 
    {     0.00000000022,  2.47522981968,    24864.08530079559}, 
    {     0.00000000023,  4.26566547587,    26222.01219115920}, 
    {     0.00000000024,  4.52888862412,   123758.29085447139}, 
    {     0.00000000022,  2.21341244399,    23866.04650697719}, 
    {     0.00000000023,  2.89086354510,    25953.79409198919}, 
    {     0.00000000028,  4.67525933004,    80382.47328510099}, 
    {     0.00000000025,  0.81895690109,    94329.77528619739}, 
    {     0.00000000021,  5.56950527628,    52712.61079524379}, 
    {     0.00000000021,  0.94595250629,    27684.08958385880}, 
    {     0.00000000023,  1.24936319391,   130446.62925487179}, 
    {     0.00000000022,  1.55521011593,    24998.19435038059}, 
    {     0.00000000024,  3.25849979981,    27669.86248985719}, 
    {     0.00000000021,  3.15563465532,   183674.70392120858}, 
    {     0.00000000020,  1.45816857985,    75615.25459924959}, 
    {     0.00000000028,  2.65265871685,    78366.80219894118}, 
    {     0.00000000020,  2.85755801769,    78160.61665050399}, 
    {     0.00000000022,  0.13822368415,    51528.79544983359}, 
    {     0.00000000022,  1.54444862819,   158746.17595363196}, 
    {     0.00000000019,  1.96807510475,    25344.91308104160}, 
    {     0.00000000019,  3.62647514058,    78039.36462902068}, 
    {     0.00000000019,  2.59520978672,    17893.62780836560}, 
    {     0.00000000019,  5.07604473723,   230239.17477710896}, 
    {     0.00000000019,  5.86669383027,   103917.90082841998}, 
    {     0.00000000023,  1.73834723518,   128220.75860368418}, 
    {     0.00000000020,  5.58923906956,    27177.61193276780}, 
    {     0.00000000018,  3.70639453097,    77726.90491262719}, 
    {     0.00000000019,  2.26467048619,   103932.12792242158}, 
    {     0.00000000018,  5.25381269855,    28736.35796704720}, 
    {     0.00000000018,  4.77217402671,    77101.23472031478}, 
    {     0.00000000019,  3.72677202378,    31415.37924995700}, 
    {     0.00000000019,  4.18744479746,   104819.57755665119}, 
    {     0.00000000018,  5.12111730170,    77307.42026875199}, 
    {     0.00000000019,  1.61508433009,    51653.22886505459}, 
    {     0.00000000022,  3.45701154104,   101011.00013959699}, 
    {     0.00000000018,  0.82201704537,    26073.67604757259}, 
    {     0.00000000017,  3.34555502934,    23919.14265929160}, 
    {     0.00000000017,  0.84066532921,    86143.79857806159}, 
    {     0.00000000016,  1.27849952927,    51868.24866217880}, 
    {     0.00000000020,  0.96796480913,    52609.51802102519}, 
    {     0.00000000018,  5.44449345767,    25508.21555457540}, 
    {     0.00000000016,  0.52044099995,     2221.85663459700}, 
    {     0.00000000022,  3.54324097486,   181659.72224941078}, 
    {     0.00000000020,  0.07176334053,   155887.52156313117}, 
    {     0.00000000016,  0.63079626568,   102659.44689679438}, 
    {     0.00000000017,  3.92564748171,    51852.30086649099}, 
    {     0.00000000016,  5.74192653915,    96357.08412427259}, 
    {     0.00000000019,  5.08675029863,   118828.96374949679}, 
    {     0.00000000017,  2.60085033622,    24448.83362438620}, 
    {     0.00000000016,  5.52297362078,     2199.08734328700}, 
    {     0.00000000016,  3.37075960327,     1911.19948321720}, 
    {     0.00000000019,  1.29587844050,   233681.74972207438}, 
    {     0.00000000020,  3.18923375101,    51969.62073471119}, 
    {     0.00000000016,  1.11677427544,   103498.41618454478}, 
    {     0.00000000017,  3.27627721422,    26312.24793727610}, 
    {     0.00000000016,  1.13221502154,      742.99006053260}, 
    {     0.00000000016,  5.54277096187,   207114.15223730978}, 
    {     0.00000000015,  2.75454442350,    26709.64694241340}, 
    {     0.00000000016,  5.31988541460,    78153.50310350319}, 
    {     0.00000000015,  1.72659803202,   104344.98400739678}, 
    {     0.00000000015,  1.16473739048,    92741.06060792258}, 
    {     0.00000000015,  6.19260970054,   130363.24963659538}, 
    {     0.00000000015,  4.39941864192,    25466.15934073500}, 
    {     0.00000000015,  5.91639466654,    81604.32185142238}, 
    {     0.00000000016,  1.77978327250,    26667.59072857300}, 
    {     0.00000000014,  1.02452017274,    78313.70604662679}, 
    {     0.00000000016,  1.76432370787,    27044.19229754480}, 
    {     0.00000000014,  2.39923226256,   103883.64757594238}, 
    {     0.00000000019,  6.27439143020,    25764.39772491679}, 
    {     0.00000000014,  1.89468926641,    37698.45509994840}, 
    {     0.00000000015,  2.42074969299,    27250.37784598199}, 
    {     0.00000000017,  5.62209405324,    51432.81622261579}, 
    {     0.00000000014,  0.57719222986,     8194.27533320860}, 
    {     0.00000000016,  3.05485736253,    22625.65843570900}, 
    {     0.00000000014,  2.01915358765,   156507.74908854539}, 
    {     0.00000000014,  4.00068734895,   187167.27548807819}, 
    {     0.00000000018,  2.79341357052,      323.50541665740}, 
    {     0.00000000014,  3.81393790220,    28256.66362385679}, 
    {     0.00000000016,  5.63776026285,   209658.82487420218}, 
    {     0.00000000014,  0.41463717901,    76887.93562487679}, 
    {     0.00000000015,  4.52522828506,    27726.97265876220}, 
    {     0.00000000017,  1.61712241486,    26198.10946279360}, 
    {     0.00000000017,  4.28622469558,   133882.09065283638}, 
    {     0.00000000013,  1.03005720435,    25867.49049913539}, 
    {     0.00000000014,  5.57249033787,     2008.55753915900}, 
    {     0.00000000014,  1.55327261244,   156314.11975400719}, 
    {     0.00000000017,  6.07980209544,    49953.94964855139}, 
    {     0.00000000015,  4.87082556178,   104358.24112519680}, 
    {     0.00000000013,  3.77190272158,       19.66976089979}, 
    {     0.00000000014,  1.15128244599,      949.17560896980}, 
    {     0.00000000015,  5.41370603467,   208276.62694171758}, 
    {     0.00000000017,  4.64348696761,   112231.70171963578}, 
    {     0.00000000015,  5.32660829331,   154408.65498906678}, 
    {     0.00000000013,  2.83396822652,    25169.97285559240}, 
    {     0.00000000013,  4.02048329912,   417406.45026518717}, 
    {     0.00000000016,  3.55065193748,    86457.98475793119}, 
    {     0.00000000014,  3.36690643779,    12546.48193908300}, 
    {     0.00000000013,  0.99936337980,    78338.49102328988}, 
    {     0.00000000012,  3.73185561368,    78786.28684281638}, 
    {     0.00000000013,  4.55944709442,    80596.90581759460}, 
    {     0.00000000013,  3.68826251139,    79315.97780791098}, 
    {     0.00000000014,  4.16798439220,   156547.08861034496}, 
    {     0.00000000012,  3.12250614731,   149288.74325784518}, 
    {     0.00000000012,  2.69822275229,      153.77881048480}, 
    {     0.00000000012,  4.38117483432,    27005.83342755599}, 
    {     0.00000000012,  0.18670274235,    27463.67694142000}, 
    {     0.00000000014,  4.15157533592,    29550.14784743939}, 
    {     0.00000000012,  2.80242906300,   102755.42612401219}, 
    {     0.00000000011,  5.82534982697,   259819.64948555276}, 
    {     0.00000000011,  2.40751499410,   169093.57054942798}, 
    {     0.00000000012,  0.49717322689,   102769.65321801379}, 
    {     0.00000000014,  5.70135994622,    76784.84285065818}, 
    {     0.00000000012,  5.56466695759,    26402.08932144380}, 
    {     0.00000000012,  5.20939267480,    77947.31755506598}, 
    {     0.00000000012,  1.48332519091,    78580.10129437919}, 
    {     0.00000000011,  1.64550613889,    25773.71696170459}, 
    {     0.00000000014,  2.00272444242,      846.08283475120}, 
    {     0.00000000011,  2.45694663172,    34082.43158359840}, 
    {     0.00000000013,  0.71976807921,    78413.27262185719}, 
    {     0.00000000011,  5.17923563094,   162810.49469943657}, 
    {     0.00000000011,  5.59096637831,    24203.00197815680}, 
    {     0.00000000011,  2.73725230614,   171292.65789271498}, 
    {     0.00000000011,  0.45561312943,     2111.65031337760}, 
    {     0.00000000010,  3.29302391758,   192828.60753723037}, 
    {     0.00000000010,  0.45749830582,   222224.97657418498}, 
    {     0.00000000013,  5.70888843757,    78213.71280281838}, 
    {     0.00000000011,  0.63918585952,    26118.23000257860}, 
    {     0.00000000011,  4.37242083406,   103718.82882698359}, 
    {     0.00000000013,  5.83046207525,    26411.40855823160}, 
    {     0.00000000010,  4.69854881597,     2125.87740737920}, 
    {     0.00000000010,  5.45767490076,    52483.36390411799}, 
    {     0.00000000011,  0.28780192978,    26057.57628056979}, 
    {     0.00000000009,  5.57296516954,   151199.94274106238}, 
    {     0.00000000011,  0.03043165356,   104991.50985261079}, 
    {     0.00000000013,  0.25136435742,    79330.20490191258}, 
    {     0.00000000010,  6.23928786518,   128106.31931499895}, 
    {     0.00000000009,  3.68851867839,   148532.89040742096}, 
    {     0.00000000013,  3.60684923313,    39629.32434406539}, 
    {     0.00000000011,  6.22990755807,   130285.73689738619}, 
    {     0.00000000011,  2.89470344307,   122444.98726584678}, 
    {     0.00000000010,  2.08672189789,    78683.19406859778}, 
    {     0.00000000011,  1.47256834447,   156520.30530244438}, 
    {     0.00000000009,  5.65081400311,     1265.56747862640}, 
    {     0.00000000009,  5.24103989320,   138319.60486120995}, 
    {     0.00000000012,  0.18150039505,   130593.29451835579}, 
    {     0.00000000009,  6.25519800847,    53906.92863608099}, 
    {     0.00000000011,  3.36897466391,   142871.55835826878}, 
    {     0.00000000009,  5.47220139772,   156531.30018480319}, 
    {     0.00000000009,  4.79193935369,   101703.15774082378}, 
    {     0.00000000009,  2.73233240796,       38.13303563780}, 
    {     0.00000000009,  5.92203424852,    62197.64356324779}, 
    {     0.00000000009,  4.73313854519,    78378.14871340781}, 
    {     0.00000000011,  0.80835589901,     3328.13565628019}, 
    {     0.00000000009,  6.25211275054,    91919.56991589899}, 
    {     0.00000000009,  5.86117346092,   199599.31813847595}, 
    {     0.00000000009,  0.76170025619,   156523.53751408719}, 
    {     0.00000000008,  2.63159027428,    25138.72753260440}, 
    {     0.00000000008,  0.63376834726,    80174.90890793978}, 
    {     0.00000000008,  5.01131881830,   229129.79622501558}, 
    {     0.00000000008,  0.59095609782,   156954.01704032118}, 
    {     0.00000000008,  3.96069371818,   120417.67842777158}, 
    {     0.00000000008,  0.20472704456,   113455.51956041438}, 
    {     0.00000000008,  0.21378629185,    13541.42120249119}, 
    {     0.00000000009,  6.19522776711,   189853.99758261938}, 
    {     0.00000000008,  3.46743939606,    77616.69859140778}, 
    {     0.00000000008,  1.77055863395,    26076.85744131030}, 
    {     0.00000000007,  0.60951368208,   158116.49174472898}, 
    {     0.00000000007,  5.88307805923,    51226.63067417859}, 
    {     0.00000000008,  2.06054527018,    78149.27013603736}, 
    {     0.00000000007,  0.67573699734,    52177.29075585669}, 
    {     0.00000000007,  0.56541937862,    25985.94062330859}, 
    {     0.00000000008,  5.86693477979,   104454.70534051539}, 
    {     0.00000000009,  1.96737763224,     1272.68102562720}, 
    {     0.00000000007,  0.44264721986,   104127.26777059489}, 
    {     0.00000000007,  0.08749528270,    90989.16285949759}, 
    {     0.00000000007,  0.73004980700,    78469.89497315978}, 
    {     0.00000000007,  6.23421813357,    52174.32181044009}, 
    {     0.00000000010,  2.72048541419,   104276.83096772949}, 
    {     0.00000000007,  5.16297609447,    26189.86565983980}, 
    {     0.00000000007,  5.16783260362,   179172.74704605396}, 
    {     0.00000000008,  0.19859791400,        1.48447270830}, 
    {     0.00000000008,  0.98974164620,    16703.06213349900}, 
    {     0.00000000007,  0.08448723866,    26098.94884183810}, 
    {     0.00000000007,  5.26655384619,    48847.67062686820}, 
    {     0.00000000007,  5.67290992258,    53029.00266490040}, 
    {     0.00000000007,  0.70298146974,    65717.22748563958}, 
    {     0.00000000007,  0.52879503896,   103814.80805420138}, 
    {     0.00000000007,  1.45586274186,    51841.95034237900}, 
    {     0.00000000008,  2.25244914252,   149756.70824819959}, 
    {     0.00000000007,  1.96966094639,   103395.32341032618}, 
    {     0.00000000007,  2.29501149303,    54374.89362643540}, 
    {     0.00000000007,  1.15651167402,   261988.40996783535}, 
    {     0.00000000007,  0.91078726535,    27972.80430499159}, 
    {     0.00000000007,  6.02717026150,   155475.15046625677}, 
    {     0.00000000008,  0.66507670910,   156740.71794488319}, 
    {     0.00000000007,  0.94700175748,   202420.14928260217}, 
    {     0.00000000008,  0.34134938947,    78339.97549599818}, 
    {     0.00000000008,  1.98845877732,    84944.93427812219}, 
    {     0.00000000006,  3.16993837728,    76041.85279012559}, 
    {     0.00000000007,  1.19047076397,   104984.39630560997}, 
    {     0.00000000007,  2.69108098458,   156377.85565231058}, 
    {     0.00000000007,  6.13097420651,    53867.97195265079}, 
    {     0.00000000007,  4.82055011453,    52286.01260436779}, 
    {     0.00000000006,  2.11609233880,      148.07872442630}, 
    {     0.00000000008,  5.56002050185,    52509.66222391780}, 
    {     0.00000000006,  3.05974031426,      151.04766984290}, 
    {     0.00000000007,  2.65161871524,      220.41264243880}, 
    {     0.00000000006,  2.56280940006,   224577.84272795678}, 
    {     0.00000000007,  0.86158158633,    50444.68393021580}, 
    {     0.00000000006,  2.00889517237,   102018.41617342478}, 
    {     0.00000000007,  1.62169979249,   103189.13786188899}, 
    {     0.00000000007,  0.09240531376,   220025.88923089796}, 
    {     0.00000000006,  4.82758891211,   154308.66174525839}, 
    {     0.00000000006,  2.40853261600,    78800.51393681798}, 
    {     0.00000000006,  5.65068346886,   234261.43730907318}, 
    {     0.00000000007,  1.38382796577,   106470.37642667518}, 
    {     0.00000000006,  2.68051758089,    77520.71936418998}, 
    {     0.00000000007,  0.27107569571,   127098.90328117118}, 
    {     0.00000000006,  0.91950758032,    57503.28239153120}, 
    {     0.00000000006,  5.40186174612,   130020.03106399579}, 
    {     0.00000000007,  4.61008524779,    81591.84508100279}, 
    {     0.00000000006,  2.52775281113,    52817.21984488739}, 
    {     0.00000000006,  0.06428030158,    53757.76563143139}, 
    {     0.00000000007,  3.13678251018,   155460.92337225519}, 
    {     0.00000000005,  2.16958206998,   104241.40624507738}, 
    {     0.00000000005,  2.16122225820,   209232.91609768818}, 
    {     0.00000000006,  2.67263390138,   130005.80396999417}, 
    {     0.00000000005,  1.01489122668,    55638.05098901359}, 
    {     0.00000000005,  1.58074341774,    50167.24874398939}, 
    {     0.00000000007,  1.32001119590,   149846.19399604558}, 
    {     0.00000000005,  2.48050355533,     9384.84100807520}, 
    {     0.00000000005,  3.64485355863,    39450.35284837340}, 
    {     0.00000000007,  5.71272099811,    70383.62027138360}, 
    {     0.00000000006,  4.54553892082,    51955.39364070959}, 
    {     0.00000000005,  3.69884871494,   266540.36346489414}, 
    {     0.00000000005,  3.50561067502,   102975.83876645098}, 
    {     0.00000000005,  3.97872155650,    53771.99272543299}, 
    {     0.00000000005,  1.30705357996,    53814.87580033639}, 
    {     0.00000000006,  1.01004635563,    77940.20400806518}, 
    {     0.00000000007,  6.03507811966,     1485.98012106520}, 
    {     0.00000000005,  2.49612730964,   102872.74599223239}, 
    {     0.00000000006,  0.44812743722,    50064.15596977079}, 
    {     0.00000000007,  3.00491549599,    50264.60679993120}, 
    {     0.00000000005,  4.43939776622,    51534.39272140940}, 
    {     0.00000000005,  2.29114170922,    61560.64729122359}, 
    {     0.00000000005,  0.95563241527,   130907.48069822539}, 
    {     0.00000000005,  0.07459937840,    78057.52387628538}, 
    {     0.00000000005,  1.56476312573,    53399.62412392700}, 
    {     0.00000000006,  4.33011184164,   156534.53239644598}, 
    {     0.00000000005,  4.55586232098,    52137.67324751059}, 
    {     0.00000000004,  0.55691399276,   189386.03259226495}, 
    {     0.00000000004,  2.65454855015,   107692.22499299659}, 
    {     0.00000000005,  3.71195236567,   128747.35003836859}, 
    {     0.00000000004,  0.50974112501,    54344.56676543099}, 
    {     0.00000000006,  6.09359126879,   104248.51979207818}, 
    {     0.00000000004,  5.91763059228,    52041.69723356339}, 
    {     0.00000000004,  4.01088339341,   104401.60918820098}, 
    {     0.00000000005,  0.98755148462,     1795.25844372100}, 
    {     0.00000000005,  4.16457595792,   129586.31932611899}, 
    {     0.00000000005,  3.17164389668,   181975.42470470538}, 
    {     0.00000000004,  6.18497065795,   209762.60706278277}, 
    {     0.00000000006,  4.82052927723,    77741.13200662879}, 
    {     0.00000000005,  0.22285727897,    50007.04580086580}, 
    {     0.00000000004,  4.57695596525,   184834.07909520617}, 
    {     0.00000000004,  2.32551642285,    53265.51507434200}, 
    {     0.00000000004,  4.83714899252,    52755.49387014719}, 
    {     0.00000000004,  0.47417846704,   105403.88094948517}, 
    {     0.00000000004,  2.61192597252,    50049.92887576919}, 
    {     0.00000000004,  1.01847002831,    52309.91533273340}, 
    {     0.00000000004,  4.93491619845,    63786.35824152260}, 
    {     0.00000000005,  0.29106641233,   207747.62539098498}, 
    {     0.00000000004,  5.23227546931,    52027.72755872209}, 
    {     0.00000000004,  4.51166201853,    77956.15180375299}, 
    {     0.00000000004,  5.45050466984,   129971.55071751658}, 
    {     0.00000000004,  3.77460109134,   104501.17576343138}, 
    {     0.00000000005,  5.22637270443,    51329.72344839720}, 
    {     0.00000000004,  1.64240288075,   130446.14426677099}, 
    {     0.00000000004,  4.12681734359,    52024.75861330549}, 
    {     0.00000000004,  1.28556784404,   112545.88789950538}, 
    {     0.00000000004,  4.76459208241,   130432.88714897096}, 
    {     0.00000000005,  1.15142161162,    27566.76971563859}, 
    {     0.00000000004,  3.50133847010,    76152.05911134499}, 
    {     0.00000000004,  3.46894421635,   128857.55635958798}, 
    {     0.00000000004,  5.61652153909,    43981.53094993980}, 
    {     0.00000000004,  4.02759705517,   104426.39416486409}, 
    {     0.00000000004,  1.34875445004,   106684.80895916879}, 
    {     0.00000000004,  5.13091111991,      735.87651353180}
};

  
static const struct ln_vsop mercury_latitude_b1[LAT_B1] = {
    {     0.00274646065,  3.95008450011,    26087.90314157420}, 
    {     0.00099737713,  3.14159265359,        0.00000000000}, 
    {     0.00018772047,  0.05141288887,    78263.70942472259}, 
    {     0.00023970726,  2.53272082947,    52175.80628314840}, 
    {     0.00008097508,  3.20946389315,   104351.61256629678}, 
    {     0.00002890729,  0.00943621371,   130439.51570787099}, 
    {     0.00000949669,  3.06780459575,   156527.41884944518}, 
    {     0.00000298013,  6.11414444304,   182615.32199101939}, 
    {     0.00000090863,  2.87023913203,   208703.22513259358}, 
    {     0.00000027163,  5.90488705529,   234791.12827416777}, 
    {     0.00000024677,  0.37210176608,    27197.28169366760}, 
    {     0.00000016001,  0.37499685422,    24978.52458948080}, 
    {     0.00000011035,  3.48855329110,    53285.18483524180}, 
    {     0.00000008004,  2.65315026358,   260879.03141574195}, 
    {     0.00000008817,  3.46732763537,    51066.42773105500}, 
    {     0.00000004863,  3.13533089859,    31749.23519072640}, 
    {     0.00000004419,  2.23904465242,    51116.42435295920}, 
    {     0.00000003814,  0.25548693522,    77154.33087262919}, 
    {     0.00000002815,  0.26202289859,    79373.08797681599}, 
    {     0.00000002530,  0.93822440376,    25028.52121138500}, 
    {     0.00000002333,  5.68288980482,   286966.93455731616}, 
    {     0.00000001895,  0.10856961205,    57837.13833230060}, 
    {     0.00000001701,  4.37082841476,    47623.85278608960}, 
    {     0.00000001899,  4.11252610224,    21535.94964451540}, 
    {     0.00000001471,  3.31454498058,   103242.23401420339}, 
    {     0.00000001398,  0.70775253481,    46514.47423399620}, 
    {     0.00000001479,  2.73615287841,     1109.37855209340}, 
    {     0.00000001354,  4.55218165396,    27043.50288318280}, 
    {     0.00000001109,  5.45818445766,    37410.56723987860}, 
    {     0.00000001052,  1.49151534032,     5661.33204915220}, 
    {     0.00000000930,  1.64333447742,    27147.28507176339}, 
    {     0.00000000989,  3.05243519620,    26107.57290247399}, 
    {     0.00000001079,  5.57037418878,    77204.32749453338}, 
    {     0.00000000906,  1.01615991422,    50586.73338786459}, 
    {     0.00000000883,  3.88701951249,    72602.37737557039}, 
    {     0.00000000815,  4.05203293287,    26068.23338067440}, 
    {     0.00000001010,  4.26926247841,     1059.38193018920}, 
    {     0.00000000865,  2.54233867528,    25132.30339996560}, 
    {     0.00000000861,  3.07069188532,    20426.57109242200}, 
    {     0.00000000804,  3.64421854876,    25558.21217647960}, 
    {     0.00000000801,  5.97109208562,    26084.02180621620}, 
    {     0.00000000731,  2.98501758578,    30639.85663863300}, 
    {     0.00000000638,  2.35143884682,    63498.47038145279}, 
    {     0.00000000834,  1.43265392502,    53131.40602475700}, 
    {     0.00000000681,  1.12652210230,    26091.78447693220}, 
    {     0.00000000633,  0.25824675505,      529.69096509460}, 
    {     0.00000000557,  1.64609790150,    51749.20809227239}, 
    {     0.00000000571,  5.59911115025,    51220.20654153979}, 
    {     0.00000000674,  2.42815855700,   313054.83769889036}, 
    {     0.00000000531,  0.08195485862,   129330.13715577759}, 
    {     0.00000000516,  3.30817563740,   105460.99111839019}, 
    {     0.00000000547,  4.88873057421,    53235.18821333759}, 
    {     0.00000000646,  5.15532565106,    51646.11531805379}, 
    {     0.00000000498,  6.25926046322,    39609.65458316560}, 
    {     0.00000000486,  1.90882118195,    41962.52073693740}, 
    {     0.00000000487,  1.46686338689,    14765.23904326980}, 
    {     0.00000000495,  1.33429661042,    73711.75592766379}, 
    {     0.00000000496,  6.18531128569,     1589.07289528380}, 
    {     0.00000000462,  0.10800789461,    28306.66024576099}, 
    {     0.00000000436,  3.94859010010,    26617.59410666880}, 
    {     0.00000000428,  2.66017504161,    32858.61374281979}, 
    {     0.00000000433,  2.66167748924,    10213.28554621100}, 
    {     0.00000000454,  1.26447194685,    52705.49724824299}, 
    {     0.00000000424,  2.16539582623,    24498.83024629040}, 
    {     0.00000000382,  4.92616226033,    13521.75144159140}, 
    {     0.00000000378,  2.51470161086,   110012.94461544899}, 
    {     0.00000000369,  0.49272546225,    23869.14603738740}, 
    {     0.00000000359,  6.10388198518,    52195.47604404819}, 
    {     0.00000000377,  0.82879515558,    52156.13652224860}, 
    {     0.00000000341,  3.96944896611,    76674.63652943878}, 
    {     0.00000000423,  6.02804558448,    56727.75978020720}, 
    {     0.00000000385,  1.53468252007,    43071.89928903080}, 
    {     0.00000000354,  2.22262764622,     4551.95349705880}, 
    {     0.00000000346,  4.52919441767,    22645.32819660879}, 
    {     0.00000000410,  0.69983495069,    98690.28051714458}, 
    {     0.00000000286,  3.35426943723,    54394.56338733519}, 
    {     0.00000000273,  2.36744757405,    77308.10968311399}, 
    {     0.00000000294,  2.74202105897,    52171.92494779040}, 
    {     0.00000000304,  2.38540570200,    19804.82729158280}, 
    {     0.00000000347,  5.86460557162,    25661.30495069820}, 
    {     0.00000000326,  5.95921822260,    58946.51688439399}, 
    {     0.00000000282,  4.58303975832,    40853.14218484400}, 
    {     0.00000000295,  4.14948936071,    19317.19254032860}, 
    {     0.00000000234,  2.42226658329,    51535.90899683439}, 
    {     0.00000000308,  4.18990062677,    52179.68761850640}, 
    {     0.00000000227,  3.10129561309,    29530.47808653960}, 
    {     0.00000000223,  3.39292203864,    52168.69273614759}, 
    {     0.00000000301,  4.98290551019,    83925.04147387479}, 
    {     0.00000000210,  1.29236814505,   129380.13377768178}, 
    {     0.00000000231,  2.78805501752,    27676.97603685800}, 
    {     0.00000000254,  1.75202182861,    79323.09135491178}, 
    {     0.00000000219,  3.11799781949,    65697.55772473979}, 
    {     0.00000000228,  4.75382145430,    69159.80243060499}, 
    {     0.00000000221,  5.66487908503,   136100.84775702319}, 
    {     0.00000000256,  4.33563337332,    78793.40038981718}, 
    {     0.00000000186,  5.08965761232,    51109.31080595839}, 
    {     0.00000000205,  5.61491216184,    15874.61759536320}, 
    {     0.00000000220,  5.33790249773,     9103.90699411760}, 
    {     0.00000000213,  2.92176515735,        7.11354700080}, 
    {     0.00000000254,  3.83544410132,   103292.23063610759}, 
    {     0.00000000182,  3.12436060186,   155418.04029735178}, 
    {     0.00000000172,  3.57237148676,    49957.04917896160}, 
    {     0.00000000170,  5.34074841499,    59414.48187474840}, 
    {     0.00000000198,  2.80899484175,    82815.66292178139}, 
    {     0.00000000169,  3.95433715382,    48733.23133818299}, 
    {     0.00000000160,  4.06638746066,    38654.05484155699}, 
    {     0.00000000169,  2.98278429311,    52182.91983014920}, 
    {     0.00000000164,  0.48406852660,    25035.63475838580}, 
    {     0.00000000193,  5.45282424425,   339142.74084046457}, 
    {     0.00000000167,  3.76968649610,   124778.18365871879}, 
    {     0.00000000177,  0.50498686165,    12566.15169998280}, 
    {     0.00000000174,  2.93891001182,     3442.57494496540}, 
    {     0.00000000139,  2.89354352723,    16983.99614745660}, 
    {     0.00000000135,  0.95689929067,    25021.40766438420}, 
    {     0.00000000135,  1.85739871878,     1066.49547719000}, 
    {     0.00000000140,  0.95231303882,    45405.09568190280}, 
    {     0.00000000129,  4.98272235175,    62389.09182935939}, 
    {     0.00000000163,  4.43252627959,    79219.30916633119}, 
    {     0.00000000127,  2.64712841018,     6283.07584999140}, 
    {     0.00000000148,  4.42851788044,      639.89728631400}, 
    {     0.00000000120,  5.47170236878,    89586.37352302698}, 
    {     0.00000000138,  4.66882702924,    25448.00585526019}, 
    {     0.00000000131,  2.39432798293,     1052.26838318840}, 
    {     0.00000000127,  4.28199485177,    45892.73043315699}, 
    {     0.00000000148,  5.88768686520,    26095.01668857500}, 
    {     0.00000000113,  5.41723025442,   103396.01282468818}, 
    {     0.00000000141,  0.66045444891,      955.59974160860}, 
    {     0.00000000132,  3.31487233981,    25874.60404613620}, 
    {     0.00000000111,  2.30602187706,    26514.50133245020}, 
    {     0.00000000127,  4.92872197982,    77837.11123384659}, 
    {     0.00000000146,  4.44514969950,    51123.53789995999}, 
    {     0.00000000108,  1.38943506443,    26301.20223701220}, 
    {     0.00000000107,  2.87108086381,    78283.37918562238}, 
    {     0.00000000107,  6.11750618089,    55618.38122811380}, 
    {     0.00000000106,  4.34929118982,    94138.32702008578}, 
    {     0.00000000141,  5.99037156525,    26080.78959457339}, 
    {     0.00000000140,  1.44143660799,    66941.04532641819}, 
    {     0.00000000145,  3.88502701676,    78244.03966382280}, 
    {     0.00000000114,  4.48951543952,   155468.03691925599}, 
    {     0.00000000127,  4.99565339762,     6770.71060124560}, 
    {     0.00000000122,  0.26346073379,    50057.04242277000}, 
    {     0.00000000106,  5.21881168514,      213.29909543800}, 
    {     0.00000000116,  0.96831158986,    78267.59076008058}, 
    {     0.00000000113,  1.04970035229,    11322.66409830440}, 
    {     0.00000000095,  2.69641328629,    33326.57873317420}, 
    {     0.00000000114,  1.09238127979,   104881.30353139139}, 
    {     0.00000000113,  5.10217474462,    52389.10537858640}, 
    {     0.00000000089,  5.79526808183,    78259.82808936459}, 
    {     0.00000000089,  2.61728576551,    77734.01845962799}, 
    {     0.00000000105,  5.07516625809,    18849.22754997420}, 
    {     0.00000000104,  4.85110269983,   105410.99449648599}, 
    {     0.00000000088,  0.07845540889,    80482.46652890938}, 
    {     0.00000000089,  0.17312185860,    36301.18868778519}, 
    {     0.00000000085,  2.60578915417,     2218.75710418680}, 
    {     0.00000000091,  0.98738393447,    64741.95798313119}, 
    {     0.00000000092,  5.59469661827,    77623.81213840858}, 
    {     0.00000000082,  1.92444262254,    77197.21394753258}, 
    {     0.00000000087,  0.20380347433,    78256.59587772179}, 
    {     0.00000000096,  0.08189739553,    32370.97899156560}, 
    {     0.00000000107,  5.83710041170,    53764.87917843220}, 
    {     0.00000000081,  3.69706776323,   125887.56221081219}, 
    {     0.00000000080,  5.03346565385,    38519.94579197200}, 
    {     0.00000000077,  6.07816721358,    78270.82297172339}, 
    {     0.00000000082,  0.51152795715,   102762.53967101299}, 
    {     0.00000000085,  1.92105479279,    88476.99497093359}, 
    {     0.00000000101,  0.96161245897,    74821.13447975718}, 
    {     0.00000000086,  0.56718393948,     2118.76386037840}, 
    {     0.00000000080,  5.85129854966,   108903.56606335558}, 
    {     0.00000000085,  0.33559096416,    68050.42387851159}, 
    {     0.00000000101,  2.44941820933,   162188.75089859738}, 
    {     0.00000000072,  5.40658854751,    52602.40447402440}, 
    {     0.00000000073,  1.35284250657,    77211.44104153418}, 
    {     0.00000000078,  1.82932544900,    23969.13928119580}, 
    {     0.00000000078,  1.14557641661,   103821.92160120218}, 
    {     0.00000000063,  0.55276835341,   150866.08680029298}, 
    {     0.00000000060,  0.75277278015,    51962.50718771040}, 
    {     0.00000000067,  0.35378094005,    76044.95232053580}, 
    {     0.00000000066,  1.22896212635,   120226.23016165999}, 
    {     0.00000000075,  1.90096013413,    44937.13069154840}, 
    {     0.00000000078,  2.65007000101,    85034.42002596818}, 
    {     0.00000000067,  5.96206801213,    99799.65906923798}, 
    {     0.00000000057,  4.04412361561,    71492.99882347698}, 
    {     0.00000000063,  2.22382469625,    64607.84893354619}, 
    {     0.00000000057,  1.26261980819,    26727.80042788820}, 
    {     0.00000000066,  5.08613056380,      426.59819087600}, 
    {     0.00000000061,  6.17937752731,   181505.94343892598}, 
    {     0.00000000057,  1.67383119023,    13655.86049117640}, 
    {     0.00000000055,  2.01862939432,    78477.00852016058}, 
    {     0.00000000059,  2.31048572111,    25934.12433108940}, 
    {     0.00000000052,  5.28302108918,   117873.36400788819}, 
    {     0.00000000058,  4.52853866098,    93028.94846799239}, 
    {     0.00000000051,  1.37470570114,    51742.09454527159}, 
    {     0.00000000049,  4.95150906291,    27154.39861876420}, 
    {     0.00000000054,  3.22580705063,    76144.94556434419}, 
    {     0.00000000055,  4.34494801509,   129909.82474277639}, 
    {     0.00000000052,  0.64534027826,   104331.94280539699}, 
    {     0.00000000049,  0.54893867721,   151975.46535238638}, 
    {     0.00000000050,  2.16547944799,   365230.64398203876}, 
    {     0.00000000042,  3.33958631905,    25654.19140369739}, 
    {     0.00000000043,  2.86670192586,    81706.28436968799}, 
    {     0.00000000045,  4.36618153094,    23754.70674870219}, 
    {     0.00000000046,  4.11608179511,   130969.20667296558}, 
    {     0.00000000042,  3.34341658738,    58458.88213313979}, 
    {     0.00000000043,  2.17611617409,   129483.91596626239}, 
    {     0.00000000040,  5.67208441017,    98068.53671630539}, 
    {     0.00000000054,  2.01769359183,    71980.63357473118}, 
    {     0.00000000041,  4.03526737986,   104355.49390165479}, 
    {     0.00000000044,  1.34241743313,    95247.70557217918}, 
    {     0.00000000048,  2.80283584379,    25668.41849769900}, 
    {     0.00000000052,  1.57841300473,    91785.46086631398}, 
    {     0.00000000051,  1.28828842075,   181555.94006083018}, 
    {     0.00000000040,  1.64623403786,   131498.89763806018}, 
    {     0.00000000043,  1.22261583745,    25619.93815121980}, 
    {     0.00000000038,  5.49413456622,      433.71173787680}, 
    {     0.00000000045,  3.79507198320,    25973.46385288896}, 
    {     0.00000000036,  0.95495171363,    12432.04265039780}, 
    {     0.00000000044,  2.60019583483,    79852.78232000639}, 
    {     0.00000000035,  3.78148248909,    78050.41032928458}, 
    {     0.00000000036,  1.55620646402,    35191.81013569180}, 
    {     0.00000000036,  3.27238519467,    51322.60990139639}, 
    {     0.00000000038,  4.98002708714,    71025.03383312259}, 
    {     0.00000000041,  5.50852676734,   188276.65404017158}, 
    {     0.00000000036,  6.11354609097,      419.48464387520}, 
    {     0.00000000039,  0.62636542709,    51756.32163927320}, 
    {     0.00000000033,  0.05318157962,   157636.79740153858}, 
    {     0.00000000031,  4.47853571883,    50579.61984086379}, 
    {     0.00000000042,  4.11842354719,    90829.86112470538}, 
    {     0.00000000041,  5.03998788697,   114564.89811250778}, 
    {     0.00000000041,  3.30990629103,    26202.34243025941}, 
    {     0.00000000029,  2.87668564214,   104358.72611329758}, 
    {     0.00000000029,  4.48238942132,   103299.34418310839}, 
    {     0.00000000029,  5.92039948279,   104371.28232719658}, 
    {     0.00000000037,  5.51946984459,    27140.17152476259}, 
    {     0.00000000027,  6.23586367522,   131548.89425996438}, 
    {     0.00000000028,  4.05590031045,    26241.68195205900}, 
    {     0.00000000028,  2.50435883057,   134991.46920492979}, 
    {     0.00000000033,  2.24161818527,    78690.30761559859}, 
    {     0.00000000033,  3.52014855585,    28206.66700195260}, 
    {     0.00000000034,  3.16651260001,    28421.09953444620}, 
    {     0.00000000026,  5.00736740368,    52026.24308601380}, 
    {     0.00000000029,  2.17466338621,   143961.26714946238}, 
    {     0.00000000027,  4.99746573906,   103285.11708910679}, 
    {     0.00000000025,  2.48133226582,     1596.18644228460}, 
    {     0.00000000027,  2.69046712792,    26137.89976347840}, 
    {     0.00000000024,  4.42906084435,    52815.70356946240}, 
    {     0.00000000024,  0.28078732255,    24491.71669928959}, 
    {     0.00000000027,  3.18888227928,   106570.36967048359}, 
    {     0.00000000026,  1.03825669554,   155997.72788435058}, 
    {     0.00000000025,  0.92922476652,    46848.33017476560}, 
    {     0.00000000030,  4.33105881883,   146314.13330323418}, 
    {     0.00000000023,  5.18080408909,   104564.91166173479}, 
    {     0.00000000028,  3.65474790938,      853.19638175200}, 
    {     0.00000000022,  0.85921724567,    97580.90196505119}, 
    {     0.00000000024,  1.23363961966,    44181.27784112419}, 
    {     0.00000000022,  0.70470227963,   130012.91751699499}, 
    {     0.00000000022,  4.49230772734,    77829.99768684579}, 
    {     0.00000000028,  2.49868158665,   103711.71527998279}, 
    {     0.00000000027,  3.29515496156,   104344.49901929598}, 
    {     0.00000000022,  0.44572975520,    84546.78527471398}, 
    {     0.00000000022,  5.88047033548,   111122.32316754239}, 
    {     0.00000000022,  2.60977946903,   124156.43985787958}, 
    {     0.00000000022,  4.44538253487,    26037.90651966999}, 
    {     0.00000000020,  4.82064305548,    50593.84693486539}, 
    {     0.00000000019,  2.55536179284,   104347.73123093879}, 
    {     0.00000000020,  4.64031139150,    39743.76363275060}, 
    {     0.00000000020,  5.75240741273,    26555.86813192860}, 
    {     0.00000000019,  3.61612329821,   176953.98994186718}, 
    {     0.00000000021,  1.87806754676,    53242.30176033840}, 
    {     0.00000000021,  5.33472392490,    25234.70675982219}, 
    {     0.00000000024,  3.22504783392,   103925.01437542078}, 
    {     0.00000000020,  0.66874668037,    24505.94379329119}, 
    {     0.00000000018,  4.02462395449,    25455.11940226100}, 
    {     0.00000000024,  3.43375195287,   102132.85546210999}, 
    {     0.00000000019,  2.22650377926,    51639.00177105299}, 
    {     0.00000000017,  5.55040575898,     7994.52844202420}, 
    {     0.00000000022,  2.31932242347,    33967.99229491319}, 
    {     0.00000000018,  3.12472807269,     2333.19639287200}, 
    {     0.00000000017,  1.33046572340,   119116.85160956658}, 
    {     0.00000000022,  2.31387117720,     7238.67559160000}, 
    {     0.00000000019,  3.58998679047,   100909.03762133139}, 
    {     0.00000000019,  3.87014504106,    77844.22478084739}, 
    {     0.00000000019,  3.09565971234,   183724.70054311278}, 
    {     0.00000000016,  5.37852102811,    52099.54021187280}, 
    {     0.00000000016,  0.33931328678,   104138.31347085879}, 
    {     0.00000000016,  3.61136447801,    25938.33994443960}, 
    {     0.00000000016,  4.67702694427,    70269.18098269838}, 
    {     0.00000000016,  3.62892599352,    45494.58142974879}, 
    {     0.00000000018,  0.09335270206,    52290.24557183361}, 
    {     0.00000000016,  4.26164005531,    18207.81398823521}, 
    {     0.00000000018,  3.03297999390,    18093.37469954999}, 
    {     0.00000000018,  1.42431884027,    52329.58509363319}, 
    {     0.00000000018,  1.95751842010,     1581.95934828300}, 
    {     0.00000000016,  5.77486682330,   105940.68546158058}, 
    {     0.00000000018,  4.34696486181,   207643.84320240439}, 
    {     0.00000000016,  5.63459120036,    60055.89543648739}, 
    {     0.00000000019,  3.63064346775,   178063.36849396059}, 
    {     0.00000000014,  2.24040737633,    26521.61487945100}, 
    {     0.00000000015,  0.02625056785,     5327.47610838280}, 
    {     0.00000000016,  2.36249545609,    53228.07466633679}, 
    {     0.00000000014,  4.71907120236,      536.80451209540}, 
    {     0.00000000014,  4.97342838812,      632.78373931320}, 
    {     0.00000000013,  0.88467126264,   157057.10981453978}, 
    {     0.00000000017,  3.02173052534,   128850.44281258718}, 
    {     0.00000000014,  3.69908958351,   130419.84594697120}, 
    {     0.00000000017,  2.97363257370,   207593.84658050018}, 
    {     0.00000000014,  3.36313158411,    26507.38778544939}, 
    {     0.00000000014,  5.19298126606,   391318.54712361297}, 
    {     0.00000000016,  6.22012529996,    54509.00267602040}, 
    {     0.00000000015,  0.11681094638,    77410.51304297059}, 
    {     0.00000000012,  1.76556010523,    97112.93697469679}, 
    {     0.00000000012,  1.25999627705,   131395.11544947959}, 
    {     0.00000000016,  0.55859453886,    52061.36699446317}, 
    {     0.00000000012,  4.71974002613,   157586.80077963437}, 
    {     0.00000000014,  1.83071724750,   140652.80125408198}, 
    {     0.00000000012,  2.28368820761,   214364.55718174578}, 
    {     0.00000000012,  6.24305669176,   102232.84870591838}, 
    {     0.00000000013,  0.94418392757,   116917.76426627958}, 
    {     0.00000000013,  5.67747595071,    52022.02747266360}, 
    {     0.00000000014,  2.65222906369,    52643.77127350280}, 
    {     0.00000000011,  4.46099054997,    90695.75207512038}, 
    {     0.00000000011,  0.77812998358,   130443.39704322898}, 
    {     0.00000000011,  4.78834330208,      647.01083331480}, 
    {     0.00000000012,  5.21629435630,   155571.81910783658}, 
    {     0.00000000010,  3.98538100953,    26011.63707029860}, 
    {     0.00000000011,  5.35398161802,    26610.48055966799}, 
    {     0.00000000014,  0.26737723968,    54294.57014352679}, 
    {     0.00000000012,  5.97381327440,    49527.35145767539}, 
    {     0.00000000011,  5.93849929007,   107794.18751126219}, 
    {     0.00000000011,  0.52555554946,    26941.09952332620}, 
    {     0.00000000010,  0.77987261513,    26081.27458267419}, 
    {     0.00000000010,  2.15201941222,    85502.38501632259}, 
    {     0.00000000010,  2.43032033570,    52698.38370124219}, 
    {     0.00000000012,  5.21081550816,    25551.09862947879}, 
    {     0.00000000013,  2.74248443392,    42153.96900304900}, 
    {     0.00000000009,  5.60699637563,    27684.08958385880}, 
    {     0.00000000009,  1.26689967531,    76667.52298243798}, 
    {     0.00000000010,  3.89379538762,   156100.82065856918}, 
    {     0.00000000012,  1.39954193335,    51543.02254383520}, 
    {     0.00000000012,  1.52257139502,    20760.42703319140}, 
    {     0.00000000009,  4.20492959289,   182085.63102592478}, 
    {     0.00000000011,  0.66834392142,    22759.76748529401}, 
    {     0.00000000010,  1.22929752466,     2648.45482547300}, 
    {     0.00000000009,  3.54074354837,    22747.29071487440}, 
    {     0.00000000010,  0.12918931028,    29416.03879785439}, 
    {     0.00000000011,  1.24509960603,    52125.80966124419}, 
    {     0.00000000011,  5.24371045714,   170049.17029103659}, 
    {     0.00000000009,  1.96952049653,    51528.79544983359}, 
    {     0.00000000008,  1.23297900240,   129387.24732468258}, 
    {     0.00000000010,  0.46604003447,    26624.70765366959}, 
    {     0.00000000009,  1.88003142152,    25565.32572348040}, 
    {     0.00000000008,  5.66609855382,   161079.37234650398}, 
    {     0.00000000010,  5.37595917575,   104778.21075717278}, 
    {     0.00000000010,  4.32195478071,    10021.83728009940}, 
    {     0.00000000008,  4.28630606896,   157483.01859105378}, 
    {     0.00000000010,  1.11167068209,   172402.03644480839}, 
    {     0.00000000008,  3.86388656968,    24864.08530079559}, 
    {     0.00000000010,  4.98434698939,    61279.71327726600}, 
    {     0.00000000008,  1.68789367623,   141762.17980617538}, 
    {     0.00000000008,  3.27159786562,    27311.72098235281}, 
    {     0.00000000010,  4.04735211723,    72936.23331633979}, 
    {     0.00000000009,  0.66661949850,      522.57741809380}, 
    {     0.00000000008,  2.11915755526,   111590.28815789679}, 
    {     0.00000000010,  3.96196817321,    26094.53170047421}, 
    {     0.00000000009,  5.97899217610,   209812.60368468695}, 
    {     0.00000000008,  5.90414175287,   130446.62925487179}, 
    {     0.00000000009,  4.70218884623,    26190.99591579279}, 
    {     0.00000000007,  5.00028838110,     7880.08915333899}, 
    {     0.00000000007,  0.27662602620,   105307.21230790539}, 
    {     0.00000000008,  3.59796141286,   110634.68841628819}, 
    {     0.00000000006,  4.71394306694,    78417.48823520739}, 
    {     0.00000000007,  5.65972341474,   129799.61842155698}, 
    {     0.00000000006,  1.30176713541,    78903.60671103658}, 
    {     0.00000000007,  0.48324947354,   204151.27163553478}, 
    {     0.00000000006,  2.68955966786,   130459.18546877075}, 
    {     0.00000000006,  3.91194449990,   123668.80510662538}, 
    {     0.00000000006,  4.25610046715,   121335.60871375339}, 
    {     0.00000000006,  4.39774898148,   145204.75475114079}, 
    {     0.00000000006,  2.03358239461,   130652.81480330898}, 
    {     0.00000000006,  5.10307826199,    13362.44970679920}, 
    {     0.00000000007,  5.73368412719,   150244.34299945379}, 
    {     0.00000000007,  1.79893081867,   129373.02023068098}, 
    {     0.00000000006,  1.60220757410,    31415.37924995700}, 
    {     0.00000000005,  5.33587354070,    77726.90491262719}, 
    {     0.00000000006,  0.69127308024,   103932.12792242158}, 
    {     0.00000000006,  1.30528239429,   103917.90082841998}, 
    {     0.00000000007,  3.42052770753,    25881.71759313700}, 
    {     0.00000000006,  0.20662663852,   128220.75860368418}, 
    {     0.00000000006,  1.76394381916,    76681.75007643958}, 
    {     0.00000000005,  1.55332352133,    65831.66677432480}, 
    {     0.00000000005,  0.39891046615,   203041.89308344138}, 
    {     0.00000000005,  5.00920311857,   154938.34595416138}, 
    {     0.00000000007,  0.07541993490,   130432.40216087017}, 
    {     0.00000000005,  3.95655297699,    25440.89230825939}, 
    {     0.00000000005,  1.60878156139,    25984.81036735560}, 
    {     0.00000000005,  5.63420105001,   130435.63437251298}, 
    {     0.00000000005,  5.71235725527,    52225.80290505260}, 
    {     0.00000000005,  4.82602182938,   123200.84011627098}, 
    {     0.00000000005,  4.28914322665,    51707.84129279399}, 
    {     0.00000000005,  2.45008961451,   132028.58860315479}, 
    {     0.00000000005,  3.44380232013,   130226.21661243298}, 
    {     0.00000000005,  0.69360997254,   126996.94076290558}, 
    {     0.00000000005,  1.20349712708,   233731.74634397858}, 
    {     0.00000000005,  4.94561230543,   137678.19129947099}, 
    {     0.00000000005,  4.02914734341,   143005.66740785378}, 
    {     0.00000000004,  3.15705475890,    78378.14871340781}, 
    {     0.00000000005,  6.19462947577,     1478.86657406440}, 
    {     0.00000000005,  6.19346173540,   132658.27281205778}, 
    {     0.00000000004,  4.93966028252,   166740.70439565618}, 
    {     0.00000000005,  5.83365858307,    68241.87214462319}, 
    {     0.00000000005,  4.88444080196,    79330.20490191258}, 
    {     0.00000000004,  1.49931528728,    26294.08869001139}, 
    {     0.00000000004,  4.91166258069,   167850.08294774959}, 
    {     0.00000000004,  0.51214147370,   156507.74908854539}, 
    {     0.00000000004,  2.48188443978,    11610.55195837420}, 
    {     0.00000000004,  5.18875909536,      206.18554843720}, 
    {     0.00000000004,  4.96587091153,    77630.92568540938}, 
    {     0.00000000004,  2.56954562406,   137210.22630911658}, 
    {     0.00000000005,  6.06172636184,     3340.61242669980}, 
    {     0.00000000004,  2.59361967134,     6681.22485339960}, 
    {     0.00000000004,  3.98182896060,    52712.61079524379}, 
    {     0.00000000004,  1.85196935264,    87367.61641884019}, 
    {     0.00000000004,  2.97167846271,    80596.90581759460}, 
    {     0.00000000004,  0.38918279754,    52595.29092702359}, 
    {     0.00000000005,  5.71555094572,    32769.12799497380}, 
    {     0.00000000004,  2.86579870082,   128320.75184749259}, 
    {     0.00000000004,  0.86678424442,    75930.51303185058}, 
    {     0.00000000004,  5.77822773684,    78731.67441507700}, 
    {     0.00000000003,  4.14814530126,    25867.49049913539}, 
    {     0.00000000004,  2.65786568260,    75615.25459924959}, 
    {     0.00000000004,  1.05721792395,   183570.92173262799}, 
    {     0.00000000004,  3.26707290101,    80382.47328510099}, 
    {     0.00000000004,  2.14799227897,   130866.11389874699}, 
    {     0.00000000004,  3.39584566237,    55503.94193942859}, 
    {     0.00000000004,  3.05837967978,   115674.27666460119}, 
    {     0.00000000004,  6.04280069605,   233681.74972207438}, 
    {     0.00000000004,  3.63969036598,    78149.27013603736}, 
    {     0.00000000004,  1.85496913222,   116783.65521669458}, 
    {     0.00000000004,  3.24711503875,   103498.41618454478}, 
    {     0.00000000003,  5.41660260354,    52609.51802102519}, 
    {     0.00000000003,  1.52254818578,   183674.70392120858}, 
    {     0.00000000004,  2.41183349287,     3328.13565628019}, 
    {     0.00000000004,  3.99911605099,      956.28915597060}, 
    {     0.00000000003,  4.42494674720,   102755.42612401219}, 
    {     0.00000000003,  3.85632951990,   156531.30018480319}, 
    {     0.00000000003,  5.43028376893,    79315.97780791098}, 
    {     0.00000000004,  1.56175361682,      149.56319713460}, 
    {     0.00000000003,  3.98774685670,   183145.01295611398}, 
    {     0.00000000003,  5.35092623925,    77616.69859140778}, 
    {     0.00000000003,  0.90485441793,       76.26607127560}, 
    {     0.00000000004,  2.70337567475,   133882.09065283638}, 
    {     0.00000000004,  2.08518328683,    78114.14622758799}, 
    {     0.00000000003,  2.33953532580,    86143.79857806159}, 
    {     0.00000000004,  0.81158752062,   182188.72380014337}, 
    {     0.00000000003,  2.11502738121,   196137.07343261078}, 
    {     0.00000000003,  0.95681396301,    12546.48193908300}, 
    {     0.00000000003,  1.37222728295,   181026.24909573558}, 
    {     0.00000000003,  2.23536000215,   417406.45026518717}, 
    {     0.00000000003,  5.37165007510,   240452.46032331996}, 
    {     0.00000000003,  1.20257903149,    44295.71712980940}, 
    {     0.00000000003,  0.52673171914,   136722.59155786238}, 
    {     0.00000000003,  0.52016201639,    71582.48457132299}, 
    {     0.00000000003,  3.50325656987,    49842.60989027639}, 
    {     0.00000000003,  3.62611352126,    53029.00266490040}, 
    {     0.00000000003,  1.62670747573,   104505.39137678158}, 
    {     0.00000000003,  3.48868699337,    51219.51712717779}, 
    {     0.00000000002,  3.67511083910,    19406.67828817460}, 
    {     0.00000000003,  0.39109925063,    66653.15746634839}, 
    {     0.00000000003,  2.84800545852,   235900.50682626116}, 
    {     0.00000000002,  5.66788822044,    52381.99183158559}, 
    {     0.00000000003,  5.55181174326,    78786.28684281638}, 
    {     0.00000000002,  4.88074649960,    64901.25971792339}, 
    {     0.00000000003,  1.50061931360,    52278.89905736699}, 
    {     0.00000000002,  1.30186439584,    96357.08412427259}, 
    {     0.00000000002,  4.21971266464,   198489.93958638258}, 
    {     0.00000000003,  2.00366252191,   181659.72224941078}, 
    {     0.00000000002,  3.71342666703,    48847.67062686820}, 
    {     0.00000000002,  5.93200805535,    16066.06586147480}, 
    {     0.00000000002,  1.05718481660,   208173.53416749898}, 
    {     0.00000000003,  2.15332656359,      103.09277421860}, 
    {     0.00000000002,  4.39182749038,   155475.15046625677}, 
    {     0.00000000003,  4.28206460476,    78213.71280281838}, 
    {     0.00000000003,  5.86398017019,    48835.19385644859}, 
    {     0.00000000002,  2.36207569977,    53771.99272543299}, 
    {     0.00000000002,  1.56910769250,   163766.09444104518}, 
    {     0.00000000002,  2.59173243384,    50483.64061364600}, 
    {     0.00000000003,  4.91698084392,   102769.65321801379}, 
    {     0.00000000002,  2.55209144895,   176332.24614102798}, 
    {     0.00000000002,  5.16963361594,    27669.86248985719}, 
    {     0.00000000002,  1.10612817954,     1162.47470440780}, 
    {     0.00000000002,  2.31962293255,    34082.43158359840}, 
    {     0.00000000002,  2.51789048589,    51951.46148744649}, 
    {     0.00000000002,  2.36943618837,    78187.44335344699}
};

 
   
static const struct ln_vsop mercury_latitude_b2[LAT_B2] = {
    {     0.00002747165,  5.24567337999,    26087.90314157420}, 
    {     0.00002047257,  0.00000000000,        0.00000000000}, 
    {     0.00000516030,  0.49321133154,    52175.80628314840}, 
    {     0.00000407309,  4.32215500849,    78263.70942472259}, 
    {     0.00000266936,  1.42744634495,   104351.61256629678}, 
    {     0.00000133544,  4.61055165903,   130439.51570787099}, 
    {     0.00000056956,  1.44017544018,   156527.41884944518}, 
    {     0.00000022049,  4.52127237069,   182615.32199101939}, 
    {     0.00000008008,  1.30182043008,   208703.22513259358}, 
    {     0.00000002781,  4.35468456951,   234791.12827416777}, 
    {     0.00000001304,  2.02991901716,    27197.28169366760}, 
    {     0.00000000934,  1.11727595126,   260879.03141574195}, 
    {     0.00000000511,  4.80027921181,    24978.52458948080}, 
    {     0.00000000433,  5.13987059401,    53285.18483524180}, 
    {     0.00000000413,  1.75599872832,    51066.42773105500}, 
    {     0.00000000306,  4.15800645361,   286966.93455731616}, 
    {     0.00000000236,  4.88575156209,    77154.33087262919}, 
    {     0.00000000123,  3.39712849299,    51116.42435295920}, 
    {     0.00000000113,  1.69721095056,   103242.23401420339}, 
    {     0.00000000109,  4.54767694492,    31749.23519072640}, 
    {     0.00000000108,  5.93327424680,    21535.94964451540}, 
    {     0.00000000078,  5.68234392096,    27043.50288318280}, 
    {     0.00000000098,  0.91744844557,   313054.83769889036}, 
    {     0.00000000065,  1.90438129465,    79373.08797681599}, 
    {     0.00000000049,  4.78044793954,   129330.13715577759}, 
    {     0.00000000053,  2.39315457975,    50586.73338786459}, 
    {     0.00000000041,  1.89540481457,    28306.66024576099}, 
    {     0.00000000042,  1.13215562166,    20426.57109242200}, 
    {     0.00000000040,  5.86412789562,    47623.85278608960}, 
    {     0.00000000036,  2.38000382517,    53131.40602475700}, 
    {     0.00000000040,  0.82891454094,    37410.56723987860}, 
    {     0.00000000034,  1.74213345173,    25132.30339996560}, 
    {     0.00000000036,  4.80372288439,    46514.47423399620}, 
    {     0.00000000030,  5.75393949543,    22645.32819660879}, 
    {     0.00000000035,  5.51811815210,      529.69096509460}, 
    {     0.00000000029,  5.15973032252,    23869.14603738740}, 
    {     0.00000000029,  2.04610351418,    72602.37737557039}, 
    {     0.00000000027,  5.07400464228,     1109.37855209340}, 
    {     0.00000000031,  3.94180796281,   339142.74084046457}, 
    {     0.00000000024,  4.46907480172,    51220.20654153979}, 
    {     0.00000000027,  4.50770662559,    32858.61374281979}, 
    {     0.00000000023,  5.00540243174,    54394.56338733519}, 
    {     0.00000000025,  6.03143676776,    25028.52121138500}, 
    {     0.00000000022,  4.97381466604,    26107.57290247399}, 
    {     0.00000000021,  2.35286083421,    26617.59410666880}, 
    {     0.00000000023,  3.65155458684,    25558.21217647960}, 
    {     0.00000000019,  1.56301436637,   155418.04029735178}, 
    {     0.00000000023,  0.21718413372,    51646.11531805379}, 
    {     0.00000000018,  1.62952557958,    26084.02180621620}, 
    {     0.00000000017,  1.10257903328,    57837.13833230060}, 
    {     0.00000000018,  5.97011387153,    52705.49724824299}, 
    {     0.00000000022,  5.72062354443,    77204.32749453338}, 
    {     0.00000000016,  3.15376195838,    53235.18821333759}, 
    {     0.00000000016,  1.95864204506,    49957.04917896160}, 
    {     0.00000000016,  3.95804080297,    63498.47038145279}, 
    {     0.00000000019,  5.27215888569,    98690.28051714458}, 
    {     0.00000000017,  5.49404503835,    14765.23904326980}, 
    {     0.00000000019,  3.33825173375,    43071.89928903080}, 
    {     0.00000000015,  6.15675923639,     4551.95349705880}, 
    {     0.00000000020,  6.08858427909,    26068.23338067440}, 
    {     0.00000000014,  5.89923942766,    25874.60404613620}, 
    {     0.00000000018,  4.82964144481,     1589.07289528380}, 
    {     0.00000000014,  1.07537737789,    77308.10968311399}, 
    {     0.00000000017,  3.14783569710,    26091.78447693220}, 
    {     0.00000000014,  3.32356467619,    25661.30495069820}, 
    {     0.00000000016,  5.27195291262,    76674.63652943878}, 
    {     0.00000000014,  1.10462125133,    39609.65458316560}, 
    {     0.00000000014,  4.25602450030,    51535.90899683439}, 
    {     0.00000000017,  1.33800696335,    58946.51688439399}, 
    {     0.00000000016,  2.52350108526,    19317.19254032860}, 
    {     0.00000000012,  2.79038116103,    40853.14218484400}, 
    {     0.00000000012,  1.85567065198,   103292.23063610759}, 
    {     0.00000000014,  4.37656794787,    56727.75978020720}, 
    {     0.00000000015,  5.47646255736,    25973.46385288896}, 
    {     0.00000000011,  5.96971832495,    27147.28507176339}, 
    {     0.00000000012,  2.70038843071,    41962.52073693740}, 
    {     0.00000000013,  1.60466136746,    26202.34243025941}, 
    {     0.00000000010,  3.38206384741,    24498.83024629040}, 
    {     0.00000000011,  5.82335799292,    48733.23133818299}, 
    {     0.00000000013,  2.82164927320,    78793.40038981718}, 
    {     0.00000000011,  0.07458891736,    79323.09135491178}, 
    {     0.00000000009,  2.11663162533,    26095.01668857500}, 
    {     0.00000000009,  1.32867484444,    29530.47808653960}, 
    {     0.00000000009,  0.82317919987,   365230.64398203876}, 
    {     0.00000000011,  2.51982070610,      213.29909543800}, 
    {     0.00000000009,  5.61255100580,    45405.09568190280}, 
    {     0.00000000008,  0.51052335690,   110012.94461544899}, 
    {     0.00000000008,  3.57838242313,     9103.90699411760}, 
    {     0.00000000011,  3.16612623037,    10213.28554621100}, 
    {     0.00000000009,  1.17806980890,    82815.66292178139}, 
    {     0.00000000007,  4.44614528188,    55618.38122811380}, 
    {     0.00000000010,  1.64021877585,    30639.85663863300}, 
    {     0.00000000007,  3.01288118296,    33326.57873317420}, 
    {     0.00000000010,  6.01140407134,    36301.18868778519}, 
    {     0.00000000007,  2.76299517138,    83925.04147387479}, 
    {     0.00000000009,  1.93819742025,   124778.18365871879}, 
    {     0.00000000007,  5.86071538076,    26301.20223701220}, 
    {     0.00000000009,  2.91823648304,    26080.78959457339}, 
    {     0.00000000008,  1.31267725201,     3442.57494496540}, 
    {     0.00000000007,  3.27939983168,    16983.99614745660}, 
    {     0.00000000007,  2.72030070524,    51749.20809227239}, 
    {     0.00000000009,  1.66808932215,    50057.04242277000}, 
    {     0.00000000007,  5.03188425899,    76044.95232053580}, 
    {     0.00000000006,  5.00360500512,    79219.30916633119}, 
    {     0.00000000007,  6.07818216662,        7.11354700080}, 
    {     0.00000000007,  5.25223733427,   129380.13377768178}, 
    {     0.00000000006,  0.66028465921,    38519.94579197200}, 
    {     0.00000000008,  1.46897620912,    27676.97603685800}, 
    {     0.00000000006,  3.89297153700,   136100.84775702319}, 
    {     0.00000000006,  1.42686898116,     1059.38193018920}, 
    {     0.00000000007,  4.44152723528,    15874.61759536320}, 
    {     0.00000000006,  4.59565794787,   181505.94343892598}, 
    {     0.00000000007,  6.07267965515,    66941.04532641819}, 
    {     0.00000000006,  3.24607855066,    52389.10537858640}, 
    {     0.00000000005,  4.06197322543,   103396.01282468818}, 
    {     0.00000000005,  0.20766621493,    69159.80243060499}, 
    {     0.00000000007,  5.63268204588,   104881.30353139139}, 
    {     0.00000000006,  4.70546255833,    52290.24557183361}, 
    {     0.00000000005,  5.48898995924,     5661.33204915220}, 
    {     0.00000000006,  2.60268608066,      639.89728631400}, 
    {     0.00000000005,  3.75395808867,     1066.49547719000}, 
    {     0.00000000005,  2.27447016547,    52061.36699446317}, 
    {     0.00000000006,  5.59309697114,    23754.70674870219}, 
    {     0.00000000006,  3.30437999047,    51962.50718771040}, 
    {     0.00000000005,  2.83333016549,    77734.01845962799}, 
    {     0.00000000004,  4.18886248495,     2218.75710418680}, 
    {     0.00000000004,  5.44996443878,    25448.00585526019}, 
    {     0.00000000004,  2.49467694933,     6283.07584999140}, 
    {     0.00000000005,  5.70870935931,     2118.76386037840}, 
    {     0.00000000005,  3.22395783989,   105410.99449648599}, 
    {     0.00000000004,  0.09916856221,    13655.86049117640}, 
    {     0.00000000005,  0.59973221538,      955.59974160860}, 
    {     0.00000000004,  1.80254747407,    80482.46652890938}, 
    {     0.00000000003,  5.23309315292,    64741.95798313119}, 
    {     0.00000000003,  2.39330094298,    38654.05484155699}, 
    {     0.00000000003,  2.57458433543,   155468.03691925599}, 
    {     0.00000000004,  5.07115322045,    78267.59076008058}, 
    {     0.00000000004,  5.77967325372,    26514.50133245020}, 
    {     0.00000000003,  2.30148151750,    73711.75592766379}, 
    {     0.00000000004,  4.21727708992,     1052.26838318840}, 
    {     0.00000000003,  2.46345351544,      426.59819087600}, 
    {     0.00000000003,  4.25457558968,   108903.56606335558}, 
    {     0.00000000003,  5.13279896483,   150866.08680029298}, 
    {     0.00000000003,  4.72421832023,    18849.22754997420}, 
    {     0.00000000003,  6.11593310720,    59414.48187474840}, 
    {     0.00000000003,  2.48879559400,    71492.99882347698}, 
    {     0.00000000003,  4.47643302630,    53764.87917843220}, 
    {     0.00000000004,  6.14344706234,    78477.00852016058}, 
    {     0.00000000003,  1.51533003761,    28421.09953444620}, 
    {     0.00000000003,  0.71956036719,    11322.66409830440}, 
    {     0.00000000003,  2.67348379860,    74821.13447975718}, 
    {     0.00000000003,  0.79945669251,   162188.75089859738}, 
    {     0.00000000003,  2.14815045285,    78244.03966382280}, 
    {     0.00000000003,  2.82222191238,    62389.09182935939}, 
    {     0.00000000003,  2.76748201992,    52602.40447402440}, 
    {     0.00000000003,  1.96898352930,   102762.53967101299}, 
    {     0.00000000002,  1.16780835398,    78283.37918562238}, 
    {     0.00000000002,  4.47449945171,    12566.15169998280}, 
    {     0.00000000003,  2.88047183180,    93028.94846799239}, 
    {     0.00000000002,  3.80780256116,    64607.84893354619}, 
    {     0.00000000002,  1.27798847041,    81706.28436968799}, 
    {     0.00000000002,  1.54584958809,    28206.66700195260}, 
    {     0.00000000003,  1.17857208902,    77623.81213840858}, 
    {     0.00000000002,  4.88982108835,    68050.42387851159}, 
    {     0.00000000002,  2.64659209004,   130969.20667296558}, 
    {     0.00000000002,  0.77279881726,   129483.91596626239}, 
    {     0.00000000002,  4.19328099887,    78259.82808936459}, 
    {     0.00000000002,  1.80053876257,      853.19638175200}, 
    {     0.00000000002,  2.85455305411,     7994.52844202420}, 
    {     0.00000000002,  4.55116089785,    52156.13652224860}, 
    {     0.00000000002,  4.39479757391,    85034.42002596818}, 
    {     0.00000000002,  0.20942265156,    88476.99497093359}, 
    {     0.00000000002,  1.26254478035,    79852.78232000639}, 
    {     0.00000000002,  3.89150722320,   391318.54712361297}, 
    {     0.00000000002,  2.04228268324,    13521.75144159140}, 
    {     0.00000000002,  1.63162182525,    52179.68761850640}, 
    {     0.00000000002,  0.06540438917,   131498.89763806018}, 
    {     0.00000000002,  2.37116664144,    94138.32702008578}, 
    {     0.00000000002,  5.93228693986,    52168.69273614759}, 
    {     0.00000000002,  3.72472287325,    65697.55772473979}, 
    {     0.00000000002,  3.93660707629,    99799.65906923798}, 
    {     0.00000000002,  4.86329180578,   131548.89425996438}, 
    {     0.00000000002,  3.49584320658,    52195.47604404819}, 
    {     0.00000000002,  4.53167102336,    76144.94556434419}, 
    {     0.00000000002,  0.10881384247,     6770.71060124560}, 
    {     0.00000000002,  1.48407007502,   105307.21230790539}, 
    {     0.00000000002,  1.81828652056,   102132.85546210999}, 
    {     0.00000000002,  3.75274548640,   105460.99111839019}, 
    {     0.00000000002,  5.33436795308,   104331.94280539699}, 
    {     0.00000000001,  0.16054262075,    52171.92494779040}, 
    {     0.00000000002,  5.19574633584,    51322.60990139639}, 
    {     0.00000000002,  5.79451235679,   103821.92160120218}, 
    {     0.00000000001,  4.31275936318,   104371.28232719658}, 
    {     0.00000000002,  5.87361011941,   181555.94006083018}, 
    {     0.00000000001,  0.84208500803,    51123.53789995999}, 
    {     0.00000000001,  5.83424113870,   120226.23016165999}, 
    {     0.00000000001,  1.49109031037,    78378.14871340781}, 
    {     0.00000000001,  2.29392399306,   104355.49390165479}, 
    {     0.00000000001,  1.63896473054,   125887.56221081219}, 
    {     0.00000000001,  3.95295093204,   188276.65404017158}, 
    {     0.00000000001,  0.96789367427,    44937.13069154840}, 
    {     0.00000000002,  1.30685997283,    51109.31080595839}, 
    {     0.00000000002,  0.18671610339,    25021.40766438420}, 
    {     0.00000000001,  0.95826401920,   104347.73123093879}, 
    {     0.00000000001,  5.52121474401,    97580.90196505119}, 
    {     0.00000000002,  0.59513540388,    35191.81013569180}, 
    {     0.00000000001,  5.15925373621,    19804.82729158280}, 
    {     0.00000000001,  0.65006628215,    78050.41032928458}, 
    {     0.00000000002,  1.90450740831,    23969.13928119580}, 
    {     0.00000000001,  4.32826013352,    77837.11123384659}, 
    {     0.00000000001,  4.65423180642,    78256.59587772179}, 
    {     0.00000000001,  4.01765755434,    45892.73043315699}, 
    {     0.00000000001,  1.06205727030,   134991.46920492979}, 
    {     0.00000000001,  5.91135191152,    26727.80042788820}, 
    {     0.00000000001,  5.33774808422,    78149.27013603736}, 
    {     0.00000000001,  5.78198423150,    91785.46086631398}, 
    {     0.00000000001,  2.96773065217,   129909.82474277639}, 
    {     0.00000000001,  3.30975819180,    39743.76363275060}, 
    {     0.00000000001,  6.10771078765,    25035.63475838580}, 
    {     0.00000000001,  5.67221349248,    52182.91983014920}, 
    {     0.00000000001,  2.48518819686,    90829.86112470538}, 
    {     0.00000000001,  4.24431178719,    78270.82297172339}, 
    {     0.00000000001,  3.23031265434,     7238.67559160000}, 
    {     0.00000000001,  3.34535840387,   114564.89811250778}, 
    {     0.00000000001,  3.87498999181,    71025.03383312259}, 
    {     0.00000000001,  0.37439113949,    78690.30761559859}, 
    {     0.00000000001,  3.33731181959,   104564.91166173479}, 
    {     0.00000000001,  5.11692827664,   151975.46535238638}, 
    {     0.00000000001,  2.03914564106,   176953.98994186718}, 
    {     0.00000000001,  6.15951882831,    70269.18098269838}, 
    {     0.00000000001,  1.26757694099,   104358.72611329758}
};

 
   
static const struct ln_vsop mercury_latitude_b3[LAT_B3] = {
    {     0.00000064680,  2.16518315874,    26087.90314157420}, 
    {     0.00000030733,  0.00000000000,        0.00000000000}, 
    {     0.00000018929,  5.40870348072,    52175.80628314840}, 
    {     0.00000009797,  2.41402344018,    78263.70942472259}, 
    {     0.00000006861,  5.88312096876,   104351.61256629678}, 
    {     0.00000004367,  2.88362764626,   130439.51570787099}, 
    {     0.00000002344,  6.05581664620,   156527.41884944518}, 
    {     0.00000001105,  2.89178837278,   182615.32199101939}, 
    {     0.00000000475,  5.98256115875,   208703.22513259358}, 
    {     0.00000000191,  2.77298018505,   234791.12827416777}, 
    {     0.00000000073,  5.83474996935,   260879.03141574195}, 
    {     0.00000000027,  2.60945701067,   286966.93455731616}, 
    {     0.00000000024,  3.87337367986,    27197.28169366760}, 
    {     0.00000000016,  1.06059146335,    24978.52458948080}, 
    {     0.00000000008,  5.66780041298,   313054.83769889036}, 
    {     0.00000000006,  5.58854950623,    51066.42773105500}, 
    {     0.00000000007,  3.08546607033,    77154.33087262919}, 
    {     0.00000000005,  0.02983831713,   103242.23401420339}, 
    {     0.00000000003,  2.47133249668,   339142.74084046457}, 
    {     0.00000000002,  1.54850606185,     1109.37855209340}, 
    {     0.00000000003,  1.80338603638,    53285.18483524180}, 
    {     0.00000000002,  3.17513673341,   129330.13715577759}, 
    {     0.00000000002,  0.12967223359,    79373.08797681599}, 
    {     0.00000000001,  5.35275811299,    20426.57109242200}, 
    {     0.00000000001,  1.51126337634,    21535.94964451540}, 
    {     0.00000000001,  2.60937074595,    46514.47423399620}, 
    {     0.00000000001,  4.35415847538,    25132.30339996560}, 
    {     0.00000000001,  0.01495555420,     1059.38193018920}, 
    {     0.00000000001,  0.38681085251,    31749.23519072640}, 
    {     0.00000000001,  1.49317898303,    27043.50288318280}, 
    {     0.00000000001,  1.37353507736,     1589.07289528380}, 
    {     0.00000000001,  4.03577664541,     4551.95349705880}, 
    {     0.00000000001,  3.34548299714,   105460.99111839019}, 
    {     0.00000000001,  5.16936349855,    25028.52121138500}, 
    {     0.00000000001,  0.11390654963,     5661.33204915220}, 
    {     0.00000000001,  1.41108698419,    47623.85278608960}, 
    {     0.00000000001,  6.25128044210,   155418.04029735178}, 
    {     0.00000000000,  5.54564708703,   365230.64398203876}, 
    {     0.00000000001,  6.08850785156,    51116.42435295920}
};

 
   
static const struct ln_vsop mercury_latitude_b4[LAT_B4] = {
    {     0.00000001427,  4.97519726738,    26087.90314157420}, 
    {     0.00000000491,  3.14159265359,        0.00000000000}, 
    {     0.00000000336,  3.19691284098,    52175.80628314840}, 
    {     0.00000000243,  0.57739947651,    78263.70942472259}, 
    {     0.00000000170,  4.04262780835,   104351.61256629678}, 
    {     0.00000000120,  1.12342918082,   130439.51570787099}, 
    {     0.00000000076,  4.36272648537,   156527.41884944518}, 
    {     0.00000000043,  1.23406162348,   182615.32199101939}, 
    {     0.00000000022,  4.35637189777,   208703.22513259358}, 
    {     0.00000000010,  1.16395130801,   234791.12827416777}, 
    {     0.00000000004,  4.27354172628,   260879.03141574195}, 
    {     0.00000000001,  1.02393401255,   286966.93455731616}, 
    {     0.00000000000,  4.13470035458,   313054.83769889036}
};

 
   
static const struct ln_vsop mercury_latitude_b5[LAT_B5] = {
    {     0.00000000009,  1.38311629808,    52175.80628314840}, 
    {     0.00000000008,  5.38548752147,    26087.90314157420}, 
    {     0.00000000006,  4.90804019263,    78263.70942472259}, 
    {     0.00000000006,  0.00000000000,        0.00000000000}, 
    {     0.00000000004,  2.13779173141,   104351.61256629678}, 
    {     0.00000000003,  5.58133586504,   130439.51570787099}, 
    {     0.00000000002,  2.64274667677,   156527.41884944518}, 
    {     0.00000000001,  5.83772628756,   182615.32199101939}, 
    {     0.00000000001,  2.68770315459,   208703.22513259358}, 
    {     0.00000000000,  5.84365103714,   234791.12827416777}
};

 
   
static const struct ln_vsop mercury_radius_r0[RADIUS_R0] = {
    {     0.39528271651,  0.00000000000,        0.00000000000}, 
    {     0.07834131818,  6.19233722598,    26087.90314157420}, 
    {     0.00795525558,  2.95989690104,    52175.80628314840}, 
    {     0.00121281764,  6.01064153797,    78263.70942472259}, 
    {     0.00021921969,  2.77820093972,   104351.61256629678}, 
    {     0.00004354065,  5.82894543774,   130439.51570787099}, 
    {     0.00000918228,  2.59650562845,   156527.41884944518}, 
    {     0.00000260033,  3.02817753901,    27197.28169366760}, 
    {     0.00000289955,  1.42441937278,    25028.52121138500}, 
    {     0.00000201855,  5.64725040577,   182615.32199101939}, 
    {     0.00000201498,  5.59227727403,    31749.23519072640}, 
    {     0.00000141980,  6.25264206514,    24978.52458948080}, 
    {     0.00000100144,  3.73435615066,    21535.94964451540}, 
    {     0.00000077561,  3.66972523786,    20426.57109242200}, 
    {     0.00000063277,  4.29905566028,    25558.21217647960}, 
    {     0.00000062951,  4.76588960835,     1059.38193018920}, 
    {     0.00000066753,  2.52520325806,     5661.33204915220}, 
    {     0.00000075500,  4.47428643135,    51116.42435295920}, 
    {     0.00000048265,  6.06824353565,    53285.18483524180}, 
    {     0.00000045748,  2.41480951848,   208703.22513259358}, 
    {     0.00000035224,  1.05917819542,    27043.50288318280}, 
    {     0.00000040815,  2.35882025197,    57837.13833230060}, 
    {     0.00000044235,  1.21957279824,    15874.61759536320}, 
    {     0.00000033873,  0.86381554218,    25661.30495069820}, 
    {     0.00000037203,  0.51733923686,    47623.85278608960}, 
    {     0.00000030092,  1.79500457353,    37410.56723987860}, 
    {     0.00000028417,  3.02063623857,    51066.42773105500}, 
    {     0.00000030903,  0.88366672292,    24498.83024629040}, 
    {     0.00000026105,  2.15021962878,    39609.65458316560}, 
    {     0.00000018699,  4.96496134509,    11322.66409830440}, 
    {     0.00000021270,  5.36857147632,    13521.75144159140}, 
    {     0.00000019422,  4.98378705281,    10213.28554621100}, 
    {     0.00000016941,  3.88764295060,    26617.59410666880}, 
    {     0.00000015109,  0.44510551618,    46514.47423399620}, 
    {     0.00000017087,  1.24077744063,    77204.32749453338}, 
    {     0.00000013940,  1.62574000931,    27147.28507176339}, 
    {     0.00000013383,  1.07656603755,    51646.11531805379}, 
    {     0.00000015011,  4.28173416255,    41962.52073693740}, 
    {     0.00000013977,  4.77056852962,    33326.57873317420}, 
    {     0.00000012794,  6.06436868672,     1109.37855209340}, 
    {     0.00000013938,  1.99984923769,    25132.30339996560}, 
    {     0.00000016297,  2.63293566917,    19804.82729158280}, 
    {     0.00000011932,  2.36500445252,     4551.95349705880}, 
    {     0.00000010612,  5.46555459994,   234791.12827416777}, 
    {     0.00000012754,  2.07611250810,      529.69096509460}, 
    {     0.00000012068,  2.84997457341,    79373.08797681599}, 
    {     0.00000009069,  1.21263578152,    14765.23904326980}, 
    {     0.00000009491,  0.83697019037,    12566.15169998280}, 
    {     0.00000009380,  5.41195321678,    83925.04147387479}, 
    {     0.00000007499,  2.44636675464,    30639.85663863300}, 
    {     0.00000007463,  5.53233826081,    32858.61374281979}, 
    {     0.00000007216,  1.17101761775,    16983.99614745660}, 
    {     0.00000008492,  3.56622963752,    73711.75592766379}, 
    {     0.00000007109,  5.32625250539,      426.59819087600}, 
    {     0.00000006862,  1.82314316379,    36301.18868778519}, 
    {     0.00000006561,  4.27817269714,    43071.89928903080}, 
    {     0.00000008853,  3.87737929181,    50586.73338786459}, 
    {     0.00000006885,  5.31108684461,     1589.07289528380}, 
    {     0.00000005943,  4.06893169924,    53131.40602475700}, 
    {     0.00000007653,  3.91505034455,    51749.20809227239}, 
    {     0.00000006460,  6.07127448610,    77154.33087262919}, 
    {     0.00000005415,  5.20028106936,    65697.55772473979}, 
    {     0.00000005185,  3.56743230013,     6283.07584999140}, 
    {     0.00000004091,  3.67594128543,    22645.32819660879}, 
    {     0.00000004075,  4.29142103675,   103292.23063610759}, 
    {     0.00000004429,  5.69109395363,    45892.73043315699}, 
    {     0.00000003426,  0.64910747902,    52705.49724824299}, 
    {     0.00000003353,  3.49344693925,    72602.37737557039}, 
    {     0.00000004120,  1.65386304528,    25448.00585526019}, 
    {     0.00000003261,  1.03196144437,    68050.42387851159}, 
    {     0.00000003278,  3.13863996522,    25874.60404613620}, 
    {     0.00000003054,  4.12577608597,    77734.01845962799}, 
    {     0.00000003614,  2.95861574665,    28306.66024576099}, 
    {     0.00000002819,  4.62629009218,    18849.22754997420}, 
    {     0.00000002746,  4.67880578050,    53235.18821333759}, 
    {     0.00000002713,  3.56874904332,    26068.23338067440}, 
    {     0.00000002507,  2.23312082053,   260879.03141574195}, 
    {     0.00000003044,  5.90613444962,   105460.99111839019}, 
    {     0.00000002755,  5.67587076777,    26107.57290247399}, 
    {     0.00000002267,  2.17941292895,   110012.94461544899}, 
    {     0.00000002274,  0.50174174314,    32370.97899156560}, 
    {     0.00000002742,  4.75428269919,    63498.47038145279}, 
    {     0.00000002792,  5.05148755419,    51220.20654153979}, 
    {     0.00000002557,  2.95114104952,    26080.78959457339}, 
    {     0.00000002134,  0.84627422908,    76674.63652943878}, 
    {     0.00000001971,  0.47406458592,    48733.23133818299}, 
    {     0.00000001965,  1.37420609579,     7238.67559160000}, 
    {     0.00000002527,  0.34531752670,    23969.13928119580}, 
    {     0.00000002022,  0.33828427611,    99799.65906923798}, 
    {     0.00000001871,  3.93046887107,    38654.05484155699}, 
    {     0.00000001873,  0.69327419506,    26091.78447693220}, 
    {     0.00000001945,  2.37384000310,     6770.71060124560}, 
    {     0.00000001863,  2.26591746342,    26084.02180621620}, 
    {     0.00000001751,  5.50651542385,    56727.75978020720}, 
    {     0.00000001971,  3.77456264986,    19317.19254032860}, 
    {     0.00000001672,  2.15275736737,    26514.50133245020}, 
    {     0.00000001703,  4.28966171001,    40853.14218484400}, 
    {     0.00000001657,  4.98018779294,     9103.90699411760}, 
    {     0.00000002084,  2.19427393480,    26301.20223701220}, 
    {     0.00000001818,  4.20870875697,    25938.33994443960}, 
    {     0.00000001780,  0.91702886288,    79219.30916633119}, 
    {     0.00000001525,  2.15720853496,    27676.97603685800}, 
    {     0.00000001533,  1.54508616302,      955.59974160860}, 
    {     0.00000001614,  1.27565064366,    25035.63475838580}, 
    {     0.00000001743,  0.68269075458,    77837.11123384659}, 
    {     0.00000001389,  4.85102187945,    62389.09182935939}, 
    {     0.00000001436,  0.05742724582,    23869.14603738740}, 
    {     0.00000001563,  5.84795328174,    26095.01668857500}, 
    {     0.00000001640,  4.66281344802,    25021.40766438420}, 
    {     0.00000001552,  2.83910652908,   103242.23401420339}, 
    {     0.00000001249,  1.97225258222,    91785.46086631398}, 
    {     0.00000001160,  1.73111584811,    38519.94579197200}, 
    {     0.00000001005,  1.05898298870,   129380.13377768178}, 
    {     0.00000001041,  2.78034606280,      213.29909543800}, 
    {     0.00000001105,  4.55512255263,    26011.63707029860}, 
    {     0.00000000979,  2.43870368161,    71980.63357473118}, 
    {     0.00000000853,  0.56324665532,    20760.42703319140}, 
    {     0.00000000874,  4.53679289793,      639.89728631400}, 
    {     0.00000000783,  3.69765164671,    78793.40038981718}, 
    {     0.00000000772,  4.08714779937,    94138.32702008578}, 
    {     0.00000000797,  0.26237404367,    98690.28051714458}, 
    {     0.00000000965,  4.70783027902,    51535.90899683439}, 
    {     0.00000000952,  2.53602802805,    29530.47808653960}, 
    {     0.00000000773,  2.67894491727,   131548.89425996438}, 
    {     0.00000000734,  0.89231112796,   103821.92160120218}, 
    {     0.00000000668,  3.73107901174,    46848.33017476560}, 
    {     0.00000000828,  2.88184295232,    19406.67828817460}, 
    {     0.00000000622,  1.05579834092,    59414.48187474840}, 
    {     0.00000000676,  4.50351834122,    25934.12433108940}, 
    {     0.00000000602,  5.28398978680,   286966.93455731616}, 
    {     0.00000000619,  1.44855125892,    79323.09135491178}, 
    {     0.00000000692,  6.19755283456,    51962.50718771040}, 
    {     0.00000000563,  5.22994157011,   136100.84775702319}, 
    {     0.00000000782,  3.25255814520,    50057.04242277000}, 
    {     0.00000000551,  0.33643935436,    52156.13652224860}, 
    {     0.00000000705,  4.73700316767,    26241.68195205900}, 
    {     0.00000000577,  5.85652683859,     2118.76386037840}, 
    {     0.00000000517,  3.93204226280,   102762.53967101299}, 
    {     0.00000000635,  4.87720835087,    12432.04265039780}, 
    {     0.00000000635,  1.81903768364,    77308.10968311399}, 
    {     0.00000000543,  1.40877750421,    44937.13069154840}, 
    {     0.00000000557,  5.44313297566,    85034.42002596818}, 
    {     0.00000000497,  3.39000246240,   125887.56221081219}, 
    {     0.00000000546,  4.77993155620,    22747.29071487440}, 
    {     0.00000000520,  6.00160827202,    52168.69273614759}, 
    {     0.00000000463,  3.67555016973,    25668.41849769900}, 
    {     0.00000000452,  3.53009642496,    58458.88213313979}, 
    {     0.00000000474,  5.94337109404,    54394.56338733519}, 
    {     0.00000000559,  2.44355298288,    52195.47604404819}, 
    {     0.00000000418,  3.73372056542,   103925.01437542078}, 
    {     0.00000000397,  0.69015519657,    64741.95798313119}, 
    {     0.00000000511,  5.88239871682,    45494.58142974879}, 
    {     0.00000000413,  2.26754821750,    82815.66292178139}, 
    {     0.00000000425,  5.24513787195,    52389.10537858640}, 
    {     0.00000000482,  0.98163319354,    25654.19140369739}, 
    {     0.00000000380,  3.74414053506,    52179.68761850640}, 
    {     0.00000000359,  5.50961175081,    26555.86813192860}, 
    {     0.00000000375,  1.97919633246,      149.56319713460}, 
    {     0.00000000385,  5.88994556216,   129330.13715577759}, 
    {     0.00000000348,  4.91062953335,     1052.26838318840}, 
    {     0.00000000418,  4.32915399414,    51123.53789995999}, 
    {     0.00000000425,  1.43228900858,    51109.31080595839}, 
    {     0.00000000464,  3.98651795995,   105307.21230790539}, 
    {     0.00000000328,  5.20638855699,    52602.40447402440}, 
    {     0.00000000354,  1.04382219765,    66941.04532641819}, 
    {     0.00000000324,  1.62972553890,    88476.99497093359}, 
    {     0.00000000378,  5.31677687871,    52171.92494779040}, 
    {     0.00000000440,  1.46388471692,    89586.37352302698}, 
    {     0.00000000355,  1.52732345644,     1066.49547719000}, 
    {     0.00000000302,  5.21118830274,    53764.87917843220}, 
    {     0.00000000301,  5.02488469326,   117873.36400788819}, 
    {     0.00000000351,  2.00433655367,    24395.73747207180}, 
    {     0.00000000289,  6.19161795579,    26094.53170047421}, 
    {     0.00000000286,  3.77109546265,        7.11354700080}, 
    {     0.00000000283,  3.10942945865,    49957.04917896160}, 
    {     0.00000000385,  2.47186185031,    25234.70675982219}, 
    {     0.00000000382,  0.97683948367,    52026.24308601380}, 
    {     0.00000000271,  5.74773027334,    25455.11940226100}, 
    {     0.00000000268,  2.86400819938,    80482.46652890938}, 
    {     0.00000000375,  0.55193410863,    45405.09568190280}, 
    {     0.00000000305,  6.00195610387,     2218.75710418680}, 
    {     0.00000000259,  1.82926086584,    24505.94379329119}, 
    {     0.00000000251,  4.10979366326,   155468.03691925599}, 
    {     0.00000000289,  3.05374038036,    26081.27458267419}, 
    {     0.00000000242,  5.05513759189,    42153.96900304900}, 
    {     0.00000000244,  2.15545293562,     3442.57494496540}, 
    {     0.00000000315,  2.61615796784,    52182.91983014920}, 
    {     0.00000000256,  3.71118385343,    25619.93815121980}, 
    {     0.00000000232,  2.21574125599,    16066.06586147480}, 
    {     0.00000000233,  5.49032532532,    98068.53671630539}, 
    {     0.00000000236,  4.08613786149,    26013.12154300690}, 
    {     0.00000000225,  0.44436388903,    76144.94556434419}, 
    {     0.00000000242,  3.29840670592,     6681.22485339960}, 
    {     0.00000000227,  1.63241183250,       76.26607127560}, 
    {     0.00000000268,  1.09036981144,    18093.37469954999}, 
    {     0.00000000255,  4.20620893175,    44181.27784112419}, 
    {     0.00000000205,  1.00335777675,    26190.99591579279}, 
    {     0.00000000228,  1.46077026379,    77623.81213840858}, 
    {     0.00000000198,  1.36691766564,    26727.80042788820}, 
    {     0.00000000259,  1.28277618444,    13655.86049117640}, 
    {     0.00000000196,  5.73310610578,   157636.79740153858}, 
    {     0.00000000196,  0.06602563750,    40565.25432477420}, 
    {     0.00000000187,  0.86191776388,   120226.23016165999}, 
    {     0.00000000262,  4.14849890829,    24491.71669928959}, 
    {     0.00000000244,  4.14398143655,    95247.70557217918}, 
    {     0.00000000232,  5.45142204480,    33967.99229491319}, 
    {     0.00000000206,  5.59194625667,    55618.38122811380}, 
    {     0.00000000203,  1.64212864180,    58946.51688439399}, 
    {     0.00000000188,  0.46231923609,   104881.30353139139}, 
    {     0.00000000192,  1.82885117119,    25551.09862947879}, 
    {     0.00000000200,  1.81390254289,    25863.55834587229}, 
    {     0.00000000191,  5.57416790284,     5327.47610838280}, 
    {     0.00000000195,  3.31299278224,   124778.18365871879}, 
    {     0.00000000169,  1.69377804998,    90695.75207512038}, 
    {     0.00000000226,  1.32358533633,    52099.54021187280}, 
    {     0.00000000177,  3.29597559078,    25131.61398560359}, 
    {     0.00000000178,  2.54736101162,    26720.68688088739}, 
    {     0.00000000167,  3.61985108387,    23754.70674870219}, 
    {     0.00000000159,  3.48407918441,    25977.69682035479}, 
    {     0.00000000180,  3.94244458655,   129909.82474277639}, 
    {     0.00000000150,  5.20173167043,    69159.80243060499}, 
    {     0.00000000166,  0.40324154213,   100909.03762133139}, 
    {     0.00000000175,  2.97505263315,    24925.42843716640}, 
    {     0.00000000154,  1.27150748229,    25984.81036735560}, 
    {     0.00000000144,  1.89329933647,    64607.84893354619}, 
    {     0.00000000145,  2.05406539484,   313054.83769889036}, 
    {     0.00000000152,  4.87194855231,   103396.01282468818}, 
    {     0.00000000137,  3.86916799978,    24609.03656750980}, 
    {     0.00000000141,  1.99766374692,   162188.75089859738}, 
    {     0.00000000184,  6.09994107476,    23439.44831610119}, 
    {     0.00000000135,  1.27330433084,    52022.02747266360}, 
    {     0.00000000127,  0.70493065203,   128850.44281258718}, 
    {     0.00000000142,  1.50690527956,    52329.58509363319}, 
    {     0.00000000126,  2.70570221163,    28206.66700195260}, 
    {     0.00000000123,  0.15653071499,   151975.46535238638}, 
    {     0.00000000126,  1.61974134336,    48835.19385644859}, 
    {     0.00000000137,  1.77314956898,    35191.81013569180}, 
    {     0.00000000147,  4.50312078660,   105410.99449648599}, 
    {     0.00000000125,  3.38986540694,    78244.03966382280}, 
    {     0.00000000119,  2.77647833951,    78256.59587772179}, 
    {     0.00000000156,  2.96636712768,    78050.41032928458}, 
    {     0.00000000145,  1.35549047802,     3340.61242669980}, 
    {     0.00000000126,  3.97012413964,    29428.51556827400}, 
    {     0.00000000128,  5.41920055502,    26162.68474014150}, 
    {     0.00000000110,  3.87981560343,    85502.38501632259}, 
    {     0.00000000127,  5.49693348651,    78283.37918562238}, 
    {     0.00000000132,  4.86941737016,    24712.12934172840}, 
    {     0.00000000126,  0.94880137000,   121335.60871375339}, 
    {     0.00000000129,  4.00700268674,    72936.23331633979}, 
    {     0.00000000102,  0.50512246193,   130012.91751699499}, 
    {     0.00000000104,  0.29867566906,    84546.78527471398}, 
    {     0.00000000118,  0.76546423413,   131395.11544947959}, 
    {     0.00000000120,  4.45274824615,    71025.03383312259}, 
    {     0.00000000117,  3.31815509821,    25771.51127191760}, 
    {     0.00000000110,  2.63255540457,    71582.48457132299}, 
    {     0.00000000097,  2.66123209192,   155418.04029735178}, 
    {     0.00000000113,  5.88929318039,    26404.29501123080}, 
    {     0.00000000098,  2.01482697693,    78477.00852016058}, 
    {     0.00000000103,  0.46436247195,    51756.32163927320}, 
    {     0.00000000093,  2.37413256663,      419.48464387520}, 
    {     0.00000000125,  1.88182927035,    26610.48055966799}, 
    {     0.00000000096,  0.34531574235,    26507.38778544939}, 
    {     0.00000000093,  3.80384593339,    26037.90651966999}, 
    {     0.00000000091,  2.63070786684,    28421.09953444620}, 
    {     0.00000000101,  5.21013194641,      433.71173787680}, 
    {     0.00000000096,  4.47740402596,    77197.21394753258}, 
    {     0.00000000108,  4.03687459562,    51742.09454527159}, 
    {     0.00000000086,  5.14042481496,    26237.46633870879}, 
    {     0.00000000092,  3.74350464437,    90829.86112470538}, 
    {     0.00000000086,  1.86284853445,    27140.17152476259}, 
    {     0.00000000102,  5.41450550369,    26137.89976347840}, 
    {     0.00000000086,  4.01669468413,    10021.83728009940}, 
    {     0.00000000100,  5.32148635395,   108903.56606335558}, 
    {     0.00000000079,  4.68110092612,    27154.39861876420}, 
    {     0.00000000092,  5.52113044538,    51322.60990139639}, 
    {     0.00000000078,  2.87936468013,    29416.03879785439}, 
    {     0.00000000092,  4.20287352869,    38813.35657634920}, 
    {     0.00000000095,  4.44016161131,   115674.27666460119}, 
    {     0.00000000104,  5.05012283418,    50483.64061364600}, 
    {     0.00000000075,  1.78913882745,   143961.26714946238}, 
    {     0.00000000086,  0.51446096218,    78267.59076008058}, 
    {     0.00000000078,  4.66703507622,   114564.89811250778}, 
    {     0.00000000078,  4.20154761010,     1692.16566950240}, 
    {     0.00000000086,  4.03049198821,    78114.14622758799}, 
    {     0.00000000073,  2.27348914847,    52643.77127350280}, 
    {     0.00000000082,  3.73527269254,      853.19638175200}, 
    {     0.00000000071,  4.89150234067,    50593.84693486539}, 
    {     0.00000000082,  5.22634268892,    27999.10262479140}, 
    {     0.00000000093,  1.09574629454,    77211.44104153418}, 
    {     0.00000000074,  1.97836913639,    78690.30761559859}, 
    {     0.00000000081,  3.59541157741,    71492.99882347698}, 
    {     0.00000000084,  3.12386155848,    14477.35118320000}, 
    {     0.00000000083,  4.10338349247,    93028.94846799239}, 
    {     0.00000000067,  0.24252839986,    66653.15746634839}, 
    {     0.00000000074,  5.66943570493,    78270.82297172339}, 
    {     0.00000000068,  1.98243672712,    79852.78232000639}, 
    {     0.00000000064,  6.15939675587,    76044.95232053580}, 
    {     0.00000000064,  5.54602351082,    25764.39772491679}, 
    {     0.00000000066,  2.28176331469,     7880.08915333899}, 
    {     0.00000000087,  1.76987117922,    25440.89230825939}, 
    {     0.00000000073,  2.06236786630,   111122.32316754239}, 
    {     0.00000000078,  0.40395754320,    49842.60989027639}, 
    {     0.00000000076,  2.65569010126,    34282.17847478280}, 
    {     0.00000000064,  0.87551506766,   181555.94006083018}, 
    {     0.00000000086,  2.08720558248,    78259.82808936459}, 
    {     0.00000000074,  0.86495417245,    50579.61984086379}, 
    {     0.00000000082,  1.02908415130,    74821.13447975718}, 
    {     0.00000000062,  0.94022411884,    25344.91308104160}, 
    {     0.00000000059,  2.45671910437,    51543.02254383520}, 
    {     0.00000000058,  2.95861307962,    52182.43484204840}, 
    {     0.00000000058,  4.20403945192,    96357.08412427259}, 
    {     0.00000000061,  2.82454009227,    26202.34243025941}, 
    {     0.00000000057,  2.27669644556,   124156.43985787958}, 
    {     0.00000000057,  4.37128574888,     1581.95934828300}, 
    {     0.00000000055,  0.13527477543,    25973.46385288896}, 
    {     0.00000000054,  4.79282641675,    26164.16921284980}, 
    {     0.00000000054,  3.05808651891,    25565.32572348040}, 
    {     0.00000000055,  4.51468564617,   103711.71527998279}, 
    {     0.00000000054,  3.87184860299,    18207.81398823521}, 
    {     0.00000000053,  4.32466503961,    70269.18098269838}, 
    {     0.00000000054,  4.62370746060,    25881.71759313700}, 
    {     0.00000000050,  2.50076265786,   183724.70054311278}, 
    {     0.00000000058,  2.06199777270,     1596.18644228460}, 
    {     0.00000000065,  5.20218241390,    26294.08869001139}, 
    {     0.00000000047,  0.85032665275,    52101.02468458109}, 
    {     0.00000000058,  1.43376641232,    23866.04650697719}, 
    {     0.00000000048,  2.35325985848,    81706.28436968799}, 
    {     0.00000000052,  0.18584318278,    92741.06060792258}, 
    {     0.00000000053,  0.58740318705,    26624.70765366959}, 
    {     0.00000000061,  2.61531397472,    49527.35145767539}, 
    {     0.00000000047,  3.88425610956,   146314.13330323418}, 
    {     0.00000000049,  6.20238177120,    32769.12799497380}, 
    {     0.00000000053,  4.37477924787,    78187.44335344699}, 
    {     0.00000000048,  5.97927376895,    51013.33157874059}, 
    {     0.00000000048,  3.83871061840,   102232.84870591838}, 
    {     0.00000000049,  5.05465236114,     7994.52844202420}, 
    {     0.00000000044,  5.42834161209,    86143.79857806159}, 
    {     0.00000000058,  3.80515926170,    99024.13645791399}, 
    {     0.00000000044,  4.02940505346,   147423.51185532758}, 
    {     0.00000000058,  6.09754644524,    52169.17772424839}, 
    {     0.00000000042,  4.38821594604,      224.34479570190}, 
    {     0.00000000049,  0.46999643208,    51707.84129279399}, 
    {     0.00000000042,  1.57834095767,    23976.25282819660}, 
    {     0.00000000040,  4.41732729204,    52815.70356946240}, 
    {     0.00000000046,  3.51899431806,   130969.20667296558}, 
    {     0.00000000045,  4.35498866833,    39743.76363275060}, 
    {     0.00000000049,  0.90018634051,      632.78373931320}, 
    {     0.00000000044,  0.77931638287,    25138.72753260440}, 
    {     0.00000000040,  4.04800595628,    52278.89905736699}, 
    {     0.00000000038,  0.62728056271,    50696.93970908399}, 
    {     0.00000000038,  2.90143761999,      956.28915597060}, 
    {     0.00000000040,  1.64469334161,    39629.32434406539}, 
    {     0.00000000043,  0.11284697031,     2648.45482547300}, 
    {     0.00000000042,  2.74307947693,    24079.34560241519}, 
    {     0.00000000051,  1.57638194838,    12725.45343477500}, 
    {     0.00000000036,  5.75260999162,    25867.49049913539}, 
    {     0.00000000037,  1.62696286674,   129483.91596626239}, 
    {     0.00000000045,  0.05081561790,    51219.51712717779}, 
    {     0.00000000035,  0.09890027261,    25241.82030682300}, 
    {     0.00000000049,  0.07684803479,   150866.08680029298}, 
    {     0.00000000034,  4.55905337378,      536.80451209540}, 
    {     0.00000000036,  5.60022995084,    52808.59002246159}, 
    {     0.00000000039,  5.99930414876,   104138.31347085879}, 
    {     0.00000000046,  0.70705564046,   155997.72788435058}, 
    {     0.00000000033,  4.54693851680,    78417.48823520739}, 
    {     0.00000000032,  4.31344005149,    78109.93061423779}, 
    {     0.00000000036,  5.69791953426,    26049.77010593640}, 
    {     0.00000000041,  4.93127694524,    51639.00177105299}, 
    {     0.00000000034,  3.32227109836,    35472.74414964940}, 
    {     0.00000000042,  4.87062950014,    51951.46148744649}, 
    {     0.00000000041,  2.38737728310,    68241.87214462319}, 
    {     0.00000000035,  5.09552330140,   339142.74084046457}, 
    {     0.00000000033,  3.74742271467,   154938.34595416138}, 
    {     0.00000000031,  4.31849572821,    52072.71350892979}, 
    {     0.00000000032,  3.22125075139,   178063.36849396059}, 
    {     0.00000000035,  5.04239162008,   188276.65404017158}, 
    {     0.00000000041,  3.22894786620,     1162.47470440780}, 
    {     0.00000000032,  2.71248623758,    25780.34552060460}, 
    {     0.00000000032,  3.81071008195,   157483.01859105378}, 
    {     0.00000000030,  0.37624678251,    26421.75908234360}, 
    {     0.00000000030,  2.31384665804,     1478.86657406440}, 
    {     0.00000000031,  6.02113204508,    26198.10946279360}, 
    {     0.00000000040,  1.02062201314,    27819.02549450680}, 
    {     0.00000000029,  2.67809374172,      110.20632121940}, 
    {     0.00000000029,  5.82834696468,   104344.49901929598}, 
    {     0.00000000030,  2.25771223167,   104371.28232719658}, 
    {     0.00000000028,  4.63556053618,    74923.09699802278}, 
    {     0.00000000037,  3.03820461285,    11610.55195837420}, 
    {     0.00000000030,  1.32768749762,     1375.77379984580}, 
    {     0.00000000032,  0.26646287192,    52065.59996192899}, 
    {     0.00000000037,  1.25738019637,   131498.89763806018}, 
    {     0.00000000032,  1.04692878427,    26086.41866886590}, 
    {     0.00000000036,  1.63924791422,    50800.03248330259}, 
    {     0.00000000030,  0.15547655101,   104331.94280539699}, 
    {     0.00000000026,  0.02869654675,    24815.22211594700}, 
    {     0.00000000026,  1.03051070102,    24292.64469785319}, 
    {     0.00000000027,  0.60357942596,   111590.28815789679}, 
    {     0.00000000026,  5.74760347398,    54294.57014352679}, 
    {     0.00000000031,  3.35995297387,   126996.94076290558}, 
    {     0.00000000026,  2.79980619229,    86457.98475793119}, 
    {     0.00000000025,  3.55507227780,   156100.82065856918}, 
    {     0.00000000025,  2.34197986382,    24601.92302050899}, 
    {     0.00000000026,  5.71059743781,    97670.38771289718}, 
    {     0.00000000033,  0.24573646815,    26395.46076254379}, 
    {     0.00000000025,  5.71438388019,   181505.94343892598}, 
    {     0.00000000025,  2.19646515906,    52250.58788171570}, 
    {     0.00000000025,  1.82858587521,       74.78159856730}, 
    {     0.00000000023,  5.07063706452,   104564.91166173479}, 
    {     0.00000000023,  6.24119188701,    75615.25459924959}, 
    {     0.00000000024,  2.04753578861,    26521.61487945100}, 
    {     0.00000000025,  3.35696591423,    28286.99048486120}, 
    {     0.00000000026,  3.35225659095,   110634.68841628819}, 
    {     0.00000000028,  0.56562335947,   125112.03959948818}, 
    {     0.00000000027,  2.39055852898,      522.57741809380}, 
    {     0.00000000028,  0.24656427036,      103.09277421860}, 
    {     0.00000000025,  0.14885265829,    22759.76748529401}, 
    {     0.00000000032,  1.70300856186,    26089.38761428249}, 
    {     0.00000000025,  4.72485493580,    13362.44970679920}, 
    {     0.00000000026,  2.07910302219,    29550.14784743939}, 
    {     0.00000000025,  5.27245546317,    25936.85547173129}, 
    {     0.00000000024,  0.09057155891,    51859.41441349179}, 
    {     0.00000000022,  4.15509763801,    24176.70365835700}, 
    {     0.00000000024,  0.80826744274,    77829.99768684579}, 
    {     0.00000000030,  1.21279872188,    97112.93697469679}, 
    {     0.00000000023,  2.30729456974,    77410.51304297059}, 
    {     0.00000000022,  4.82022861734,    13541.42120249119}, 
    {     0.00000000026,  6.26940339209,    25939.82441714789}, 
    {     0.00000000023,  2.65745031641,    52492.19815280499}, 
    {     0.00000000024,  4.93609558838,    52698.38370124219}, 
    {     0.00000000022,  1.24209358625,   103285.11708910679}, 
    {     0.00000000022,  0.79086333802,   104202.04936916218}, 
    {     0.00000000022,  1.95647457585,    24356.78078864160}, 
    {     0.00000000021,  2.52943432215,      467.96499035440}, 
    {     0.00000000022,  3.68660576300,    26729.31670331319}, 
    {     0.00000000021,  5.49527500986,   112231.70171963578}, 
    {     0.00000000023,  1.84999492041,    76571.54375522019}, 
    {     0.00000000023,  1.18923260859,   141762.17980617538}, 
    {     0.00000000025,  2.55846756753,    24822.33566294780}, 
    {     0.00000000027,  3.60550105765,    23962.02573419499}, 
    {     0.00000000023,  2.60707335355,    25754.04720080480}, 
    {     0.00000000026,  0.76123293665,    55516.41870984820}, 
    {     0.00000000026,  2.09701412913,   134991.46920492979}, 
    {     0.00000000020,  3.35114638284,    52595.29092702359}, 
    {     0.00000000021,  0.36856325095,    97580.90196505119}, 
    {     0.00000000021,  5.70555721397,    60055.89543648739}, 
    {     0.00000000024,  0.51930649617,   116917.76426627958}, 
    {     0.00000000019,  2.85664849845,    60370.08161635699}, 
    {     0.00000000019,  0.57202736293,    52125.80966124419}, 
    {     0.00000000024,  3.51346257561,    77844.22478084739}, 
    {     0.00000000019,  0.54258647630,    26941.09952332620}, 
    {     0.00000000019,  6.25208431325,    25973.50403466079}, 
    {     0.00000000022,  5.14053236920,   104347.73123093879}, 
    {     0.00000000021,  4.13818325733,   103299.34418310839}, 
    {     0.00000000019,  0.33672573506,   102018.41617342478}, 
    {     0.00000000018,  1.90089087831,    52325.36948028299}, 
    {     0.00000000019,  4.27464346361,   122444.98726584678}, 
    {     0.00000000019,  5.68003083783,    54509.00267602040}, 
    {     0.00000000018,  1.43369019964,    53242.30176033840}, 
    {     0.00000000018,  2.45228682430,   104358.72611329758}, 
    {     0.00000000018,  1.06798371960,    27780.06881107659}, 
    {     0.00000000023,  1.86418858933,   116783.65521669458}, 
    {     0.00000000021,  2.99699115190,    26073.67604757259}, 
    {     0.00000000018,  4.86636715695,   170049.17029103659}, 
    {     0.00000000019,  4.89530983995,    53228.07466633679}, 
    {     0.00000000021,  2.47209635724,    27726.97265876220}, 
    {     0.00000000020,  4.99224602107,   104778.21075717278}, 
    {     0.00000000021,  1.47188069923,   140652.80125408198}, 
    {     0.00000000022,  0.87466972564,   119116.85160956658}, 
    {     0.00000000017,  4.05072250317,    76667.52298243798}, 
    {     0.00000000018,  1.69254770146,    76681.75007643958}, 
    {     0.00000000019,  4.81653733420,    51528.79544983359}, 
    {     0.00000000023,  2.09581007213,    52225.80290505260}, 
    {     0.00000000019,  0.74728940617,    36109.74042167360}, 
    {     0.00000000016,  2.93241655330,   102132.85546210999}, 
    {     0.00000000018,  5.00476392390,   105940.68546158058}, 
    {     0.00000000021,  3.53806328767,   106570.36967048359}, 
    {     0.00000000018,  4.66155601593,    61279.71327726600}, 
    {     0.00000000022,  3.56812851373,   104355.49390165479}, 
    {     0.00000000019,  4.43774117349,      647.01083331480}, 
    {     0.00000000017,  2.10545220233,    64901.25971792339}, 
    {     0.00000000017,  2.83176092494,   132658.27281205778}, 
    {     0.00000000017,  5.67040223146,    25788.77674730500}, 
    {     0.00000000018,  2.89493956098,    26091.83529483729}, 
    {     0.00000000017,  5.38147763977,    78731.67441507700}, 
    {     0.00000000015,  5.25853489897,   150244.34299945379}, 
    {     0.00000000019,  4.36796558291,    24182.43837663380}, 
    {     0.00000000019,  1.70937445812,      153.77881048480}, 
    {     0.00000000015,  1.13029685380,    25042.74830538660}, 
    {     0.00000000015,  2.16455066064,    26222.01219115920}, 
    {     0.00000000017,  3.97920822146,   207643.84320240439}, 
    {     0.00000000015,  5.16204794210,    27684.08958385880}, 
    {     0.00000000016,  5.73885440717,    25352.02662804239}, 
    {     0.00000000015,  2.31658070939,    51852.30086649099}, 
    {     0.00000000014,  3.42267011966,    26823.77965510599}, 
    {     0.00000000014,  2.50300888215,    32132.13172294960}, 
    {     0.00000000014,  0.64831361219,      323.50541665740}, 
    {     0.00000000014,  6.07546939857,    78270.33798362259}, 
    {     0.00000000017,  6.02302146414,    26667.59072857300}, 
    {     0.00000000014,  1.36600630226,    23919.14265929160}, 
    {     0.00000000019,  4.41224311863,    49953.94964855139}, 
    {     0.00000000013,  1.32912005824,   129799.61842155698}, 
    {     0.00000000013,  5.28407417719,      742.99006053260}, 
    {     0.00000000013,  5.59372980773,   209812.60368468695}, 
    {     0.00000000014,  1.17381822060,   104275.34649502118}, 
    {     0.00000000014,  5.53140406603,    77630.92568540938}, 
    {     0.00000000014,  0.44776281245,    17893.62780836560}, 
    {     0.00000000018,  1.65347821757,    28256.66362385679}, 
    {     0.00000000014,  4.81716097174,     2221.85663459700}, 
    {     0.00000000015,  3.17385925198,   176953.98994186718}, 
    {     0.00000000013,  0.78761204117,   173511.41499690177}, 
    {     0.00000000014,  2.91486993959,    78257.08086582259}, 
    {     0.00000000017,  1.98703193197,    27037.07875054399}, 
    {     0.00000000013,  2.32883100115,    27005.83342755599}, 
    {     0.00000000014,  3.95960354665,    51432.81622261579}, 
    {     0.00000000015,  1.32037560412,    27669.86248985719}, 
    {     0.00000000013,  1.39086614790,    25024.58905812189}, 
    {     0.00000000013,  3.85817843282,   182085.63102592478}, 
    {     0.00000000015,  1.99264271696,    52381.99183158559}, 
    {     0.00000000012,  3.33811921058,    25508.21555457540}, 
    {     0.00000000016,  5.59174105029,    25446.48957983520}, 
    {     0.00000000012,  3.96861439229,    78188.92782615528}, 
    {     0.00000000012,  5.32870101114,    80174.90890793978}, 
    {     0.00000000016,  2.19148092925,    26308.31578401300}, 
    {     0.00000000012,  5.45614378004,   107794.18751126219}, 
    {     0.00000000014,  0.70193545832,   172402.03644480839}, 
    {     0.00000000012,  1.54035928437,    52252.07235442399}, 
    {     0.00000000014,  3.47280146015,    27177.61193276780}, 
    {     0.00000000014,  2.70931032077,    27311.72098235281}, 
    {     0.00000000013,  0.52324869857,    75930.51303185058}, 
    {     0.00000000012,  5.76352424828,    50167.24874398939}, 
    {     0.00000000011,  2.65933951973,   137210.22630911658}, 
    {     0.00000000011,  0.61260463058,    44295.71712980940}, 
    {     0.00000000011,  4.75744397675,   155571.81910783658}, 
    {     0.00000000011,  0.92596625175,    22625.65843570900}, 
    {     0.00000000014,  5.94031170257,    52290.24557183361}, 
    {     0.00000000013,  2.88183763459,   112545.88789950538}, 
    {     0.00000000012,  6.20307751102,    51653.22886505459}, 
    {     0.00000000014,  0.79666118269,    25953.79409198919}, 
    {     0.00000000011,  2.82291310257,    77101.23472031478}, 
    {     0.00000000011,  1.26691831337,    26312.24793727610}, 
    {     0.00000000011,  6.04692861527,    27044.19229754480}, 
    {     0.00000000011,  3.59050910670,    52712.61079524379}, 
    {     0.00000000012,  3.29867482436,    52061.36699446317}, 
    {     0.00000000011,  4.14868784122,    45290.65639321759}, 
    {     0.00000000012,  2.20117670946,    31415.37924995700}, 
    {     0.00000000011,  3.28550164867,    28736.35796704720}, 
    {     0.00000000011,  2.94144581880,    58857.03113654799}, 
    {     0.00000000014,  2.76963894785,    23888.81579828719}, 
    {     0.00000000010,  0.46195987169,    24448.83362438620}, 
    {     0.00000000010,  2.86866087585,   130226.21661243298}, 
    {     0.00000000010,  5.45102637711,   163298.12945069079}, 
    {     0.00000000013,  4.41913559624,    19958.60610206760}, 
    {     0.00000000012,  5.95935970873,    26083.97098831109}, 
    {     0.00000000013,  3.57379666664,    77795.74443436819}, 
    {     0.00000000010,  3.83420431277,    51226.63067417859}, 
    {     0.00000000012,  1.57272284029,    91805.13062721379}, 
    {     0.00000000010,  1.11456831986,    78903.60671103658}, 
    {     0.00000000011,  1.35230305494,    51969.62073471119}, 
    {     0.00000000010,  4.67337740333,     2111.65031337760}, 
    {     0.00000000011,  5.80271751795,    27972.80430499159}, 
    {     0.00000000011,  5.80527692287,    26102.13023557580}, 
    {     0.00000000013,  0.32349874907,   157057.10981453978}, 
    {     0.00000000010,  1.14247096580,     9384.84100807520}, 
    {     0.00000000013,  4.60340992512,    25032.45336464809}, 
    {     0.00000000011,  2.47098170967,    26010.15259759030}, 
    {     0.00000000010,  4.34994273616,   157586.80077963437}, 
    {     0.00000000010,  1.10800044909,    65831.66677432480}, 
    {     0.00000000012,  5.55659972511,    22909.75735100660}, 
    {     0.00000000011,  4.67416745722,    50064.15596977079}, 
    {     0.00000000009,  2.37765084995,    78896.49316403578}, 
    {     0.00000000009,  0.47421378853,   128106.31931499895}, 
    {     0.00000000011,  6.23832638741,    30171.89164827860}, 
    {     0.00000000009,  1.42183589402,   104505.39137678158}, 
    {     0.00000000009,  4.85867084365,    24918.31489016559}, 
    {     0.00000000010,  2.78334321933,    81591.84508100279}, 
    {     0.00000000010,  0.87205573987,    78366.80219894118}, 
    {     0.00000000009,  5.40574630906,   130459.18546877075}, 
    {     0.00000000010,  1.65859404347,    78039.36462902068}, 
    {     0.00000000009,  3.03509575630,    51329.72344839720}, 
    {     0.00000000009,  1.96004127485,    26575.53789282839}, 
    {     0.00000000010,  1.17585399339,    50270.34151820800}, 
    {     0.00000000009,  5.53838845699,     8194.27533320860}, 
    {     0.00000000009,  3.66100752188,   151199.94274106238}, 
    {     0.00000000009,  1.60088408502,   117893.03376878797}, 
    {     0.00000000010,  3.21502369366,    77307.42026875199}, 
    {     0.00000000009,  0.42023516699,    27223.58001346740}, 
    {     0.00000000008,  1.34535060467,    12546.48193908300}, 
    {     0.00000000009,  5.46394041390,    16703.06213349900}, 
    {     0.00000000009,  1.60635058887,    77616.69859140778}, 
    {     0.00000000010,  1.76453908885,    77726.90491262719}, 
    {     0.00000000009,  5.48514099908,   138319.60486120995}, 
    {     0.00000000009,  5.66705612562,    50910.23880452200}, 
    {     0.00000000009,  0.69447244274,    26709.64694241340}, 
    {     0.00000000009,  6.23127403544,      846.08283475120}, 
    {     0.00000000010,  5.49114293123,    94329.77528619739}, 
    {     0.00000000011,  0.75948957862,   128320.75184749259}, 
    {     0.00000000009,  0.50088873003,    27573.19384827740}, 
    {     0.00000000008,  1.18612452170,   104197.83375581198}, 
    {     0.00000000011,  6.20672194821,    28102.88481337200}, 
    {     0.00000000008,  0.96153145702,    19202.75325164339}, 
    {     0.00000000009,  1.73726961641,    28791.51929624980}, 
    {     0.00000000008,  4.51184849789,    27463.67694142000}, 
    {     0.00000000008,  3.59638355762,    76784.84285065818}, 
    {     0.00000000009,  1.55645109651,    26126.03617721200}, 
    {     0.00000000008,  1.09983228187,    78160.61665050399}, 
    {     0.00000000008,  6.23118263675,      148.07872442630}, 
    {     0.00000000008,  0.87630174262,      151.04766984290}, 
    {     0.00000000008,  3.17310230516,    50903.12525752120}, 
    {     0.00000000011,  1.85720558473,   214364.55718174578}, 
    {     0.00000000008,  2.49935513570,    51955.39364070959}, 
    {     0.00000000008,  2.66478360481,   130432.40216087017}, 
    {     0.00000000008,  3.12318873266,    22003.91463486980}, 
    {     0.00000000008,  4.20069783382,    50380.54783942739}, 
    {     0.00000000008,  5.82869890340,     3328.13565628019}, 
    {     0.00000000010,  2.61302801987,    27170.98337386779}, 
    {     0.00000000008,  3.45199097443,    24203.00197815680}, 
    {     0.00000000008,  0.37984013982,   183570.92173262799}, 
    {     0.00000000008,  3.44870214429,    26402.08932144380}, 
    {     0.00000000008,  6.15047498198,    37698.45509994840}, 
    {     0.00000000007,  0.09645033702,      206.18554843720}, 
    {     0.00000000007,  5.88329863855,    51868.24866217880}, 
    {     0.00000000007,  4.80640635339,    26118.23000257860}, 
    {     0.00000000010,  2.52561621829,    35833.22369743080}, 
    {     0.00000000007,  3.79900304025,   103917.90082841998}, 
    {     0.00000000008,  1.59041748036,   101011.00013959699}, 
    {     0.00000000009,  2.57099726908,     2125.87740737920}, 
    {     0.00000000007,  5.32440574441,    35077.37084700659}, 
    {     0.00000000007,  2.46084982091,    52137.67324751059}, 
    {     0.00000000008,  4.37434019274,   123200.84011627098}, 
    {     0.00000000009,  5.13687735660,    55638.05098901359}, 
    {     0.00000000007,  5.98045973961,    52179.73843641149}, 
    {     0.00000000009,  2.52935998753,    25227.59321282139}, 
    {     0.00000000009,  0.68598593831,       38.13303563780}, 
    {     0.00000000009,  3.57329597023,     1265.56747862640}, 
    {     0.00000000009,  1.65566330689,    65717.22748563958}, 
    {     0.00000000007,  3.88988296844,     1485.98012106520}, 
    {     0.00000000007,  4.29110565750,   155887.52156313117}, 
    {     0.00000000008,  0.47377071059,   181026.24909573558}, 
    {     0.00000000008,  5.57007244381,    50689.82616208319}, 
    {     0.00000000010,  0.82585923948,    39763.43339365039}, 
    {     0.00000000007,  4.34057816709,   129373.02023068098}, 
    {     0.00000000007,  0.41164824366,   182188.72380014337}, 
    {     0.00000000008,  0.23518929674,    50049.92887576919}, 
    {     0.00000000007,  3.14813276838,    52061.40717623499}, 
    {     0.00000000008,  1.24064472176,    76041.85279012559}, 
    {     0.00000000009,  3.52369322812,     2008.55753915900}, 
    {     0.00000000007,  4.86954611488,    27351.06050415239}, 
    {     0.00000000009,  1.96717423051,   365230.64398203876}, 
    {     0.00000000007,  5.46143723851,    25985.94062330859}, 
    {     0.00000000008,  6.26980974962,   204151.27163553478}, 
    {     0.00000000007,  3.42584394985,    52483.36390411799}, 
    {     0.00000000007,  2.52325477952,   207593.84658050018}, 
    {     0.00000000009,  0.69792128051,   233731.74634397858}, 
    {     0.00000000007,  0.13818691784,    52911.68279668019}, 
    {     0.00000000007,  3.98674061320,    13675.53025207620}, 
    {     0.00000000007,  4.44340268776,    26057.57628056979}, 
    {     0.00000000007,  2.53713814740,    80382.47328510099}, 
    {     0.00000000007,  0.03218225075,    31281.27020037200}, 
    {     0.00000000007,  4.33489563070,   167850.08294774959}, 
    {     0.00000000008,  4.62571179271,    76887.93562487679}, 
    {     0.00000000008,  4.03988460752,    53906.92863608099}, 
    {     0.00000000006,  1.59873561232,   143980.93691036216}, 
    {     0.00000000007,  3.52756376168,    52509.66222391780}, 
    {     0.00000000007,  5.24448652662,     1795.25844372100}, 
    {     0.00000000007,  5.21000690023,   161079.37234650398}, 
    {     0.00000000007,  1.70582791676,    54087.00576636560}, 
    {     0.00000000007,  4.28578455719,    51130.65144696079}, 
    {     0.00000000007,  3.42650023556,    29396.36903695460}, 
    {     0.00000000006,  3.18788579110,    24072.92146977640}, 
    {     0.00000000008,  0.70492853290,    25169.97285559240}, 
    {     0.00000000007,  5.70539968132,     9745.32055585660}, 
    {     0.00000000008,  0.13922543752,   136722.59155786238}, 
    {     0.00000000007,  5.42861124484,    27566.76971563859}, 
    {     0.00000000007,  3.95476784450,   145204.75475114079}, 
    {     0.00000000007,  3.78837180264,    26189.86565983980}, 
    {     0.00000000008,  3.40119385646,    78153.50310350319}, 
    {     0.00000000006,  1.19861324023,    26734.91397488900}, 
    {     0.00000000007,  0.57045467282,   118828.96374949679}, 
    {     0.00000000008,  3.30573659151,   130419.84594697120}, 
    {     0.00000000006,  5.17878386927,    78338.49102328988}, 
    {     0.00000000007,  1.86755524082,     1905.46476494040}, 
    {     0.00000000008,  3.80625042789,   137678.19129947099}, 
    {     0.00000000007,  1.20815914313,    61560.64729122359}, 
    {     0.00000000008,  5.80110689687,    25773.71696170459}, 
    {     0.00000000008,  4.81332582969,   142871.55835826878}, 
    {     0.00000000008,  1.46122702584,    87367.61641884019}, 
    {     0.00000000008,  0.88124699513,      220.41264243880}, 
    {     0.00000000007,  1.64179152420,   196137.07343261078}, 
    {     0.00000000006,  0.90242839977,   129387.24732468258}, 
    {     0.00000000007,  5.69215909880,   158746.17595363196}, 
    {     0.00000000006,  4.05724988846,    52174.32181044009}, 
    {     0.00000000006,  1.71090238858,    26830.89320210680}, 
    {     0.00000000006,  6.10253738949,   203041.89308344138}, 
    {     0.00000000006,  0.30738123560,    54374.89362643540}, 
    {     0.00000000006,  0.41222313301,     2199.08734328700}, 
    {     0.00000000006,  1.43510177069,     2333.19639287200}, 
    {     0.00000000006,  3.93656809970,   130289.95251073639}, 
    {     0.00000000007,  0.36974820473,   103932.12792242158}, 
    {     0.00000000006,  2.72826803217,    76255.15188556358}, 
    {     0.00000000007,  1.27402494790,    46046.50924364180}, 
    {     0.00000000006,  0.44952989323,   208173.53416749898}, 
    {     0.00000000008,  4.68388468911,    25014.29411738339}, 
    {     0.00000000007,  3.81640774507,    52041.69723356339}, 
    {     0.00000000008,  5.42651288061,      949.17560896980}, 
    {     0.00000000006,  0.52080930820,    25004.82290928060}, 
    {     0.00000000008,  3.01472942819,    26076.85744131030}, 
    {     0.00000000007,  5.36517964373,    77940.20400806518}, 
    {     0.00000000006,  3.49010452393,   123668.80510662538}, 
    {     0.00000000006,  4.57296057068,    35211.47989659159}, 
    {     0.00000000006,  5.37176342300,    53093.73656913019}, 
    {     0.00000000006,  1.99673742216,   130435.63437251298}, 
    {     0.00000000006,  3.10336530669,    77947.31755506598}, 
    {     0.00000000008,  5.49357414100,    53814.87580033639}, 
    {     0.00000000008,  2.24316734824,    25466.15934073500}, 
    {     0.00000000006,  6.09625894529,   103395.32341032618}, 
    {     0.00000000008,  5.31272348192,    24388.62392507099}, 
    {     0.00000000005,  0.44435745265,   179172.74704605396}, 
    {     0.00000000005,  5.64850202903,    28774.62523611540}, 
    {     0.00000000005,  5.86981284050,   156314.11975400719}, 
    {     0.00000000007,  4.21874962552,    26098.94884183810}, 
    {     0.00000000006,  2.19700567791,    12412.37288949800}, 
    {     0.00000000006,  1.28784041110,   102975.83876645098}, 
    {     0.00000000005,  4.94698005592,    50444.68393021580}, 
    {     0.00000000006,  1.82802843508,    24402.85101907260}, 
    {     0.00000000005,  5.64154870955,    55503.94193942859}, 
    {     0.00000000006,  0.02944876240,    20043.67456019880}, 
    {     0.00000000006,  1.01830751527,   183674.70392120858}, 
    {     0.00000000006,  2.19844933048,   103718.82882698359}, 
    {     0.00000000006,  2.48218378908,    51439.92976961659}, 
    {     0.00000000007,  3.65669338110,   143005.66740785378}, 
    {     0.00000000006,  5.02499172571,    78469.89497315978}, 
    {     0.00000000006,  3.28107700351,   144916.86689107098}, 
    {     0.00000000005,  1.52974136650,    26724.89941359840}, 
    {     0.00000000005,  5.43264125558,   130446.62925487179}, 
    {     0.00000000006,  6.20586010225,      114.39910691340}, 
    {     0.00000000005,  1.97758412332,   130652.81480330898}, 
    {     0.00000000007,  0.75444891777,    77520.71936418998}, 
    {     0.00000000005,  3.42800816448,    50536.73676596039}, 
    {     0.00000000005,  1.69966337069,    78786.28684281638}, 
    {     0.00000000005,  5.46516609389,   103498.41618454478}, 
    {     0.00000000006,  4.70912746923,    52177.29075585669}, 
    {     0.00000000005,  5.03210861040,     1045.15483618760}, 
    {     0.00000000005,  4.19089790418,   130363.24963659538}, 
    {     0.00000000005,  6.27157957330,     1272.68102562720}, 
    {     0.00000000005,  1.36461885531,   181659.72224941078}, 
    {     0.00000000006,  2.86818435011,    52755.49387014719}, 
    {     0.00000000005,  5.57712092238,   106262.81204951399}, 
    {     0.00000000007,  3.82369524609,    62197.64356324779}, 
    {     0.00000000005,  4.48988723219,    50007.04580086580}, 
    {     0.00000000005,  5.67785301537,    78580.10129437919}, 
    {     0.00000000006,  3.63826732126,   198489.93958638258}, 
    {     0.00000000007,  3.08378061801,    52027.72755872209}, 
    {     0.00000000005,  0.06002744854,    51596.11869614960}, 
    {     0.00000000006,  2.81224506925,    25450.90686955000}, 
    {     0.00000000005,  5.06206878451,    52609.51802102519}, 
    {     0.00000000005,  4.13691080116,    53867.97195265079}, 
    {     0.00000000005,  0.66848559375,   104276.83096772949}, 
    {     0.00000000005,  4.95249581376,    78413.27262185719}, 
    {     0.00000000005,  3.55435464017,    43981.53094993980}, 
    {     0.00000000005,  0.50816610094,      299.12639426920}, 
    {     0.00000000006,  2.94825784581,    56259.79478985279}, 
    {     0.00000000005,  5.74190826395,   103189.13786188899}, 
    {     0.00000000005,  0.31741758800,    78800.51393681798}, 
    {     0.00000000006,  3.74336258475,    26247.20487636640}, 
    {     0.00000000006,  2.73646698829,    52286.01260436779}, 
    {     0.00000000005,  1.77497247774,   129586.31932611899}, 
    {     0.00000000006,  2.57896380153,    26014.60601571519}, 
    {     0.00000000005,  2.23635663946,    24513.05734029200}, 
    {     0.00000000006,  0.42705996592,   130443.39704322898}, 
    {     0.00000000006,  5.13378058477,    78313.70604662679}, 
    {     0.00000000005,  2.46839838469,   123758.29085447139}, 
    {     0.00000000006,  1.18640004452,    25600.26839032000}, 
    {     0.00000000006,  5.08742416907,    53124.98189211819}, 
    {     0.00000000007,  2.15977683208,    52024.75861330549}, 
    {     0.00000000006,  4.52235258445,   166740.70439565618}, 
    {     0.00000000005,  4.87195511152,   102659.44689679438}, 
    {     0.00000000006,  0.31441101535,   102872.74599223239}, 
    {     0.00000000005,  1.42393263915,    28199.55345495179}, 
    {     0.00000000005,  1.39267646690,    39450.35284837340}, 
    {     0.00000000006,  1.37133092960,    51120.35650622229}, 
    {     0.00000000006,  6.22297289912,    78149.27013603736}, 
    {     0.00000000005,  0.57729967408,    26933.98597632540}, 
    {     0.00000000006,  1.80407643479,    23549.65463732060}, 
    {     0.00000000005,  3.60259399818,       11.04570026390}, 
    {     0.00000000005,  3.93868954411,    48713.56157728320}, 
    {     0.00000000006,  1.44234050040,    76152.05911134499}, 
    {     0.00000000006,  3.19917719734,   183145.01295611398}, 
    {     0.00000000005,  4.55197145990,    79330.20490191258}, 
    {     0.00000000005,  0.84232799985,    24551.92639860479}, 
    {     0.00000000005,  4.45098264390,   102769.65321801379}, 
    {     0.00000000005,  2.92291007768,    54190.78795494619}, 
    {     0.00000000005,  0.46604463103,    52817.21984488739}, 
    {     0.00000000006,  1.11258968779,    25647.07785669659}, 
    {     0.00000000005,  3.96038779086,    25657.37279743509}, 
    {     0.00000000005,  3.75575867114,    52797.55008398759}, 
    {     0.00000000005,  3.61079719482,    26411.40855823160}, 
    {     0.00000000005,  1.66822570670,    47803.92991637420}, 
    {     0.00000000006,  2.32203480843,    27665.24668402200}, 
    {     0.00000000004,  1.86177066589,    53771.99272543299}, 
    {     0.00000000005,  4.85075574464,    54344.56676543099}, 
    {     0.00000000005,  6.19447408823,    26191.68533015479}, 
    {     0.00000000005,  3.73206511731,    78213.71280281838}, 
    {     0.00000000004,  2.13995639327,   189386.03259226495}, 
    {     0.00000000006,  2.60366708487,    78378.14871340781}, 
    {     0.00000000004,  1.39917225370,    26290.15653674829}, 
    {     0.00000000005,  1.09229620764,    26183.88236879199}, 
    {     0.00000000006,  0.88029618554,    23336.35554188260}, 
    {     0.00000000005,  6.13113074115,    26026.17716683400}, 
    {     0.00000000004,  4.94928690334,    52663.44103440259}, 
    {     0.00000000004,  0.62360130446,   102755.42612401219}, 
    {     0.00000000005,  6.04519983514,    52161.57918914679}, 
    {     0.00000000004,  1.71609047005,    23762.95373275860}, 
    {     0.00000000004,  0.21148637237,    19336.86230122839}, 
    {     0.00000000005,  3.31951258622,    45424.76544280259}, 
    {     0.00000000004,  0.09463875144,    78683.19406859778}, 
    {     0.00000000005,  6.01855111376,   128220.75860368418}, 
    {     0.00000000005,  1.78257995471,   187167.27548807819}, 
    {     0.00000000005,  4.99565783477,    41494.55574658299}, 
    {     0.00000000005,  4.64166221826,    24824.74577899600}, 
    {     0.00000000004,  1.61945390198,    28309.75977617119}, 
    {     0.00000000006,  2.62148938551,    52171.87412988529}, 
    {     0.00000000004,  0.52972446133,    77314.53381575279}, 
    {     0.00000000006,  2.56621666333,    51876.67988887919}, 
    {     0.00000000006,  2.53671356332,    52190.03337714999}, 
    {     0.00000000005,  5.84026664575,   104344.98400739678}, 
    {     0.00000000004,  3.77333237335,   153084.84390447979}, 
    {     0.00000000004,  3.42433134364,    53311.48315504160}, 
    {     0.00000000004,  1.92553176807,   156547.08861034496}, 
    {     0.00000000004,  4.29836210336,   130593.29451835579}, 
    {     0.00000000005,  0.30567664615,   103883.64757594238}, 
    {     0.00000000004,  4.24846221979,   189853.99758261938}, 
    {     0.00000000004,  6.09490221813,    77417.62658997139}, 
    {     0.00000000005,  3.46214176278,    48847.67062686820}, 
    {     0.00000000006,  3.71691630302,    81604.32185142238}, 
    {     0.00000000004,  3.62019381955,    70383.62027138360}, 
    {     0.00000000004,  3.62744843597,    53029.00266490040}, 
    {     0.00000000004,  1.40344660688,    25885.64974640009}, 
    {     0.00000000006,  2.54555794681,    54060.70744656579}, 
    {     0.00000000004,  4.06110284313,    91919.56991589899}, 
    {     0.00000000005,  3.92504614590,   101703.15774082378}, 
    {     0.00000000004,  5.48109256361,    78225.57638908479}, 
    {     0.00000000004,  5.92354219151,    84944.93427812219}, 
    {     0.00000000005,  1.45746030546,    51102.19725895759}, 
    {     0.00000000004,  0.18748530762,    52489.99246301800}, 
    {     0.00000000005,  0.64220436035,     3178.14579056760}, 
    {     0.00000000005,  1.74091893413,    79315.97780791098}, 
    {     0.00000000005,  4.33120733566,    51112.49219969609}, 
    {     0.00000000005,  0.28595106407,    26161.20026743319}, 
    {     0.00000000005,  0.30883343706,    53265.51507434200}, 
    {     0.00000000004,  4.51338981538,    78339.97549599818}, 
    {     0.00000000005,  1.96614115805,   130866.11389874699}, 
    {     0.00000000004,  0.09019783661,    58220.03486452380}, 
    {     0.00000000004,  5.51106442769,    78043.29678228378}, 
    {     0.00000000004,  0.59216167629,    16342.58258571760}, 
    {     0.00000000005,  0.32341090439,    28096.46068073319}, 
    {     0.00000000004,  5.15437140585,    24285.53115085240}, 
    {     0.00000000005,  2.15151582679,    48997.66049258080}, 
    {     0.00000000005,  4.75657933833,   240452.46032331996}, 
    {     0.00000000004,  5.35396036827,   104984.39630560997}, 
    {     0.00000000004,  3.83354739662,       14.22709400160}, 
    {     0.00000000004,  1.52206374281,    26267.98027185880}, 
    {     0.00000000004,  2.36732975711,       19.66976089979}, 
    {     0.00000000004,  5.10954286080,    31722.93687092660}, 
    {     0.00000000004,  1.54518951672,    52206.13314415280}, 
    {     0.00000000004,  4.66669337352,   104127.26777059489}, 
    {     0.00000000005,  5.74829513019,    51841.95034237900}, 
    {     0.00000000004,  3.30106035790,      316.39186965660}, 
    {     0.00000000004,  2.93299901703,    31775.53351052620}, 
    {     0.00000000004,  4.06219603307,   130285.73689738619}, 
    {     0.00000000004,  1.74441095464,    26248.31051095900}, 
    {     0.00000000004,  4.12254586219,    27441.65188659100}, 
    {     0.00000000004,  4.15776973428,    26279.35140768579}, 
    {     0.00000000004,  1.15784310255,    50264.60679993120}, 
    {     0.00000000004,  5.23429009814,    52396.21892558720}, 
    {     0.00000000004,  5.30327887066,    25672.35065096209}, 
    {     0.00000000005,  1.10382058499,    31903.01400121119}, 
    {     0.00000000005,  2.71036686336,    24952.22626968100}, 
    {     0.00000000004,  2.64042462073,    24602.61243487099}, 
    {     0.00000000004,  1.87407286172,    15406.65260500879}, 
    {     0.00000000004,  5.78862899204,    22779.43724619380}, 
    {     0.00000000004,  4.22021430563,     1731.12235293260}, 
    {     0.00000000004,  3.29759878123,    76137.83201734339}, 
    {     0.00000000005,  4.41662635417,    78057.52387628538}, 
    {     0.00000000004,  1.57423026339,   128747.35003836859}, 
    {     0.00000000005,  5.17627834613,    19367.18916223280}, 
    {     0.00000000004,  4.68271936370,   103814.80805420138}, 
    {     0.00000000004,  2.99546350548,    77741.13200662879}, 
    {     0.00000000004,  3.47912671031,    53661.09698985160}, 
    {     0.00000000004,  1.47969113461,   120417.67842777158}, 
    {     0.00000000004,  5.51314482955,   132350.71519108818}, 
    {     0.00000000004,  2.11602271207,   235900.50682626116}, 
    {     0.00000000004,  3.41919050321,    26114.20146137400}, 
    {     0.00000000004,  2.87953962922,    25862.07387316400}, 
    {     0.00000000005,  5.71960795619,     1911.19948321720}, 
    {     0.00000000004,  2.82954379060,   133767.65136415116}, 
    {     0.00000000004,  3.12567603415,    20894.53608277640}, 
    {     0.00000000004,  2.20022040184,    52073.84376488279}, 
    {     0.00000000003,  1.65447289500,    51006.21803173979}, 
    {     0.00000000004,  0.72729563393,    25865.04281858059}, 
    {     0.00000000004,  4.75773817489,   156740.71794488319}, 
    {     0.00000000004,  5.61140287619,    53258.88651544199}, 
    {     0.00000000004,  1.55115346866,    53438.96364572659}, 
    {     0.00000000005,  0.91157457367,    25665.23710396129}, 
    {     0.00000000005,  6.11074430084,   156507.74908854539}, 
    {     0.00000000003,  3.13187739577,    80462.79676800959}, 
    {     0.00000000004,  0.99586228194,   149288.74325784518}, 
    {     0.00000000004,  3.81858133541,    26513.81191808820}, 
    {     0.00000000003,  3.76308396741,       77.75054398390}, 
    {     0.00000000004,  2.20983069576,    76777.72930365738}, 
    {     0.00000000004,  1.96565283101,   132028.58860315479}, 
    {     0.00000000004,  0.75635766859,    23384.28698689860}, 
    {     0.00000000003,  2.47442898563,    77956.15180375299}, 
    {     0.00000000004,  3.82892344861,   104454.70534051539}, 
    {     0.00000000004,  4.06084495744,    33856.26969826880}, 
    {     0.00000000004,  1.56161739887,     1055.44977692610}, 
    {     0.00000000005,  3.11675458540,    26149.62911631439}, 
    {     0.00000000004,  3.75207273650,    49424.25868345679}, 
    {     0.00000000004,  4.12046971863,   104991.50985261079}, 
    {     0.00000000003,  4.55090472605,    57503.28239153120}, 
    {     0.00000000004,  0.52382972546,   154194.22245657316}, 
    {     0.00000000003,  4.57699005153,    21716.02677480000}, 
    {     0.00000000003,  4.03880524047,   104248.51979207818}, 
    {     0.00000000004,  0.75633347724,    79994.83177765518}, 
    {     0.00000000003,  0.94848153160,   143164.96914264598}, 
    {     0.00000000005,  4.29018004927,    53757.76563143139}, 
    {     0.00000000004,  2.29764966629,    51534.39272140940}, 
    {     0.00000000004,  3.74755373208,    25970.58327335399}, 
    {     0.00000000004,  1.22491945176,    25927.49577218939}, 
    {     0.00000000003,  0.19025922851,    50290.90511973100}, 
    {     0.00000000003,  0.82865789636,    30689.85326053720}, 
    {     0.00000000004,  2.93938009670,    30110.16567353840}, 
    {     0.00000000003,  2.37855052298,    25459.05155552409}, 
    {     0.00000000003,  5.61456633749,   156520.30530244438}, 
    {     0.00000000003,  0.54027108346,   130005.80396999417}, 
    {     0.00000000004,  6.15218047879,    76991.02839909539}, 
    {     0.00000000004,  3.50355655289,    33480.35754365900}, 
    {     0.00000000003,  0.01124368540,    78571.26704569219}, 
    {     0.00000000004,  1.42998120813,    23446.56186310200}, 
    {     0.00000000004,  4.30859600855,     2538.24850425360}, 
    {     0.00000000003,  4.07249909537,    32808.61712091560}, 
    {     0.00000000004,  4.57967744100,    52213.93931878620}, 
    {     0.00000000004,  2.71237687854,   107679.74822257696}, 
    {     0.00000000004,  2.10867686930,    27331.39074325260}, 
    {     0.00000000004,  2.63978309242,    80596.90581759460}, 
    {     0.00000000004,  1.44726666359,    25907.82601128960}, 
    {     0.00000000003,  2.77225709802,    25984.12095299360}, 
    {     0.00000000003,  0.77055249403,    23389.45169419700}, 
    {     0.00000000004,  2.22943193042,   104819.57755665119}, 
    {     0.00000000004,  5.53757642567,    52098.05573916449}, 
    {     0.00000000003,  4.85887200017,     1063.31408345230}, 
    {     0.00000000004,  5.50902935440,    51315.49635439559}, 
    {     0.00000000003,  6.10316637842,    48091.81777644400}, 
    {     0.00000000004,  4.67601599622,    18073.70493865020}, 
    {     0.00000000003,  4.58899296863,    25896.45487546260}, 
    {     0.00000000003,  5.35415033267,   233681.74972207438}, 
    {     0.00000000003,  2.07638324500,        3.93215326310}, 
    {     0.00000000003,  2.40851756173,    76998.14194609619}, 
    {     0.00000000003,  3.54974279869,    23401.18104703300}, 
    {     0.00000000003,  6.24455798435,    54824.26110862140}, 
    {     0.00000000003,  5.95091721147,     6751.04084034580}, 
    {     0.00000000003,  4.46119653187,   127098.90328117118}, 
    {     0.00000000004,  1.45335178532,     1073.60902419080}, 
    {     0.00000000004,  3.64332193223,      860.30992875280}, 
    {     0.00000000003,  5.19214304483,    52309.91533273340}, 
    {     0.00000000003,  3.87383641149,    56777.75640211140}, 
    {     0.00000000004,  1.93735592711,    26603.36701266720}, 
    {     0.00000000003,  2.94612910423,    27039.97976483379}, 
    {     0.00000000004,  2.04162116492,    27623.87988454360}, 
    {     0.00000000003,  1.90299644295,   126067.63934109679}, 
    {     0.00000000003,  5.46693649158,   149846.19399604558}, 
    {     0.00000000004,  3.72194883593,    51257.87599716660}, 
    {     0.00000000004,  5.84175823655,    25650.25925043430}, 
    {     0.00000000003,  2.84825042585,   159855.55450572536}, 
    {     0.00000000003,  5.38166577823,    26061.60482177439}, 
    {     0.00000000004,  4.82038901276,   391318.54712361297}, 
    {     0.00000000003,  0.24758758375,    28632.57577846660}, 
    {     0.00000000004,  3.73245535012,    29580.47470844380}, 
    {     0.00000000003,  5.50683793531,    25928.60140678200}, 
    {     0.00000000004,  1.30672083529,   128857.55635958798}, 
    {     0.00000000004,  2.91975490767,   104358.24112519680}, 
    {     0.00000000003,  4.20598772135,    52400.15107885030}, 
    {     0.00000000003,  2.10934687772,    60170.33472517260}, 
    {     0.00000000003,  3.58809373398,    28471.09615635040}, 
    {     0.00000000003,  3.28239195135,   208276.62694171758}, 
    {     0.00000000003,  2.85078808201,    27360.58416720139}, 
    {     0.00000000003,  2.17582056660,    27047.02600153180}, 
    {     0.00000000003,  1.50018330501,     4371.87636677420}, 
    {     0.00000000003,  0.91046516994,    76468.45098100159}, 
    {     0.00000000003,  5.28365186085,     2751.54759969160}, 
    {     0.00000000003,  0.87901414894,     1699.27921650320}, 
    {     0.00000000003,  1.88463694401,    27353.47062020059}, 
    {     0.00000000003,  5.30944897904,    51554.06248230919}, 
    {     0.00000000003,  1.34767282324,     1169.58825140860}, 
    {     0.00000000003,  1.02260378622,   193937.98608932378}, 
    {     0.00000000003,  0.08040381198,   104241.40624507738}, 
    {     0.00000000004,  0.92990491519,    23735.03698780239}, 
    {     0.00000000003,  0.94893744180,    25991.92391435639}, 
    {     0.00000000003,  0.22588113722,   203375.74902421077}, 
    {     0.00000000003,  4.57210118096,    34102.10134449819}, 
    {     0.00000000003,  1.72215842070,   170068.84005193636}, 
    {     0.00000000003,  0.81863700708,    78262.22495201428}, 
    {     0.00000000003,  3.80268685478,    25384.26995695679}, 
    {     0.00000000003,  2.04040938346,   176332.24614102798}, 
    {     0.00000000003,  1.84457498582,    45455.09230380700}, 
    {     0.00000000003,  0.65752082616,    35679.44488694599}, 
    {     0.00000000003,  5.96488404544,    52164.76058288449}, 
    {     0.00000000003,  5.22098781756,     3462.24470586520}, 
    {     0.00000000003,  2.07639441349,    24072.23205541439}, 
    {     0.00000000003,  4.15153931980,   128843.32926558638}, 
    {     0.00000000003,  4.53866780815,    28908.73428570040}, 
    {     0.00000000003,  6.18743354616,    50160.82461135059}, 
    {     0.00000000003,  4.26626022439,    67608.75720795698}, 
    {     0.00000000003,  4.07476395108,    33917.99567300899}, 
    {     0.00000000003,  4.19552535253,   149642.26895951436}, 
    {     0.00000000003,  1.00306343406,   155460.92337225519}, 
    {     0.00000000003,  1.95424623759,   104426.39416486409}, 
    {     0.00000000003,  1.43273740893,    24719.24288872919}, 
    {     0.00000000003,  4.35442914687,    38634.38508065720}, 
    {     0.00000000003,  4.64552041720,    54879.42243782400}, 
    {     0.00000000003,  4.16961765976,    76358.24465978218}, 
    {     0.00000000003,  5.81598121096,    49976.71893986139}, 
    {     0.00000000003,  4.34295741397,    16964.32638655680}, 
    {     0.00000000003,  2.53451860055,    51861.62010327879}, 
    {     0.00000000003,  2.49492450438,      636.99627202420}, 
    {     0.00000000003,  3.92173943640,   155475.15046625677}, 
    {     0.00000000003,  3.12145981611,   162810.49469943657}, 
    {     0.00000000002,  0.59129261912,    50951.98844236979}, 
    {     0.00000000003,  1.17681439145,    52145.47942214399}, 
    {     0.00000000003,  3.00732745961,    24705.01579472759}, 
    {     0.00000000002,  5.95257930202,    53399.62412392700}, 
    {     0.00000000003,  4.63479353604,   104874.18998439058}, 
    {     0.00000000003,  4.83384593430,   156523.53751408719}, 
    {     0.00000000002,  3.69719041336,    24616.15011451060}, 
    {     0.00000000003,  5.46916395598,    61921.12683900499}, 
    {     0.00000000003,  0.61188230666,   171292.65789271498}, 
    {     0.00000000003,  0.02228487735,        1.48447270830}, 
    {     0.00000000003,  0.17724758311,    24510.55959912640}, 
    {     0.00000000003,  4.95237759532,   102129.75593169978}, 
    {     0.00000000003,  5.99061509510,    29864.33402730900}, 
    {     0.00000000003,  3.93018711070,    17098.43543614181}, 
    {     0.00000000002,  4.21937046280,    10681.25053656540}, 
    {     0.00000000003,  0.28167729696,   169093.57054942798}, 
    {     0.00000000002,  3.49816744164,    51092.72605085480}, 
    {     0.00000000003,  0.52178350633,    52277.76880141400}, 
    {     0.00000000003,  4.05955850118,    97466.46267636596}, 
    {     0.00000000002,  5.23971659541,     1639.06951718800}, 
    {     0.00000000003,  3.80600862869,    25124.50043860279}, 
    {     0.00000000002,  0.12283639421,   149756.70824819959}, 
    {     0.00000000002,  0.58027608343,    27573.88326263939}, 
    {     0.00000000003,  3.08645332652,     4083.98850670440}, 
    {     0.00000000002,  0.63115841045,     1485.29070670320}, 
    {     0.00000000002,  0.17989490547,    78597.56536549199}, 
    {     0.00000000003,  4.97930287376,   180496.55813064099}, 
    {     0.00000000002,  0.84663844231,   163766.09444104518}, 
    {     0.00000000003,  2.12660879167,    42790.96527507320}, 
    {     0.00000000003,  5.24817307826,     6885.14988993081}, 
    {     0.00000000003,  3.26326592296,   156531.30018480319}, 
    {     0.00000000003,  4.84282671665,    49637.55777889479}, 
    {     0.00000000002,  3.66265576771,    26397.18146422999}, 
    {     0.00000000003,  4.15745762538,    51688.17153189420}, 
    {     0.00000000002,  4.40058588833,    31127.49138988719}, 
    {     0.00000000002,  4.51215350981,    52812.80255517260}, 
    {     0.00000000002,  1.85614154560,   104401.60918820098}, 
    {     0.00000000003,  0.24921211552,    25778.62481891839}, 
    {     0.00000000003,  6.05682256137,    48153.54375118419}, 
    {     0.00000000002,  4.09759047914,    24864.08530079559}, 
    {     0.00000000002,  4.27961723610,   220025.88923089796}, 
    {     0.00000000002,  5.31413874636,    75085.56363415498}, 
    {     0.00000000002,  4.40043538600,    25248.93385382380}, 
    {     0.00000000002,  5.50124846637,   106470.37642667518}, 
    {     0.00000000002,  1.36339547689,     6044.22858137540}, 
    {     0.00000000002,  5.61481903582,    28213.78054895339}, 
    {     0.00000000002,  1.71226573993,    76532.58707178998}, 
    {     0.00000000002,  1.47894403485,    78265.19389743089}, 
    {     0.00000000002,  2.81905656676,    63786.35824152260}, 
    {     0.00000000002,  2.66825602170,    53132.09543911899}, 
    {     0.00000000002,  3.58699104379,    24787.07632336920}, 
    {     0.00000000002,  6.10133380039,   104035.22069664019}, 
    {     0.00000000002,  3.23064508032,   130020.03106399579}, 
    {     0.00000000002,  1.11637372513,    76094.94894243999}, 
    {     0.00000000002,  5.24666183170,    24734.15439655740}, 
    {     0.00000000002,  3.73466434913,   199599.31813847595}, 
    {     0.00000000002,  5.76862263272,    25661.99436506020}, 
    {     0.00000000002,  4.46773900208,    26926.87242932459}, 
    {     0.00000000003,  5.47127542511,    27388.72995977919}, 
    {     0.00000000002,  2.48055036253,    25543.98508247800}, 
    {     0.00000000002,  0.28737768397,   174620.79354899516}, 
    {     0.00000000002,  3.23947010430,    42430.48572729180}, 
    {     0.00000000002,  1.90098213386,    20272.79228193720}, 
    {     0.00000000002,  4.30589300181,     2324.94940881560}, 
    {     0.00000000002,  1.33937343257,   196156.74319351057}, 
    {     0.00000000003,  0.24285063924,    23113.29318696320}, 
    {     0.00000000002,  0.20903760722,   177287.84588263658}, 
    {     0.00000000003,  4.48020724900,   156954.01704032118}, 
    {     0.00000000002,  0.58830784715,   156377.85565231058}, 
    {     0.00000000002,  2.17673056463,   133882.09065283638}, 
    {     0.00000000002,  2.97360848608,    26235.98186600050}, 
    {     0.00000000002,  2.39528557885,   104668.00443595338}, 
    {     0.00000000002,  1.98009462137,    50476.52706664519}, 
    {     0.00000000002,  3.79785772720,    65851.33653522459}, 
    {     0.00000000002,  5.14733332770,   289185.69166150296}, 
    {     0.00000000002,  3.15820059422,   207114.15223730978}, 
    {     0.00000000002,  0.99424509152,     2064.97829370200}, 
    {     0.00000000002,  3.96748008059,   225687.22128005016}, 
    {     0.00000000002,  1.75880221581,    22595.33157470459}, 
    {     0.00000000002,  0.35945480523,   104301.61594439259}, 
    {     0.00000000002,  4.50142650477,    21067.98465416099}, 
    {     0.00000000002,  4.06761017581,     1685.05212250160}, 
    {     0.00000000002,  4.80714121052,      440.82528487760}, 
    {     0.00000000002,  3.69573475242,     1574.84580128220}, 
    {     0.00000000002,  4.47164076488,    65538.25598994759}, 
    {     0.00000000002,  5.27720278071,    24998.19435038059}, 
    {     0.00000000002,  0.03956368481,    24189.55192363460}, 
    {     0.00000000002,  1.88701981019,    40738.70289615879}, 
    {     0.00000000003,  3.07558765849,   230239.17477710896}, 
    {     0.00000000002,  2.00682967230,    28786.35458895140}, 
    {     0.00000000002,  2.92175843057,    22065.64060961000}, 
    {     0.00000000002,  4.42508659344,    93696.66034953119}, 
    {     0.00000000002,  0.02297616821,   197092.67317421938}, 
    {     0.00000000002,  2.53282099987,   249268.47945736776}, 
    {     0.00000000002,  1.06567957268,    21562.24796431520}, 
    {     0.00000000002,  0.84740706727,    24494.89809302729}, 
    {     0.00000000002,  4.28261879219,   123554.36581794015}, 
    {     0.00000000002,  0.10971441902,    55484.27217852879}, 
    {     0.00000000002,  0.29345837800,    24765.22549404280}, 
    {     0.00000000002,  3.98649649262,    24808.10856894620}, 
    {     0.00000000002,  5.89087983305,   283524.35961235073}, 
    {     0.00000000002,  2.29200392607,    27410.58078910560}, 
    {     0.00000000002,  1.16567793728,    53551.58008299420}, 
    {     0.00000000002,  1.12952757353,    25572.43927048119}, 
    {     0.00000000002,  1.63321646369,    66826.60603773296}, 
    {     0.00000000002,  4.53722544295,    52355.88341343300}, 
    {     0.00000000002,  4.30854449363,    71378.55953479178}, 
    {     0.00000000002,  1.97399498955,      430.53034413910}, 
    {     0.00000000002,  1.99872081555,    24932.54198416719}, 
    {     0.00000000002,  4.55759105401,    49850.85687433279}, 
    {     0.00000000002,  0.37032643194,    26500.27423844859}, 
    {     0.00000000002,  3.83442901458,      307.55762096960}, 
    {     0.00000000002,  5.81356382743,    51538.81001112419}, 
    {     0.00000000002,  2.06311358499,    23233.26276766400}, 
    {     0.00000000002,  2.21513587213,    25675.53204469980}, 
    {     0.00000000002,  1.86537837885,     2703.61615467560}, 
    {     0.00000000002,  4.36625276614,    41520.85406638280}, 
    {     0.00000000002,  2.41635418383,    26713.57333388659}, 
    {     0.00000000002,  5.53696157861,    87253.17713015496}, 
    {     0.00000000002,  0.54252317353,        3.88133535800}, 
    {     0.00000000002,  4.25487079347,    90989.16285949759}, 
    {     0.00000000002,  4.42845015108,   158116.49174472898}, 
    {     0.00000000002,  2.30331517982,    27883.16158529519}, 
    {     0.00000000002,  2.98672680729,    57369.17334194619}, 
    {     0.00000000002,  6.08199781417,    18043.37807764579}, 
    {     0.00000000002,  0.73324052336,    25757.28417791599}, 
    {     0.00000000002,  6.16225556919,       49.99662190420}, 
    {     0.00000000002,  6.04230640954,    78115.63070029629}, 
    {     0.00000000002,  2.01671299774,    46564.47085590040}, 
    {     0.00000000002,  2.52858429504,    26140.99929388859}, 
    {     0.00000000002,  4.60594242656,    52336.21365253320}, 
    {     0.00000000002,  4.07531487160,    51734.98099827079}, 
    {     0.00000000002,  5.76630255453,    78373.91574594198}, 
    {     0.00000000002,  0.16910812024,    25462.23294926180}, 
    {     0.00000000002,  0.29867787782,   107692.22499299659}, 
    {     0.00000000002,  0.08977124652,    25135.82651831460}, 
    {     0.00000000002,  6.02059582335,   164721.69418265378}, 
    {     0.00000000002,  2.48908964809,    13705.85711308060}, 
    {     0.00000000002,  3.07002924674,    23432.33476910039}, 
    {     0.00000000002,  3.46681243572,   154408.65498906678}, 
    {     0.00000000002,  0.05687800902,    26034.80698925980}, 
    {     0.00000000002,  0.04904063753,   229463.65216578495}, 
    {     0.00000000002,  4.28354458896,    24484.60315228879}, 
    {     0.00000000002,  1.75454322097,    78697.42116259939}, 
    {     0.00000000002,  4.02876141227,    26238.95081141709}, 
    {     0.00000000002,  3.24222429199,    21509.65132471559}, 
    {     0.00000000002,  1.81543335689,    87648.55043279778}, 
    {     0.00000000002,  2.07300031744,    53654.67285721279}, 
    {     0.00000000002,  2.52315832958,   210614.42461581076}, 
    {     0.00000000002,  2.32677216347,    54862.52837768960}, 
    {     0.00000000002,  3.03967372772,   104771.09721017198}, 
    {     0.00000000002,  5.07022623770,    78112.66175487968}, 
    {     0.00000000002,  1.10376435729,    50912.64892057020}, 
    {     0.00000000002,  3.46489468484,    78905.12298646157}, 
    {     0.00000000002,  0.67835568542,   235746.72801577636}, 
    {     0.00000000002,  3.79260774499,     3308.46589538040}, 
    {     0.00000000002,  5.85661754245,     2974.60995461100}, 
    {     0.00000000002,  2.25512645553,    77929.85348395319}, 
    {     0.00000000002,  5.18613735503,    50600.96048186620}, 
    {     0.00000000002,  2.56189724502,    76064.62208143558}, 
    {     0.00000000002,  4.05996888958,    24502.76239955349}, 
    {     0.00000000002,  5.53877039970,    51040.12941125520}, 
    {     0.00000000002,  0.76026031493,     1802.37199072180}, 
    {     0.00000000002,  4.62411854151,   247223.17092456557}, 
    {     0.00000000002,  0.05336994875,   146505.58156934578}, 
    {     0.00000000002,  5.61214825198,    34082.43158359840}, 
    {     0.00000000001,  5.70524522839,    52072.02409456780}, 
    {     0.00000000001,  5.47105937931,    50690.51557644519}, 
    {     0.00000000002,  1.73035919617,    99979.73619952259}, 
    {     0.00000000002,  5.62955025847,    21819.80896338059}, 
    {     0.00000000001,  5.12943475162,    23704.71012679799}, 
    {     0.00000000001,  3.55982710637,   209658.82487420218}, 
    {     0.00000000002,  0.11249539090,    38469.94917006779}, 
    {     0.00000000002,  4.34823097600,   148532.89040742096}, 
    {     0.00000000002,  4.70382111310,    50490.75416064679}, 
    {     0.00000000001,  2.70277319349,    78249.48233072099}, 
    {     0.00000000002,  0.62470424533,    51745.27593900929}, 
    {     0.00000000002,  2.50077827630,   179966.86716554638}, 
    {     0.00000000001,  4.52201346507,    98575.84122845937}, 
    {     0.00000000002,  6.07032776125,    74935.57376844239}, 
    {     0.00000000001,  3.75122611900,    76352.50994150538}, 
    {     0.00000000002,  5.33836077527,   106684.80895916879}, 
    {     0.00000000001,  0.71806518278,    28928.40404660019}
};

 
   
static const struct ln_vsop mercury_radius_r1[RADIUS_R1] = {
    {     0.00217347740,  4.65617158665,    26087.90314157420}, 
    {     0.00044141826,  1.42385544001,    52175.80628314840}, 
    {     0.00010094479,  4.47466326327,    78263.70942472259}, 
    {     0.00002432805,  1.24226083323,   104351.61256629678}, 
    {     0.00001624367,  0.00000000000,        0.00000000000}, 
    {     0.00000603996,  4.29303116468,   130439.51570787099}, 
    {     0.00000152851,  1.06060778072,   156527.41884944518}, 
    {     0.00000039202,  4.11136733071,   182615.32199101939}, 
    {     0.00000017760,  4.54424729034,    27197.28169366760}, 
    {     0.00000017999,  4.71193597233,    24978.52458948080}, 
    {     0.00000010154,  0.87893540982,   208703.22513259358}, 
    {     0.00000008086,  3.00540629863,    25028.52121138500}, 
    {     0.00000004444,  2.13638817844,    20426.57109242200}, 
    {     0.00000004393,  1.48073536997,    51066.42773105500}, 
    {     0.00000003510,  3.21169312709,     1059.38193018920}, 
    {     0.00000003133,  5.23846816226,    21535.94964451540}, 
    {     0.00000002650,  3.92968869319,   234791.12827416777}, 
    {     0.00000002498,  2.02627371234,    24498.83024629040}, 
    {     0.00000002011,  1.23910805857,    53285.18483524180}, 
    {     0.00000001963,  4.04525058702,     5661.33204915220}, 
    {     0.00000001546,  2.61850768654,    26617.59410666880}, 
    {     0.00000001542,  2.35662446357,    27043.50288318280}, 
    {     0.00000001418,  1.37877634525,     1109.37855209340}, 
    {     0.00000001295,  5.19094994605,    46514.47423399620}, 
    {     0.00000001241,  0.21244114624,    11322.66409830440}, 
    {     0.00000001090,  6.23729220424,    27147.28507176339}, 
    {     0.00000001271,  0.56438178969,    25132.30339996560}, 
    {     0.00000001120,  0.86372582920,    57837.13833230060}, 
    {     0.00000001005,  3.28270573299,    37410.56723987860}, 
    {     0.00000001177,  4.53194587462,    77154.33087262919}, 
    {     0.00000000841,  5.96255043354,    14765.23904326980}, 
    {     0.00000000935,  2.37277293840,    25661.30495069820}, 
    {     0.00000000743,  0.77744171599,    32858.61374281979}, 
    {     0.00000000736,  4.06886325615,     1589.07289528380}, 
    {     0.00000000713,  2.70877599555,    16983.99614745660}, 
    {     0.00000000863,  5.55319075962,    25558.21217647960}, 
    {     0.00000000707,  0.92994379913,    30639.85663863300}, 
    {     0.00000000696,  0.69734609780,   260879.03141574195}, 
    {     0.00000000678,  2.02192026554,    26068.23338067440}, 
    {     0.00000000608,  0.85717026702,     4551.95349705880}, 
    {     0.00000000545,  5.38146993956,    26091.78447693220}, 
    {     0.00000000608,  3.65993695204,    25448.00585526019}, 
    {     0.00000000597,  4.64866860427,    26080.78959457339}, 
    {     0.00000000572,  3.50127448259,    10213.28554621100}, 
    {     0.00000000515,  4.83661700395,    50586.73338786459}, 
    {     0.00000000532,  5.21858845471,    22645.32819660879}, 
    {     0.00000000572,  0.62744603883,    13521.75144159140}, 
    {     0.00000000517,  3.89429240358,    83925.04147387479}, 
    {     0.00000000507,  5.55468086446,    12566.15169998280}, 
    {     0.00000000606,  4.50209900884,    28306.66024576099}, 
    {     0.00000000533,  0.93585445428,    26107.57290247399}, 
    {     0.00000000435,  5.79040236288,    43071.89928903080}, 
    {     0.00000000436,  5.86661030748,    25035.63475838580}, 
    {     0.00000000429,  0.26257002232,    36301.18868778519}, 
    {     0.00000000472,  6.00512006080,    77204.32749453338}, 
    {     0.00000000443,  3.86746180481,    26084.02180621620}, 
    {     0.00000000487,  4.23944310239,    26095.01668857500}, 
    {     0.00000000406,  5.60324675895,    52705.49724824299}, 
    {     0.00000000524,  0.06435802551,    25021.40766438420}, 
    {     0.00000000379,  1.95636892131,    72602.37737557039}, 
    {     0.00000000390,  3.81996113063,      426.59819087600}, 
    {     0.00000000418,  2.77521264952,    41962.52073693740}, 
    {     0.00000000453,  0.72806552601,      529.69096509460}, 
    {     0.00000000358,  6.00165773999,    33326.57873317420}, 
    {     0.00000000347,  1.39489736517,    23969.13928119580}, 
    {     0.00000000340,  0.24130963838,    26301.20223701220}, 
    {     0.00000000325,  4.78755454456,    23869.14603738740}, 
    {     0.00000000290,  3.04040767889,    53235.18821333759}, 
    {     0.00000000326,  1.30032135752,   103242.23401420339}, 
    {     0.00000000316,  2.22800622388,    19317.19254032860}, 
    {     0.00000000264,  3.93162118303,     6770.71060124560}, 
    {     0.00000000332,  3.59225598431,    51220.20654153979}, 
    {     0.00000000223,  2.76527165172,   103292.23063610759}, 
    {     0.00000000215,  3.98001918299,    56727.75978020720}, 
    {     0.00000000235,  2.24084854536,    25874.60404613620}, 
    {     0.00000000215,  6.16644528217,    51646.11531805379}, 
    {     0.00000000208,  2.74550745517,    40853.14218484400}, 
    {     0.00000000204,  3.44662595112,     9103.90699411760}, 
    {     0.00000000197,  0.80045639402,    27676.97603685800}, 
    {     0.00000000196,  1.99906300504,    48733.23133818299}, 
    {     0.00000000205,  3.20834398876,    18849.22754997420}, 
    {     0.00000000218,  2.11855599471,    73711.75592766379}, 
    {     0.00000000189,  0.65683523675,   110012.94461544899}, 
    {     0.00000000207,  5.89089887294,    31749.23519072640}, 
    {     0.00000000184,  3.74833520338,   286966.93455731616}, 
    {     0.00000000174,  5.81261322150,    68050.42387851159}, 
    {     0.00000000163,  4.00374821064,    79373.08797681599}, 
    {     0.00000000152,  5.07392487296,    52156.13652224860}, 
    {     0.00000000151,  2.83396005215,      955.59974160860}, 
    {     0.00000000151,  0.40937127334,    26514.50133245020}, 
    {     0.00000000147,  2.32188363628,    38654.05484155699}, 
    {     0.00000000154,  3.26432452388,    38519.94579197200}, 
    {     0.00000000185,  0.98990596875,    29530.47808653960}, 
    {     0.00000000150,  3.69227943541,    65697.55772473979}, 
    {     0.00000000132,  2.71821268672,    77734.01845962799}, 
    {     0.00000000140,  2.05758999121,     6283.07584999140}, 
    {     0.00000000122,  3.31360115889,    62389.09182935939}, 
    {     0.00000000123,  2.07940467790,    25668.41849769900}, 
    {     0.00000000118,  0.51915032422,    51535.90899683439}, 
    {     0.00000000120,  2.15439400962,    52179.68761850640}, 
    {     0.00000000152,  2.66001905502,    25654.19140369739}, 
    {     0.00000000113,  2.33266633795,    78793.40038981718}, 
    {     0.00000000124,  3.13057843195,    51109.31080595839}, 
    {     0.00000000150,  2.60372699526,      639.89728631400}, 
    {     0.00000000124,  2.65134648993,    51123.53789995999}, 
    {     0.00000000106,  1.31444088780,    47623.85278608960}, 
    {     0.00000000112,  5.00800079212,    98690.28051714458}, 
    {     0.00000000107,  5.12874134815,    99799.65906923798}, 
    {     0.00000000123,  6.13777841633,     1066.49547719000}, 
    {     0.00000000106,  1.42968371953,    52168.69273614759}, 
    {     0.00000000104,  4.51535298285,    25234.70675982219}, 
    {     0.00000000120,  4.06575468260,    45892.73043315699}, 
    {     0.00000000093,  4.72793717538,     2118.76386037840}, 
    {     0.00000000112,  4.78989437046,    53131.40602475700}, 
    {     0.00000000096,  5.03480533398,    32370.97899156560}, 
    {     0.00000000091,  4.22087947367,    50057.04242277000}, 
    {     0.00000000107,  0.14589408309,    12432.04265039780}, 
    {     0.00000000091,  4.35426331615,   129330.13715577759}, 
    {     0.00000000084,  0.32895187929,     1052.26838318840}, 
    {     0.00000000084,  5.81466213086,   129380.13377768178}, 
    {     0.00000000092,  0.34545636827,    77308.10968311399}, 
    {     0.00000000078,  1.17740935265,    76674.63652943878}, 
    {     0.00000000107,  1.01247025157,    52182.91983014920}, 
    {     0.00000000082,  6.11430864932,    79323.09135491178}, 
    {     0.00000000086,  2.50452244748,     7238.67559160000}, 
    {     0.00000000072,  1.56149801558,    49957.04917896160}, 
    {     0.00000000076,  1.62516369719,    15874.61759536320}, 
    {     0.00000000090,  5.75449025797,    24491.71669928959}, 
    {     0.00000000092,  3.97742380655,    52195.47604404819}, 
    {     0.00000000068,  0.44537901082,    91785.46086631398}, 
    {     0.00000000078,  0.63568556169,    52171.92494779040}, 
    {     0.00000000064,  2.57343416459,    94138.32702008578}, 
    {     0.00000000065,  2.12923498203,        7.11354700080}, 
    {     0.00000000062,  3.70758538046,   136100.84775702319}, 
    {     0.00000000068,  1.18992116627,    54394.56338733519}, 
    {     0.00000000079,  3.35587970544,    52389.10537858640}, 
    {     0.00000000060,  6.26094287016,    24505.94379329119}, 
    {     0.00000000065,  5.09697559988,    51962.50718771040}, 
    {     0.00000000061,  0.73863647120,    82815.66292178139}, 
    {     0.00000000063,  1.29903752227,     2218.75710418680}, 
    {     0.00000000070,  5.28679522332,    45405.09568190280}, 
    {     0.00000000054,  0.89790115044,    71980.63357473118}, 
    {     0.00000000057,  1.92411310638,    20760.42703319140}, 
    {     0.00000000051,  4.71610129635,   105460.99111839019}, 
    {     0.00000000054,  6.22074076941,    44937.13069154840}, 
    {     0.00000000052,  3.43154581427,    25551.09862947879}, 
    {     0.00000000052,  5.77926746609,    66941.04532641819}, 
    {     0.00000000048,  0.51820543805,   313054.83769889036}, 
    {     0.00000000052,  5.71872770622,   103821.92160120218}, 
    {     0.00000000047,  3.82177422106,    53764.87917843220}, 
    {     0.00000000050,  5.75583590982,    25938.33994443960}, 
    {     0.00000000047,  5.52776222700,    77837.11123384659}, 
    {     0.00000000043,  5.84980653694,    63498.47038145279}, 
    {     0.00000000052,  2.63480617664,    18093.37469954999}, 
    {     0.00000000042,  5.39170998784,    64741.95798313119}, 
    {     0.00000000041,  1.87436617947,   125887.56221081219}, 
    {     0.00000000045,  4.04573573351,    55618.38122811380}, 
    {     0.00000000039,  3.50885173288,    52602.40447402440}, 
    {     0.00000000051,  6.02412463531,    13655.86049117640}, 
    {     0.00000000048,  0.72398672501,    33967.99229491319}, 
    {     0.00000000038,  0.09228296016,    88476.99497093359}, 
    {     0.00000000038,  1.84192926335,    78244.03966382280}, 
    {     0.00000000041,  5.74762731223,    26727.80042788820}, 
    {     0.00000000045,  5.73856748504,    44181.27784112419}, 
    {     0.00000000038,  5.17731648720,    23754.70674870219}, 
    {     0.00000000035,  0.81850559713,    23439.44831610119}, 
    {     0.00000000036,  4.81776409496,    51116.42435295920}, 
    {     0.00000000041,  2.91924856282,    26241.68195205900}, 
    {     0.00000000032,  1.91980495251,    58458.88213313979}, 
    {     0.00000000033,  1.27537006504,   131548.89425996438}, 
    {     0.00000000031,  5.02484981561,    46848.33017476560}, 
    {     0.00000000030,  3.95195102074,    26555.86813192860}, 
    {     0.00000000031,  1.17956097833,    59414.48187474840}, 
    {     0.00000000030,  0.55660013087,     3442.57494496540}, 
    {     0.00000000033,  5.35914498696,   104881.30353139139}, 
    {     0.00000000034,  3.55545989401,      433.71173787680}, 
    {     0.00000000030,  1.25027037776,    26202.34243025941}, 
    {     0.00000000029,  2.98819043245,    27154.39861876420}, 
    {     0.00000000035,  3.23315937408,    25455.11940226100}, 
    {     0.00000000033,  3.55107682453,    25440.89230825939}, 
    {     0.00000000028,  4.36009500774,    80482.46652890938}, 
    {     0.00000000033,  1.77301132586,   124778.18365871879}, 
    {     0.00000000029,  0.03485368228,    79219.30916633119}, 
    {     0.00000000030,  5.14824322621,    51756.32163927320}, 
    {     0.00000000027,  2.59987755832,   155468.03691925599}, 
    {     0.00000000027,  1.05618361621,    28421.09953444620}, 
    {     0.00000000030,  5.72049964303,    51742.09454527159}, 
    {     0.00000000029,  5.20497301981,    78267.59076008058}, 
    {     0.00000000030,  6.10164768471,    26011.63707029860}, 
    {     0.00000000026,  1.11277156957,   155418.04029735178}, 
    {     0.00000000027,  3.38581716378,   103396.01282468818}, 
    {     0.00000000025,  3.48854332661,   117873.36400788819}, 
    {     0.00000000026,  6.19594686594,    77197.21394753258}, 
    {     0.00000000025,  1.70207039258,    25973.46385288896}, 
    {     0.00000000023,  1.48784027849,    28206.66700195260}, 
    {     0.00000000023,  3.86573027322,    16066.06586147480}, 
    {     0.00000000027,  4.06662296312,    78270.82297172339}, 
    {     0.00000000022,  4.03831631421,      419.48464387520}, 
    {     0.00000000023,  3.38647417024,    58946.51688439399}, 
    {     0.00000000022,  1.34032161201,    51322.60990139639}, 
    {     0.00000000023,  2.24016677563,   103925.01437542078}, 
    {     0.00000000024,  3.67307410546,    26610.48055966799}, 
    {     0.00000000021,  4.49579658422,    78256.59587772179}, 
    {     0.00000000021,  3.69230315983,    77623.81213840858}, 
    {     0.00000000028,  5.71579741424,    77211.44104153418}, 
    {     0.00000000020,  3.97824189549,    98068.53671630539}, 
    {     0.00000000020,  5.61186204564,   120226.23016165999}, 
    {     0.00000000024,  1.72755836618,      853.19638175200}, 
    {     0.00000000020,  6.15795630851,      213.29909543800}, 
    {     0.00000000024,  2.89550770232,   105410.99449648599}, 
    {     0.00000000021,  0.42057491496,      149.56319713460}, 
    {     0.00000000020,  4.41593605146,    29416.03879785439}, 
    {     0.00000000024,  2.43647861768,    50579.61984086379}, 
    {     0.00000000020,  0.62149243389,    85034.42002596818}, 
    {     0.00000000021,  0.18471197727,    35191.81013569180}, 
    {     0.00000000020,  0.48534032212,   162188.75089859738}, 
    {     0.00000000019,  2.39134899200,    26037.90651966999}, 
    {     0.00000000018,  4.60102058427,    76044.95232053580}, 
    {     0.00000000018,  3.06506502101,    50593.84693486539}, 
    {     0.00000000022,  0.44685187346,     1596.18644228460}, 
    {     0.00000000019,  3.59043449510,    27140.17152476259}, 
    {     0.00000000019,  1.77495862092,    78050.41032928458}, 
    {     0.00000000021,  0.16420917914,    78477.00852016058}, 
    {     0.00000000021,  3.45801523273,   102762.53967101299}, 
    {     0.00000000018,  1.82673294922,    25565.32572348040}, 
    {     0.00000000022,  4.62812554933,    19406.67828817460}, 
    {     0.00000000019,  5.28521008361,    26624.70765366959}, 
    {     0.00000000019,  2.69563356202,   105307.21230790539}, 
    {     0.00000000016,  4.38108594875,    25131.61398560359}, 
    {     0.00000000018,  4.12920214042,     5327.47610838280}, 
    {     0.00000000018,  1.12132022143,    76144.94556434419}, 
    {     0.00000000015,  0.52310488443,    42153.96900304900}, 
    {     0.00000000018,  2.04183547601,    71492.99882347698}, 
    {     0.00000000018,  0.72265923388,    78283.37918562238}, 
    {     0.00000000020,  3.87063422695,    51749.20809227239}, 
    {     0.00000000014,  0.06668257964,    25984.81036735560}, 
    {     0.00000000018,  3.79515954928,   108903.56606335558}, 
    {     0.00000000014,  4.25123740486,   157636.79740153858}, 
    {     0.00000000014,  2.30100270598,    18207.81398823521}, 
    {     0.00000000019,  2.52491398171,   129909.82474277639}, 
    {     0.00000000013,  4.91446105451,   151975.46535238638}, 
    {     0.00000000014,  3.82631305037,     7880.08915333899}, 
    {     0.00000000015,  1.42348252663,    40565.25432477420}, 
    {     0.00000000014,  0.49847426695,    26137.89976347840}, 
    {     0.00000000016,  1.93614457319,    49842.60989027639}, 
    {     0.00000000014,  1.68315486020,     6681.22485339960}, 
    {     0.00000000016,  2.97339589661,    71025.03383312259}, 
    {     0.00000000013,  0.09179476261,       76.26607127560}, 
    {     0.00000000013,  2.18789083340,    90829.86112470538}, 
    {     0.00000000012,  2.17529291977,    29428.51556827400}, 
    {     0.00000000013,  0.55788178178,    79852.78232000639}, 
    {     0.00000000016,  3.67857856689,    78259.82808936459}, 
    {     0.00000000013,  3.16115557204,    25881.71759313700}, 
    {     0.00000000012,  3.49193422292,    64607.84893354619}, 
    {     0.00000000012,  0.81761525395,    81706.28436968799}, 
    {     0.00000000012,  0.31632203314,    78690.30761559859}, 
    {     0.00000000012,  2.09762480906,    24609.03656750980}, 
    {     0.00000000015,  2.58203356183,    93028.94846799239}, 
    {     0.00000000012,  3.14266169479,   114564.89811250778}, 
    {     0.00000000013,  3.56100116701,   339142.74084046457}, 
    {     0.00000000011,  0.04545445248,    19804.82729158280}, 
    {     0.00000000011,  4.95969052565,    84546.78527471398}, 
    {     0.00000000011,  2.38972392013,    10021.83728009940}, 
    {     0.00000000011,  3.22945823005,    90695.75207512038}, 
    {     0.00000000012,  0.71734482256,    26294.08869001139}, 
    {     0.00000000010,  2.92861070824,      536.80451209540}, 
    {     0.00000000011,  1.78852128558,    69159.80243060499}, 
    {     0.00000000010,  1.89783740289,    24925.42843716640}, 
    {     0.00000000011,  3.48412644818,     7994.52844202420}, 
    {     0.00000000012,  0.12617932392,    51543.02254383520}, 
    {     0.00000000010,  3.60589886808,    49527.35145767539}, 
    {     0.00000000012,  6.27492199816,     1581.95934828300}, 
    {     0.00000000012,  6.05888678029,    52329.58509363319}, 
    {     0.00000000009,  5.35262821933,     2648.45482547300}, 
    {     0.00000000011,  1.66471845038,    26507.38778544939}, 
    {     0.00000000010,  2.53893582711,    52815.70356946240}, 
    {     0.00000000009,  5.25424591978,   130012.91751699499}, 
    {     0.00000000010,  5.63677389632,   181555.94006083018}, 
    {     0.00000000011,  4.93443540854,   104331.94280539699}, 
    {     0.00000000009,  0.35849773025,    26521.61487945100}, 
    {     0.00000000010,  2.79816937867,    39743.76363275060}, 
    {     0.00000000009,  0.71220225370,    25764.39772491679}, 
    {     0.00000000010,  1.17340335585,    25934.12433108940}, 
    {     0.00000000009,  3.20002719704,    39629.32434406539}, 
    {     0.00000000008,  4.19761308993,   181505.94343892598}, 
    {     0.00000000010,  2.48682113937,   103299.34418310839}, 
    {     0.00000000011,  0.22893201377,    51639.00177105299}, 
    {     0.00000000008,  0.16348041588,   129483.91596626239}, 
    {     0.00000000009,  0.30337489561,    27999.10262479140}, 
    {     0.00000000009,  3.99498377108,      522.57741809380}, 
    {     0.00000000008,  2.54138408889,    26190.99591579279}, 
    {     0.00000000011,  5.95249130311,    38813.35657634920}, 
    {     0.00000000008,  3.31854576667,    24395.73747207180}, 
    {     0.00000000008,  4.64662384390,    26094.53170047421}, 
    {     0.00000000011,  4.84765242606,   150866.08680029298}, 
    {     0.00000000008,  5.11571024014,    25619.93815121980}, 
    {     0.00000000008,  0.71596259507,    52643.77127350280}, 
    {     0.00000000008,  1.19651473439,    25867.49049913539}, 
    {     0.00000000008,  0.31282225043,    51528.79544983359}, 
    {     0.00000000008,  5.89654379780,    23976.25282819660}, 
    {     0.00000000010,  2.11360383925,   130969.20667296558}, 
    {     0.00000000008,  4.88364028664,    22759.76748529401}, 
    {     0.00000000007,  0.23623382371,   143961.26714946238}, 
    {     0.00000000007,  0.85604718929,   104358.72611329758}, 
    {     0.00000000009,  3.29913653682,    12725.45343477500}, 
    {     0.00000000007,  3.46214563345,    26237.46633870879}, 
    {     0.00000000007,  6.03210574641,    53242.30176033840}, 
    {     0.00000000007,  2.37810032854,   146314.13330323418}, 
    {     0.00000000007,  3.13316977597,      632.78373931320}, 
    {     0.00000000007,  2.54301544837,    77829.99768684579}, 
    {     0.00000000007,  0.73956927174,   124156.43985787958}, 
    {     0.00000000007,  3.70026494730,    85502.38501632259}, 
    {     0.00000000007,  5.62145437858,   131395.11544947959}, 
    {     0.00000000008,  1.94555311267,    77844.22478084739}, 
    {     0.00000000007,  5.14149225737,    35472.74414964940}, 
    {     0.00000000008,  3.48926584442,    25863.55834587229}, 
    {     0.00000000008,  1.49877323045,    26081.27458267419}, 
    {     0.00000000008,  5.18714163199,    23962.02573419499}, 
    {     0.00000000009,  2.01436615102,   104355.49390165479}, 
    {     0.00000000006,  3.29980048581,   104564.91166173479}, 
    {     0.00000000007,  2.03785266970,   100909.03762133139}, 
    {     0.00000000007,  0.57886086091,    86143.79857806159}, 
    {     0.00000000006,  5.26631894455,    50696.93970908399}, 
    {     0.00000000006,  4.15417610256,    54509.00267602040}, 
    {     0.00000000006,  4.43201408602,    54294.57014352679}, 
    {     0.00000000007,  4.34076115792,    52290.24557183361}, 
    {     0.00000000006,  3.56561263718,    27684.08958385880}, 
    {     0.00000000008,  5.96307679067,   131498.89763806018}, 
    {     0.00000000006,  0.71203388696,    89586.37352302698}, 
    {     0.00000000007,  4.87238413087,    26941.09952332620}, 
    {     0.00000000007,  3.86685146587,    34282.17847478280}, 
    {     0.00000000006,  5.78409267205,    70269.18098269838}, 
    {     0.00000000006,  1.41633910671,   102132.85546210999}, 
    {     0.00000000007,  3.58295941315,   188276.65404017158}, 
    {     0.00000000006,  4.72373191376,   104138.31347085879}, 
    {     0.00000000006,  4.58647990894,    25977.69682035479}, 
    {     0.00000000006,  5.13295981391,    97580.90196505119}, 
    {     0.00000000007,  6.19371116461,   128850.44281258718}, 
    {     0.00000000007,  2.66802033812,      647.01083331480}, 
    {     0.00000000005,  0.04375887104,    13541.42120249119}, 
    {     0.00000000006,  0.33123091213,    26308.31578401300}, 
    {     0.00000000005,  5.56381967808,    96357.08412427259}, 
    {     0.00000000005,  4.80464589535,    51013.33157874059}, 
    {     0.00000000006,  5.53758966617,   155997.72788435058}, 
    {     0.00000000005,  5.60807429033,    76667.52298243798}, 
    {     0.00000000006,  4.28669891744,    14477.35118320000}, 
    {     0.00000000005,  3.19580206930,    26164.16921284980}, 
    {     0.00000000005,  2.77179581202,      224.34479570190}, 
    {     0.00000000005,  5.49690701497,    52125.80966124419}, 
    {     0.00000000006,  3.04296474364,    13362.44970679920}, 
    {     0.00000000006,  1.12902280478,    27311.72098235281}, 
    {     0.00000000005,  3.67139738592,    25241.82030682300}, 
    {     0.00000000005,  3.09230254875,   115674.27666460119}, 
    {     0.00000000005,  4.44854763906,    25227.59321282139}, 
    {     0.00000000005,  6.11660618145,    76681.75007643958}, 
    {     0.00000000005,  4.08211677301,   209812.60368468695}, 
    {     0.00000000005,  1.73089458865,      956.28915597060}, 
    {     0.00000000005,  5.66811291485,    45290.65639321759}, 
    {     0.00000000005,  3.13493063609,   103285.11708910679}, 
    {     0.00000000006,  0.68903019707,    26720.68688088739}, 
    {     0.00000000005,  1.38851632143,   104344.49901929598}, 
    {     0.00000000005,  4.91303143516,    52061.36699446317}, 
    {     0.00000000005,  1.74146694456,   178063.36849396059}, 
    {     0.00000000006,  0.57541579782,   134991.46920492979}, 
    {     0.00000000005,  2.68983687693,    50064.15596977079}, 
    {     0.00000000004,  1.00808694646,   183724.70054311278}, 
    {     0.00000000006,  3.71607717230,    26162.68474014150}, 
    {     0.00000000004,  0.62283626032,    22747.29071487440}, 
    {     0.00000000004,  4.50456714341,    77410.51304297059}, 
    {     0.00000000005,  1.56490281477,    11610.55195837420}, 
    {     0.00000000005,  4.32652438787,    32132.13172294960}, 
    {     0.00000000004,  1.00639601102,    51219.51712717779}, 
    {     0.00000000004,  1.51036812292,    66653.15746634839}, 
    {     0.00000000004,  0.36128713063,    48835.19385644859}, 
    {     0.00000000004,  0.41686657221,    52698.38370124219}, 
    {     0.00000000005,  0.98141094776,    71582.48457132299}, 
    {     0.00000000005,  3.11319066063,    61279.71327726600}, 
    {     0.00000000005,  2.13218330001,    39609.65458316560}, 
    {     0.00000000004,  1.96389435563,    52712.61079524379}, 
    {     0.00000000004,  5.99354847872,   121335.60871375339}, 
    {     0.00000000004,  5.78126086314,    26734.91397488900}, 
    {     0.00000000004,  2.73212882510,     1692.16566950240}, 
    {     0.00000000004,  3.01852709067,    52072.71350892979}, 
    {     0.00000000005,  5.66771377195,   119116.85160956658}, 
    {     0.00000000005,  0.77258282125,   103711.71527998279}, 
    {     0.00000000005,  6.04945174043,    97112.93697469679}, 
    {     0.00000000004,  0.36575665885,    31415.37924995700}, 
    {     0.00000000005,  5.02731895212,    51653.22886505459}, 
    {     0.00000000004,  3.93621649933,   104371.28232719658}, 
    {     0.00000000004,  5.41284039165,    72936.23331633979}, 
    {     0.00000000004,  2.92377236341,    78417.48823520739}, 
    {     0.00000000004,  3.51647396311,    74821.13447975718}, 
    {     0.00000000004,  4.54421819395,    26198.10946279360}, 
    {     0.00000000004,  0.88403223565,    60055.89543648739}, 
    {     0.00000000003,  2.66890053344,    24176.70365835700}, 
    {     0.00000000004,  5.69108860339,    25138.72753260440}, 
    {     0.00000000003,  3.87783398339,   107794.18751126219}, 
    {     0.00000000003,  5.41502481469,    44295.71712980940}, 
    {     0.00000000004,  6.15603833593,   140652.80125408198}, 
    {     0.00000000003,  2.04324855763,   156100.82065856918}, 
    {     0.00000000003,  1.43970050784,   130226.21661243298}, 
    {     0.00000000004,  4.42783340987,    32769.12799497380}, 
    {     0.00000000004,  1.81467845339,    50049.92887576919}, 
    {     0.00000000003,  0.63347622471,   104347.73123093879}, 
    {     0.00000000003,  3.32438215067,   170049.17029103659}, 
    {     0.00000000003,  0.67090491468,    26222.01219115920}, 
    {     0.00000000004,  1.76229044896,   110634.68841628819}, 
    {     0.00000000003,  5.53149982046,    52101.02468458109}, 
    {     0.00000000004,  4.50620915113,    52169.17772424839}, 
    {     0.00000000004,  3.56885504720,   105940.68546158058}, 
    {     0.00000000004,  0.21580922543,   214364.55718174578}, 
    {     0.00000000003,  3.38684695593,    77616.69859140778}, 
    {     0.00000000004,  2.17281001389,   182085.63102592478}, 
    {     0.00000000003,  2.92184086259,    78187.44335344699}, 
    {     0.00000000003,  3.62367878110,   102232.84870591838}, 
    {     0.00000000003,  6.16140322421,    12546.48193908300}, 
    {     0.00000000004,  0.33659131492,    53228.07466633679}, 
    {     0.00000000004,  0.86535240325,    24822.33566294780}, 
    {     0.00000000003,  3.54130574747,    28791.51929624980}, 
    {     0.00000000003,  5.53380981999,      323.50541665740}, 
    {     0.00000000003,  0.55130340136,     1911.19948321720}, 
    {     0.00000000003,  0.87110894776,   207593.84658050018}, 
    {     0.00000000003,  5.53793227956,   129387.24732468258}, 
    {     0.00000000004,  1.48944067730,   176953.98994186718}, 
    {     0.00000000003,  1.39556385937,      110.20632121940}, 
    {     0.00000000003,  3.73684881528,    68241.87214462319}, 
    {     0.00000000003,  5.18504918985,    17893.62780836560}, 
    {     0.00000000003,  5.78973675301,    27780.06881107659}, 
    {     0.00000000003,  1.34609552040,    52182.43484204840}, 
    {     0.00000000004,  0.33642454097,   365230.64398203876}, 
    {     0.00000000003,  3.31724366253,   104778.21075717278}, 
    {     0.00000000003,  0.35623812687,    75615.25459924959}, 
    {     0.00000000003,  5.28343621642,   183570.92173262799}, 
    {     0.00000000003,  0.96990585284,    25780.34552060460}, 
    {     0.00000000003,  5.33125415195,   172402.03644480839}, 
    {     0.00000000003,  0.56049277948,    52250.58788171570}, 
    {     0.00000000003,  4.87139349011,    27044.19229754480}, 
    {     0.00000000004,  5.37885673963,    52022.02747266360}, 
    {     0.00000000003,  2.98512848612,   102769.65321801379}, 
    {     0.00000000003,  3.02425841901,    74923.09699802278}, 
    {     0.00000000003,  0.49237630844,    35077.37084700659}, 
    {     0.00000000003,  3.10202105417,   155571.81910783658}, 
    {     0.00000000003,  2.40265630063,   207643.84320240439}, 
    {     0.00000000003,  5.24629397059,    55516.41870984820}, 
    {     0.00000000003,  1.46721236412,    77101.23472031478}, 
    {     0.00000000003,  2.66397867066,   157586.80077963437}, 
    {     0.00000000003,  0.67298226082,   112231.70171963578}, 
    {     0.00000000003,  4.99605169070,   103932.12792242158}, 
    {     0.00000000003,  4.10691179553,     1478.86657406440}, 
    {     0.00000000003,  6.27831375933,     3340.61242669980}, 
    {     0.00000000003,  4.70793427922,    52595.29092702359}, 
    {     0.00000000003,  3.30698355673,   111122.32316754239}, 
    {     0.00000000003,  3.59410472234,   161079.37234650398}, 
    {     0.00000000003,  1.08598465210,     2125.87740737920}, 
    {     0.00000000003,  2.86835872465,    79330.20490191258}, 
    {     0.00000000003,  0.03528312928,   130652.81480330898}, 
    {     0.00000000003,  4.91342309115,   130443.39704322898}, 
    {     0.00000000003,  3.81834920265,   130446.62925487179}, 
    {     0.00000000003,  5.36562496748,    36109.74042167360}, 
    {     0.00000000003,  4.08661000212,    97670.38771289718}, 
    {     0.00000000003,  3.26620026556,    27669.86248985719}, 
    {     0.00000000003,  3.18918832992,    64901.25971792339}, 
    {     0.00000000003,  5.81508759911,    65831.66677432480}, 
    {     0.00000000003,  5.12438368628,   225687.22128005016}, 
    {     0.00000000003,  5.22842077296,   116917.76426627958}, 
    {     0.00000000003,  4.34062442450,   128220.75860368418}, 
    {     0.00000000003,  6.07858503745,    26724.89941359840}, 
    {     0.00000000002,  5.50809745225,    78903.60671103658}, 
    {     0.00000000003,  4.22986268574,    53399.62412392700}, 
    {     0.00000000002,  3.93729718963,    25352.02662804239}, 
    {     0.00000000003,  4.09989052992,    25446.48957983520}, 
    {     0.00000000002,  1.09392137734,    24998.19435038059}, 
    {     0.00000000002,  3.68762047589,   150244.34299945379}, 
    {     0.00000000003,  3.19241041107,    77630.92568540938}, 
    {     0.00000000003,  6.21988692602,    51969.62073471119}, 
    {     0.00000000003,  1.11955202845,    80382.47328510099}, 
    {     0.00000000002,  2.12662656444,    28736.35796704720}, 
    {     0.00000000003,  2.04127296360,    76784.84285065818}, 
    {     0.00000000002,  5.87891896219,   104505.39137678158}, 
    {     0.00000000003,  1.71543070116,   130419.84594697120}, 
    {     0.00000000002,  2.72423428668,    23866.04650697719}, 
    {     0.00000000003,  4.73772050139,   204151.27163553478}, 
    {     0.00000000002,  1.63035800038,      206.18554843720}, 
    {     0.00000000002,  0.28516429317,    52325.36948028299}, 
    {     0.00000000003,  1.04046826719,    78378.14871340781}, 
    {     0.00000000002,  5.57938361325,    24292.64469785319}, 
    {     0.00000000002,  1.79521955728,   123668.80510662538}, 
    {     0.00000000003,  5.45838796650,      220.41264243880}, 
    {     0.00000000003,  4.42874475531,    51955.39364070959}, 
    {     0.00000000002,  2.17330948821,   157483.01859105378}, 
    {     0.00000000002,  4.42013828428,    78270.33798362259}, 
    {     0.00000000002,  1.95807177582,   102018.41617342478}, 
    {     0.00000000003,  0.90312079140,    80596.90581759460}, 
    {     0.00000000003,  0.79264995950,    87253.17713015496}, 
    {     0.00000000002,  0.27619168326,   111590.28815789679}, 
    {     0.00000000002,  6.07933917378,    39450.35284837340}, 
    {     0.00000000002,  3.76044810773,    78731.67441507700}, 
    {     0.00000000002,  2.15358480656,    78213.71280281838}, 
    {     0.00000000003,  2.99177358632,   102755.42612401219}, 
    {     0.00000000002,  4.21598945690,    81591.84508100279}, 
    {     0.00000000003,  2.32279667601,   145204.75475114079}, 
    {     0.00000000002,  0.25549281668,    22909.75735100660}, 
    {     0.00000000002,  6.14643883768,   141762.17980617538}, 
    {     0.00000000002,  4.52361884313,    20043.67456019880}, 
    {     0.00000000003,  1.75443444354,    77741.13200662879}, 
    {     0.00000000003,  5.20551476382,    26709.64694241340}, 
    {     0.00000000003,  5.08171722545,   157057.10981453978}, 
    {     0.00000000002,  5.52481194670,   104202.04936916218}, 
    {     0.00000000002,  0.47870092643,     2111.65031337760}, 
    {     0.00000000002,  2.47915773617,    78114.14622758799}, 
    {     0.00000000003,  2.27153901784,    25953.79409198919}, 
    {     0.00000000002,  3.82824341716,     1162.47470440780}, 
    {     0.00000000002,  0.51034872663,   133882.09065283638}, 
    {     0.00000000002,  3.73613869026,    24601.92302050899}, 
    {     0.00000000003,  3.59795425725,    52396.21892558720}, 
    {     0.00000000002,  5.13033023401,    26823.77965510599}, 
    {     0.00000000002,  4.43860191568,    25450.90686955000}, 
    {     0.00000000002,  5.79358770849,   181026.24909573558}, 
    {     0.00000000002,  2.21653310659,    26402.08932144380}, 
    {     0.00000000002,  4.78156121936,    51859.41441349179}, 
    {     0.00000000002,  2.34758825112,    78109.93061423779}, 
    {     0.00000000002,  3.31605319473,    52609.51802102519}, 
    {     0.00000000002,  3.95441673698,    52808.59002246159}, 
    {     0.00000000002,  2.72617137486,   123200.84011627098}, 
    {     0.00000000002,  3.78539987320,    52381.99183158559}, 
    {     0.00000000002,  1.51043652717,    78149.27013603736}, 
    {     0.00000000002,  2.79844678677,   167850.08294774959}, 
    {     0.00000000002,  1.04172617563,    52492.19815280499}, 
    {     0.00000000003,  2.56160742762,   154938.34595416138}, 
    {     0.00000000002,  4.64184952554,    60370.08161635699}, 
    {     0.00000000002,  1.36020518792,     3328.13565628019}, 
    {     0.00000000002,  1.24306133807,    58857.03113654799}, 
    {     0.00000000002,  0.61134558822,   128320.75184749259}, 
    {     0.00000000002,  3.66766587868,    51852.30086649099}, 
    {     0.00000000003,  3.60643045560,    52225.80290505260}, 
    {     0.00000000002,  3.83820356329,    16703.06213349900}, 
    {     0.00000000002,  6.27055581751,   130866.11389874699}, 
    {     0.00000000002,  1.60943083243,    53029.00266490040}, 
    {     0.00000000002,  0.74910000830,    26667.59072857300}, 
    {     0.00000000002,  1.22999905791,   103498.41618454478}, 
    {     0.00000000002,  6.15892249504,    52252.07235442399}, 
    {     0.00000000002,  5.23865884724,    26729.31670331319}, 
    {     0.00000000002,  5.92374472867,    78160.61665050399}, 
    {     0.00000000002,  5.69052913085,   189853.99758261938}, 
    {     0.00000000002,  3.69732655609,    52309.91533273340}, 
    {     0.00000000002,  4.01638193690,    51868.24866217880}, 
    {     0.00000000002,  5.60946469584,   103917.90082841998}, 
    {     0.00000000002,  2.05507054538,    70383.62027138360}, 
    {     0.00000000002,  6.01217703537,    94329.77528619739}, 
    {     0.00000000002,  2.32199957299,    51226.63067417859}, 
    {     0.00000000002,  2.67908261522,   173511.41499690177}, 
    {     0.00000000002,  3.62032090461,     6885.14988993081}, 
    {     0.00000000002,  1.58668212347,    26013.12154300690}, 
    {     0.00000000002,  1.81879125394,    27177.61193276780}, 
    {     0.00000000002,  1.81202528574,    25771.51127191760}, 
    {     0.00000000002,  6.06186683896,   129373.02023068098}, 
    {     0.00000000002,  5.38601913539,   151199.94274106238}, 
    {     0.00000000002,  0.20113172923,    25754.04720080480}, 
    {     0.00000000002,  5.96231230667,    23919.14265929160}, 
    {     0.00000000002,  5.44340217714,    95247.70557217918}, 
    {     0.00000000002,  1.68782102934,    27250.37784598199}, 
    {     0.00000000002,  4.33776532179,    26404.29501123080}, 
    {     0.00000000002,  1.10098144775,     1223.81784077861}, 
    {     0.00000000002,  2.87118340279,   137678.19129947099}, 
    {     0.00000000002,  1.73319857606,    92741.06060792258}, 
    {     0.00000000002,  3.72580494980,    34082.43158359840}, 
    {     0.00000000002,  5.77505044086,    25600.26839032000}, 
    {     0.00000000002,  0.26892495924,    53771.99272543299}, 
    {     0.00000000002,  3.97982464503,   129799.61842155698}, 
    {     0.00000000002,  0.60185817387,       74.78159856730}, 
    {     0.00000000002,  3.37711958412,     2221.85663459700}, 
    {     0.00000000002,  3.37390513588,    26575.53789282839}, 
    {     0.00000000002,  2.81094355112,   118828.96374949679}, 
    {     0.00000000002,  5.68640078492,    50264.60679993120}, 
    {     0.00000000002,  4.37218185067,     8194.27533320860}, 
    {     0.00000000002,  6.09074384651,     2333.19639287200}, 
    {     0.00000000002,  5.21226121395,    52278.89905736699}, 
    {     0.00000000002,  0.47057494510,    25773.71696170459}, 
    {     0.00000000002,  1.23732034066,    78257.08086582259}, 
    {     0.00000000002,  4.51390388591,    37698.45509994840}, 
    {     0.00000000002,  3.29240007524,    77726.90491262719}, 
    {     0.00000000002,  5.79437105261,    26312.24793727610}, 
    {     0.00000000002,  1.11912985777,    51315.49635439559}, 
    {     0.00000000002,  2.50406010238,    19202.75325164339}, 
    {     0.00000000002,  1.61719066741,    24079.34560241519}, 
    {     0.00000000002,  5.00820642202,   182188.72380014337}, 
    {     0.00000000002,  3.08979268503,   195047.36464141717}, 
    {     0.00000000002,  2.19163720361,    26395.46076254379}, 
    {     0.00000000002,  1.93268238025,    26189.86565983980}, 
    {     0.00000000001,  1.95651508860,    26073.67604757259}, 
    {     0.00000000002,  1.69360766883,    48847.67062686820}, 
    {     0.00000000002,  4.77850859259,   136722.59155786238}, 
    {     0.00000000002,  1.23109092649,    52286.01260436779}, 
    {     0.00000000002,  1.92969421017,   143005.66740785378}, 
    {     0.00000000002,  5.31894725019,    23384.28698689860}, 
    {     0.00000000002,  4.01601058100,   189386.03259226495}, 
    {     0.00000000002,  4.13493316476,    25466.15934073500}, 
    {     0.00000000002,  4.58005710714,    25004.82290928060}, 
    {     0.00000000001,  4.50232888505,   101703.15774082378}, 
    {     0.00000000002,  1.99945872949,    17098.43543614181}, 
    {     0.00000000001,  5.86202636151,   163766.09444104518}, 
    {     0.00000000002,  4.42951918443,   132658.27281205778}, 
    {     0.00000000002,  4.91675947523,    24448.83362438620}, 
    {     0.00000000002,  2.35593686283,   147423.51185532758}, 
    {     0.00000000002,  4.35624857900,   130432.40216087017}, 
    {     0.00000000001,  4.98789585706,    78800.51393681798}, 
    {     0.00000000001,  1.09794599902,    55503.94193942859}, 
    {     0.00000000002,  1.80354488061,      860.30992875280}, 
    {     0.00000000002,  2.50676380667,    61560.64729122359}, 
    {     0.00000000002,  0.29051427089,    24356.78078864160}, 
    {     0.00000000002,  6.11873017537,    87367.61641884019}, 
    {     0.00000000001,  1.32811901694,   154194.22245657316}, 
    {     0.00000000002,  1.30375159885,   144916.86689107098}, 
    {     0.00000000001,  3.51165251141,    26421.75908234360}, 
    {     0.00000000001,  5.54890134424,   220025.88923089796}, 
    {     0.00000000001,  4.52193457212,    27170.98337386779}, 
    {     0.00000000002,  2.16673373766,      103.09277421860}, 
    {     0.00000000001,  2.97156317234,      846.08283475120}, 
    {     0.00000000001,  3.56056299689,    78786.28684281638}, 
    {     0.00000000001,  1.72265685452,    25508.21555457540}, 
    {     0.00000000002,  1.14700860003,    61165.27398858079}, 
    {     0.00000000002,  5.40448093264,     1265.56747862640}, 
    {     0.00000000002,  0.63660432851,    52065.59996192899}, 
    {     0.00000000001,  5.30775305827,    22625.65843570900}, 
    {     0.00000000002,  2.87848636951,   166740.70439565618}, 
    {     0.00000000002,  1.64559155822,    75930.51303185058}, 
    {     0.00000000001,  0.51782407060,   113341.08027172917}, 
    {     0.00000000001,  0.26594892339,    76571.54375522019}, 
    {     0.00000000001,  1.68473271541,    28286.99048486120}, 
    {     0.00000000001,  3.43479665429,   130435.63437251298}, 
    {     0.00000000001,  4.94766296108,   205260.65018762815}, 
    {     0.00000000001,  5.67189364590,   122444.98726584678}, 
    {     0.00000000002,  0.35003578980,   132028.58860315479}, 
    {     0.00000000001,  3.82950218931,    50910.23880452200}, 
    {     0.00000000001,  0.58719200248,    78896.49316403578}, 
    {     0.00000000001,  1.40281382564,      467.96499035440}, 
    {     0.00000000001,  3.70071408896,   116783.65521669458}, 
    {     0.00000000001,  1.98838052622,    81604.32185142238}, 
    {     0.00000000001,  5.87508556606,   104275.34649502118}, 
    {     0.00000000001,  2.06878150381,    78188.92782615528}, 
    {     0.00000000001,  3.08543227540,     9384.84100807520}, 
    {     0.00000000001,  3.30520943702,       19.66976089979}, 
    {     0.00000000001,  2.76310033884,    52812.80255517260}, 
    {     0.00000000001,  5.76310756779,     1375.77379984580}, 
    {     0.00000000001,  5.71684807894,    76152.05911134499}, 
    {     0.00000000001,  3.43817796928,    65717.22748563958}, 
    {     0.00000000001,  0.85559605439,    25985.94062330859}, 
    {     0.00000000001,  5.99281135918,   106570.36967048359}, 
    {     0.00000000001,  1.87029583839,    26411.40855823160}, 
    {     0.00000000001,  2.97621377443,    91805.13062721379}, 
    {     0.00000000001,  2.81819497010,   168959.46149984296}, 
    {     0.00000000001,  6.14145843596,   221135.26778299136}, 
    {     0.00000000001,  6.19284917502,   103718.82882698359}, 
    {     0.00000000001,  0.38545603521,   130459.18546877075}, 
    {     0.00000000001,  5.58283403624,   104197.83375581198}, 
    {     0.00000000001,  2.74916354771,   170068.84005193636}, 
    {     0.00000000001,  2.29937985557,    58220.03486452380}, 
    {     0.00000000001,  0.77298125199,    26102.13023557580}, 
    {     0.00000000001,  3.82192552665,    25928.60140678200}, 
    {     0.00000000001,  0.48738972037,   104819.57755665119}, 
    {     0.00000000001,  0.34737694069,     1795.25844372100}, 
    {     0.00000000001,  5.04672208460,    26247.20487636640}, 
    {     0.00000000001,  4.44724577178,     6044.22858137540}, 
    {     0.00000000001,  4.31124637329,    50483.64061364600}, 
    {     0.00000000001,  3.69136847395,    77307.42026875199}, 
    {     0.00000000001,  0.40474217020,      636.99627202420}, 
    {     0.00000000001,  6.11533644929,   241561.83887541336}, 
    {     0.00000000001,  0.08760404468,    54879.42243782400}, 
    {     0.00000000001,  1.61849542996,   128106.31931499895}, 
    {     0.00000000001,  6.27732006130,   196137.07343261078}, 
    {     0.00000000001,  0.82044479603,    51329.72344839720}, 
    {     0.00000000001,  0.98691419134,   163298.12945069079}, 
    {     0.00000000001,  2.30107750853,   179172.74704605396}, 
    {     0.00000000001,  0.61075768459,    51534.39272140940}, 
    {     0.00000000001,  0.58942299216,    78469.89497315978}, 
    {     0.00000000001,  3.29001702156,    79315.97780791098}, 
    {     0.00000000001,  4.50997601178,   203041.89308344138}, 
    {     0.00000000001,  1.19400695200,     8989.46770543239}, 
    {     0.00000000001,  2.30283274772,    50380.54783942739}, 
    {     0.00000000001,  3.04434275932,    78057.52387628538}, 
    {     0.00000000001,  1.59838533079,   137210.22630911658}, 
    {     0.00000000001,  6.25852814644,    50800.03248330259}, 
    {     0.00000000001,  4.59739779893,   156507.74908854539}, 
    {     0.00000000001,  3.52857712732,    78338.49102328988}, 
    {     0.00000000001,  3.29578424156,    51841.95034237900}, 
    {     0.00000000001,  4.37115478363,   231348.55332920236}, 
    {     0.00000000001,  6.21157459837,   199599.31813847595}, 
    {     0.00000000001,  5.68807537585,     3178.14579056760}, 
    {     0.00000000001,  6.16099382664,   103814.80805420138}, 
    {     0.00000000001,  3.58703299790,   106262.81204951399}, 
    {     0.00000000001,  2.12644283427,    62197.64356324779}, 
    {     0.00000000001,  3.67624268292,     2703.61615467560}, 
    {     0.00000000001,  1.94597992024,    45494.58142974879}, 
    {     0.00000000001,  5.27747039682,    52041.69723356339}, 
    {     0.00000000001,  2.87032894974,    38634.38508065720}, 
    {     0.00000000001,  0.23270745450,   138319.60486120995}, 
    {     0.00000000001,  5.53197596443,    27819.02549450680}, 
    {     0.00000000001,  5.12208743996,   142871.55835826878}, 
    {     0.00000000001,  1.39038865276,   112545.88789950538}, 
    {     0.00000000001,  4.74583618954,    53265.51507434200}, 
    {     0.00000000001,  5.38786120390,    99024.13645791399}, 
    {     0.00000000001,  0.39696641642,    42790.96527507320}, 
    {     0.00000000001,  0.71118375221,    52026.24308601380}, 
    {     0.00000000001,  2.16468187079,     1485.98012106520}, 
    {     0.00000000001,  5.72787089962,   153084.84390447979}, 
    {     0.00000000001,  4.66269784654,    54374.89362643540}
};

 
   
static const struct ln_vsop mercury_radius_r2[RADIUS_R2] = {
    {     0.00003117867,  3.08231840294,    26087.90314157420}, 
    {     0.00001245397,  6.15183316810,    52175.80628314840}, 
    {     0.00000424822,  2.92583350003,    78263.70942472259}, 
    {     0.00000136130,  5.97983927257,   104351.61256629678}, 
    {     0.00000042176,  2.74936984182,   130439.51570787099}, 
    {     0.00000021759,  3.14159265359,        0.00000000000}, 
    {     0.00000012794,  5.80143158303,   156527.41884944518}, 
    {     0.00000003825,  2.56993470104,   182615.32199101939}, 
    {     0.00000001042,  3.14646747795,    24978.52458948080}, 
    {     0.00000001131,  5.62140894157,   208703.22513259358}, 
    {     0.00000000483,  6.14311665486,    27197.28169366760}, 
    {     0.00000000332,  2.38990569407,   234791.12827416777}, 
    {     0.00000000320,  6.20678671907,    51066.42773105500}, 
    {     0.00000000120,  0.56753278081,    20426.57109242200}, 
    {     0.00000000113,  3.28087063421,    24498.83024629040}, 
    {     0.00000000105,  4.36644825356,    25028.52121138500}, 
    {     0.00000000097,  5.44142060651,   260879.03141574195}, 
    {     0.00000000095,  1.70261963549,     1059.38193018920}, 
    {     0.00000000103,  2.98025866325,    77154.33087262919}, 
    {     0.00000000074,  1.28624418497,    26617.59410666880}, 
    {     0.00000000057,  2.96811822826,     1109.37855209340}, 
    {     0.00000000066,  5.68227129537,    25132.30339996560}, 
    {     0.00000000053,  3.63665664342,    46514.47423399620}, 
    {     0.00000000059,  3.10957221200,    27043.50288318280}, 
    {     0.00000000053,  0.66664633754,    21535.94964451540}, 
    {     0.00000000043,  4.69265718173,    27147.28507176339}, 
    {     0.00000000042,  2.77425162061,     1589.07289528380}, 
    {     0.00000000036,  4.39785847487,    14765.23904326980}, 
    {     0.00000000035,  1.80414409714,    11322.66409830440}, 
    {     0.00000000043,  6.07298394731,    28306.66024576099}, 
    {     0.00000000033,  5.34403985744,    25448.00585526019}, 
    {     0.00000000031,  5.66726050432,    30639.85663863300}, 
    {     0.00000000031,  2.36583154631,    32858.61374281979}, 
    {     0.00000000031,  4.27240840519,    16983.99614745660}, 
    {     0.00000000033,  3.23005237683,    23869.14603738740}, 
    {     0.00000000031,  0.49978982972,    22645.32819660879}, 
    {     0.00000000028,  2.21272342124,   286966.93455731616}, 
    {     0.00000000033,  6.03641747595,   103242.23401420339}, 
    {     0.00000000025,  4.24265705908,    52705.49724824299}, 
    {     0.00000000023,  2.59657279752,    23969.13928119580}, 
    {     0.00000000027,  2.10611676289,    25558.21217647960}, 
    {     0.00000000021,  0.41168883239,    72602.37737557039}, 
    {     0.00000000025,  5.69956303861,     5661.33204915220}, 
    {     0.00000000022,  4.86511394552,    26301.20223701220}, 
    {     0.00000000024,  0.66328767410,    19317.19254032860}, 
    {     0.00000000021,  2.30174192487,    51220.20654153979}, 
    {     0.00000000020,  5.62040366872,     4551.95349705880}, 
    {     0.00000000018,  0.49330577083,    26068.23338067440}, 
    {     0.00000000016,  6.08123098154,    50586.73338786459}, 
    {     0.00000000016,  1.48825706159,    53235.18821333759}, 
    {     0.00000000017,  2.94317208111,    53285.18483524180}, 
    {     0.00000000015,  2.39611761878,    83925.04147387479}, 
    {     0.00000000015,  3.85588323044,    26091.78447693220}, 
    {     0.00000000014,  4.13824962282,    12566.15169998280}, 
    {     0.00000000015,  5.51224761330,     6770.71060124560}, 
    {     0.00000000014,  5.68202466008,    57837.13833230060}, 
    {     0.00000000014,  5.73541534358,    27676.97603685800}, 
    {     0.00000000016,  5.69568023163,    26107.57290247399}, 
    {     0.00000000015,  5.72321197499,    29530.47808653960}, 
    {     0.00000000014,  5.00810046723,    37410.56723987860}, 
    {     0.00000000012,  1.18950088434,    40853.14218484400}, 
    {     0.00000000013,  2.34556111896,    26084.02180621620}, 
    {     0.00000000012,  2.43751302567,    56727.75978020720}, 
    {     0.00000000012,  1.11729686867,    43071.89928903080}, 
    {     0.00000000012,  4.91255816577,    36301.18868778519}, 
    {     0.00000000011,  1.87794158603,     9103.90699411760}, 
    {     0.00000000010,  2.33246324171,      426.59819087600}, 
    {     0.00000000011,  2.79095158447,   129330.13715577759}, 
    {     0.00000000010,  5.86523749031,    26202.34243025941}, 
    {     0.00000000009,  0.03195500104,    25234.70675982219}, 
    {     0.00000000011,  0.92603695080,      639.89728631400}, 
    {     0.00000000010,  3.94422779390,    25661.30495069820}, 
    {     0.00000000008,  5.42470507867,   110012.94461544899}, 
    {     0.00000000008,  6.27857478248,    49957.04917896160}, 
    {     0.00000000008,  3.40746854679,    25973.46385288896}, 
    {     0.00000000009,  4.83419682076,    38519.94579197200}, 
    {     0.00000000008,  5.64863461479,    53131.40602475700}, 
    {     0.00000000009,  5.74323028796,    51116.42435295920}, 
    {     0.00000000008,  1.97671803181,    13521.75144159140}, 
    {     0.00000000008,  3.52143325301,    52156.13652224860}, 
    {     0.00000000008,  0.94287580197,    78793.40038981718}, 
    {     0.00000000008,  5.25159704872,   313054.83769889036}, 
    {     0.00000000007,  3.57055320328,    48733.23133818299}, 
    {     0.00000000008,  5.33870577078,    51646.11531805379}, 
    {     0.00000000008,  4.34685532674,    31749.23519072640}, 
    {     0.00000000010,  5.07112035424,    25874.60404613620}, 
    {     0.00000000007,  3.44200114221,    26080.78959457339}, 
    {     0.00000000008,  3.46506333076,    98690.28051714458}, 
    {     0.00000000007,  5.27632613466,    77308.10968311399}, 
    {     0.00000000007,  1.97132570364,    10213.28554621100}, 
    {     0.00000000007,  3.47394709299,     2118.76386037840}, 
    {     0.00000000007,  1.19332181936,   103292.23063610759}, 
    {     0.00000000007,  0.88225421550,    38654.05484155699}, 
    {     0.00000000007,  4.28963258668,      955.59974160860}, 
    {     0.00000000009,  2.12066223909,    18849.22754997420}, 
    {     0.00000000008,  2.74524992169,    26095.01668857500}, 
    {     0.00000000007,  4.98611088801,      529.69096509460}, 
    {     0.00000000007,  0.21206642896,    33326.57873317420}, 
    {     0.00000000006,  1.24554634942,    41962.52073693740}, 
    {     0.00000000006,  0.58325989516,    52179.68761850640}, 
    {     0.00000000006,  4.54627482504,    79323.09135491178}, 
    {     0.00000000006,  1.74421492528,    62389.09182935939}, 
    {     0.00000000005,  2.14134003331,    51535.90899683439}, 
    {     0.00000000007,  4.18624565491,    77204.32749453338}, 
    {     0.00000000006,  4.90636348078,    26514.50133245020}, 
    {     0.00000000005,  4.28760477114,    68050.42387851159}, 
    {     0.00000000007,  1.68768205340,    12432.04265039780}, 
    {     0.00000000006,  1.67734378339,    52389.10537858640}, 
    {     0.00000000005,  2.62192976400,    79373.08797681599}, 
    {     0.00000000006,  3.72321362480,    45405.09568190280}, 
    {     0.00000000005,  2.80648643213,    54394.56338733519}, 
    {     0.00000000004,  6.27711808251,    52168.69273614759}, 
    {     0.00000000005,  4.49206719344,    13655.86049117640}, 
    {     0.00000000006,  2.42054247740,    52195.47604404819}, 
    {     0.00000000005,  5.36726437404,    52171.92494779040}, 
    {     0.00000000004,  2.39080386734,    53764.87917843220}, 
    {     0.00000000004,  5.45239063221,    82815.66292178139}, 
    {     0.00000000004,  2.45845698665,    55618.38122811380}, 
    {     0.00000000004,  5.46064307091,    50057.04242277000}, 
    {     0.00000000004,  4.24543775680,   129380.13377768178}, 
    {     0.00000000004,  2.16475111801,   136100.84775702319}, 
    {     0.00000000004,  3.27367961735,     7238.67559160000}, 
    {     0.00000000004,  4.23033954187,    66941.04532641819}, 
    {     0.00000000004,  5.86077781318,   155418.04029735178}, 
    {     0.00000000004,  2.91823301912,     2218.75710418680}, 
    {     0.00000000004,  2.22132272424,    33967.99229491319}, 
    {     0.00000000004,  4.13443053346,    32370.97899156560}, 
    {     0.00000000004,  0.97401599373,    44181.27784112419}, 
    {     0.00000000005,  5.73865924281,    52182.91983014920}, 
    {     0.00000000003,  5.77600031262,    28421.09953444620}, 
    {     0.00000000003,  3.60566098017,    99799.65906923798}, 
    {     0.00000000003,  4.89516568247,    47623.85278608960}, 
    {     0.00000000003,  2.65837542043,    76674.63652943878}, 
    {     0.00000000004,  3.97575019999,    26727.80042788820}, 
    {     0.00000000004,  1.58883137896,    77734.01845962799}, 
    {     0.00000000003,  4.05377923220,    18093.37469954999}, 
    {     0.00000000003,  0.32164436845,    78244.03966382280}, 
    {     0.00000000003,  4.55918659193,     1066.49547719000}, 
    {     0.00000000003,  1.04073203752,    94138.32702008578}, 
    {     0.00000000003,  5.11379070475,     1052.26838318840}, 
    {     0.00000000004,  0.00289656740,        7.11354700080}, 
    {     0.00000000003,  6.00211964373,    29416.03879785439}, 
    {     0.00000000003,  0.83769822705,    73711.75592766379}, 
    {     0.00000000003,  6.24558724290,      853.19638175200}, 
    {     0.00000000003,  1.04516366216,    51123.53789995999}, 
    {     0.00000000003,  1.58718103357,    51109.31080595839}, 
    {     0.00000000003,  1.95786741975,   103396.01282468818}, 
    {     0.00000000002,  1.84359601235,    52602.40447402440}, 
    {     0.00000000003,  0.20363902961,   124778.18365871879}, 
    {     0.00000000003,  3.92029951121,   104881.30353139139}, 
    {     0.00000000002,  3.86834138575,    64741.95798313119}, 
    {     0.00000000002,  4.78277672679,    88476.99497093359}, 
    {     0.00000000002,  3.02197674612,    76044.95232053580}, 
    {     0.00000000002,  2.56056246046,    51962.50718771040}, 
    {     0.00000000002,  0.39257053002,    23754.70674870219}, 
    {     0.00000000002,  1.93806690975,   117873.36400788819}, 
    {     0.00000000003,  4.94947672066,    44937.13069154840}, 
    {     0.00000000002,  5.16794137847,    91785.46086631398}, 
    {     0.00000000002,  3.69784569438,    78267.59076008058}, 
    {     0.00000000002,  0.12898246901,    28206.66700195260}, 
    {     0.00000000002,  2.71494330191,    52290.24557183361}, 
    {     0.00000000002,  1.01643765523,   155468.03691925599}, 
    {     0.00000000002,  1.94864163639,     7994.52844202420}, 
    {     0.00000000002,  0.34644075002,   125887.56221081219}, 
    {     0.00000000002,  2.07439531255,   339142.74084046457}, 
    {     0.00000000002,  0.47977325476,    74821.13447975718}, 
    {     0.00000000002,  2.16320557771,    65697.55772473979}, 
    {     0.00000000002,  5.55432178842,    78283.37918562238}, 
    {     0.00000000002,  1.29900775156,   105410.99449648599}, 
    {     0.00000000002,  2.53975890096,    78270.82297172339}, 
    {     0.00000000002,  3.05127595992,    78256.59587772179}, 
    {     0.00000000002,  0.74524218739,    18207.81398823521}, 
    {     0.00000000002,  2.52077863728,    45892.73043315699}, 
    {     0.00000000002,  4.40145815211,   103821.92160120218}, 
    {     0.00000000002,  0.48596602676,    71492.99882347698}, 
    {     0.00000000002,  5.20647406504,   162188.75089859738}, 
    {     0.00000000002,  4.82705668292,    35191.81013569180}, 
    {     0.00000000002,  2.53400006045,   181505.94343892598}, 
    {     0.00000000002,  5.01222373888,     3442.57494496540}, 
    {     0.00000000002,  4.77472325123,    78477.00852016058}, 
    {     0.00000000002,  4.04794032959,   120226.23016165999}, 
    {     0.00000000002,  4.91210946644,   129483.91596626239}, 
    {     0.00000000002,  4.13616693949,    77211.44104153418}, 
    {     0.00000000002,  5.55063812006,    71980.63357473118}, 
    {     0.00000000002,  1.87550379173,    23439.44831610119}, 
    {     0.00000000002,  4.79089230864,    15874.61759536320}, 
    {     0.00000000002,  4.07209162893,    77837.11123384659}, 
    {     0.00000000002,  3.28278777867,    51322.60990139639}, 
    {     0.00000000001,  3.34910054328,   151975.46535238638}, 
    {     0.00000000001,  2.46216864998,    98068.53671630539}, 
    {     0.00000000002,  2.55245277940,    39609.65458316560}, 
    {     0.00000000002,  2.20615341805,    78259.82808936459}, 
    {     0.00000000001,  1.85625086925,    27140.17152476259}, 
    {     0.00000000001,  4.90356608602,    78690.30761559859}, 
    {     0.00000000002,  2.05592477737,      433.71173787680}, 
    {     0.00000000001,  0.57135579166,    58458.88213313979}, 
    {     0.00000000001,  6.02187954635,   102132.85546210999}, 
    {     0.00000000002,  3.23303486183,   150866.08680029298}, 
    {     0.00000000001,  4.60285163809,    77197.21394753258}, 
    {     0.00000000001,  3.29652393557,   104331.94280539699}, 
    {     0.00000000002,  0.37358476984,    52061.36699446317}, 
    {     0.00000000002,  6.05813345839,    78050.41032928458}, 
    {     0.00000000001,  5.03719934254,   105460.99111839019}, 
    {     0.00000000001,  5.61325235757,    81706.28436968799}, 
    {     0.00000000001,  4.16559096091,    51742.09454527159}, 
    {     0.00000000001,  2.18291711529,   104371.28232719658}, 
    {     0.00000000001,  1.56268200733,   114564.89811250778}, 
    {     0.00000000001,  2.97801937910,    26941.09952332620}, 
    {     0.00000000002,  0.60670302239,   130969.20667296558}, 
    {     0.00000000001,  1.28661284202,    27154.39861876420}, 
    {     0.00000000001,  0.32656599185,     6283.07584999140}, 
    {     0.00000000002,  0.98900298585,   129909.82474277639}, 
    {     0.00000000002,  0.34266376084,   104355.49390165479}, 
    {     0.00000000001,  1.70449480453,    71025.03383312259}, 
    {     0.00000000001,  0.69109808707,   103925.01437542078}, 
    {     0.00000000001,  5.99111938887,   104344.49901929598}, 
    {     0.00000000001,  1.29444105614,    26241.68195205900}, 
    {     0.00000000001,  1.52348055432,   104564.91166173479}, 
    {     0.00000000001,  1.02840142284,    93028.94846799239}, 
    {     0.00000000001,  2.70610275891,    59414.48187474840}, 
    {     0.00000000001,  3.38720596578,    24864.08530079559}, 
    {     0.00000000001,  4.01905758539,   181555.94006083018}, 
    {     0.00000000001,  0.19437065391,   131548.89425996438}, 
    {     0.00000000001,  2.33926236379,   108903.56606335558}, 
    {     0.00000000001,  3.48554697151,    97580.90196505119}, 
    {     0.00000000001,  2.21845432691,   107794.18751126219}, 
    {     0.00000000001,  5.21032711478,   134991.46920492979}, 
    {     0.00000000001,  3.36974859678,    22759.76748529401}, 
    {     0.00000000001,  3.69704620260,    51749.20809227239}, 
    {     0.00000000001,  5.50712708044,   104358.72611329758}, 
    {     0.00000000001,  3.54339432961,    84546.78527471398}, 
    {     0.00000000001,  1.85236380912,    76144.94556434419}, 
    {     0.00000000001,  1.35457977308,   103285.11708910679}, 
    {     0.00000000001,  5.41788745559,    79852.78232000639}, 
    {     0.00000000001,  2.71021284118,      419.48464387520}, 
    {     0.00000000001,  5.20690925178,    58946.51688439399}, 
    {     0.00000000001,  2.58243930041,    79219.30916633119}, 
    {     0.00000000001,  4.14551403325,     2648.45482547300}, 
    {     0.00000000001,  0.80546617242,    52815.70356946240}, 
    {     0.00000000001,  4.35263828880,   131498.89763806018}, 
    {     0.00000000001,  2.96821079393,    63498.47038145279}, 
    {     0.00000000001,  1.67750729252,    64607.84893354619}, 
    {     0.00000000001,  1.27183275592,    39743.76363275060}, 
    {     0.00000000001,  4.96647288061,   365230.64398203876}, 
    {     0.00000000001,  0.99406518960,    50579.61984086379}, 
    {     0.00000000001,  5.18049622713,     1596.18644228460}, 
    {     0.00000000001,  3.02654575849,    54294.57014352679}, 
    {     0.00000000001,  5.63350272797,    78378.14871340781}, 
    {     0.00000000001,  4.40490970421,    25021.40766438420}, 
    {     0.00000000001,  3.63610465805,    51756.32163927320}, 
    {     0.00000000001,  4.26629771518,    26724.89941359840}, 
    {     0.00000000001,  2.79177248963,   157636.79740153858}, 
    {     0.00000000001,  4.56988133520,    19804.82729158280}, 
    {     0.00000000001,  2.63303478623,     5327.47610838280}, 
    {     0.00000000001,  5.14973525909,   104347.73123093879}, 
    {     0.00000000001,  3.74530927136,    44295.71712980940}, 
    {     0.00000000001,  0.68414890944,    90829.86112470538}, 
    {     0.00000000001,  0.49165582856,    69159.80243060499}, 
    {     0.00000000001,  1.49658721659,    61279.71327726600}, 
    {     0.00000000001,  5.27847149725,    25934.12433108940}, 
    {     0.00000000001,  5.17229158556,      149.56319713460}, 
    {     0.00000000001,  3.18169864614,    78149.27013603736}, 
    {     0.00000000001,  0.76788482924,   146314.13330323418}, 
    {     0.00000000001,  5.29528480250,    26137.89976347840}, 
    {     0.00000000001,  3.51389080283,    49842.60989027639}, 
    {     0.00000000001,  0.80519817567,   103299.34418310839}, 
    {     0.00000000001,  1.91164708185,   105940.68546158058}, 
    {     0.00000000001,  0.84584454465,    77829.99768684579}, 
    {     0.00000000001,  4.68188188415,    90695.75207512038}, 
    {     0.00000000001,  0.65295847908,    26037.90651966999}, 
    {     0.00000000001,  0.23063503545,   105307.21230790539}, 
    {     0.00000000001,  3.82320581190,    25619.93815121980}, 
    {     0.00000000001,  4.40595033152,    70269.18098269838}, 
    {     0.00000000001,  5.83543698290,    27311.72098235281}, 
    {     0.00000000001,  4.93010556318,   143961.26714946238}, 
    {     0.00000000001,  0.69055367085,    10021.83728009940}, 
    {     0.00000000001,  4.04373064295,    25565.32572348040}, 
    {     0.00000000001,  2.76360990402,    55503.94193942859}, 
    {     0.00000000001,  5.27048505986,    52643.77127350280}, 
    {     0.00000000001,  5.30671272193,    77623.81213840858}, 
    {     0.00000000001,  3.59001485540,   130012.91751699499}, 
    {     0.00000000001,  6.20174437935,     3328.13565628019}, 
    {     0.00000000001,  4.37843587271,    52329.58509363319}, 
    {     0.00000000001,  5.35804254604,     7880.08915333899}, 
    {     0.00000000001,  0.37001213364,    29428.51556827400}, 
    {     0.00000000001,  2.09823688356,    26610.48055966799}, 
    {     0.00000000001,  1.90742269266,   188276.65404017158}, 
    {     0.00000000001,  2.07583539066,    26555.86813192860}, 
    {     0.00000000001,  2.74928843672,    54509.00267602040}, 
    {     0.00000000001,  4.78361926570,    25450.90686955000}, 
    {     0.00000000001,  4.66282101332,     1581.95934828300}, 
    {     0.00000000001,  1.93180863256,    85034.42002596818}, 
    {     0.00000000001,  1.39574142846,    50593.84693486539}, 
    {     0.00000000001,  4.28383546403,    53242.30176033840}, 
    {     0.00000000001,  0.36440946351,    89586.37352302698}, 
    {     0.00000000001,  3.84510723447,   119116.85160956658}, 
    {     0.00000000001,  0.98328228963,      536.80451209540}, 
    {     0.00000000001,  6.21114511135,    25668.41849769900}, 
    {     0.00000000001,  3.66409514672,    26624.70765366959}, 
    {     0.00000000001,  4.38823198457,    12546.48193908300}, 
    {     0.00000000000,  3.66005454502,    95247.70557217918}, 
    {     0.00000000001,  3.25481552100,    46848.33017476560}, 
    {     0.00000000000,  6.18816289886,      213.29909543800}, 
    {     0.00000000000,  5.42382537447,   124156.43985787958}, 
    {     0.00000000000,  3.08747000862,   104138.31347085879}, 
    {     0.00000000000,  4.37059865637,    80482.46652890938}, 
    {     0.00000000000,  4.90249116112,    26521.61487945100}, 
    {     0.00000000000,  4.11303810429,    65831.66677432480}, 
    {     0.00000000000,  3.42919047371,   116917.76426627958}, 
    {     0.00000000001,  4.86353089367,    51639.00177105299}, 
    {     0.00000000000,  0.20560781967,    77844.22478084739}, 
    {     0.00000000000,  6.23379339496,    48847.67062686820}, 
    {     0.00000000000,  4.71445024355,       76.26607127560}, 
    {     0.00000000001,  2.25536112069,    25551.09862947879}, 
    {     0.00000000000,  6.00692447908,    26507.38778544939}, 
    {     0.00000000000,  0.02652054523,     6681.22485339960}, 
    {     0.00000000000,  1.97940011643,    86143.79857806159}, 
    {     0.00000000000,  4.41963004243,      114.43928868521}
};

 
   
static const struct ln_vsop mercury_radius_r3[RADIUS_R3] = {
    {     0.00000032676,  1.67971641967,    26087.90314157420}, 
    {     0.00000024166,  4.63403168878,    52175.80628314840}, 
    {     0.00000012133,  1.38983777816,    78263.70942472259}, 
    {     0.00000005141,  4.43915486864,   104351.61256629678}, 
    {     0.00000001981,  1.20734065292,   130439.51570787099}, 
    {     0.00000001460,  3.14159265359,        0.00000000000}, 
    {     0.00000000719,  4.25914225052,   156527.41884944518}, 
    {     0.00000000250,  1.02794489584,   182615.32199101939}, 
    {     0.00000000084,  4.08003393556,   208703.22513259358}, 
    {     0.00000000028,  0.84976129869,   234791.12827416777}, 
    {     0.00000000023,  1.60056693427,    24978.52458948080}, 
    {     0.00000000011,  4.57906901820,    27197.28169366760}, 
    {     0.00000000012,  4.66186402631,    51066.42773105500}, 
    {     0.00000000009,  3.90351105399,   260879.03141574195}, 
    {     0.00000000005,  1.44899194699,    77154.33087262919}, 
    {     0.00000000004,  1.37039350951,    53285.18483524180}, 
    {     0.00000000003,  0.65216170836,   286966.93455731616}, 
    {     0.00000000002,  5.31647339795,    20426.57109242200}, 
    {     0.00000000002,  1.54948310012,     1109.37855209340}, 
    {     0.00000000002,  4.46650154841,   103242.23401420339}, 
    {     0.00000000002,  0.20311171970,     1059.38193018920}, 
    {     0.00000000001,  4.18509315538,    25132.30339996560}, 
    {     0.00000000001,  2.08677361801,    46514.47423399620}, 
    {     0.00000000001,  3.22427097914,    27147.28507176339}, 
    {     0.00000000001,  1.31990592569,     1589.07289528380}, 
    {     0.00000000001,  6.11476749247,    26617.59410666880}, 
    {     0.00000000001,  3.87574939924,     4551.95349705880}, 
    {     0.00000000001,  5.13451991746,    72602.37737557039}, 
    {     0.00000000001,  2.82416621766,    14765.23904326980}, 
    {     0.00000000001,  3.69788379486,   313054.83769889036}, 
    {     0.00000000001,  1.23397179166,   129330.13715577759}, 
    {     0.00000000001,  1.47670395865,    27043.50288318280}, 
    {     0.00000000001,  2.82993373800,    52705.49724824299}, 
    {     0.00000000001,  1.69896765630,    23869.14603738740}, 
    {     0.00000000001,  0.32413035355,     9103.90699411760}, 
    {     0.00000000001,  4.20161569510,    27676.97603685800}, 
    {     0.00000000001,  4.34344280909,    79373.08797681599}, 
    {     0.00000000001,  0.89956318302,    51220.20654153979}, 
    {     0.00000000001,  2.20322858011,    21535.94964451540}, 
    {     0.00000000001,  3.19342492912,    26301.20223701220}, 
    {     0.00000000001,  1.88258101468,    98690.28051714458}, 
    {     0.00000000001,  4.68591095165,    50586.73338786459}, 
    {     0.00000000001,  5.85065851846,    40853.14218484400}, 
    {     0.00000000001,  1.23101504358,    54394.56338733519}, 
    {     0.00000000001,  6.23351653071,    53235.18821333759}, 
    {     0.00000000001,  3.87422845306,    77308.10968311399}, 
    {     0.00000000001,  0.79126413034,    32858.61374281979}, 
    {     0.00000000001,  4.14416492315,    29530.47808653960}, 
    {     0.00000000001,  3.66291049805,    82815.66292178139}, 
    {     0.00000000001,  4.44414264582,    53131.40602475700}, 
    {     0.00000000001,  5.39898005107,    19317.19254032860}, 
    {     0.00000000001,  5.74090182848,    78793.40038981718}, 
    {     0.00000000001,  2.04445272211,    22645.32819660879}, 
    {     0.00000000000,  5.20058182117,    26068.23338067440}, 
    {     0.00000000000,  2.88882171293,    79323.09135491178}, 
    {     0.00000000000,  0.77734457598,    83925.04147387479}, 
    {     0.00000000000,  1.85241611022,    25973.46385288896}, 
    {     0.00000000000,  4.31134434847,    26202.34243025941}, 
    {     0.00000000000,  2.48865412354,    25028.52121138500}, 
    {     0.00000000000,  4.73702212377,    49957.04917896160}, 
    {     0.00000000001,  4.52312859491,    28306.66024576099}, 
    {     0.00000000000,  6.22434083886,    25558.21217647960}, 
    {     0.00000000000,  4.43739303442,    57837.13833230060}, 
    {     0.00000000000,  4.22145138443,   155418.04029735178}, 
    {     0.00000000001,  4.15987542477,     3442.57494496540}, 
    {     0.00000000000,  3.37837484563,    37410.56723987860}, 
    {     0.00000000000,  4.06445772133,    30639.85663863300}, 
    {     0.00000000000,  1.88469600324,    52156.13652224860}, 
    {     0.00000000000,  5.55588074115,      639.89728631400}, 
    {     0.00000000000,  4.12649087613,    26107.57290247399}, 
    {     0.00000000001,  2.12434762874,    45405.09568190280}, 
    {     0.00000000000,  3.52050357800,    51646.11531805379}, 
    {     0.00000000000,  0.95617902890,    56727.75978020720}, 
    {     0.00000000000,  2.68844434121,    25874.60404613620}, 
    {     0.00000000000,  0.77169310211,    26084.02180621620}, 
    {     0.00000000000,  1.28280882604,    31749.23519072640}, 
    {     0.00000000000,  3.77504856922,   110012.94461544899}, 
    {     0.00000000000,  5.51895778760,    51116.42435295920}, 
    {     0.00000000000,  2.46996848792,    12566.15169998280}, 
    {     0.00000000000,  2.06080302810,    26091.78447693220}, 
    {     0.00000000000,  4.06656248201,     6770.71060124560}, 
    {     0.00000000000,  5.64089373958,    43071.89928903080}, 
    {     0.00000000000,  3.01044907413,      529.69096509460}, 
    {     0.00000000000,  3.74932541209,    58946.51688439399}, 
    {     0.00000000000,  1.59982844601,    24498.83024629040}, 
    {     0.00000000000,  6.18077135384,    52389.10537858640}, 
    {     0.00000000000,  3.54760851916,     5661.33204915220}, 
    {     0.00000000000,  0.36958867063,   339142.74084046457}, 
    {     0.00000000000,  1.28365548551,   105460.99111839019}, 
    {     0.00000000000,  2.54309051397,    66941.04532641819}, 
    {     0.00000000000,  1.20651308836,    76674.63652943878}, 
    {     0.00000000000,  0.56648671737,      426.59819087600}, 
    {     0.00000000000,  5.16253006866,      955.59974160860}, 
    {     0.00000000000,  0.44574885677,    51535.90899683439}, 
    {     0.00000000000,  3.22440388798,    36301.18868778519}, 
    {     0.00000000000,  5.18616332697,    52179.68761850640}, 
    {     0.00000000000,  1.77057901742,     2118.76386037840}, 
    {     0.00000000000,  0.83059819658,    53764.87917843220}, 
    {     0.00000000000,  4.82874431323,    78244.03966382280}, 
    {     0.00000000000,  5.46044714578,    38654.05484155699}, 
    {     0.00000000000,  1.35238108580,    76044.95232053580}, 
    {     0.00000000000,  0.78426047136,    52195.47604404819}, 
    {     0.00000000000,  1.56504928662,     2218.75710418680}, 
    {     0.00000000000,  0.44110358867,   136100.84775702319}, 
    {     0.00000000000,  3.95443065599,    50057.04242277000}, 
    {     0.00000000000,  0.69662881483,    55618.38122811380}, 
    {     0.00000000000,  0.00690662625,      213.29909543800}, 
    {     0.00000000000,  3.72355104277,    52171.92494779040}, 
    {     0.00000000000,  5.77253301832,   105410.99449648599}, 
    {     0.00000000000,  0.68653770637,    79219.30916633119}, 
    {     0.00000000000,  2.14142206148,    64741.95798313119}
};

  
static const struct ln_vsop mercury_radius_r4[RADIUS_R4] = {
    {     0.00000000394,  0.36736738836,    26087.90314157420}, 
    {     0.00000000387,  3.18568894140,    52175.80628314840}, 
    {     0.00000000270,  6.16979809593,    78263.70942472259}, 
    {     0.00000000149,  2.91591472142,   104351.61256629678}, 
    {     0.00000000071,  5.95888916295,   130439.51570787099}, 
    {     0.00000000031,  2.72386331553,   156527.41884944518}, 
    {     0.00000000017,  0.00000000000,        0.00000000000}, 
    {     0.00000000012,  5.77758679438,   182615.32199101939}, 
    {     0.00000000005,  2.54442235521,   208703.22513259358}, 
    {     0.00000000002,  5.59215484513,   234791.12827416777}, 
    {     0.00000000001,  2.31734413223,   260879.03141574195}, 
    {     0.00000000000,  5.37041038965,   286966.93455731616}, 
    {     0.00000000000,  3.05050417438,    51066.42773105500}, 
    {     0.00000000000,  0.07052854591,    24978.52458948080}, 
    {     0.00000000000,  5.93192891756,    53285.18483524180}, 
    {     0.00000000000,  6.03840913462,    77154.33087262919}, 
    {     0.00000000000,  3.02089425425,    27197.28169366760}
};

  
static const struct ln_vsop mercury_radius_r5[RADIUS_R5] = {
    {     0.00000000006,  3.98812118954,    26087.90314157420}, 
    {     0.00000000006,  1.55172409309,    52175.80628314840}, 
    {     0.00000000005,  4.65488347662,    78263.70942472259}, 
    {     0.00000000004,  1.40628214181,   104351.61256629678}, 
    {     0.00000000002,  4.44423794944,   130439.51570787099}, 
    {     0.00000000001,  3.14159265359,        0.00000000000}, 
    {     0.00000000001,  1.21235041448,   156527.41884944518}, 
    {     0.00000000001,  4.24238056507,   182615.32199101939}, 
    {     0.00000000000,  0.95140152937,   208703.22513259358}, 
    {     0.00000000000,  4.00511196914,   234791.12827416777} 
};

/*! \fn void ln_get_mercury_equ_coords (double JD, struct ln_equ_posn * position);
* \param JD julian Day
* \param position Pointer to store position 
*
* Calculates Mercury's equatorial position for given julian day.
* This function includes calculations for planetary aberration and refers
* to the FK5 reference frame.
*
* To get the complete equatorial coordinates, corrections for nutation
* have to be applied.
*
* The position returned is accurate to within 0.1 arcsecs.
*/ 
void ln_get_mercury_equ_coords (double JD, struct ln_equ_posn * position)
{
	struct ln_helio_posn h_sol, h_mercury;
	struct ln_rect_posn g_sol, g_mercury;
	double a,b,c;
	double ra, dec, delta, diff, last, t = 0;
	
	/* need typdef for solar heliocentric coords */
	ln_get_solar_geom_coords (JD, &h_sol);
	ln_get_rect_from_helio (&h_sol, &g_sol);
	
	do {
		last = t;
		ln_get_mercury_helio_coords (JD - t, &h_mercury);
		ln_get_rect_from_helio (&h_mercury, &g_mercury);

		/* equ 33.10 pg 229 */
		a = g_sol.X + g_mercury.X;
		b = g_sol.Y + g_mercury.Y;
		c = g_sol.Z + g_mercury.Z;
	
		delta = a*a + b*b + c*c;
		delta = sqrt (delta);
		t = delta * 0.0057755183;
		diff = t - last;
	} while (diff > 0.0001 || diff < -0.0001);
		
	ra = atan2 (b,a);
	dec = c / delta;
	dec = asin (dec);

	/* back to hours, degrees */
	position->ra = ln_range_degrees(ln_rad_to_deg (ra));
	position->dec = ln_rad_to_deg (dec);
}
	

/*! \fn void ln_get_mercury_helio_coords (double JD, struct ln_helio_posn * position)
* \param JD Julian Day
* \param position Pointer to store heliocentric position
*
* Calculate Mercury heliocentric (refered to the centre of the Sun) coordinates
* in the FK5 reference frame for the given julian day.
* Longitude and Latitude are in degrees, whilst radius vector is in AU.
*/  
/* Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87 
*/
void ln_get_mercury_helio_coords (double JD, struct ln_helio_posn * position)
{
	double t, t2, t3, t4, t5;
	double L0, L1, L2, L3, L4, L5;
	double B0, B1, B2, B3, B4, B5;
	double R0, R1, R2, R3, R4, R5;
	
	/* check cache first */
	if (JD == cJD) {
		/* cache hit */
		position->L = cL;
		position->B = cB;
		position->R = cR;
		return;
	}
	
	/* get julian ephemeris day */
	t = (JD - 2451545.0) / 365250;
	t2 = t * t;
	t3 = t2 * t;
	t4 = t3 * t;
	t5 = t4 * t;
	
	/* calc L series */
	L0 = ln_calc_series (mercury_longitude_l0, LONG_L0, t);
	L1 = ln_calc_series (mercury_longitude_l1, LONG_L1, t);
	L2 = ln_calc_series (mercury_longitude_l2, LONG_L2, t);
	L3 = ln_calc_series (mercury_longitude_l3, LONG_L3, t);
	L4 = ln_calc_series (mercury_longitude_l4, LONG_L4, t);
	L5 = ln_calc_series (mercury_longitude_l5, LONG_L5, t);
	position->L = (L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5);

	/* calc B series */
	B0 = ln_calc_series (mercury_latitude_b0, LAT_B0, t);
	B1 = ln_calc_series (mercury_latitude_b1, LAT_B1, t);
	B2 = ln_calc_series (mercury_latitude_b2, LAT_B2, t);
	B3 = ln_calc_series (mercury_latitude_b3, LAT_B3, t);
	B4 = ln_calc_series (mercury_latitude_b4, LAT_B4, t);
	B5 = ln_calc_series (mercury_latitude_b5, LAT_B5, t);
	position->B = (B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5);


	/* calc R series */
	R0 = ln_calc_series (mercury_radius_r0, RADIUS_R0, t);
	R1 = ln_calc_series (mercury_radius_r1, RADIUS_R1, t);
	R2 = ln_calc_series (mercury_radius_r2, RADIUS_R2, t);
	R3 = ln_calc_series (mercury_radius_r3, RADIUS_R3, t);
	R4 = ln_calc_series (mercury_radius_r4, RADIUS_R4, t);
	R5 = ln_calc_series (mercury_radius_r5, RADIUS_R5, t);
	position->R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5);
	
	/* change to degrees in correct quadrant */
	position->L = ln_rad_to_deg(position->L);
	position->B = ln_rad_to_deg(position->B);
	position->L = ln_range_degrees(position->L);	
	
	/* change to fk5 reference frame */
	ln_vsop87_to_fk5 (position, JD);
	
	/* save cache */
	cJD = JD;
	cL = position->L;
	cB = position->B;
	cR = position->R;
}


/*! \fn double ln_get_mercury_earth_dist (double JD);
* \brief Calculate the distance between Mercury and the Earth in AU
* \param JD Julian day
* \return Distance in AU
*
* Calculates the distance in AU between the Earth and Mercury for
* the given julian day.
*/
double ln_get_mercury_earth_dist (double JD)
{
	struct ln_helio_posn  h_mercury, h_earth;
	struct ln_rect_posn g_mercury, g_earth;
	double x, y, z;
	
	/* get heliocentric positions */
	ln_get_mercury_helio_coords (JD, &h_mercury);
	ln_get_earth_helio_coords (JD, &h_earth);
	
	/* get geocentric coords */
	ln_get_rect_from_helio (&h_mercury, &g_mercury);
	ln_get_rect_from_helio (&h_earth, &g_earth);
	
	/* use pythag */
	x = g_mercury.X - g_earth.X;
	y = g_mercury.Y - g_earth.Y;
	z = g_mercury.Z - g_earth.Z;;
	x = x * x;
	y = y * y;
	z = z * z;

	return sqrt (x + y + z);
}
	
/*! \fn double ln_get_mercury_solar_dist (double JD);
* \brief Calculate the distance between Mercury and the Sun in AU
* \param JD Julian day
* \return Distance in AU
*
* Calculates the distance in AU between the Sun and Mercury for
* the given julian day.
*/ 
double ln_get_mercury_solar_dist (double JD)
{
	struct ln_helio_posn  h_mercury;

	/* get heliocentric position */
	ln_get_mercury_helio_coords (JD, &h_mercury);

	return h_mercury.R;
}
	
/*! \fn double ln_get_mercury_magnitude (double JD);
* \brief Calculate the visible magnitude of Mercury
* \param JD Julian day
* \return Visisble magnitude of mercury
*
* Calculate the visisble magnitude of Mercury for the given
* julian day.
*/ 
double ln_get_mercury_magnitude (double JD)
{
	double delta, r, i, i2, i3;
	
	/* get distances */
	r = ln_get_mercury_solar_dist (JD);
	delta = ln_get_mercury_earth_dist (JD);
	
	/* get phase */
	i = ln_get_mercury_phase (JD);
	i2 = i * i;
	i3 = i2 * i;
	
	return -0.42 + 5 * log10 (r * delta) + 0.0380 * i - 0.000273 * i2 + 0.000002 * i3;
}

/*! \fn double ln_get_mercury_disk (double JD);
* \brief Calculate the illuminated fraction of Mercury's disk
* \param JD Julian day
* \return Illuminated fraction of Mercury's disk
*
* Calculate the illuminated fraction of Mercury's disk for the given Julian
* day.
*/ 
/* Chapter 41 */
double ln_get_mercury_disk (double JD)
{
	double r,delta,R;	
	
	/* get distances */
	R = ln_get_earth_solar_dist (JD);
	r = ln_get_mercury_solar_dist (JD);
	delta = ln_get_mercury_earth_dist (JD);
	
	/* calc fraction angle */
	return (((r + delta) * (r + delta)) - R * R) / (4 * r * delta);
}
  
/*! \fn double ln_get_mercury_phase (double JD);
* \brief Calculate the phase angle of Mercury (Sun - Mercury - Earth)
* \param JD Julian day
* \return Phase angle of Mercury (degrees)
*
* Calculates the phase angle of Mercury, that is, the angle Sun -
* Mercury - Earth for the given Julian day.
*/ 
/* Chapter 41 */
double ln_get_mercury_phase (double JD)
{
	double i,r,delta,R;	
	
	/* get distances */
	R = ln_get_earth_solar_dist (JD);
	r = ln_get_mercury_solar_dist (JD);
	delta = ln_get_mercury_earth_dist (JD);

	/* calc phase */
	i = (r * r + delta * delta - R * R) / (2 * r * delta);
	i = acos (i);
	return ln_rad_to_deg (i);
}


/*! \fn double ln_get_mercury_rst (double JD, struct ln_lnlat_posn * observer, struct ln_rst_time * rst);
* \param JD Julian day
* \param observer Observers position
* \param rst Pointer to store Rise, Set and Transit time in JD
* \return 0 for success, else 1 for circumpolar.
*
* Calculate the time the rise, set and transit (crosses the local meridian at upper culmination)
* time of Mercury for the given Julian day.
*
* Note: this functions returns 1 if Mercury is circumpolar, that is it remains the whole
* day either above or below the horizon.
*/
int ln_get_mercury_rst (double JD, struct ln_lnlat_posn * observer, struct ln_rst_time * rst)
{
	return ln_get_body_rst_horizon (JD, observer, ln_get_mercury_equ_coords, LN_STAR_STANDART_HORIZON, rst); 
}

/*! \fn double ln_get_mercury_sdiam (double JD)
* \param JD Julian day
* \return Semidiameter in arc seconds
*
* Calculate the semidiameter of Mercury in arc seconds for the 
* given julian day.
*/
double ln_get_mercury_sdiam (double JD)
{
	double So = 3.36; /* at 1 AU */
	double dist;
	
	dist = ln_get_mercury_earth_dist (JD);
	return So / dist;
}
	
/*! \fn void ln_get_mercury_rect_helio (double JD, struct ln_rect_posn * position)
* \param JD Julian day.
* \param position ointer to return position
*
* Calculate Mercurys rectangular heliocentric coordinates for the
* given Julian day. Coordinates are in AU.
*/
void ln_get_mercury_rect_helio (double JD, struct ln_rect_posn * position)
{
	struct ln_helio_posn mercury;
		
	ln_get_mercury_helio_coords (JD, &mercury);
	ln_get_rect_from_helio (&mercury, position);
}
