/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "SourceParametersWidget.h"

#include "ParametersWidgetBase_p.h"

using namespace QtShiva;

#include <GTLCore/Value.h>
#include <OpenShiva/Source.h>
#include <OpenShiva/Metadata.h>

class SourceParametersWidget::SourceParametrisation : public ParametersWidgetBase::Parametrisation {
  public:
    SourceParametrisation() : m_source(0) {}
    virtual const GTLCore::Metadata::Group* parameters() const;
    virtual const GTLCore::String& name() const;
    virtual void setParameter( const GTLCore::String& _name, GTLCore::Value );
    void setSource( const OpenShiva::Source* _kernel );
    const std::map< GTLCore::String, GTLCore::Value>& parametersMap() const;
  private:
    const OpenShiva::Source* m_source;
    std::map< GTLCore::String, GTLCore::Value> m_parameters;
};


const GTLCore::Metadata::Group* SourceParametersWidget::SourceParametrisation::parameters() const
{
  if( m_source and m_source->metadata() )
  {
    return m_source->metadata()->parameters();
  } else {
    return 0;
  }
}

const GTLCore::String& SourceParametersWidget::SourceParametrisation::name() const
{
  return m_source->name();
}

void SourceParametersWidget::SourceParametrisation::setParameter( const GTLCore::String& _name, GTLCore::Value _value)
{
  m_parameters[_name] = _value;
}

void SourceParametersWidget::SourceParametrisation::setSource( const OpenShiva::Source* _source )
{
  m_source = _source;
  p->regenerateWidget();
}

const std::map< GTLCore::String, GTLCore::Value>& SourceParametersWidget::SourceParametrisation::parametersMap() const
{
  return m_parameters;
}


struct SourceParametersWidget::Private {
  SourceParametrisation* parametrisation;
};


SourceParametersWidget::SourceParametersWidget( QWidget* parent ) : ParametersWidgetBase(parent), d(new Private)
{
  d->parametrisation = new SourceParametrisation;
  setParametrisation(d->parametrisation);
}

SourceParametersWidget::~SourceParametersWidget()
{
  delete d;
}

void SourceParametersWidget::setSource( const OpenShiva::Source* _source )
{
  d->parametrisation->setSource(_source);
}

const std::map< GTLCore::String, GTLCore::Value>& SourceParametersWidget::parameters() const
{
  return d->parametrisation->parametersMap();
}

