/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Brush.h"

#include <QPainter>

#include <OpenRijn/DistanceInformation.h>
#include <OpenRijn/DrawingPoint.h>

#include "Canvas.h"

using namespace QtRijn;

struct Brush::Private
{
  QPen pen;
};

Brush::Brush(const QPen& pen) : d(new Private)
{
  d->pen = pen;
}

Brush::~Brush()
{
  delete d;
}

float Brush::drawPoint( OpenRijn::AbstractCanvas* _canvas, const OpenRijn::DrawingPoint& _pt)
{
  Canvas* canvas = static_cast<Canvas*>(_canvas);
  QPen p = d->pen;
  p.setWidth(p.width() * _pt.t);
  canvas->painter().setPen(p);
  canvas->painter().drawPoint(QPointF(_pt.x, _pt.y));
  return 0.0;
}

OpenRijn::DistanceInformation Brush::drawLine( OpenRijn::AbstractCanvas* _canvas, const OpenRijn::DrawingPoint& _pt1, const OpenRijn::DrawingPoint& _pt2, const OpenRijn::DistanceInformation& _information)
{
  Canvas* canvas = static_cast<Canvas*>(_canvas);
  QPen p = d->pen;
  p.setWidth(p.width() * (_pt1.t + _pt2.t) * 0.5);
  canvas->painter().setPen(p);
  canvas->painter().drawLine(QPointF(_pt1.x, _pt1.y), QPointF(_pt2.x, _pt2.y));
  return _information;
}

OpenRijn::DistanceInformation Brush::drawCurve(  OpenRijn::AbstractCanvas* _canvas, const OpenRijn::DrawingPoint& _pt1, float _x1, float _y1, float _x2, float _y2, const OpenRijn::DrawingPoint& _pt2, const OpenRijn::DistanceInformation& _information)
{
  Canvas* canvas = static_cast<Canvas*>(_canvas);
  QPen p = d->pen;
  p.setWidth(p.width() * (_pt1.t + _pt2.t) * 0.5);
  canvas->painter().setPen(p);
  QPainterPath path;
  path.moveTo(QPointF(_pt1.x, _pt1.y));
  path.cubicTo(QPointF(_pt2.x, _pt2.y), QPointF(_x1, _y1), QPointF(_x2, _y2));
  canvas->painter().drawPath(path);
  return _information;
}
