/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.CellCoverInfo;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedExpressionsElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedRangeElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfTableCellRange {
    private int mnStartRow;
    private int mnStartColumn;
    private int mnEndRow;
    private int mnEndColumn;
    private String msCellRangeName;
    private OdfTable maOwnerTable;
    private boolean mbSpreadsheet;

    OdfTableCellRange(OdfTable table, int startColumn, int startRow, int endColumn, int endRow) {
        int colIndex;
        int rowIndex;
        OdfTableCell cell;
        int i;
        this.maOwnerTable = table;
        OdfDocument doc = (OdfDocument)((OdfFileDom)this.maOwnerTable.getOdfElement().getOwnerDocument()).getDocument();
        if (doc instanceof OdfSpreadsheetDocument) {
            this.mbSpreadsheet = true;
        }
        this.mnStartColumn = startColumn;
        this.mnStartRow = startRow;
        this.mnEndColumn = endColumn;
        this.mnEndRow = endRow;
        List<CellCoverInfo> coverList = this.maOwnerTable.getCellCoverInfos(0, 0, this.maOwnerTable.getColumnCount() - 1, this.maOwnerTable.getRowCount() - 1);
        for (i = startColumn; i <= endColumn; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, i, startRow);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
        for (i = startColumn; i <= endColumn; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, i, endRow);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
        for (i = startRow + 1; i < endRow; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, startColumn, i);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
        for (i = startRow + 1; i < endRow; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, endColumn, i);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
    }

    OdfTableCellRange() {
    }

    public void merge() {
        OdfTableCell firstCell = this.maOwnerTable.getCellByPosition(this.mnStartColumn, this.mnStartRow);
        int rowCount = this.maOwnerTable.getRowCount();
        int colCount = this.maOwnerTable.getColumnCount();
        if (rowCount == this.mnEndRow - this.mnStartRow + 1 && colCount == this.mnEndColumn - this.mnStartColumn + 1 && !this.mbSpreadsheet) {
            if (firstCell.getOdfElement() instanceof TableTableCellElement) {
                TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            }
            for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
                for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                    OdfTableCell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                    if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                    firstCell.appendContentFrom(cellBase);
                }
            }
            this.maOwnerTable.removeRowsByIndex(1, this.maOwnerTable.getRowCount() - 1);
            this.maOwnerTable.removeColumnsByIndex(1, this.maOwnerTable.getColumnCount() - 1);
            OdfTableColumn firstColumn = this.maOwnerTable.getColumnByIndex(0);
            firstColumn.setWidth(this.maOwnerTable.getWidth());
            this.mnEndRow = this.mnStartRow;
            this.mnEndColumn = this.mnStartColumn;
            return;
        }
        if (rowCount == this.mnEndRow - this.mnStartRow + 1 && colCount > this.mnEndColumn - this.mnStartColumn + 1 && this.mnEndColumn - this.mnStartColumn > 0) {
            if (firstCell.getOdfElement() instanceof TableTableCellElement) {
                TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                firstCellElement.setTableNumberRowsSpannedAttribute(this.mnEndRow - this.mnStartRow + 1);
                firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            }
            for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
                for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                    OdfTableCell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                    if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                    firstCell.appendContentFrom(cellBase);
                    if (j != this.mnStartColumn || !(cellBase.getOdfElement() instanceof TableTableCellElement)) continue;
                    TableTableCellElement firstColumnCell = (TableTableCellElement)cellBase.getOdfElement();
                    TableCoveredTableCellElement coveredCell = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)firstColumnCell.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                    OdfTableRow parentRow = cellBase.getTableRow();
                    parentRow.getOdfElement().insertBefore(coveredCell, firstColumnCell);
                    parentRow.getOdfElement().removeChild(firstColumnCell);
                }
            }
            List<Long> widthList = this.getCellRangeWidthList();
            long nCellRangeWidth = widthList.get(widthList.size() - 1) - widthList.get(0);
            this.maOwnerTable.removeColumnsByIndex(this.mnStartColumn + 1, this.mnEndColumn - this.mnStartColumn);
            OdfTableColumn firstColumn = this.maOwnerTable.getColumnByIndex(this.mnStartColumn);
            firstColumn.setWidth(nCellRangeWidth);
            this.mnEndColumn = this.mnStartColumn;
            return;
        }
        if (rowCount > this.mnEndRow - this.mnStartRow + 1 && colCount == this.mnEndColumn - this.mnStartColumn + 1 && this.mnEndRow - this.mnStartRow > 0) {
            if (firstCell.getOdfElement() instanceof TableTableCellElement) {
                TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                firstCellElement.setTableNumberColumnsSpannedAttribute(this.mnEndColumn - this.mnStartColumn + 1);
                firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            }
            for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
                for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                    OdfTableCell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                    if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                    firstCell.appendContentFrom(cellBase);
                    if (i != this.mnStartRow || !(cellBase.getOdfElement() instanceof TableTableCellElement)) continue;
                    TableTableCellElement firstRowCell = (TableTableCellElement)cellBase.getOdfElement();
                    TableCoveredTableCellElement coveredCell = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)firstRowCell.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                    OdfTableRow parentRow = cellBase.getTableRow();
                    parentRow.getOdfElement().insertBefore(coveredCell, firstRowCell);
                    parentRow.getOdfElement().removeChild(firstRowCell);
                }
            }
            this.maOwnerTable.removeRowsByIndex(this.mnStartRow + 1, this.mnEndRow - this.mnStartRow);
            this.mnEndRow = this.mnStartRow;
            return;
        }
        if (firstCell.getOdfElement() instanceof TableTableCellElement) {
            TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
            firstCellElement.setTableNumberColumnsSpannedAttribute(this.mnEndColumn - this.mnStartColumn + 1);
            firstCellElement.setTableNumberRowsSpannedAttribute(this.mnEndRow - this.mnStartRow + 1);
            firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
        }
        for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
            for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                OdfTableCell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                if (cellBase.getOdfElement() instanceof TableTableCellElement) {
                    TableTableCellElement cell = (TableTableCellElement)cellBase.getOdfElement();
                    TableCoveredTableCellElement coveredCell = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)cell.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                    OdfTableRow parentRow = cellBase.getTableRow();
                    parentRow.getOdfElement().insertBefore(coveredCell, cell);
                    firstCell.appendContentFrom(cellBase);
                    cellBase.removeContent();
                    int repeatedNum = cell.getTableNumberColumnsRepeatedAttribute();
                    int num = this.mnEndColumn - j + 1 - repeatedNum;
                    if (num >= 0) {
                        coveredCell.setTableNumberColumnsRepeatedAttribute(repeatedNum);
                        parentRow.getOdfElement().removeChild(cell);
                        continue;
                    }
                    coveredCell.setTableNumberColumnsRepeatedAttribute(new Integer(this.mnEndColumn - j + 1));
                    cell.setTableNumberColumnsRepeatedAttribute(-num);
                    continue;
                }
                if (!(cellBase.getOdfElement() instanceof TableCoveredTableCellElement)) continue;
                try {
                    firstCell.appendContentFrom(cellBase);
                    cellBase.removeContent();
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(OdfTableCellRange.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    private List<Long> getCellRangeWidthList() {
        ArrayList<Long> list = new ArrayList<Long>();
        Long length = 0L;
        for (int i = 0; i < this.maOwnerTable.getColumnCount() - 1; ++i) {
            OdfTableColumn col = this.maOwnerTable.getColumnByIndex(i);
            int repeateNum = col.getColumnsRepeatedNumber();
            if (repeateNum == 1) {
                if (this.isColumnInCellRange(i)) {
                    list.add(length);
                }
                length = length + col.getWidth();
                continue;
            }
            for (int j = 0; j < repeateNum; ++j) {
                if (!this.isColumnInCellRange(i + j)) continue;
                list.add(length);
                length = length + col.getWidth();
            }
            i += repeateNum - 1;
        }
        list.add(length);
        return list;
    }

    List<Long> getVeticalSplitCellRangeWidthList(int splitNum) {
        List<CellCoverInfo> coverList = this.maOwnerTable.getCellCoverInfos(this.mnStartColumn, this.mnStartRow, this.mnEndColumn, this.mnEndRow);
        ArrayList<Long> tmpList = new ArrayList<Long>();
        List<Long> widthList = this.getCellRangeWidthList();
        for (int i = this.mnStartColumn; i < this.mnEndColumn + 1; ++i) {
            for (int j = this.mnStartRow; j < this.mnEndRow + 1; ++j) {
                Long width;
                if (this.maOwnerTable.isCoveredCellInOwnerTable(coverList, i, j) || tmpList.contains(width = widthList.get(i - this.mnStartColumn))) continue;
                tmpList.add(width);
            }
        }
        Object[] widthArray = (Long[])tmpList.toArray();
        Arrays.sort(widthArray);
        ArrayList<Long> rtnValues = new ArrayList<Long>();
        rtnValues.add((Long)widthArray[0]);
        for (int i = 1; i < widthArray.length; ++i) {
            Long colWidth = (Long)widthArray[i] - (Long)widthArray[i - 1];
            long unitWidth = colWidth / (long)splitNum;
            for (int j = 1; j < splitNum; ++j) {
                long eachWidth = unitWidth * (long)j + (Long)widthArray[i - 1];
                rtnValues.add(eachWidth);
            }
            rtnValues.add((Long)widthArray[i]);
        }
        return rtnValues;
    }

    public String getCellRangeName() {
        return this.msCellRangeName;
    }

    public void setCellRangeName(String cellRangeName) {
        try {
            OdfElement contentRoot = this.maOwnerTable.mDocument.getContentRoot();
            OdfFileDom contentDom = (OdfFileDom)this.maOwnerTable.getOdfElement().getOwnerDocument();
            TableNamedExpressionsElement nameExpress = (TableNamedExpressionsElement)OdfXMLFactory.newOdfElement(contentDom, OdfName.newName(OdfDocumentNamespace.TABLE, "named-expressions"));
            String startCellRange = "$" + this.maOwnerTable.getTableName() + "." + this.maOwnerTable.getAbsoluteCellAddress(this.mnStartColumn, this.mnStartRow);
            String endCellRange = "$" + this.maOwnerTable.getTableName() + "." + this.maOwnerTable.getAbsoluteCellAddress(this.mnEndColumn, this.mnEndRow);
            TableNamedRangeElement nameRange = nameExpress.newTableNamedRangeElement(startCellRange + ":" + endCellRange, cellRangeName);
            nameRange.setTableBaseCellAddressAttribute(endCellRange);
            contentRoot.appendChild(nameExpress);
            this.msCellRangeName = cellRangeName;
        }
        catch (Exception ex) {
            Logger.getLogger(OdfTableCellRange.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public OdfTable getTable() {
        return this.maOwnerTable;
    }

    public int getRowNumber() {
        return this.mnEndRow - this.mnStartRow + 1;
    }

    public int getColumnNumber() {
        return this.mnEndColumn - this.mnStartColumn + 1;
    }

    public OdfTableCell getCellByPosition(int clmIndex, int rowIndex) throws IndexOutOfBoundsException {
        return this.maOwnerTable.getCellByPosition(this.mnStartColumn + clmIndex, this.mnStartRow + rowIndex);
    }

    private boolean isColumnInCellRange(int colIndex) {
        return colIndex >= this.mnStartColumn && colIndex <= this.mnEndColumn;
    }

    public OdfTableCell getCellByPosition(String address) {
        return this.getCellByPosition(this.maOwnerTable.getColIndexFromCellAddress(address), this.maOwnerTable.getRowIndexFromCellAddress(address));
    }
}

