/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.odftoolkit.odfdom.incubator.search.Navigation;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextNavigation
extends Navigation {
    private String mMatchedElementName = "text:p,text:h";
    private String mPatternText;
    private OdfTextDocument mTextDocument;
    private TextSelection mCurrentSelectedItem;
    private String mCurrentText;
    private int mCurrentIndex;
    private boolean mbFinishFindInHeaderFooter;

    public TextNavigation(String pattern, OdfTextDocument doc) {
        this.mPatternText = pattern;
        this.mTextDocument = doc;
        this.mCurrentSelectedItem = null;
        this.mbFinishFindInHeaderFooter = false;
    }

    private TextSelection findInHeaderFooter(TextSelection selected) {
        OdfStylesDom styledom = null;
        OdfOfficeMasterStyles masterpage = null;
        OdfElement element = null;
        if (selected != null) {
            OdfElement containerElement = selected.getContainerElement();
            int index = selected.getIndex();
            OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
            String content = textProcessor.getText(containerElement);
            int nextIndex = -1;
            Pattern pattern = Pattern.compile(this.mPatternText);
            Matcher matcher = pattern.matcher(content);
            if (matcher.find(index + selected.getText().length())) {
                nextIndex = matcher.start();
                int eIndex = matcher.end();
                this.mCurrentText = content.substring(nextIndex, eIndex);
            }
            if (nextIndex != -1) {
                TextSelection item = new TextSelection(this.mCurrentText, selected.getContainerElement(), nextIndex);
                return item;
            }
        }
        try {
            styledom = this.mTextDocument.getStylesDom();
            NodeList list = styledom.getElementsByTagName("office:master-styles");
            if (styledom == null) {
                return null;
            }
            if (list.getLength() <= 0) {
                return null;
            }
            masterpage = (OdfOfficeMasterStyles)list.item(0);
            element = selected == null ? (OdfElement)this.getNextMatchElementInTree(masterpage, masterpage) : (OdfElement)this.getNextMatchElementInTree(selected.getContainerElement(), masterpage);
            if (element != null) {
                TextSelection item = new TextSelection(this.mCurrentText, element, this.mCurrentIndex);
                return item;
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private TextSelection findnext(TextSelection selected) {
        if (!this.mbFinishFindInHeaderFooter) {
            TextSelection styleselected = this.findInHeaderFooter(selected);
            if (styleselected != null) {
                return styleselected;
            }
            selected = null;
            this.mbFinishFindInHeaderFooter = true;
        }
        if (selected == null) {
            OdfElement element = null;
            try {
                element = (OdfElement)this.getNextMatchElement(this.mTextDocument.getContentRoot());
            }
            catch (Exception ex) {
                Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (element != null) {
                return new TextSelection(this.mCurrentText, element, this.mCurrentIndex);
            }
            return null;
        }
        OdfElement containerElement = selected.getContainerElement();
        int index = selected.getIndex();
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        String content = textProcessor.getText(containerElement);
        int nextIndex = -1;
        Pattern pattern = Pattern.compile(this.mPatternText);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find(index + selected.getText().length())) {
            nextIndex = matcher.start();
            int eIndex = matcher.end();
            this.mCurrentText = content.substring(nextIndex, eIndex);
        }
        if (nextIndex != -1) {
            TextSelection item = new TextSelection(this.mCurrentText, selected.getContainerElement(), nextIndex);
            return item;
        }
        OdfElement element = (OdfElement)this.getNextMatchElement(containerElement);
        if (element != null) {
            TextSelection item = new TextSelection(this.mCurrentText, element, this.mCurrentIndex);
            return item;
        }
        return null;
    }

    @Override
    public Selection getCurrentItem() {
        Selection.SelectionManager.registerItem(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem;
    }

    @Override
    public boolean hasNext() {
        this.mCurrentSelectedItem = this.findnext(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem != null;
    }

    @Override
    public boolean match(Node element) {
        if (element instanceof OdfElement && this.mMatchedElementName.indexOf(element.getNodeName()) != -1) {
            OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
            String content = textProcessor.getText(element);
            Pattern pattern = Pattern.compile(this.mPatternText);
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                this.mCurrentIndex = matcher.start();
                int eIndex = matcher.end();
                this.mCurrentText = content.substring(this.mCurrentIndex, eIndex);
                return true;
            }
        }
        return false;
    }
}

