/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * LeastFrequentlyUsedCache.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.cache;

import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.base.util.LFUMap;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class LeastFrequentlyUsedCache implements FontCache
{
  private LFUMap map;

  public LeastFrequentlyUsedCache(final int cacheSize)
  {
    // having at least 3 entries saves me a lot of coding and thus gives more performance ..
    this.map = new LFUMap(cacheSize);
  }

  public synchronized FontMetrics getFontMetrics(final FontKey fontKey)
  {
    return (FontMetrics) map.get(fontKey);
  }

  public synchronized void putFontMetrics(final FontKey key, final FontMetrics metrics)
  {
    map.put(key, metrics);
  }

  public void commit()
  {
    // no op, as we have no deeper level.
  }
}
