/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * CompoundFontIdentifier.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.merge;

import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

/**
 * Creation-Date: 20.07.2007, 19:31:00
 *
 * @author Thomas Morgner
 */
public class CompoundFontIdentifier implements FontIdentifier
{
  private FontIdentifier identifier;
  private FontRegistry registry;
  private boolean boldSpecified;
  private boolean italicsSpecified;

  public CompoundFontIdentifier(final FontIdentifier identifier,
                                final FontRegistry registry,
                                final boolean boldSpecified,
                                final boolean italicsSpecified)
  {
    this.boldSpecified = boldSpecified;
    this.italicsSpecified = italicsSpecified;
    if (registry == null)
    {
      throw new NullPointerException();
    }
    if (identifier == null)
    {
      throw new NullPointerException();
    }
    this.registry = registry;
    this.identifier = identifier;
  }

  public FontIdentifier getIdentifier()
  {
    return identifier;
  }

  public boolean isBoldSpecified()
  {
    return boldSpecified;
  }

  public boolean isItalicsSpecified()
  {
    return italicsSpecified;
  }

  public boolean equals(final Object o)
  {
    if (this == o)
    {
      return true;
    }
    if (o == null || getClass() != o.getClass())
    {
      return false;
    }

    final CompoundFontIdentifier that = (CompoundFontIdentifier) o;

    if (!identifier.equals(that.identifier))
    {
      return false;
    }
    if (!registry.equals(that.registry))
    {
      return false;
    }

    return true;
  }

  public int hashCode()
  {
    int result = identifier.hashCode();
    result = 29 * result + registry.hashCode();
    return result;
  }

  public boolean isScalable()
  {
    return identifier.isScalable();
  }

  public FontType getFontType()
  {
    return identifier.getFontType();
  }

  public FontRegistry getRegistry()
  {
    return registry;
  }
}
