/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * DefaultFontStorage.java
 * ------------
 */
package org.pentaho.reporting.libraries.fonts.registry;

import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.base.util.DebugLog;

/**
 * Creation-Date: 15.12.2005, 18:07:53
 *
 * @author Thomas Morgner
 */
public class DefaultFontStorage implements FontStorage
{
  private FirstLevelFontCache knownMetrics;
  private FontRegistry registry;
  private FontMetricsFactory metricsFactory;
  private FontKey lookupKey;
  private int hits;
  private int misses;

  public DefaultFontStorage(final FontRegistry registry)
  {
    this.knownMetrics = new FirstLevelFontCache(registry.getSecondLevelCache());
    this.registry = registry;
    this.metricsFactory = registry.createMetricsFactory();
    this.lookupKey = new FontKey();
  }

  public FontRegistry getFontRegistry()
  {
    return registry;
  }

  public FontMetrics getFontMetrics(final FontIdentifier record,
                                    final FontContext context)
  {
    if (record == null)
    {
      throw new NullPointerException();
    }
    if (context == null)
    {
      throw new NullPointerException();
    }

    lookupKey.setAliased(context.isAntiAliased());
    lookupKey.setFontSize(context.getFontSize());
    lookupKey.setIdentifier(record);
    lookupKey.setFractional(context.isFractionalMetrics());

    final FontMetrics cachedMetrics = knownMetrics.getFontMetrics(lookupKey);
    if (cachedMetrics != null)
    {
      hits += 1;
      return cachedMetrics;
    }

    misses += 1;
    final FontKey key = new FontKey(record, context.isAntiAliased(),
        context.isFractionalMetrics(), context.getFontSize());
    final FontMetrics metrics = metricsFactory.createMetrics(record, context);
    knownMetrics.putFontMetrics(key, metrics);
    return metrics;
  }

  public void commit()
  {
    DebugLog.log("Font-Storage: hits=" + hits + ", misses=" + misses);
    knownMetrics.commit();
  }
}
