package org.pentaho.reporting.libraries.repository.email;

import java.io.OutputStream;

import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;

/**
 * Creation-Date: 17.09.2008, 15:00:00
 *
 * @author Pedro Alves - WebDetails
 */
public class EmailRepository implements Repository
{

  private MimeRegistry mimeRegistry;
  private EmailContentLocation root;
  private HtmlEmail htmlEmail;

  public EmailRepository(final MimeRegistry mimeRegistry) throws ContentIOException
  {
    if (mimeRegistry == null)
    {
      throw new NullPointerException();
    }

    this.mimeRegistry = mimeRegistry;
    this.root = new EmailContentLocation(this, null, "");
    try
    {

      htmlEmail = new HtmlEmail();
      htmlEmail.setHostName("127.0.0.1");
      htmlEmail.addTo("foo@127.0.0.1", "Dummy To");
      htmlEmail.setFrom("bar@127.0.0.1", "Dummy From");
      htmlEmail.setSubject("Subject");
    }
    catch (EmailException ex)
    {
      throw new ContentIOException("Error creating email", ex);
    }


  }

  public EmailRepository(final HtmlEmail htmlEmail, final MimeRegistry mimeRegistry) throws ContentIOException
  {
    if (htmlEmail == null)
    {
      throw new NullPointerException();
    }
    if (mimeRegistry == null)
    {
      throw new NullPointerException();
    }
    this.htmlEmail = htmlEmail;
    this.mimeRegistry = mimeRegistry;
    this.root = new EmailContentLocation(this, null, "");

  }

  public EmailRepository(final HtmlEmail htmlEmail) throws ContentIOException
  {
    this(htmlEmail, new DefaultMimeRegistry());

  }

  public EmailRepository() throws ContentIOException
  {
    this(new DefaultMimeRegistry());

  }

  public ContentLocation getRoot() throws ContentIOException
  {
    return root;
  }

  public MimeRegistry getMimeRegistry()
  {
    return mimeRegistry;
  }

  public void writeEmail(final OutputStream out) throws ContentIOException
  {
    try
    {
      htmlEmail.buildMimeMessage();
      htmlEmail.getMimeMessage().getContentID();
      htmlEmail.getMimeMessage().writeTo(out);
    }
    catch (Exception ex)
    {
      throw new ContentIOException(ex.getMessage(), ex);
    }

  }

  public HtmlEmail getHtmlEmail()
  {
    return htmlEmail;
  }
}
