/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// autogenerated file with codegen.pl

#include "sal/config.h"
#include "sal/precppunit.hxx"

#include "cppunit/TestAssert.h"
#include "cppunit/TestFixture.h"
#include "cppunit/extensions/HelperMacros.h"

#include <basegfx/vector/b2isize.hxx>
#include <basegfx/range/b2ibox.hxx>
#include <basegfx/point/b2ipoint.hxx>
#include <basegfx/polygon/b2dpolygon.hxx>
#include <basegfx/polygon/b2dpolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <basegfx/polygon/b2dpolypolygontools.hxx>

#include <basebmp/color.hxx>
#include <basebmp/scanlineformats.hxx>
#include <basebmp/bitmapdevice.hxx>
#include "tools.hxx"

using namespace ::basebmp;

namespace
{
class BmpMaskTest : public CppUnit::TestFixture
{
private:
    BitmapDeviceSharedPtr mpDevice1bpp;
    BitmapDeviceSharedPtr mpMaskBmp1bpp;
    BitmapDeviceSharedPtr mpBmp1bpp;
    BitmapDeviceSharedPtr mpDevice32bpp;
    BitmapDeviceSharedPtr mpBmp32bpp;

    void implTestBmpBasics(const BitmapDeviceSharedPtr& rDevice,
                           const BitmapDeviceSharedPtr& rBmp)
    {
        rDevice->clear(Color(0));
        const Color aCol(0xFFFFFFFF);

        const basegfx::B2IBox aSourceRect(0,0,10,10);
        const basegfx::B2IBox aDestAll(0,0,10,10);

        rDevice->drawMaskedBitmap(
            rBmp,
            mpMaskBmp1bpp,
            aSourceRect,
            aDestAll,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 30",
                               countPixel( rDevice, aCol ) == 30);
    }

    void implTestBmpScaledClip(const BitmapDeviceSharedPtr& rDevice,
                               const BitmapDeviceSharedPtr& rBmp)
    {
        rDevice->clear(Color(0));
        const Color aCol(0xFFFFFFFF);

        const basegfx::B2IBox aSourceRect(0,0,10,10);
        const basegfx::B2IBox aDestLeftTop(0,0,6,6);

        rDevice->drawMaskedBitmap(
            rBmp,
            mpMaskBmp1bpp,
            aSourceRect,
            aDestLeftTop,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 12",
                               countPixel( rDevice, aCol ) == 12);
    }

public:
    void setUp()
    {
        const basegfx::B2ISize aSize(10,10);
        mpDevice1bpp = createBitmapDevice( aSize,
                                           true,
                                           Format::ONE_BIT_MSB_PAL );
        mpDevice32bpp = createBitmapDevice( aSize,
                                            true,
                                            Format::THIRTYTWO_BIT_TC_MASK );

        mpMaskBmp1bpp = createBitmapDevice( aSize,
                                            true,
                                            Format::ONE_BIT_MSB_GREY );

        mpBmp1bpp = createBitmapDevice( aSize,
                                        true,
                                        Format::ONE_BIT_MSB_PAL );
        mpBmp32bpp = createBitmapDevice( aSize,
                                         true,
                                         Format::THIRTYTWO_BIT_TC_MASK );

        ::rtl::OUString aSvg( "m 0 0h5v10h5v-5h-10z" );

        basegfx::B2DPolyPolygon aPoly;
        basegfx::tools::importFromSvgD( aPoly, aSvg );
        const Color aColWhite(0xFFFFFFFF);
        const Color aColBlack(0);
        mpBmp1bpp->fillPolyPolygon(
            aPoly,
            aColWhite,
            DrawMode_PAINT );
        mpBmp32bpp->fillPolyPolygon(
            aPoly,
            aColWhite,
            DrawMode_PAINT );

        aSvg = ::rtl::OUString( "m 0 0 h6 v10 h-6z" );

        aPoly.clear();
        basegfx::tools::importFromSvgD( aPoly, aSvg );
        mpMaskBmp1bpp->clear(aColWhite);
        mpMaskBmp1bpp->fillPolyPolygon(
            aPoly,
            aColBlack,
            DrawMode_PAINT );
    }

    void testBmpBasics()
    {
        implTestBmpBasics( mpDevice1bpp, mpBmp1bpp );
        implTestBmpBasics( mpDevice32bpp, mpBmp32bpp );
    }

    void testBmpClip()
    {
        implTestBmpScaledClip( mpDevice1bpp, mpBmp1bpp );
        implTestBmpScaledClip( mpDevice32bpp, mpBmp32bpp );
    }

    // Change the following lines only, if you add, remove or rename
    // member functions of the current class,
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(BmpMaskTest);
    CPPUNIT_TEST(testBmpBasics);
    CPPUNIT_TEST(testBmpClip);
    CPPUNIT_TEST_SUITE_END();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BmpMaskTest);
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
