/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef SVX_SVXCOMMANDS_HRC
#define SVX_SVXCOMMANDS_HRC

#define CMD_SID_INET_DLG                            ".uno:InternetDialog"
#define CMD_SID_FM_RECORD_ABSOLUTE                  ".uno:AbsoluteRecord"
#define CMD_SID_FM_ADD_FIELD                        ".uno:AddField"
#define CMD_SID_FM_ADDTABLE                         ".uno:AddTable"
#define CMD_SID_OBJECT_ALIGN_CENTER                 ".uno:AlignCenter"
#define CMD_SID_OBJECT_ALIGN_DOWN                   ".uno:AlignDown"
#define CMD_SID_OBJECT_ALIGN_LEFT                   ".uno:ObjectAlignLeft"
#define CMD_SID_ATTR_PARA_ADJUST                    ".uno:Alignment"
#define CMD_SID_OBJECT_ALIGN_MIDDLE                 ".uno:AlignMiddle"
#define CMD_SID_OBJECT_ALIGN_RIGHT                  ".uno:ObjectAlignRight"
#define CMD_SID_OBJECT_ALIGN_UP                     ".uno:AlignUp"
#define CMD_SID_DRAW_ARC                            ".uno:Arc"
#define CMD_SID_3D_ASSIGN                           ".uno:Assign3D"
#define CMD_SID_FM_AUTOCONTROLFOCUS                 ".uno:AutoControlFocus"
#define CMD_SID_FM_AUTOFILTER                       ".uno:AutoFilter"
#define CMD_SID_AUTOFORMAT                          ".uno:AutoFormat"
#define CMD_SID_TABLE_STYLE                         ".uno:TableStyle"
#define CMD_SID_TABLE_STYLE_SETTINGS                ".uno:TableStyleSettings"
#define CMD_SID_TABLEDESIGN                         ".uno:TableDesign"
#define CMD_SID_BACKGROUND_COLOR                    ".uno:BackgroundColor"
#define CMD_SID_ATTR_BRUSH                          ".uno:BackgroundPattern"
#define CMD_SID_BACKGROUND_PATTERN                  ".uno:BackgroundPatternController"
#define CMD_SID_DRAW_BEZIER_NOFILL                  ".uno:Bezier_Unfilled"
#define CMD_SID_BEZIER_APPEND                       ".uno:BezierAppend"
#define CMD_SID_BEZIER_CLOSE                        ".uno:BezierClose"
#define CMD_SID_BEZIER_CONVERT                      ".uno:BezierConvert"
#define CMD_SID_BEZIER_CUTLINE                      ".uno:BezierCutLine"
#define CMD_SID_BEZIER_DELETE                       ".uno:BezierDelete"
#define CMD_SID_BEZIER_EDGE                         ".uno:BezierEdge"
#define CMD_SID_BEZIER_ELIMINATE_POINTS             ".uno:BezierEliminatePoints"
#define CMD_SID_DRAW_BEZIER_FILL                    ".uno:BezierFill"
#define CMD_SID_BEZIER_INSERT                       ".uno:BezierInsert"
#define CMD_SID_BEZIER_MOVE                         ".uno:BezierMove"
#define CMD_SID_BEZIER_SMOOTH                       ".uno:BezierSmooth"
#define CMD_SID_BEZIER_SYMMTR                       ".uno:BezierSymmetric"
#define CMD_SID_BEZIERTO                            ".uno:BezierTo"
#define CMD_SID_BMPMASK                             ".uno:BmpMask"
#define CMD_SID_BMPMASK_EXEC                        ".uno:BmpMaskExec"
#define CMD_SID_BMPMASK_PIPETTE                     ".uno:BmpMaskPipette"
#define CMD_SID_ATTR_CHAR_WEIGHT                    ".uno:Bold"
#define CMD_SID_ATTR_CHAR_LATIN_WEIGHT              ".uno:BoldLatin"
#define CMD_SID_ATTR_CHAR_CJK_WEIGHT                ".uno:BoldCJK"
#define CMD_SID_ATTR_CHAR_CTL_WEIGHT                ".uno:BoldCTL"
#define CMD_SID_BORDER_OBJECT                       ".uno:Border"
#define CMD_SID_ATTR_BORDER_INNER                   ".uno:BorderInner"
#define CMD_SID_ATTR_BORDER_OUTER                   ".uno:BorderOuter"
#define CMD_SID_ATTR_BORDER                         ".uno:SetBorderStyle"
#define CMD_SID_FRAME_TO_TOP                        ".uno:BringToFront"
#define CMD_SID_DRAW_CAPTION                        ".uno:DrawCaption"
#define CMD_SID_ATTR_CHAR_CASEMAP                   ".uno:CaseMap"
#define CMD_SID_ATTR_PARA_ADJUST_CENTER             ".uno:CenterPara"
#define CMD_SID_TRANSLITERATE_FULLWIDTH             ".uno:ChangeCaseToFullWidth"
#define CMD_SID_TRANSLITERATE_HALFWIDTH             ".uno:ChangeCaseToHalfWidth"
#define CMD_SID_TRANSLITERATE_HIRAGANA              ".uno:ChangeCaseToHiragana"
#define CMD_SID_TRANSLITERATE_KATAGANA              ".uno:ChangeCaseToKatakana"
#define CMD_SID_TRANSLITERATE_LOWER                 ".uno:ChangeCaseToLower"
#define CMD_SID_TRANSLITERATE_UPPER                 ".uno:ChangeCaseToUpper"
#define CMD_SID_FM_CHANGECONTROLTYPE                ".uno:ChangeControlType"
#define CMD_SID_ATTR_CHAR_FONT                      ".uno:CharFontName"
#define CMD_SID_ATTR_CHAR_LATIN_FONT                ".uno:CharFontNameLatin"
#define CMD_SID_ATTR_CHAR_CJK_FONT                  ".uno:CharFontNameCJK"
#define CMD_SID_ATTR_CHAR_CTL_FONT                  ".uno:CharFontNameCTL"
#define CMD_SID_INSERT_CHECKBOX                     ".uno:Checkbox"
#define CMD_SID_FM_CHECKBOX                         ".uno:CheckBox"
#define CMD_SID_CHOOSE_CONTROLS                     ".uno:ChooseControls"
#define CMD_SID_CHOOSE_POLYGON                      ".uno:ChoosePolygon"
#define CMD_SID_DRAW_CIRCLE                         ".uno:Circle"
#define CMD_SID_DRAW_CIRCLE_NOFILL                  ".uno:Circle_Unfilled"
#define CMD_SID_DRAW_CIRCLEARC                      ".uno:CircleArc"
#define CMD_SID_DRAW_CIRCLECUT                      ".uno:CircleCut"
#define CMD_SID_DRAW_CIRCLECUT_NOFILL               ".uno:CircleCut_Unfilled"
#define CMD_SID_DRAW_CIRCLEPIE                      ".uno:CirclePie"
#define CMD_SID_DRAW_CIRCLEPIE_NOFILL               ".uno:CirclePie_Unfilled"
#define CMD_SID_OUTLINE_DELETEALL                   ".uno:ClearOutline"
#define CMD_SID_ATTR_CHAR_COLOR                     ".uno:Color"
#define CMD_SID_COLOR_CONTROL                       ".uno:ColorControl"
#define CMD_SID_FM_COMBOBOX                         ".uno:ComboBox"
#define CMD_SID_FM_NAVIGATIONBAR                    ".uno:NavigationBar"
#define CMD_SID_INSERT_COMBOBOX                     ".uno:Combobox"
#define CMD_SID_FM_CONFIG                           ".uno:Config"
#define CMD_SID_FM_MORE_CONTROLS                    ".uno:MoreControls"
#define CMD_SID_FM_FORM_DESIGN_TOOLS                ".uno:FormDesignTools"
#define CMD_SID_CONTOUR_DLG                         ".uno:ContourDialog"
#define CMD_SID_CONTOUR_EXEC                        ".uno:ContourExecute"
#define CMD_SID_FM_CTL_PROPERTIES                   ".uno:ControlProperties"
#define CMD_SID_FM_CONVERTTO_BUTTON                 ".uno:ConvertToButton"
#define CMD_SID_FM_CONVERTTO_CHECKBOX               ".uno:ConvertToCheckBox"
#define CMD_SID_FM_CONVERTTO_COMBOBOX               ".uno:ConvertToCombo"
#define CMD_SID_FM_CONVERTTO_CURRENCY               ".uno:ConvertToCurrency"
#define CMD_SID_FM_CONVERTTO_DATE                   ".uno:ConvertToDate"
#define CMD_SID_FM_CONVERTTO_EDIT                   ".uno:ConvertToEdit"
#define CMD_SID_FM_CONVERTTO_FILECONTROL            ".uno:ConvertToFileControl"
#define CMD_SID_FM_CONVERTTO_FIXEDTEXT              ".uno:ConvertToFixed"
#define CMD_SID_FM_CONVERTTO_FORMATTED              ".uno:ConvertToFormatted"
#define CMD_SID_FM_CONVERTTO_SCROLLBAR              ".uno:ConvertToScrollBar"
#define CMD_SID_FM_CONVERTTO_SPINBUTTON             ".uno:ConvertToSpinButton"
#define CMD_SID_FM_CONVERTTO_GROUPBOX               ".uno:ConvertToGroup"
#define CMD_SID_FM_CONVERTTO_IMAGEBUTTON            ".uno:ConvertToImageBtn"
#define CMD_SID_FM_CONVERTTO_IMAGECONTROL           ".uno:ConvertToImageControl"
#define CMD_SID_FM_CONVERTTO_LISTBOX                ".uno:ConvertToList"
#define CMD_SID_FM_CONVERTTO_NUMERIC                ".uno:ConvertToNumeric"
#define CMD_SID_FM_CONVERTTO_PATTERN                ".uno:ConvertToPattern"
#define CMD_SID_FM_CONVERTTO_RADIOBUTTON            ".uno:ConvertToRadio"
#define CMD_SID_FM_CONVERTTO_TIME                   ".uno:ConvertToTime"
#define CMD_SID_FM_CONVERTTO_NAVIGATIONBAR          ".uno:ConvertToNavigationBar"
#define CMD_SID_FM_COUNTALL                         ".uno:CountAll"
#define CMD_SID_FM_CREATE_CONTROL                   ".uno:CreateControl"
#define CMD_SID_INSERT_CURRENCYFIELD                ".uno:InsertCurrencyField"
#define CMD_SID_FM_CURRENCYFIELD                    ".uno:CurrencyField"
#define CMD_SID_DASH                                ".uno:Dash"
#define CMD_SID_INSERT_DATEFIELD                    ".uno:AddDateField"
#define CMD_SID_FM_DATEFIELD                        ".uno:DateField"
#define CMD_FN_NUM_BULLET_ON                        ".uno:DefaultBullet"
#define CMD_SID_FM_RECORD_DELETE                    ".uno:DeleteRecord"
#define CMD_SID_FM_DESIGN_MODE                      ".uno:SwitchControlDesignMode"
#define CMD_SID_DISTRIBUTE_DLG                      ".uno:DistributeSelection"
#define CMD_SID_DRAW_SELECT                         ".uno:DrawSelect"
#define CMD_SID_INSERT_DRAW                         ".uno:InsertDraw"
#define CMD_SID_DSBROWSER_EXPLORER                  ".uno:DSBrowserExplorer"
#define CMD_SID_FM_EDIT                             ".uno:Edit"
#define CMD_SID_INSERT_EDIT                         ".uno:InsertEdit"
#define CMD_SID_DRAW_ELLIPSE                        ".uno:Ellipse"
#define CMD_SID_DRAW_ELLIPSE_NOFILL                 ".uno:Ellipse_Unfilled"
#define CMD_SID_DRAW_ELLIPSECUT                     ".uno:EllipseCut"
#define CMD_SID_DRAW_ELLIPSECUT_NOFILL              ".uno:EllipseCut_Unfilled"
#define CMD_SID_ENTER_GROUP                         ".uno:EnterGroup"
#define CMD_SID_ATTR_CHAR_ESCAPEMENT                ".uno:Escapement"
#define CMD_SID_FM_FIELDS_CONTROL                   ".uno:FieldController"
#define CMD_SID_FM_FILECONTROL                      ".uno:FileControl"
#define CMD_SID_INSERT_FILECONTROL                  ".uno:InsertFileControl"
#define CMD_SID_INSERT_TREECONTROL                  ".uno:InsertTreeControl"
#define CMD_SID_ATTR_FILL_BITMAP                    ".uno:FillBitmap"
#define CMD_SID_ATTR_FILL_COLOR                     ".uno:FillColor"
#define CMD_SID_ATTR_FILL_GRADIENT                  ".uno:FillGradient"
#define CMD_SID_ATTR_FILL_HATCH                     ".uno:FillHatch"
#define CMD_SID_ATTR_FILL_STYLE                     ".uno:FillStyle"
#define CMD_SID_FM_FILTERCRIT                       ".uno:FilterCrit"
#define CMD_SID_FM_RECORD_FIRST                     ".uno:FirstRecord"
#define CMD_SID_ATTR_FLASH                          ".uno:Flash"
#define CMD_SID_FM_FMEXPLORER_CONTROL               ".uno:FmExplorerController"
#define CMD_SID_FM_FILTER_NAVIGATOR_CONTROL         ".uno:FmFilterNavigatorController"
#define CMD_SID_CHAR_DLG                            ".uno:FontDialog"
#define CMD_SID_ATTR_CHAR_FONTHEIGHT                ".uno:FontHeight"
#define CMD_SID_ATTR_CHAR_LATIN_FONTHEIGHT          ".uno:FontHeighLatin"
#define CMD_SID_ATTR_CHAR_CJK_FONTHEIGHT            ".uno:FontHeightCJK"
#define CMD_SID_ATTR_CHAR_CTL_FONTHEIGHT            ".uno:FontHeightCTL"
#define CMD_SID_FONTWORK                            ".uno:FontWork"
#define CMD_SID_FORMTEXT_ADJUST                     ".uno:FontWorkTextAdjust"
#define CMD_SID_FORMTEXT_STDFORM                    ".uno:FontWorkTextClearAttributes"
#define CMD_SID_FORMTEXT_DISTANCE                   ".uno:FontWorkTextDistance"
#define CMD_SID_FORMTEXT_MIRROR                     ".uno:FontWorkTextMirror"
#define CMD_SID_FORMTEXT_OUTLINE                    ".uno:FontWorkTextOutline"
#define CMD_SID_FORMTEXT_SHADOW                     ".uno:FontWorkTextShadow"
#define CMD_SID_FORMTEXT_SHDWCOLOR                  ".uno:FontWorkTextShadowColor"
#define CMD_SID_FORMTEXT_SHDWXVAL                   ".uno:FontWorkTextShadowXVal"
#define CMD_SID_FORMTEXT_SHDWYVAL                   ".uno:FontWorkTextShadowYVal"
#define CMD_SID_FORMTEXT_START                      ".uno:FontWorkTextStart"
#define CMD_SID_FORMTEXT_STYLE                      ".uno:FontWorkTextStyle"
#define CMD_SID_ATTRIBUTES_AREA                     ".uno:FormatArea"
#define CMD_SID_FORMTEXT_HIDEFORM                   ".uno:FormatFontWorkClose"
#define CMD_SID_GROUP                               ".uno:FormatGroup"
#define CMD_SID_ATTRIBUTES_LINE                     ".uno:FormatLine"
#define CMD_SID_FM_FORMATTEDFIELD                   ".uno:FormattedField"
#define CMD_SID_FM_SCROLLBAR                        ".uno:ScrollBar"
#define CMD_SID_FM_SPINBUTTON                       ".uno:SpinButton"
#define CMD_SID_INSERT_FORMATTEDFIELD               ".uno:InsertFormattedField"
#define CMD_SID_UNGROUP                             ".uno:FormatUngroup"
#define CMD_SID_FM_FILTER_START                     ".uno:FormFilter"
#define CMD_SID_FM_FORM_FILTERED                    ".uno:FormFiltered"
#define CMD_SID_FM_FILTER_EXECUTE                   ".uno:FormFilterExecute"
#define CMD_SID_FM_FILTER_EXIT                      ".uno:FormFilterExit"
#define CMD_SID_FM_FILTER_NAVIGATOR                 ".uno:FormFilterNavigator"
#define CMD_SID_FM_PROPERTIES                       ".uno:FormProperties"
#define CMD_SID_DRAW_FREELINE                       ".uno:Freeline"
#define CMD_SID_DRAW_FREELINE_NOFILL                ".uno:Freeline_Unfilled"
#define CMD_SID_ATTR_AUTO_COLOR_INVALID             ".uno:AutoColorInvalid"
#define CMD_SID_GALLERY                             ".uno:Gallery"
#define CMD_SID_GALLERY_ENABLE_ADDCOPY              ".uno:GalleryEnableAddCopy"
#define CMD_SID_GETREDOSTRINGS                      ".uno:GetRedoStrings"
#define CMD_SID_GETUNDOSTRINGS                      ".uno:GetUndoStrings"
#define CMD_SID_ATTR_GRAF_CROP                      ".uno:GrafAttrCrop"
#define CMD_SID_ATTR_GRAF_BLUE                      ".uno:GrafBlue"
#define CMD_SID_ATTR_GRAF_CONTRAST                  ".uno:GrafContrast"
#define CMD_SID_ATTR_GRAF_GAMMA                     ".uno:GrafGamma"
#define CMD_SID_ATTR_GRAF_GREEN                     ".uno:GrafGreen"
#define CMD_SID_ATTR_GRAF_INVERT                    ".uno:GrafInvert"
#define CMD_SID_ATTR_GRAF_LUMINANCE                 ".uno:GrafLuminance"
#define CMD_SID_ATTR_GRAF_MODE                      ".uno:GrafMode"
#define CMD_SID_ATTR_GRAF_RED                       ".uno:GrafRed"
#define CMD_SID_ATTR_GRAF_TRANSPARENCE              ".uno:GrafTransparence"
#define CMD_SID_GRFFILTER_INVERT                    ".uno:GraphicFilterInvert"
#define CMD_SID_GRFFILTER_MOSAIC                    ".uno:GraphicFilterMosaic"
#define CMD_SID_GRFFILTER_POPART                    ".uno:GraphicFilterPopart"
#define CMD_SID_GRFFILTER_POSTER                    ".uno:GraphicFilterPoster"
#define CMD_SID_GRFFILTER_EMBOSS                    ".uno:GraphicFilterRelief"
#define CMD_SID_GRFFILTER_REMOVENOISE               ".uno:GraphicFilterRemoveNoise"
#define CMD_SID_GRFFILTER_SEPIA                     ".uno:GraphicFilterSepia"
#define CMD_SID_GRFFILTER_SHARPEN                   ".uno:GraphicFilterSharpen"
#define CMD_SID_GRFFILTER_SMOOTH                    ".uno:GraphicFilterSmooth"
#define CMD_SID_GRFFILTER_SOBEL                     ".uno:GraphicFilterSobel"
#define CMD_SID_GRFFILTER_SOLARIZE                  ".uno:GraphicFilterSolarize"
#define CMD_SID_GRFFILTER                           ".uno:GraphicFilterToolbox"
#define CMD_SID_FM_DBGRID                           ".uno:Grid"
#define CMD_SID_GRID_USE                            ".uno:GridUse"
#define CMD_SID_GRID_VISIBLE                        ".uno:GridVisible"
#define CMD_SID_OUTLINE_MAKE                        ".uno:Group"
#define CMD_SID_FM_GROUPBOX                         ".uno:GroupBox"
#define CMD_SID_INSERT_GROUPBOX                     ".uno:Groupbox"
#define CMD_SID_RULER_LR_MIN_MAX                    ".uno:HeaderFooterBorder"
#define CMD_SID_HELPLINES_MOVE                      ".uno:HelplinesMove"
#define CMD_SID_INSERT_HFIXEDLINE                   ".uno:HFixedLine"
#define CMD_SID_OUTLINE_HIDE                        ".uno:HideDetail"
#define CMD_SID_INSERT_HSCROLLBAR                   ".uno:HScrollbar"
#define CMD_SID_HYPERLINK_GETLINK                   ".uno:Hyperlink"
#define CMD_SID_FM_IMAGEBUTTON                      ".uno:Imagebutton"
#define CMD_SID_FM_IMAGECONTROL                     ".uno:ImageControl"
#define CMD_SID_INSERT_IMAGECONTROL                 ".uno:InsertImageControl"
#define CMD_SID_IMAP                                ".uno:ImageMapDialog"
#define CMD_SID_IMAP_EXEC                           ".uno:ImageMapExecute"
#define CMD_SID_3D_INIT                             ".uno:Init3D"
#define CMD_SID_OBJECTRESIZE                        ".uno:InPlaceObjectResize"
#define CMD_SID_ENTER_STRING                        ".uno:EnterString"
#define CMD_SID_INSERT_POSTIT                       ".uno:InsertAnnotation"
#define CMD_SID_SHOW_POSTIT                         ".uno:ShowAnnotations"
#define CMD_SID_REPLYTO_POSTIT                      ".uno:ReplyToAnnotation"
#define CMD_SID_DELETE_POSTIT                       ".uno:DeleteAnnotation"
#define CMD_SID_DELETEALL_POSTIT                    ".uno:DeleteAllAnnotation"
#define CMD_SID_DELETEALLBYAUTHOR_POSTIT            ".uno:DeleteAllAnnotationByAuthor"
#define CMD_SID_NEXT_POSTIT                         ".uno:NextAnnotation"
#define CMD_SID_PREVIOUS_POSTIT                     ".uno:PreviousAnnotation"
#define CMD_SID_INSERT_APPLET                       ".uno:InsertApplet"
#define CMD_SID_GALLERY_FORMATS                     ".uno:InsertGalleryPic"
#define CMD_SID_INSERT_GRAPHIC                      ".uno:InsertGraphic"
#define CMD_SID_INSERT_IMAGE                        ".uno:InsertImage"
#define CMD_SID_INSERT_MATH                         ".uno:InsertMath"
#define CMD_SID_ATTR_INSERT                         ".uno:InsertMode"
#define CMD_FN_NUM_NUMBERING_ON                     ".uno:DefaultNumbering"
#define CMD_SID_INSERT_OBJECT                       ".uno:InsertObject"
#define CMD_SID_INSERT_DIAGRAM                      ".uno:InsertObjectChart"
#define CMD_SID_INSERT_PLUGIN                       ".uno:InsertPlugin"
#define CMD_SID_INSERT_SOUND                        ".uno:InsertSound"
#define CMD_SID_CHARMAP                             ".uno:InsertSymbol"
#define CMD_SID_ATTR_TABLE                          ".uno:InsertSpreadsheet"
#define CMD_SID_INSERT_TABLE                        ".uno:InsertTable"
#define CMD_SID_INSERT_FRAME                        ".uno:InsertTextFrame"
#define CMD_SID_INSERT_VIDEO                        ".uno:InsertVideo"
#define CMD_SID_POLY_INTERSECT                      ".uno:Intersect"
#define CMD_SID_ATTR_CHAR_POSTURE                   ".uno:Italic"
#define CMD_SID_ATTR_CHAR_LATIN_POSTURE             ".uno:ItalicLatin"
#define CMD_SID_ATTR_CHAR_CJK_POSTURE               ".uno:ItalicCJK"
#define CMD_SID_ATTR_CHAR_CTL_POSTURE               ".uno:ItalicCTL"
#define CMD_SID_ATTR_PARA_ADJUST_BLOCK              ".uno:JustifyPara"
#define CMD_SID_INSERT_FIXEDTEXT                    ".uno:InsertFixedText"
#define CMD_SID_FM_FIXEDTEXT                        ".uno:Label"
#define CMD_SID_ATTR_CHAR_LANGUAGE                  ".uno:Language"
#define CMD_SID_ATTR_CHAR_LATIN_LANGUAGE            ".uno:LanguageLatin"
#define CMD_SID_FM_RECORD_LAST                      ".uno:LastRecord"
#define CMD_SID_FM_LEAVE_CREATE                     ".uno:LeaveFMCreateMode"
#define CMD_SID_LEAVE_GROUP                         ".uno:LeaveGroup"
#define CMD_SID_ATTR_PARA_ADJUST_LEFT               ".uno:LeftPara"
#define CMD_SID_ATTR_LRSPACE                        ".uno:LeftRightMargin"
#define CMD_SID_ATTR_PARA_LRSPACE                   ".uno:LeftRightParaMargin"
#define CMD_SID_ATTR_PARA_LRSPACE_VERTICAL          ".uno:LeftRightParaMargin_Vertical"
#define CMD_SID_DRAW_LINE                           ".uno:Line"
#define CMD_SID_DRAW_XLINE                          ".uno:Line_Diagonal"
#define CMD_SID_FRAME_LINECOLOR                     ".uno:FrameLineColor"
#define CMD_SID_ATTR_LINE_DASH                      ".uno:LineDash"
#define CMD_SID_ATTR_LINEEND_STYLE                  ".uno:LineEndStyle"
#define CMD_SID_ATTR_PARA_LINESPACE                 ".uno:LineSpacing"
#define CMD_SID_FRAME_LINESTYLE                     ".uno:LineStyle"
#define CMD_SID_ATTR_LINE_WIDTH                     ".uno:LineWidth"
#define CMD_SID_FM_LISTBOX                          ".uno:ListBox"
#define CMD_SID_INSERT_LISTBOX                      ".uno:InsertListbox"
#define CMD_SID_POLY_MERGE                          ".uno:Merge"
#define CMD_SID_BASICIDE_NEWJAVAMODULE              ".uno:NewJavaModule"
#define CMD_SID_FM_RECORD_NEW                       ".uno:NewRecord"
#define CMD_SID_FM_RECORD_NEXT                      ".uno:NextRecord"
#define CMD_SID_FM_NUMERICFIELD                     ".uno:NumericField"
#define CMD_SID_INSERT_NUMERICFIELD                 ".uno:InsertNumericField"
#define CMD_SID_OBJECT_ALIGN                        ".uno:ObjectAlign"
#define CMD_SID_FRAME_DOWN                          ".uno:ObjectBackOne"
#define CMD_SID_FRAME_UP                            ".uno:ObjectForwardOne"
#define CMD_SID_FM_OPEN_READONLY                    ".uno:OpenReadOnly"
#define CMD_SID_FM_ORDERCRIT                        ".uno:OrderCrit"
#define CMD_SID_ATTR_PARA_ORPHANS                   ".uno:Orphan"
#define CMD_SID_OUTLINE_BULLET                      ".uno:OutlineBullet"
#define CMD_SID_OUTLINE_COLLAPSE                    ".uno:OutlineCollapse"
#define CMD_SID_OUTLINE_COLLAPSE_ALL                ".uno:OutlineCollapseAll"
#define CMD_SID_OUTLINE_DOWN                        ".uno:OutlineDown"
#define CMD_SID_OUTLINE_EXPAND                      ".uno:OutlineExpand"
#define CMD_SID_OUTLINE_EXPAND_ALL                  ".uno:OutlineExpandAll"
#define CMD_SID_ATTR_CHAR_CONTOUR                   ".uno:OutlineFont"
#define CMD_SID_OUTLINE_FORMAT                      ".uno:OutlineFormat"
#define CMD_SID_OUTLINE_LEFT                        ".uno:OutlineLeft"
#define CMD_SID_OUTLINE_RIGHT                       ".uno:OutlineRight"
#define CMD_SID_OUTLINE_UP                          ".uno:OutlineUp"
#define CMD_SID_ATTR_PARA_PAGEBREAK                 ".uno:Pagebreak"
#define CMD_SID_ATTR_PAGE_PAPERBIN                  ".uno:PagePaperBin"
#define CMD_SID_ATTR_PAGE_SIZE                      ".uno:AttributePageSize"
#define CMD_SID_ATTR_PARA_MODEL                     ".uno:AttributeParaModel"
#define CMD_SID_ATTR_PAGE                           ".uno:AttributePage"
#define CMD_SID_ATTR_CHAR_AUTOKERN                  ".uno:PairKerning"
#define CMD_SID_PARA_DLG                            ".uno:ParagraphDialog"
#define CMD_SID_ATTR_PARA_KEEP                      ".uno:ParaKeepTogether"
#define CMD_SID_ATTR_PARA_SPLIT                     ".uno:ParaSplit"
#define CMD_SID_INSERT_PATTERNFIELD                 ".uno:InsertPatternField"
#define CMD_SID_FM_PATTERNFIELD                     ".uno:PatternField"
#define CMD_SID_DRAW_PIE                            ".uno:Pie"
#define CMD_SID_DRAW_PIE_NOFILL                     ".uno:Pie_Unfilled"
#define CMD_SID_POLY_FORMEN                         ".uno:PolyFormen"
#define CMD_SID_DRAW_XPOLYGON                       ".uno:Polygon_Diagonal"
#define CMD_SID_DRAW_XPOLYGON_NOFILL                ".uno:Polygon_Diagonal_Unfilled"
#define CMD_SID_DRAW_POLYGON_NOFILL                 ".uno:Polygon_Unfilled"
#define CMD_SID_ATTR_POSITION                       ".uno:Position"
#define CMD_SID_INSERT_PREVIEW                      ".uno:Preview"
#define CMD_SID_FM_RECORD_PREV                      ".uno:PrevRecord"
#define CMD_SID_INSERT_PROGRESSBAR                  ".uno:ProgressBar"
#define CMD_SID_FM_PROPERTY_CONTROL                 ".uno:PropertyController"
#define CMD_SID_FM_PUSHBUTTON                       ".uno:Pushbutton"
#define CMD_SID_INSERT_PUSHBUTTON                   ".uno:InsertPushbutton"
#define CMD_SID_INSERT_RADIOBUTTON                  ".uno:Radiobutton"
#define CMD_SID_FM_RADIOBUTTON                      ".uno:RadioButton"
#define CMD_SID_READONLY_MODE                       ".uno:ReadOnlyMode"
#define CMD_SID_FM_RECORD_FROM_TEXT                 ".uno:RecFromText"
#define CMD_SID_FM_RECORD_SAVE                      ".uno:RecSave"
#define CMD_SID_FM_SEARCH                           ".uno:RecSearch"
#define CMD_SID_DRAW_RECT                           ".uno:Rect"
#define CMD_SID_DRAW_RECT_ROUND                     ".uno:Rect_Rounded"
#define CMD_SID_DRAW_RECT_ROUND_NOFILL              ".uno:Rect_Rounded_Unfilled"
#define CMD_SID_DRAW_RECT_NOFILL                    ".uno:Rect_Unfilled"
#define CMD_SID_FM_RECORD_TEXT                      ".uno:RecText"
#define CMD_SID_FM_RECORD_TOTAL                     ".uno:RecTotal"
#define CMD_SID_FM_RECORD_UNDO                      ".uno:RecUndo"
#define CMD_SID_FM_REFRESH                          ".uno:Refresh"
#define CMD_SID_FM_REFRESH_FORM_CONTROL             ".uno:RefreshFormControl"
#define CMD_SID_FM_FILTER_REMOVE                    ".uno:RemoveFilter"
#define CMD_SID_FM_REMOVE_FILTER_SORT               ".uno:RemoveFilterSort"
#define CMD_FID_SEARCH_REPLACESET                   ".uno:ReplaceSet"
#define CMD_SID_ATTR_PARA_ADJUST_RIGHT              ".uno:RightPara"
#define CMD_SID_RULER_BORDER_DISTANCE               ".uno:RulerBorderDistance"
#define CMD_SID_RULER_BORDERS                       ".uno:RulerBorders"
#define CMD_SID_RULER_BORDERS_VERTICAL              ".uno:RulerBordersVertical"
#define CMD_SID_RULER_NULL_OFFSET                   ".uno:RulerNullOffset"
#define CMD_SID_RULER_PAGE_POS                      ".uno:RulerPagePos"
#define CMD_SID_RULER_PROTECT                       ".uno:RulerProtect"
#define CMD_SID_FM_EXECUTE                          ".uno:SbaExecuteSql"
#define CMD_SID_FM_NATIVESQL                        ".uno:SbaNativeSql"
#define CMD_SID_SCAN                                ".uno:Scan"
#define CMD_SID_SC_EDITOPTIONS                      ".uno:ScEditOptions"
#define CMD_SID_SCH_EDITOPTIONS                     ".uno:SchEditOptions"
#define CMD_SID_SD_EDITOPTIONS                      ".uno:SdEditOptions"
#define CMD_SID_SD_GRAPHIC_OPTIONS                  ".uno:SdGraphicOptions"
#define CMD_FID_SEARCH_OFF                          ".uno:SearchOff"
#define CMD_FID_SEARCH_ON                           ".uno:SearchOn"
#define CMD_FID_SEARCH_SEARCHSET                    ".uno:SearchSet"
#define CMD_SID_SELECT                              ".uno:Select"
#define CMD_SID_FRAME_TO_BOTTOM                     ".uno:SendToBack"
#define CMD_SID_SET_DEFAULT                         ".uno:SetDefault"
#define CMD_SID_HYPERLINK_SETLINK                   ".uno:SetHyperlink"
#define CMD_SID_ATTR_PARA_HYPHENZONE                ".uno:SetHyphenZone"
#define CMD_SID_ATTR_LONG_LRSPACE                   ".uno:SetLongLeftRightMargin"
#define CMD_SID_ATTR_LONG_ULSPACE                   ".uno:SetLongTopBottomMargin"
#define CMD_SID_OBJECT_HELL                         ".uno:SetObjectToBackground"
#define CMD_SID_OBJECT_HEAVEN                       ".uno:SetObjectToForeground"
#define CMD_SID_ATTR_PAGE_MAXSIZE                   ".uno:SetPageMaxSize"
#define CMD_SID_ATTR_BORDER_SHADOW                  ".uno:BorderShadow"
#define CMD_SID_ATTR_FILL_SHADOW                    ".uno:FillShadow"
#define CMD_SID_ATTR_CHAR_SHADOWED                  ".uno:Shadowed"
#define CMD_SID_OUTLINE_SHOW                        ".uno:ShowDetail"
#define CMD_SID_FM_SHOW_FMEXPLORER                  ".uno:ShowFmExplorer"
#define CMD_SID_SHOW_ITEMBROWSER                    ".uno:ShowItemBrowser"
#define CMD_SID_SHOW_PROPERTYBROWSER                ".uno:ShowPropBrowser"
#define CMD_SID_FM_SHOW_PROPERTIES                  ".uno:ShowProperties"
#define CMD_SID_FM_SHOW_PROPERTY_BROWSER            ".uno:ShowPropertyBrowser"
#define CMD_SID_RULER                               ".uno:ShowRuler"
#define CMD_SID_SIM_EDITOPTIONS                     ".uno:SimEditOptions"
#define CMD_SID_ATTR_SIZE                           ".uno:Size"
#define CMD_SID_SM_EDITOPTIONS                      ".uno:SmEditOptions"
#define CMD_SID_FM_SORTDOWN                         ".uno:SortDown"
#define CMD_SID_FM_SORTUP                           ".uno:Sortup"
#define CMD_SID_ATTR_PARA_LINESPACE_10              ".uno:SpacePara1"
#define CMD_SID_ATTR_PARA_LINESPACE_15              ".uno:SpacePara15"
#define CMD_SID_ATTR_PARA_LINESPACE_20              ".uno:SpacePara2"
#define CMD_SID_ATTR_CHAR_KERNING                   ".uno:Spacing"
#define CMD_SID_AUTOSPELL_CHECK                     ".uno:SpellOnline"
#define CMD_SID_INSERT_SPINBUTTON                   ".uno:Spinbutton"
#define CMD_SID_DRAW_SQUARE                         ".uno:Square"
#define CMD_SID_DRAW_SQUARE_ROUND                   ".uno:Square_Rounded"
#define CMD_SID_DRAW_SQUARE_ROUND_NOFILL            ".uno:Square_Rounded_Unfilled"
#define CMD_SID_DRAW_SQUARE_NOFILL                  ".uno:Square_Unfilled"
#define CMD_SID_3D_STATE                            ".uno:State3D"
#define CMD_SID_ATTR_CHAR_STRIKEOUT                 ".uno:Strikeout"
#define CMD_SID_SET_SUB_SCRIPT                      ".uno:SubScript"
#define CMD_SID_POLY_SUBSTRACT                      ".uno:Substract"
#define CMD_SID_SET_SUPER_SCRIPT                    ".uno:SuperScript"
#define CMD_SID_SW_EDITOPTIONS                      ".uno:SwEditOptions"
#define CMD_SID_FM_TAB_DIALOG                       ".uno:TabDialog"
#define CMD_SID_ATTR_TABSTOP                        ".uno:Tabstops"
#define CMD_SID_ATTR_TABSTOP_VERTICAL               ".uno:TabstopsVertical"
#define CMD_SID_DIALOG_TESTMODE                     ".uno:TestMode"
#define CMD_SID_ATTR_CHAR                           ".uno:Text"
#define CMD_SID_DRAW_TEXT                           ".uno:DrawText"
#define CMD_SID_DRAW_TEXT_MARQUEE                   ".uno:Text_Marquee"
#define CMD_SID_TEXTDIRECTION_LEFT_TO_RIGHT         ".uno:TextdirectionLeftToRight"
#define CMD_SID_TEXTDIRECTION_TOP_TO_BOTTOM         ".uno:TextdirectionTopToBottom"
#define CMD_SID_ATTR_TEXT_FITTOSIZE                 ".uno:TextFitToSize"
#define CMD_SID_THESAURUS                           ".uno:ThesaurusDialog"
#define CMD_SID_INSERT_TIMEFIELD                    ".uno:InsertTimeField"
#define CMD_SID_FM_TIMEFIELD                        ".uno:TimeField"
#define CMD_SID_BEZIER_EDIT                         ".uno:ToggleObjectBezierMode"
#define CMD_SID_OBJECT_ROTATE                       ".uno:ToggleObjectRotateMode"
#define CMD_SID_TEXTEDIT                            ".uno:ToolEdit"
#define CMD_SID_OBJECT_SELECT                       ".uno:SelectObject"
#define CMD_SID_ATTR_ULSPACE                        ".uno:TopBottomMargin"
#define CMD_SID_ATTR_TRANSFORM                      ".uno:TransformDialog"
#define CMD_SID_TWAIN_SELECT                        ".uno:TwainSelect"
#define CMD_SID_TWAIN_TRANSFER                      ".uno:TwainTransfer"
#define CMD_SID_ATTR_CHAR_UNDERLINE                 ".uno:Underline"
#define CMD_SID_ATTR_CHAR_OVERLINE                  ".uno:Overline"
#define CMD_SID_OUTLINE_REMOVE                      ".uno:Ungroup"
#define CMD_SID_INSERT_URLBUTTON                    ".uno:URLButton"
#define CMD_SID_FM_USE_WIZARDS                      ".uno:UseWizards"
#define CMD_SID_DRAW_CAPTION_VERTICAL               ".uno:VerticalCaption"
#define CMD_SID_DRAW_TEXT_VERTICAL                  ".uno:VerticalText"
#define CMD_SID_INSERT_VFIXEDLINE                   ".uno:VFixedLine"
#define CMD_SID_FM_VIEW_AS_GRID                     ".uno:ViewFormAsGrid"
#define CMD_SID_INSERT_VSCROLLBAR                   ".uno:VScrollbar"
#define CMD_SID_ATTR_PARA_WIDOWS                    ".uno:Widow"
#define CMD_SID_3D_WIN                              ".uno:Window3D"
#define CMD_SID_ATTR_CHAR_WORDLINEMODE              ".uno:WordMode"
#define CMD_SID_ATTR_LINE_COLOR                     ".uno:XLineColor"
#define CMD_SID_ATTR_LINE_STYLE                     ".uno:XLineStyle"
#define CMD_SID_ATTR_ZOOM                           ".uno:Zoom"
#define CMD_SID_SIZE_REAL                           ".uno:Zoom100Percent"
#define CMD_SID_SIZE_OPTIMAL                        ".uno:ZoomObjects"
#define CMD_SID_SIZE_ALL                            ".uno:ZoomOptimal"
#define CMD_SID_SIZE_PAGE                           ".uno:ZoomPage"
#define CMD_SID_SIZE_PAGE_WIDTH                     ".uno:ZoomPageWidth"
#define CMD_SID_SIZE_VISAREA                        ".uno:ZoomVisArea"
#define CMD_SID_FM_GRABCONTROLFOCUS                 ".uno:GrabControlFocus"
#define CMD_SID_FM_CREATE_FIELDCONTROL              ".uno:CreateFieldControl"
#define CMD_SID_INSERT_SELECT                       ".uno:SelectMode"
#define CMD_SID_PARA_VERTALIGN                      ".uno:VerticalParagraphAlignment"
#define CMD_SID_ATTR_CHAR_RELIEF                    ".uno:CharacterRelief"
#define CMD_SID_ATTR_BRUSH_CHAR                     ".uno:CharacterBackgroundPattern"
#define CMD_SID_ATTR_CHAR_ROTATED                   ".uno:CharacterRotation"
#define CMD_SID_ATTR_CHAR_SCALEWIDTH                ".uno:CharacterWidthScalingFactor"
#define CMD_SID_ATTR_NUMBERFORMAT_VALUE             ".uno:NumberFormatValue"
#define CMD_SID_ATTR_ALIGN_HOR_JUSTIFY              ".uno:HorizontalJustification"
#define CMD_SID_ATTR_ALIGN_VER_JUSTIFY              ".uno:VerticalJustification"
#define CMD_SID_ATTR_ALIGN_INDENT                   ".uno:AlignmentIndent"
#define CMD_SID_ATTR_ALIGN_HYPHENATION              ".uno:AlignmentHyphenation"
#define CMD_SID_ATTR_ALIGN_DEGREES                  ".uno:AlignmentRotation"
#define CMD_SID_ATTR_ALIGN_LOCKPOS                  ".uno:AlignmentRotationMode"
#define CMD_SID_ATTR_ALIGN_MARGIN                   ".uno:AlignmentMargin"
#define CMD_SID_ATTR_ALIGN_STACKED                  ".uno:AlignmentStacked"
#define CMD_SID_ATTR_PARA_LEFT_TO_RIGHT             ".uno:ParaLeftToRight"
#define CMD_SID_ATTR_PARA_RIGHT_TO_LEFT             ".uno:ParaRightToLeft"
#define CMD_SID_RULER_TEXT_RIGHT_TO_LEFT            ".uno:TextRTL"
#define CMD_SID_OPEN_HYPERLINK                      ".uno:OpenHyperlinkOnCursor"
#define CMD_SID_CTLFONT_STATE                       ".uno:CTLFontState"
#define CMD_SID_VERTICALTEXT_STATE                  ".uno:VerticalTextState"
#define CMD_SID_OPEN_XML_FILTERSETTINGS             ".uno:OpenXMLFilterSettings"
#define CMD_SID_HANGUL_HANJA_CONVERSION             ".uno:HangulHanjaConversion"
#define CMD_SID_CHINESE_CONVERSION                  ".uno:ChineseConversion"
#define CMD_SID_SPELL_DIALOG                        ".uno:SpellDialog"
#define CMD_SID_RULER_ROWS                          ".uno:RulerRows"
#define CMD_SID_RULER_ROWS_VERTICAL                 ".uno:RulerRowsVertical"
#define CMD_SID_ATTR_CHAR_FONTLIST                  ".uno:FontNameList"
#define CMD_SID_EXTRUSION_TOOGLE                    ".uno:ExtrusionToggle"
#define CMD_SID_EXTRUSION_TILT_DOWN                 ".uno:ExtrusionTiltDown"
#define CMD_SID_EXTRUSION_TILT_UP                   ".uno:ExtrusionTiltUp"
#define CMD_SID_EXTRUSION_TILT_LEFT                 ".uno:ExtrusionTiltLeft"
#define CMD_SID_EXTRUSION_TILT_RIGHT                ".uno:ExtrusionTiltRight"
#define CMD_SID_EXTRUSION_DEPTH_FLOATER             ".uno:ExtrusionDepthFloater"
#define CMD_SID_EXTRUSION_DEPTH_DIALOG              ".uno:ExtrusionDepthDialog"
#define CMD_SID_EXTRUSION_DIRECTION_FLOATER         ".uno:ExtrusionDirectionFloater"
#define CMD_SID_EXTRUSION_LIGHTING_FLOATER          ".uno:ExtrusionLightingFloater"
#define CMD_SID_EXTRUSION_SURFACE_FLOATER           ".uno:ExtrusionSurfaceFloater"
#define CMD_SID_EXTRUSION_3D_COLOR                  ".uno:Extrusion3DColor"
#define CMD_SID_EXTRUSION_DEPTH                     ".uno:ExtrusionDepth"
#define CMD_SID_EXTRUSION_DIRECTION                 ".uno:ExtrusionDirection"
#define CMD_SID_EXTRUSION_PROJECTION                ".uno:ExtrusionProjection"
#define CMD_SID_EXTRUSION_LIGHTING_DIRECTION        ".uno:ExtrusionLightingDirection"
#define CMD_SID_EXTRUSION_LIGHTING_INTENSITY        ".uno:ExtrusionLightingIntensity"
#define CMD_SID_EXTRUSION_SURFACE                   ".uno:ExtrusionSurface"
#define CMD_SID_FONTWORK_GALLERY_FLOATER            ".uno:FontworkGalleryFloater"
#define CMD_SID_FONTWORK_SHAPE_TYPE                 ".uno:FontworkShapeType"
#define CMD_SID_FONTWORK_SAME_LETTER_HEIGHTS        ".uno:FontworkSameLetterHeights"
#define CMD_SID_FONTWORK_ALIGNMENT_FLOATER          ".uno:FontworkAlignmentFloater"
#define CMD_SID_FONTWORK_CHARACTER_SPACING_FLOATER  ".uno:FontworkCharacterSpacingFloater"
#define CMD_SID_FONTWORK_SHAPE                      ".uno:FontworkShape"
#define CMD_SID_FONTWORK_ALIGNMENT                  ".uno:FontworkAlignment"
#define CMD_SID_FONTWORK_CHARACTER_SPACING          ".uno:FontworkCharacterSpacing"
#define CMD_SID_FONTWORK_CHARACTER_SPACING_DIALOG   ".uno:FontworkCharacterSpacingDialog"
#define CMD_SID_FONTWORK_KERN_CHARACTER_PAIRS       ".uno:FontworkKernCharacterPairs"
#define CMD_SID_GET_COLORTABLE                      ".uno:GetColorTable"
#define CMD_SID_SPELLCHECKER_CHANGED                ".uno:SpellCheckerChanged"
#define CMD_SID_ATTR_YEAR2000                       ".uno:Year2000"
#define CMD_SID_INC_INDENT                          ".uno:IncrementIndent"
#define CMD_SID_DEC_INDENT                          ".uno:DecrementIndent"
#define CMD_SID_TABLE_CELL                          ".uno:StateTableCell"
#define CMD_SID_OUTLINE_TO_IMPRESS                  ".uno:SendOutlineToImpress"
#define CMD_SID_ATTR_DEFTABSTOP                     ".uno:DefTabStop"
#define CMD_SID_ATTR_LANGUAGE                       ".uno:DocumentLanguage"
#define CMD_SID_ATTR_CHAR_CJK_LANGUAGE              ".uno:DocumentLanguageCJK"
#define CMD_SID_ATTR_CHAR_CTL_LANGUAGE              ".uno:DocumentLanguageCTL"
#define CMD_SID_OPT_LOCALE_CHANGED                  ".uno:OptionsLocaleChanged"
#define CMD_SID_SBA_BRW_INSERT                      ".uno:SbaBrwInsert"
#define CMD_SID_DRAWTBX_CS_BASIC                    ".uno:BasicShapes"
#define CMD_SID_DRAWTBX_CS_SYMBOL                   ".uno:SymbolShapes"
#define CMD_SID_DRAWTBX_CS_ARROW                    ".uno:ArrowShapes"
#define CMD_SID_DRAWTBX_CS_FLOWCHART                ".uno:FlowChartShapes"
#define CMD_SID_DRAWTBX_CS_CALLOUT                  ".uno:CalloutShapes"
#define CMD_SID_DRAWTBX_CS_STAR                     ".uno:StarShapes"
#define CMD_SID_DRAW_CS_ID                          ".uno:CustomShape"
#define CMD_SID_DASH_LIST                           ".uno:DashListState"
#define CMD_SID_LINEEND_LIST                        ".uno:LineEndListState"
#define CMD_SID_COLOR_TABLE                         ".uno:ColorTableState"
#define CMD_SID_GRADIENT_LIST                       ".uno:GradientListState"
#define CMD_SID_HATCH_LIST                          ".uno:HatchListState"
#define CMD_SID_BITMAP_LIST                         ".uno:BitmapListState"
#define CMD_SID_ATTR_CHAR_EMPHASISMARK              ".uno:EmphasisMark"
#define CMD_SID_FM_SHOW_DATANAVIGATOR               ".uno:ShowDataNavigator"
#define CMD_SID_FM_DATANAVIGATOR_CONTROL            ".uno:FmDataNavigatorController"
#define CMD_SID_ALIGN_ANY_LEFT                      ".uno:CommonAlignLeft"
#define CMD_SID_ALIGN_ANY_HCENTER                   ".uno:CommonAlignHorizontalCenter"
#define CMD_SID_ALIGN_ANY_RIGHT                     ".uno:CommonAlignRight"
#define CMD_SID_ALIGN_ANY_JUSTIFIED                 ".uno:CommonAlignJustified"
#define CMD_SID_ALIGN_ANY_TOP                       ".uno:CommonAlignTop"
#define CMD_SID_ALIGN_ANY_VCENTER                   ".uno:CommonAlignVerticalCenter"
#define CMD_SID_ALIGN_ANY_BOTTOM                    ".uno:CommonAlignBottom"
#define CMD_SID_ALIGN_ANY_HDEFAULT                  ".uno:CommonAlignHorizontalDefault"
#define CMD_SID_ALIGN_ANY_VDEFAULT                  ".uno:CommonAlignVerticalDefault"
#define CMD_SID_AVMEDIA_TOOLBOX                     ".uno:AVMediaToolBox"
#define CMD_SID_BORDER_REDUCED_MODE                 ".uno:BorderReducedMode"
#define CMD_SID_COLOR_SETTINGS                      ".uno:ColorSettings"
#define CMD_SID_MAIL_EXPORT_FINISHED                ".uno:MailExportFinished"
#define CMD_SID_INSERT_ZWSP                         ".uno:InsertZWSP"
#define CMD_SID_INSERT_ZWNBSP                       ".uno:InsertZWNBSP"
#define CMD_SID_INSERT_LRM                          ".uno:InsertLRM"
#define CMD_SID_INSERT_RLM                          ".uno:InsertRLM"
#define CMD_FN_INSERT_SOFT_HYPHEN                   ".uno:InsertSoftHyphen"
#define CMD_FN_INSERT_HARDHYPHEN                    ".uno:InsertHardHyphen"
#define CMD_FN_INSERT_HARD_SPACE                    ".uno:InsertNonBreakingSpace"
#define CMD_SID_BASICIDE_MANAGE_LANG                ".uno:ManageLanguage"
#define CMD_SID_BASICIDE_CURRENT_LANG               ".uno:CurrentLanguage"
#define CMD_SID_TABLE_MERGE_CELLS                   ".uno:MergeCells"
#define CMD_SID_TABLE_SPLIT_CELLS                   ".uno:SplitCell"
#define CMD_SID_OPTIMIZE_TABLE                      ".uno:OptimizeTable"
#define CMD_SID_TABLE_VERT_BOTTOM                   ".uno:CellVertBottom"
#define CMD_SID_TABLE_VERT_CENTER                   ".uno:CellVertCenter"
#define CMD_SID_TABLE_VERT_NONE                     ".uno:CellVertTop"
#define CMD_SID_TABLE_INSERT_ROW                    ".uno:InsertRows"
#define CMD_SID_TABLE_INSERT_COL                    ".uno:InsertColumns"
#define CMD_SID_TABLE_DELETE_ROW                    ".uno:DeleteRows"
#define CMD_SID_TABLE_DELETE_COL                    ".uno:DeleteColumns"
#define CMD_SID_TABLE_SELECT_ALL                    ".uno:SelectTable"
#define CMD_SID_TABLE_SELECT_COL                    ".uno:EntireColumn"
#define CMD_SID_TABLE_SELECT_ROW                    ".uno:EntireRow"
#define CMD_SID_FORMAT_TABLE_DLG                    ".uno:TableDialog"
#define CMD_SID_TABLE_AUTOSUM                       ".uno:AutoSum"
#define CMD_SID_TABLE_SORT_DIALOG                   ".uno:TableSort"
#define CMD_SID_OPEN_SMARTTAGMENU                   ".uno:OpenSmartTagMenuOnCursor"
#define CMD_SID_ATTR_ZOOMSLIDER                     ".uno:ZoomSlider"
#define CMD_SID_FONTNAMELIST                        ".uno:FontNameStringList"
#define CMD_SID_LANGUAGE_STATUS                     ".uno:LanguageStatus"
#define CMD_SID_CHAR_DLG_FOR_PARAGRAPH              ".uno:FontDialogForParagraph"
#define CMD_SID_GROW_FONT_SIZE                      ".uno:Grow"
#define CMD_SID_SHRINK_FONT_SIZE                    ".uno:Shrink"
#define CMD_SID_RECHECK_DOCUMENT                    ".uno:RecheckDocument"
#define CMD_SID_TABLE_INSERT_COL_DLG                ".uno:InsertColumnDialog"
#define CMD_SID_TABLE_INSERT_ROW_DLG                ".uno:InsertRowDialog"

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
