/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_WINACCESSIBILITY_INC_ACCCOMPONENTEVENTLISTENER_HXX
#define INCLUDED_WINACCESSIBILITY_INC_ACCCOMPONENTEVENTLISTENER_HXX

#include <stdio.h>
#include "AccEventListener.hxx"
#include <com/sun/star/accessibility/XAccessibleEventListener.hpp>
#include <com/sun/star/accessibility/XAccessible.hpp>


/**
 * AccComponentEventListener is inherited from AccEventListener. It handles the evnets
 * generated by component controls. The accessible roles are: CHECK_BOX, ICON, LABEL,
 * MENU_ITEM, PUSH_BUTTON, RADIO_BUTTON, SCROLL_BAR, SEPARATOR, TOGGLE_BUTTON, TOOL_TIP, SPIN_BOX.
 * It defines the procedure of specific event handling related with components and provides
 * the detailed support for some related methods.
 */
class AccComponentEventListener: public AccEventListener
{
private:
    static FILE *output, *output2, *output3, *outacc;//used for debugging
public:
    AccComponentEventListener(css::accessibility::XAccessible* pAcc, AccObjectManagerAgent* Agent);
    virtual ~AccComponentEventListener() override;

    // XAccessibleEventListener
    virtual void SAL_CALL notifyEvent( const css::accessibility::AccessibleEventObject& aEvent ) throw (css::uno::RuntimeException) override;

    //for value changed event
    virtual void HandleValueChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue);

    //for action changed event
    virtual void HandleActionChangedEvent();

    //for text changed event
    virtual void HandleTextChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue);

    //for caret changed event
    virtual void HandleCaretChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue);

    virtual void SetComponentState(short state, bool enable) override;
    virtual void FireStatePropertyChange(short state, bool set) override;
    virtual void FireStateFocusedChange(bool enable) override;

    void HandleSelectionChangedEventNoArgs();

    //add TEXT_SELECTION_CHANGED event
    void HandleTextSelectionChangedEvent();
};

#endif // INCLUDED_WINACCESSIBILITY_INC_ACCCOMPONENTEVENTLISTENER_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
