/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SC_SOURCE_UI_INC_NAMEPAST_HXX
#define INCLUDED_SC_SOURCE_UI_INC_NAMEPAST_HXX

#include <vcl/dialog.hxx>
#include <vcl/button.hxx>
#include "namemgrtable.hxx"

#include <memory>
#include <vector>
#include <map>

class ScRangeName;
class ScDocShell;

class ScNamePasteDlg : public ModalDialog
{
    DECL_LINK( ButtonHdl, Button *, void );

private:
    VclPtr<PushButton> m_pBtnPasteAll;
    VclPtr<PushButton> m_pBtnPaste;
    VclPtr<PushButton> m_pBtnClose;

    VclPtr<ScRangeManagerTable> mpTable;

    std::vector<OUString> maSelectedNames;
    std::map<OUString, std::unique_ptr<ScRangeName>> m_RangeMap;

public:
    ScNamePasteDlg( vcl::Window * pParent, ScDocShell* pShell );

    virtual ~ScNamePasteDlg() override;
    virtual void dispose() override;

    const std::vector<OUString>& GetSelectedNames() const;
};

#endif // INCLUDED_SC_SOURCE_UI_INC_NAMEPAST_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
