/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SW_SOURCE_UI_VBA_VBAHEADERFOOTERHELPER_HXX
#define INCLUDED_SW_SOURCE_UI_VBA_VBAHEADERFOOTERHELPER_HXX

#include <vbahelper/vbahelper.hxx>
#include <com/sun/star/text/XText.hpp>
#include <com/sun/star/text/XTextViewCursor.hpp>
#include <com/sun/star/text/XPageCursor.hpp>
#include <com/sun/star/style/XStyle.hpp>

class HeaderFooterHelper
{
public:
    /// @throws css::uno::RuntimeException
    static bool isHeaderFooter( const css::uno::Reference< css::frame::XModel >& xModel );
    /// @throws css::uno::RuntimeException
    static bool isHeaderFooter( const css::uno::Reference< css::text::XText >& xText );
    /// @throws css::uno::RuntimeException
    static bool isHeader( const css::uno::Reference< css::frame::XModel >& xModel );
    /// @throws css::uno::RuntimeException
    static bool isFirstPageHeader( const css::uno::Reference< css::frame::XModel >& xModel );
    /// @throws css::uno::RuntimeException
    static bool isEvenPagesHeader( const css::uno::Reference< css::frame::XModel >& xModel );
    /// @throws css::uno::RuntimeException
    static bool isFooter( const css::uno::Reference< css::frame::XModel >& xModel );
    /// @throws css::uno::RuntimeException
    static bool isFirstPageFooter( const css::uno::Reference< css::frame::XModel >& xModel );
    /// @throws css::uno::RuntimeException
    static bool isEvenPagesFooter( const css::uno::Reference< css::frame::XModel >& xModel );
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
