/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.concurrent.Callable;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Cache;

class CacheOps {
    CacheOps() {
    }

    public static <K, V> V getOrFill(Cache<K, V> cache, K key, Callable<V> callable) {
        V value = cache.getIfPresent(key);
        if (value == null) {
            try {
                value = callable.call();
            }
            catch (Exception e) {
                throw new AtlasException("Exception on cache fill", e);
            }
            if (value != null) {
                cache.put(key, value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrFillSync(Cache<K, V> cache, K key, Callable<V> callable) {
        Cache<K, V> cache2 = cache;
        synchronized (cache2) {
            return CacheOps.getOrFill(cache, key, callable);
        }
    }
}

