/*
 * Copyright 2021 Google LLC
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef skgpu_graphite_MtlUtilsPriv_DEFINED
#define skgpu_graphite_MtlUtilsPriv_DEFINED

#include "include/core/SkImageInfo.h"
#include "include/ports/SkCFObject.h"
#include "src/gpu/graphite/ResourceTypes.h"
#include "src/sksl/ir/SkSLProgram.h"

#import <Metal/Metal.h>

namespace skgpu {
class ShaderErrorHandler;
}

namespace SkSL {
    class Compiler;
    enum class ProgramKind : int8_t;
    struct ProgramSettings;
}

namespace skgpu::graphite {
class MtlSharedContext;

bool MtlFormatIsDepthOrStencil(MTLPixelFormat);
bool MtlFormatIsDepth(MTLPixelFormat);
bool MtlFormatIsStencil(MTLPixelFormat);
bool MtlFormatIsCompressed(MTLPixelFormat);

MTLPixelFormat MtlDepthStencilFlagsToFormat(SkEnumBitMask<DepthStencilFlags>);

/**
 * Produces MSL code generated by SkSLC
 */
bool SkSLToMSL(SkSL::Compiler*,
               const std::string& sksl,
               SkSL::ProgramKind kind,
               const SkSL::ProgramSettings& settings,
               std::string* msl,
               SkSL::Program::Inputs* outInputs,
               ShaderErrorHandler* errorHandler);

sk_cfp<id<MTLLibrary>> MtlCompileShaderLibrary(const MtlSharedContext* sharedContext,
                                               const std::string& msl,
                                               ShaderErrorHandler* errorHandler);

#ifdef SK_BUILD_FOR_IOS
bool MtlIsAppInBackground();
#endif
} // namespace skgpu::graphite

#endif // skgpu_graphite_MtlUtilsPriv_DEFINED
