// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::AsyncResult;
use crate::Cancellable;
use crate::TlsCertificateRequestFlags;
use crate::TlsConnection;
use crate::TlsInteractionResult;
use crate::TlsPassword;
use glib::object::IsA;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GTlsInteraction")]
    pub struct TlsInteraction(Object<ffi::GTlsInteraction, ffi::GTlsInteractionClass>);

    match fn {
        type_ => || ffi::g_tls_interaction_get_type(),
    }
}

impl TlsInteraction {
    pub const NONE: Option<&'static TlsInteraction> = None;
}

pub trait TlsInteractionExt: 'static {
    #[doc(alias = "g_tls_interaction_ask_password")]
    fn ask_password(
        &self,
        password: &impl IsA<TlsPassword>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error>;

    #[doc(alias = "g_tls_interaction_ask_password_async")]
    fn ask_password_async<P: FnOnce(Result<TlsInteractionResult, glib::Error>) + 'static>(
        &self,
        password: &impl IsA<TlsPassword>,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    );

    fn ask_password_future(
        &self,
        password: &(impl IsA<TlsPassword> + Clone + 'static),
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<TlsInteractionResult, glib::Error>> + 'static>,
    >;

    #[doc(alias = "g_tls_interaction_invoke_ask_password")]
    fn invoke_ask_password(
        &self,
        password: &impl IsA<TlsPassword>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error>;

    #[doc(alias = "g_tls_interaction_invoke_request_certificate")]
    fn invoke_request_certificate(
        &self,
        connection: &impl IsA<TlsConnection>,
        flags: TlsCertificateRequestFlags,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error>;

    #[doc(alias = "g_tls_interaction_request_certificate")]
    fn request_certificate(
        &self,
        connection: &impl IsA<TlsConnection>,
        flags: TlsCertificateRequestFlags,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error>;

    #[doc(alias = "g_tls_interaction_request_certificate_async")]
    fn request_certificate_async<P: FnOnce(Result<TlsInteractionResult, glib::Error>) + 'static>(
        &self,
        connection: &impl IsA<TlsConnection>,
        flags: TlsCertificateRequestFlags,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    );

    fn request_certificate_future(
        &self,
        connection: &(impl IsA<TlsConnection> + Clone + 'static),
        flags: TlsCertificateRequestFlags,
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<TlsInteractionResult, glib::Error>> + 'static>,
    >;
}

impl<O: IsA<TlsInteraction>> TlsInteractionExt for O {
    fn ask_password(
        &self,
        password: &impl IsA<TlsPassword>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_ask_password(
                self.as_ref().to_glib_none().0,
                password.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn ask_password_async<P: FnOnce(Result<TlsInteractionResult, glib::Error>) + 'static>(
        &self,
        password: &impl IsA<TlsPassword>,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn ask_password_async_trampoline<
            P: FnOnce(Result<TlsInteractionResult, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_ask_password_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = ask_password_async_trampoline::<P>;
        unsafe {
            ffi::g_tls_interaction_ask_password_async(
                self.as_ref().to_glib_none().0,
                password.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn ask_password_future(
        &self,
        password: &(impl IsA<TlsPassword> + Clone + 'static),
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<TlsInteractionResult, glib::Error>> + 'static>,
    > {
        let password = password.clone();
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.ask_password_async(&password, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn invoke_ask_password(
        &self,
        password: &impl IsA<TlsPassword>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_invoke_ask_password(
                self.as_ref().to_glib_none().0,
                password.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn invoke_request_certificate(
        &self,
        connection: &impl IsA<TlsConnection>,
        flags: TlsCertificateRequestFlags,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_invoke_request_certificate(
                self.as_ref().to_glib_none().0,
                connection.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn request_certificate(
        &self,
        connection: &impl IsA<TlsConnection>,
        flags: TlsCertificateRequestFlags,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<TlsInteractionResult, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_request_certificate(
                self.as_ref().to_glib_none().0,
                connection.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn request_certificate_async<P: FnOnce(Result<TlsInteractionResult, glib::Error>) + 'static>(
        &self,
        connection: &impl IsA<TlsConnection>,
        flags: TlsCertificateRequestFlags,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn request_certificate_async_trampoline<
            P: FnOnce(Result<TlsInteractionResult, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_request_certificate_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = request_certificate_async_trampoline::<P>;
        unsafe {
            ffi::g_tls_interaction_request_certificate_async(
                self.as_ref().to_glib_none().0,
                connection.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn request_certificate_future(
        &self,
        connection: &(impl IsA<TlsConnection> + Clone + 'static),
        flags: TlsCertificateRequestFlags,
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<TlsInteractionResult, glib::Error>> + 'static>,
    > {
        let connection = connection.clone();
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.request_certificate_async(&connection, flags, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }
}

impl fmt::Display for TlsInteraction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TlsInteraction")
    }
}
