/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __U1_REQUEST_CHROME_H__
#define __U1_REQUEST_CHROME_H__

#define LIBSOUP_USE_UNSTABLE_REQUEST_API
#include <libsoup/soup-request.h>

#define U1_TYPE_REQUEST_CHROME            (u1_request_chrome_get_type ())
#define U1_REQUEST_CHROME(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), U1_TYPE_REQUEST_CHROME, U1RequestChrome))
#define U1_IS_REQUEST_CHROME(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), U1_TYPE_REQUEST_CHROME))
#define U1_REQUEST_CHROME_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), U1_TYPE_REQUEST_CHROME, U1RequestChrome))
#define U1_IS_REQUEST_CHROME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), U1_TYPE_REQUEST_CHROME))
#define U1_REQUEST_CHROME_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), U1_TYPE_REQUEST_CHROME, U1RequestChrome))

typedef struct _U1RequestChrome        U1RequestChrome;
typedef struct _U1RequestChromeClass   U1RequestChromeClass;
typedef struct _U1RequestChromePrivate U1RequestChromePrivate;

struct _U1RequestChrome {
	SoupRequest parent;

    U1RequestChromePrivate *priv;
};

struct _U1RequestChromeClass {
    SoupRequestClass parent_class;
};

GType u1_request_chrome_get_type (void);

#endif
