#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static guint callbacks = 0;

static void
on_play_pause (UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Playpause \n");
}
static void
on_previous (UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Previous \n");
}
static void
on_next (UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Next \n");
}

static void
on_raise (UnityWebappsContext *context,  const gchar *file, gpointer user_data)
{
  printf("Raise \n");
  
  if (callbacks >= 3)
    {
      uwa_emit_test_finished ();
    }
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_music_player_init (context, "Test player");
  unity_webapps_context_on_raise_callback (context, on_raise, NULL);
  
  unity_webapps_music_player_set_track (context, "Test", "Test", "Test", ICON_URL);
  unity_webapps_music_player_on_play_pause_callback (context, on_play_pause, NULL);
  unity_webapps_music_player_on_previous_callback (context, on_previous, NULL);
  unity_webapps_music_player_on_next_callback (context, on_next, NULL);
  
  printf ("Raise the test player, then activate all the sound controls for Test Player from the sound menu\n");
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
