/* unity-place.c generated by valac 0.12.0, the Vala compiler
 * generated from unity-place.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * It may appear this code it is bit more bloated than it needs to be
 * (considering the pure number of classes and indirections), but this has
 * some good reasons.
 *
 * Firstly we want to hide away Vala's internal DBus marshalling which would
 * expose raw structs in the API. These structs are hidden away in _PlaceRendererInfo,
 * and _PlaceEntryInfo. We wrap these in handy GObjects with properties and what not.
 * In fact we want to hide all DBusisms, which is also why the DBus interfaces
 * are declared private.
 *
 * Secondly we want the generatedd C API to be nice and not too Vala-ish. We
 * must anticipate that place daemons consuming libunity will be written in
 * both Vala and C.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include <gio/gio.h>
#include <gee.h>


#define UNITY_TYPE__PLACERENDERERINFO (unity__placerendererinfo_get_type ())
typedef struct _Unity_PlaceRendererInfo Unity_PlaceRendererInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_PLACE_RENDERER_INFO (unity_place_renderer_info_get_type ())
#define UNITY_PLACE_RENDERER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_RENDERER_INFO, UnityPlaceRendererInfo))
#define UNITY_PLACE_RENDERER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLACE_RENDERER_INFO, UnityPlaceRendererInfoClass))
#define UNITY_IS_PLACE_RENDERER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_RENDERER_INFO))
#define UNITY_IS_PLACE_RENDERER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLACE_RENDERER_INFO))
#define UNITY_PLACE_RENDERER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLACE_RENDERER_INFO, UnityPlaceRendererInfoClass))

typedef struct _UnityPlaceRendererInfo UnityPlaceRendererInfo;
typedef struct _UnityPlaceRendererInfoClass UnityPlaceRendererInfoClass;
typedef struct _UnityPlaceRendererInfoPrivate UnityPlaceRendererInfoPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TYPE_PLACE_SEARCH (unity_place_search_get_type ())
#define UNITY_PLACE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_SEARCH, UnityPlaceSearch))
#define UNITY_PLACE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLACE_SEARCH, UnityPlaceSearchClass))
#define UNITY_IS_PLACE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_SEARCH))
#define UNITY_IS_PLACE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLACE_SEARCH))
#define UNITY_PLACE_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLACE_SEARCH, UnityPlaceSearchClass))

typedef struct _UnityPlaceSearch UnityPlaceSearch;
typedef struct _UnityPlaceSearchClass UnityPlaceSearchClass;
typedef struct _UnityPlaceSearchPrivate UnityPlaceSearchPrivate;

#define UNITY_TYPE_PLACE_ENTRY_INFO (unity_place_entry_info_get_type ())
#define UNITY_PLACE_ENTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_ENTRY_INFO, UnityPlaceEntryInfo))
#define UNITY_PLACE_ENTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLACE_ENTRY_INFO, UnityPlaceEntryInfoClass))
#define UNITY_IS_PLACE_ENTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_ENTRY_INFO))
#define UNITY_IS_PLACE_ENTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLACE_ENTRY_INFO))
#define UNITY_PLACE_ENTRY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLACE_ENTRY_INFO, UnityPlaceEntryInfoClass))

typedef struct _UnityPlaceEntryInfo UnityPlaceEntryInfo;
typedef struct _UnityPlaceEntryInfoClass UnityPlaceEntryInfoClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define UNITY_TYPE__PLACEENTRYINFO (unity__placeentryinfo_get_type ())
typedef struct _Unity_PlaceEntryInfo Unity_PlaceEntryInfo;

#define UNITY_TYPE__PLACEENTRYINFODATA (unity__placeentryinfodata_get_type ())
typedef struct _Unity_PlaceEntryInfoData Unity_PlaceEntryInfoData;
typedef struct _UnityPlaceEntryInfoPrivate UnityPlaceEntryInfoPrivate;

#define UNITY_TYPE_BROWSER (unity_browser_get_type ())
#define UNITY_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_BROWSER, UnityBrowser))
#define UNITY_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_BROWSER, UnityBrowserClass))
#define UNITY_IS_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_BROWSER))
#define UNITY_IS_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_BROWSER))
#define UNITY_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_BROWSER, UnityBrowserClass))

typedef struct _UnityBrowser UnityBrowser;
typedef struct _UnityBrowserClass UnityBrowserClass;

#define UNITY_TYPE_PLACE_SERVICE (unity_place_service_get_type ())
#define UNITY_PLACE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_SERVICE, UnityPlaceService))
#define UNITY_IS_PLACE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_SERVICE))
#define UNITY_PLACE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_PLACE_SERVICE, UnityPlaceServiceIface))

typedef struct _UnityPlaceService UnityPlaceService;
typedef struct _UnityPlaceServiceIface UnityPlaceServiceIface;

#define UNITY_TYPE_PLACE_SERVICE_PROXY (unity_place_service_proxy_get_type ())
typedef GDBusProxy UnityPlaceServiceProxy;
typedef GDBusProxyClass UnityPlaceServiceProxyClass;

#define UNITY_TYPE_PLACE_ENTRY_SERVICE (unity_place_entry_service_get_type ())
#define UNITY_PLACE_ENTRY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_ENTRY_SERVICE, UnityPlaceEntryService))
#define UNITY_IS_PLACE_ENTRY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_ENTRY_SERVICE))
#define UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_PLACE_ENTRY_SERVICE, UnityPlaceEntryServiceIface))

typedef struct _UnityPlaceEntryService UnityPlaceEntryService;
typedef struct _UnityPlaceEntryServiceIface UnityPlaceEntryServiceIface;

#define UNITY_TYPE_PLACE_ENTRY_SERVICE_PROXY (unity_place_entry_service_proxy_get_type ())
typedef GDBusProxy UnityPlaceEntryServiceProxy;
typedef GDBusProxyClass UnityPlaceEntryServiceProxyClass;

#define UNITY_TYPE_ACTIVATION (unity_activation_get_type ())
#define UNITY_ACTIVATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_ACTIVATION, UnityActivation))
#define UNITY_IS_ACTIVATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_ACTIVATION))
#define UNITY_ACTIVATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_ACTIVATION, UnityActivationIface))

typedef struct _UnityActivation UnityActivation;
typedef struct _UnityActivationIface UnityActivationIface;

#define UNITY_TYPE_ACTIVATION_PROXY (unity_activation_proxy_get_type ())

#define UNITY_TYPE_PLACE_SERVICE_IMPL (unity_place_service_impl_get_type ())
#define UNITY_PLACE_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_SERVICE_IMPL, UnityPlaceServiceImpl))
#define UNITY_PLACE_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLACE_SERVICE_IMPL, UnityPlaceServiceImplClass))
#define UNITY_IS_PLACE_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_SERVICE_IMPL))
#define UNITY_IS_PLACE_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLACE_SERVICE_IMPL))
#define UNITY_PLACE_SERVICE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLACE_SERVICE_IMPL, UnityPlaceServiceImplClass))

typedef struct _UnityPlaceServiceImpl UnityPlaceServiceImpl;
typedef struct _UnityPlaceServiceImplClass UnityPlaceServiceImplClass;
typedef struct _UnityPlaceServiceImplPrivate UnityPlaceServiceImplPrivate;

#define UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL (unity_place_entry_service_impl_get_type ())
#define UNITY_PLACE_ENTRY_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImpl))
#define UNITY_PLACE_ENTRY_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImplClass))
#define UNITY_IS_PLACE_ENTRY_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL))
#define UNITY_IS_PLACE_ENTRY_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL))
#define UNITY_PLACE_ENTRY_SERVICE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImplClass))

typedef struct _UnityPlaceEntryServiceImpl UnityPlaceEntryServiceImpl;
typedef struct _UnityPlaceEntryServiceImplClass UnityPlaceEntryServiceImplClass;

#define UNITY_TYPE_ACTIVATION_STATUS (unity_activation_status_get_type ())
typedef struct _UnityPlaceServiceImplActivateData UnityPlaceServiceImplActivateData;
typedef struct _UnityPlaceEntryServiceImplPrivate UnityPlaceEntryServiceImplPrivate;

#define UNITY_TYPE_BROWSER_SERVICE (unity_browser_service_get_type ())
#define UNITY_BROWSER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_BROWSER_SERVICE, UnityBrowserService))
#define UNITY_IS_BROWSER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_BROWSER_SERVICE))
#define UNITY_BROWSER_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_BROWSER_SERVICE, UnityBrowserServiceIface))

typedef struct _UnityBrowserService UnityBrowserService;
typedef struct _UnityBrowserServiceIface UnityBrowserServiceIface;

#define UNITY_TYPE_BROWSER_SERVICE_PROXY (unity_browser_service_proxy_get_type ())

#define UNITY_TYPE__BROWSINGSTATE (unity__browsingstate_get_type ())
typedef struct _Unity_BrowsingState Unity_BrowsingState;

#define UNITY_TYPE__PLACEENTRYSIGNALS (unity__placeentrysignals_get_type ())
typedef struct _Unity_PlaceEntrySignals Unity_PlaceEntrySignals;

#define UNITY_TYPE_PLACE_CONTROLLER (unity_place_controller_get_type ())
#define UNITY_PLACE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLACE_CONTROLLER, UnityPlaceController))
#define UNITY_PLACE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLACE_CONTROLLER, UnityPlaceControllerClass))
#define UNITY_IS_PLACE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLACE_CONTROLLER))
#define UNITY_IS_PLACE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLACE_CONTROLLER))
#define UNITY_PLACE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLACE_CONTROLLER, UnityPlaceControllerClass))

typedef struct _UnityPlaceController UnityPlaceController;
typedef struct _UnityPlaceControllerClass UnityPlaceControllerClass;
typedef struct _UnityPlaceControllerPrivate UnityPlaceControllerPrivate;
typedef struct _Block1Data Block1Data;
#define _unity__placeentrysignals_free0(var) ((var == NULL) ? NULL : (var = (unity__placeentrysignals_free (var), NULL)))

struct _Unity_PlaceRendererInfo {
	gchar* default_renderer;
	gchar* groups_model;
	gchar* results_model;
	GHashTable* hints;
};

struct _UnityPlaceRendererInfo {
	GObject parent_instance;
	UnityPlaceRendererInfoPrivate * priv;
};

struct _UnityPlaceRendererInfoClass {
	GObjectClass parent_class;
};

struct _UnityPlaceRendererInfoPrivate {
	Unity_PlaceRendererInfo* info;
	DeeModel* _groups_model;
	DeeModel* _results_model;
};

struct _UnityPlaceSearch {
	GInitiallyUnowned parent_instance;
	UnityPlaceSearchPrivate * priv;
};

struct _UnityPlaceSearchClass {
	GInitiallyUnownedClass parent_class;
};

struct _UnityPlaceSearchPrivate {
	gchar* search;
	GHashTable* hints;
	UnityPlaceEntryInfo* parent_entry;
	guint section;
};

struct _Unity_PlaceEntryInfo {
	gchar* dbus_path;
	gchar* display_name;
	gchar* icon;
	guint position;
	gchar** mimetypes;
	gint mimetypes_length1;
	gint _mimetypes_size_;
	gboolean sensitive;
	gchar* sections_model;
	GHashTable* hints;
	Unity_PlaceRendererInfo entry_renderer_info;
	Unity_PlaceRendererInfo global_renderer_info;
};

struct _Unity_PlaceEntryInfoData {
	gchar* dbus_path;
	gchar* display_name;
	gchar* icon;
	guint position;
	gchar** mimetypes;
	gint mimetypes_length1;
	gint _mimetypes_size_;
	gboolean sensitive;
	gchar* sections_model;
	GHashTable* hints;
};

struct _UnityPlaceEntryInfo {
	GObject parent_instance;
	UnityPlaceEntryInfoPrivate * priv;
};

struct _UnityPlaceEntryInfoClass {
	GObjectClass parent_class;
};

struct _UnityPlaceEntryInfoPrivate {
	Unity_PlaceEntryInfo info;
	UnityPlaceRendererInfo* _entry_renderer_info;
	UnityPlaceRendererInfo* _global_renderer_info;
	DeeModel* _sections_model;
	gboolean _active;
	guint _active_section;
	UnityPlaceSearch* _active_search;
	UnityPlaceSearch* _active_global_search;
	UnityBrowser* _browser;
};

struct _UnityPlaceServiceIface {
	GTypeInterface parent_iface;
	Unity_PlaceEntryInfo* (*get_entries) (UnityPlaceService* self, int* result_length1, GError** error);
};

struct _UnityPlaceEntryServiceIface {
	GTypeInterface parent_iface;
	void (*set_global_search) (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error);
	void (*set_search) (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error);
	void (*set_active) (UnityPlaceEntryService* self, gboolean is_active, GError** error);
	void (*set_active_section) (UnityPlaceEntryService* self, guint section_id, GError** error);
};

struct _UnityActivationIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32 (*activate_finish) (UnityActivation* self, GAsyncResult* _res_, GError** error);
};

struct _UnityPlaceServiceImpl {
	GObject parent_instance;
	UnityPlaceServiceImplPrivate * priv;
};

struct _UnityPlaceServiceImplClass {
	GObjectClass parent_class;
};

struct _UnityPlaceServiceImplPrivate {
	gchar* _dbus_path;
	GHashTable* entries;
	guint _service_dbus_id;
	guint _activation_dbus_id;
	UnityActivation* _activation;
};

typedef enum  {
	UNITY_ACTIVATION_STATUS_NOT_ACTIVATED,
	UNITY_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH,
	UNITY_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH
} UnityActivationStatus;

struct _UnityPlaceServiceImplActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPlaceServiceImpl* self;
	gchar* uri;
	guint32 result;
	guint32 _tmp0_;
	guint32 activated;
	GError * e;
	GError * _inner_error_;
};

struct _UnityPlaceEntryServiceImpl {
	GObject parent_instance;
	UnityPlaceEntryServiceImplPrivate * priv;
};

struct _UnityPlaceEntryServiceImplClass {
	GObjectClass parent_class;
};

struct _UnityPlaceEntryServiceImplPrivate {
	guint _dbus_id;
	UnityPlaceEntryInfo* _entry_info;
	guint place_entry_info_changed_signal_source;
	UnityBrowser* _browser;
	guint _browser_dbus_id;
};

struct _Unity_BrowsingState {
	gboolean sensitive;
	gchar* comment;
};

struct _UnityBrowserServiceIface {
	GTypeInterface parent_iface;
	Unity_BrowsingState* (*go_back) (UnityBrowserService* self, int* result_length1, GError** error);
	Unity_BrowsingState* (*go_forward) (UnityBrowserService* self, int* result_length1, GError** error);
	Unity_BrowsingState* (*get_state) (UnityBrowserService* self, int* result_length1, GError** error);
};

struct _Unity_PlaceEntrySignals {
	gulong place_entry_info_changed_id;
	gulong entry_renderer_info_changed_id;
	gulong global_renderer_info_changed_id;
};

struct _UnityPlaceController {
	GObject parent_instance;
	UnityPlaceControllerPrivate * priv;
};

struct _UnityPlaceControllerClass {
	GObjectClass parent_class;
};

struct _UnityPlaceControllerPrivate {
	UnityPlaceServiceImpl* service;
	gchar* _dbus_path;
	gboolean _exported;
	GHashTable* entry_signals;
	GeeSet* ignore_remote_notify_props;
};

struct _Block1Data {
	int _ref_count_;
	UnityPlaceController * self;
	UnityPlaceEntryInfo* entry;
};


static gpointer unity_place_renderer_info_parent_class = NULL;
static gpointer unity_place_search_parent_class = NULL;
static gpointer unity_place_entry_info_parent_class = NULL;
static gpointer unity_place_service_impl_parent_class = NULL;
static UnityPlaceServiceIface* unity_place_service_impl_unity_place_service_parent_iface = NULL;
static UnityActivationIface* unity_place_service_impl_unity_activation_parent_iface = NULL;
static gpointer unity_place_entry_service_impl_parent_class = NULL;
static UnityPlaceEntryServiceIface* unity_place_entry_service_impl_unity_place_entry_service_parent_iface = NULL;
static gpointer unity_place_controller_parent_class = NULL;

GType unity__placerendererinfo_get_type (void) G_GNUC_CONST;
Unity_PlaceRendererInfo* unity__placerendererinfo_dup (const Unity_PlaceRendererInfo* self);
void unity__placerendererinfo_free (Unity_PlaceRendererInfo* self);
void unity__placerendererinfo_copy (const Unity_PlaceRendererInfo* self, Unity_PlaceRendererInfo* dest);
void unity__placerendererinfo_destroy (Unity_PlaceRendererInfo* self);
GType unity_place_renderer_info_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_RENDERER_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLACE_RENDERER_INFO, UnityPlaceRendererInfoPrivate))
enum  {
	UNITY_PLACE_RENDERER_INFO_DUMMY_PROPERTY,
	UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER,
	UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL,
	UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL
};
UnityPlaceRendererInfo* unity_place_renderer_info_new (Unity_PlaceRendererInfo* info);
UnityPlaceRendererInfo* unity_place_renderer_info_construct (GType object_type, Unity_PlaceRendererInfo* info);
void unity_place_renderer_info_set_hint (UnityPlaceRendererInfo* self, const gchar* hint, const gchar* val);
gchar* unity_place_renderer_info_get_hint (UnityPlaceRendererInfo* self, const gchar* hint);
void unity_place_renderer_info_clear_hint (UnityPlaceRendererInfo* self, const gchar* hint);
void unity_place_renderer_info_clear_hints (UnityPlaceRendererInfo* self);
guint unity_place_renderer_info_num_hints (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_get_raw (UnityPlaceRendererInfo* self, Unity_PlaceRendererInfo* result);
const gchar* unity_place_renderer_info_get_default_renderer (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_set_default_renderer (UnityPlaceRendererInfo* self, const gchar* value);
DeeModel* unity_place_renderer_info_get_groups_model (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_set_groups_model (UnityPlaceRendererInfo* self, DeeModel* value);
DeeModel* unity_place_renderer_info_get_results_model (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_set_results_model (UnityPlaceRendererInfo* self, DeeModel* value);
static void unity_place_renderer_info_finalize (GObject* obj);
static void _vala_unity_place_renderer_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_place_renderer_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_place_search_get_type (void) G_GNUC_CONST;
GType unity_place_entry_info_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLACE_SEARCH, UnityPlaceSearchPrivate))
enum  {
	UNITY_PLACE_SEARCH_DUMMY_PROPERTY
};
UnityPlaceSearch* unity_place_search_new (const gchar* search, GHashTable* hints);
UnityPlaceSearch* unity_place_search_construct (GType object_type, const gchar* search, GHashTable* hints);
gchar* unity_place_search_get_search_string (UnityPlaceSearch* self);
GList* unity_place_search_get_hints (UnityPlaceSearch* self);
void unity_place_search_set_hint (UnityPlaceSearch* self, const gchar* hint, const gchar* val);
gchar* unity_place_search_get_hint (UnityPlaceSearch* self, const gchar* hint);
void unity_place_search_clear_hint (UnityPlaceSearch* self, const gchar* hint);
void unity_place_search_clear_hints (UnityPlaceSearch* self);
guint unity_place_search_num_hints (UnityPlaceSearch* self);
gboolean unity_place_search_equals (UnityPlaceSearch* self, UnityPlaceSearch* other);
void unity_place_search_set_section (UnityPlaceSearch* self, guint section);
guint unity_place_search_get_section (UnityPlaceSearch* self);
void unity_place_search_set_parent_entry (UnityPlaceSearch* self, UnityPlaceEntryInfo* entry);
UnityPlaceEntryInfo* unity_place_search_get_parent_entry (UnityPlaceSearch* self);
void unity_place_search_finished (UnityPlaceSearch* self);
static GVariant* _variant_new15 (GHashTable* value);
void unity_place_entry_info_flush_all_models (UnityPlaceEntryInfo* self);
const gchar* unity_place_entry_info_get_dbus_path (UnityPlaceEntryInfo* self);
static void unity_place_search_finalize (GObject* obj);
GType unity__placeentryinfo_get_type (void) G_GNUC_CONST;
Unity_PlaceEntryInfo* unity__placeentryinfo_dup (const Unity_PlaceEntryInfo* self);
void unity__placeentryinfo_free (Unity_PlaceEntryInfo* self);
void unity__placeentryinfo_copy (const Unity_PlaceEntryInfo* self, Unity_PlaceEntryInfo* dest);
void unity__placeentryinfo_destroy (Unity_PlaceEntryInfo* self);
static gchar** _vala_array_dup5 (gchar** self, int length);
GType unity__placeentryinfodata_get_type (void) G_GNUC_CONST;
Unity_PlaceEntryInfoData* unity__placeentryinfodata_dup (const Unity_PlaceEntryInfoData* self);
void unity__placeentryinfodata_free (Unity_PlaceEntryInfoData* self);
void unity__placeentryinfodata_copy (const Unity_PlaceEntryInfoData* self, Unity_PlaceEntryInfoData* dest);
void unity__placeentryinfodata_destroy (Unity_PlaceEntryInfoData* self);
static gchar** _vala_array_dup6 (gchar** self, int length);
GType unity_browser_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_ENTRY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLACE_ENTRY_INFO, UnityPlaceEntryInfoPrivate))
enum  {
	UNITY_PLACE_ENTRY_INFO_DUMMY_PROPERTY,
	UNITY_PLACE_ENTRY_INFO_ENTRY_RENDERER_INFO,
	UNITY_PLACE_ENTRY_INFO_GLOBAL_RENDERER_INFO,
	UNITY_PLACE_ENTRY_INFO_DBUS_PATH,
	UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME,
	UNITY_PLACE_ENTRY_INFO_ICON,
	UNITY_PLACE_ENTRY_INFO_POSITION,
	UNITY_PLACE_ENTRY_INFO_MIMETYPES,
	UNITY_PLACE_ENTRY_INFO_SENSITIVE,
	UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL,
	UNITY_PLACE_ENTRY_INFO_ACTIVE,
	UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION,
	UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH,
	UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH,
	UNITY_PLACE_ENTRY_INFO_BROWSER
};
UnityPlaceEntryInfo* unity_place_entry_info_new (const gchar* dbus_path);
UnityPlaceEntryInfo* unity_place_entry_info_construct (GType object_type, const gchar* dbus_path);
void unity_place_entry_info_set_hint (UnityPlaceEntryInfo* self, const gchar* hint, const gchar* val);
gchar* unity_place_entry_info_get_hint (UnityPlaceEntryInfo* self, const gchar* hint);
void unity_place_entry_info_clear_hint (UnityPlaceEntryInfo* self, const gchar* hint);
void unity_place_entry_info_clear_hints (UnityPlaceEntryInfo* self);
guint unity_place_entry_info_num_hints (UnityPlaceEntryInfo* self);
DeeModel* unity_place_entry_info_get_sections_model (UnityPlaceEntryInfo* self);
UnityPlaceRendererInfo* unity_place_entry_info_get_entry_renderer_info (UnityPlaceEntryInfo* self);
UnityPlaceRendererInfo* unity_place_entry_info_get_global_renderer_info (UnityPlaceEntryInfo* self);
void unity_place_entry_info_get_raw (UnityPlaceEntryInfo* self, Unity_PlaceEntryInfo* result);
void unity_place_entry_info_set_dbus_path (UnityPlaceEntryInfo* self, const gchar* value);
const gchar* unity_place_entry_info_get_display_name (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_display_name (UnityPlaceEntryInfo* self, const gchar* value);
const gchar* unity_place_entry_info_get_icon (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_icon (UnityPlaceEntryInfo* self, const gchar* value);
guint unity_place_entry_info_get_position (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_position (UnityPlaceEntryInfo* self, guint value);
gchar** unity_place_entry_info_get_mimetypes (UnityPlaceEntryInfo* self, int* result_length1);
void unity_place_entry_info_set_mimetypes (UnityPlaceEntryInfo* self, gchar** value, int value_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gboolean unity_place_entry_info_get_sensitive (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_sensitive (UnityPlaceEntryInfo* self, gboolean value);
void unity_place_entry_info_set_sections_model (UnityPlaceEntryInfo* self, DeeModel* value);
gboolean unity_place_entry_info_get_active (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active (UnityPlaceEntryInfo* self, gboolean value);
guint unity_place_entry_info_get_active_section (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active_section (UnityPlaceEntryInfo* self, guint value);
UnityPlaceSearch* unity_place_entry_info_get_active_search (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value);
UnityPlaceSearch* unity_place_entry_info_get_active_global_search (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active_global_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value);
UnityBrowser* unity_place_entry_info_get_browser (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_browser (UnityPlaceEntryInfo* self, UnityBrowser* value);
const gchar* unity_browser_get_dbus_path (UnityBrowser* self);
static GObject * unity_place_entry_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void unity_place_entry_info_finalize (GObject* obj);
static void _vala_unity_place_entry_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_place_entry_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_place_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_place_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_place_service_get_type (void) G_GNUC_CONST;
Unity_PlaceEntryInfo* unity_place_service_get_entries (UnityPlaceService* self, int* result_length1, GError** error);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_place_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_unity_place_service_entry_added (UnityPlaceService* self, GVariant* parameters);
static void _dbus_handle_unity_place_service_entry_removed (UnityPlaceService* self, GVariant* parameters);
static Unity_PlaceEntryInfo* unity_place_service_proxy_get_entries (UnityPlaceService* self, int* result_length1, GError** error);
static void unity_place_service_proxy_unity_place_service_interface_init (UnityPlaceServiceIface* iface);
static void _vala_Unity_PlaceEntryInfo_array_free (Unity_PlaceEntryInfo* array, gint array_length);
static void _dbus_unity_place_service_get_entries (UnityPlaceService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void unity_place_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_place_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_place_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_place_service_entry_added (GObject* _sender, Unity_PlaceEntryInfo* entry, gpointer* _data);
static void _dbus_unity_place_service_entry_removed (GObject* _sender, const gchar* entry_dbus_path, gpointer* _data);
static void _unity_place_service_unregister_object (gpointer user_data);
GType unity_place_entry_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_place_entry_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_place_entry_service_get_type (void) G_GNUC_CONST;
void unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error);
void unity_place_entry_service_set_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error);
void unity_place_entry_service_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error);
void unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_place_entry_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_unity_place_entry_service_entry_renderer_info_changed (UnityPlaceEntryService* self, GVariant* parameters);
static void _dbus_handle_unity_place_entry_service_global_renderer_info_changed (UnityPlaceEntryService* self, GVariant* parameters);
static void _dbus_handle_unity_place_entry_service_place_entry_info_changed (UnityPlaceEntryService* self, GVariant* parameters);
static void _dbus_handle_unity_place_entry_service_search_finished (UnityPlaceEntryService* self, GVariant* parameters);
static void unity_place_entry_service_proxy_set_global_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_proxy_set_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_proxy_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error);
static void unity_place_entry_service_proxy_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error);
static void unity_place_entry_service_proxy_unity_place_entry_service_interface_init (UnityPlaceEntryServiceIface* iface);
static void _dbus_unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_place_entry_service_set_search (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_place_entry_service_set_active (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void unity_place_entry_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_place_entry_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_place_entry_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_place_entry_service_entry_renderer_info_changed (GObject* _sender, Unity_PlaceRendererInfo* renderer_info, gpointer* _data);
static void _dbus_unity_place_entry_service_global_renderer_info_changed (GObject* _sender, Unity_PlaceRendererInfo* renderer_info, gpointer* _data);
static void _dbus_unity_place_entry_service_place_entry_info_changed (GObject* _sender, Unity_PlaceEntryInfoData* entry_info_data, gpointer* _data);
static void _dbus_unity_place_entry_service_search_finished (GObject* _sender, guint section, const gchar* search, GHashTable* hints, gpointer* _data);
static void _unity_place_entry_service_unregister_object (gpointer user_data);
GType unity_activation_proxy_get_type (void) G_GNUC_CONST;
guint unity_activation_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_get_type (void) G_GNUC_CONST;
GType unity_place_service_impl_get_type (void) G_GNUC_CONST;
GType unity_place_entry_service_impl_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_SERVICE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLACE_SERVICE_IMPL, UnityPlaceServiceImplPrivate))
enum  {
	UNITY_PLACE_SERVICE_IMPL_DUMMY_PROPERTY,
	UNITY_PLACE_SERVICE_IMPL_DBUS_PATH,
	UNITY_PLACE_SERVICE_IMPL_EXPORTED,
	UNITY_PLACE_SERVICE_IMPL_ACTIVATION
};
UnityPlaceServiceImpl* unity_place_service_impl_new (const gchar* dbus_path);
UnityPlaceServiceImpl* unity_place_service_impl_construct (GType object_type, const gchar* dbus_path);
static Unity_PlaceEntryInfo* unity_place_service_impl_real_get_entries (UnityPlaceService* base, int* result_length1, GError** error);
UnityPlaceEntryInfo* unity_place_entry_service_impl_get_entry_info (UnityPlaceEntryServiceImpl* self);
void unity_place_service_impl_add_entry (UnityPlaceServiceImpl* self, UnityPlaceEntryInfo* entry_info);
UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_new (UnityPlaceEntryInfo* entry_info);
UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_construct (GType object_type, UnityPlaceEntryInfo* entry_info);
gboolean unity_place_service_impl_get_exported (UnityPlaceServiceImpl* self);
void unity_place_entry_service_impl_export (UnityPlaceEntryServiceImpl* self, GError** error);
UnityPlaceEntryInfo* unity_place_service_impl_get_entry (UnityPlaceServiceImpl* self, const gchar* dbus_path);
UnityPlaceEntryServiceImpl* unity_place_service_impl_get_entry_service (UnityPlaceServiceImpl* self, const gchar* dbus_path);
guint unity_place_service_impl_num_entries (UnityPlaceServiceImpl* self);
gchar** unity_place_service_impl_get_entry_paths (UnityPlaceServiceImpl* self, int* result_length1);
void unity_place_service_impl_remove_entry (UnityPlaceServiceImpl* self, const gchar* dbus_path);
void unity_place_entry_service_impl_unexport (UnityPlaceEntryServiceImpl* self, GError** error);
void unity_place_service_impl_export (UnityPlaceServiceImpl* self, GError** error);
void unity_place_service_impl_unexport (UnityPlaceServiceImpl* self, GError** error);
static void unity_place_service_impl_real_activate_data_free (gpointer _data);
static void unity_place_service_impl_real_activate (UnityActivation* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_place_service_impl_real_activate_co (UnityPlaceServiceImplActivateData* data);
UnityActivation* unity_place_service_impl_get_activation (UnityPlaceServiceImpl* self);
GType unity_activation_status_get_type (void) G_GNUC_CONST;
void unity_activation_activate (UnityActivation* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32 unity_activation_activate_finish (UnityActivation* self, GAsyncResult* _res_, GError** error);
static void unity_place_service_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* unity_place_service_impl_get_dbus_path (UnityPlaceServiceImpl* self);
static void unity_place_service_impl_set_dbus_path (UnityPlaceServiceImpl* self, const gchar* value);
void unity_place_service_impl_set_activation (UnityPlaceServiceImpl* self, UnityActivation* value);
static GObject * unity_place_service_impl_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void unity_place_service_impl_finalize (GObject* obj);
static void _vala_unity_place_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_place_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLACE_ENTRY_SERVICE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImplPrivate))
enum  {
	UNITY_PLACE_ENTRY_SERVICE_IMPL_DUMMY_PROPERTY,
	UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO,
	UNITY_PLACE_ENTRY_SERVICE_IMPL_EXPORTED
};
static void unity_place_entry_service_impl_on_browser_changed (UnityPlaceEntryServiceImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_place_entry_service_impl_on_browser_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_place_entry_service_impl_real_set_global_search (UnityPlaceEntryService* base, const gchar* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_impl_real_set_search (UnityPlaceEntryService* base, const gchar* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_impl_real_set_active (UnityPlaceEntryService* base, gboolean is_active, GError** error);
static void unity_place_entry_service_impl_real_set_active_section (UnityPlaceEntryService* base, guint section_id, GError** error);
GType unity_browser_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_browser_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity__browsingstate_get_type (void) G_GNUC_CONST;
Unity_BrowsingState* unity__browsingstate_dup (const Unity_BrowsingState* self);
void unity__browsingstate_free (Unity_BrowsingState* self);
void unity__browsingstate_copy (const Unity_BrowsingState* self, Unity_BrowsingState* dest);
void unity__browsingstate_destroy (Unity_BrowsingState* self);
GType unity_browser_service_get_type (void) G_GNUC_CONST;
UnityBrowserService* unity_browser_get_service (UnityBrowser* self);
void unity_place_entry_service_impl_queue_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self);
static gboolean unity_place_entry_service_impl_emit_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self);
static gboolean _unity_place_entry_service_impl_emit_place_entry_info_changed_signal_gsource_func (gpointer self);
static gchar** _vala_array_dup8 (gchar** self, int length);
static void unity_place_entry_service_impl_set_entry_info (UnityPlaceEntryServiceImpl* self, UnityPlaceEntryInfo* value);
gboolean unity_place_entry_service_impl_get_exported (UnityPlaceEntryServiceImpl* self);
static void unity_place_entry_service_impl_finalize (GObject* obj);
static void _vala_unity_place_entry_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_place_entry_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity__placeentrysignals_get_type (void) G_GNUC_CONST;
Unity_PlaceEntrySignals* unity__placeentrysignals_dup (const Unity_PlaceEntrySignals* self);
void unity__placeentrysignals_free (Unity_PlaceEntrySignals* self);
GType unity_place_controller_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLACE_CONTROLLER, UnityPlaceControllerPrivate))
enum  {
	UNITY_PLACE_CONTROLLER_DUMMY_PROPERTY,
	UNITY_PLACE_CONTROLLER_DBUS_PATH,
	UNITY_PLACE_CONTROLLER_EXPORTED,
	UNITY_PLACE_CONTROLLER_ACTIVATION
};
UnityPlaceController* unity_place_controller_new (const gchar* dbus_path);
UnityPlaceController* unity_place_controller_construct (GType object_type, const gchar* dbus_path);
void unity_place_controller_add_entry (UnityPlaceController* self, UnityPlaceEntryInfo* entry);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void unity_place_controller_on_entry_changed (UnityPlaceController* self, GObject* obj, GParamSpec* pspec);
static void _unity_place_controller_on_entry_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda0_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_);
static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda1_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_);
static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
UnityPlaceEntryInfo* unity_place_controller_get_entry (UnityPlaceController* self, const gchar* dbus_path);
void unity_place_controller_remove_entry (UnityPlaceController* self, const gchar* dbus_path);
guint unity_place_controller_num_entries (UnityPlaceController* self);
gchar** unity_place_controller_get_entry_paths (UnityPlaceController* self, int* result_length1);
UnityPlaceEntryInfo** unity_place_controller_get_entries (UnityPlaceController* self, int* result_length1);
void unity_place_controller_export (UnityPlaceController* self, GError** error);
void unity_place_controller_unexport (UnityPlaceController* self, GError** error);
const gchar* unity_place_controller_get_dbus_path (UnityPlaceController* self);
static void unity_place_controller_set_dbus_path (UnityPlaceController* self, const gchar* value);
gboolean unity_place_controller_get_exported (UnityPlaceController* self);
UnityActivation* unity_place_controller_get_activation (UnityPlaceController* self);
void unity_place_controller_set_activation (UnityPlaceController* self, UnityActivation* value);
static GObject * unity_place_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity__placeentrysignals_free0_ (gpointer var);
static void unity_place_controller_finalize (GObject* obj);
static void _vala_unity_place_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_place_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _unity_place_service_dbus_arg_info_get_entries_result = {-1, "result", "a(sssuasbsa{ss}(sssa{ss})(sssa{ss}))"};
static const GDBusArgInfo * const _unity_place_service_dbus_arg_info_get_entries_in[] = {NULL};
static const GDBusArgInfo * const _unity_place_service_dbus_arg_info_get_entries_out[] = {&_unity_place_service_dbus_arg_info_get_entries_result, NULL};
static const GDBusMethodInfo _unity_place_service_dbus_method_info_get_entries = {-1, "GetEntries", (GDBusArgInfo **) (&_unity_place_service_dbus_arg_info_get_entries_in), (GDBusArgInfo **) (&_unity_place_service_dbus_arg_info_get_entries_out)};
static const GDBusMethodInfo * const _unity_place_service_dbus_method_info[] = {&_unity_place_service_dbus_method_info_get_entries, NULL};
static const GDBusArgInfo _unity_place_service_dbus_arg_info_entry_added_entry = {-1, "entry", "(sssuasbsa{ss}(sssa{ss})(sssa{ss}))"};
static const GDBusArgInfo * const _unity_place_service_dbus_arg_info_entry_added[] = {&_unity_place_service_dbus_arg_info_entry_added_entry, NULL};
static const GDBusSignalInfo _unity_place_service_dbus_signal_info_entry_added = {-1, "EntryAdded", (GDBusArgInfo **) (&_unity_place_service_dbus_arg_info_entry_added)};
static const GDBusArgInfo _unity_place_service_dbus_arg_info_entry_removed_entry_dbus_path = {-1, "entry_dbus_path", "s"};
static const GDBusArgInfo * const _unity_place_service_dbus_arg_info_entry_removed[] = {&_unity_place_service_dbus_arg_info_entry_removed_entry_dbus_path, NULL};
static const GDBusSignalInfo _unity_place_service_dbus_signal_info_entry_removed = {-1, "EntryRemoved", (GDBusArgInfo **) (&_unity_place_service_dbus_arg_info_entry_removed)};
static const GDBusSignalInfo * const _unity_place_service_dbus_signal_info[] = {&_unity_place_service_dbus_signal_info_entry_added, &_unity_place_service_dbus_signal_info_entry_removed, NULL};
static const GDBusPropertyInfo * const _unity_place_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_place_service_dbus_interface_info = {-1, "com.canonical.Unity.Place", (GDBusMethodInfo **) (&_unity_place_service_dbus_method_info), (GDBusSignalInfo **) (&_unity_place_service_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_place_service_dbus_property_info)};
static const GDBusInterfaceVTable _unity_place_service_dbus_interface_vtable = {unity_place_service_dbus_interface_method_call, unity_place_service_dbus_interface_get_property, unity_place_service_dbus_interface_set_property};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_set_global_search_search = {-1, "search", "s"};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_set_global_search_hints = {-1, "hints", "a{ss}"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_global_search_in[] = {&_unity_place_entry_service_dbus_arg_info_set_global_search_search, &_unity_place_entry_service_dbus_arg_info_set_global_search_hints, NULL};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_global_search_out[] = {NULL};
static const GDBusMethodInfo _unity_place_entry_service_dbus_method_info_set_global_search = {-1, "SetGlobalSearch", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_global_search_in), (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_global_search_out)};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_set_search_search = {-1, "search", "s"};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_set_search_hints = {-1, "hints", "a{ss}"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_search_in[] = {&_unity_place_entry_service_dbus_arg_info_set_search_search, &_unity_place_entry_service_dbus_arg_info_set_search_hints, NULL};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_search_out[] = {NULL};
static const GDBusMethodInfo _unity_place_entry_service_dbus_method_info_set_search = {-1, "SetSearch", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_search_in), (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_search_out)};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_set_active_is_active = {-1, "is_active", "b"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_active_in[] = {&_unity_place_entry_service_dbus_arg_info_set_active_is_active, NULL};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_active_out[] = {NULL};
static const GDBusMethodInfo _unity_place_entry_service_dbus_method_info_set_active = {-1, "SetActive", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_active_in), (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_active_out)};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_set_active_section_section_id = {-1, "section_id", "u"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_active_section_in[] = {&_unity_place_entry_service_dbus_arg_info_set_active_section_section_id, NULL};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_set_active_section_out[] = {NULL};
static const GDBusMethodInfo _unity_place_entry_service_dbus_method_info_set_active_section = {-1, "SetActiveSection", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_active_section_in), (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_set_active_section_out)};
static const GDBusMethodInfo * const _unity_place_entry_service_dbus_method_info[] = {&_unity_place_entry_service_dbus_method_info_set_global_search, &_unity_place_entry_service_dbus_method_info_set_search, &_unity_place_entry_service_dbus_method_info_set_active, &_unity_place_entry_service_dbus_method_info_set_active_section, NULL};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_entry_renderer_info_changed_renderer_info = {-1, "renderer_info", "(sssa{ss})"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_entry_renderer_info_changed[] = {&_unity_place_entry_service_dbus_arg_info_entry_renderer_info_changed_renderer_info, NULL};
static const GDBusSignalInfo _unity_place_entry_service_dbus_signal_info_entry_renderer_info_changed = {-1, "EntryRendererInfoChanged", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_entry_renderer_info_changed)};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_global_renderer_info_changed_renderer_info = {-1, "renderer_info", "(sssa{ss})"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_global_renderer_info_changed[] = {&_unity_place_entry_service_dbus_arg_info_global_renderer_info_changed_renderer_info, NULL};
static const GDBusSignalInfo _unity_place_entry_service_dbus_signal_info_global_renderer_info_changed = {-1, "GlobalRendererInfoChanged", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_global_renderer_info_changed)};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_place_entry_info_changed_entry_info_data = {-1, "entry_info_data", "(sssuasbsa{ss})"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_place_entry_info_changed[] = {&_unity_place_entry_service_dbus_arg_info_place_entry_info_changed_entry_info_data, NULL};
static const GDBusSignalInfo _unity_place_entry_service_dbus_signal_info_place_entry_info_changed = {-1, "PlaceEntryInfoChanged", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_place_entry_info_changed)};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_search_finished_section = {-1, "section", "u"};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_search_finished_search = {-1, "search", "s"};
static const GDBusArgInfo _unity_place_entry_service_dbus_arg_info_search_finished_hints = {-1, "hints", "a{ss}"};
static const GDBusArgInfo * const _unity_place_entry_service_dbus_arg_info_search_finished[] = {&_unity_place_entry_service_dbus_arg_info_search_finished_section, &_unity_place_entry_service_dbus_arg_info_search_finished_search, &_unity_place_entry_service_dbus_arg_info_search_finished_hints, NULL};
static const GDBusSignalInfo _unity_place_entry_service_dbus_signal_info_search_finished = {-1, "SearchFinished", (GDBusArgInfo **) (&_unity_place_entry_service_dbus_arg_info_search_finished)};
static const GDBusSignalInfo * const _unity_place_entry_service_dbus_signal_info[] = {&_unity_place_entry_service_dbus_signal_info_entry_renderer_info_changed, &_unity_place_entry_service_dbus_signal_info_global_renderer_info_changed, &_unity_place_entry_service_dbus_signal_info_place_entry_info_changed, &_unity_place_entry_service_dbus_signal_info_search_finished, NULL};
static const GDBusPropertyInfo * const _unity_place_entry_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_place_entry_service_dbus_interface_info = {-1, "com.canonical.Unity.PlaceEntry", (GDBusMethodInfo **) (&_unity_place_entry_service_dbus_method_info), (GDBusSignalInfo **) (&_unity_place_entry_service_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_place_entry_service_dbus_property_info)};
static const GDBusInterfaceVTable _unity_place_entry_service_dbus_interface_vtable = {unity_place_entry_service_dbus_interface_method_call, unity_place_entry_service_dbus_interface_get_property, unity_place_entry_service_dbus_interface_set_property};

static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity__placerendererinfo_copy (const Unity_PlaceRendererInfo* self, Unity_PlaceRendererInfo* dest) {
	dest->default_renderer = g_strdup (self->default_renderer);
	dest->groups_model = g_strdup (self->groups_model);
	dest->results_model = g_strdup (self->results_model);
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity__placerendererinfo_destroy (Unity_PlaceRendererInfo* self) {
	_g_free0 ((*self).default_renderer);
	_g_free0 ((*self).groups_model);
	_g_free0 ((*self).results_model);
	_g_hash_table_unref0 ((*self).hints);
}


Unity_PlaceRendererInfo* unity__placerendererinfo_dup (const Unity_PlaceRendererInfo* self) {
	Unity_PlaceRendererInfo* dup;
	dup = g_new0 (Unity_PlaceRendererInfo, 1);
	unity__placerendererinfo_copy (self, dup);
	return dup;
}


void unity__placerendererinfo_free (Unity_PlaceRendererInfo* self) {
	unity__placerendererinfo_destroy (self);
	g_free (self);
}


GType unity__placerendererinfo_get_type (void) {
	static volatile gsize unity__placerendererinfo_type_id__volatile = 0;
	if (g_once_init_enter (&unity__placerendererinfo_type_id__volatile)) {
		GType unity__placerendererinfo_type_id;
		unity__placerendererinfo_type_id = g_boxed_type_register_static ("Unity_PlaceRendererInfo", (GBoxedCopyFunc) unity__placerendererinfo_dup, (GBoxedFreeFunc) unity__placerendererinfo_free);
		g_once_init_leave (&unity__placerendererinfo_type_id__volatile, unity__placerendererinfo_type_id);
	}
	return unity__placerendererinfo_type_id__volatile;
}


UnityPlaceRendererInfo* unity_place_renderer_info_construct (GType object_type, Unity_PlaceRendererInfo* info) {
	UnityPlaceRendererInfo * self = NULL;
	self = (UnityPlaceRendererInfo*) g_object_new (object_type, NULL);
	self->priv->info = info;
	return self;
}


UnityPlaceRendererInfo* unity_place_renderer_info_new (Unity_PlaceRendererInfo* info) {
	return unity_place_renderer_info_construct (UNITY_TYPE_PLACE_RENDERER_INFO, info);
}


void unity_place_renderer_info_set_hint (UnityPlaceRendererInfo* self, const gchar* hint, const gchar* val) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_strdup (hint);
	_tmp1_ = g_strdup (val);
	g_hash_table_insert ((*self->priv->info).hints, _tmp0_, _tmp1_);
}


gchar* unity_place_renderer_info_get_hint (UnityPlaceRendererInfo* self, const gchar* hint) {
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hint != NULL, NULL);
	_tmp0_ = g_hash_table_lookup ((*self->priv->info).hints, hint);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	result = _tmp1_;
	return result;
}


void unity_place_renderer_info_clear_hint (UnityPlaceRendererInfo* self, const gchar* hint) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_hash_table_remove ((*self->priv->info).hints, hint);
}


void unity_place_renderer_info_clear_hints (UnityPlaceRendererInfo* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all ((*self->priv->info).hints);
}


guint unity_place_renderer_info_num_hints (UnityPlaceRendererInfo* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_hash_table_size ((*self->priv->info).hints);
	result = _tmp0_;
	return result;
}


void unity_place_renderer_info_get_raw (UnityPlaceRendererInfo* self, Unity_PlaceRendererInfo* result) {
	Unity_PlaceRendererInfo _tmp0_;
	Unity_PlaceRendererInfo _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	unity__placerendererinfo_copy (self->priv->info, &_tmp1_);
	_tmp0_ = _tmp1_;
	*result = _tmp0_;
	return;
}


const gchar* unity_place_renderer_info_get_default_renderer (UnityPlaceRendererInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (*self->priv->info).default_renderer;
	return result;
}


void unity_place_renderer_info_set_default_renderer (UnityPlaceRendererInfo* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 ((*self->priv->info).default_renderer);
	(*self->priv->info).default_renderer = _tmp0_;
	g_object_notify ((GObject *) self, "default-renderer");
}


DeeModel* unity_place_renderer_info_get_groups_model (UnityPlaceRendererInfo* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_groups_model;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_place_renderer_info_set_groups_model (UnityPlaceRendererInfo* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_groups_model);
	self->priv->_groups_model = _tmp0_;
	if (DEE_IS_SHARED_MODEL (value)) {
		DeeModel* _tmp1_;
		DeeSharedModel* _tmp2_;
		DeeSharedModel* model;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = value;
		_tmp2_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL);
		model = _tmp2_;
		_tmp3_ = dee_shared_model_get_swarm_name (model);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 ((*self->priv->info).groups_model);
		(*self->priv->info).groups_model = _tmp4_;
		_g_object_unref0 (model);
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("__local__");
		_g_free0 ((*self->priv->info).groups_model);
		(*self->priv->info).groups_model = _tmp5_;
	}
	g_object_notify ((GObject *) self, "groups-model");
}


DeeModel* unity_place_renderer_info_get_results_model (UnityPlaceRendererInfo* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_results_model;
	return result;
}


void unity_place_renderer_info_set_results_model (UnityPlaceRendererInfo* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_results_model);
	self->priv->_results_model = _tmp0_;
	if (DEE_IS_SHARED_MODEL (value)) {
		DeeModel* _tmp1_;
		DeeSharedModel* _tmp2_;
		DeeSharedModel* model;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = value;
		_tmp2_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL);
		model = _tmp2_;
		_tmp3_ = dee_shared_model_get_swarm_name (model);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 ((*self->priv->info).results_model);
		(*self->priv->info).results_model = _tmp4_;
		_g_object_unref0 (model);
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("__local__");
		_g_free0 ((*self->priv->info).results_model);
		(*self->priv->info).results_model = _tmp5_;
	}
	g_object_notify ((GObject *) self, "results-model");
}


static void unity_place_renderer_info_class_init (UnityPlaceRendererInfoClass * klass) {
	unity_place_renderer_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceRendererInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_place_renderer_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_place_renderer_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_place_renderer_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER, g_param_spec_string ("default-renderer", "default-renderer", "default-renderer", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL, g_param_spec_object ("groups-model", "groups-model", "groups-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL, g_param_spec_object ("results-model", "results-model", "results-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_renderer_info_instance_init (UnityPlaceRendererInfo * self) {
	self->priv = UNITY_PLACE_RENDERER_INFO_GET_PRIVATE (self);
}


static void unity_place_renderer_info_finalize (GObject* obj) {
	UnityPlaceRendererInfo * self;
	self = UNITY_PLACE_RENDERER_INFO (obj);
	_g_object_unref0 (self->priv->_groups_model);
	_g_object_unref0 (self->priv->_results_model);
	G_OBJECT_CLASS (unity_place_renderer_info_parent_class)->finalize (obj);
}


/**
   * SECTION:unity-place-renderer-info
   * @short_description: Encapsulates all place entry metadata the Unity shell needs in order to render this model
   * @include: unity.h
   *
   *
   */
GType unity_place_renderer_info_get_type (void) {
	static volatile gsize unity_place_renderer_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_renderer_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceRendererInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_renderer_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceRendererInfo), 0, (GInstanceInitFunc) unity_place_renderer_info_instance_init, NULL };
		GType unity_place_renderer_info_type_id;
		unity_place_renderer_info_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceRendererInfo", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_renderer_info_type_id__volatile, unity_place_renderer_info_type_id);
	}
	return unity_place_renderer_info_type_id__volatile;
}


static void _vala_unity_place_renderer_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceRendererInfo * self;
	self = UNITY_PLACE_RENDERER_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER:
		g_value_set_string (value, unity_place_renderer_info_get_default_renderer (self));
		break;
		case UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL:
		g_value_set_object (value, unity_place_renderer_info_get_groups_model (self));
		break;
		case UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL:
		g_value_set_object (value, unity_place_renderer_info_get_results_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_place_renderer_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceRendererInfo * self;
	self = UNITY_PLACE_RENDERER_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER:
		unity_place_renderer_info_set_default_renderer (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL:
		unity_place_renderer_info_set_groups_model (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL:
		unity_place_renderer_info_set_results_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlaceSearch* unity_place_search_construct (GType object_type, const gchar* search, GHashTable* hints) {
	UnityPlaceSearch * self = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	g_return_val_if_fail (search != NULL, NULL);
	g_return_val_if_fail (hints != NULL, NULL);
	self = (UnityPlaceSearch*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (search);
	_g_free0 (self->priv->search);
	self->priv->search = _tmp0_;
	_tmp1_ = _g_hash_table_ref0 (hints);
	_g_hash_table_unref0 (self->priv->hints);
	self->priv->hints = _tmp1_;
	self->priv->parent_entry = NULL;
	self->priv->section = (guint) 0;
	return self;
}


UnityPlaceSearch* unity_place_search_new (const gchar* search, GHashTable* hints) {
	return unity_place_search_construct (UNITY_TYPE_PLACE_SEARCH, search, hints);
}


gchar* unity_place_search_get_search_string (UnityPlaceSearch* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->search);
	result = _tmp0_;
	return result;
}


GList* unity_place_search_get_hints (UnityPlaceSearch* self) {
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_get_keys (self->priv->hints);
	result = _tmp0_;
	return result;
}


void unity_place_search_set_hint (UnityPlaceSearch* self, const gchar* hint, const gchar* val) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_strdup (hint);
	_tmp1_ = g_strdup (val);
	g_hash_table_insert (self->priv->hints, _tmp0_, _tmp1_);
}


gchar* unity_place_search_get_hint (UnityPlaceSearch* self, const gchar* hint) {
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hint != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->hints, hint);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	result = _tmp1_;
	return result;
}


void unity_place_search_clear_hint (UnityPlaceSearch* self, const gchar* hint) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_hash_table_remove (self->priv->hints, hint);
}


void unity_place_search_clear_hints (UnityPlaceSearch* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all (self->priv->hints);
}


guint unity_place_search_num_hints (UnityPlaceSearch* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_hash_table_size (self->priv->hints);
	result = _tmp0_;
	return result;
}


gboolean unity_place_search_equals (UnityPlaceSearch* self, UnityPlaceSearch* other) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GList* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (other == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = unity_place_search_get_search_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = unity_place_search_get_search_string (other);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) != 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = unity_place_search_num_hints (self);
	_tmp6_ = unity_place_search_num_hints (other);
	if (_tmp5_ != _tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = unity_place_search_get_hints (self);
	{
		GList* hint_collection;
		GList* hint_it;
		hint_collection = _tmp7_;
		for (hint_it = hint_collection; hint_it != NULL; hint_it = hint_it->next) {
			const gchar* hint;
			hint = (const gchar*) hint_it->data;
			{
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gboolean _tmp12_;
				_tmp8_ = unity_place_search_get_hint (other, hint);
				_tmp9_ = _tmp8_;
				_tmp10_ = unity_place_search_get_hint (self, hint);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strcmp0 (_tmp9_, _tmp11_) != 0;
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				if (_tmp12_) {
					result = FALSE;
					_g_list_free0 (hint_collection);
					return result;
				}
			}
		}
		_g_list_free0 (hint_collection);
	}
	result = TRUE;
	return result;
}


void unity_place_search_set_section (UnityPlaceSearch* self, guint section) {
	g_return_if_fail (self != NULL);
	self->priv->section = section;
}


guint unity_place_search_get_section (UnityPlaceSearch* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->section;
	return result;
}


void unity_place_search_set_parent_entry (UnityPlaceSearch* self, UnityPlaceEntryInfo* entry) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	self->priv->parent_entry = entry;
}


UnityPlaceEntryInfo* unity_place_search_get_parent_entry (UnityPlaceSearch* self) {
	UnityPlaceEntryInfo* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->parent_entry;
	return result;
}


static GVariant* _variant_new15 (GHashTable* value) {
	GVariantBuilder _tmp0_;
	GHashTableIter _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	g_hash_table_iter_init (&_tmp1_, value);
	g_variant_builder_init (&_tmp0_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp1_, &_tmp2_, &_tmp3_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp2_;
		_value = (gchar*) _tmp3_;
		g_variant_builder_add (&_tmp0_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp0_));
}


void unity_place_search_finished (UnityPlaceSearch* self) {
	GVariant* vhints;
	GVariant* _tmp4_ = NULL;
	GVariant* params;
	GDBusConnection* _tmp5_ = NULL;
	GDBusConnection* conn;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->parent_entry == NULL) {
		return;
	}
	vhints = _variant_new15 (self->priv->hints);
	_tmp4_ = g_variant_new ("(us@a{ss})", self->priv->section, self->priv->search, vhints, NULL);
	params = g_variant_ref_sink (_tmp4_);
	_tmp5_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (params);
		_g_variant_unref0 (vhints);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch15_g_io_error;
		}
		_g_variant_unref0 (params);
		_g_variant_unref0 (vhints);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	unity_place_entry_info_flush_all_models (self->priv->parent_entry);
	_tmp6_ = unity_place_entry_info_get_dbus_path (self->priv->parent_entry);
	g_dbus_connection_emit_signal (conn, NULL, _tmp6_, "com.canonical.Unity.PlaceEntry", "SearchFinished", params, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conn);
		_g_variant_unref0 (params);
		_g_variant_unref0 (vhints);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch15_g_io_error;
		}
		goto __finally15;
	}
	_g_object_unref0 (conn);
	_g_variant_unref0 (params);
	_g_variant_unref0 (vhints);
	goto __finally15;
	__catch15_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-place.vala:270: Failed to emit com.canonical.Unity.PlaceEntry.Se" \
"archFinished: %s", e->message);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void unity_place_search_class_init (UnityPlaceSearchClass * klass) {
	unity_place_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceSearchPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_place_search_finalize;
}


static void unity_place_search_instance_init (UnityPlaceSearch * self) {
	self->priv = UNITY_PLACE_SEARCH_GET_PRIVATE (self);
}


static void unity_place_search_finalize (GObject* obj) {
	UnityPlaceSearch * self;
	self = UNITY_PLACE_SEARCH (obj);
	_g_free0 (self->priv->search);
	_g_hash_table_unref0 (self->priv->hints);
	G_OBJECT_CLASS (unity_place_search_parent_class)->finalize (obj);
}


/**
   *
   */
GType unity_place_search_get_type (void) {
	static volatile gsize unity_place_search_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceSearch), 0, (GInstanceInitFunc) unity_place_search_instance_init, NULL };
		GType unity_place_search_type_id;
		unity_place_search_type_id = g_type_register_static (G_TYPE_INITIALLY_UNOWNED, "UnityPlaceSearch", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_search_type_id__volatile, unity_place_search_type_id);
	}
	return unity_place_search_type_id__volatile;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity__placeentryinfo_copy (const Unity_PlaceEntryInfo* self, Unity_PlaceEntryInfo* dest) {
	gchar** _tmp0_;
	Unity_PlaceRendererInfo _tmp1_ = {0};
	Unity_PlaceRendererInfo _tmp2_ = {0};
	dest->dbus_path = g_strdup (self->dbus_path);
	dest->display_name = g_strdup (self->display_name);
	dest->icon = g_strdup (self->icon);
	dest->position = self->position;
	dest->mimetypes = (_tmp0_ = self->mimetypes, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup5 (_tmp0_, (*self).mimetypes_length1));
	dest->mimetypes_length1 = self->mimetypes_length1;
	dest->sensitive = self->sensitive;
	dest->sections_model = g_strdup (self->sections_model);
	dest->hints = _g_hash_table_ref0 (self->hints);
	unity__placerendererinfo_copy (&self->entry_renderer_info, &_tmp1_);
	dest->entry_renderer_info = _tmp1_;
	unity__placerendererinfo_copy (&self->global_renderer_info, &_tmp2_);
	dest->global_renderer_info = _tmp2_;
}


void unity__placeentryinfo_destroy (Unity_PlaceEntryInfo* self) {
	_g_free0 ((*self).dbus_path);
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).icon);
	(*self).mimetypes = (_vala_array_free ((*self).mimetypes, (*self).mimetypes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 ((*self).sections_model);
	_g_hash_table_unref0 ((*self).hints);
	unity__placerendererinfo_destroy (&(*self).entry_renderer_info);
	unity__placerendererinfo_destroy (&(*self).global_renderer_info);
}


Unity_PlaceEntryInfo* unity__placeentryinfo_dup (const Unity_PlaceEntryInfo* self) {
	Unity_PlaceEntryInfo* dup;
	dup = g_new0 (Unity_PlaceEntryInfo, 1);
	unity__placeentryinfo_copy (self, dup);
	return dup;
}


void unity__placeentryinfo_free (Unity_PlaceEntryInfo* self) {
	unity__placeentryinfo_destroy (self);
	g_free (self);
}


GType unity__placeentryinfo_get_type (void) {
	static volatile gsize unity__placeentryinfo_type_id__volatile = 0;
	if (g_once_init_enter (&unity__placeentryinfo_type_id__volatile)) {
		GType unity__placeentryinfo_type_id;
		unity__placeentryinfo_type_id = g_boxed_type_register_static ("Unity_PlaceEntryInfo", (GBoxedCopyFunc) unity__placeentryinfo_dup, (GBoxedFreeFunc) unity__placeentryinfo_free);
		g_once_init_leave (&unity__placeentryinfo_type_id__volatile, unity__placeentryinfo_type_id);
	}
	return unity__placeentryinfo_type_id__volatile;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity__placeentryinfodata_copy (const Unity_PlaceEntryInfoData* self, Unity_PlaceEntryInfoData* dest) {
	gchar** _tmp0_;
	dest->dbus_path = g_strdup (self->dbus_path);
	dest->display_name = g_strdup (self->display_name);
	dest->icon = g_strdup (self->icon);
	dest->position = self->position;
	dest->mimetypes = (_tmp0_ = self->mimetypes, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup6 (_tmp0_, (*self).mimetypes_length1));
	dest->mimetypes_length1 = self->mimetypes_length1;
	dest->sensitive = self->sensitive;
	dest->sections_model = g_strdup (self->sections_model);
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity__placeentryinfodata_destroy (Unity_PlaceEntryInfoData* self) {
	_g_free0 ((*self).dbus_path);
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).icon);
	(*self).mimetypes = (_vala_array_free ((*self).mimetypes, (*self).mimetypes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 ((*self).sections_model);
	_g_hash_table_unref0 ((*self).hints);
}


Unity_PlaceEntryInfoData* unity__placeentryinfodata_dup (const Unity_PlaceEntryInfoData* self) {
	Unity_PlaceEntryInfoData* dup;
	dup = g_new0 (Unity_PlaceEntryInfoData, 1);
	unity__placeentryinfodata_copy (self, dup);
	return dup;
}


void unity__placeentryinfodata_free (Unity_PlaceEntryInfoData* self) {
	unity__placeentryinfodata_destroy (self);
	g_free (self);
}


GType unity__placeentryinfodata_get_type (void) {
	static volatile gsize unity__placeentryinfodata_type_id__volatile = 0;
	if (g_once_init_enter (&unity__placeentryinfodata_type_id__volatile)) {
		GType unity__placeentryinfodata_type_id;
		unity__placeentryinfodata_type_id = g_boxed_type_register_static ("Unity_PlaceEntryInfoData", (GBoxedCopyFunc) unity__placeentryinfodata_dup, (GBoxedFreeFunc) unity__placeentryinfodata_free);
		g_once_init_leave (&unity__placeentryinfodata_type_id__volatile, unity__placeentryinfodata_type_id);
	}
	return unity__placeentryinfodata_type_id__volatile;
}


UnityPlaceEntryInfo* unity_place_entry_info_construct (GType object_type, const gchar* dbus_path) {
	UnityPlaceEntryInfo * self = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _empty;
	gint _empty_length1;
	gint __empty_size_;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_empty = _tmp0_;
	_empty_length1 = 0;
	__empty_size_ = 0;
	self = (UnityPlaceEntryInfo*) g_object_new (object_type, "dbus-path", dbus_path, "mimetypes", _empty, NULL);
	_empty = (_vala_array_free (_empty, _empty_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


UnityPlaceEntryInfo* unity_place_entry_info_new (const gchar* dbus_path) {
	return unity_place_entry_info_construct (UNITY_TYPE_PLACE_ENTRY_INFO, dbus_path);
}


void unity_place_entry_info_set_hint (UnityPlaceEntryInfo* self, const gchar* hint, const gchar* val) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_strdup (hint);
	_tmp1_ = g_strdup (val);
	g_hash_table_insert (self->priv->info.hints, _tmp0_, _tmp1_);
}


gchar* unity_place_entry_info_get_hint (UnityPlaceEntryInfo* self, const gchar* hint) {
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hint != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->info.hints, hint);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	result = _tmp1_;
	return result;
}


void unity_place_entry_info_clear_hint (UnityPlaceEntryInfo* self, const gchar* hint) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_hash_table_remove (self->priv->info.hints, hint);
}


void unity_place_entry_info_clear_hints (UnityPlaceEntryInfo* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all (self->priv->info.hints);
}


guint unity_place_entry_info_num_hints (UnityPlaceEntryInfo* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_hash_table_size (self->priv->info.hints);
	result = _tmp0_;
	return result;
}


void unity_place_entry_info_flush_all_models (UnityPlaceEntryInfo* self) {
	DeeModel* _tmp0_ = NULL;
	UnityPlaceRendererInfo* _tmp3_ = NULL;
	DeeModel* _tmp4_ = NULL;
	UnityPlaceRendererInfo* _tmp8_ = NULL;
	DeeModel* _tmp9_ = NULL;
	UnityPlaceRendererInfo* _tmp13_ = NULL;
	DeeModel* _tmp14_ = NULL;
	UnityPlaceRendererInfo* _tmp18_ = NULL;
	DeeModel* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_place_entry_info_get_sections_model (self);
	if (DEE_IS_SHARED_MODEL (_tmp0_)) {
		DeeModel* _tmp1_ = NULL;
		DeeModel* _tmp2_;
		_tmp1_ = unity_place_entry_info_get_sections_model (self);
		_tmp2_ = _tmp1_;
		dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (_tmp2_) ? ((DeeSharedModel*) _tmp2_) : NULL);
	}
	_tmp3_ = unity_place_entry_info_get_entry_renderer_info (self);
	_tmp4_ = unity_place_renderer_info_get_results_model (_tmp3_);
	if (DEE_IS_SHARED_MODEL (_tmp4_)) {
		UnityPlaceRendererInfo* _tmp5_ = NULL;
		DeeModel* _tmp6_ = NULL;
		DeeModel* _tmp7_;
		_tmp5_ = unity_place_entry_info_get_entry_renderer_info (self);
		_tmp6_ = unity_place_renderer_info_get_results_model (_tmp5_);
		_tmp7_ = _tmp6_;
		dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (_tmp7_) ? ((DeeSharedModel*) _tmp7_) : NULL);
	}
	_tmp8_ = unity_place_entry_info_get_entry_renderer_info (self);
	_tmp9_ = unity_place_renderer_info_get_groups_model (_tmp8_);
	if (DEE_IS_SHARED_MODEL (_tmp9_)) {
		UnityPlaceRendererInfo* _tmp10_ = NULL;
		DeeModel* _tmp11_ = NULL;
		DeeModel* _tmp12_;
		_tmp10_ = unity_place_entry_info_get_entry_renderer_info (self);
		_tmp11_ = unity_place_renderer_info_get_groups_model (_tmp10_);
		_tmp12_ = _tmp11_;
		dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (_tmp12_) ? ((DeeSharedModel*) _tmp12_) : NULL);
	}
	_tmp13_ = unity_place_entry_info_get_global_renderer_info (self);
	_tmp14_ = unity_place_renderer_info_get_results_model (_tmp13_);
	if (DEE_IS_SHARED_MODEL (_tmp14_)) {
		UnityPlaceRendererInfo* _tmp15_ = NULL;
		DeeModel* _tmp16_ = NULL;
		DeeModel* _tmp17_;
		_tmp15_ = unity_place_entry_info_get_entry_renderer_info (self);
		_tmp16_ = unity_place_renderer_info_get_results_model (_tmp15_);
		_tmp17_ = _tmp16_;
		dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (_tmp17_) ? ((DeeSharedModel*) _tmp17_) : NULL);
	}
	_tmp18_ = unity_place_entry_info_get_global_renderer_info (self);
	_tmp19_ = unity_place_renderer_info_get_groups_model (_tmp18_);
	if (DEE_IS_SHARED_MODEL (_tmp19_)) {
		UnityPlaceRendererInfo* _tmp20_ = NULL;
		DeeModel* _tmp21_ = NULL;
		DeeModel* _tmp22_;
		_tmp20_ = unity_place_entry_info_get_global_renderer_info (self);
		_tmp21_ = unity_place_renderer_info_get_groups_model (_tmp20_);
		_tmp22_ = _tmp21_;
		dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (_tmp22_) ? ((DeeSharedModel*) _tmp22_) : NULL);
	}
}


void unity_place_entry_info_get_raw (UnityPlaceEntryInfo* self, Unity_PlaceEntryInfo* result) {
	Unity_PlaceEntryInfo _tmp0_;
	Unity_PlaceEntryInfo _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	unity__placeentryinfo_copy (&self->priv->info, &_tmp1_);
	_tmp0_ = _tmp1_;
	*result = _tmp0_;
	return;
}


UnityPlaceRendererInfo* unity_place_entry_info_get_entry_renderer_info (UnityPlaceEntryInfo* self) {
	UnityPlaceRendererInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_renderer_info;
	return result;
}


UnityPlaceRendererInfo* unity_place_entry_info_get_global_renderer_info (UnityPlaceEntryInfo* self) {
	UnityPlaceRendererInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_global_renderer_info;
	return result;
}


const gchar* unity_place_entry_info_get_dbus_path (UnityPlaceEntryInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->info.dbus_path;
	return result;
}


void unity_place_entry_info_set_dbus_path (UnityPlaceEntryInfo* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->info.dbus_path);
	self->priv->info.dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


const gchar* unity_place_entry_info_get_display_name (UnityPlaceEntryInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->info.display_name;
	return result;
}


void unity_place_entry_info_set_display_name (UnityPlaceEntryInfo* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->info.display_name);
	self->priv->info.display_name = _tmp0_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* unity_place_entry_info_get_icon (UnityPlaceEntryInfo* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->info.icon;
	return result;
}


void unity_place_entry_info_set_icon (UnityPlaceEntryInfo* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->info.icon);
	self->priv->info.icon = _tmp0_;
	g_object_notify ((GObject *) self, "icon");
}


guint unity_place_entry_info_get_position (UnityPlaceEntryInfo* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->info.position;
	return result;
}


void unity_place_entry_info_set_position (UnityPlaceEntryInfo* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->info.position = value;
	g_object_notify ((GObject *) self, "position");
}


gchar** unity_place_entry_info_get_mimetypes (UnityPlaceEntryInfo* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->info.mimetypes;
	*result_length1 = self->priv->info.mimetypes_length1;
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity_place_entry_info_set_mimetypes (UnityPlaceEntryInfo* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup7 (_tmp1_, value_length1));
	self->priv->info.mimetypes = (_vala_array_free (self->priv->info.mimetypes, self->priv->info.mimetypes_length1, (GDestroyNotify) g_free), NULL);
	self->priv->info.mimetypes = _tmp0_;
	self->priv->info.mimetypes_length1 = value_length1;
	self->priv->info._mimetypes_size_ = value_length1;
	g_object_notify ((GObject *) self, "mimetypes");
}


gboolean unity_place_entry_info_get_sensitive (UnityPlaceEntryInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->info.sensitive;
	return result;
}


void unity_place_entry_info_set_sensitive (UnityPlaceEntryInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->info.sensitive = value;
	g_object_notify ((GObject *) self, "sensitive");
}


DeeModel* unity_place_entry_info_get_sections_model (UnityPlaceEntryInfo* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sections_model;
	return result;
}


void unity_place_entry_info_set_sections_model (UnityPlaceEntryInfo* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_sections_model);
	self->priv->_sections_model = _tmp0_;
	if (DEE_IS_SHARED_MODEL (value)) {
		DeeModel* _tmp1_;
		DeeSharedModel* _tmp2_;
		DeeSharedModel* model;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = value;
		_tmp2_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL);
		model = _tmp2_;
		_tmp3_ = dee_shared_model_get_swarm_name (model);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->info.sections_model);
		self->priv->info.sections_model = _tmp4_;
		_g_object_unref0 (model);
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("__local__");
		_g_free0 (self->priv->info.sections_model);
		self->priv->info.sections_model = _tmp5_;
	}
	g_object_notify ((GObject *) self, "sections-model");
}


gboolean unity_place_entry_info_get_active (UnityPlaceEntryInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_place_entry_info_set_active (UnityPlaceEntryInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


guint unity_place_entry_info_get_active_section (UnityPlaceEntryInfo* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_active_section;
	return result;
}


void unity_place_entry_info_set_active_section (UnityPlaceEntryInfo* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_active_section = value;
	g_object_notify ((GObject *) self, "active-section");
}


UnityPlaceSearch* unity_place_entry_info_get_active_search (UnityPlaceEntryInfo* self) {
	UnityPlaceSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_search;
	return result;
}


void unity_place_entry_info_set_active_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value) {
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_active_search);
	self->priv->_active_search = _tmp0_;
	g_object_notify ((GObject *) self, "active-search");
}


UnityPlaceSearch* unity_place_entry_info_get_active_global_search (UnityPlaceEntryInfo* self) {
	UnityPlaceSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_global_search;
	return result;
}


void unity_place_entry_info_set_active_global_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value) {
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_active_global_search);
	self->priv->_active_global_search = _tmp0_;
	g_object_notify ((GObject *) self, "active-global-search");
}


UnityBrowser* unity_place_entry_info_get_browser (UnityPlaceEntryInfo* self) {
	UnityBrowser* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_browser;
	return result;
}


void unity_place_entry_info_set_browser (UnityPlaceEntryInfo* self, UnityBrowser* value) {
	UnityBrowser* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_browser);
	self->priv->_browser = _tmp0_;
	if (value != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = unity_browser_get_dbus_path (value);
		unity_place_entry_info_set_hint (self, "UnityPlaceBrowserPath", _tmp1_);
		unity_place_entry_info_set_hint (self, "UnitySectionStyle", "breadcrumb");
	} else {
		unity_place_entry_info_clear_hint (self, "UnityPlaceBrowserPath");
		unity_place_entry_info_clear_hint (self, "UnitySectionStyle");
	}
	g_object_notify ((GObject *) self, "browser");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static GObject * unity_place_entry_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlaceEntryInfo * self;
	GHashTable* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GHashTable* _tmp13_ = NULL;
	UnityPlaceRendererInfo* _tmp14_ = NULL;
	UnityPlaceRendererInfo* _tmp15_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_place_entry_info_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACE_ENTRY_INFO (obj);
	if (self->priv->info.dbus_path == NULL) {
		gchar* _tmp0_;
		g_critical ("unity-place.vala:418: No DBus path set for PlaceEntryInfo.\n" \
"'dbus-path' property in the UnityPlaceEntryInfo constructor");
		_tmp0_ = g_strdup ("");
		_g_free0 (self->priv->info.dbus_path);
		self->priv->info.dbus_path = _tmp0_;
	}
	if (self->priv->info.display_name == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (self->priv->info.display_name);
		self->priv->info.display_name = _tmp1_;
	}
	if (self->priv->info.icon == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (self->priv->info.icon);
		self->priv->info.icon = _tmp2_;
	}
	self->priv->info.position = (guint) 0;
	if (self->priv->info.mimetypes == NULL) {
		gchar** _tmp3_ = NULL;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		self->priv->info.mimetypes = (_vala_array_free (self->priv->info.mimetypes, self->priv->info.mimetypes_length1, (GDestroyNotify) g_free), NULL);
		self->priv->info.mimetypes = _tmp3_;
		self->priv->info.mimetypes_length1 = 0;
		self->priv->info._mimetypes_size_ = 0;
	}
	self->priv->info.sensitive = TRUE;
	if (self->priv->info.sections_model == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (self->priv->info.sections_model);
		self->priv->info.sections_model = _tmp4_;
	}
	_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->info.hints);
	self->priv->info.hints = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->info.entry_renderer_info.default_renderer);
	self->priv->info.entry_renderer_info.default_renderer = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (self->priv->info.entry_renderer_info.groups_model);
	self->priv->info.entry_renderer_info.groups_model = _tmp7_;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->priv->info.entry_renderer_info.results_model);
	self->priv->info.entry_renderer_info.results_model = _tmp8_;
	_tmp9_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->info.entry_renderer_info.hints);
	self->priv->info.entry_renderer_info.hints = _tmp9_;
	_tmp10_ = g_strdup ("");
	_g_free0 (self->priv->info.global_renderer_info.default_renderer);
	self->priv->info.global_renderer_info.default_renderer = _tmp10_;
	_tmp11_ = g_strdup ("");
	_g_free0 (self->priv->info.global_renderer_info.groups_model);
	self->priv->info.global_renderer_info.groups_model = _tmp11_;
	_tmp12_ = g_strdup ("");
	_g_free0 (self->priv->info.global_renderer_info.results_model);
	self->priv->info.global_renderer_info.results_model = _tmp12_;
	_tmp13_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->info.global_renderer_info.hints);
	self->priv->info.global_renderer_info.hints = _tmp13_;
	_tmp14_ = unity_place_renderer_info_new (&self->priv->info.entry_renderer_info);
	_g_object_unref0 (self->priv->_entry_renderer_info);
	self->priv->_entry_renderer_info = _tmp14_;
	_tmp15_ = unity_place_renderer_info_new (&self->priv->info.global_renderer_info);
	_g_object_unref0 (self->priv->_global_renderer_info);
	self->priv->_global_renderer_info = _tmp15_;
	return obj;
}


static void unity_place_entry_info_class_init (UnityPlaceEntryInfoClass * klass) {
	unity_place_entry_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceEntryInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_place_entry_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_place_entry_info_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_place_entry_info_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_place_entry_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ENTRY_RENDERER_INFO, g_param_spec_object ("entry-renderer-info", "entry-renderer-info", "entry-renderer-info", UNITY_TYPE_PLACE_RENDERER_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_GLOBAL_RENDERER_INFO, g_param_spec_object ("global-renderer-info", "global-renderer-info", "global-renderer-info", UNITY_TYPE_PLACE_RENDERER_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_POSITION, g_param_spec_uint ("position", "position", "position", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_MIMETYPES, g_param_spec_boxed ("mimetypes", "mimetypes", "mimetypes", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_SENSITIVE, g_param_spec_boolean ("sensitive", "sensitive", "sensitive", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL, g_param_spec_object ("sections-model", "sections-model", "sections-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION, g_param_spec_uint ("active-section", "active-section", "active-section", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH, g_param_spec_object ("active-search", "active-search", "active-search", UNITY_TYPE_PLACE_SEARCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH, g_param_spec_object ("active-global-search", "active-global-search", "active-global-search", UNITY_TYPE_PLACE_SEARCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_BROWSER, g_param_spec_object ("browser", "browser", "browser", UNITY_TYPE_BROWSER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_entry_info_instance_init (UnityPlaceEntryInfo * self) {
	Unity_PlaceEntryInfo _tmp0_ = {0};
	Unity_PlaceEntryInfo _tmp1_ = {0};
	self->priv = UNITY_PLACE_ENTRY_INFO_GET_PRIVATE (self);
	memset (&_tmp0_, 0, sizeof (Unity_PlaceEntryInfo));
	_tmp1_ = _tmp0_;
	self->priv->info = _tmp1_;
	self->priv->_active = FALSE;
	self->priv->_active_section = (guint) 0;
	self->priv->_browser = NULL;
}


static void unity_place_entry_info_finalize (GObject* obj) {
	UnityPlaceEntryInfo * self;
	self = UNITY_PLACE_ENTRY_INFO (obj);
	unity__placeentryinfo_destroy (&self->priv->info);
	_g_object_unref0 (self->priv->_entry_renderer_info);
	_g_object_unref0 (self->priv->_global_renderer_info);
	_g_object_unref0 (self->priv->_sections_model);
	_g_object_unref0 (self->priv->_active_search);
	_g_object_unref0 (self->priv->_active_global_search);
	_g_object_unref0 (self->priv->_browser);
	G_OBJECT_CLASS (unity_place_entry_info_parent_class)->finalize (obj);
}


GType unity_place_entry_info_get_type (void) {
	static volatile gsize unity_place_entry_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_entry_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceEntryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_entry_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceEntryInfo), 0, (GInstanceInitFunc) unity_place_entry_info_instance_init, NULL };
		GType unity_place_entry_info_type_id;
		unity_place_entry_info_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceEntryInfo", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_entry_info_type_id__volatile, unity_place_entry_info_type_id);
	}
	return unity_place_entry_info_type_id__volatile;
}


static void _vala_unity_place_entry_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryInfo * self;
	int length;
	self = UNITY_PLACE_ENTRY_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_INFO_ENTRY_RENDERER_INFO:
		g_value_set_object (value, unity_place_entry_info_get_entry_renderer_info (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_GLOBAL_RENDERER_INFO:
		g_value_set_object (value, unity_place_entry_info_get_global_renderer_info (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_DBUS_PATH:
		g_value_set_string (value, unity_place_entry_info_get_dbus_path (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME:
		g_value_set_string (value, unity_place_entry_info_get_display_name (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ICON:
		g_value_set_string (value, unity_place_entry_info_get_icon (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_POSITION:
		g_value_set_uint (value, unity_place_entry_info_get_position (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_MIMETYPES:
		g_value_set_boxed (value, unity_place_entry_info_get_mimetypes (self, &length));
		break;
		case UNITY_PLACE_ENTRY_INFO_SENSITIVE:
		g_value_set_boolean (value, unity_place_entry_info_get_sensitive (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL:
		g_value_set_object (value, unity_place_entry_info_get_sections_model (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE:
		g_value_set_boolean (value, unity_place_entry_info_get_active (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION:
		g_value_set_uint (value, unity_place_entry_info_get_active_section (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH:
		g_value_set_object (value, unity_place_entry_info_get_active_search (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH:
		g_value_set_object (value, unity_place_entry_info_get_active_global_search (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_BROWSER:
		g_value_set_object (value, unity_place_entry_info_get_browser (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_place_entry_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryInfo * self;
	gpointer boxed;
	self = UNITY_PLACE_ENTRY_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_INFO_DBUS_PATH:
		unity_place_entry_info_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME:
		unity_place_entry_info_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ICON:
		unity_place_entry_info_set_icon (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_POSITION:
		unity_place_entry_info_set_position (self, g_value_get_uint (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_MIMETYPES:
		boxed = g_value_get_boxed (value);
		unity_place_entry_info_set_mimetypes (self, boxed, g_strv_length (boxed));
		break;
		case UNITY_PLACE_ENTRY_INFO_SENSITIVE:
		unity_place_entry_info_set_sensitive (self, g_value_get_boolean (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL:
		unity_place_entry_info_set_sections_model (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE:
		unity_place_entry_info_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION:
		unity_place_entry_info_set_active_section (self, g_value_get_uint (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH:
		unity_place_entry_info_set_active_search (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH:
		unity_place_entry_info_set_active_global_search (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_BROWSER:
		unity_place_entry_info_set_browser (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Unity_PlaceEntryInfo* unity_place_service_get_entries (UnityPlaceService* self, int* result_length1, GError** error) {
	return UNITY_PLACE_SERVICE_GET_INTERFACE (self)->get_entries (self, result_length1, error);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void unity_place_service_base_init (UnityPlaceServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("entry_added", UNITY_TYPE_PLACE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE__PLACEENTRYINFO);
		g_signal_new ("entry_removed", UNITY_TYPE_PLACE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


/**
   * UnityPlaceService:
   *
   * DBus interface exported by a place daemon
   */
GType unity_place_service_get_type (void) {
	static volatile gsize unity_place_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceServiceIface), (GBaseInitFunc) unity_place_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_place_service_type_id;
		unity_place_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityPlaceService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_place_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_place_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_place_service_proxy_get_type);
		g_type_set_qdata (unity_place_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.Place");
		g_type_set_qdata (unity_place_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_place_service_register_object);
		g_once_init_leave (&unity_place_service_type_id__volatile, unity_place_service_type_id);
	}
	return unity_place_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityPlaceServiceProxy, unity_place_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_PLACE_SERVICE, unity_place_service_proxy_unity_place_service_interface_init) )
static void unity_place_service_proxy_class_init (UnityPlaceServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_place_service_proxy_g_signal;
}


static void _dbus_handle_unity_place_service_entry_added (UnityPlaceService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	Unity_PlaceEntryInfo entry = {0};
	GVariant* _tmp8_;
	Unity_PlaceEntryInfo _tmp9_;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	gchar** _tmp16_;
	int _tmp16__length;
	int _tmp16__size;
	int _tmp16__length1;
	GVariantIter _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GHashTable* _tmp22_;
	GVariantIter _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	Unity_PlaceRendererInfo _tmp27_;
	GVariantIter _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	GHashTable* _tmp33_;
	GVariantIter _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	Unity_PlaceRendererInfo _tmp38_;
	GVariantIter _tmp39_;
	GVariant* _tmp40_;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	GVariant* _tmp43_;
	GHashTable* _tmp44_;
	GVariantIter _tmp45_;
	GVariant* _tmp46_;
	GVariant* _tmp47_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp10_, _tmp8_);
	_tmp11_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.dbus_path = g_variant_dup_string (_tmp11_, NULL);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.display_name = g_variant_dup_string (_tmp12_, NULL);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.icon = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.position = g_variant_get_uint32 (_tmp14_);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_tmp10_);
	_tmp16_ = g_new (gchar*, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
	g_variant_iter_init (&_tmp17_, _tmp15_);
	for (; (_tmp18_ = g_variant_iter_next_value (&_tmp17_)) != NULL; _tmp16__length1++) {
		if (_tmp16__size == _tmp16__length) {
			_tmp16__size = 2 * _tmp16__size;
			_tmp16_ = g_renew (gchar*, _tmp16_, _tmp16__size + 1);
		}
		_tmp16_[_tmp16__length++] = g_variant_dup_string (_tmp18_, NULL);
		g_variant_unref (_tmp18_);
	}
	_tmp9_.mimetypes_length1 = _tmp16__length1;
	_tmp16_[_tmp16__length] = NULL;
	_tmp9_.mimetypes = _tmp16_;
	g_variant_unref (_tmp15_);
	_tmp19_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.sensitive = g_variant_get_boolean (_tmp19_);
	g_variant_unref (_tmp19_);
	_tmp20_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.sections_model = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	_tmp21_ = g_variant_iter_next_value (&_tmp10_);
	_tmp22_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp23_, _tmp21_);
	while (g_variant_iter_loop (&_tmp23_, "{?*}", &_tmp24_, &_tmp25_)) {
		g_hash_table_insert (_tmp22_, g_variant_dup_string (_tmp24_, NULL), g_variant_dup_string (_tmp25_, NULL));
	}
	_tmp9_.hints = _tmp22_;
	g_variant_unref (_tmp21_);
	_tmp26_ = g_variant_iter_next_value (&_tmp10_);
	g_variant_iter_init (&_tmp28_, _tmp26_);
	_tmp29_ = g_variant_iter_next_value (&_tmp28_);
	_tmp27_.default_renderer = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_tmp28_);
	_tmp27_.groups_model = g_variant_dup_string (_tmp30_, NULL);
	g_variant_unref (_tmp30_);
	_tmp31_ = g_variant_iter_next_value (&_tmp28_);
	_tmp27_.results_model = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	_tmp32_ = g_variant_iter_next_value (&_tmp28_);
	_tmp33_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp34_, _tmp32_);
	while (g_variant_iter_loop (&_tmp34_, "{?*}", &_tmp35_, &_tmp36_)) {
		g_hash_table_insert (_tmp33_, g_variant_dup_string (_tmp35_, NULL), g_variant_dup_string (_tmp36_, NULL));
	}
	_tmp27_.hints = _tmp33_;
	g_variant_unref (_tmp32_);
	_tmp9_.entry_renderer_info = _tmp27_;
	g_variant_unref (_tmp26_);
	_tmp37_ = g_variant_iter_next_value (&_tmp10_);
	g_variant_iter_init (&_tmp39_, _tmp37_);
	_tmp40_ = g_variant_iter_next_value (&_tmp39_);
	_tmp38_.default_renderer = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_tmp39_);
	_tmp38_.groups_model = g_variant_dup_string (_tmp41_, NULL);
	g_variant_unref (_tmp41_);
	_tmp42_ = g_variant_iter_next_value (&_tmp39_);
	_tmp38_.results_model = g_variant_dup_string (_tmp42_, NULL);
	g_variant_unref (_tmp42_);
	_tmp43_ = g_variant_iter_next_value (&_tmp39_);
	_tmp44_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp45_, _tmp43_);
	while (g_variant_iter_loop (&_tmp45_, "{?*}", &_tmp46_, &_tmp47_)) {
		g_hash_table_insert (_tmp44_, g_variant_dup_string (_tmp46_, NULL), g_variant_dup_string (_tmp47_, NULL));
	}
	_tmp38_.hints = _tmp44_;
	g_variant_unref (_tmp43_);
	_tmp9_.global_renderer_info = _tmp38_;
	g_variant_unref (_tmp37_);
	entry = _tmp9_;
	g_variant_unref (_tmp8_);
	g_signal_emit_by_name (self, "entry-added", &entry);
	unity__placeentryinfo_destroy (&entry);
}


static void _dbus_handle_unity_place_service_entry_removed (UnityPlaceService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* entry_dbus_path = NULL;
	GVariant* _tmp48_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	entry_dbus_path = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	g_signal_emit_by_name (self, "entry-removed", entry_dbus_path);
	_g_free0 (entry_dbus_path);
}


static void unity_place_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "EntryAdded") == 0) {
		_dbus_handle_unity_place_service_entry_added ((UnityPlaceService*) proxy, parameters);
	} else if (strcmp (signal_name, "EntryRemoved") == 0) {
		_dbus_handle_unity_place_service_entry_removed ((UnityPlaceService*) proxy, parameters);
	}
}


static void unity_place_service_proxy_init (UnityPlaceServiceProxy* self) {
}


static Unity_PlaceEntryInfo* unity_place_service_proxy_get_entries (UnityPlaceService* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	Unity_PlaceEntryInfo* _result;
	int _result_length1;
	GVariant* _tmp49_;
	Unity_PlaceEntryInfo* _tmp50_;
	int _tmp50__length;
	int _tmp50__size;
	int _tmp50__length1;
	GVariantIter _tmp51_;
	GVariant* _tmp52_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Place", "GetEntries");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp49_ = g_variant_iter_next_value (&_reply_iter);
	_tmp50_ = g_new (Unity_PlaceEntryInfo, 5);
	_tmp50__length = 0;
	_tmp50__size = 4;
	_tmp50__length1 = 0;
	g_variant_iter_init (&_tmp51_, _tmp49_);
	for (; (_tmp52_ = g_variant_iter_next_value (&_tmp51_)) != NULL; _tmp50__length1++) {
		Unity_PlaceEntryInfo _tmp53_;
		GVariantIter _tmp54_;
		GVariant* _tmp55_;
		GVariant* _tmp56_;
		GVariant* _tmp57_;
		GVariant* _tmp58_;
		GVariant* _tmp59_;
		gchar** _tmp60_;
		int _tmp60__length;
		int _tmp60__size;
		int _tmp60__length1;
		GVariantIter _tmp61_;
		GVariant* _tmp62_;
		GVariant* _tmp63_;
		GVariant* _tmp64_;
		GVariant* _tmp65_;
		GHashTable* _tmp66_;
		GVariantIter _tmp67_;
		GVariant* _tmp68_;
		GVariant* _tmp69_;
		GVariant* _tmp70_;
		Unity_PlaceRendererInfo _tmp71_;
		GVariantIter _tmp72_;
		GVariant* _tmp73_;
		GVariant* _tmp74_;
		GVariant* _tmp75_;
		GVariant* _tmp76_;
		GHashTable* _tmp77_;
		GVariantIter _tmp78_;
		GVariant* _tmp79_;
		GVariant* _tmp80_;
		GVariant* _tmp81_;
		Unity_PlaceRendererInfo _tmp82_;
		GVariantIter _tmp83_;
		GVariant* _tmp84_;
		GVariant* _tmp85_;
		GVariant* _tmp86_;
		GVariant* _tmp87_;
		GHashTable* _tmp88_;
		GVariantIter _tmp89_;
		GVariant* _tmp90_;
		GVariant* _tmp91_;
		if (_tmp50__size == _tmp50__length) {
			_tmp50__size = 2 * _tmp50__size;
			_tmp50_ = g_renew (Unity_PlaceEntryInfo, _tmp50_, _tmp50__size + 1);
		}
		g_variant_iter_init (&_tmp54_, _tmp52_);
		_tmp55_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.dbus_path = g_variant_dup_string (_tmp55_, NULL);
		g_variant_unref (_tmp55_);
		_tmp56_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.display_name = g_variant_dup_string (_tmp56_, NULL);
		g_variant_unref (_tmp56_);
		_tmp57_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.icon = g_variant_dup_string (_tmp57_, NULL);
		g_variant_unref (_tmp57_);
		_tmp58_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.position = g_variant_get_uint32 (_tmp58_);
		g_variant_unref (_tmp58_);
		_tmp59_ = g_variant_iter_next_value (&_tmp54_);
		_tmp60_ = g_new (gchar*, 5);
		_tmp60__length = 0;
		_tmp60__size = 4;
		_tmp60__length1 = 0;
		g_variant_iter_init (&_tmp61_, _tmp59_);
		for (; (_tmp62_ = g_variant_iter_next_value (&_tmp61_)) != NULL; _tmp60__length1++) {
			if (_tmp60__size == _tmp60__length) {
				_tmp60__size = 2 * _tmp60__size;
				_tmp60_ = g_renew (gchar*, _tmp60_, _tmp60__size + 1);
			}
			_tmp60_[_tmp60__length++] = g_variant_dup_string (_tmp62_, NULL);
			g_variant_unref (_tmp62_);
		}
		_tmp53_.mimetypes_length1 = _tmp60__length1;
		_tmp60_[_tmp60__length] = NULL;
		_tmp53_.mimetypes = _tmp60_;
		g_variant_unref (_tmp59_);
		_tmp63_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.sensitive = g_variant_get_boolean (_tmp63_);
		g_variant_unref (_tmp63_);
		_tmp64_ = g_variant_iter_next_value (&_tmp54_);
		_tmp53_.sections_model = g_variant_dup_string (_tmp64_, NULL);
		g_variant_unref (_tmp64_);
		_tmp65_ = g_variant_iter_next_value (&_tmp54_);
		_tmp66_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		g_variant_iter_init (&_tmp67_, _tmp65_);
		while (g_variant_iter_loop (&_tmp67_, "{?*}", &_tmp68_, &_tmp69_)) {
			g_hash_table_insert (_tmp66_, g_variant_dup_string (_tmp68_, NULL), g_variant_dup_string (_tmp69_, NULL));
		}
		_tmp53_.hints = _tmp66_;
		g_variant_unref (_tmp65_);
		_tmp70_ = g_variant_iter_next_value (&_tmp54_);
		g_variant_iter_init (&_tmp72_, _tmp70_);
		_tmp73_ = g_variant_iter_next_value (&_tmp72_);
		_tmp71_.default_renderer = g_variant_dup_string (_tmp73_, NULL);
		g_variant_unref (_tmp73_);
		_tmp74_ = g_variant_iter_next_value (&_tmp72_);
		_tmp71_.groups_model = g_variant_dup_string (_tmp74_, NULL);
		g_variant_unref (_tmp74_);
		_tmp75_ = g_variant_iter_next_value (&_tmp72_);
		_tmp71_.results_model = g_variant_dup_string (_tmp75_, NULL);
		g_variant_unref (_tmp75_);
		_tmp76_ = g_variant_iter_next_value (&_tmp72_);
		_tmp77_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		g_variant_iter_init (&_tmp78_, _tmp76_);
		while (g_variant_iter_loop (&_tmp78_, "{?*}", &_tmp79_, &_tmp80_)) {
			g_hash_table_insert (_tmp77_, g_variant_dup_string (_tmp79_, NULL), g_variant_dup_string (_tmp80_, NULL));
		}
		_tmp71_.hints = _tmp77_;
		g_variant_unref (_tmp76_);
		_tmp53_.entry_renderer_info = _tmp71_;
		g_variant_unref (_tmp70_);
		_tmp81_ = g_variant_iter_next_value (&_tmp54_);
		g_variant_iter_init (&_tmp83_, _tmp81_);
		_tmp84_ = g_variant_iter_next_value (&_tmp83_);
		_tmp82_.default_renderer = g_variant_dup_string (_tmp84_, NULL);
		g_variant_unref (_tmp84_);
		_tmp85_ = g_variant_iter_next_value (&_tmp83_);
		_tmp82_.groups_model = g_variant_dup_string (_tmp85_, NULL);
		g_variant_unref (_tmp85_);
		_tmp86_ = g_variant_iter_next_value (&_tmp83_);
		_tmp82_.results_model = g_variant_dup_string (_tmp86_, NULL);
		g_variant_unref (_tmp86_);
		_tmp87_ = g_variant_iter_next_value (&_tmp83_);
		_tmp88_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		g_variant_iter_init (&_tmp89_, _tmp87_);
		while (g_variant_iter_loop (&_tmp89_, "{?*}", &_tmp90_, &_tmp91_)) {
			g_hash_table_insert (_tmp88_, g_variant_dup_string (_tmp90_, NULL), g_variant_dup_string (_tmp91_, NULL));
		}
		_tmp82_.hints = _tmp88_;
		g_variant_unref (_tmp87_);
		_tmp53_.global_renderer_info = _tmp82_;
		g_variant_unref (_tmp81_);
		_tmp50_[_tmp50__length++] = _tmp53_;
		g_variant_unref (_tmp52_);
	}
	_result_length1 = _tmp50__length1;
	_result = _tmp50_;
	g_variant_unref (_tmp49_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void unity_place_service_proxy_unity_place_service_interface_init (UnityPlaceServiceIface* iface) {
	iface->get_entries = unity_place_service_proxy_get_entries;
}


static void _vala_Unity_PlaceEntryInfo_array_free (Unity_PlaceEntryInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			unity__placeentryinfo_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_unity_place_service_get_entries (UnityPlaceService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	Unity_PlaceEntryInfo* result;
	int result_length1 = 0;
	Unity_PlaceEntryInfo* _tmp92_;
	GVariantBuilder _tmp93_;
	int _tmp94_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = unity_place_service_get_entries (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp92_ = result;
	g_variant_builder_init (&_tmp93_, G_VARIANT_TYPE ("a(sssuasbsa{ss}(sssa{ss})(sssa{ss}))"));
	for (_tmp94_ = 0; _tmp94_ < result_length1; _tmp94_++) {
		GVariantBuilder _tmp95_;
		gchar** _tmp96_;
		GVariantBuilder _tmp97_;
		int _tmp98_;
		GVariantBuilder _tmp99_;
		GHashTableIter _tmp100_;
		gpointer _tmp101_;
		gpointer _tmp102_;
		GVariantBuilder _tmp103_;
		GVariantBuilder _tmp104_;
		GHashTableIter _tmp105_;
		gpointer _tmp106_;
		gpointer _tmp107_;
		GVariantBuilder _tmp108_;
		GVariantBuilder _tmp109_;
		GHashTableIter _tmp110_;
		gpointer _tmp111_;
		gpointer _tmp112_;
		g_variant_builder_init (&_tmp95_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp95_, g_variant_new_string ((*_tmp92_).dbus_path));
		g_variant_builder_add_value (&_tmp95_, g_variant_new_string ((*_tmp92_).display_name));
		g_variant_builder_add_value (&_tmp95_, g_variant_new_string ((*_tmp92_).icon));
		g_variant_builder_add_value (&_tmp95_, g_variant_new_uint32 ((*_tmp92_).position));
		_tmp96_ = (*_tmp92_).mimetypes;
		g_variant_builder_init (&_tmp97_, G_VARIANT_TYPE ("as"));
		for (_tmp98_ = 0; _tmp98_ < (*_tmp92_).mimetypes_length1; _tmp98_++) {
			g_variant_builder_add_value (&_tmp97_, g_variant_new_string (*_tmp96_));
			_tmp96_++;
		}
		g_variant_builder_add_value (&_tmp95_, g_variant_builder_end (&_tmp97_));
		g_variant_builder_add_value (&_tmp95_, g_variant_new_boolean ((*_tmp92_).sensitive));
		g_variant_builder_add_value (&_tmp95_, g_variant_new_string ((*_tmp92_).sections_model));
		g_hash_table_iter_init (&_tmp100_, (*_tmp92_).hints);
		g_variant_builder_init (&_tmp99_, G_VARIANT_TYPE ("a{ss}"));
		while (g_hash_table_iter_next (&_tmp100_, &_tmp101_, &_tmp102_)) {
			gchar* _key;
			gchar* _value;
			_key = (gchar*) _tmp101_;
			_value = (gchar*) _tmp102_;
			g_variant_builder_add (&_tmp99_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
		}
		g_variant_builder_add_value (&_tmp95_, g_variant_builder_end (&_tmp99_));
		g_variant_builder_init (&_tmp103_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp103_, g_variant_new_string ((*_tmp92_).entry_renderer_info.default_renderer));
		g_variant_builder_add_value (&_tmp103_, g_variant_new_string ((*_tmp92_).entry_renderer_info.groups_model));
		g_variant_builder_add_value (&_tmp103_, g_variant_new_string ((*_tmp92_).entry_renderer_info.results_model));
		g_hash_table_iter_init (&_tmp105_, (*_tmp92_).entry_renderer_info.hints);
		g_variant_builder_init (&_tmp104_, G_VARIANT_TYPE ("a{ss}"));
		while (g_hash_table_iter_next (&_tmp105_, &_tmp106_, &_tmp107_)) {
			gchar* _key;
			gchar* _value;
			_key = (gchar*) _tmp106_;
			_value = (gchar*) _tmp107_;
			g_variant_builder_add (&_tmp104_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
		}
		g_variant_builder_add_value (&_tmp103_, g_variant_builder_end (&_tmp104_));
		g_variant_builder_add_value (&_tmp95_, g_variant_builder_end (&_tmp103_));
		g_variant_builder_init (&_tmp108_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp108_, g_variant_new_string ((*_tmp92_).global_renderer_info.default_renderer));
		g_variant_builder_add_value (&_tmp108_, g_variant_new_string ((*_tmp92_).global_renderer_info.groups_model));
		g_variant_builder_add_value (&_tmp108_, g_variant_new_string ((*_tmp92_).global_renderer_info.results_model));
		g_hash_table_iter_init (&_tmp110_, (*_tmp92_).global_renderer_info.hints);
		g_variant_builder_init (&_tmp109_, G_VARIANT_TYPE ("a{ss}"));
		while (g_hash_table_iter_next (&_tmp110_, &_tmp111_, &_tmp112_)) {
			gchar* _key;
			gchar* _value;
			_key = (gchar*) _tmp111_;
			_value = (gchar*) _tmp112_;
			g_variant_builder_add (&_tmp109_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
		}
		g_variant_builder_add_value (&_tmp108_, g_variant_builder_end (&_tmp109_));
		g_variant_builder_add_value (&_tmp95_, g_variant_builder_end (&_tmp108_));
		g_variant_builder_add_value (&_tmp93_, g_variant_builder_end (&_tmp95_));
		_tmp92_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp93_));
	 result = (_vala_Unity_PlaceEntryInfo_array_free ( result,  result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_place_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetEntries") == 0) {
		_dbus_unity_place_service_get_entries (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_place_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_place_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_place_service_entry_added (GObject* _sender, Unity_PlaceEntryInfo* entry, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp113_;
	gchar** _tmp114_;
	GVariantBuilder _tmp115_;
	int _tmp116_;
	GVariantBuilder _tmp117_;
	GHashTableIter _tmp118_;
	gpointer _tmp119_;
	gpointer _tmp120_;
	GVariantBuilder _tmp121_;
	GVariantBuilder _tmp122_;
	GHashTableIter _tmp123_;
	gpointer _tmp124_;
	gpointer _tmp125_;
	GVariantBuilder _tmp126_;
	GVariantBuilder _tmp127_;
	GHashTableIter _tmp128_;
	gpointer _tmp129_;
	gpointer _tmp130_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp113_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp113_, g_variant_new_string ((*entry).dbus_path));
	g_variant_builder_add_value (&_tmp113_, g_variant_new_string ((*entry).display_name));
	g_variant_builder_add_value (&_tmp113_, g_variant_new_string ((*entry).icon));
	g_variant_builder_add_value (&_tmp113_, g_variant_new_uint32 ((*entry).position));
	_tmp114_ = (*entry).mimetypes;
	g_variant_builder_init (&_tmp115_, G_VARIANT_TYPE ("as"));
	for (_tmp116_ = 0; _tmp116_ < (*entry).mimetypes_length1; _tmp116_++) {
		g_variant_builder_add_value (&_tmp115_, g_variant_new_string (*_tmp114_));
		_tmp114_++;
	}
	g_variant_builder_add_value (&_tmp113_, g_variant_builder_end (&_tmp115_));
	g_variant_builder_add_value (&_tmp113_, g_variant_new_boolean ((*entry).sensitive));
	g_variant_builder_add_value (&_tmp113_, g_variant_new_string ((*entry).sections_model));
	g_hash_table_iter_init (&_tmp118_, (*entry).hints);
	g_variant_builder_init (&_tmp117_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp118_, &_tmp119_, &_tmp120_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp119_;
		_value = (gchar*) _tmp120_;
		g_variant_builder_add (&_tmp117_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_tmp113_, g_variant_builder_end (&_tmp117_));
	g_variant_builder_init (&_tmp121_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp121_, g_variant_new_string ((*entry).entry_renderer_info.default_renderer));
	g_variant_builder_add_value (&_tmp121_, g_variant_new_string ((*entry).entry_renderer_info.groups_model));
	g_variant_builder_add_value (&_tmp121_, g_variant_new_string ((*entry).entry_renderer_info.results_model));
	g_hash_table_iter_init (&_tmp123_, (*entry).entry_renderer_info.hints);
	g_variant_builder_init (&_tmp122_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp123_, &_tmp124_, &_tmp125_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp124_;
		_value = (gchar*) _tmp125_;
		g_variant_builder_add (&_tmp122_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_tmp121_, g_variant_builder_end (&_tmp122_));
	g_variant_builder_add_value (&_tmp113_, g_variant_builder_end (&_tmp121_));
	g_variant_builder_init (&_tmp126_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp126_, g_variant_new_string ((*entry).global_renderer_info.default_renderer));
	g_variant_builder_add_value (&_tmp126_, g_variant_new_string ((*entry).global_renderer_info.groups_model));
	g_variant_builder_add_value (&_tmp126_, g_variant_new_string ((*entry).global_renderer_info.results_model));
	g_hash_table_iter_init (&_tmp128_, (*entry).global_renderer_info.hints);
	g_variant_builder_init (&_tmp127_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp128_, &_tmp129_, &_tmp130_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp129_;
		_value = (gchar*) _tmp130_;
		g_variant_builder_add (&_tmp127_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_tmp126_, g_variant_builder_end (&_tmp127_));
	g_variant_builder_add_value (&_tmp113_, g_variant_builder_end (&_tmp126_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp113_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Place", "EntryAdded", _arguments, NULL);
}


static void _dbus_unity_place_service_entry_removed (GObject* _sender, const gchar* entry_dbus_path, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (entry_dbus_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Place", "EntryRemoved", _arguments, NULL);
}


guint unity_place_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_place_service_dbus_interface_info), &_unity_place_service_dbus_interface_vtable, data, _unity_place_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "entry-added", (GCallback) _dbus_unity_place_service_entry_added, data);
	g_signal_connect (object, "entry-removed", (GCallback) _dbus_unity_place_service_entry_removed, data);
	return result;
}


static void _unity_place_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_global_search (self, search, hints, error);
}


void unity_place_entry_service_set_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_search (self, search, hints, error);
}


void unity_place_entry_service_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_active (self, is_active, error);
}


void unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_active_section (self, section_id, error);
}


static void g_cclosure_user_marshal_VOID__UINT_STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_STRING_BOXED) (gpointer data1, guint arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}


static void unity_place_entry_service_base_init (UnityPlaceEntryServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("entry_renderer_info_changed", UNITY_TYPE_PLACE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE__PLACERENDERERINFO);
		g_signal_new ("global_renderer_info_changed", UNITY_TYPE_PLACE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE__PLACERENDERERINFO);
		g_signal_new ("place_entry_info_changed", UNITY_TYPE_PLACE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE__PLACEENTRYINFODATA);
		g_signal_new ("search_finished", UNITY_TYPE_PLACE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING_BOXED, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_HASH_TABLE);
	}
}


/**
   * UnityPlaceEntryService:
   *
   * DBus interface for a given place entry exported by a place daemon
   */
GType unity_place_entry_service_get_type (void) {
	static volatile gsize unity_place_entry_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_entry_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceEntryServiceIface), (GBaseInitFunc) unity_place_entry_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_place_entry_service_type_id;
		unity_place_entry_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityPlaceEntryService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_place_entry_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_place_entry_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_place_entry_service_proxy_get_type);
		g_type_set_qdata (unity_place_entry_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.PlaceEntry");
		g_type_set_qdata (unity_place_entry_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_place_entry_service_register_object);
		g_once_init_leave (&unity_place_entry_service_type_id__volatile, unity_place_entry_service_type_id);
	}
	return unity_place_entry_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityPlaceEntryServiceProxy, unity_place_entry_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_PLACE_ENTRY_SERVICE, unity_place_entry_service_proxy_unity_place_entry_service_interface_init) )
static void unity_place_entry_service_proxy_class_init (UnityPlaceEntryServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_place_entry_service_proxy_g_signal;
}


static void _dbus_handle_unity_place_entry_service_entry_renderer_info_changed (UnityPlaceEntryService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	Unity_PlaceRendererInfo renderer_info = {0};
	GVariant* _tmp131_;
	Unity_PlaceRendererInfo _tmp132_;
	GVariantIter _tmp133_;
	GVariant* _tmp134_;
	GVariant* _tmp135_;
	GVariant* _tmp136_;
	GVariant* _tmp137_;
	GHashTable* _tmp138_;
	GVariantIter _tmp139_;
	GVariant* _tmp140_;
	GVariant* _tmp141_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp131_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp133_, _tmp131_);
	_tmp134_ = g_variant_iter_next_value (&_tmp133_);
	_tmp132_.default_renderer = g_variant_dup_string (_tmp134_, NULL);
	g_variant_unref (_tmp134_);
	_tmp135_ = g_variant_iter_next_value (&_tmp133_);
	_tmp132_.groups_model = g_variant_dup_string (_tmp135_, NULL);
	g_variant_unref (_tmp135_);
	_tmp136_ = g_variant_iter_next_value (&_tmp133_);
	_tmp132_.results_model = g_variant_dup_string (_tmp136_, NULL);
	g_variant_unref (_tmp136_);
	_tmp137_ = g_variant_iter_next_value (&_tmp133_);
	_tmp138_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp139_, _tmp137_);
	while (g_variant_iter_loop (&_tmp139_, "{?*}", &_tmp140_, &_tmp141_)) {
		g_hash_table_insert (_tmp138_, g_variant_dup_string (_tmp140_, NULL), g_variant_dup_string (_tmp141_, NULL));
	}
	_tmp132_.hints = _tmp138_;
	g_variant_unref (_tmp137_);
	renderer_info = _tmp132_;
	g_variant_unref (_tmp131_);
	g_signal_emit_by_name (self, "entry-renderer-info-changed", &renderer_info);
	unity__placerendererinfo_destroy (&renderer_info);
}


static void _dbus_handle_unity_place_entry_service_global_renderer_info_changed (UnityPlaceEntryService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	Unity_PlaceRendererInfo renderer_info = {0};
	GVariant* _tmp142_;
	Unity_PlaceRendererInfo _tmp143_;
	GVariantIter _tmp144_;
	GVariant* _tmp145_;
	GVariant* _tmp146_;
	GVariant* _tmp147_;
	GVariant* _tmp148_;
	GHashTable* _tmp149_;
	GVariantIter _tmp150_;
	GVariant* _tmp151_;
	GVariant* _tmp152_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp142_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp144_, _tmp142_);
	_tmp145_ = g_variant_iter_next_value (&_tmp144_);
	_tmp143_.default_renderer = g_variant_dup_string (_tmp145_, NULL);
	g_variant_unref (_tmp145_);
	_tmp146_ = g_variant_iter_next_value (&_tmp144_);
	_tmp143_.groups_model = g_variant_dup_string (_tmp146_, NULL);
	g_variant_unref (_tmp146_);
	_tmp147_ = g_variant_iter_next_value (&_tmp144_);
	_tmp143_.results_model = g_variant_dup_string (_tmp147_, NULL);
	g_variant_unref (_tmp147_);
	_tmp148_ = g_variant_iter_next_value (&_tmp144_);
	_tmp149_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp150_, _tmp148_);
	while (g_variant_iter_loop (&_tmp150_, "{?*}", &_tmp151_, &_tmp152_)) {
		g_hash_table_insert (_tmp149_, g_variant_dup_string (_tmp151_, NULL), g_variant_dup_string (_tmp152_, NULL));
	}
	_tmp143_.hints = _tmp149_;
	g_variant_unref (_tmp148_);
	renderer_info = _tmp143_;
	g_variant_unref (_tmp142_);
	g_signal_emit_by_name (self, "global-renderer-info-changed", &renderer_info);
	unity__placerendererinfo_destroy (&renderer_info);
}


static void _dbus_handle_unity_place_entry_service_place_entry_info_changed (UnityPlaceEntryService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	Unity_PlaceEntryInfoData entry_info_data = {0};
	GVariant* _tmp153_;
	Unity_PlaceEntryInfoData _tmp154_;
	GVariantIter _tmp155_;
	GVariant* _tmp156_;
	GVariant* _tmp157_;
	GVariant* _tmp158_;
	GVariant* _tmp159_;
	GVariant* _tmp160_;
	gchar** _tmp161_;
	int _tmp161__length;
	int _tmp161__size;
	int _tmp161__length1;
	GVariantIter _tmp162_;
	GVariant* _tmp163_;
	GVariant* _tmp164_;
	GVariant* _tmp165_;
	GVariant* _tmp166_;
	GHashTable* _tmp167_;
	GVariantIter _tmp168_;
	GVariant* _tmp169_;
	GVariant* _tmp170_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp153_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp155_, _tmp153_);
	_tmp156_ = g_variant_iter_next_value (&_tmp155_);
	_tmp154_.dbus_path = g_variant_dup_string (_tmp156_, NULL);
	g_variant_unref (_tmp156_);
	_tmp157_ = g_variant_iter_next_value (&_tmp155_);
	_tmp154_.display_name = g_variant_dup_string (_tmp157_, NULL);
	g_variant_unref (_tmp157_);
	_tmp158_ = g_variant_iter_next_value (&_tmp155_);
	_tmp154_.icon = g_variant_dup_string (_tmp158_, NULL);
	g_variant_unref (_tmp158_);
	_tmp159_ = g_variant_iter_next_value (&_tmp155_);
	_tmp154_.position = g_variant_get_uint32 (_tmp159_);
	g_variant_unref (_tmp159_);
	_tmp160_ = g_variant_iter_next_value (&_tmp155_);
	_tmp161_ = g_new (gchar*, 5);
	_tmp161__length = 0;
	_tmp161__size = 4;
	_tmp161__length1 = 0;
	g_variant_iter_init (&_tmp162_, _tmp160_);
	for (; (_tmp163_ = g_variant_iter_next_value (&_tmp162_)) != NULL; _tmp161__length1++) {
		if (_tmp161__size == _tmp161__length) {
			_tmp161__size = 2 * _tmp161__size;
			_tmp161_ = g_renew (gchar*, _tmp161_, _tmp161__size + 1);
		}
		_tmp161_[_tmp161__length++] = g_variant_dup_string (_tmp163_, NULL);
		g_variant_unref (_tmp163_);
	}
	_tmp154_.mimetypes_length1 = _tmp161__length1;
	_tmp161_[_tmp161__length] = NULL;
	_tmp154_.mimetypes = _tmp161_;
	g_variant_unref (_tmp160_);
	_tmp164_ = g_variant_iter_next_value (&_tmp155_);
	_tmp154_.sensitive = g_variant_get_boolean (_tmp164_);
	g_variant_unref (_tmp164_);
	_tmp165_ = g_variant_iter_next_value (&_tmp155_);
	_tmp154_.sections_model = g_variant_dup_string (_tmp165_, NULL);
	g_variant_unref (_tmp165_);
	_tmp166_ = g_variant_iter_next_value (&_tmp155_);
	_tmp167_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp168_, _tmp166_);
	while (g_variant_iter_loop (&_tmp168_, "{?*}", &_tmp169_, &_tmp170_)) {
		g_hash_table_insert (_tmp167_, g_variant_dup_string (_tmp169_, NULL), g_variant_dup_string (_tmp170_, NULL));
	}
	_tmp154_.hints = _tmp167_;
	g_variant_unref (_tmp166_);
	entry_info_data = _tmp154_;
	g_variant_unref (_tmp153_);
	g_signal_emit_by_name (self, "place-entry-info-changed", &entry_info_data);
	unity__placeentryinfodata_destroy (&entry_info_data);
}


static void _dbus_handle_unity_place_entry_service_search_finished (UnityPlaceEntryService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint section = 0U;
	GVariant* _tmp171_;
	gchar* search = NULL;
	GVariant* _tmp172_;
	GHashTable* hints = NULL;
	GVariant* _tmp173_;
	GHashTable* _tmp174_;
	GVariantIter _tmp175_;
	GVariant* _tmp176_;
	GVariant* _tmp177_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp171_ = g_variant_iter_next_value (&_arguments_iter);
	section = g_variant_get_uint32 (_tmp171_);
	g_variant_unref (_tmp171_);
	_tmp172_ = g_variant_iter_next_value (&_arguments_iter);
	search = g_variant_dup_string (_tmp172_, NULL);
	g_variant_unref (_tmp172_);
	_tmp173_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp174_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp175_, _tmp173_);
	while (g_variant_iter_loop (&_tmp175_, "{?*}", &_tmp176_, &_tmp177_)) {
		g_hash_table_insert (_tmp174_, g_variant_dup_string (_tmp176_, NULL), g_variant_dup_string (_tmp177_, NULL));
	}
	hints = _tmp174_;
	g_variant_unref (_tmp173_);
	g_signal_emit_by_name (self, "search-finished", section, search, hints);
	_g_free0 (search);
	_g_hash_table_unref0 (hints);
}


static void unity_place_entry_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "EntryRendererInfoChanged") == 0) {
		_dbus_handle_unity_place_entry_service_entry_renderer_info_changed ((UnityPlaceEntryService*) proxy, parameters);
	} else if (strcmp (signal_name, "GlobalRendererInfoChanged") == 0) {
		_dbus_handle_unity_place_entry_service_global_renderer_info_changed ((UnityPlaceEntryService*) proxy, parameters);
	} else if (strcmp (signal_name, "PlaceEntryInfoChanged") == 0) {
		_dbus_handle_unity_place_entry_service_place_entry_info_changed ((UnityPlaceEntryService*) proxy, parameters);
	} else if (strcmp (signal_name, "SearchFinished") == 0) {
		_dbus_handle_unity_place_entry_service_search_finished ((UnityPlaceEntryService*) proxy, parameters);
	}
}


static void unity_place_entry_service_proxy_init (UnityPlaceEntryServiceProxy* self) {
}


static void unity_place_entry_service_proxy_set_global_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp178_;
	GHashTableIter _tmp179_;
	gpointer _tmp180_;
	gpointer _tmp181_;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceEntry", "SetGlobalSearch");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search));
	g_hash_table_iter_init (&_tmp179_, hints);
	g_variant_builder_init (&_tmp178_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp179_, &_tmp180_, &_tmp181_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp180_;
		_value = (gchar*) _tmp181_;
		g_variant_builder_add (&_tmp178_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp178_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_place_entry_service_proxy_set_search (UnityPlaceEntryService* self, const gchar* search, GHashTable* hints, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp182_;
	GHashTableIter _tmp183_;
	gpointer _tmp184_;
	gpointer _tmp185_;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceEntry", "SetSearch");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search));
	g_hash_table_iter_init (&_tmp183_, hints);
	g_variant_builder_init (&_tmp182_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp183_, &_tmp184_, &_tmp185_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp184_;
		_value = (gchar*) _tmp185_;
		g_variant_builder_add (&_tmp182_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp182_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_place_entry_service_proxy_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceEntry", "SetActive");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (is_active));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_place_entry_service_proxy_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceEntry", "SetActiveSection");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (section_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_place_entry_service_proxy_unity_place_entry_service_interface_init (UnityPlaceEntryServiceIface* iface) {
	iface->set_global_search = unity_place_entry_service_proxy_set_global_search;
	iface->set_search = unity_place_entry_service_proxy_set_search;
	iface->set_active = unity_place_entry_service_proxy_set_active;
	iface->set_active_section = unity_place_entry_service_proxy_set_active_section;
}


static void _dbus_unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* search = NULL;
	GVariant* _tmp186_;
	GHashTable* hints = NULL;
	GVariant* _tmp187_;
	GHashTable* _tmp188_;
	GVariantIter _tmp189_;
	GVariant* _tmp190_;
	GVariant* _tmp191_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp186_ = g_variant_iter_next_value (&_arguments_iter);
	search = g_variant_dup_string (_tmp186_, NULL);
	g_variant_unref (_tmp186_);
	_tmp187_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp188_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp189_, _tmp187_);
	while (g_variant_iter_loop (&_tmp189_, "{?*}", &_tmp190_, &_tmp191_)) {
		g_hash_table_insert (_tmp188_, g_variant_dup_string (_tmp190_, NULL), g_variant_dup_string (_tmp191_, NULL));
	}
	hints = _tmp188_;
	g_variant_unref (_tmp187_);
	unity_place_entry_service_set_global_search (self, search, hints, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (search);
	_g_hash_table_unref0 (hints);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_place_entry_service_set_search (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* search = NULL;
	GVariant* _tmp192_;
	GHashTable* hints = NULL;
	GVariant* _tmp193_;
	GHashTable* _tmp194_;
	GVariantIter _tmp195_;
	GVariant* _tmp196_;
	GVariant* _tmp197_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp192_ = g_variant_iter_next_value (&_arguments_iter);
	search = g_variant_dup_string (_tmp192_, NULL);
	g_variant_unref (_tmp192_);
	_tmp193_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp194_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp195_, _tmp193_);
	while (g_variant_iter_loop (&_tmp195_, "{?*}", &_tmp196_, &_tmp197_)) {
		g_hash_table_insert (_tmp194_, g_variant_dup_string (_tmp196_, NULL), g_variant_dup_string (_tmp197_, NULL));
	}
	hints = _tmp194_;
	g_variant_unref (_tmp193_);
	unity_place_entry_service_set_search (self, search, hints, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (search);
	_g_hash_table_unref0 (hints);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_place_entry_service_set_active (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean is_active = FALSE;
	GVariant* _tmp198_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp198_ = g_variant_iter_next_value (&_arguments_iter);
	is_active = g_variant_get_boolean (_tmp198_);
	g_variant_unref (_tmp198_);
	unity_place_entry_service_set_active (self, is_active, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint section_id = 0U;
	GVariant* _tmp199_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp199_ = g_variant_iter_next_value (&_arguments_iter);
	section_id = g_variant_get_uint32 (_tmp199_);
	g_variant_unref (_tmp199_);
	unity_place_entry_service_set_active_section (self, section_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_place_entry_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetGlobalSearch") == 0) {
		_dbus_unity_place_entry_service_set_global_search (object, parameters, invocation);
	} else if (strcmp (method_name, "SetSearch") == 0) {
		_dbus_unity_place_entry_service_set_search (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActive") == 0) {
		_dbus_unity_place_entry_service_set_active (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActiveSection") == 0) {
		_dbus_unity_place_entry_service_set_active_section (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_place_entry_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_place_entry_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_place_entry_service_entry_renderer_info_changed (GObject* _sender, Unity_PlaceRendererInfo* renderer_info, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp200_;
	GVariantBuilder _tmp201_;
	GHashTableIter _tmp202_;
	gpointer _tmp203_;
	gpointer _tmp204_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp200_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp200_, g_variant_new_string ((*renderer_info).default_renderer));
	g_variant_builder_add_value (&_tmp200_, g_variant_new_string ((*renderer_info).groups_model));
	g_variant_builder_add_value (&_tmp200_, g_variant_new_string ((*renderer_info).results_model));
	g_hash_table_iter_init (&_tmp202_, (*renderer_info).hints);
	g_variant_builder_init (&_tmp201_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp202_, &_tmp203_, &_tmp204_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp203_;
		_value = (gchar*) _tmp204_;
		g_variant_builder_add (&_tmp201_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_tmp200_, g_variant_builder_end (&_tmp201_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp200_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.PlaceEntry", "EntryRendererInfoChanged", _arguments, NULL);
}


static void _dbus_unity_place_entry_service_global_renderer_info_changed (GObject* _sender, Unity_PlaceRendererInfo* renderer_info, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp205_;
	GVariantBuilder _tmp206_;
	GHashTableIter _tmp207_;
	gpointer _tmp208_;
	gpointer _tmp209_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp205_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*renderer_info).default_renderer));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*renderer_info).groups_model));
	g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*renderer_info).results_model));
	g_hash_table_iter_init (&_tmp207_, (*renderer_info).hints);
	g_variant_builder_init (&_tmp206_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp207_, &_tmp208_, &_tmp209_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp208_;
		_value = (gchar*) _tmp209_;
		g_variant_builder_add (&_tmp206_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_tmp205_, g_variant_builder_end (&_tmp206_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp205_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.PlaceEntry", "GlobalRendererInfoChanged", _arguments, NULL);
}


static void _dbus_unity_place_entry_service_place_entry_info_changed (GObject* _sender, Unity_PlaceEntryInfoData* entry_info_data, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp210_;
	gchar** _tmp211_;
	GVariantBuilder _tmp212_;
	int _tmp213_;
	GVariantBuilder _tmp214_;
	GHashTableIter _tmp215_;
	gpointer _tmp216_;
	gpointer _tmp217_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp210_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp210_, g_variant_new_string ((*entry_info_data).dbus_path));
	g_variant_builder_add_value (&_tmp210_, g_variant_new_string ((*entry_info_data).display_name));
	g_variant_builder_add_value (&_tmp210_, g_variant_new_string ((*entry_info_data).icon));
	g_variant_builder_add_value (&_tmp210_, g_variant_new_uint32 ((*entry_info_data).position));
	_tmp211_ = (*entry_info_data).mimetypes;
	g_variant_builder_init (&_tmp212_, G_VARIANT_TYPE ("as"));
	for (_tmp213_ = 0; _tmp213_ < (*entry_info_data).mimetypes_length1; _tmp213_++) {
		g_variant_builder_add_value (&_tmp212_, g_variant_new_string (*_tmp211_));
		_tmp211_++;
	}
	g_variant_builder_add_value (&_tmp210_, g_variant_builder_end (&_tmp212_));
	g_variant_builder_add_value (&_tmp210_, g_variant_new_boolean ((*entry_info_data).sensitive));
	g_variant_builder_add_value (&_tmp210_, g_variant_new_string ((*entry_info_data).sections_model));
	g_hash_table_iter_init (&_tmp215_, (*entry_info_data).hints);
	g_variant_builder_init (&_tmp214_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp215_, &_tmp216_, &_tmp217_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp216_;
		_value = (gchar*) _tmp217_;
		g_variant_builder_add (&_tmp214_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_tmp210_, g_variant_builder_end (&_tmp214_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp210_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.PlaceEntry", "PlaceEntryInfoChanged", _arguments, NULL);
}


static void _dbus_unity_place_entry_service_search_finished (GObject* _sender, guint section, const gchar* search, GHashTable* hints, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp218_;
	GHashTableIter _tmp219_;
	gpointer _tmp220_;
	gpointer _tmp221_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (section));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search));
	g_hash_table_iter_init (&_tmp219_, hints);
	g_variant_builder_init (&_tmp218_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp219_, &_tmp220_, &_tmp221_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp220_;
		_value = (gchar*) _tmp221_;
		g_variant_builder_add (&_tmp218_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp218_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.PlaceEntry", "SearchFinished", _arguments, NULL);
}


guint unity_place_entry_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_place_entry_service_dbus_interface_info), &_unity_place_entry_service_dbus_interface_vtable, data, _unity_place_entry_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "entry-renderer-info-changed", (GCallback) _dbus_unity_place_entry_service_entry_renderer_info_changed, data);
	g_signal_connect (object, "global-renderer-info-changed", (GCallback) _dbus_unity_place_entry_service_global_renderer_info_changed, data);
	g_signal_connect (object, "place-entry-info-changed", (GCallback) _dbus_unity_place_entry_service_place_entry_info_changed, data);
	g_signal_connect (object, "search-finished", (GCallback) _dbus_unity_place_entry_service_search_finished, data);
	return result;
}


static void _unity_place_entry_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


UnityPlaceServiceImpl* unity_place_service_impl_construct (GType object_type, const gchar* dbus_path) {
	UnityPlaceServiceImpl * self = NULL;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	self = (UnityPlaceServiceImpl*) g_object_new (object_type, "dbus-path", dbus_path, NULL);
	return self;
}


UnityPlaceServiceImpl* unity_place_service_impl_new (const gchar* dbus_path) {
	return unity_place_service_impl_construct (UNITY_TYPE_PLACE_SERVICE_IMPL, dbus_path);
}


static Unity_PlaceEntryInfo* unity_place_service_impl_real_get_entries (UnityPlaceService* base, int* result_length1, GError** error) {
	UnityPlaceServiceImpl * self;
	Unity_PlaceEntryInfo* result = NULL;
	guint _tmp0_;
	Unity_PlaceEntryInfo* _tmp1_ = NULL;
	Unity_PlaceEntryInfo* _result_;
	gint _result__length1;
	gint __result__size_;
	gint i;
	GList* _tmp2_ = NULL;
	Unity_PlaceEntryInfo* _tmp7_;
	self = (UnityPlaceServiceImpl*) base;
	_tmp0_ = g_hash_table_size (self->priv->entries);
	_tmp1_ = g_new0 (Unity_PlaceEntryInfo, _tmp0_);
	_result_ = _tmp1_;
	_result__length1 = _tmp0_;
	__result__size_ = _tmp0_;
	i = 0;
	_tmp2_ = g_hash_table_get_values (self->priv->entries);
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = _tmp2_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				UnityPlaceEntryInfo* _tmp3_ = NULL;
				Unity_PlaceEntryInfo _tmp4_ = {0};
				Unity_PlaceEntryInfo _tmp5_ = {0};
				Unity_PlaceEntryInfo _tmp6_;
				_tmp3_ = unity_place_entry_service_impl_get_entry_info (entry);
				unity_place_entry_info_get_raw (_tmp3_, &_tmp4_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				unity__placeentryinfo_destroy (&_result_[i]);
				_result_[i] = _tmp6_;
				i++;
			}
		}
		_g_list_free0 (entry_collection);
	}
	_tmp7_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp7_;
	return result;
}


void unity_place_service_impl_add_entry (UnityPlaceServiceImpl* self, UnityPlaceEntryInfo* entry_info) {
	const gchar* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp2_ = NULL;
	UnityPlaceEntryServiceImpl* entry;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	UnityPlaceEntryServiceImpl* _tmp5_;
	gboolean _tmp6_;
	Unity_PlaceEntryInfo _tmp9_ = {0};
	Unity_PlaceEntryInfo _tmp10_ = {0};
	Unity_PlaceEntryInfo _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_info != NULL);
	_tmp0_ = unity_place_entry_info_get_dbus_path (entry_info);
	_tmp1_ = g_hash_table_lookup (self->priv->entries, _tmp0_);
	if (((UnityPlaceEntryServiceImpl*) _tmp1_) != NULL) {
		return;
	}
	_tmp2_ = unity_place_entry_service_impl_new (entry_info);
	entry = _tmp2_;
	_tmp3_ = unity_place_entry_info_get_dbus_path (entry_info);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _g_object_ref0 (entry);
	g_hash_table_insert (self->priv->entries, _tmp4_, _tmp5_);
	_tmp6_ = unity_place_service_impl_get_exported (self);
	if (_tmp6_) {
		unity_place_entry_service_impl_export (entry, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch16_g_io_error;
			}
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally16;
		__catch16_g_io_error:
		{
			GError * e;
			UnityPlaceEntryInfo* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = unity_place_entry_service_impl_get_entry_info (entry);
			_tmp8_ = unity_place_entry_info_get_dbus_path (_tmp7_);
			g_critical ("unity-place.vala:647: Failed to export entry '%s': %s", _tmp8_, e->message);
			_g_error_free0 (e);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	unity_place_entry_info_get_raw (entry_info, &_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	g_signal_emit_by_name ((UnityPlaceService*) self, "entry-added", &_tmp11_);
	unity__placeentryinfo_destroy (&_tmp11_);
	_g_object_unref0 (entry);
}


UnityPlaceEntryInfo* unity_place_service_impl_get_entry (UnityPlaceServiceImpl* self, const gchar* dbus_path) {
	UnityPlaceEntryInfo* result = NULL;
	gconstpointer _tmp0_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp1_;
	UnityPlaceEntryServiceImpl* entry;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->entries, dbus_path);
	_tmp1_ = _g_object_ref0 ((UnityPlaceEntryServiceImpl*) _tmp0_);
	entry = _tmp1_;
	if (entry != NULL) {
		UnityPlaceEntryInfo* _tmp2_ = NULL;
		UnityPlaceEntryInfo* _tmp3_;
		_tmp2_ = unity_place_entry_service_impl_get_entry_info (entry);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		result = _tmp3_;
		_g_object_unref0 (entry);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (entry);
		return result;
	}
	_g_object_unref0 (entry);
}


UnityPlaceEntryServiceImpl* unity_place_service_impl_get_entry_service (UnityPlaceServiceImpl* self, const gchar* dbus_path) {
	UnityPlaceEntryServiceImpl* result = NULL;
	gconstpointer _tmp0_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp1_;
	UnityPlaceEntryServiceImpl* entry;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->entries, dbus_path);
	_tmp1_ = _g_object_ref0 ((UnityPlaceEntryServiceImpl*) _tmp0_);
	entry = _tmp1_;
	if (entry != NULL) {
		result = entry;
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (entry);
		return result;
	}
	_g_object_unref0 (entry);
}


guint unity_place_service_impl_num_entries (UnityPlaceServiceImpl* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_hash_table_size (self->priv->entries);
	result = _tmp0_;
	return result;
}


gchar** unity_place_service_impl_get_entry_paths (UnityPlaceServiceImpl* self, int* result_length1) {
	gchar** result = NULL;
	guint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	gint i;
	GList* _tmp2_ = NULL;
	gchar** _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_size (self->priv->entries);
	_tmp1_ = g_new0 (gchar*, _tmp0_ + 1);
	_result_ = _tmp1_;
	_result__length1 = _tmp0_;
	__result__size_ = _tmp0_;
	i = 0;
	_tmp2_ = g_hash_table_get_values (self->priv->entries);
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = _tmp2_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				UnityPlaceEntryInfo* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = unity_place_entry_service_impl_get_entry_info (entry);
				_tmp4_ = unity_place_entry_info_get_dbus_path (_tmp3_);
				_tmp5_ = g_strdup (_tmp4_);
				_tmp6_ = _tmp5_;
				_g_free0 (_result_[i]);
				_result_[i] = _tmp6_;
				i++;
			}
		}
		_g_list_free0 (entry_collection);
	}
	_tmp7_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp7_;
	return result;
}


void unity_place_service_impl_remove_entry (UnityPlaceServiceImpl* self, const gchar* dbus_path) {
	gconstpointer _tmp0_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp1_;
	UnityPlaceEntryServiceImpl* entry;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_path != NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->entries, dbus_path);
	_tmp1_ = _g_object_ref0 ((UnityPlaceEntryServiceImpl*) _tmp0_);
	entry = _tmp1_;
	if (entry == NULL) {
		_g_object_unref0 (entry);
		return;
	}
	g_signal_emit_by_name ((UnityPlaceService*) self, "entry-removed", dbus_path);
	_tmp2_ = unity_place_service_impl_get_exported (self);
	if (_tmp2_) {
		unity_place_entry_service_impl_unexport (entry, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch17_g_io_error;
			}
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally17;
		__catch17_g_io_error:
		{
			GError * e;
			UnityPlaceEntryInfo* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = unity_place_entry_service_impl_get_entry_info (entry);
			_tmp4_ = unity_place_entry_info_get_dbus_path (_tmp3_);
			g_critical ("unity-place.vala:704: Failed to unexport '%s': %s", _tmp4_, e->message);
			_g_error_free0 (e);
		}
		__finally17:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_hash_table_remove (self->priv->entries, dbus_path);
	_g_object_unref0 (entry);
}


void unity_place_service_impl_export (UnityPlaceServiceImpl* self, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* conn;
	UnityPlaceServiceImpl* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	UnityPlaceServiceImpl* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GList* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = self;
	_tmp2_ = unity_place_service_register_object (UNITY_IS_PLACE_SERVICE (_tmp1_) ? ((UnityPlaceService*) _tmp1_) : NULL, conn, self->priv->_dbus_path, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_service_dbus_id = _tmp3_;
	_tmp4_ = self;
	_tmp5_ = unity_activation_register_object (UNITY_IS_ACTIVATION (_tmp4_) ? ((UnityActivation*) _tmp4_) : NULL, conn, self->priv->_dbus_path, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_activation_dbus_id = _tmp6_;
	_tmp7_ = g_hash_table_get_values (self->priv->entries);
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = _tmp7_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				unity_place_entry_service_impl_export (entry, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (entry_collection);
						_g_object_unref0 (conn);
						return;
					} else {
						_g_list_free0 (entry_collection);
						_g_object_unref0 (conn);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (entry_collection);
	}
	g_object_notify ((GObject*) self, "exported");
	_g_object_unref0 (conn);
}


void unity_place_service_impl_unexport (UnityPlaceServiceImpl* self, GError** error) {
	GList* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	GDBusConnection* conn;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_hash_table_get_values (self->priv->entries);
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				unity_place_entry_service_impl_unexport (entry, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (entry_collection);
						return;
					} else {
						_g_list_free0 (entry_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (entry_collection);
	}
	_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_dbus_connection_unregister_object (conn, self->priv->_service_dbus_id);
	g_dbus_connection_unregister_object (conn, self->priv->_activation_dbus_id);
	self->priv->_service_dbus_id = (guint) 0;
	self->priv->_activation_dbus_id = (guint) 0;
	g_object_notify ((GObject*) self, "exported");
	_g_object_unref0 (conn);
}


static void unity_place_service_impl_real_activate_data_free (gpointer _data) {
	UnityPlaceServiceImplActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_object_unref0 (data->self);
	g_slice_free (UnityPlaceServiceImplActivateData, data);
}


static void unity_place_service_impl_real_activate (UnityActivation* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPlaceServiceImpl * self;
	UnityPlaceServiceImplActivateData* _data_;
	self = (UnityPlaceServiceImpl*) base;
	_data_ = g_slice_new0 (UnityPlaceServiceImplActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_place_service_impl_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_place_service_impl_real_activate_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	unity_place_service_impl_real_activate_co (_data_);
}


static guint32 unity_place_service_impl_real_activate_finish (UnityActivation* base, GAsyncResult* _res_, GError** error) {
	guint32 result;
	UnityPlaceServiceImplActivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void unity_place_service_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPlaceServiceImplActivateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_place_service_impl_real_activate_co (data);
}


static gboolean unity_place_service_impl_real_activate_co (UnityPlaceServiceImplActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->_activation == NULL) {
		data->result = (guint32) UNITY_ACTIVATION_STATUS_NOT_ACTIVATED;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	unity_activation_activate (data->self->priv->_activation, data->uri, unity_place_service_impl_activate_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = unity_activation_activate_finish (data->self->priv->_activation, data->_res_, &data->_inner_error_);
	data->activated = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch18_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = data->activated;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	goto __finally18;
	__catch18_g_io_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->result = (guint32) UNITY_ACTIVATION_STATUS_NOT_ACTIVATED;
		_g_error_free0 (data->e);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally18:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
	g_clear_error (&data->_inner_error_);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


const gchar* unity_place_service_impl_get_dbus_path (UnityPlaceServiceImpl* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_place_service_impl_set_dbus_path (UnityPlaceServiceImpl* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


gboolean unity_place_service_impl_get_exported (UnityPlaceServiceImpl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_service_dbus_id != 0;
	return result;
}


UnityActivation* unity_place_service_impl_get_activation (UnityPlaceServiceImpl* self) {
	UnityActivation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_activation;
	return result;
}


void unity_place_service_impl_set_activation (UnityPlaceServiceImpl* self, UnityActivation* value) {
	UnityActivation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_activation);
	self->priv->_activation = _tmp0_;
	g_object_notify ((GObject *) self, "activation");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * unity_place_service_impl_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlaceServiceImpl * self;
	GHashTable* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_place_service_impl_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACE_SERVICE_IMPL (obj);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->entries);
	self->priv->entries = _tmp0_;
	return obj;
}


static void unity_place_service_impl_class_init (UnityPlaceServiceImplClass * klass) {
	unity_place_service_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceServiceImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_place_service_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_place_service_impl_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_place_service_impl_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_place_service_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_SERVICE_IMPL_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_SERVICE_IMPL_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_SERVICE_IMPL_ACTIVATION, g_param_spec_object ("activation", "activation", "activation", UNITY_TYPE_ACTIVATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_service_impl_unity_place_service_interface_init (UnityPlaceServiceIface * iface) {
	unity_place_service_impl_unity_place_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_entries = (Unity_PlaceEntryInfo* (*)(UnityPlaceService* ,int* ,GError**)) unity_place_service_impl_real_get_entries;
}


static void unity_place_service_impl_unity_activation_interface_init (UnityActivationIface * iface) {
	unity_place_service_impl_unity_activation_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (guint32 (*)(UnityActivation* ,const gchar* ,GError**)) unity_place_service_impl_real_activate;
	iface->activate_finish = unity_place_service_impl_real_activate_finish;
}


static void unity_place_service_impl_instance_init (UnityPlaceServiceImpl * self) {
	self->priv = UNITY_PLACE_SERVICE_IMPL_GET_PRIVATE (self);
	self->priv->_service_dbus_id = (guint) 0;
	self->priv->_activation_dbus_id = (guint) 0;
	self->priv->_activation = NULL;
}


static void unity_place_service_impl_finalize (GObject* obj) {
	UnityPlaceServiceImpl * self;
	self = UNITY_PLACE_SERVICE_IMPL (obj);
	_g_free0 (self->priv->_dbus_path);
	_g_hash_table_unref0 (self->priv->entries);
	_g_object_unref0 (self->priv->_activation);
	G_OBJECT_CLASS (unity_place_service_impl_parent_class)->finalize (obj);
}


/**
   * UnityPlaceServiceImpl:
   *
   * Private helper class to shield of DBus details and ugly
   * internal structs used for marshalling
   */
GType unity_place_service_impl_get_type (void) {
	static volatile gsize unity_place_service_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_service_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceServiceImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_service_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceServiceImpl), 0, (GInstanceInitFunc) unity_place_service_impl_instance_init, NULL };
		static const GInterfaceInfo unity_place_service_info = { (GInterfaceInitFunc) unity_place_service_impl_unity_place_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo unity_activation_info = { (GInterfaceInitFunc) unity_place_service_impl_unity_activation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_place_service_impl_type_id;
		unity_place_service_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceServiceImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_place_service_impl_type_id, UNITY_TYPE_PLACE_SERVICE, &unity_place_service_info);
		g_type_add_interface_static (unity_place_service_impl_type_id, UNITY_TYPE_ACTIVATION, &unity_activation_info);
		g_once_init_leave (&unity_place_service_impl_type_id__volatile, unity_place_service_impl_type_id);
	}
	return unity_place_service_impl_type_id__volatile;
}


static void _vala_unity_place_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceServiceImpl * self;
	self = UNITY_PLACE_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_SERVICE_IMPL_DBUS_PATH:
		g_value_set_string (value, unity_place_service_impl_get_dbus_path (self));
		break;
		case UNITY_PLACE_SERVICE_IMPL_EXPORTED:
		g_value_set_boolean (value, unity_place_service_impl_get_exported (self));
		break;
		case UNITY_PLACE_SERVICE_IMPL_ACTIVATION:
		g_value_set_object (value, unity_place_service_impl_get_activation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_place_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceServiceImpl * self;
	self = UNITY_PLACE_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_SERVICE_IMPL_DBUS_PATH:
		unity_place_service_impl_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_SERVICE_IMPL_ACTIVATION:
		unity_place_service_impl_set_activation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _unity_place_entry_service_impl_on_browser_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_place_entry_service_impl_on_browser_changed (self, _sender, pspec);
}


UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_construct (GType object_type, UnityPlaceEntryInfo* entry_info) {
	UnityPlaceEntryServiceImpl * self = NULL;
	UnityBrowser* _tmp0_ = NULL;
	UnityBrowser* _tmp1_;
	g_return_val_if_fail (entry_info != NULL, NULL);
	self = (UnityPlaceEntryServiceImpl*) g_object_new (object_type, "entry-info", entry_info, NULL);
	_tmp0_ = unity_place_entry_info_get_browser (entry_info);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_browser);
	self->priv->_browser = _tmp1_;
	g_signal_connect_object ((GObject*) entry_info, "notify::browser", (GCallback) _unity_place_entry_service_impl_on_browser_changed_g_object_notify, self, 0);
	return self;
}


UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_new (UnityPlaceEntryInfo* entry_info) {
	return unity_place_entry_service_impl_construct (UNITY_TYPE_PLACE_ENTRY_SERVICE_IMPL, entry_info);
}


static void unity_place_entry_service_impl_real_set_global_search (UnityPlaceEntryService* base, const gchar* search, GHashTable* hints, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	UnityPlaceSearch* _tmp0_ = NULL;
	UnityPlaceSearch* s;
	UnityPlaceSearch* _tmp1_ = NULL;
	gboolean _tmp2_;
	self = (UnityPlaceEntryServiceImpl*) base;
	g_return_if_fail (search != NULL);
	g_return_if_fail (hints != NULL);
	_tmp0_ = unity_place_search_new (search, hints);
	s = g_object_ref_sink (_tmp0_);
	unity_place_search_set_parent_entry (s, self->priv->_entry_info);
	_tmp1_ = unity_place_entry_info_get_active_global_search (self->priv->_entry_info);
	_tmp2_ = unity_place_search_equals (s, _tmp1_);
	if (!_tmp2_) {
		unity_place_entry_info_set_active_global_search (self->priv->_entry_info, s);
	}
	_g_object_unref0 (s);
}


static void unity_place_entry_service_impl_real_set_search (UnityPlaceEntryService* base, const gchar* search, GHashTable* hints, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	UnityPlaceSearch* _tmp0_ = NULL;
	UnityPlaceSearch* s;
	guint _tmp1_;
	UnityPlaceSearch* _tmp2_ = NULL;
	gboolean _tmp3_;
	self = (UnityPlaceEntryServiceImpl*) base;
	g_return_if_fail (search != NULL);
	g_return_if_fail (hints != NULL);
	_tmp0_ = unity_place_search_new (search, hints);
	s = g_object_ref_sink (_tmp0_);
	_tmp1_ = unity_place_entry_info_get_active_section (self->priv->_entry_info);
	unity_place_search_set_section (s, _tmp1_);
	unity_place_search_set_parent_entry (s, self->priv->_entry_info);
	_tmp2_ = unity_place_entry_info_get_active_search (self->priv->_entry_info);
	_tmp3_ = unity_place_search_equals (s, _tmp2_);
	if (!_tmp3_) {
		unity_place_entry_info_set_active_search (self->priv->_entry_info, s);
	}
	_g_object_unref0 (s);
}


static void unity_place_entry_service_impl_real_set_active (UnityPlaceEntryService* base, gboolean is_active, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	self = (UnityPlaceEntryServiceImpl*) base;
	unity_place_entry_info_set_active (self->priv->_entry_info, is_active);
}


static void unity_place_entry_service_impl_real_set_active_section (UnityPlaceEntryService* base, guint section_id, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	self = (UnityPlaceEntryServiceImpl*) base;
	unity_place_entry_info_set_active_section (self->priv->_entry_info, section_id);
}


void unity_place_entry_service_impl_export (UnityPlaceEntryServiceImpl* self, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* conn;
	const gchar* _tmp1_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	UnityBrowser* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = unity_place_entry_info_get_dbus_path (self->priv->_entry_info);
	_tmp2_ = self;
	_tmp3_ = unity_place_entry_service_register_object (UNITY_IS_PLACE_ENTRY_SERVICE (_tmp2_) ? ((UnityPlaceEntryService*) _tmp2_) : NULL, conn, _tmp1_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_dbus_id = _tmp4_;
	_tmp6_ = unity_place_entry_info_get_browser (self->priv->_entry_info);
	if (_tmp6_ != NULL) {
		_tmp5_ = self->priv->_browser_dbus_id == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		UnityBrowser* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		UnityBrowser* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		UnityBrowser* _tmp11_ = NULL;
		UnityBrowserService* _tmp12_ = NULL;
		UnityBrowserService* _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		_tmp7_ = unity_place_entry_info_get_browser (self->priv->_entry_info);
		_tmp8_ = unity_browser_get_dbus_path (_tmp7_);
		g_debug ("unity-place.vala:848: Exporting browser at '%s'", _tmp8_);
		_tmp9_ = unity_place_entry_info_get_browser (self->priv->_entry_info);
		_tmp10_ = unity_browser_get_dbus_path (_tmp9_);
		_tmp11_ = unity_place_entry_info_get_browser (self->priv->_entry_info);
		_tmp12_ = unity_browser_get_service (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = unity_browser_service_register_object (_tmp13_, conn, _tmp10_, &_inner_error_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (conn);
				return;
			} else {
				_g_object_unref0 (conn);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->_browser_dbus_id = _tmp16_;
	} else {
		g_debug ("unity-place.vala:854: No browser to export");
	}
	g_object_notify ((GObject*) self, "exported");
	_g_object_unref0 (conn);
}


void unity_place_entry_service_impl_unexport (UnityPlaceEntryServiceImpl* self, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* conn;
	gboolean _tmp1_ = FALSE;
	UnityBrowser* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_dbus_connection_unregister_object (conn, self->priv->_dbus_id);
	_tmp2_ = unity_place_entry_info_get_browser (self->priv->_entry_info);
	if (_tmp2_ != NULL) {
		_tmp1_ = self->priv->_browser_dbus_id != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		UnityBrowser* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = unity_place_entry_info_get_browser (self->priv->_entry_info);
		_tmp4_ = unity_browser_get_dbus_path (_tmp3_);
		g_debug ("unity-place.vala:866: Unexporting browser '%s'", _tmp4_);
		g_dbus_connection_unregister_object (conn, self->priv->_browser_dbus_id);
		self->priv->_browser_dbus_id = (guint) 0;
	}
	self->priv->_dbus_id = (guint) 0;
	g_object_notify ((GObject*) self, "exported");
	_g_object_unref0 (conn);
}


static void unity_place_entry_service_impl_on_browser_changed (UnityPlaceEntryServiceImpl* self, GObject* obj, GParamSpec* pspec) {
	GDBusConnection* conn = NULL;
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_;
	UnityPlaceEntryInfo* _tmp2_ = NULL;
	UnityBrowser* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	UnityPlaceEntryInfo* _tmp6_ = NULL;
	UnityBrowser* _tmp7_ = NULL;
	UnityBrowser* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch19_g_io_error;
		}
		_g_object_unref0 (conn);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (conn);
	conn = _tmp1_;
	goto __finally19;
	__catch19_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-place.vala:881: Unable to connect to session bus: %s", e->message);
		_g_error_free0 (e);
		_g_object_unref0 (conn);
		return;
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = unity_place_entry_service_impl_get_entry_info (self);
	_tmp3_ = unity_place_entry_info_get_browser (_tmp2_);
	if (self->priv->_browser == _tmp3_) {
		_g_object_unref0 (conn);
		return;
	}
	if (self->priv->_browser != NULL) {
		_tmp4_ = self->priv->_browser_dbus_id != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = unity_browser_get_dbus_path (self->priv->_browser);
		g_debug ("unity-place.vala:892: Unexporting browser '%s'", _tmp5_);
		g_dbus_connection_unregister_object (conn, self->priv->_browser_dbus_id);
	}
	_tmp6_ = unity_place_entry_service_impl_get_entry_info (self);
	_tmp7_ = unity_place_entry_info_get_browser (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->_browser);
	self->priv->_browser = _tmp8_;
	self->priv->_browser_dbus_id = (guint) 0;
	if (self->priv->_browser != NULL) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		UnityBrowserService* _tmp11_ = NULL;
		UnityBrowserService* _tmp12_;
		guint _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		_tmp9_ = unity_browser_get_dbus_path (self->priv->_browser);
		g_debug ("unity-place.vala:902: Exporting browser '%s'", _tmp9_);
		_tmp10_ = unity_browser_get_dbus_path (self->priv->_browser);
		_tmp11_ = unity_browser_get_service (self->priv->_browser);
		_tmp12_ = _tmp11_;
		_tmp13_ = unity_browser_service_register_object (_tmp12_, conn, _tmp10_, &_inner_error_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch20_g_io_error;
			}
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->_browser_dbus_id = _tmp15_;
		goto __finally20;
		__catch20_g_io_error:
		{
			GError * e;
			const gchar* _tmp16_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = unity_browser_get_dbus_path (self->priv->_browser);
			g_critical ("unity-place.vala:907: failed to export browser '%s': %s", _tmp16_, e->message);
			_g_error_free0 (e);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (conn);
}


static gboolean _unity_place_entry_service_impl_emit_place_entry_info_changed_signal_gsource_func (gpointer self) {
	gboolean result;
	result = unity_place_entry_service_impl_emit_place_entry_info_changed_signal (self);
	return result;
}


void unity_place_entry_service_impl_queue_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->place_entry_info_changed_signal_source == 0) {
		guint _tmp0_;
		_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_place_entry_service_impl_emit_place_entry_info_changed_signal_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->place_entry_info_changed_signal_source = _tmp0_;
	}
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean unity_place_entry_service_impl_emit_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self) {
	gboolean result = FALSE;
	Unity_PlaceEntryInfoData entry_data = {0};
	Unity_PlaceEntryInfo _tmp0_ = {0};
	Unity_PlaceEntryInfo _tmp1_ = {0};
	Unity_PlaceEntryInfo _entry;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar* _tmp7_;
	GHashTable* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&entry_data, 0, sizeof (Unity_PlaceEntryInfoData));
	unity_place_entry_info_get_raw (self->priv->_entry_info, &_tmp0_);
	_tmp1_ = _tmp0_;
	_entry = _tmp1_;
	_tmp2_ = g_strdup (_entry.dbus_path);
	_g_free0 (entry_data.dbus_path);
	entry_data.dbus_path = _tmp2_;
	_tmp3_ = g_strdup (_entry.display_name);
	_g_free0 (entry_data.display_name);
	entry_data.display_name = _tmp3_;
	_tmp4_ = g_strdup (_entry.icon);
	_g_free0 (entry_data.icon);
	entry_data.icon = _tmp4_;
	entry_data.position = _entry.position;
	_tmp5_ = (_tmp6_ = _entry.mimetypes, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup8 (_tmp6_, _entry.mimetypes_length1));
	entry_data.mimetypes = (_vala_array_free (entry_data.mimetypes, entry_data.mimetypes_length1, (GDestroyNotify) g_free), NULL);
	entry_data.mimetypes = _tmp5_;
	entry_data.mimetypes_length1 = _entry.mimetypes_length1;
	entry_data._mimetypes_size_ = _entry.mimetypes_length1;
	entry_data.sensitive = _entry.sensitive;
	_tmp7_ = g_strdup (_entry.sections_model);
	_g_free0 (entry_data.sections_model);
	entry_data.sections_model = _tmp7_;
	_tmp8_ = _g_hash_table_ref0 (_entry.hints);
	_g_hash_table_unref0 (entry_data.hints);
	entry_data.hints = _tmp8_;
	g_signal_emit_by_name ((UnityPlaceEntryService*) self, "place-entry-info-changed", &entry_data);
	self->priv->place_entry_info_changed_signal_source = (guint) 0;
	result = FALSE;
	unity__placeentryinfo_destroy (&_entry);
	unity__placeentryinfodata_destroy (&entry_data);
	return result;
}


UnityPlaceEntryInfo* unity_place_entry_service_impl_get_entry_info (UnityPlaceEntryServiceImpl* self) {
	UnityPlaceEntryInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_info;
	return result;
}


static void unity_place_entry_service_impl_set_entry_info (UnityPlaceEntryServiceImpl* self, UnityPlaceEntryInfo* value) {
	UnityPlaceEntryInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_entry_info);
	self->priv->_entry_info = _tmp0_;
	g_object_notify ((GObject *) self, "entry-info");
}


gboolean unity_place_entry_service_impl_get_exported (UnityPlaceEntryServiceImpl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dbus_id != 0;
	return result;
}


static void unity_place_entry_service_impl_class_init (UnityPlaceEntryServiceImplClass * klass) {
	unity_place_entry_service_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceEntryServiceImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_place_entry_service_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_place_entry_service_impl_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_place_entry_service_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO, g_param_spec_object ("entry-info", "entry-info", "entry-info", UNITY_TYPE_PLACE_ENTRY_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_SERVICE_IMPL_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_place_entry_service_impl_unity_place_entry_service_interface_init (UnityPlaceEntryServiceIface * iface) {
	unity_place_entry_service_impl_unity_place_entry_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_global_search = (void (*)(UnityPlaceEntryService* ,const gchar* ,GHashTable* ,GError**)) unity_place_entry_service_impl_real_set_global_search;
	iface->set_search = (void (*)(UnityPlaceEntryService* ,const gchar* ,GHashTable* ,GError**)) unity_place_entry_service_impl_real_set_search;
	iface->set_active = (void (*)(UnityPlaceEntryService* ,gboolean ,GError**)) unity_place_entry_service_impl_real_set_active;
	iface->set_active_section = (void (*)(UnityPlaceEntryService* ,guint ,GError**)) unity_place_entry_service_impl_real_set_active_section;
}


static void unity_place_entry_service_impl_instance_init (UnityPlaceEntryServiceImpl * self) {
	self->priv = UNITY_PLACE_ENTRY_SERVICE_IMPL_GET_PRIVATE (self);
	self->priv->_dbus_id = (guint) 0;
	self->priv->place_entry_info_changed_signal_source = (guint) 0;
	self->priv->_browser = NULL;
	self->priv->_browser_dbus_id = (guint) 0;
}


static void unity_place_entry_service_impl_finalize (GObject* obj) {
	UnityPlaceEntryServiceImpl * self;
	self = UNITY_PLACE_ENTRY_SERVICE_IMPL (obj);
	_g_object_unref0 (self->priv->_entry_info);
	_g_object_unref0 (self->priv->_browser);
	G_OBJECT_CLASS (unity_place_entry_service_impl_parent_class)->finalize (obj);
}


/**
   * UnityPlaceEntryServiceImpl:
   *
   * Private helper class to shield of DBus details and ugly
   * internal structs used for marshalling
   */
GType unity_place_entry_service_impl_get_type (void) {
	static volatile gsize unity_place_entry_service_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_entry_service_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceEntryServiceImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_entry_service_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceEntryServiceImpl), 0, (GInstanceInitFunc) unity_place_entry_service_impl_instance_init, NULL };
		static const GInterfaceInfo unity_place_entry_service_info = { (GInterfaceInitFunc) unity_place_entry_service_impl_unity_place_entry_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_place_entry_service_impl_type_id;
		unity_place_entry_service_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceEntryServiceImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_place_entry_service_impl_type_id, UNITY_TYPE_PLACE_ENTRY_SERVICE, &unity_place_entry_service_info);
		g_once_init_leave (&unity_place_entry_service_impl_type_id__volatile, unity_place_entry_service_impl_type_id);
	}
	return unity_place_entry_service_impl_type_id__volatile;
}


static void _vala_unity_place_entry_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryServiceImpl * self;
	self = UNITY_PLACE_ENTRY_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO:
		g_value_set_object (value, unity_place_entry_service_impl_get_entry_info (self));
		break;
		case UNITY_PLACE_ENTRY_SERVICE_IMPL_EXPORTED:
		g_value_set_boolean (value, unity_place_entry_service_impl_get_exported (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_place_entry_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryServiceImpl * self;
	self = UNITY_PLACE_ENTRY_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO:
		unity_place_entry_service_impl_set_entry_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Unity_PlaceEntrySignals* unity__placeentrysignals_dup (const Unity_PlaceEntrySignals* self) {
	Unity_PlaceEntrySignals* dup;
	dup = g_new0 (Unity_PlaceEntrySignals, 1);
	memcpy (dup, self, sizeof (Unity_PlaceEntrySignals));
	return dup;
}


void unity__placeentrysignals_free (Unity_PlaceEntrySignals* self) {
	g_free (self);
}


GType unity__placeentrysignals_get_type (void) {
	static volatile gsize unity__placeentrysignals_type_id__volatile = 0;
	if (g_once_init_enter (&unity__placeentrysignals_type_id__volatile)) {
		GType unity__placeentrysignals_type_id;
		unity__placeentrysignals_type_id = g_boxed_type_register_static ("Unity_PlaceEntrySignals", (GBoxedCopyFunc) unity__placeentrysignals_dup, (GBoxedFreeFunc) unity__placeentrysignals_free);
		g_once_init_leave (&unity__placeentrysignals_type_id__volatile, unity__placeentrysignals_type_id);
	}
	return unity__placeentrysignals_type_id__volatile;
}


UnityPlaceController* unity_place_controller_construct (GType object_type, const gchar* dbus_path) {
	UnityPlaceController * self = NULL;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	self = (UnityPlaceController*) g_object_new (object_type, "dbus-path", dbus_path, NULL);
	return self;
}


UnityPlaceController* unity_place_controller_new (const gchar* dbus_path) {
	return unity_place_controller_construct (UNITY_TYPE_PLACE_CONTROLLER, dbus_path);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->entry);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _unity_place_controller_on_entry_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_place_controller_on_entry_changed (self, _sender, pspec);
}


static void _lambda0_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_) {
	UnityPlaceController * self;
	GObject* _tmp0_;
	UnityPlaceRendererInfo* _tmp1_;
	UnityPlaceRendererInfo* renderer_info;
	const gchar* _tmp2_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp3_ = NULL;
	UnityPlaceEntryServiceImpl* entry_service;
	self = _data1_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_PLACE_RENDERER_INFO (_tmp0_) ? ((UnityPlaceRendererInfo*) _tmp0_) : NULL);
	renderer_info = _tmp1_;
	_tmp2_ = unity_place_entry_info_get_dbus_path (_data1_->entry);
	_tmp3_ = unity_place_service_impl_get_entry_service (self->priv->service, _tmp2_);
	entry_service = _tmp3_;
	if (entry_service == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = unity_place_entry_info_get_dbus_path (_data1_->entry);
		g_warning ("unity-place.vala:1037: PlaceEntry renderer info changed for unknown en" \
"try '%s'", _tmp4_);
	} else {
		Unity_PlaceRendererInfo _tmp5_ = {0};
		Unity_PlaceRendererInfo _tmp6_ = {0};
		Unity_PlaceRendererInfo _tmp7_;
		unity_place_renderer_info_get_raw (renderer_info, &_tmp5_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		g_signal_emit_by_name ((UnityPlaceEntryService*) entry_service, "entry-renderer-info-changed", &_tmp7_);
		unity__placerendererinfo_destroy (&_tmp7_);
	}
	_g_object_unref0 (entry_service);
	_g_object_unref0 (renderer_info);
}


static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda0_ (_sender, pspec, self);
}


static void _lambda1_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_) {
	UnityPlaceController * self;
	GObject* _tmp0_;
	UnityPlaceRendererInfo* _tmp1_;
	UnityPlaceRendererInfo* renderer_info;
	const gchar* _tmp2_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp3_ = NULL;
	UnityPlaceEntryServiceImpl* entry_service;
	self = _data1_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_PLACE_RENDERER_INFO (_tmp0_) ? ((UnityPlaceRendererInfo*) _tmp0_) : NULL);
	renderer_info = _tmp1_;
	_tmp2_ = unity_place_entry_info_get_dbus_path (_data1_->entry);
	_tmp3_ = unity_place_service_impl_get_entry_service (self->priv->service, _tmp2_);
	entry_service = _tmp3_;
	if (entry_service == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = unity_place_entry_info_get_dbus_path (_data1_->entry);
		g_warning ("unity-place.vala:1053: Global renderer info changed for unknown entry " \
"'%s'", _tmp4_);
	} else {
		Unity_PlaceRendererInfo _tmp5_ = {0};
		Unity_PlaceRendererInfo _tmp6_ = {0};
		Unity_PlaceRendererInfo _tmp7_;
		unity_place_renderer_info_get_raw (renderer_info, &_tmp5_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		g_signal_emit_by_name ((UnityPlaceEntryService*) entry_service, "global-renderer-info-changed", &_tmp7_);
		unity__placerendererinfo_destroy (&_tmp7_);
	}
	_g_object_unref0 (entry_service);
	_g_object_unref0 (renderer_info);
}


static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda1_ (_sender, pspec, self);
}


static gpointer _unity__placeentrysignals_dup0 (gpointer self) {
	return self ? unity__placeentrysignals_dup (self) : NULL;
}


void unity_place_controller_add_entry (UnityPlaceController* self, UnityPlaceEntryInfo* entry) {
	Block1Data* _data1_;
	Unity_PlaceEntrySignals signals = {0};
	gulong _tmp0_;
	UnityPlaceRendererInfo* _tmp1_ = NULL;
	gulong _tmp2_;
	UnityPlaceRendererInfo* _tmp3_ = NULL;
	gulong _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	Unity_PlaceEntrySignals* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->entry = _g_object_ref0 (entry);
	unity_place_service_impl_add_entry (self->priv->service, _data1_->entry);
	memset (&signals, 0, sizeof (Unity_PlaceEntrySignals));
	_tmp0_ = g_signal_connect_object ((GObject*) _data1_->entry, "notify", (GCallback) _unity_place_controller_on_entry_changed_g_object_notify, self, 0);
	signals.place_entry_info_changed_id = _tmp0_;
	_tmp1_ = unity_place_entry_info_get_entry_renderer_info (_data1_->entry);
	_tmp2_ = g_signal_connect_data ((GObject*) _tmp1_, "notify", (GCallback) __lambda0__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	signals.entry_renderer_info_changed_id = _tmp2_;
	_tmp3_ = unity_place_entry_info_get_global_renderer_info (_data1_->entry);
	_tmp4_ = g_signal_connect_data ((GObject*) _tmp3_, "notify", (GCallback) __lambda1__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	signals.global_renderer_info_changed_id = _tmp4_;
	_tmp5_ = unity_place_entry_info_get_dbus_path (_data1_->entry);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _unity__placeentrysignals_dup0 (&signals);
	g_hash_table_insert (self->priv->entry_signals, _tmp6_, _tmp7_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


UnityPlaceEntryInfo* unity_place_controller_get_entry (UnityPlaceController* self, const gchar* dbus_path) {
	UnityPlaceEntryInfo* result = NULL;
	UnityPlaceEntryInfo* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	_tmp0_ = unity_place_service_impl_get_entry (self->priv->service, dbus_path);
	result = _tmp0_;
	return result;
}


void unity_place_controller_remove_entry (UnityPlaceController* self, const gchar* dbus_path) {
	gconstpointer _tmp0_ = NULL;
	Unity_PlaceEntrySignals* _tmp1_;
	Unity_PlaceEntrySignals* signals;
	UnityPlaceEntryInfo* _tmp2_ = NULL;
	UnityPlaceEntryInfo* entry;
	UnityPlaceRendererInfo* _tmp3_ = NULL;
	UnityPlaceRendererInfo* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_path != NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->entry_signals, dbus_path);
	_tmp1_ = _unity__placeentrysignals_dup0 ((Unity_PlaceEntrySignals*) _tmp0_);
	signals = _tmp1_;
	if (signals == NULL) {
		g_warning ("unity-place.vala:1077: No signals connected for unknown entry '%s'", dbus_path);
		unity_place_service_impl_remove_entry (self->priv->service, dbus_path);
		_unity__placeentrysignals_free0 (signals);
		return;
	}
	_tmp2_ = unity_place_service_impl_get_entry (self->priv->service, dbus_path);
	entry = _tmp2_;
	if (entry == NULL) {
		g_warning ("unity-place.vala:1086: Can not disconnect signals for unknown entry '%" \
"s'", dbus_path);
		g_hash_table_remove (self->priv->entry_signals, dbus_path);
		_g_object_unref0 (entry);
		_unity__placeentrysignals_free0 (signals);
		return;
	}
	g_signal_handler_disconnect ((GObject*) entry, (*signals).place_entry_info_changed_id);
	_tmp3_ = unity_place_entry_info_get_entry_renderer_info (entry);
	g_signal_handler_disconnect ((GObject*) _tmp3_, (*signals).entry_renderer_info_changed_id);
	_tmp4_ = unity_place_entry_info_get_global_renderer_info (entry);
	g_signal_handler_disconnect ((GObject*) _tmp4_, (*signals).global_renderer_info_changed_id);
	unity_place_service_impl_remove_entry (self->priv->service, dbus_path);
	_g_object_unref0 (entry);
	_unity__placeentrysignals_free0 (signals);
}


guint unity_place_controller_num_entries (UnityPlaceController* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = unity_place_service_impl_num_entries (self->priv->service);
	result = _tmp0_;
	return result;
}


gchar** unity_place_controller_get_entry_paths (UnityPlaceController* self, int* result_length1) {
	gchar** result = NULL;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = unity_place_service_impl_get_entry_paths (self->priv->service, &_tmp0_);
	_tmp2_ = _tmp1_;
	*result_length1 = _tmp0_;
	result = _tmp2_;
	return result;
}


UnityPlaceEntryInfo** unity_place_controller_get_entries (UnityPlaceController* self, int* result_length1) {
	UnityPlaceEntryInfo** result = NULL;
	guint _tmp0_;
	guint len;
	UnityPlaceEntryInfo** _tmp1_ = NULL;
	UnityPlaceEntryInfo** _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** entry_paths;
	gint entry_paths_length1;
	gint _entry_paths_size_;
	gint i;
	UnityPlaceEntryInfo** _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_place_controller_num_entries (self);
	len = _tmp0_;
	_tmp1_ = g_new0 (UnityPlaceEntryInfo*, len + 1);
	_result_ = _tmp1_;
	_result__length1 = len;
	__result__size_ = len;
	_tmp3_ = unity_place_controller_get_entry_paths (self, &_tmp2_);
	entry_paths = _tmp3_;
	entry_paths_length1 = _tmp2_;
	_entry_paths_size_ = _tmp2_;
	i = 0;
	{
		gboolean _tmp4_;
		i = 0;
		_tmp4_ = TRUE;
		while (TRUE) {
			UnityPlaceEntryInfo* _tmp5_ = NULL;
			UnityPlaceEntryInfo* _tmp6_;
			if (!_tmp4_) {
				i++;
			}
			_tmp4_ = FALSE;
			if (!(i < len)) {
				break;
			}
			_tmp5_ = unity_place_controller_get_entry (self, entry_paths[i]);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_result_[i]);
			_result_[i] = _tmp6_;
		}
	}
	_tmp7_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp7_;
	entry_paths = (_vala_array_free (entry_paths, entry_paths_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void unity_place_controller_export (UnityPlaceController* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	unity_place_service_impl_export (self->priv->service, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_exported = TRUE;
	g_object_notify ((GObject*) self, "exported");
}


void unity_place_controller_unexport (UnityPlaceController* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	unity_place_service_impl_unexport (self->priv->service, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_exported = FALSE;
	g_object_notify ((GObject*) self, "exported");
}


static void unity_place_controller_on_entry_changed (UnityPlaceController* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityPlaceEntryInfo* _tmp1_;
	UnityPlaceEntryInfo* entry;
	const gchar* _tmp2_ = NULL;
	UnityPlaceEntryServiceImpl* _tmp3_ = NULL;
	UnityPlaceEntryServiceImpl* entry_service;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_PLACE_ENTRY_INFO (_tmp0_) ? ((UnityPlaceEntryInfo*) _tmp0_) : NULL);
	entry = _tmp1_;
	_tmp2_ = unity_place_entry_info_get_dbus_path (entry);
	_tmp3_ = unity_place_service_impl_get_entry_service (self->priv->service, _tmp2_);
	entry_service = _tmp3_;
	if (entry_service == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = unity_place_entry_info_get_dbus_path (entry);
		g_warning ("unity-place.vala:1148: Got change signal from unknown entry service '%" \
"s'", _tmp4_);
		_g_object_unref0 (entry_service);
		_g_object_unref0 (entry);
		return;
	}
	_tmp5_ = g_param_spec_get_name (pspec);
	_tmp6_ = gee_collection_contains ((GeeCollection*) self->priv->ignore_remote_notify_props, _tmp5_);
	if (_tmp6_) {
		_g_object_unref0 (entry_service);
		_g_object_unref0 (entry);
		return;
	}
	unity_place_entry_service_impl_queue_place_entry_info_changed_signal (entry_service);
	_g_object_unref0 (entry_service);
	_g_object_unref0 (entry);
}


const gchar* unity_place_controller_get_dbus_path (UnityPlaceController* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_place_controller_set_dbus_path (UnityPlaceController* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


gboolean unity_place_controller_get_exported (UnityPlaceController* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exported;
	return result;
}


UnityActivation* unity_place_controller_get_activation (UnityPlaceController* self) {
	UnityActivation* result;
	UnityActivation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_place_service_impl_get_activation (self->priv->service);
	result = _tmp0_;
	return result;
}


void unity_place_controller_set_activation (UnityPlaceController* self, UnityActivation* value) {
	g_return_if_fail (self != NULL);
	unity_place_service_impl_set_activation (self->priv->service, value);
	g_object_notify ((GObject *) self, "activation");
}


static void _unity__placeentrysignals_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (unity__placeentrysignals_free (var), NULL));
}


static GObject * unity_place_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlaceController * self;
	UnityPlaceServiceImpl* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_place_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACE_CONTROLLER (obj);
	_tmp0_ = unity_place_service_impl_new (self->priv->_dbus_path);
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp0_;
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _unity__placeentrysignals_free0_);
	_g_hash_table_unref0 (self->priv->entry_signals);
	self->priv->entry_signals = _tmp1_;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->ignore_remote_notify_props);
	self->priv->ignore_remote_notify_props = (GeeSet*) _tmp2_;
	gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active-search");
	gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active-global-search");
	gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active");
	gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active-section");
	return obj;
}


static void unity_place_controller_class_init (UnityPlaceControllerClass * klass) {
	unity_place_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_place_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_place_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_place_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_place_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_CONTROLLER_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_CONTROLLER_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_CONTROLLER_ACTIVATION, g_param_spec_object ("activation", "activation", "activation", UNITY_TYPE_ACTIVATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_controller_instance_init (UnityPlaceController * self) {
	self->priv = UNITY_PLACE_CONTROLLER_GET_PRIVATE (self);
	self->priv->_exported = FALSE;
}


static void unity_place_controller_finalize (GObject* obj) {
	UnityPlaceController * self;
	self = UNITY_PLACE_CONTROLLER (obj);
	_g_object_unref0 (self->priv->service);
	_g_free0 (self->priv->_dbus_path);
	_g_hash_table_unref0 (self->priv->entry_signals);
	_g_object_unref0 (self->priv->ignore_remote_notify_props);
	G_OBJECT_CLASS (unity_place_controller_parent_class)->finalize (obj);
}


/**
   * UnityPlaceController:
   *
   * Main handle for controlling the place entries managed by a place daemon
   */
GType unity_place_controller_get_type (void) {
	static volatile gsize unity_place_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceController), 0, (GInstanceInitFunc) unity_place_controller_instance_init, NULL };
		GType unity_place_controller_type_id;
		unity_place_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceController", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_controller_type_id__volatile, unity_place_controller_type_id);
	}
	return unity_place_controller_type_id__volatile;
}


static void _vala_unity_place_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceController * self;
	self = UNITY_PLACE_CONTROLLER (object);
	switch (property_id) {
		case UNITY_PLACE_CONTROLLER_DBUS_PATH:
		g_value_set_string (value, unity_place_controller_get_dbus_path (self));
		break;
		case UNITY_PLACE_CONTROLLER_EXPORTED:
		g_value_set_boolean (value, unity_place_controller_get_exported (self));
		break;
		case UNITY_PLACE_CONTROLLER_ACTIVATION:
		g_value_set_object (value, unity_place_controller_get_activation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_place_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceController * self;
	self = UNITY_PLACE_CONTROLLER (object);
	switch (property_id) {
		case UNITY_PLACE_CONTROLLER_DBUS_PATH:
		unity_place_controller_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_CONTROLLER_ACTIVATION:
		unity_place_controller_set_activation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



