/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Dee;

namespace Unity {

/* Encapsulates information about a search from Unity.
 * A bit sparse at the moment with information, but in the future will encapsulate
 * hint information too
 */
public class LensSearch : InitiallyUnowned
{
  public string search_string { get; construct; }
  public HashTable<string, Variant> hints { get; construct; }

  public signal void finished ();

  public LensSearch (string search_string, HashTable<string, Variant> hints)
  {
    Object (search_string:search_string, hints:hints);
  }

  public bool equals (LensSearch? other)
  {
    if (other == null ||
        search_string != other.search_string)
      return false;

    return true;
  }
}

} /* namespace */
