/* unity-scope-private.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-scope-private.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include "unity.h"
#include <time.h>


#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_SCOPE_IMPL (unity_scope_impl_get_type ())
#define UNITY_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImpl))
#define UNITY_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))
#define UNITY_IS_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_IS_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_SCOPE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))

typedef struct _UnityScopeImpl UnityScopeImpl;
typedef struct _UnityScopeImplClass UnityScopeImplClass;
typedef struct _UnityScopeImplPrivate UnityScopeImplPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_TYPE_SCOPE_INFO (unity_scope_info_get_type ())
typedef struct _UnityScopeInfo UnityScopeInfo;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_FILTER_COLUMN (unity_filter_column_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeImplInfoRequestData UnityScopeImplInfoRequestData;
typedef struct _UnityScopeImplActivateData UnityScopeImplActivateData;
typedef struct _Block2Data Block2Data;
typedef struct _UnityScopeImplSearchData UnityScopeImplSearchData;
typedef struct _Block3Data Block3Data;
typedef struct _UnityScopeImplGlobalSearchData UnityScopeImplGlobalSearchData;
typedef struct _UnityScopeImplPreviewData UnityScopeImplPreviewData;
typedef struct _UnityScopeImplSetActiveData UnityScopeImplSetActiveData;
typedef struct _UnityScopeImplSetActiveSourcesData UnityScopeImplSetActiveSourcesData;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_active) (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityScopeImpl {
	GObject parent_instance;
	UnityScopeImplPrivate * priv;
	DeeSharedModel* _results_model;
	DeeSharedModel* _global_results_model;
	DeeSharedModel* _filters_model;
};

struct _UnityScopeImplClass {
	GObjectClass parent_class;
};

struct _UnityScopeImplPrivate {
	UnityScope* _owner;
	guint _dbus_id;
	guint _info_changed_id;
	guint _filters_changed_id;
};

struct _UnityScopeInfo {
	gchar* dbus_path;
	gchar** sources;
	gint sources_length1;
	gint _sources_size_;
	gboolean search_in_global;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

typedef enum  {
	UNITY_FILTER_COLUMN_ID = 0,
	UNITY_FILTER_COLUMN_NAME,
	UNITY_FILTER_COLUMN_ICON_HINT,
	UNITY_FILTER_COLUMN_RENDERER_NAME,
	UNITY_FILTER_COLUMN_RENDERER_STATE,
	UNITY_FILTER_COLUMN_VISIBLE,
	UNITY_FILTER_COLUMN_COLLAPSED,
	UNITY_FILTER_COLUMN_FILTERING
} UnityFilterColumn;

struct _UnityScopeImplInfoRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
};

struct _UnityScopeImplActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	UnityActivationReplyRaw reply;
	UnityActivationResponse* _tmp0_;
	UnityActivationResponse* _tmp1_;
	UnityActivationResponse* response;
	UnityActivationResponse* _tmp2_;
	gchar* _tmp3_;
	UnityHandledType _tmp4_;
	GHashTable* _tmp5_;
};

struct _Block2Data {
	int _ref_count_;
	UnityScopeImpl * self;
	UnityLensSearch* s;
	gpointer _async_data_;
};

struct _UnityScopeImplSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* search_string;
	GHashTable* hints;
	Block2Data* _data2_;
	UnityLensSearch* _tmp0_;
	UnityLensSearch* _tmp1_;
	gboolean _tmp2_;
};

struct _Block3Data {
	int _ref_count_;
	UnityScopeImpl * self;
	UnityLensSearch* s;
	gpointer _async_data_;
};

struct _UnityScopeImplGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* search_string;
	GHashTable* hints;
	Block3Data* _data3_;
	UnityLensSearch* _tmp0_;
	UnityLensSearch* _tmp1_;
	gboolean _tmp2_;
};

struct _UnityScopeImplPreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	UnityPreviewReplyRaw reply;
	UnityPreview* _tmp0_;
	UnityPreview* _tmp1_;
	UnityPreview* response;
	UnityNoPreview* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GHashTable* _tmp5_;
};

struct _UnityScopeImplSetActiveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gboolean is_active;
};

struct _UnityScopeImplSetActiveSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar** sources;
	gint sources_length1;
	gchar** s_collection;
	int s_collection_length1;
	int s_it;
	gchar* _tmp0_;
	gchar* s;
};


static gpointer unity_scope_impl_parent_class = NULL;
static UnityScopeServiceIface* unity_scope_impl_unity_scope_service_parent_iface = NULL;

GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
GType unity_scope_impl_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplPrivate))
enum  {
	UNITY_SCOPE_IMPL_DUMMY_PROPERTY
};
UnityScopeImpl* unity_scope_impl_new (UnityScope* owner);
UnityScopeImpl* unity_scope_impl_construct (GType object_type, UnityScope* owner);
static void unity_scope_impl_queue_info_changed (UnityScopeImpl* self);
static void _unity_scope_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_scope_impl_create_models (UnityScopeImpl* self, const gchar* dbus_name);
static gchar* unity_scope_impl_create_dbus_name (UnityScopeImpl* self);
static void unity_scope_impl_on_filter_added (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter);
static void _unity_scope_impl_on_filter_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_scope_impl_on_filter_changed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter);
static void _unity_scope_impl_on_filter_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_scope_impl_on_filter_removed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter);
static void _unity_scope_impl_on_filter_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
void unity_scope_impl_export (UnityScopeImpl* self, GError** error);
static gboolean unity_scope_impl_emit_info_changed (UnityScopeImpl* self);
static gboolean _unity_scope_impl_emit_info_changed_gsource_func (gpointer self);
static void unity_scope_impl_queue_filters_changed (UnityScopeImpl* self);
static gboolean unity_scope_impl_emit_filters_changed (UnityScopeImpl* self);
static gboolean _unity_scope_impl_emit_filters_changed_gsource_func (gpointer self);
GType unity_scope_info_get_type (void) G_GNUC_CONST;
UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self);
void unity_scope_info_free (UnityScopeInfo* self);
void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest);
void unity_scope_info_destroy (UnityScopeInfo* self);
static gchar** _vala_array_dup6 (gchar** self, int length);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GType unity_filter_column_get_type (void) G_GNUC_CONST;
void unity_filter_set_model_and_iter (UnityFilter* self, DeeModel* model, DeeModelIter* iter);
static void unity_scope_impl_real_info_request_data_free (gpointer _data);
static void unity_scope_impl_real_info_request (UnityScopeService* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_info_request_co (UnityScopeImplInfoRequestData* data);
static void unity_scope_impl_real_activate_data_free (gpointer _data);
static void unity_scope_impl_real_activate (UnityScopeService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_activate_co (UnityScopeImplActivateData* data);
GHashTable* unity_activation_response_get_hints (UnityActivationResponse* self);
static void unity_scope_impl_real_search_data_free (gpointer _data);
static void unity_scope_impl_real_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_search_co (UnityScopeImplSearchData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda1_ (Block2Data* _data2_);
static void __lambda1__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self);
static void unity_scope_impl_real_global_search_data_free (gpointer _data);
static void unity_scope_impl_real_global_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_global_search_co (UnityScopeImplGlobalSearchData* data);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda2_ (Block3Data* _data3_);
static void __lambda2__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self);
static void unity_scope_impl_real_preview_data_free (gpointer _data);
static void unity_scope_impl_real_preview (UnityScopeService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_preview_co (UnityScopeImplPreviewData* data);
gchar* unity_preview_get_renderer_name (UnityPreview* self);
GHashTable* unity_preview_get_properties (UnityPreview* self);
static void unity_scope_impl_real_set_active_data_free (gpointer _data);
static void unity_scope_impl_real_set_active (UnityScopeService* base, gboolean is_active, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_set_active_co (UnityScopeImplSetActiveData* data);
void unity_scope_set_active_internal (UnityScope* self, gboolean is_active);
static void unity_scope_impl_real_set_active_sources_data_free (gpointer _data);
static void unity_scope_impl_real_set_active_sources (UnityScopeService* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gboolean unity_scope_impl_real_set_active_sources_co (UnityScopeImplSetActiveSourcesData* data);
void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1);
static void unity_scope_impl_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_scope_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_scope_impl_queue_info_changed (self);
}


UnityScopeImpl* unity_scope_impl_construct (GType object_type, UnityScope* owner) {
	UnityScopeImpl * self = NULL;
	UnityScope* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (owner != NULL, NULL);
	self = (UnityScopeImpl*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->priv->_owner);
	self->priv->_owner = _tmp0_;
	g_signal_connect_object ((GObject*) self->priv->_owner, "notify::search-in-global", (GCallback) _unity_scope_impl_queue_info_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_owner, "notify::visible", (GCallback) _unity_scope_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp1_ = unity_scope_impl_create_dbus_name (self);
	_tmp2_ = _tmp1_;
	unity_scope_impl_create_models (self, _tmp2_);
	_g_free0 (_tmp2_);
	return self;
}


UnityScopeImpl* unity_scope_impl_new (UnityScope* owner) {
	return unity_scope_impl_construct (UNITY_TYPE_SCOPE_IMPL, owner);
}


static gchar* unity_scope_impl_create_dbus_name (UnityScopeImpl* self) {
	gchar* result = NULL;
	time_t _tmp0_;
	guint t;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* dbus_path;
	gchar* _tmp3_;
	gchar* dbus_name;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = time (NULL);
	t = (guint) _tmp0_;
	_tmp1_ = unity_scope_get_dbus_path (self->priv->_owner);
	_tmp2_ = g_strdup (_tmp1_);
	dbus_path = _tmp2_;
	_tmp3_ = g_strdup ("com.canonical.Unity.Scope");
	dbus_name = _tmp3_;
	_tmp4_ = g_path_get_basename (dbus_path);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (".", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (dbus_name, _tmp7_, NULL);
	_g_free0 (dbus_name);
	dbus_name = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp9_ = g_strdup_printf (".T%u", t);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (dbus_name, _tmp10_, NULL);
	_g_free0 (dbus_name);
	dbus_name = _tmp11_;
	_g_free0 (_tmp10_);
	result = dbus_name;
	_g_free0 (dbus_path);
	return result;
}


static void _unity_scope_impl_on_filter_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_scope_impl_on_filter_added (self, _sender, iter);
}


static void _unity_scope_impl_on_filter_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_scope_impl_on_filter_changed (self, _sender, iter);
}


static void _unity_scope_impl_on_filter_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_scope_impl_on_filter_removed (self, _sender, iter);
}


static void unity_scope_impl_create_models (UnityScopeImpl* self, const gchar* dbus_name) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	DeeSharedModel* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	DeeSharedModel* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	DeeSharedModel* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_name != NULL);
	_tmp0_ = g_strconcat (dbus_name, ".Results", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = (DeeSharedModel*) dee_shared_model_new (_tmp1_);
	_g_object_unref0 (self->_results_model);
	self->_results_model = _tmp2_;
	_g_free0 (_tmp1_);
	dee_model_set_schema ((DeeModel*) self->_results_model, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp3_ = g_strconcat (dbus_name, ".GlobalResults", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = (DeeSharedModel*) dee_shared_model_new (_tmp4_);
	_g_object_unref0 (self->_global_results_model);
	self->_global_results_model = _tmp5_;
	_g_free0 (_tmp4_);
	dee_model_set_schema ((DeeModel*) self->_global_results_model, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp6_ = g_strconcat (dbus_name, ".Filters", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = (DeeSharedModel*) dee_shared_model_new (_tmp7_);
	_g_object_unref0 (self->_filters_model);
	self->_filters_model = _tmp8_;
	_g_free0 (_tmp7_);
	dee_model_set_schema ((DeeModel*) self->_filters_model, "s", "s", "s", "s", "a{sv}", "b", "b", "b", NULL);
	g_signal_connect_object ((DeeModel*) self->_filters_model, "row-added", (GCallback) _unity_scope_impl_on_filter_added_dee_model_row_added, self, 0);
	g_signal_connect_object ((DeeModel*) self->_filters_model, "row-changed", (GCallback) _unity_scope_impl_on_filter_changed_dee_model_row_changed, self, 0);
	g_signal_connect_object ((DeeModel*) self->_filters_model, "row-removed", (GCallback) _unity_scope_impl_on_filter_removed_dee_model_row_removed, self, 0);
}


void unity_scope_impl_export (UnityScopeImpl* self, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* conn;
	const gchar* _tmp1_ = NULL;
	UnityScopeImpl* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = unity_scope_get_dbus_path (self->priv->_owner);
	_tmp2_ = self;
	_tmp3_ = unity_scope_service_register_object (UNITY_IS_SCOPE_SERVICE (_tmp2_) ? ((UnityScopeService*) _tmp2_) : NULL, conn, _tmp1_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_dbus_id = _tmp4_;
	unity_scope_impl_queue_info_changed (self);
	_g_object_unref0 (conn);
}


static gboolean _unity_scope_impl_emit_info_changed_gsource_func (gpointer self) {
	gboolean result;
	result = unity_scope_impl_emit_info_changed (self);
	return result;
}


static void unity_scope_impl_queue_info_changed (UnityScopeImpl* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_info_changed_id == 0) {
		guint _tmp0_;
		_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_scope_impl_emit_info_changed_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_info_changed_id = _tmp0_;
	}
}


static gboolean _unity_scope_impl_emit_filters_changed_gsource_func (gpointer self) {
	gboolean result;
	result = unity_scope_impl_emit_filters_changed (self);
	return result;
}


static void unity_scope_impl_queue_filters_changed (UnityScopeImpl* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_filters_changed_id == 0) {
		guint _tmp0_;
		_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, _unity_scope_impl_emit_filters_changed_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_filters_changed_id = _tmp0_;
	}
}


static gboolean unity_scope_impl_emit_filters_changed (UnityScopeImpl* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self->priv->_owner, "filters-changed");
	self->priv->_filters_changed_id = (guint) 0;
	result = FALSE;
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_scope_impl_emit_info_changed (UnityScopeImpl* self) {
	gboolean result = FALSE;
	UnityScopeInfo info = {0};
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gint _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GHashTable* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&info, 0, sizeof (UnityScopeInfo));
	_tmp0_ = unity_scope_get_dbus_path (self->priv->_owner);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (info.dbus_path);
	info.dbus_path = _tmp1_;
	_tmp2_ = unity_scope_get_sources (self->priv->_owner, &_tmp3_);
	_tmp4_ = (_tmp5_ = _tmp2_, (_tmp5_ == NULL) ? ((gpointer) _tmp5_) : _vala_array_dup6 (_tmp5_, _tmp3_));
	info.sources = (_vala_array_free (info.sources, info.sources_length1, (GDestroyNotify) g_free), NULL);
	info.sources = _tmp4_;
	info.sources_length1 = _tmp3_;
	info._sources_size_ = _tmp3_;
	_tmp6_ = unity_scope_get_search_in_global (self->priv->_owner);
	info.search_in_global = _tmp6_;
	_tmp7_ = g_strdup ("<not implemented>");
	_g_free0 (info.private_connection_name);
	info.private_connection_name = _tmp7_;
	_tmp8_ = dee_shared_model_get_swarm_name (self->_results_model);
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (info.results_model_name);
	info.results_model_name = _tmp9_;
	_tmp10_ = dee_shared_model_get_swarm_name (self->_global_results_model);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (info.global_results_model_name);
	info.global_results_model_name = _tmp11_;
	_tmp12_ = dee_shared_model_get_swarm_name (self->_filters_model);
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (info.filters_model_name);
	info.filters_model_name = _tmp13_;
	_tmp14_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (info.hints);
	info.hints = _tmp14_;
	g_signal_emit_by_name ((UnityScopeService*) self, "changed", &info);
	self->priv->_info_changed_id = (guint) 0;
	result = FALSE;
	unity_scope_info_destroy (&info);
	return result;
}


static void unity_scope_impl_on_filter_added (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* renderer_name;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* icon_hint_s;
	GIcon* icon_hint;
	UnityFilter* filter;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_RENDERER_NAME);
	_tmp1_ = g_strdup (_tmp0_);
	renderer_name = _tmp1_;
	_tmp2_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_ICON_HINT);
	_tmp3_ = g_strdup (_tmp2_);
	icon_hint_s = _tmp3_;
	icon_hint = NULL;
	if (g_strcmp0 (icon_hint_s, "") != 0) {
		GIcon* _tmp4_ = NULL;
		GIcon* _tmp5_;
		_tmp4_ = g_icon_new_for_string (icon_hint_s, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch23_g_error;
		}
		_g_object_unref0 (icon_hint);
		icon_hint = _tmp5_;
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-scope-private.vala:149: Error parsing GIcon data '%s': %s", icon_hint_s, e->message);
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (icon_hint);
		_g_free0 (icon_hint_s);
		_g_free0 (renderer_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	filter = NULL;
	if (g_strcmp0 (renderer_name, "filter-ratings") == 0) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		UnityRatingsFilter* _tmp8_ = NULL;
		_tmp6_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_ID);
		_tmp7_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_NAME);
		_tmp8_ = unity_ratings_filter_new (_tmp6_, _tmp7_, icon_hint, FALSE);
		_g_object_unref0 (filter);
		filter = (UnityFilter*) _tmp8_;
	} else {
		if (g_strcmp0 (renderer_name, "filter-radiooption") == 0) {
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			UnityRadioOptionFilter* _tmp11_ = NULL;
			_tmp9_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_ID);
			_tmp10_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_NAME);
			_tmp11_ = unity_radio_option_filter_new (_tmp9_, _tmp10_, icon_hint, FALSE);
			_g_object_unref0 (filter);
			filter = (UnityFilter*) _tmp11_;
		} else {
			if (g_strcmp0 (renderer_name, "filter-checkoption") == 0) {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				UnityCheckOptionFilter* _tmp14_ = NULL;
				_tmp12_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_ID);
				_tmp13_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_NAME);
				_tmp14_ = unity_check_option_filter_new (_tmp12_, _tmp13_, icon_hint, FALSE);
				_g_object_unref0 (filter);
				filter = (UnityFilter*) _tmp14_;
			} else {
				if (g_strcmp0 (renderer_name, "filter-multirange") == 0) {
					const gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					UnityMultiRangeFilter* _tmp17_ = NULL;
					_tmp15_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_ID);
					_tmp16_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_NAME);
					_tmp17_ = unity_multi_range_filter_new (_tmp15_, _tmp16_, icon_hint, FALSE);
					_g_object_unref0 (filter);
					filter = (UnityFilter*) _tmp17_;
				}
			}
		}
	}
	if (UNITY_IS_FILTER (filter)) {
		UnityFilter* _tmp18_;
		unity_filter_set_model_and_iter (filter, model, iter);
		_tmp18_ = _g_object_ref0 (filter);
		self->priv->_owner->_filters = g_list_append (self->priv->_owner->_filters, _tmp18_);
		unity_scope_impl_queue_filters_changed (self);
	}
	_g_object_unref0 (filter);
	_g_object_unref0 (icon_hint);
	_g_free0 (icon_hint_s);
	_g_free0 (renderer_name);
}


static void unity_scope_impl_on_filter_changed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	unity_scope_impl_queue_filters_changed (self);
}


static void unity_scope_impl_on_filter_removed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	{
		GList* filter_collection;
		GList* filter_it;
		filter_collection = self->priv->_owner->_filters;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* _tmp0_;
			UnityFilter* filter;
			_tmp0_ = _g_object_ref0 ((UnityFilter*) filter_it->data);
			filter = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				const gchar* _tmp2_ = NULL;
				_tmp1_ = unity_filter_get_id (filter);
				_tmp2_ = dee_model_get_string (model, iter, (guint) UNITY_FILTER_COLUMN_ID);
				if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
					self->priv->_owner->_filters = g_list_remove (self->priv->_owner->_filters, filter);
					_g_object_unref0 (filter);
					break;
				}
				_g_object_unref0 (filter);
			}
		}
	}
	unity_scope_impl_queue_filters_changed (self);
}


static void unity_scope_impl_real_info_request_data_free (gpointer _data) {
	UnityScopeImplInfoRequestData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplInfoRequestData, data);
}


static void unity_scope_impl_real_info_request (UnityScopeService* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplInfoRequestData* _data_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplInfoRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_info_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_info_request_data_free);
	_data_->self = _g_object_ref0 (self);
	unity_scope_impl_real_info_request_co (_data_);
}


static void unity_scope_impl_real_info_request_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplInfoRequestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_impl_real_info_request_co (UnityScopeImplInfoRequestData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_scope_impl_queue_info_changed (data->self);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_activate_data_free (gpointer _data) {
	UnityScopeImplActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	unity_activation_reply_raw_destroy (&data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplActivateData, data);
}


static void unity_scope_impl_real_activate (UnityScopeService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplActivateData* _data_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_activate_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	_data_->action_type = action_type;
	unity_scope_impl_real_activate_co (_data_);
}


static void unity_scope_impl_real_activate_finish (UnityScopeService* base, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UnityScopeImplActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static gboolean unity_scope_impl_real_activate_co (UnityScopeImplActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->reply, 0, sizeof (UnityActivationReplyRaw));
	data->_tmp0_ = NULL;
	g_signal_emit_by_name (data->self->priv->_owner, "activate-uri", data->uri, &data->_tmp0_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = data->_tmp0_;
	data->response = data->_tmp1_;
	if (data->response == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
		_g_object_unref0 (data->response);
		data->response = g_object_ref_sink (data->_tmp2_);
	}
	data->_tmp3_ = g_strdup (data->uri);
	_g_free0 (data->reply.uri);
	data->reply.uri = data->_tmp3_;
	data->_tmp4_ = unity_activation_response_get_handled (data->response);
	data->reply.handled = (guint) data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = unity_activation_response_get_hints (data->response);
	_g_hash_table_unref0 (data->reply.hints);
	data->reply.hints = data->_tmp5_;
	data->result = data->reply;
	_g_object_unref0 (data->response);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->response);
	unity_activation_reply_raw_destroy (&data->reply);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_search_data_free (gpointer _data) {
	UnityScopeImplSearchData* data;
	data = _data;
	_g_free0 (data->search_string);
	_g_hash_table_unref0 (data->hints);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplSearchData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void unity_scope_impl_real_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplSearchData* _data_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search_string = g_strdup (search_string);
	_data_->hints = _g_hash_table_ref0 (hints);
	unity_scope_impl_real_search_co (_data_);
}


static void unity_scope_impl_real_search_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->s);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda1_ (Block2Data* _data2_) {
	UnityScopeImpl * self;
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = _data2_->self;
	_tmp0_ = unity_lens_search_get_search_string (_data2_->s);
	_tmp1_ = unity_lens_search_get_hints (_data2_->s);
	g_signal_emit_by_name ((UnityScopeService*) self, "search-finished", _tmp0_, _tmp1_);
}


static void __lambda1__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self) {
	_lambda1_ (self);
}


static gboolean unity_scope_impl_real_search_co (UnityScopeImplSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->self = g_object_ref (data->self);
	data->_data2_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = unity_lens_search_new (data->search_string, data->hints);
	data->_data2_->s = g_object_ref_sink (data->_tmp0_);
	g_signal_connect_data (data->_data2_->s, "finished", (GCallback) __lambda1__unity_lens_search_finished, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
	data->_tmp1_ = NULL;
	data->_tmp1_ = unity_scope_get_active_search (data->self->priv->_owner);
	data->_tmp2_ = unity_lens_search_equals (data->_data2_->s, data->_tmp1_);
	if (!data->_tmp2_) {
		unity_scope_set_active_search (data->self->priv->_owner, data->_data2_->s);
	}
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_global_search_data_free (gpointer _data) {
	UnityScopeImplGlobalSearchData* data;
	data = _data;
	_g_free0 (data->search_string);
	_g_hash_table_unref0 (data->hints);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplGlobalSearchData, data);
}


static void unity_scope_impl_real_global_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplGlobalSearchData* _data_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_global_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search_string = g_strdup (search_string);
	_data_->hints = _g_hash_table_ref0 (hints);
	unity_scope_impl_real_global_search_co (_data_);
}


static void unity_scope_impl_real_global_search_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplGlobalSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->s);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda2_ (Block3Data* _data3_) {
	UnityScopeImpl * self;
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = _data3_->self;
	_tmp0_ = unity_lens_search_get_search_string (_data3_->s);
	_tmp1_ = unity_lens_search_get_hints (_data3_->s);
	g_signal_emit_by_name ((UnityScopeService*) self, "global-search-finished", _tmp0_, _tmp1_);
}


static void __lambda2__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self) {
	_lambda2_ (self);
}


static gboolean unity_scope_impl_real_global_search_co (UnityScopeImplGlobalSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = g_object_ref (data->self);
	data->_data3_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = unity_lens_search_new (data->search_string, data->hints);
	data->_data3_->s = g_object_ref_sink (data->_tmp0_);
	g_signal_connect_data (data->_data3_->s, "finished", (GCallback) __lambda2__unity_lens_search_finished, block3_data_ref (data->_data3_), (GClosureNotify) block3_data_unref, 0);
	data->_tmp1_ = NULL;
	data->_tmp1_ = unity_scope_get_active_global_search (data->self->priv->_owner);
	data->_tmp2_ = unity_lens_search_equals (data->_data3_->s, data->_tmp1_);
	if (!data->_tmp2_) {
		unity_scope_set_active_global_search (data->self->priv->_owner, data->_data3_->s);
	}
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_preview_data_free (gpointer _data) {
	UnityScopeImplPreviewData* data;
	data = _data;
	_g_free0 (data->uri);
	unity_preview_reply_raw_destroy (&data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplPreviewData, data);
}


static void unity_scope_impl_real_preview (UnityScopeService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplPreviewData* _data_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplPreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_preview_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	unity_scope_impl_real_preview_co (_data_);
}


static void unity_scope_impl_real_preview_finish (UnityScopeService* base, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UnityScopeImplPreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static gboolean unity_scope_impl_real_preview_co (UnityScopeImplPreviewData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->reply, 0, sizeof (UnityPreviewReplyRaw));
	data->_tmp0_ = NULL;
	g_signal_emit_by_name (data->self->priv->_owner, "preview-uri", data->uri, &data->_tmp0_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = data->_tmp0_;
	data->response = data->_tmp1_;
	if (data->response == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = unity_no_preview_new ();
		_g_object_unref0 (data->response);
		data->response = (UnityPreview*) g_object_ref_sink (data->_tmp2_);
	}
	data->_tmp3_ = g_strdup (data->uri);
	_g_free0 (data->reply.uri);
	data->reply.uri = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = unity_preview_get_renderer_name (data->response);
	_g_free0 (data->reply.renderer_name);
	data->reply.renderer_name = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = unity_preview_get_properties (data->response);
	_g_hash_table_unref0 (data->reply.properties);
	data->reply.properties = data->_tmp5_;
	data->result = data->reply;
	_g_object_unref0 (data->response);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->response);
	unity_preview_reply_raw_destroy (&data->reply);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_set_active_data_free (gpointer _data) {
	UnityScopeImplSetActiveData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplSetActiveData, data);
}


static void unity_scope_impl_real_set_active (UnityScopeService* base, gboolean is_active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplSetActiveData* _data_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplSetActiveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_set_active);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_set_active_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->is_active = is_active;
	unity_scope_impl_real_set_active_co (_data_);
}


static void unity_scope_impl_real_set_active_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplSetActiveData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_impl_real_set_active_co (UnityScopeImplSetActiveData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_scope_set_active_internal (data->self->priv->_owner, data->is_active);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_set_active_sources_data_free (gpointer _data) {
	UnityScopeImplSetActiveSourcesData* data;
	data = _data;
	data->sources = (_vala_array_free (data->sources, data->sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeImplSetActiveSourcesData, data);
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void unity_scope_impl_real_set_active_sources (UnityScopeService* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplSetActiveSourcesData* _data_;
	gchar** _tmp0_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplSetActiveSourcesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_set_active_sources);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_set_active_sources_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sources = (_tmp0_ = sources, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup7 (_tmp0_, sources_length1));
	_data_->sources_length1 = sources_length1;
	unity_scope_impl_real_set_active_sources_co (_data_);
}


static void unity_scope_impl_real_set_active_sources_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplSetActiveSourcesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_impl_real_set_active_sources_co (UnityScopeImplSetActiveSourcesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_scope_set_active_sources_internal (data->self->priv->_owner, data->sources, data->sources_length1);
	{
		data->s_collection = data->sources;
		data->s_collection_length1 = data->sources_length1;
		for (data->s_it = 0; data->s_it < data->sources_length1; data->s_it = data->s_it + 1) {
			data->_tmp0_ = g_strdup (data->s_collection[data->s_it]);
			data->s = data->_tmp0_;
			{
				g_debug ("unity-scope-private.vala:283: Source: %s", data->s);
				_g_free0 (data->s);
			}
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_impl_class_init (UnityScopeImplClass * klass) {
	unity_scope_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopeImplPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_scope_impl_finalize;
}


static void unity_scope_impl_unity_scope_service_interface_init (UnityScopeServiceIface * iface) {
	unity_scope_impl_unity_scope_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->info_request = (void (*)(UnityScopeService* ,GError**)) unity_scope_impl_real_info_request;
	iface->info_request_finish = unity_scope_impl_real_info_request_finish;
	iface->activate = (UnityActivationReplyRaw (*)(UnityScopeService* ,const gchar* ,guint ,UnityActivationReplyRaw* ,GError**)) unity_scope_impl_real_activate;
	iface->activate_finish = unity_scope_impl_real_activate_finish;
	iface->search = (void (*)(UnityScopeService* ,const gchar* ,GHashTable* ,GError**)) unity_scope_impl_real_search;
	iface->search_finish = unity_scope_impl_real_search_finish;
	iface->global_search = (void (*)(UnityScopeService* ,const gchar* ,GHashTable* ,GError**)) unity_scope_impl_real_global_search;
	iface->global_search_finish = unity_scope_impl_real_global_search_finish;
	iface->preview = (UnityPreviewReplyRaw (*)(UnityScopeService* ,const gchar* ,UnityPreviewReplyRaw* ,GError**)) unity_scope_impl_real_preview;
	iface->preview_finish = unity_scope_impl_real_preview_finish;
	iface->set_active = (void (*)(UnityScopeService* ,gboolean ,GError**)) unity_scope_impl_real_set_active;
	iface->set_active_finish = unity_scope_impl_real_set_active_finish;
	iface->set_active_sources = (void (*)(UnityScopeService* ,gchar** ,int ,GError**)) unity_scope_impl_real_set_active_sources;
	iface->set_active_sources_finish = unity_scope_impl_real_set_active_sources_finish;
}


static void unity_scope_impl_instance_init (UnityScopeImpl * self) {
	self->priv = UNITY_SCOPE_IMPL_GET_PRIVATE (self);
}


static void unity_scope_impl_finalize (GObject* obj) {
	UnityScopeImpl * self;
	self = UNITY_SCOPE_IMPL (obj);
	_g_object_unref0 (self->priv->_owner);
	_g_object_unref0 (self->_results_model);
	_g_object_unref0 (self->_global_results_model);
	_g_object_unref0 (self->_filters_model);
	G_OBJECT_CLASS (unity_scope_impl_parent_class)->finalize (obj);
}


GType unity_scope_impl_get_type (void) {
	static volatile gsize unity_scope_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScopeImpl), 0, (GInstanceInitFunc) unity_scope_impl_instance_init, NULL };
		static const GInterfaceInfo unity_scope_service_info = { (GInterfaceInitFunc) unity_scope_impl_unity_scope_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_scope_impl_type_id;
		unity_scope_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScopeImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_scope_impl_type_id, UNITY_TYPE_SCOPE_SERVICE, &unity_scope_service_info);
		g_once_init_leave (&unity_scope_impl_type_id__volatile, unity_scope_impl_type_id);
	}
	return unity_scope_impl_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



