.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealing in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtGet-Keysym-Table XtKeysym-To-Keycode-List wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtGetKeysymTable __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtGetKeysymTable, XtKeysymToKeycodeList \- query keysyms and keycodes
.SH SYNTAX
.HP
Keysym* XtGetKeysymTable(Display* \fIdisplay\fP, KeyCode*
\fImin_keycode_return\fP, int *\fIkeysyms_per_keycode_return\fP);
.HP
void XtKeysymToKeycodeList(Display* \fIdisplay\fP, KeySym \fIkeysym\fP,
KeyCode** \fIkeycodes_return\fP, Cardinal* \fIkeycount_return\fP);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the display whose table is required.
.LP
.IP \fImin_keycode_return\fP 1i
Returns the minimum KeyCode valid for the display.
.LP
.IP \fIkeysyms_per_keycode_return\fP
Returns the number of KeySyms stored for each KeyCode.
.LP
.IP \fIkeysym\fP 1i
Specifies the KeySym for which to search.
.LP
.IP \fIkeycodes_return\fP 1i
Returns a list of KeyCodes that have \fIkeysym\fP associated with them,
or NULL if \fIkeycount_return\fP is 0.
.LP
.IP \fIkeycount_return\fP 1i
Returns the number of KeyCodes in the keycode list.
.SH DESCRIPTION
.ZN XtGetKeysymTable
returns a pointer to the Intrinsics' copy of the server's KeyCode-to-KeySym
table. This table must not be modified.
.LP
The
.ZN XtKeysymToKeycodeList
procedure returns all the KeyCodes that have \fIkeysym\fP in their
entry for the keyboard mapping table associated with \fIdisplay\fP.
The caller should free the storage pointed to by \fIkeycodes_return\fP
using
.ZN XtFree
when it is no longer useful.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
