/*
 * Copyright (C) 2008-2009  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * Authors:
 *   Richard Li <RichardZ.Li@amd.com>, <richardradeon@gmail.com>
 *   CooperYuan <cooper.yuan@amd.com>, <cooperyuan@gmail.com>
 */

#ifndef _R700_CHIPOFFSET_H_
#define _R700_CHIPOFFSET_H_

#define mmWAIT_UNTIL                                    0x2010
#define mmSCRATCH_REG0                                  0x2140
#define mmGUI_SCRATCH_REG0                              0x2140
#define mmSCRATCH_REG1                                  0x2141
#define mmGUI_SCRATCH_REG1                              0x2141
#define mmSCRATCH_REG2                                  0x2142
#define mmGUI_SCRATCH_REG2                              0x2142
#define mmSCRATCH_REG3                                  0x2143
#define mmGUI_SCRATCH_REG3                              0x2143
#define mmSCRATCH_REG4                                  0x2144
#define mmGUI_SCRATCH_REG4                              0x2144
#define mmSCRATCH_REG5                                  0x2145
#define mmGUI_SCRATCH_REG5                              0x2145
#define mmSCRATCH_REG6                                  0x2146
#define mmGUI_SCRATCH_REG6                              0x2146
#define mmSCRATCH_REG7                                  0x2147
#define mmGUI_SCRATCH_REG7                              0x2147

#define mmCP_COHER_CNTL                                 0x217C
#define mmCP_COHER_SIZE                                 0x217D
#define mmCP_COHER_BASE                                 0x217E
#define mmCP_COHER_STATUS                               0x217F

#define mmTA_CNTL_AUX                                   0x2542
#define mmVC_ENHANCE                                    0x25C5
#define mmSQ_DYN_GPR_CNTL_PS_FLUSH_REQ                  0x2363
#define mmDB_DEBUG                                      0x260C
#define mmDB_WATERMARKS                                 0x260E

#define mmPA_CL_VPORT_XSCALE                            0xA10F
#define mmPA_CL_VPORT_XOFFSET                           0xA110
#define mmPA_CL_VPORT_YSCALE                            0xA111
#define mmPA_CL_VPORT_YOFFSET                           0xA112
#define mmPA_CL_VPORT_ZSCALE                            0xA113
#define mmPA_CL_VPORT_ZOFFSET                           0xA114
#define mmPA_CL_VPORT_XSCALE_1                          0xA115
#define mmPA_CL_VPORT_XSCALE_2                          0xA11B
#define mmPA_CL_VPORT_XSCALE_3                          0xA121
#define mmPA_CL_VPORT_XSCALE_4                          0xA127
#define mmPA_CL_VPORT_XSCALE_5                          0xA12D
#define mmPA_CL_VPORT_XSCALE_6                          0xA133
#define mmPA_CL_VPORT_XSCALE_7                          0xA139
#define mmPA_CL_VPORT_XSCALE_8                          0xA13F
#define mmPA_CL_VPORT_XSCALE_9                          0xA145
#define mmPA_CL_VPORT_XSCALE_10                         0xA14B
#define mmPA_CL_VPORT_XSCALE_11                         0xA151
#define mmPA_CL_VPORT_XSCALE_12                         0xA157
#define mmPA_CL_VPORT_XSCALE_13                         0xA15D
#define mmPA_CL_VPORT_XSCALE_14                         0xA163
#define mmPA_CL_VPORT_XSCALE_15                         0xA169
#define mmPA_CL_VPORT_XOFFSET_1                         0xA116
#define mmPA_CL_VPORT_XOFFSET_2                         0xA11C
#define mmPA_CL_VPORT_XOFFSET_3                         0xA122
#define mmPA_CL_VPORT_XOFFSET_4                         0xA128
#define mmPA_CL_VPORT_XOFFSET_5                         0xA12E
#define mmPA_CL_VPORT_XOFFSET_6                         0xA134
#define mmPA_CL_VPORT_XOFFSET_7                         0xA13A
#define mmPA_CL_VPORT_XOFFSET_8                         0xA140
#define mmPA_CL_VPORT_XOFFSET_9                         0xA146
#define mmPA_CL_VPORT_XOFFSET_10                        0xA14C
#define mmPA_CL_VPORT_XOFFSET_11                        0xA152
#define mmPA_CL_VPORT_XOFFSET_12                        0xA158
#define mmPA_CL_VPORT_XOFFSET_13                        0xA15E
#define mmPA_CL_VPORT_XOFFSET_14                        0xA164
#define mmPA_CL_VPORT_XOFFSET_15                        0xA16A
#define mmPA_CL_VPORT_YSCALE_1                          0xA117
#define mmPA_CL_VPORT_YSCALE_2                          0xA11D
#define mmPA_CL_VPORT_YSCALE_3                          0xA123
#define mmPA_CL_VPORT_YSCALE_4                          0xA129
#define mmPA_CL_VPORT_YSCALE_5                          0xA12F
#define mmPA_CL_VPORT_YSCALE_6                          0xA135
#define mmPA_CL_VPORT_YSCALE_7                          0xA13B
#define mmPA_CL_VPORT_YSCALE_8                          0xA141
#define mmPA_CL_VPORT_YSCALE_9                          0xA147
#define mmPA_CL_VPORT_YSCALE_10                         0xA14D
#define mmPA_CL_VPORT_YSCALE_11                         0xA153
#define mmPA_CL_VPORT_YSCALE_12                         0xA159
#define mmPA_CL_VPORT_YSCALE_13                         0xA15F
#define mmPA_CL_VPORT_YSCALE_14                         0xA165
#define mmPA_CL_VPORT_YSCALE_15                         0xA16B
#define mmPA_CL_VPORT_YOFFSET_1                         0xA118
#define mmPA_CL_VPORT_YOFFSET_2                         0xA11E
#define mmPA_CL_VPORT_YOFFSET_3                         0xA124
#define mmPA_CL_VPORT_YOFFSET_4                         0xA12A
#define mmPA_CL_VPORT_YOFFSET_5                         0xA130
#define mmPA_CL_VPORT_YOFFSET_6                         0xA136
#define mmPA_CL_VPORT_YOFFSET_7                         0xA13C
#define mmPA_CL_VPORT_YOFFSET_8                         0xA142
#define mmPA_CL_VPORT_YOFFSET_9                         0xA148
#define mmPA_CL_VPORT_YOFFSET_10                        0xA14E
#define mmPA_CL_VPORT_YOFFSET_11                        0xA154
#define mmPA_CL_VPORT_YOFFSET_12                        0xA15A
#define mmPA_CL_VPORT_YOFFSET_13                        0xA160
#define mmPA_CL_VPORT_YOFFSET_14                        0xA166
#define mmPA_CL_VPORT_YOFFSET_15                        0xA16C
#define mmPA_CL_VPORT_ZSCALE_1                          0xA119
#define mmPA_CL_VPORT_ZSCALE_2                          0xA11F
#define mmPA_CL_VPORT_ZSCALE_3                          0xA125
#define mmPA_CL_VPORT_ZSCALE_4                          0xA12B
#define mmPA_CL_VPORT_ZSCALE_5                          0xA131
#define mmPA_CL_VPORT_ZSCALE_6                          0xA137
#define mmPA_CL_VPORT_ZSCALE_7                          0xA13D
#define mmPA_CL_VPORT_ZSCALE_8                          0xA143
#define mmPA_CL_VPORT_ZSCALE_9                          0xA149
#define mmPA_CL_VPORT_ZSCALE_10                         0xA14F
#define mmPA_CL_VPORT_ZSCALE_11                         0xA155
#define mmPA_CL_VPORT_ZSCALE_12                         0xA15B
#define mmPA_CL_VPORT_ZSCALE_13                         0xA161
#define mmPA_CL_VPORT_ZSCALE_14                         0xA167
#define mmPA_CL_VPORT_ZSCALE_15                         0xA16D
#define mmPA_CL_VPORT_ZOFFSET_1                         0xA11A
#define mmPA_CL_VPORT_ZOFFSET_2                         0xA120
#define mmPA_CL_VPORT_ZOFFSET_3                         0xA126
#define mmPA_CL_VPORT_ZOFFSET_4                         0xA12C
#define mmPA_CL_VPORT_ZOFFSET_5                         0xA132
#define mmPA_CL_VPORT_ZOFFSET_6                         0xA138
#define mmPA_CL_VPORT_ZOFFSET_7                         0xA13E
#define mmPA_CL_VPORT_ZOFFSET_8                         0xA144
#define mmPA_CL_VPORT_ZOFFSET_9                         0xA14A
#define mmPA_CL_VPORT_ZOFFSET_10                        0xA150
#define mmPA_CL_VPORT_ZOFFSET_11                        0xA156
#define mmPA_CL_VPORT_ZOFFSET_12                        0xA15C
#define mmPA_CL_VPORT_ZOFFSET_13                        0xA162
#define mmPA_CL_VPORT_ZOFFSET_14                        0xA168
#define mmPA_CL_VPORT_ZOFFSET_15                        0xA16E
#define mmPA_CL_VTE_CNTL                                0xA206
#define mmPA_CL_VS_OUT_CNTL                             0xA207
#define mmPA_CL_NANINF_CNTL                             0xA208
#define mmPA_CL_CLIP_CNTL                               0xA204
#define mmPA_CL_GB_VERT_CLIP_ADJ                        0xA303
#define mmPA_CL_GB_VERT_DISC_ADJ                        0xA304
#define mmPA_CL_GB_HORZ_CLIP_ADJ                        0xA305
#define mmPA_CL_GB_HORZ_DISC_ADJ                        0xA306
#define mmPA_CL_UCP_0_X                                 0xA388
#define mmPA_CL_UCP_0_Y                                 0xA389
#define mmPA_CL_UCP_0_Z                                 0xA38A
#define mmPA_CL_UCP_0_W                                 0xA38B
#define mmPA_CL_UCP_1_X                                 0xA38C
#define mmPA_CL_UCP_1_Y                                 0xA38D
#define mmPA_CL_UCP_1_Z                                 0xA38E
#define mmPA_CL_UCP_1_W                                 0xA38F
#define mmPA_CL_UCP_2_X                                 0xA390
#define mmPA_CL_UCP_2_Y                                 0xA391
#define mmPA_CL_UCP_2_Z                                 0xA392
#define mmPA_CL_UCP_2_W                                 0xA393
#define mmPA_CL_UCP_3_X                                 0xA394
#define mmPA_CL_UCP_3_Y                                 0xA395
#define mmPA_CL_UCP_3_Z                                 0xA396
#define mmPA_CL_UCP_3_W                                 0xA397
#define mmPA_CL_UCP_4_X                                 0xA398
#define mmPA_CL_UCP_4_Y                                 0xA399
#define mmPA_CL_UCP_4_Z                                 0xA39A
#define mmPA_CL_UCP_4_W                                 0xA39B
#define mmPA_CL_UCP_5_X                                 0xA39C
#define mmPA_CL_UCP_5_Y                                 0xA39D
#define mmPA_CL_UCP_5_Z                                 0xA39E
#define mmPA_CL_UCP_5_W                                 0xA39F
#define mmPA_CL_POINT_X_RAD                             0xA384
#define mmPA_CL_POINT_Y_RAD                             0xA385
#define mmPA_CL_POINT_SIZE                              0xA386
#define mmPA_CL_POINT_CULL_RAD                          0xA387

#define mmPA_SU_VTX_CNTL                                0xA302
#define mmPA_SU_POINT_SIZE                              0xA280
#define mmPA_SU_POINT_MINMAX                            0xA281
#define mmPA_SU_LINE_CNTL                               0xA282
#define mmPA_SU_SC_MODE_CNTL                            0xA205
#define mmPA_SU_POLY_OFFSET_DB_FMT_CNTL                 0xA37E
#define mmPA_SU_POLY_OFFSET_CLAMP                       0xA37F
#define mmPA_SU_POLY_OFFSET_FRONT_SCALE                 0xA380
#define mmPA_SU_POLY_OFFSET_FRONT_OFFSET                0xA381
#define mmPA_SU_POLY_OFFSET_BACK_SCALE                  0xA382
#define mmPA_SU_POLY_OFFSET_BACK_OFFSET                 0xA383

#define mmPA_SC_WINDOW_OFFSET                           0xA080
#define mmPA_SC_AA_CONFIG                               0xA301
#define mmPA_SC_AA_MASK                                 0xA312
#define mmPA_SC_AA_SAMPLE_LOCS_MCTX                     0xA307
#define mmPA_SC_AA_SAMPLE_LOCS_8S_WD1_MCTX              0xA308
#define mmPA_SC_LINE_STIPPLE                            0xA283
#define mmPA_SC_LINE_CNTL                               0xA300
#define mmPA_SC_SCREEN_SCISSOR_TL                       0xA00C
#define mmPA_SC_SCREEN_SCISSOR_BR                       0xA00D
#define mmPA_SC_WINDOW_SCISSOR_TL                       0xA081
#define mmPA_SC_WINDOW_SCISSOR_BR                       0xA082
#define mmPA_SC_CLIPRECT_RULE                           0xA083
#define mmPA_SC_CLIPRECT_0_TL                           0xA084
#define mmPA_SC_CLIPRECT_0_BR                           0xA085
#define mmPA_SC_CLIPRECT_1_TL                           0xA086
#define mmPA_SC_CLIPRECT_1_BR                           0xA087
#define mmPA_SC_CLIPRECT_2_TL                           0xA088
#define mmPA_SC_CLIPRECT_2_BR                           0xA089
#define mmPA_SC_CLIPRECT_3_TL                           0xA08A
#define mmPA_SC_CLIPRECT_3_BR                           0xA08B
#define mmPA_SC_EDGERULE                                0xA08C
#define mmPA_SC_GENERIC_SCISSOR_TL                      0xA090
#define mmPA_SC_GENERIC_SCISSOR_BR                      0xA091
#define mmPA_SC_VPORT_SCISSOR_0_TL                      0xA094
#define mmPA_SC_VPORT_SCISSOR_1_TL                      0xA096
#define mmPA_SC_VPORT_SCISSOR_2_TL                      0xA098
#define mmPA_SC_VPORT_SCISSOR_3_TL                      0xA09A
#define mmPA_SC_VPORT_SCISSOR_4_TL                      0xA09C
#define mmPA_SC_VPORT_SCISSOR_5_TL                      0xA09E
#define mmPA_SC_VPORT_SCISSOR_6_TL                      0xA0A0
#define mmPA_SC_VPORT_SCISSOR_7_TL                      0xA0A2
#define mmPA_SC_VPORT_SCISSOR_8_TL                      0xA0A4
#define mmPA_SC_VPORT_SCISSOR_9_TL                      0xA0A6
#define mmPA_SC_VPORT_SCISSOR_10_TL                     0xA0A8
#define mmPA_SC_VPORT_SCISSOR_11_TL                     0xA0AA
#define mmPA_SC_VPORT_SCISSOR_12_TL                     0xA0AC
#define mmPA_SC_VPORT_SCISSOR_13_TL                     0xA0AE
#define mmPA_SC_VPORT_SCISSOR_14_TL                     0xA0B0
#define mmPA_SC_VPORT_SCISSOR_15_TL                     0xA0B2
#define mmPA_SC_VPORT_SCISSOR_0_BR                      0xA095
#define mmPA_SC_VPORT_SCISSOR_1_BR                      0xA097
#define mmPA_SC_VPORT_SCISSOR_2_BR                      0xA099
#define mmPA_SC_VPORT_SCISSOR_3_BR                      0xA09B
#define mmPA_SC_VPORT_SCISSOR_4_BR                      0xA09D
#define mmPA_SC_VPORT_SCISSOR_5_BR                      0xA09F
#define mmPA_SC_VPORT_SCISSOR_6_BR                      0xA0A1
#define mmPA_SC_VPORT_SCISSOR_7_BR                      0xA0A3
#define mmPA_SC_VPORT_SCISSOR_8_BR                      0xA0A5
#define mmPA_SC_VPORT_SCISSOR_9_BR                      0xA0A7
#define mmPA_SC_VPORT_SCISSOR_10_BR                     0xA0A9
#define mmPA_SC_VPORT_SCISSOR_11_BR                     0xA0AB
#define mmPA_SC_VPORT_SCISSOR_12_BR                     0xA0AD
#define mmPA_SC_VPORT_SCISSOR_13_BR                     0xA0AF
#define mmPA_SC_VPORT_SCISSOR_14_BR                     0xA0B1
#define mmPA_SC_VPORT_SCISSOR_15_BR                     0xA0B3
#define mmPA_SC_VPORT_ZMIN_0                            0xA0B4
#define mmPA_SC_VPORT_ZMIN_1                            0xA0B6
#define mmPA_SC_VPORT_ZMIN_2                            0xA0B8
#define mmPA_SC_VPORT_ZMIN_3                            0xA0BA
#define mmPA_SC_VPORT_ZMIN_4                            0xA0BC
#define mmPA_SC_VPORT_ZMIN_5                            0xA0BE
#define mmPA_SC_VPORT_ZMIN_6                            0xA0C0
#define mmPA_SC_VPORT_ZMIN_7                            0xA0C2
#define mmPA_SC_VPORT_ZMIN_8                            0xA0C4
#define mmPA_SC_VPORT_ZMIN_9                            0xA0C6
#define mmPA_SC_VPORT_ZMIN_10                           0xA0C8
#define mmPA_SC_VPORT_ZMIN_11                           0xA0CA
#define mmPA_SC_VPORT_ZMIN_12                           0xA0CC
#define mmPA_SC_VPORT_ZMIN_13                           0xA0CE
#define mmPA_SC_VPORT_ZMIN_14                           0xA0D0
#define mmPA_SC_VPORT_ZMIN_15                           0xA0D2
#define mmPA_SC_VPORT_ZMAX_0                            0xA0B5
#define mmPA_SC_VPORT_ZMAX_1                            0xA0B7
#define mmPA_SC_VPORT_ZMAX_2                            0xA0B9
#define mmPA_SC_VPORT_ZMAX_3                            0xA0BB
#define mmPA_SC_VPORT_ZMAX_4                            0xA0BD
#define mmPA_SC_VPORT_ZMAX_5                            0xA0BF
#define mmPA_SC_VPORT_ZMAX_6                            0xA0C1
#define mmPA_SC_VPORT_ZMAX_7                            0xA0C3
#define mmPA_SC_VPORT_ZMAX_8                            0xA0C5
#define mmPA_SC_VPORT_ZMAX_9                            0xA0C7
#define mmPA_SC_VPORT_ZMAX_10                           0xA0C9
#define mmPA_SC_VPORT_ZMAX_11                           0xA0CB
#define mmPA_SC_VPORT_ZMAX_12                           0xA0CD
#define mmPA_SC_VPORT_ZMAX_13                           0xA0CF
#define mmPA_SC_VPORT_ZMAX_14                           0xA0D1
#define mmPA_SC_VPORT_ZMAX_15                           0xA0D3
#define mmPA_SC_MODE_CNTL                               0xA293
#define mmPA_SC_MPASS_PS_CNTL                           0xA292

#define mmVGT_DRAW_INITIATOR                            0xA1FC
#define mmVGT_EVENT_INITIATOR                           0xA2A4
#define mmVGT_EVENT_ADDRESS_REG                         0xA1FE
#define mmVGT_DMA_BASE_HI                               0xA1F9
#define mmVGT_DMA_BASE                                  0xA1FA
#define mmVGT_DMA_INDEX_TYPE                            0xA29F
#define mmVGT_DMA_NUM_INSTANCES                         0xA2A2
#define mmVGT_DMA_SIZE                                  0xA29D

#define mmVGT_IMMED_DATA                                0xA1FD
#define mmVGT_INDEX_TYPE                                0x2257
#define mmVGT_NUM_INDICES                               0x225C
#define mmVGT_NUM_INSTANCES                             0x225D
#define mmVGT_PRIMITIVE_TYPE                            0x2256
#define mmVGT_PRIMITIVEID_EN                            0xA2A1
#define mmVGT_VTX_CNT_EN                                0xA2AE
#define mmVGT_REUSE_OFF                                 0xA2AD
#define mmVGT_INSTANCE_STEP_RATE_0                      0xA2A8
#define mmVGT_INSTANCE_STEP_RATE_1                      0xA2A9
#define mmVGT_MAX_VTX_INDX                              0xA100
#define mmVGT_MIN_VTX_INDX                              0xA101
#define mmVGT_INDX_OFFSET                               0xA102
#define mmVGT_VERTEX_REUSE_BLOCK_CNTL                   0xA316
#define mmVGT_OUT_DEALLOC_CNTL                          0xA317
#define mmVGT_MULTI_PRIM_IB_RESET_INDX                  0xA103
#define mmVGT_MULTI_PRIM_IB_RESET_EN                    0xA2A5
#define mmVGT_ENHANCE                                   0xA294
#define mmVGT_OUTPUT_PATH_CNTL                          0xA284
#define mmVGT_HOS_CNTL                                  0xA285
#define mmVGT_HOS_MAX_TESS_LEVEL                        0xA286
#define mmVGT_HOS_MIN_TESS_LEVEL                        0xA287
#define mmVGT_HOS_REUSE_DEPTH                           0xA288
#define mmVGT_GROUP_PRIM_TYPE                           0xA289
#define mmVGT_GROUP_FIRST_DECR                          0xA28A
#define mmVGT_GROUP_DECR                                0xA28B
#define mmVGT_GROUP_VECT_0_CNTL                         0xA28C
#define mmVGT_GROUP_VECT_1_CNTL                         0xA28D
#define mmVGT_GROUP_VECT_0_FMT_CNTL                     0xA28E
#define mmVGT_GROUP_VECT_1_FMT_CNTL                     0xA28F
#define mmVGT_GS_MODE                                   0xA290
#define mmVGT_GS_OUT_PRIM_TYPE                          0xA29B

#define mmVGT_STRMOUT_EN                                0xA2AC
#define mmVGT_STRMOUT_BUFFER_SIZE_0                     0xA2B4
#define mmVGT_STRMOUT_BUFFER_SIZE_1                     0xA2B8
#define mmVGT_STRMOUT_BUFFER_SIZE_2                     0xA2BC
#define mmVGT_STRMOUT_BUFFER_SIZE_3                     0xA2C0
#define mmVGT_STRMOUT_BUFFER_OFFSET_0                   0xA2B7
#define mmVGT_STRMOUT_BUFFER_OFFSET_1                   0xA2BB
#define mmVGT_STRMOUT_BUFFER_OFFSET_2                   0xA2BF
#define mmVGT_STRMOUT_BUFFER_OFFSET_3                   0xA2C3
#define mmVGT_STRMOUT_VTX_STRIDE_0                      0xA2B5
#define mmVGT_STRMOUT_VTX_STRIDE_1                      0xA2B9
#define mmVGT_STRMOUT_VTX_STRIDE_2                      0xA2BD
#define mmVGT_STRMOUT_VTX_STRIDE_3                      0xA2C1
#define mmVGT_STRMOUT_BUFFER_BASE_0                     0xA2B6
#define mmVGT_STRMOUT_BUFFER_BASE_1                     0xA2BA
#define mmVGT_STRMOUT_BUFFER_BASE_2                     0xA2BE
#define mmVGT_STRMOUT_BUFFER_BASE_3                     0xA2C2
#define mmVGT_STRMOUT_BUFFER_EN                         0xA2C8
#define mmVGT_STRMOUT_BASE_OFFSET_0                     0xA2C4
#define mmVGT_STRMOUT_BASE_OFFSET_1                     0xA2C5
#define mmVGT_STRMOUT_BASE_OFFSET_2                     0xA2C6
#define mmVGT_STRMOUT_BASE_OFFSET_3                     0xA2C7
#define mmVGT_STRMOUT_BASE_OFFSET_HI_0                  0xA2D1
#define mmVGT_STRMOUT_BASE_OFFSET_HI_1                  0xA2D2
#define mmVGT_STRMOUT_BASE_OFFSET_HI_2                  0xA2D3
#define mmVGT_STRMOUT_BASE_OFFSET_HI_3                  0xA2D4
#define mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET                0xA2CA
#define mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE    0xA2CB
#define mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE         0xA2CC

#define mmSQ_PGM_START_PS                               0xA210
#define mmSQ_PGM_CF_OFFSET_PS                           0xA233
#define mmSQ_PGM_RESOURCES_PS                           0xA214
#define mmSQ_PGM_EXPORTS_PS                             0xA215
#define mmSQ_PGM_START_VS                               0xA216
#define mmSQ_PGM_CF_OFFSET_VS                           0xA234
#define mmSQ_PGM_RESOURCES_VS                           0xA21A
#define mmSQ_PGM_START_GS                               0xA21B
#define mmSQ_PGM_CF_OFFSET_GS                           0xA235
#define mmSQ_PGM_RESOURCES_GS                           0xA21F
#define mmSQ_PGM_START_ES                               0xA220
#define mmSQ_PGM_CF_OFFSET_ES                           0xA236
#define mmSQ_PGM_RESOURCES_ES                           0xA224
#define mmSQ_PGM_START_FS                               0xA225
#define mmSQ_PGM_CF_OFFSET_FS                           0xA237
#define mmSQ_PGM_RESOURCES_FS                           0xA229
#define mmSQ_ESGS_RING_ITEMSIZE                         0xA22A
#define mmSQ_GSVS_RING_ITEMSIZE                         0xA22B
#define mmSQ_ESTMP_RING_ITEMSIZE                        0xA22C
#define mmSQ_GSTMP_RING_ITEMSIZE                        0xA22D
#define mmSQ_VSTMP_RING_ITEMSIZE                        0xA22E
#define mmSQ_PSTMP_RING_ITEMSIZE                        0xA22F
#define mmSQ_FBUF_RING_ITEMSIZE                         0xA230
#define mmSQ_REDUC_RING_ITEMSIZE                        0xA231
#define mmSQ_GS_VERT_ITEMSIZE                           0xA232
#define mmSQ_VTX_SEMANTIC_CLEAR                         0xA238

#define mmSQ_VTX_SEMANTIC_0                             0xA0E0
#define mmSQ_VTX_SEMANTIC_1                             0xA0E1
#define mmSQ_VTX_SEMANTIC_2                             0xA0E2
#define mmSQ_VTX_SEMANTIC_3                             0xA0E3
#define mmSQ_VTX_SEMANTIC_4                             0xA0E4
#define mmSQ_VTX_SEMANTIC_5                             0xA0E5
#define mmSQ_VTX_SEMANTIC_6                             0xA0E6
#define mmSQ_VTX_SEMANTIC_7                             0xA0E7
#define mmSQ_VTX_SEMANTIC_8                             0xA0E8
#define mmSQ_VTX_SEMANTIC_9                             0xA0E9
#define mmSQ_VTX_SEMANTIC_10                            0xA0EA
#define mmSQ_VTX_SEMANTIC_11                            0xA0EB
#define mmSQ_VTX_SEMANTIC_12                            0xA0EC
#define mmSQ_VTX_SEMANTIC_13                            0xA0ED
#define mmSQ_VTX_SEMANTIC_14                            0xA0EE
#define mmSQ_VTX_SEMANTIC_15                            0xA0EF
#define mmSQ_VTX_SEMANTIC_16                            0xA0F0
#define mmSQ_VTX_SEMANTIC_17                            0xA0F1
#define mmSQ_VTX_SEMANTIC_18                            0xA0F2
#define mmSQ_VTX_SEMANTIC_19                            0xA0F3
#define mmSQ_VTX_SEMANTIC_20                            0xA0F4
#define mmSQ_VTX_SEMANTIC_21                            0xA0F5
#define mmSQ_VTX_SEMANTIC_22                            0xA0F6
#define mmSQ_VTX_SEMANTIC_23                            0xA0F7
#define mmSQ_VTX_SEMANTIC_24                            0xA0F8
#define mmSQ_VTX_SEMANTIC_25                            0xA0F9
#define mmSQ_VTX_SEMANTIC_26                            0xA0FA
#define mmSQ_VTX_SEMANTIC_27                            0xA0FB
#define mmSQ_VTX_SEMANTIC_28                            0xA0FC
#define mmSQ_VTX_SEMANTIC_29                            0xA0FD
#define mmSQ_VTX_SEMANTIC_30                            0xA0FE
#define mmSQ_VTX_SEMANTIC_31                            0xA0FF

#define mmSQ_ALU_CONST_CACHE_PS_0                       0xA250
#define mmSQ_ALU_CONST_CACHE_PS_1                       0xA251
#define mmSQ_ALU_CONST_CACHE_PS_2                       0xA252
#define mmSQ_ALU_CONST_CACHE_PS_3                       0xA253
#define mmSQ_ALU_CONST_CACHE_PS_4                       0xA254
#define mmSQ_ALU_CONST_CACHE_PS_5                       0xA255
#define mmSQ_ALU_CONST_CACHE_PS_6                       0xA256
#define mmSQ_ALU_CONST_CACHE_PS_7                       0xA257
#define mmSQ_ALU_CONST_CACHE_PS_8                       0xA258
#define mmSQ_ALU_CONST_CACHE_PS_9                       0xA259
#define mmSQ_ALU_CONST_CACHE_PS_10                      0xA25A
#define mmSQ_ALU_CONST_CACHE_PS_11                      0xA25B
#define mmSQ_ALU_CONST_CACHE_PS_12                      0xA25C
#define mmSQ_ALU_CONST_CACHE_PS_13                      0xA25D
#define mmSQ_ALU_CONST_CACHE_PS_14                      0xA25E
#define mmSQ_ALU_CONST_CACHE_PS_15                      0xA25F
#define mmSQ_ALU_CONST_CACHE_VS_0                       0xA260
#define mmSQ_ALU_CONST_CACHE_VS_1                       0xA261
#define mmSQ_ALU_CONST_CACHE_VS_2                       0xA262
#define mmSQ_ALU_CONST_CACHE_VS_3                       0xA263
#define mmSQ_ALU_CONST_CACHE_VS_4                       0xA264
#define mmSQ_ALU_CONST_CACHE_VS_5                       0xA265
#define mmSQ_ALU_CONST_CACHE_VS_6                       0xA266
#define mmSQ_ALU_CONST_CACHE_VS_7                       0xA267
#define mmSQ_ALU_CONST_CACHE_VS_8                       0xA268
#define mmSQ_ALU_CONST_CACHE_VS_9                       0xA269
#define mmSQ_ALU_CONST_CACHE_VS_10                      0xA26A
#define mmSQ_ALU_CONST_CACHE_VS_11                      0xA26B
#define mmSQ_ALU_CONST_CACHE_VS_12                      0xA26C
#define mmSQ_ALU_CONST_CACHE_VS_13                      0xA26D
#define mmSQ_ALU_CONST_CACHE_VS_14                      0xA26E
#define mmSQ_ALU_CONST_CACHE_VS_15                      0xA26F
#define mmSQ_ALU_CONST_CACHE_GS_0                       0xA270
#define mmSQ_ALU_CONST_CACHE_GS_1                       0xA271
#define mmSQ_ALU_CONST_CACHE_GS_2                       0xA272
#define mmSQ_ALU_CONST_CACHE_GS_3                       0xA273
#define mmSQ_ALU_CONST_CACHE_GS_4                       0xA274
#define mmSQ_ALU_CONST_CACHE_GS_5                       0xA275
#define mmSQ_ALU_CONST_CACHE_GS_6                       0xA276
#define mmSQ_ALU_CONST_CACHE_GS_7                       0xA277
#define mmSQ_ALU_CONST_CACHE_GS_8                       0xA278
#define mmSQ_ALU_CONST_CACHE_GS_9                       0xA279
#define mmSQ_ALU_CONST_CACHE_GS_10                      0xA27A
#define mmSQ_ALU_CONST_CACHE_GS_11                      0xA27B
#define mmSQ_ALU_CONST_CACHE_GS_12                      0xA27C
#define mmSQ_ALU_CONST_CACHE_GS_13                      0xA27D
#define mmSQ_ALU_CONST_CACHE_GS_14                      0xA27E
#define mmSQ_ALU_CONST_CACHE_GS_15                      0xA27F
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_0                 0xA050
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_1                 0xA051
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_2                 0xA052
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_3                 0xA053
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_4                 0xA054
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_5                 0xA055
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_6                 0xA056
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_7                 0xA057
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_8                 0xA058
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_9                 0xA059
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_10                0xA05A
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_11                0xA05B
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_12                0xA05C
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_13                0xA05D
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_14                0xA05E
#define mmSQ_ALU_CONST_BUFFER_SIZE_PS_15                0xA05F
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_0                 0xA060
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_1                 0xA061
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_2                 0xA062
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_3                 0xA063
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_4                 0xA064
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_5                 0xA065
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_6                 0xA066
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_7                 0xA067
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_8                 0xA068
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_9                 0xA069
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_10                0xA06A
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_11                0xA06B
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_12                0xA06C
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_13                0xA06D
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_14                0xA06E
#define mmSQ_ALU_CONST_BUFFER_SIZE_VS_15                0xA06F
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_0                 0xA070
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_1                 0xA071
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_2                 0xA072
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_3                 0xA073
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_4                 0xA074
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_5                 0xA075
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_6                 0xA076
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_7                 0xA077
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_8                 0xA078
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_9                 0xA079
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_10                0xA07A
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_11                0xA07B
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_12                0xA07C
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_13                0xA07D
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_14                0xA07E
#define mmSQ_ALU_CONST_BUFFER_SIZE_GS_15                0xA07F

#define mmSPI_VS_OUT_ID_0                               0xA185
#define mmSPI_VS_OUT_ID_1                               0xA186
#define mmSPI_VS_OUT_ID_2                               0xA187
#define mmSPI_VS_OUT_ID_3                               0xA188
#define mmSPI_VS_OUT_ID_4                               0xA189
#define mmSPI_VS_OUT_ID_5                               0xA18A
#define mmSPI_VS_OUT_ID_6                               0xA18B
#define mmSPI_VS_OUT_ID_7                               0xA18C
#define mmSPI_VS_OUT_ID_8                               0xA18D
#define mmSPI_VS_OUT_ID_9                               0xA18E
#define mmSPI_PS_INPUT_CNTL_0                           0xA191
#define mmSPI_PS_INPUT_CNTL_1                           0xA192
#define mmSPI_PS_INPUT_CNTL_2                           0xA193
#define mmSPI_PS_INPUT_CNTL_3                           0xA194
#define mmSPI_PS_INPUT_CNTL_4                           0xA195
#define mmSPI_PS_INPUT_CNTL_5                           0xA196
#define mmSPI_PS_INPUT_CNTL_6                           0xA197
#define mmSPI_PS_INPUT_CNTL_7                           0xA198
#define mmSPI_PS_INPUT_CNTL_8                           0xA199
#define mmSPI_PS_INPUT_CNTL_9                           0xA19A
#define mmSPI_PS_INPUT_CNTL_10                          0xA19B
#define mmSPI_PS_INPUT_CNTL_11                          0xA19C
#define mmSPI_PS_INPUT_CNTL_12                          0xA19D
#define mmSPI_PS_INPUT_CNTL_13                          0xA19E
#define mmSPI_PS_INPUT_CNTL_14                          0xA19F
#define mmSPI_PS_INPUT_CNTL_15                          0xA1A0
#define mmSPI_PS_INPUT_CNTL_16                          0xA1A1
#define mmSPI_PS_INPUT_CNTL_17                          0xA1A2
#define mmSPI_PS_INPUT_CNTL_18                          0xA1A3
#define mmSPI_PS_INPUT_CNTL_19                          0xA1A4
#define mmSPI_PS_INPUT_CNTL_20                          0xA1A5
#define mmSPI_PS_INPUT_CNTL_21                          0xA1A6
#define mmSPI_PS_INPUT_CNTL_22                          0xA1A7
#define mmSPI_PS_INPUT_CNTL_23                          0xA1A8
#define mmSPI_PS_INPUT_CNTL_24                          0xA1A9
#define mmSPI_PS_INPUT_CNTL_25                          0xA1AA
#define mmSPI_PS_INPUT_CNTL_26                          0xA1AB
#define mmSPI_PS_INPUT_CNTL_27                          0xA1AC
#define mmSPI_PS_INPUT_CNTL_28                          0xA1AD
#define mmSPI_PS_INPUT_CNTL_29                          0xA1AE
#define mmSPI_PS_INPUT_CNTL_30                          0xA1AF
#define mmSPI_PS_INPUT_CNTL_31                          0xA1B0
#define mmSPI_VS_OUT_CONFIG                             0xA1B1
#define mmSPI_THREAD_GROUPING                           0xA1B2
#define mmSPI_PS_IN_CONTROL_0                           0xA1B3
#define mmSPI_PS_IN_CONTROL_1                           0xA1B4
#define mmSPI_INTERP_CONTROL_0                          0xA1B5
#define mmSPI_INPUT_Z                                   0xA1B6
#define mmSPI_FOG_CNTL                                  0xA1B7
#define mmSPI_FOG_FUNC_SCALE                            0xA1B8
#define mmSPI_FOG_FUNC_BIAS                             0xA1B9

#define mmSX_MISC                                       0xA0D4
#define mmSX_ALPHA_TEST_CONTROL                         0xA104
#define mmSX_ALPHA_REF                                  0xA10E

#define mmDB_DEPTH_BASE                                 0xA003
#define mmDB_DEPTH_INFO                                 0xA004
#define mmDB_HTILE_DATA_BASE                            0xA005
#define mmDB_DEPTH_SIZE                                 0xA000
#define mmDB_DEPTH_VIEW                                 0xA001
#define mmDB_RENDER_CONTROL                             0xA343
#define mmDB_RENDER_OVERRIDE                            0xA344
#define mmDB_SHADER_CONTROL                             0xA203
#define mmDB_STENCIL_CLEAR                              0xA00A
#define mmDB_DEPTH_CLEAR                                0xA00B
#define mmDB_HTILE_SURFACE                              0xA349
#define mmDB_PRELOAD_CONTROL                            0xA34C
#define mmDB_PREFETCH_LIMIT                             0xA34D
#define mmDB_STENCILREFMASK                             0xA10C
#define mmDB_STENCILREFMASK_BF                          0xA10D
#define mmDB_SRESULTS_COMPARE_STATE0                    0xA34A
#define mmDB_SRESULTS_COMPARE_STATE1                    0xA34B
#define mmDB_DEPTH_CONTROL                              0xA200
#define mmDB_ALPHA_TO_MASK                              0xA351

#define mmCB_CLEAR_RED_R6XX                             0xA048
#define mmCB_CLEAR_GREEN_R6XX                           0xA049
#define mmCB_CLEAR_BLUE_R6XX                            0xA04A
#define mmCB_CLEAR_ALPHA_R6XX                           0xA04B
#define mmCB_BLEND_RED                                  0xA105
#define mmCB_BLEND_GREEN                                0xA106
#define mmCB_BLEND_BLUE                                 0xA107
#define mmCB_BLEND_ALPHA                                0xA108
#define mmCB_FOG_RED_R6XX                               0xA109
#define mmCB_FOG_GREEN_R6XX                             0xA10A
#define mmCB_FOG_BLUE_R6XX                              0xA10B
#define mmCB_BLEND_CONTROL                              0xA201
#define mmCB_COLOR_CONTROL                              0xA202
#define mmCB_BLEND0_CONTROL                             0xA1E0
#define mmCB_BLEND1_CONTROL                             0xA1E1
#define mmCB_BLEND2_CONTROL                             0xA1E2
#define mmCB_BLEND3_CONTROL                             0xA1E3
#define mmCB_BLEND4_CONTROL                             0xA1E4
#define mmCB_BLEND5_CONTROL                             0xA1E5
#define mmCB_BLEND6_CONTROL                             0xA1E6
#define mmCB_BLEND7_CONTROL                             0xA1E7
#define mmCB_CLRCMP_CONTROL                             0xA30C
#define mmCB_CLRCMP_SRC                                 0xA30D
#define mmCB_CLRCMP_DST                                 0xA30E
#define mmCB_CLRCMP_MSK                                 0xA30F
#define mmCB_COLOR0_BASE                                0xA010
#define mmCB_COLOR1_BASE                                0xA011
#define mmCB_COLOR2_BASE                                0xA012
#define mmCB_COLOR3_BASE                                0xA013
#define mmCB_COLOR4_BASE                                0xA014
#define mmCB_COLOR5_BASE                                0xA015
#define mmCB_COLOR6_BASE                                0xA016
#define mmCB_COLOR7_BASE                                0xA017
#define mmCB_COLOR0_SIZE                                0xA018
#define mmCB_COLOR1_SIZE                                0xA019
#define mmCB_COLOR2_SIZE                                0xA01A
#define mmCB_COLOR3_SIZE                                0xA01B
#define mmCB_COLOR4_SIZE                                0xA01C
#define mmCB_COLOR5_SIZE                                0xA01D
#define mmCB_COLOR6_SIZE                                0xA01E
#define mmCB_COLOR7_SIZE                                0xA01F
#define mmCB_COLOR0_VIEW                                0xA020
#define mmCB_COLOR1_VIEW                                0xA021
#define mmCB_COLOR2_VIEW                                0xA022
#define mmCB_COLOR3_VIEW                                0xA023
#define mmCB_COLOR4_VIEW                                0xA024
#define mmCB_COLOR5_VIEW                                0xA025
#define mmCB_COLOR6_VIEW                                0xA026
#define mmCB_COLOR7_VIEW                                0xA027
#define mmCB_COLOR0_INFO                                0xA028
#define mmCB_COLOR1_INFO                                0xA029
#define mmCB_COLOR2_INFO                                0xA02A
#define mmCB_COLOR3_INFO                                0xA02B
#define mmCB_COLOR4_INFO                                0xA02C
#define mmCB_COLOR5_INFO                                0xA02D
#define mmCB_COLOR6_INFO                                0xA02E
#define mmCB_COLOR7_INFO                                0xA02F
#define mmCB_COLOR0_TILE                                0xA030
#define mmCB_COLOR1_TILE                                0xA031
#define mmCB_COLOR2_TILE                                0xA032
#define mmCB_COLOR3_TILE                                0xA033
#define mmCB_COLOR4_TILE                                0xA034
#define mmCB_COLOR5_TILE                                0xA035
#define mmCB_COLOR6_TILE                                0xA036
#define mmCB_COLOR7_TILE                                0xA037
#define mmCB_COLOR0_FRAG                                0xA038
#define mmCB_COLOR1_FRAG                                0xA039
#define mmCB_COLOR2_FRAG                                0xA03A
#define mmCB_COLOR3_FRAG                                0xA03B
#define mmCB_COLOR4_FRAG                                0xA03C
#define mmCB_COLOR5_FRAG                                0xA03D
#define mmCB_COLOR6_FRAG                                0xA03E
#define mmCB_COLOR7_FRAG                                0xA03F
#define mmCB_COLOR0_MASK                                0xA040
#define mmCB_COLOR1_MASK                                0xA041
#define mmCB_COLOR2_MASK                                0xA042
#define mmCB_COLOR3_MASK                                0xA043
#define mmCB_COLOR4_MASK                                0xA044
#define mmCB_COLOR5_MASK                                0xA045
#define mmCB_COLOR6_MASK                                0xA046
#define mmCB_COLOR7_MASK                                0xA047
#define mmCB_CLEAR_RED_R6XX                             0xA048
#define mmCB_CLEAR_GREEN_R6XX                           0xA049
#define mmCB_CLEAR_BLUE_R6XX                            0xA04A
#define mmCB_CLEAR_ALPHA_R6XX                           0xA04B
#define mmCB_TARGET_MASK                                0xA08E
#define mmCB_SHADER_MASK                                0xA08F
#define mmCB_SHADER_CONTROL                             0xA1E8

#define mmSQ_VTX_BASE_VTX_LOC                           0xF3FC
#define mmSQ_VTX_START_INST_LOC                         0xF3FD

#endif /* _R700_CHIPOFFSET_H_ */

