.\" Hey, Emacs!  This is an -*- nroff -*- source file.
.\" Update-mime and this manpage were written by Brian White and
.\" have been placed in the public domain (the only true "free").
.\"
.TH MAILCAP.ORDER 5 "16th Aug 1998" "Debian Project" "Order Mailcap Entries"
.SH NAME
/etc/mailcap.order \- the mailcap ordering specifications
.SH DESCRIPTION
The order of entries in the
.I /etc/mailcap
file can be altered by editing the
.I /etc/mailcap.order
file.  Each line of that file specifies a package and an optional mime
type.  Mailcap entries that match will be placed in the order of this
file.  Entries that don't match will be placed later.
.SS Example
    mime-support:*/*
    gv:application/postscript
    netscape:text/html
    less:text/*
    emacs:text/*

The above would make any entries provided by the
.B mime-support
package
(as found in the 
.I /usr/lib/mime/packages
directory) take priority over everything else.  The
.B gv
package will be used over anything else when it comes to postscript
documents.
.B Netscape
will be used for any html documents and
.B less
will
be used for any remaining text documents.  However, since neither
netscape or less provide for editing documents, any edit or compose
actions will fall through to the
.B emacs
rules.

After modifying this file, be sure to run
.I /usr/sbin/update-mime
(as root)
to propagate the changes into the
.I /etc/mailcap
file.

Remember that this files takes
.I package
names and not
.I executable
names.  If you want to define rules that reference specific programs,
the best way is to include them in
.I ~/.mailcap
or the user section of the
.I /etc/mailcap
file.
.SH LIMITATIONS
There is currently no way to break out a certain type from a wildcard
rule.  If, for example, both xv and gimp were to specify "image/*"
rules, it isn't possible to use xv for
.I gif
images but use gimp for
.I jpeg
images.

Also, I would like to add the ability to specify certain actions in the
rules.  For example, if netscape were to have an
.I edit
rule but I wanted to use emacs for editing/creating html documents, I
could place a line like

  emacs:text/* action=edit|compose

before the netscape entry.  The
.B update-mime
program would then spit out entries such that netscape
.I view
rule comes
.B before
the emacs
.I view
rule but have the netscape
.I edit
rule comes
.B after
the emacs
.I edit
rule.
.SH "SEE ALSO"
.BR mailcap "(5)"
.BR run-mailcap "(1)"
.BR update-mime "(8)"
.SH AUTHOR
The
.B mailcap.order
specification was written by Brian White <bcwhite@pobox.com>
