/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Alexandros Frantzis <alexandros.frantzis@canonical.com>
 */

#undef TRACEPOINT_PROVIDER
#define TRACEPOINT_PROVIDER mir_server_msgproc

#undef TRACEPOINT_INCLUDE
#define TRACEPOINT_INCLUDE "./message_processor_report_tp.h"

#if !defined(MIR_LTTNG_MESSAGE_PROCESSOR_REPORT_TP_H_) || defined(TRACEPOINT_HEADER_MULTI_READ)
#define MIR_LTTNG_MESSAGE_PROCESSOR_REPORT_TP_H_

#include <lttng/tracepoint.h>

TRACEPOINT_EVENT(
    mir_server_msgproc,
    received_invocation,
    TP_ARGS(const void*, mediator, int, id, const char*, method),
    TP_FIELDS(
        ctf_integer_hex(void*, mediator, mediator)
        ctf_integer(int, id, id)
        ctf_string(method, method)
    )
)

TRACEPOINT_EVENT(
    mir_server_msgproc,
    completed_invocation,
    TP_ARGS(const void*, mediator, int, id, int, result),
    TP_FIELDS(
        ctf_integer_hex(void*, mediator, mediator)
        ctf_integer(int, id, id)
        ctf_integer(int, result, result)
    )
)

#endif /* MIR_LTTNG_MESSAGE_PROCESSOR_REPORT_TP_H_ */

#include <lttng/tracepoint-event.h>
