Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

const nsIMozvoikkoHelper = Components.interfaces.nsIMozvoikkoHelper;
const CLASS_ID = Components.ID("{aae2f310-dd4b-11df-937b-0800200c9a66}");
const CLASS_NAME = "Mozvoikko Helper";
const CONTRACT_ID = "@mozilla.org/mozvoikkohelper;1";

function MozvoikkoHelper() { }

MozvoikkoHelper.prototype =
{
    classDescription: CLASS_NAME,
    classID: CLASS_ID,
    contracyID: CONTRACT_ID,

    QueryInterface: XPCOMUtils.generateQI([nsIMozvoikkoHelper],
                           Components.interfaces.nsISupports),
    
    get componentFile() {
        return __LOCATION__;
    },
    
    get componentsDir() {
        return __LOCATION__.parent;
    },
    
    get extensionDir() {
        return __LOCATION__.parent.parent;
    }

}

/***********************************************************
module definition (xpcom registration)
***********************************************************/
var MozvoikkoHelperFactory =
{
    registerSelf: function(aCompMgr, aFileSpec, aLocation, aType)
    {
        aCompMgr = aCompMgr.
            QueryInterface(Components.interfaces.nsIComponentRegistrar);
        aCompMgr.registerFactoryLocation(
            CLASS_ID, CLASS_NAME,
            CONTRACT_ID, aFileSpec, aLocation, aType);
    },

    unregisterSelf: function(aCompMgr, aLocation, aType)
    {
        aCompMgr = aCompMgr.
            QueryInterface(Components.interfaces.nsIComponentRegistrar);
        aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);
    },

    getClassObject: function(aCompMgr, aCID, aIID)
    {
        if (!aIID.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        if (aCID.equals(CLASS_ID))
            return this.MozvoikkoHelperFactory;
        
        throw Components.results.NS_ERROR_NO_INTERFACE;
    },

    canUnload: function(aCompMgr)
    {
        return true;
    },

    /***********************************************************
        class factory

        This object is a member of the global-scope Components.classes.
        It is keyed off of the contract ID. Eg:

        myHelloWorld = Components.classes["@dietrich.ganx4.com/helloworld;1"].
                          createInstance(Components.interfaces.nsIHelloWorld);

    ***********************************************************/
    MozvoikkoHelperFactory:
    {
        createInstance: function(aOuter, aIID)
        {
            if (aOuter != null)
                throw Components.results.NS_ERROR_NO_AGGREGATION;

            return (new MozvoikkoHelper()).QueryInterface(aIID);
        }
    }
};

// FF 2
/***********************************************************
module initialization

When the application registers the component, this function
is called.
***********************************************************/
function NSGetModule(aCompMgr, aFileSpec)
{
        return MozvoikkoHelperFactory;
}

// FF 4+
if (typeof XPCOMUtils != "undefined")
{
        if (XPCOMUtils.generateNSGetFactory) {
                // FF 4+
                var NSGetFactory = XPCOMUtils.generateNSGetFactory([MozvoikkoHelper]);
        }
}
