/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.EventListenerList;
import java.io.Serializable;

public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    protected transient ChangeEvent changeEvent;
    protected EventListenerList listenerList = new EventListenerList();
    private int value;
    private int extent;
    private int min;
    private int max = 100;
    private boolean isAdjusting = false;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public DefaultBoundedRangeModel() {
    }

    public DefaultBoundedRangeModel(int n, int n2, int n3, int n4) {
        if (n4 >= n3 && n >= n3 && n + n2 <= n4) {
            this.value = n;
            this.extent = n2;
            this.min = n3;
            this.max = n4;
            return;
        }
        throw new IllegalArgumentException("invalid range properties");
    }

    public int getValue() {
        return this.value;
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setValue(int n) {
        int n2 = Math.max(n, this.min);
        if (n2 + this.extent > this.max) {
            n2 = this.max - this.extent;
        }
        this.setRangeProperties(n2, this.extent, this.min, this.max, this.isAdjusting);
    }

    public void setExtent(int n) {
        int n2 = Math.max(0, n);
        if (this.value + n2 > this.max) {
            n2 = this.max - this.value;
        }
        this.setRangeProperties(this.value, n2, this.min, this.max, this.isAdjusting);
    }

    public void setMinimum(int n) {
        int n2 = Math.max(n, this.max);
        int n3 = Math.max(n, this.value);
        int n4 = Math.min(n2 - n3, this.extent);
        this.setRangeProperties(n3, n4, n, n2, this.isAdjusting);
    }

    public void setMaximum(int n) {
        int n2 = Math.min(n, this.min);
        int n3 = Math.min(n, this.value);
        int n4 = Math.min(n - n3, this.extent);
        this.setRangeProperties(n3, n4, n2, n, this.isAdjusting);
    }

    public void setValueIsAdjusting(boolean bl) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, bl);
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (n3 > n4) {
            n3 = n4;
        }
        if (n > n4) {
            n4 = n;
        }
        if (n < n3) {
            n3 = n;
        }
        if (n2 + n > n4) {
            n2 = n4 - n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        boolean bl3 = bl2 = n != this.value || n2 != this.extent || n3 != this.min || n4 != this.max || bl != this.isAdjusting;
        if (bl2) {
            this.value = n;
            this.extent = n2;
            this.min = n3;
            this.max = n4;
            this.isAdjusting = bl;
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = DefaultBoundedRangeModel.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = DefaultBoundedRangeModel.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : DefaultBoundedRangeModel.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public String toString() {
        String string = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return String.valueOf(this.getClass().getName()) + "[" + string + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

