/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import java.io.Serializable;
import java.util.BitSet;

public class DefaultListSelectionModel
implements ListSelectionModel,
Cloneable,
Serializable {
    private int selectionMode = 2;
    private int minIndex = -1;
    private int maxIndex = -1;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private int firstChangedIndex = -1;
    private int lastChangedIndex = -1;
    private boolean isAdjusting = false;
    protected BitSet value = new BitSet(32);
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean leadAnchorNotificationEnabled = true;
    static /* synthetic */ Class class$com$sun$java$swing$event$ListSelectionListener;

    public int getMinSelectionIndex() {
        return this.minIndex;
    }

    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = n;
                return;
            }
        }
        throw new IllegalArgumentException("invalid selectionMode");
    }

    public boolean isSelectedIndex(int n) {
        if (n == -1 || n < this.minIndex || n > this.maxIndex) {
            return false;
        }
        return this.value.get(n);
    }

    public boolean isSelectionEmpty() {
        return this.minIndex == -1 && this.maxIndex == -1;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : (class$com$sun$java$swing$event$ListSelectionListener = DefaultListSelectionModel.class$("com.sun.java.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : (class$com$sun$java$swing$event$ListSelectionListener = DefaultListSelectionModel.class$("com.sun.java.swing.event.ListSelectionListener")), listSelectionListener);
    }

    protected void fireValueChanged(boolean bl) {
        this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), bl);
    }

    protected void fireValueChanged(int n, int n2) {
        this.fireValueChanged(n, n2, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : DefaultListSelectionModel.class$("com.sun.java.swing.event.ListSelectionListener"))) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[n3 + 1]).valueChanged(listSelectionEvent);
            }
            n3 -= 2;
        }
    }

    public void clearSelection() {
        if (this.minIndex == -1 || this.maxIndex == -1) {
            return;
        }
        boolean bl = false;
        int n = this.minIndex;
        while (n <= this.maxIndex) {
            if (this.value.get(n)) {
                bl = true;
            }
            this.value.clear(n);
            ++n;
        }
        this.leadIndex = -1;
        this.anchorIndex = -1;
        this.maxIndex = -1;
        this.minIndex = -1;
        if (bl) {
            this.fireValueChanged(this.minIndex, this.maxIndex);
        }
    }

    public void setLeadAnchorNotificationEnabled(boolean bl) {
        this.leadAnchorNotificationEnabled = bl;
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    private void updateLeadAnchorIndices(int n, int n2) {
        if (this.leadAnchorNotificationEnabled) {
            int n3;
            int n4;
            if (this.anchorIndex != -1 && this.anchorIndex != n) {
                n4 = Math.min(this.anchorIndex, n);
                n3 = Math.max(this.anchorIndex, n);
                this.firstChangedIndex = this.firstChangedIndex == -1 ? n3 : Math.min(n4, this.firstChangedIndex);
                this.lastChangedIndex = Math.max(n3, this.lastChangedIndex);
            }
            if (this.leadIndex != -1 && this.leadIndex != n2) {
                n4 = Math.min(this.leadIndex, n2);
                n3 = Math.max(this.leadIndex, n2);
                this.firstChangedIndex = this.firstChangedIndex == -1 ? n4 : Math.min(n4, this.firstChangedIndex);
                this.lastChangedIndex = Math.max(n3, this.lastChangedIndex);
            }
        }
        this.anchorIndex = n;
        this.leadIndex = n2;
    }

    public void setSelectionInterval(int n, int n2) {
        if (this.getSelectionMode() == 0) {
            n = n2;
        }
        if (n == -1 && n2 == -1) {
            this.clearSelection();
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (this.minIndex == -1 || n3 < this.minIndex) {
            this.minIndex = n3;
        }
        if (this.maxIndex == -1 || n4 > this.maxIndex) {
            this.maxIndex = n4;
        }
        this.firstChangedIndex = -1;
        this.lastChangedIndex = -1;
        int n5 = this.minIndex;
        while (n5 < n3) {
            if (this.value.get(n5)) {
                if (this.firstChangedIndex == -1) {
                    this.firstChangedIndex = this.lastChangedIndex = n5;
                } else if (n5 > this.lastChangedIndex) {
                    this.lastChangedIndex = n5;
                }
            }
            this.value.clear(n5);
            ++n5;
        }
        int n6 = n3;
        while (n6 <= n4) {
            if (!this.value.get(n6)) {
                if (this.firstChangedIndex == -1) {
                    this.firstChangedIndex = this.lastChangedIndex = n6;
                } else if (n6 > this.lastChangedIndex) {
                    this.lastChangedIndex = n6;
                }
            }
            this.value.set(n6);
            ++n6;
        }
        int n7 = n4 + 1;
        while (n7 <= this.maxIndex) {
            if (this.value.get(n7)) {
                if (this.firstChangedIndex == -1) {
                    this.firstChangedIndex = this.lastChangedIndex = n7;
                } else if (n7 > this.lastChangedIndex) {
                    this.lastChangedIndex = n7;
                }
            }
            this.value.clear(n7);
            ++n7;
        }
        this.updateLeadAnchorIndices(n, n2);
        this.minIndex = n3;
        this.maxIndex = n4;
        if (this.firstChangedIndex != -1 && this.lastChangedIndex != -1) {
            this.fireValueChanged(this.firstChangedIndex, this.lastChangedIndex);
        }
    }

    public void addSelectionInterval(int n, int n2) {
        int n3 = this.getSelectionMode();
        if (n3 == 0 || n3 == 1) {
            this.setSelectionInterval(n, n2);
            return;
        }
        if (n == -1 && n2 == -1) {
            return;
        }
        int n4 = Math.min(n, n2);
        int n5 = Math.max(n, n2);
        if (this.minIndex == -1 || n4 < this.minIndex) {
            this.minIndex = n4;
        }
        if (this.maxIndex == -1 || n5 > this.maxIndex) {
            this.maxIndex = n5;
        }
        this.firstChangedIndex = -1;
        this.lastChangedIndex = -1;
        int n6 = n4;
        while (n6 <= n5) {
            if (!this.value.get(n6)) {
                if (this.firstChangedIndex == -1) {
                    this.firstChangedIndex = this.lastChangedIndex = n6;
                } else if (n6 > this.lastChangedIndex) {
                    this.lastChangedIndex = n6;
                }
                this.value.set(n6);
            }
            ++n6;
        }
        this.updateLeadAnchorIndices(n, n2);
        if (this.firstChangedIndex != -1 && this.lastChangedIndex != -1) {
            this.fireValueChanged(this.firstChangedIndex, this.lastChangedIndex);
        }
    }

    public void removeSelectionInterval(int n, int n2) {
        if (n == -1 && n2 == -1) {
            return;
        }
        if (this.minIndex == -1 && this.maxIndex == -1) {
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = -1;
        int n6 = -1;
        int n7 = n3;
        while (n7 <= n4) {
            if (this.value.get(n7)) {
                if (n5 == -1) {
                    n5 = n6 = n7;
                } else if (n7 > n6) {
                    n6 = n7;
                }
                this.value.clear(n7);
            }
            ++n7;
        }
        int n8 = -1;
        int n9 = -1;
        int n10 = this.minIndex;
        while (n10 <= this.maxIndex) {
            if (this.value.get(n10)) {
                if (n8 == -1) {
                    n8 = n9 = n10;
                } else if (n10 > n9) {
                    n9 = n10;
                }
            }
            ++n10;
        }
        this.minIndex = n8;
        this.maxIndex = n9;
        if (n5 != -1 && n6 != -1) {
            this.fireValueChanged(n5, n6);
        }
    }

    public void insertIndexInterval(int n, int n2, boolean bl) {
        int n3 = bl ? Math.max(0, n - 1) : n + 1;
        int n4 = n3 + n2 - 1;
        boolean bl2 = this.value.get(n) && this.value.get(n3);
        int n5 = this.maxIndex;
        while (n5 >= n3) {
            if (this.value.get(n5)) {
                this.value.set(n5 + n2);
            } else {
                this.value.clear(n5 + n2);
            }
            --n5;
        }
        int n6 = n3;
        while (n6 <= n4) {
            if (bl2) {
                this.value.set(n6);
            } else {
                this.value.clear(n6);
            }
            ++n6;
        }
        if (this.minIndex != -1 && (this.minIndex > n3 || this.minIndex == n3 && !bl2)) {
            this.minIndex += n2;
        }
        if (this.maxIndex != -1 && this.maxIndex >= n3) {
            this.maxIndex += n2;
        }
        this.fireValueChanged(n3, this.maxIndex);
    }

    public void removeIndexInterval(int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.minIndex == -1 && this.maxIndex == -1) {
            return;
        }
        int n4 = Math.min(n, n2);
        int n5 = Math.max(n, n2);
        int n6 = n5 - n4 + 1;
        if (n4 > this.maxIndex || n5 < this.minIndex) {
            return;
        }
        if (n4 <= this.minIndex && n5 >= this.maxIndex) {
            this.clearSelection();
            return;
        }
        int n7 = n4;
        while (n7 <= n5) {
            if (this.value.get(n7 + n6)) {
                this.value.set(n7);
            } else {
                this.value.clear(n7);
            }
            ++n7;
        }
        int n8 = this.maxIndex;
        while (n8 > this.maxIndex - n6) {
            this.value.clear(n8);
            --n8;
        }
        int n9 = this.minIndex;
        int n10 = this.maxIndex;
        if (n9 >= n4) {
            this.minIndex = -1;
            n3 = n4;
            while (n3 <= n10) {
                if (this.value.get(n3)) {
                    this.minIndex = n3;
                    break;
                }
                ++n3;
            }
        }
        if (this.minIndex == -1) {
            this.maxIndex = -1;
        } else if (n10 > n5) {
            this.maxIndex = n10 - n6;
        } else {
            n3 = n10;
            while (n3 >= this.minIndex) {
                if (this.value.get(n3)) {
                    this.maxIndex = n3;
                    break;
                }
                --n3;
            }
        }
        if (this.maxIndex == -1 && this.minIndex == -1) {
            this.fireValueChanged(n4, n5);
            return;
        }
        this.firstChangedIndex = Math.min(n4, this.minIndex);
        this.lastChangedIndex = Math.max(n5, this.maxIndex);
        this.fireValueChanged(this.firstChangedIndex, this.lastChangedIndex);
    }

    public void setValueIsAdjusting(boolean bl) {
        if (bl != this.isAdjusting) {
            this.isAdjusting = bl;
            this.fireValueChanged(bl);
        }
    }

    public String toString() {
        String string = String.valueOf(this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
        return String.valueOf(this.getClass().getName()) + " " + Integer.toString(this.hashCode()) + " " + string;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)super.clone();
        defaultListSelectionModel.value = (BitSet)this.value.clone();
        defaultListSelectionModel.listenerList = new EventListenerList();
        return defaultListSelectionModel;
    }

    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    public void setAnchorSelectionIndex(int n) {
        this.anchorIndex = n;
    }

    public void setLeadSelectionIndex(int n) {
        this.updateLead(n);
        this.leadIndex = n;
    }

    private boolean contains(int n, int n2, int n3) {
        if (n <= n2) {
            return n3 >= n && n3 < n2;
        }
        return n3 <= n && n3 > n2;
    }

    private int sign(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    private void updateLead(int n) {
        boolean bl;
        if (this.anchorIndex == -1) {
            this.anchorIndex = n;
        }
        if (!(bl = false) && this.contains(this.leadIndex, n, this.anchorIndex)) {
            this.removeSelectionInterval(this.anchorIndex, this.leadIndex);
            this.addSelectionInterval(this.anchorIndex, n);
        }
        if (!bl && !this.contains(this.anchorIndex, this.leadIndex, n)) {
            this.addSelectionInterval(this.anchorIndex, n);
            return;
        }
        int n2 = this.sign(this.anchorIndex, this.leadIndex);
        this.removeSelectionInterval(n - n2, this.leadIndex);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

