/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleAction;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleText;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.TreeExpansionEvent;
import com.sun.java.swing.event.TreeExpansionListener;
import com.sun.java.swing.event.TreeModelEvent;
import com.sun.java.swing.event.TreeModelListener;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.plaf.TreeUI;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.DefaultTreeModel;
import com.sun.java.swing.tree.DefaultTreeSelectionModel;
import com.sun.java.swing.tree.TreeCellEditor;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import com.sun.java.swing.tree.TreeSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class JTree
extends JComponent
implements Scrollable,
Accessible {
    protected transient TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    protected boolean rootVisible;
    protected transient TreeCellRenderer cellRenderer;
    protected int rowHeight;
    protected boolean showsRootHandles;
    protected TreeSelectionRedirector selectionRedirector;
    protected transient TreeCellEditor cellEditor;
    protected boolean editable;
    protected boolean largeModel;
    protected int visibleRowCount;
    protected boolean invokesStopCellEditing;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String TREE_MODEL_PROPERTY = "treeModel";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "messagesStopCellEditing";
    static /* synthetic */ Class class$com$sun$java$swing$event$TreeExpansionListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$TreeSelectionListener;

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("swing");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = defaultMutableTreeNode3;
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("is");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = defaultMutableTreeNode3;
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("cool");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    protected static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            defaultMutableTreeNode = new DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    public JTree() {
        this(JTree.getDefaultTreeModel());
    }

    public JTree(Object[] objectArray) {
        this(JTree.createTreeModel(objectArray));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public JTree(Vector vector) {
        this(JTree.createTreeModel(vector));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public JTree(Hashtable hashtable) {
        this(JTree.createTreeModel(hashtable));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public JTree(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JTree(TreeNode treeNode, boolean bl) {
        this(new DefaultTreeModel(treeNode, bl));
    }

    public JTree(TreeModel treeModel) {
        this.setLayout(null);
        this.rowHeight = 16;
        this.visibleRowCount = 20;
        this.rootVisible = true;
        this.selectionModel = new DefaultTreeSelectionModel();
        this.cellRenderer = null;
        this.updateUI();
        this.setModel(treeModel);
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public void setUI(TreeUI treeUI) {
        if ((TreeUI)this.ui != treeUI) {
            super.setUI(treeUI);
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "TreeUI";
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        TreeCellRenderer treeCellRenderer2 = this.cellRenderer;
        this.cellRenderer = treeCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, treeCellRenderer2, this.cellRenderer);
        this.invalidate();
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.EDITABLE : null, bl ? AccessibleState.EDITABLE : null);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setCellEditor(TreeCellEditor treeCellEditor) {
        TreeCellEditor treeCellEditor2 = this.cellEditor;
        this.cellEditor = treeCellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, treeCellEditor2, treeCellEditor);
        this.invalidate();
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.treeModel;
        this.treeModel = treeModel;
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, this.treeModel);
        this.invalidate();
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean bl) {
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, bl2, this.rootVisible);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public void setShowsRootHandles(boolean bl) {
        boolean bl2 = this.showsRootHandles;
        this.showsRootHandles = bl;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, bl2, this.showsRootHandles);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
        this.invalidate();
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setRowHeight(int n) {
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, n2, this.rowHeight);
        this.invalidate();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public void setLargeModel(boolean bl) {
        boolean bl2 = this.largeModel;
        this.largeModel = bl;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, bl2, bl);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isPathEditable(TreePath treePath) {
        return this.isEditable();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            TreePath treePath;
            Object object;
            Component component;
            Point point = mouseEvent.getPoint();
            int n = this.getRowForLocation(point.x, point.y);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (n != -1 && treeCellRenderer != null && (component = treeCellRenderer.getTreeCellRendererComponent(this, object = (treePath = this.getPathForRow(n)).getLastPathComponent(), this.isRowSelected(n), this.isExpanded(n), this.getModel().isLeaf(object), n, true)) instanceof JComponent) {
                Rectangle rectangle = this.getPathBounds(treePath);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        return null;
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int getRowCount() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowCount();
        }
        return 0;
    }

    public void setSelectionPath(TreePath treePath) {
        this.getSelectionModel().setSelectionPath(treePath);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().setSelectionPaths(treePathArray);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void setSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.setSelectionRows(nArray);
    }

    public void setSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                treePathArray[n2] = treeUI.getPathForRow(nArray[n2]);
                ++n2;
            }
            this.setSelectionPaths(treePathArray);
        }
    }

    public void addSelectionPath(TreePath treePath) {
        this.getSelectionModel().addSelectionPath(treePath);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().addSelectionPaths(treePathArray);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void addSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.addSelectionRows(nArray);
    }

    public void addSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                treePathArray[n2] = treeUI.getPathForRow(nArray[n2]);
                ++n2;
            }
            this.addSelectionPaths(treePathArray);
        }
    }

    public Object getLastSelectedPathComponent() {
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    public TreePath getSelectionPath() {
        return this.getSelectionModel().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.getSelectionModel().getSelectionRows();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public int getMinSelectionRow() {
        return this.getSelectionModel().getMinSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.getSelectionModel().getMaxSelectionRow();
    }

    public int getLeadSelectionRow() {
        return this.getSelectionModel().getLeadSelectionRow();
    }

    public TreePath getLeadSelectionPath() {
        return this.getSelectionModel().getLeadSelectionPath();
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.getSelectionModel().isPathSelected(treePath);
    }

    public boolean isRowSelected(int n) {
        return this.getSelectionModel().isRowSelected(n);
    }

    public boolean isExpanded(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isExpanded(treePath);
        }
        return false;
    }

    public boolean isExpanded(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isExpanded(n);
        }
        return false;
    }

    public boolean isCollapsed(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isCollapsed(treePath);
        }
        return false;
    }

    public boolean isCollapsed(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isCollapsed(n);
        }
        return false;
    }

    public void makeVisible(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.makeVisible(treePath);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public boolean isVisible(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isVisible(treePath);
        }
        return false;
    }

    public Rectangle getPathBounds(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathBounds(treePath);
        }
        return null;
    }

    public Rectangle getRowBounds(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowBounds(n);
        }
        return null;
    }

    public void scrollPathToVisible(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.scrollPathToVisible(treePath);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public void scrollRowToVisible(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.scrollRowToVisible(n);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public TreePath getPathForRow(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathForRow(n);
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowForPath(treePath);
        }
        return -1;
    }

    public void expandPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.expandPath(treePath);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public void expandRow(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.expandRow(n);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public void collapsePath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.collapsePath(treePath);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public void collapseRow(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.collapseRow(n);
            if (this.accessibleContext != null) {
                ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }
    }

    public TreePath getPathForLocation(int n, int n2) {
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null) {
            Rectangle rectangle = this.getPathBounds(treePath);
            if (n >= rectangle.x && n < rectangle.x + rectangle.width && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                return treePath;
            }
        }
        return null;
    }

    public int getRowForLocation(int n, int n2) {
        int n3 = this.getClosestRowForLocation(n, n2);
        if (n3 != -1) {
            Rectangle rectangle = this.getRowBounds(n3);
            if (n >= rectangle.x && n < rectangle.x + rectangle.width && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                return n3;
            }
        }
        return -1;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestPathForLocation(n, n2);
        }
        return null;
    }

    public int getClosestRowForLocation(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestRowForLocation(n, n2);
        }
        return -1;
    }

    public boolean isEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isEditing();
        }
        return false;
    }

    public boolean stopEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.stopEditing();
        }
        return false;
    }

    public void startEditingAtPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.startEditingAtPath(treePath);
        }
    }

    public TreePath getEditingPath() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getEditingPath();
        }
        return null;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel == null) {
            treeSelectionModel = EmptySelectionModel.sharedInstance();
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        this.selectionModel = treeSelectionModel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, this.selectionModel);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected TreePath[] getPathBetweenRows(int n, int n2) {
        TreeUI treeUI = this.getUI();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (treeUI != null) {
            TreePath[] treePathArray = new TreePath[n4 - n3 + 1];
            int n5 = n3;
            while (n5 <= n4) {
                treePathArray[n5 - n3] = treeUI.getPathForRow(n5);
                ++n5;
            }
            return treePathArray;
        }
        return null;
    }

    public void setSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().setSelectionPaths(treePathArray);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void addSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().addSelectionPaths(treePathArray);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void removeSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().removeSelectionPaths(treePathArray);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        this.getSelectionModel().removeSelectionPath(treePath);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().removeSelectionPaths(treePathArray);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public void removeSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.removeSelectionRows(nArray);
    }

    public void removeSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                treePathArray[n2] = treeUI.getPathForRow(nArray[n2]);
                ++n2;
            }
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireSelectionPropertyChange();
        }
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.add(class$com$sun$java$swing$event$TreeExpansionListener != null ? class$com$sun$java$swing$event$TreeExpansionListener : (class$com$sun$java$swing$event$TreeExpansionListener = JComponent.class$("com.sun.java.swing.event.TreeExpansionListener")), treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$TreeExpansionListener != null ? class$com$sun$java$swing$event$TreeExpansionListener : (class$com$sun$java$swing$event$TreeExpansionListener = JComponent.class$("com.sun.java.swing.event.TreeExpansionListener")), treeExpansionListener);
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeExpansionListener != null ? class$com$sun$java$swing$event$TreeExpansionListener : JComponent.class$("com.sun.java.swing.event.TreeExpansionListener"))) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeExpansionListener)objectArray[n + 1]).treeExpanded(treeExpansionEvent);
            }
            n -= 2;
        }
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeExpansionListener != null ? class$com$sun$java$swing$event$TreeExpansionListener : JComponent.class$("com.sun.java.swing.event.TreeExpansionListener"))) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeExpansionListener)objectArray[n + 1]).treeCollapsed(treeExpansionEvent);
            }
            n -= 2;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : (class$com$sun$java$swing$event$TreeSelectionListener = JComponent.class$("com.sun.java.swing.event.TreeSelectionListener")), treeSelectionListener);
        if (this.listenerList.getListenerCount(class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : (class$com$sun$java$swing$event$TreeSelectionListener = JComponent.class$("com.sun.java.swing.event.TreeSelectionListener"))) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : (class$com$sun$java$swing$event$TreeSelectionListener = JComponent.class$("com.sun.java.swing.event.TreeSelectionListener")), treeSelectionListener);
        if (this.listenerList.getListenerCount(class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : (class$com$sun$java$swing$event$TreeSelectionListener = JComponent.class$("com.sun.java.swing.event.TreeSelectionListener"))) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : JComponent.class$("com.sun.java.swing.event.TreeSelectionListener"))) {
                ((TreeSelectionListener)objectArray[n + 1]).valueChanged(treeSelectionEvent);
            }
            n -= 2;
        }
    }

    public void treeDidChange() {
        this.revalidate();
        this.repaint();
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = n;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, n2, this.visibleRowCount);
        this.invalidate();
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.cellRenderer != null && this.cellRenderer instanceof Serializable) {
            vector.addElement(CELL_RENDERER_PROPERTY);
            vector.addElement(this.cellRenderer);
        }
        if (this.cellEditor != null && this.cellEditor instanceof Serializable) {
            vector.addElement(CELL_EDITOR_PROPERTY);
            vector.addElement(this.cellEditor);
        }
        if (this.treeModel != null && this.treeModel instanceof Serializable) {
            vector.addElement(TREE_MODEL_PROPERTY);
            vector.addElement(this.treeModel);
        }
        if (this.selectionModel != null && this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals(CELL_RENDERER_PROPERTY)) {
            this.cellRenderer = (TreeCellRenderer)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(CELL_EDITOR_PROPERTY)) {
            this.cellEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(TREE_MODEL_PROPERTY)) {
            this.treeModel = (TreeModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (TreeSelectionModel)vector.elementAt(++n);
            ++n;
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        TreeUI treeUI;
        int n = this.getPreferredSize().width;
        int n2 = this.getVisibleRowCount();
        int n3 = this.isFixedRowHeight() ? n2 * this.getRowHeight() : ((treeUI = this.getUI()) != null && treeUI.getRowCount() > 0 ? this.getRowBounds((int)0).height * n2 : 16 * n2);
        return new Dimension(n, n3);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = this.getClosestRowForLocation(0, rectangle.y);
            if (n3 != -1) {
                Rectangle rectangle2 = this.getRowBounds(n3);
                if (rectangle2.y != rectangle.y) {
                    if (n2 < 0) {
                        return rectangle.y - rectangle2.y;
                    }
                    return rectangle2.y + rectangle2.height - rectangle.y;
                }
                if (n2 < 0) {
                    if (n3 != 0) {
                        rectangle2 = this.getRowBounds(n3 - 1);
                        return rectangle2.height;
                    }
                } else {
                    return rectangle2.height;
                }
            }
            return 0;
        }
        return 4;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTree();
        }
        return this.accessibleContext;
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }

        EmptySelectionModel() {
        }
    }

    protected class TreeSelectionRedirector
    implements Serializable,
    TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(JTree.this);
            JTree.this.fireValueChanged(treeSelectionEvent2);
        }

        TreeSelectionRedirector() {
            JTree.this = JTree.this;
        }
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasChildren;
        protected Object childValue;
        protected boolean loadedChildren = false;

        public static void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(vector.elementAt(n), vector.elementAt(n)));
                    ++n;
                }
                return;
            }
            if (object instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)object;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(k, hashtable.get(k)));
                }
                return;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = 0;
                int n3 = objectArray.length;
                while (n < n3) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(objectArray[n], objectArray[n]));
                    ++n;
                }
            }
        }

        public DynamicUtilTreeNode(Object object, Object object2) {
            super(object);
            this.childValue = object2;
            if (object2 != null) {
                if (object2 instanceof Vector) {
                    this.setAllowsChildren(true);
                    return;
                }
                if (object2 instanceof Hashtable) {
                    this.setAllowsChildren(true);
                    return;
                }
                if (object2 instanceof Object[]) {
                    this.setAllowsChildren(true);
                    return;
                }
                this.setAllowsChildren(false);
                return;
            }
            this.setAllowsChildren(false);
        }

        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicUtilTreeNode.createChildren(this, this.childValue);
        }
    }

    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeModelListener,
    TreeExpansionListener {
        public AccessibleJTree() {
            JTree.this = JTree.this;
            JTree.this.getModel().addTreeModelListener(this);
            JTree.this.addTreeExpansionListener(this);
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public void fireSelectionPropertyChange() {
            this.fireVisibleDataPropertyChange();
            this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component instanceof Accessible) {
                return ((Accessible)((Object)component)).getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            TreeModel treeModel = JTree.this.getModel();
            TreePath treePath = new TreePath(treeModel.getRoot());
            if (JTree.this.isVisible(treePath)) {
                TreeCellRenderer treeCellRenderer = JTree.this.getCellRenderer();
                TreeUI treeUI = JTree.this.getUI();
                if (treeUI != null) {
                    int n = treeUI.getRowForPath(treePath);
                    boolean bl = JTree.this.isPathSelected(treePath);
                    boolean bl2 = JTree.this.isExpanded(treePath);
                    boolean bl3 = false;
                    return treeCellRenderer.getTreeCellRendererComponent(JTree.this, treeModel.getRoot(), bl, bl2, treeModel.isLeaf(treeModel.getRoot()), n, bl3);
                }
            }
            return null;
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                String string = accessibleContext.getAccessibleName();
                if (string != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                return null;
            }
            if (this.accessibleName != null && this.accessibleName != "") {
                return this.accessibleName;
            }
            return null;
        }

        public String getAccessibleDescription() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleDescription();
            }
            return super.getAccessibleDescription();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public Accessible getAccessibleAt(Point point) {
            TreePath treePath = JTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                return treeModel.getChildCount(treeModel.getRoot());
            }
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                if (n < 0 || n >= treeModel.getChildCount(treeModel.getRoot())) {
                    return null;
                }
                Object object = treeModel.getChild(treeModel.getRoot(), n);
                Object[] objectArray = new Object[]{treeModel.getRoot(), object};
                TreePath treePath = new TreePath(objectArray);
                return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
            }
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return JTree.this.getSelectionCount();
        }

        public Accessible getAccessibleSelection(int n) {
            TreePath[] treePathArray = JTree.this.getSelectionPaths();
            if (n < 0 || n >= treePathArray.length) {
                return null;
            }
            return new AccessibleJTreeNode(JTree.this, treePathArray[n], JTree.this);
        }

        public boolean isAccessibleChildSelected(int n) {
            TreePath[] treePathArray = JTree.this.getSelectionPaths();
            TreeModel treeModel = JTree.this.getModel();
            int n2 = 0;
            while (n2 < treePathArray.length) {
                Object object = treePathArray[n2].getLastPathComponent();
                if (n == treeModel.getIndexOfChild(treeModel.getRoot(), object)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void addAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null && n >= 0 && n < treeModel.getChildCount(treeModel.getRoot())) {
                Object object = treeModel.getChild(treeModel.getRoot(), n);
                Object[] objectArray = new Object[]{treeModel.getRoot(), object};
                TreePath treePath = new TreePath(objectArray);
                JTree.this.addSelectionPath(treePath);
            }
        }

        public void removeAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null && n >= 0 && n < treeModel.getChildCount(treeModel.getRoot())) {
                Object object = treeModel.getChild(treeModel.getRoot(), n);
                Object[] objectArray = new Object[]{treeModel.getRoot(), object};
                TreePath treePath = new TreePath(objectArray);
                JTree.this.removeSelectionPath(treePath);
            }
        }

        public void clearAccessibleSelection() {
            int n = this.getAccessibleChildrenCount();
            int n2 = 0;
            while (n2 < n) {
                this.removeAccessibleSelection(n2);
                ++n2;
            }
        }

        public void selectAllAccessibleSelection() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                JTree.this.addSelectionInterval(0, treeModel.getChildCount(treeModel.getRoot()) - 1);
            }
        }

        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree;
            private TreeModel treeModel;
            private Object obj;
            private Object objParent;
            private TreePath path;
            private Accessible accessibleParent;
            private int index = -1;
            private boolean isLeaf = false;

            public AccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
                AccessibleJTree.this = AccessibleJTree.this;
                this.tree = jTree;
                this.path = treePath;
                this.accessibleParent = accessible;
                this.treeModel = jTree.getModel();
                this.obj = treePath.getLastPathComponent();
                Object[] objectArray = treePath.getPath();
                if (objectArray.length > 1) {
                    this.objParent = objectArray[objectArray.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(this.objParent, this.obj);
                    }
                    Object[] objectArray2 = new Object[objectArray.length - 1];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
                    new TreePath(objectArray2);
                    this.setAccessibleParent(this.accessibleParent);
                } else if (this.treeModel != null) {
                    this.index = this.treeModel.getIndexOfChild(this.treeModel.getRoot(), this.obj);
                    this.setAccessibleParent(this.tree);
                }
                if (this.treeModel != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }

            private TreePath getChildTreePath(int n) {
                if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                return new TreePath(objectArray2);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getCurrentComponent();
                if (component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                if (this.tree.isVisible(this.path)) {
                    TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                    TreeUI treeUI = this.tree.getUI();
                    if (treeUI != null) {
                        int n = treeUI.getRowForPath(this.path);
                        boolean bl = this.tree.isPathSelected(this.path);
                        boolean bl2 = this.tree.isExpanded(this.path);
                        boolean bl3 = false;
                        return treeCellRenderer.getTreeCellRendererComponent(this.tree, this.obj, bl, bl2, this.isLeaf, n, bl3);
                    }
                }
                return null;
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    String string = accessibleContext.getAccessibleName();
                    if (string != null && string != "") {
                        return accessibleContext.getAccessibleName();
                    }
                    return null;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                    return;
                }
                super.setAccessibleName(string);
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                    return;
                }
                super.setAccessibleDescription(string);
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                if (this.tree.isPathSelected(this.path)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (!this.isLeaf) {
                    accessibleStateSet.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.path)) {
                    accessibleStateSet.add(AccessibleState.EXPANDED);
                } else {
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    accessibleStateSet.add(AccessibleState.EDITABLE);
                }
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                return this.accessibleParent;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                return this.treeModel.getChildCount(this.obj);
            }

            public Accessible getAccessibleChild(int n) {
                if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                TreePath treePath = new TreePath(objectArray2);
                return new AccessibleJTreeNode(JTree.this, treePath, this);
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return this.tree.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                    return;
                }
                super.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                    return;
                }
                super.removePropertyChangeListener(propertyChangeListener);
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && this.isLeaf) {
                    return this.getCurrentAccessibleContext().getAccessibleSelection();
                }
                return this;
            }

            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleText();
                }
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleValue();
                }
                return null;
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }

            public boolean isVisible() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Rectangle rectangle2 = this.tree.getVisibleRect();
                return rectangle != null && rectangle2 != null && rectangle2.intersects(rectangle);
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                return this.tree.isShowing() && this.isVisible();
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.tree != null) {
                    Point point = this.tree.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            protected Point getLocationInJTree() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public Point getLocation() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Accessible accessible = this.getAccessibleParent();
                if (accessible != null && accessible instanceof AccessibleJTreeNode) {
                    Point point = ((AccessibleJTreeNode)accessible).getLocationInJTree();
                    if (point != null && rectangle != null) {
                        rectangle.translate(-point.x, -point.y);
                    } else {
                        return null;
                    }
                }
                return rectangle;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBounds(rectangle);
                }
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }

            public int getAccessibleSelectionCount() {
                int n = 0;
                int n2 = this.getAccessibleChildrenCount();
                int n3 = 0;
                while (n3 < n2) {
                    TreePath treePath = this.getChildTreePath(n3);
                    if (this.tree.isPathSelected(treePath)) {
                        ++n;
                    }
                    ++n3;
                }
                return n;
            }

            public Accessible getAccessibleSelection(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2 && n >= n3) {
                    TreePath treePath = this.getChildTreePath(n4);
                    if (this.tree.isPathSelected(treePath)) {
                        if (n3 == n) {
                            return new AccessibleJTreeNode(this.tree, treePath, this);
                        }
                        ++n3;
                    }
                    ++n4;
                }
                return null;
            }

            public boolean isAccessibleChildSelected(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return false;
                }
                TreePath treePath = this.getChildTreePath(n);
                return this.tree.isPathSelected(treePath);
            }

            public void addAccessibleSelection(int n) {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n);
                    JTree.this.addSelectionPath(treePath);
                }
            }

            public void removeAccessibleSelection(int n) {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n);
                    JTree.this.removeSelectionPath(treePath);
                }
            }

            public void clearAccessibleSelection() {
                int n = this.getAccessibleChildrenCount();
                int n2 = 0;
                while (n2 < n) {
                    this.removeAccessibleSelection(n2);
                    ++n2;
                }
            }

            public void selectAllAccessibleSelection() {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null) {
                    int n = this.getAccessibleChildrenCount();
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath treePath = this.getChildTreePath(n2);
                        JTree.this.addSelectionPath(treePath);
                        ++n2;
                    }
                }
            }

            public int getAccessibleActionCount() {
                AccessibleAction accessibleAction;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
                }
                if (this.isLeaf) {
                    return 0;
                }
                return 1;
            }

            public String getAccessibleActionDescription(int n) {
                AccessibleAction accessibleAction;
                if (n < 0 || n >= this.getAccessibleActionCount()) {
                    return null;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n == 0) {
                    return "toggle expand";
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionDescription(n - 1);
                }
                return null;
            }

            public boolean doAccessibleAction(int n) {
                AccessibleAction accessibleAction;
                if (n < 0 || n >= this.getAccessibleActionCount()) {
                    return false;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n == 0) {
                    if (JTree.this.isExpanded(this.path)) {
                        JTree.this.collapsePath(this.path);
                    } else {
                        JTree.this.expandPath(this.path);
                    }
                    return true;
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.doAccessibleAction(n - 1);
                }
                return false;
            }
        }
    }
}

