/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.SwingUtilities;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class KeyStroke
implements Serializable {
    private static final Object pressedCharCacheKey = new StringBuffer("KeyStroke.pressedCharCacheKey");
    private static final Object releasedCharCacheKey = new StringBuffer("KeyStroke.releasedCharCacheKey");
    private static final Object pressedCodeCacheKey = new StringBuffer("KeyStroke.pressedCodeCacheKey");
    private static final Object releasedCodeCacheKey = new StringBuffer("KeyStroke.releasedCodeCacheKey");
    char keyChar;
    int keyCode;
    int modifiers;
    boolean onKeyRelease;
    static final int MIN_ASCII_CACHE_INDEX = 10;
    static final int MAX_ASCII_CACHE_INDEX = 127;
    static /* synthetic */ Class class$com$sun$java$swing$KeyStroke;

    private KeyStroke() {
    }

    static KeyStroke getCachedKeyCharKeyStroke(char c, boolean bl) {
        KeyStroke keyStroke = null;
        if (c >= '\n' && c < '\u007f') {
            Class clazz = class$com$sun$java$swing$KeyStroke != null ? class$com$sun$java$swing$KeyStroke : (class$com$sun$java$swing$KeyStroke = KeyStroke.class$("com.sun.java.swing.KeyStroke"));
            synchronized (clazz) {
                KeyStroke[] keyStrokeArray = bl ? (KeyStroke[])SwingUtilities.appContextGet(releasedCharCacheKey) : (KeyStroke[])SwingUtilities.appContextGet(pressedCharCacheKey);
                if (keyStrokeArray != null) {
                    keyStroke = keyStrokeArray[c - 10];
                }
            }
        }
        return keyStroke;
    }

    static void cacheKeyCharKeyStroke(KeyStroke keyStroke, boolean bl) {
        if (keyStroke.keyChar >= '\n' && keyStroke.keyChar < '\u007f') {
            Class clazz = class$com$sun$java$swing$KeyStroke != null ? class$com$sun$java$swing$KeyStroke : (class$com$sun$java$swing$KeyStroke = KeyStroke.class$("com.sun.java.swing.KeyStroke"));
            synchronized (clazz) {
                if (bl) {
                    KeyStroke[] keyStrokeArray = (KeyStroke[])SwingUtilities.appContextGet(releasedCharCacheKey);
                    if (keyStrokeArray == null) {
                        keyStrokeArray = new KeyStroke[117];
                        SwingUtilities.appContextPut(releasedCharCacheKey, keyStrokeArray);
                    }
                    keyStrokeArray[keyStroke.keyChar - 10] = keyStroke;
                } else {
                    KeyStroke[] keyStrokeArray = (KeyStroke[])SwingUtilities.appContextGet(pressedCharCacheKey);
                    if (keyStrokeArray == null) {
                        keyStrokeArray = new KeyStroke[117];
                        SwingUtilities.appContextPut(pressedCharCacheKey, keyStrokeArray);
                    }
                    keyStrokeArray[keyStroke.keyChar - 10] = keyStroke;
                }
                return;
            }
        }
    }

    static int subIndexForModifier(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 8) {
            return 3;
        }
        return -1;
    }

    static KeyStroke getCachedKeyStroke(int n, int n2, boolean bl) {
        int n3;
        KeyStroke keyStroke = null;
        if (n >= 10 && n < 127 && (n3 = KeyStroke.subIndexForModifier(n2)) != -1) {
            Class clazz = class$com$sun$java$swing$KeyStroke != null ? class$com$sun$java$swing$KeyStroke : (class$com$sun$java$swing$KeyStroke = KeyStroke.class$("com.sun.java.swing.KeyStroke"));
            synchronized (clazz) {
                KeyStroke[][] keyStrokeArray = bl ? (KeyStroke[][])SwingUtilities.appContextGet(pressedCodeCacheKey) : (KeyStroke[][])SwingUtilities.appContextGet(releasedCodeCacheKey);
                if (keyStrokeArray != null) {
                    keyStroke = keyStrokeArray[n3][n - 10];
                }
            }
        }
        return keyStroke;
    }

    static void cacheKeyStroke(KeyStroke keyStroke) {
        int n = -1;
        if (keyStroke.keyCode >= 10 && keyStroke.keyCode < 127 && (n = KeyStroke.subIndexForModifier(keyStroke.modifiers)) != -1) {
            Class clazz = class$com$sun$java$swing$KeyStroke != null ? class$com$sun$java$swing$KeyStroke : (class$com$sun$java$swing$KeyStroke = KeyStroke.class$("com.sun.java.swing.KeyStroke"));
            synchronized (clazz) {
                KeyStroke[][] keyStrokeArray = null;
                if (keyStroke.onKeyRelease) {
                    KeyStroke[][] keyStrokeArray2 = (KeyStroke[][])SwingUtilities.appContextGet(pressedCodeCacheKey);
                    if (keyStrokeArray2 == null) {
                        keyStrokeArray2 = new KeyStroke[4][117];
                        SwingUtilities.appContextPut(pressedCodeCacheKey, keyStrokeArray2);
                    }
                    keyStrokeArray = keyStrokeArray2;
                } else {
                    KeyStroke[][] keyStrokeArray3 = (KeyStroke[][])SwingUtilities.appContextGet(releasedCodeCacheKey);
                    if (keyStrokeArray3 == null) {
                        keyStrokeArray3 = new KeyStroke[4][117];
                        SwingUtilities.appContextPut(releasedCodeCacheKey, keyStrokeArray3);
                    }
                    keyStrokeArray = keyStrokeArray3;
                }
                keyStrokeArray[n][keyStroke.keyCode - 10] = keyStroke;
                return;
            }
        }
    }

    public static KeyStroke getKeyStroke(char c) {
        return KeyStroke.getKeyStroke(c, false);
    }

    public static KeyStroke getKeyStroke(char c, boolean bl) {
        KeyStroke keyStroke = KeyStroke.getCachedKeyCharKeyStroke(c, bl);
        if (keyStroke == null) {
            keyStroke = new KeyStroke();
            keyStroke.keyChar = c;
            keyStroke.modifiers = 0;
            keyStroke.onKeyRelease = bl;
            KeyStroke.cacheKeyCharKeyStroke(keyStroke, bl);
        }
        return keyStroke;
    }

    public static KeyStroke getKeyStroke(int n, int n2, boolean bl) {
        KeyStroke keyStroke = KeyStroke.getCachedKeyStroke(n, n2, bl);
        if (keyStroke == null) {
            keyStroke = new KeyStroke();
            keyStroke.keyCode = n;
            keyStroke.modifiers = n2;
            keyStroke.onKeyRelease = bl;
            KeyStroke.cacheKeyStroke(keyStroke);
        }
        return keyStroke;
    }

    public static KeyStroke getKeyStroke(int n, int n2) {
        return KeyStroke.getKeyStroke(n, n2, false);
    }

    public static KeyStroke getKeyStrokeForEvent(KeyEvent keyEvent) {
        KeyStroke keyStroke = null;
        switch (keyEvent.getID()) {
            case 401: {
                keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), false);
                break;
            }
            case 402: {
                keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), true);
                break;
            }
            case 400: {
                keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyChar());
                break;
            }
        }
        return keyStroke;
    }

    public static KeyStroke getKeyStroke(String string) {
        return null;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isOnKeyRelease() {
        return this.onKeyRelease;
    }

    private static String getStringRepresentation(char c, int n, boolean bl) {
        return "keyChar " + KeyEvent.getKeyModifiersText(n) + c + (bl ? "-R" : "-P");
    }

    private static String getStringRepresentation(int n, int n2, boolean bl) {
        return "keyCode " + KeyEvent.getKeyModifiersText(n2) + KeyEvent.getKeyText(n) + (bl ? "-R" : "-P");
    }

    public int hashCode() {
        return (this.keyChar + '\u0001') * (2 * (this.keyCode + 1)) * (this.modifiers + 1) + (this.onKeyRelease ? 1 : 2);
    }

    public boolean equals(Object object) {
        if (object instanceof KeyStroke) {
            KeyStroke keyStroke = (KeyStroke)object;
            if (keyStroke.keyChar == this.keyChar && keyStroke.keyCode == this.keyCode && keyStroke.onKeyRelease == this.onKeyRelease && keyStroke.modifiers == this.modifiers) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.keyChar == '\u0000') {
            return KeyStroke.getStringRepresentation(this.keyCode, this.modifiers, this.onKeyRelease);
        }
        return KeyStroke.getStringRepresentation(this.keyChar, 0, this.onKeyRelease);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

