/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.SystemEventQueueUtilities;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RepaintManager {
    Hashtable dirtyComponents = new Hashtable();
    Vector invalidComponents;
    boolean doubleBufferingEnabled = true;
    Image doubleBuffer;
    Dimension doubleBufferMaxSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static final Object repaintManagerKey = class$com$sun$java$swing$RepaintManager != null ? class$com$sun$java$swing$RepaintManager : (class$com$sun$java$swing$RepaintManager = RepaintManager.class$("com.sun.java.swing.RepaintManager"));
    static /* synthetic */ Class class$com$sun$java$swing$RepaintManager;

    public static RepaintManager currentManager(Component component) {
        RepaintManager repaintManager = (RepaintManager)SwingUtilities.appContextGet(repaintManagerKey);
        if (repaintManager == null) {
            repaintManager = new RepaintManager();
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (repaintManager != null) {
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
            return;
        }
        SwingUtilities.appContextRemove(repaintManagerKey);
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Component component = null;
        Container container = jComponent;
        while (container != null) {
            if (container instanceof CellRendererPane || container.getPeer() == null) {
                return;
            }
            if (container instanceof JComponent && container.isValidateRoot()) {
                component = container;
                break;
            }
            container = container.getParent();
        }
        if (component == null) {
            return;
        }
        Component component2 = null;
        Component component3 = component;
        while (component3 != null) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (component3 instanceof Window || component3 instanceof Applet) {
                component2 = component3;
                break;
            }
            component3 = component3.getParent();
        }
        if (component2 == null) {
            return;
        }
        if (this.invalidComponents == null) {
            this.invalidComponents = new Vector();
        } else {
            int n = this.invalidComponents.size();
            int n2 = 0;
            while (n2 < n) {
                if (component == (Component)this.invalidComponents.elementAt(n2)) {
                    return;
                }
                ++n2;
            }
        }
        this.invalidComponents.addElement(component);
        SystemEventQueueUtilities.queueComponentWorkRequest(component2);
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        int n;
        if (this.invalidComponents != null && (n = this.invalidComponents.indexOf(jComponent)) != -1) {
            this.invalidComponents.removeElementAt(n);
        }
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0 || jComponent == null) {
            return;
        }
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        JComponent jComponent2 = null;
        Container container = jComponent;
        while (container != null) {
            if (!container.isVisible() || container.getPeer() == null) {
                return;
            }
            if (container instanceof Window || container instanceof Applet) {
                jComponent2 = container;
                break;
            }
            container = container.getParent();
        }
        if (this.dirtyComponents == null) {
            this.dirtyComponents = new Hashtable();
            this.dirtyComponents.put(jComponent, new Rectangle(n, n2, n3, n4));
        } else {
            Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
            if (rectangle == null) {
                this.dirtyComponents.put(jComponent, new Rectangle(n, n2, n3, n4));
            } else {
                SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            }
        }
        SystemEventQueueUtilities.queueComponentWorkRequest(jComponent2);
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = null;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.dirtyComponents != null) {
                rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
            }
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(rectangle);
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.dirtyComponents != null) {
                this.dirtyComponents.remove(jComponent);
            }
            return;
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        return rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE;
    }

    public void validateInvalidComponents() {
        Vector vector;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.invalidComponents == null) {
                Object var3_3 = null;
                return;
            }
            vector = this.invalidComponents;
            this.invalidComponents = null;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Component)vector.elementAt(n2)).validate();
            ++n2;
        }
    }

    public void paintDirtyRegions() {
        JComponent jComponent;
        Hashtable hashtable;
        Object object = this;
        synchronized (object) {
            if (this.dirtyComponents == null) {
                Object var7_2 = null;
                return;
            }
            hashtable = this.dirtyComponents;
            this.dirtyComponents = null;
        }
        int n = hashtable.size();
        if (n == 0) {
            return;
        }
        Vector vector = new Vector(n);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            jComponent = (JComponent)enumeration.nextElement();
            this.collectDirtyComponents(hashtable, jComponent, vector);
        }
        n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jComponent = (JComponent)vector.elementAt(n2);
            object = (Rectangle)hashtable.get(jComponent);
            Rectangle rectangle = jComponent.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            object = ((Rectangle)object).intersection(rectangle);
            jComponent.paintImmediately(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            ++n2;
        }
    }

    void collectDirtyComponents(Hashtable hashtable, JComponent jComponent, Vector vector) {
        Container container;
        boolean bl = false;
        Container container2 = jComponent;
        Container container3 = container2;
        Rectangle rectangle = jComponent._bounds;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle2 = new Rectangle((Rectangle)hashtable.get(jComponent));
        SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, rectangle2);
        if (rectangle2.isEmpty()) {
            return;
        }
        if (jComponent.isOpaque()) {
            bl = true;
        }
        while ((container = container3.getParent()) != null && container instanceof JComponent) {
            container3 = container;
            if (((JComponent)container3).isOpaque()) {
                bl = true;
            }
            n2 += rectangle.x;
            n4 += rectangle.y;
            rectangle2.setLocation(rectangle2.x + rectangle.x, rectangle2.y + rectangle.y);
            rectangle = ((JComponent)container3)._bounds;
            rectangle2 = SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, rectangle2);
            if (rectangle2.isEmpty()) {
                return;
            }
            if (hashtable.get(container3) == null) continue;
            container2 = container3;
            n = n2;
            n3 = n4;
        }
        if (jComponent != container2) {
            rectangle2.setLocation(rectangle2.x + n - n2, rectangle2.y + n3 - n4);
            Rectangle rectangle3 = (Rectangle)hashtable.get(container2);
            SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle3);
        }
        if (!vector.contains(container2)) {
            vector.addElement(container2);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dirtyComponents != null) {
            stringBuffer.append(String.valueOf(this.dirtyComponents));
        }
        return stringBuffer.toString();
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        int n3 = n > this.doubleBufferMaxSize.width ? this.doubleBufferMaxSize.width : n;
        int n4 = n2 > this.doubleBufferMaxSize.height ? this.doubleBufferMaxSize.height : n2;
        if (this.doubleBuffer != null && (this.doubleBuffer.getWidth(null) < n3 || this.doubleBuffer.getHeight(null) < n4)) {
            this.doubleBuffer = null;
        }
        if (this.doubleBuffer == null) {
            this.doubleBuffer = component.createImage(n3, n4);
        }
        return this.doubleBuffer;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaxSize = dimension;
        if (this.doubleBuffer != null && (this.doubleBuffer.getWidth(null) > dimension.width || this.doubleBuffer.getHeight(null) > dimension.height)) {
            this.doubleBuffer = null;
        }
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaxSize;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
        if (!this.doubleBufferingEnabled) {
            this.doubleBuffer = null;
        }
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

