/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class BasicBorderFactory {
    private static Border toggleButtonBorder;
    private static Border radioButtonBorder;
    private static Border buttonBorder;
    private static Border menuBarBorder;

    public static Border getMenuBarBorder() {
        if (menuBarBorder == null) {
            menuBarBorder = new BasicMenuBarBorder();
        }
        return menuBarBorder;
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BasicButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BasicToggleBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getRadioButtonBorder() {
        if (radioButtonBorder == null) {
            radioButtonBorder = new BasicRadioBorder();
        }
        return radioButtonBorder;
    }

    private static class BasicToggleBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        BasicToggleBorder() {
        }
    }

    private static class BasicRadioBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(graphics, n, n2, n3, n4);
                    return;
                }
                BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, abstractButton.isFocusPainted() && abstractButton.hasFocus());
                return;
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        BasicRadioBorder() {
        }
    }

    private static class BasicButtonBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                boolean bl3 = bl = buttonModel.isPressed() && buttonModel.isArmed();
                if (component instanceof JButton) {
                    bl2 = ((JButton)component).isDefaultButton();
                }
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, bl, bl2);
        }

        public Insets getBorderInsets(Component component) {
            if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                return new Insets(2, 2, 3, 3);
            }
            return new Insets(1, 1, 2, 2);
        }

        BasicButtonBorder() {
        }
    }

    private static class BasicMenuBarBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawGroove(graphics, 0, n4 - 2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 2, 0);
        }

        BasicMenuBarBorder() {
        }
    }
}

