/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.SyntheticImage;
import com.sun.java.swing.plaf.basic.HueLightnessPatch;
import com.sun.java.swing.plaf.basic.ImageComponent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

class ColorWheel
extends ImageComponent
implements AdjustmentListener {
    private static Image img;
    SyntheticImage vSrc;
    int sx;
    int sy;
    private static int cursorWidth;
    HueLightnessPatch hlp;
    Adjustable hue;
    int lastCursorAngle = -1;

    ColorWheel(HueLightnessPatch hueLightnessPatch, Adjustable adjustable) {
        this.hlp = hueLightnessPatch;
        this.hue = adjustable;
        adjustable.setMinimum(0);
        adjustable.setMaximum(359);
        adjustable.addAdjustmentListener(this);
        this.enableEvents(48L);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: 
            case 506: {
                this.moveSel(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
    }

    public void setTheta(double d) {
        this.lastCursorAngle = (int)d;
        this.repaint();
    }

    protected void locateImage() {
        if (img == null) {
            Dimension dimension = this.getSize();
            this.vSrc = new 1(dimension);
            this.setImage(this.getToolkit().createImage(this.vSrc));
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        this.hlp.setColor(Color.HSBtoRGB((float)n / 360.0f, 1.0f, 1.0f));
        this.hlp.propogateColor();
        Graphics graphics = this.getGraphics();
        if (graphics != null && this.isShowing()) {
            this.paintCursor(graphics, this.lastCursorAngle);
            this.lastCursorAngle = n;
            this.paintCursor(graphics, this.lastCursorAngle);
            graphics.dispose();
        }
    }

    private void moveSel(int n, int n2) {
        if (n == this.sx && n2 == this.sy) {
            return;
        }
        this.sx = n;
        this.sy = n2;
        int n3 = this.sx - (this.isize.width >> 1);
        int n4 = this.sy - (this.isize.height >> 1);
        int n5 = (int)(Math.atan2(n3, n4) * 57.29577951308232);
        if (n5 < 0) {
            n5 += 360;
        }
        this.hue.setValue(n5);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintCursor(graphics, this.lastCursorAngle);
    }

    private void paintCursor(Graphics graphics, int n) {
        if (n < 0) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.black);
        int n2 = this.isize.width >> 1;
        int n3 = this.isize.height >> 1;
        int n4 = (int)(Math.sin((double)n * (Math.PI / 180)) * (double)n2);
        int n5 = (int)(Math.cos((double)n * (Math.PI / 180)) * (double)n3);
        graphics.drawArc(n2 + n4 - (n4 >> 3) - (n2 >> 4), n3 + n5 - (n5 >> 3) - (n3 >> 4), n2 >> 3, n2 >> 3, 0, 360);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    static {
        cursorWidth = 3;
    }

    private final class 1
    extends SyntheticImage {
        protected void computeRow(int n, int[] nArray) {
            int n2 = this.width >> 1;
            int n3 = n2 * 3 / 4;
            int n4 = n - n2;
            int n5 = this.width;
            while (--n5 >= 0) {
                int n6 = n5 - n2;
                int n7 = (int)(Math.sqrt((double)(n4 * n4 + n6 * n6 + n6 + n4) + 0.5) + 0.5);
                if (n7 >= n2 || n7 <= n3) {
                    nArray[n5] = 0;
                    continue;
                }
                float f = 1.0f;
                float f2 = 1.0f;
                int n8 = (int)(Math.atan2(n6, n4) * 57.29577951308232);
                if (n8 < 0) {
                    n8 += 360;
                }
                if (n7 >= n2 - 2 || n7 <= n3 + 2) {
                    int n9 = n8 + 315;
                    if (n9 >= 360) {
                        n9 -= 360;
                    }
                    if (n9 >= 180) {
                        n9 = 360 - n9;
                    }
                    n9 -= 90;
                    if (n7 <= n3 + 2) {
                        n9 = -n9;
                    }
                    if (n9 < 0) {
                        f = 1.0f - (float)n9 / -180.0f;
                    } else {
                        f2 = 1.0f - (float)n9 / 120.0f;
                    }
                }
                nArray[n5] = Color.HSBtoRGB((float)n8 / 360.0f, f2, f);
            }
        }

        /* synthetic */ 1(Dimension dimension) {
            this.width = dimension.width;
            this.height = dimension.height;
        }
    }
}

