/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setRequestFocusEnabled(false);
    }

    private Color getColorForCell(int n, int n2) {
        return this.colors[n2 * this.numSwatches.width + n];
    }

    public Color getColorForLocation(int n, int n2) {
        int n3 = n / (this.swatchSize.width + this.gap.width);
        int n4 = n2 / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(n3, n4);
    }

    public Dimension getPreferredSize() {
        int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(n, n2);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
        return String.valueOf(color.getRed()) + ", " + color.getGreen() + ", " + color.getBlue();
    }

    protected void initColors() {
    }

    protected void initValues() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = 0;
        while (n < this.numSwatches.height) {
            int n2 = 0;
            while (n2 < this.numSwatches.width) {
                graphics.setColor(this.getColorForCell(n2, n));
                int n3 = n2 * (this.swatchSize.width + this.gap.width);
                int n4 = n * (this.swatchSize.height + this.gap.height);
                graphics.fillRect(n3, n4, this.swatchSize.width, this.swatchSize.height);
                graphics.setColor(Color.black);
                graphics.drawLine(n3 + this.swatchSize.width - 1, n4, n3 + this.swatchSize.width - 1, n4 + this.swatchSize.height - 1);
                graphics.drawLine(n3, n4 + this.swatchSize.height - 1, n3 + this.swatchSize.width - 1, n4 + this.swatchSize.width - 1);
                ++n2;
            }
            ++n;
        }
    }
}

