/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENSITIVE_SYM = 686,
     SEPARATOR_SYM = 687,
     SERIALIZABLE_SYM = 688,
     SERIAL_SYM = 689,
     SESSION_SYM = 690,
     SET = 691,
     SET_VAR = 692,
     SHARE_SYM = 693,
     SHIFT_LEFT = 694,
     SHIFT_RIGHT = 695,
     SHOW = 696,
     SHUTDOWN = 697,
     SIGNED_SYM = 698,
     SIMPLE_SYM = 699,
     SLAVE = 700,
     SMALLINT = 701,
     SNAPSHOT_SYM = 702,
     SOUNDS_SYM = 703,
     SOURCE_SYM = 704,
     SPATIAL_SYM = 705,
     SPECIFIC_SYM = 706,
     SQLEXCEPTION_SYM = 707,
     SQLSTATE_SYM = 708,
     SQLWARNING_SYM = 709,
     SQL_BIG_RESULT = 710,
     SQL_BUFFER_RESULT = 711,
     SQL_CACHE_SYM = 712,
     SQL_CALC_FOUND_ROWS = 713,
     SQL_NO_CACHE_SYM = 714,
     SQL_SMALL_RESULT = 715,
     SQL_SYM = 716,
     SQL_THREAD = 717,
     SSL_SYM = 718,
     STARTING = 719,
     START_SYM = 720,
     STATUS_SYM = 721,
     STD_SYM = 722,
     STDDEV_SAMP_SYM = 723,
     STOP_SYM = 724,
     STORAGE_SYM = 725,
     STRAIGHT_JOIN = 726,
     STRING_SYM = 727,
     SUBDATE_SYM = 728,
     SUBJECT_SYM = 729,
     SUBSTRING = 730,
     SUBSTRING_INDEX = 731,
     SUM_SYM = 732,
     SUPER_SYM = 733,
     SUSPEND_SYM = 734,
     SWAPS_SYM = 735,
     SWITCHES_SYM = 736,
     SYSDATE = 737,
     TABLES = 738,
     TABLESPACE = 739,
     TABLE_SYM = 740,
     TEMPORARY = 741,
     TEMPTABLE_SYM = 742,
     TERMINATED = 743,
     TEXT_STRING = 744,
     TEXT_SYM = 745,
     TIMESTAMP = 746,
     TIMESTAMP_ADD = 747,
     TIMESTAMP_DIFF = 748,
     TIME_SYM = 749,
     TINYBLOB = 750,
     TINYINT = 751,
     TINYTEXT = 752,
     TO_SYM = 753,
     TRAILING = 754,
     TRANSACTION_SYM = 755,
     TRIGGER_SYM = 756,
     TRIGGERS_SYM = 757,
     TRIM = 758,
     TRUE_SYM = 759,
     TRUNCATE_SYM = 760,
     TYPES_SYM = 761,
     TYPE_SYM = 762,
     UDF_RETURNS_SYM = 763,
     UDF_SONAME_SYM = 764,
     ULONGLONG_NUM = 765,
     UNCOMMITTED_SYM = 766,
     UNDEFINED_SYM = 767,
     UNDERSCORE_CHARSET = 768,
     UNDO_SYM = 769,
     UNICODE_SYM = 770,
     UNION_SYM = 771,
     UNIQUE_SYM = 772,
     UNIQUE_USERS = 773,
     UNIX_TIMESTAMP = 774,
     UNKNOWN_SYM = 775,
     UNLOCK_SYM = 776,
     UNSIGNED = 777,
     UNTIL_SYM = 778,
     UPDATE_SYM = 779,
     UPGRADE_SYM = 780,
     USAGE = 781,
     USER = 782,
     USE_FRM = 783,
     USE_SYM = 784,
     USING = 785,
     UTC_DATE_SYM = 786,
     UTC_TIMESTAMP_SYM = 787,
     UTC_TIME_SYM = 788,
     VAR_SAMP_SYM = 789,
     VALUES = 790,
     VALUE_SYM = 791,
     VARBINARY = 792,
     VARCHAR = 793,
     VARIABLES = 794,
     VARIANCE_SYM = 795,
     VARYING = 796,
     VIEW_SYM = 797,
     WARNINGS = 798,
     WEEK_SYM = 799,
     WHEN_SYM = 800,
     WHERE = 801,
     WHILE_SYM = 802,
     WITH = 803,
     WORK_SYM = 804,
     WRITE_SYM = 805,
     X509_SYM = 806,
     XA_SYM = 807,
     XOR = 808,
     YEARWEEK = 809,
     YEAR_MONTH_SYM = 810,
     YEAR_SYM = 811,
     ZEROFILL = 812,
     TABLE_REF_PRIORITY = 813,
     ELSE = 814,
     THEN_SYM = 815,
     CASE_SYM = 816,
     BETWEEN_SYM = 817,
     NEG = 818
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENSITIVE_SYM 686
#define SEPARATOR_SYM 687
#define SERIALIZABLE_SYM 688
#define SERIAL_SYM 689
#define SESSION_SYM 690
#define SET 691
#define SET_VAR 692
#define SHARE_SYM 693
#define SHIFT_LEFT 694
#define SHIFT_RIGHT 695
#define SHOW 696
#define SHUTDOWN 697
#define SIGNED_SYM 698
#define SIMPLE_SYM 699
#define SLAVE 700
#define SMALLINT 701
#define SNAPSHOT_SYM 702
#define SOUNDS_SYM 703
#define SOURCE_SYM 704
#define SPATIAL_SYM 705
#define SPECIFIC_SYM 706
#define SQLEXCEPTION_SYM 707
#define SQLSTATE_SYM 708
#define SQLWARNING_SYM 709
#define SQL_BIG_RESULT 710
#define SQL_BUFFER_RESULT 711
#define SQL_CACHE_SYM 712
#define SQL_CALC_FOUND_ROWS 713
#define SQL_NO_CACHE_SYM 714
#define SQL_SMALL_RESULT 715
#define SQL_SYM 716
#define SQL_THREAD 717
#define SSL_SYM 718
#define STARTING 719
#define START_SYM 720
#define STATUS_SYM 721
#define STD_SYM 722
#define STDDEV_SAMP_SYM 723
#define STOP_SYM 724
#define STORAGE_SYM 725
#define STRAIGHT_JOIN 726
#define STRING_SYM 727
#define SUBDATE_SYM 728
#define SUBJECT_SYM 729
#define SUBSTRING 730
#define SUBSTRING_INDEX 731
#define SUM_SYM 732
#define SUPER_SYM 733
#define SUSPEND_SYM 734
#define SWAPS_SYM 735
#define SWITCHES_SYM 736
#define SYSDATE 737
#define TABLES 738
#define TABLESPACE 739
#define TABLE_SYM 740
#define TEMPORARY 741
#define TEMPTABLE_SYM 742
#define TERMINATED 743
#define TEXT_STRING 744
#define TEXT_SYM 745
#define TIMESTAMP 746
#define TIMESTAMP_ADD 747
#define TIMESTAMP_DIFF 748
#define TIME_SYM 749
#define TINYBLOB 750
#define TINYINT 751
#define TINYTEXT 752
#define TO_SYM 753
#define TRAILING 754
#define TRANSACTION_SYM 755
#define TRIGGER_SYM 756
#define TRIGGERS_SYM 757
#define TRIM 758
#define TRUE_SYM 759
#define TRUNCATE_SYM 760
#define TYPES_SYM 761
#define TYPE_SYM 762
#define UDF_RETURNS_SYM 763
#define UDF_SONAME_SYM 764
#define ULONGLONG_NUM 765
#define UNCOMMITTED_SYM 766
#define UNDEFINED_SYM 767
#define UNDERSCORE_CHARSET 768
#define UNDO_SYM 769
#define UNICODE_SYM 770
#define UNION_SYM 771
#define UNIQUE_SYM 772
#define UNIQUE_USERS 773
#define UNIX_TIMESTAMP 774
#define UNKNOWN_SYM 775
#define UNLOCK_SYM 776
#define UNSIGNED 777
#define UNTIL_SYM 778
#define UPDATE_SYM 779
#define UPGRADE_SYM 780
#define USAGE 781
#define USER 782
#define USE_FRM 783
#define USE_SYM 784
#define USING 785
#define UTC_DATE_SYM 786
#define UTC_TIMESTAMP_SYM 787
#define UTC_TIME_SYM 788
#define VAR_SAMP_SYM 789
#define VALUES 790
#define VALUE_SYM 791
#define VARBINARY 792
#define VARCHAR 793
#define VARIABLES 794
#define VARIANCE_SYM 795
#define VARYING 796
#define VIEW_SYM 797
#define WARNINGS 798
#define WEEK_SYM 799
#define WHEN_SYM 800
#define WHERE 801
#define WHILE_SYM 802
#define WITH 803
#define WORK_SYM 804
#define WRITE_SYM 805
#define X509_SYM 806
#define XA_SYM 807
#define XOR 808
#define YEARWEEK 809
#define YEAR_MONTH_SYM 810
#define YEAR_SYM 811
#define ZEROFILL 812
#define TABLE_REF_PRIORITY 813
#define ELSE 814
#define THEN_SYM 815
#define CASE_SYM 816
#define BETWEEN_SYM 817
#define NEG 818




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1648 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1663 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  472
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   45186

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  583
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  678
/* YYNRULES -- Number of rules. */
#define YYNRULES  2056
/* YYNRULES -- Number of states. */
#define YYNSTATES  3709

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   818

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   576,     2,     2,     2,   569,   564,     2,
     573,   574,   567,   566,   575,   565,   580,   568,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   582,   581,
       2,     2,     2,     2,   579,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   570,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   577,   563,   578,   571,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   572
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1431,
    1434,  1436,  1441,  1442,  1444,  1445,  1448,  1450,  1454,  1455,
    1462,  1463,  1469,  1470,  1476,  1477,  1483,  1484,  1496,  1497,
    1499,  1500,  1503,  1506,  1508,  1512,  1515,  1519,  1522,  1527,
    1528,  1535,  1536,  1537,  1546,  1551,  1556,  1560,  1564,  1567,
    1570,  1577,  1583,  1587,  1593,  1595,  1597,  1599,  1600,  1602,
    1603,  1605,  1606,  1608,  1610,  1611,  1614,  1616,  1617,  1619,
    1621,  1623,  1624,  1630,  1634,  1635,  1641,  1645,  1649,  1650,
    1654,  1655,  1658,  1660,  1664,  1665,  1667,  1669,  1670,  1673,
    1675,  1679,  1680,  1687,  1688,  1695,  1696,  1702,  1703,  1705,
    1707,  1708,  1715,  1716,  1718,  1720,  1723,  1725,  1727,  1729,
    1730,  1737,  1738,  1744,  1745,  1747,  1749,  1752,  1754,  1756,
    1758,  1760,  1762,  1765,  1766,  1773,  1774,  1776,  1778,  1779,
    1784,  1789,  1793,  1799,  1801,  1805,  1809,  1815,  1817,  1821,
    1824,  1826,  1828,  1829,  1836,  1838,  1842,  1846,  1847,  1850,
    1851,  1856,  1857,  1860,  1862,  1865,  1870,  1873,  1877,  1878,
    1882,  1883,  1884,  1891,  1894,  1896,  1898,  1901,  1904,  1913,
    1918,  1919,  1921,  1924,  1926,  1928,  1930,  1932,  1934,  1936,
    1938,  1940,  1942,  1944,  1946,  1947,  1950,  1955,  1959,  1961,
    1963,  1968,  1969,  1970,  1972,  1974,  1975,  1978,  1981,  1983,
    1985,  1986,  1989,  1990,  1994,  1995,  1999,  2003,  2004,  2008,
    2009,  2013,  2016,  2018,  2022,  2027,  2031,  2036,  2040,  2045,
    2047,  2051,  2056,  2060,  2064,  2071,  2073,  2079,  2086,  2092,
    2100,  2107,  2116,  2122,  2129,  2134,  2139,  2145,  2149,  2154,
    2156,  2160,  2162,  2166,  2168,  2172,  2176,  2178,  2182,  2186,
    2191,  2196,  2198,  2202,  2206,  2210,  2214,  2218,  2220,  2224,
    2226,  2228,  2230,  2232,  2234,  2236,  2238,  2240,  2242,  2244,
    2246,  2248,  2250,  2252,  2254,  2256,  2258,  2261,  2263,  2267,
    2269,  2271,  2273,  2275,  2279,  2282,  2285,  2288,  2291,  2295,
    2299,  2305,  2312,  2317,  2322,  2330,  2335,  2338,  2345,  2351,
    2358,  2365,  2370,  2375,  2379,  2384,  2391,  2400,  2407,  2416,
    2423,  2428,  2435,  2440,  2447,  2452,  2457,  2462,  2467,  2474,
    2483,  2486,  2489,  2494,  2497,  2505,  2513,  2517,  2522,  2527,
    2534,  2541,  2546,  2553,  2560,  2567,  2572,  2579,  2584,  2591,
    2600,  2611,  2624,  2631,  2636,  2643,  2650,  2652,  2659,  2664,
    2673,  2684,  2689,  2691,  2695,  2700,  2707,  2714,  2723,  2730,
    2737,  2742,  2749,  2756,  2765,  2770,  2775,  2782,  2787,  2790,
    2795,  2800,  2805,  2812,  2817,  2822,  2826,  2835,  2842,  2847,
    2854,  2858,  2865,  2874,  2879,  2888,  2895,  2904,  2911,  2920,
    2923,  2928,  2933,  2938,  2945,  2954,  2963,  2968,  2976,  2984,
    2992,  2999,  3006,  3013,  3020,  3027,  3034,  3035,  3041,  3052,
    3056,  3061,  3065,  3068,  3071,  3074,  3079,  3086,  3091,  3096,
    3103,  3110,  3117,  3124,  3129,  3136,  3141,  3148,  3153,  3158,
    3163,  3168,  3175,  3180,  3187,  3192,  3199,  3204,  3209,  3216,
    3221,  3228,  3233,  3240,  3245,  3250,  3257,  3262,  3269,  3270,
    3274,  3278,  3279,  3281,  3282,  3285,  3287,  3291,  3296,  3301,
    3307,  3312,  3317,  3322,  3328,  3333,  3334,  3335,  3343,  3354,
    3359,  3365,  3370,  3376,  3381,  3386,  3391,  3396,  3401,  3407,
    3408,  3417,  3418,  3422,  3426,  3428,  3433,  3434,  3436,  3437,
    3440,  3441,  3443,  3444,  3448,  3451,  3455,  3458,  3460,  3463,
    3465,  3468,  3470,  3472,  3474,  3477,  3478,  3480,  3481,  3484,
    3486,  3490,  3492,  3496,  3497,  3500,  3502,  3506,  3507,  3509,
    3510,  3513,  3518,  3524,  3526,  3528,  3530,  3532,  3536,  3540,
    3544,  3545,  3552,  3553,  3560,  3561,  3570,  3575,  3576,  3585,
    3586,  3597,  3604,  3605,  3614,  3615,  3626,  3633,  3635,  3638,
    3641,  3642,  3647,  3648,  3660,  3664,  3671,  3672,  3676,  3677,
    3678,  3684,  3685,  3687,  3688,  3690,  3691,  3694,  3695,  3698,
    3701,  3704,  3705,  3712,  3713,  3715,  3719,  3721,  3723,  3725,
    3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,  3745,  3747,
    3749,  3751,  3753,  3755,  3757,  3759,  3761,  3763,  3765,  3767,
    3769,  3771,  3773,  3775,  3777,  3779,  3781,  3782,  3784,  3786,
    3787,  3790,  3791,  3793,  3794,  3795,  3799,  3800,  3801,  3805,
    3808,  3809,  3810,  3815,  3820,  3823,  3824,  3827,  3830,  3834,
    3838,  3840,  3843,  3844,  3846,  3847,  3852,  3857,  3860,  3861,
    3863,  3865,  3866,  3868,  3869,  3871,  3874,  3876,  3880,  3884,
    3886,  3888,  3890,  3892,  3893,  3896,  3898,  3900,  3902,  3904,
    3906,  3908,  3910,  3912,  3914,  3916,  3918,  3919,  3920,  3927,
    3928,  3930,  3934,  3936,  3939,  3940,  3943,  3947,  3949,  3952,
    3954,  3955,  3959,  3960,  3966,  3969,  3971,  3972,  3976,  3983,
    3984,  3991,  3996,  4001,  4006,  4011,  4017,  4022,  4024,  4028,
    4030,  4031,  4034,  4035,  4037,  4038,  4039,  4048,  4049,  4050,
    4057,  4058,  4060,  4062,  4064,  4066,  4068,  4071,  4073,  4075,
    4077,  4081,  4086,  4087,  4091,  4095,  4097,  4100,  4103,  4104,
    4108,  4109,  4115,  4119,  4121,  4125,  4127,  4131,  4133,  4135,
    4136,  4138,  4139,  4144,  4145,  4147,  4151,  4153,  4155,  4157,
    4158,  4159,  4166,  4167,  4168,  4180,  4184,  4186,  4190,  4194,
    4196,  4200,  4201,  4203,  4204,  4209,  4210,  4217,  4218,  4224,
    4225,  4232,  4234,  4238,  4242,  4248,  4249,  4252,  4253,  4256,
    4258,  4260,  4262,  4266,  4267,  4269,  4270,  4272,  4274,  4278,
    4280,  4282,  4285,  4288,  4291,  4293,  4295,  4297,  4299,  4300,
    4304,  4305,  4309,  4312,  4317,  4322,  4327,  4332,  4333,  4338,
    4345,  4362,  4365,  4368,  4369,  4376,  4382,  4385,  4388,  4391,
    4393,  4399,  4405,  4408,  4411,  4413,  4418,  4422,  4425,  4428,
    4431,  4435,  4438,  4441,  4444,  4446,  4448,  4452,  4457,  4461,
    4465,  4468,  4471,  4475,  4479,  4483,  4487,  4491,  4495,  4497,
    4499,  4501,  4503,  4504,  4506,  4507,  4510,  4511,  4513,  4515,
    4517,  4518,  4521,  4522,  4525,  4526,  4529,  4532,  4533,  4538,
    4539,  4544,  4546,  4548,  4549,  4551,  4552,  4554,  4556,  4557,
    4562,  4566,  4568,  4569,  4573,  4578,  4581,  4583,  4585,  4587,
    4589,  4591,  4593,  4595,  4597,  4598,  4600,  4601,  4605,  4609,
    4611,  4613,  4615,  4618,  4619,  4623,  4627,  4630,  4633,  4634,
    4639,  4640,  4642,  4644,  4647,  4648,  4653,  4659,  4660,  4661,
    4662,  4663,  4682,  4685,  4686,  4688,  4689,  4691,  4693,  4694,
    4696,  4698,  4699,  4702,  4705,  4707,  4711,  4716,  4720,  4724,
    4725,  4728,  4731,  4733,  4737,  4741,  4742,  4746,  4747,  4751,
    4754,  4758,  4760,  4762,  4765,  4766,  4769,  4771,  4773,  4776,
    4779,  4781,  4783,  4785,  4787,  4789,  4792,  4795,  4797,  4799,
    4801,  4803,  4805,  4807,  4809,  4812,  4815,  4818,  4821,  4824,
    4826,  4828,  4830,  4832,  4834,  4836,  4838,  4842,  4848,  4850,
    4852,  4854,  4856,  4858,  4862,  4867,  4873,  4875,  4881,  4885,
    4888,  4890,  4894,  4897,  4899,  4901,  4903,  4905,  4907,  4909,
    4911,  4913,  4915,  4917,  4919,  4921,  4923,  4925,  4929,  4932,
    4934,  4936,  4938,  4940,  4942,  4944,  4946,  4948,  4950,  4952,
    4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,  4970,  4972,
    4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,  4990,  4992,
    4994,  4996,  4998,  5000,  5002,  5004,  5006,  5008,  5010,  5012,
    5014,  5016,  5018,  5020,  5022,  5024,  5026,  5028,  5030,  5032,
    5034,  5036,  5038,  5040,  5042,  5044,  5046,  5048,  5050,  5052,
    5054,  5056,  5058,  5060,  5062,  5064,  5066,  5068,  5070,  5072,
    5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,
    5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,  5112,
    5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,  5132,
    5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,
    5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,  5172,
    5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,  5192,
    5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,
    5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,  5232,
    5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,
    5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,  5272,
    5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,  5292,
    5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,  5312,
    5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,  5332,
    5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,  5352,
    5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,
    5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,
    5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,
    5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,
    5434,  5436,  5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,
    5454,  5456,  5458,  5459,  5464,  5465,  5467,  5469,  5473,  5474,
    5477,  5479,  5481,  5483,  5485,  5486,  5488,  5489,  5491,  5493,
    5495,  5496,  5499,  5502,  5505,  5507,  5510,  5515,  5521,  5526,
    5533,  5536,  5540,  5544,  5548,  5554,  5556,  5560,  5564,  5567,
    5570,  5573,  5575,  5577,  5582,  5587,  5589,  5591,  5593,  5595,
    5597,  5598,  5603,  5605,  5607,  5609,  5613,  5617,  5619,  5621,
    5624,  5627,  5628,  5632,  5637,  5641,  5642,  5650,  5652,  5655,
    5657,  5659,  5661,  5663,  5665,  5667,  5668,  5674,  5676,  5678,
    5680,  5682,  5684,  5688,  5695,  5702,  5709,  5717,  5721,  5730,
    5739,  5748,  5749,  5751,  5753,  5756,  5757,  5759,  5761,  5765,
    5766,  5770,  5771,  5775,  5776,  5780,  5781,  5785,  5787,  5789,
    5791,  5793,  5795,  5797,  5799,  5801,  5803,  5805,  5807,  5810,
    5813,  5815,  5819,  5822,  5825,  5828,  5831,  5834,  5837,  5840,
    5843,  5844,  5846,  5850,  5852,  5855,  5858,  5861,  5863,  5867,
    5871,  5873,  5875,  5879,  5881,  5885,  5890,  5896,  5898,  5899,
    5903,  5907,  5909,  5911,  5912,  5915,  5918,  5921,  5924,  5925,
    5928,  5931,  5933,  5936,  5939,  5942,  5945,  5948,  5949,  5953,
    5954,  5956,  5957,  5961,  5964,  5965,  5967,  5970,  5971,  5973,
    5978,  5983,  5989,  5992,  5996,  5997,  5999,  6000,  6005,  6006,
    6008,  6010,  6011,  6014,  6017,  6019,  6020,  6022,  6024,  6029,
    6030,  6038,  6040,  6041,  6042,  6045,  6049,  6051,  6053,  6055,
    6056,  6060,  6062,  6065,  6067,  6070,  6074,  6078,  6082,  6083,
    6085,  6086,  6090,  6094,  6095,  6104,  6105,  6109,  6111,  6115,
    6116,  6119,  6123,  6129,  6130,  6134,  6139,  6144,  6145,  6160,
    6161,  6168,  6169,  6170,  6171,  6172,  6185,  6190,  6195,  6199,
    6204,  6208,  6211,  6213,  6217,  6223,  6225,  6227,  6228,  6230,
    6232,  6233,  6236,  6237,  6238,  6242,  6243
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     584,     0,    -1,     3,    -1,   585,     3,    -1,   586,    -1,
    1206,    -1,   784,    -1,   825,    -1,   815,    -1,   621,    -1,
     598,    -1,   827,    -1,   817,    -1,  1212,    -1,   603,    -1,
     587,    -1,  1046,    -1,  1077,    -1,  1002,    -1,  1004,    -1,
     591,    -1,  1083,    -1,  1181,    -1,  1172,    -1,   596,    -1,
    1010,    -1,  1097,    -1,  1101,    -1,  1164,    -1,   832,    -1,
     840,    -1,   844,    -1,   589,    -1,  1093,    -1,  1215,    -1,
     835,    -1,   820,    -1,  1013,    -1,  1089,    -1,   813,    -1,
    1179,    -1,  1213,    -1,  1214,    -1,   852,    -1,  1147,    -1,
    1063,    -1,   802,    -1,   805,    -1,  1057,    -1,  1170,    -1,
    1038,    -1,  1100,    -1,  1253,    -1,   588,   370,  1141,    -1,
     106,    -1,   129,    -1,   370,  1141,   175,   590,    -1,  1138,
      -1,   579,  1143,    -1,    -1,   151,  1141,   592,   593,    -1,
      -1,   530,   594,    -1,   594,   575,   595,    -1,   595,    -1,
     579,  1143,    -1,    -1,   202,   597,  1143,    -1,    -1,    53,
     287,   498,   599,   600,    -1,   601,    -1,   600,   575,   601,
      -1,   274,   145,  1138,    -1,   288,   145,  1138,    -1,   277,
     145,  1138,    -1,   278,   145,   987,    -1,   273,   145,   987,
      -1,   286,   145,   987,    -1,   282,   145,  1138,    -1,   281,
     145,  1138,    -1,   283,   145,  1138,    -1,   284,   145,  1138,
      -1,   285,   145,  1138,    -1,   602,    -1,   275,   145,  1138,
      -1,   276,   145,   988,    -1,   396,   145,  1138,    -1,   397,
     145,   987,    -1,    -1,    87,   701,   485,   704,  1135,   604,
     688,    -1,    -1,    87,   776,   217,  1141,   777,   344,  1135,
     605,   573,   779,   574,    -1,    -1,    87,    94,   704,  1141,
     606,   698,    -1,    -1,    87,   607,  1229,    -1,    87,   527,
     608,  1197,    -1,    -1,  1141,   580,  1141,    -1,  1141,    -1,
     413,   717,   509,  1138,    -1,    -1,    -1,    -1,    -1,    -1,
     573,   611,   626,   574,   612,   413,   613,   728,   614,   617,
     615,   650,    -1,    -1,   616,   618,    -1,    -1,   617,   619,
      -1,    68,  1138,    -1,   241,   461,    -1,   335,   461,    -1,
      80,   461,    -1,   389,   461,    96,    -1,   311,   461,    96,
      -1,   620,    -1,   618,    -1,   121,    -1,   891,   121,    -1,
     461,   429,   112,    -1,   461,   429,   228,    -1,    -1,    48,
     609,   622,   623,    -1,    -1,   573,   624,   574,    -1,    -1,
     625,    -1,   625,   575,   873,    -1,   873,    -1,    -1,   627,
      -1,   627,   575,   629,    -1,   629,    -1,    -1,  1141,   628,
     728,    -1,    -1,   631,    -1,   631,   575,   632,    -1,   632,
      -1,   633,   628,  1141,   728,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   634,   650,   581,    -1,   650,   581,
      -1,   635,   650,   581,    -1,    -1,   636,   637,   581,    -1,
      -1,   109,   648,   638,   728,   649,    -1,   109,  1141,    76,
     172,   645,    -1,    -1,   109,   642,   199,   172,   639,   643,
     650,    -1,   109,  1141,    92,   172,   640,    -1,    -1,   641,
     586,    -1,   153,    -1,    82,    -1,   644,    -1,   643,   575,
     644,    -1,   647,    -1,   987,    -1,   453,   646,  1139,    -1,
      -1,   536,    -1,   645,    -1,  1141,    -1,   454,    -1,   891,
     173,    -1,   452,    -1,  1141,    -1,   648,   575,  1141,    -1,
      -1,   111,   873,    -1,    -1,   651,   586,    -1,    -1,   414,
     652,   873,    -1,    -1,   213,   653,   658,   141,   213,    -1,
     663,    -1,   678,    -1,    -1,   654,   681,    -1,   248,  1142,
      -1,   235,  1142,    -1,   347,  1141,    -1,    -1,   161,   656,
    1141,   226,   655,   657,    -1,    61,  1141,    -1,    -1,   330,
     175,    -1,   175,    -1,  1141,    -1,   657,   575,  1141,    -1,
      -1,    -1,    -1,   659,   873,   560,   660,   635,   661,   662,
      -1,    -1,   135,   658,    -1,   559,   635,    -1,   664,    -1,
     667,    -1,    -1,    -1,   561,   665,   873,   666,   669,   677,
     141,   561,    -1,    -1,   561,   668,   670,   677,   141,   561,
      -1,   671,    -1,   669,   671,    -1,   674,    -1,   670,   674,
      -1,    -1,    -1,   545,   672,   873,   673,   560,   635,    -1,
      -1,    -1,   545,   675,   873,   676,   560,   635,    -1,    -1,
     559,   635,    -1,    -1,  1142,   582,   679,   681,   680,    -1,
      -1,  1142,    -1,    -1,    28,   682,   636,   634,   141,    -1,
     269,   635,   141,   269,    -1,    -1,    -1,   547,   683,   873,
     128,   684,   635,   141,   547,    -1,    -1,   404,   635,   523,
     685,   873,   141,   404,    -1,    27,    -1,     8,    -1,   223,
      -1,   524,    -1,   115,    -1,   573,   689,    -1,   705,   691,
      -1,   252,  1135,    -1,   573,   252,  1135,   574,    -1,   718,
     574,   705,   691,    -1,    -1,   694,   574,   690,  1219,    -1,
      -1,    -1,  1110,   697,   694,   692,  1216,    -1,    -1,  1110,
     697,   573,   694,   574,   693,  1219,    -1,    -1,    -1,   430,
     695,   862,   866,   696,   715,    -1,    -1,    18,    -1,    -1,
     699,    -1,   700,    -1,   699,   700,    -1,   710,    -1,   709,
      -1,    -1,   702,    -1,   703,    -1,   703,   702,    -1,   486,
      -1,    -1,   213,   891,   152,    -1,    -1,   707,    -1,   708,
      -1,   708,   706,    -1,   708,    -1,   708,   707,    -1,   708,
     575,   707,    -1,   143,  1030,   711,    -1,   507,  1030,   711,
      -1,   292,  1030,   988,    -1,   307,  1030,   988,    -1,    24,
    1030,   987,    -1,   361,  1030,  1138,    -1,    68,  1030,  1138,
      -1,    23,  1030,   988,    -1,   358,  1030,   987,    -1,   358,
    1030,   111,    -1,    57,  1030,   987,    -1,   114,  1030,   987,
      -1,   423,  1030,   712,    -1,   387,  1030,   713,    -1,   384,
    1030,   987,    -1,   385,  1030,   987,    -1,   516,  1030,   573,
    1006,   574,    -1,   709,    -1,   710,    -1,   224,  1030,   714,
      -1,    96,   122,  1030,  1138,    -1,   217,   122,  1030,  1138,
      -1,    77,  1030,  1138,    -1,   758,   749,  1030,   751,    -1,
     758,    64,  1030,   757,    -1,  1143,    -1,   111,    -1,   165,
      -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,   386,
      -1,   383,    -1,   987,    -1,   335,    -1,   164,    -1,   243,
      -1,   982,    -1,   861,   865,    -1,    -1,    10,    -1,   472,
      -1,   391,    -1,   108,    -1,   227,    -1,   719,    -1,   718,
     575,   719,    -1,   720,    -1,   721,    -1,   726,   722,    -1,
     726,   763,    -1,   771,   781,   777,   573,   779,   574,    -1,
     724,   772,   781,   777,   573,   779,   574,    -1,   724,   170,
     238,   781,   573,   779,   574,   763,    -1,   725,   722,    -1,
     724,   723,    -1,    -1,   723,    -1,    58,   873,    -1,    -1,
     725,    -1,    79,   781,    -1,    -1,  1134,   727,   728,   745,
      -1,   736,   743,   740,    -1,   737,   744,   740,    -1,   167,
     738,   740,    -1,    37,    -1,    37,   573,   338,   574,    -1,
      42,    -1,    41,    -1,   732,   573,   338,   574,   759,    -1,
     732,   759,    -1,   733,   573,   338,   574,   760,    -1,   733,
     760,    -1,    32,   573,   338,   574,    -1,    32,    -1,   734,
     573,   338,   574,   759,    -1,   735,   573,   338,   574,   760,
      -1,   537,   573,   338,   574,    -1,   556,   743,   740,    -1,
     100,    -1,   494,    -1,   491,   743,    -1,    97,    -1,   495,
      -1,    39,   743,    -1,   731,    -1,   296,    -1,   265,    -1,
     268,   537,    -1,   268,   734,   759,    -1,   497,   759,    -1,
     490,   743,   759,    -1,   298,   759,    -1,   266,   759,    -1,
     108,   738,   740,    -1,   339,   738,   740,    -1,   165,   738,
     740,    -1,    -1,   144,   729,   573,   783,   574,   759,    -1,
      -1,   436,   730,   573,   783,   574,   759,    -1,   268,   759,
      -1,   434,    -1,   187,    -1,   186,    -1,   365,    -1,   318,
      -1,   256,    -1,   317,    -1,   367,    -1,   319,    -1,    56,
      -1,   326,    -1,   323,    56,    -1,   732,   541,    -1,   538,
      -1,   323,   538,    -1,   340,    -1,   326,   538,    -1,   323,
      56,   541,    -1,   326,   541,    -1,   227,    -1,   496,    -1,
     446,    -1,   297,    -1,    31,    -1,   391,    -1,   127,    -1,
     127,   369,    -1,    -1,   573,   338,   574,    -1,   739,    -1,
     573,   338,   575,   338,   574,    -1,    -1,   741,    -1,   741,
     742,    -1,   742,    -1,   443,    -1,   522,    -1,   557,    -1,
      -1,   573,   338,   574,    -1,    -1,   739,    -1,    -1,   746,
      -1,   746,   747,    -1,   747,    -1,   337,    -1,   891,   337,
      -1,   111,   748,    -1,   344,   524,   334,   872,    -1,    23,
      -1,   434,   111,   536,    -1,   762,   238,    -1,   517,    -1,
     517,   238,    -1,    68,  1138,    -1,    64,   755,    -1,   334,
     872,    -1,  1125,    -1,    56,   436,    -1,    55,    -1,  1143,
      -1,    32,    -1,   750,    -1,   111,    -1,    -1,   749,   751,
      -1,  1143,    -1,    32,    -1,   753,    -1,   111,    -1,  1143,
      -1,    -1,    64,   757,    -1,   755,    -1,   111,    -1,    -1,
     111,    -1,    -1,    20,   760,    -1,    46,    -1,   515,   760,
      -1,   749,   750,   760,    -1,    32,   761,    -1,    -1,    32,
      -1,    -1,    20,    -1,   515,    -1,   749,   750,    -1,    -1,
     372,    -1,    -1,   394,  1135,   764,   765,    -1,   767,    -1,
     573,   766,   574,   767,    -1,   766,   575,  1141,    -1,  1141,
      -1,    -1,   768,    -1,   768,   769,    -1,   769,    -1,   344,
     115,   770,    -1,   344,   524,   770,    -1,   289,   177,    -1,
     289,   360,    -1,   289,   444,    -1,   411,    -1,    49,    -1,
     436,   337,    -1,   335,     5,    -1,   436,   111,    -1,   773,
      -1,   178,   774,    -1,   450,   774,    -1,   372,   238,    -1,
     517,   774,    -1,   238,    -1,   217,    -1,    -1,   773,    -1,
     237,    -1,   217,    -1,   216,    -1,    -1,   517,    -1,   178,
      -1,   450,    -1,    -1,   530,   778,    -1,   507,   778,    -1,
      44,    -1,   425,    -1,   200,    -1,   779,   575,   780,   980,
      -1,   780,   980,    -1,  1141,    -1,  1141,   573,   338,   574,
      -1,    -1,  1134,    -1,    -1,   580,  1141,    -1,  1123,    -1,
     783,   575,  1123,    -1,    -1,    13,   798,   485,  1135,   785,
     791,    -1,    -1,    13,    94,   790,   786,   698,    -1,    -1,
      13,   374,   609,   787,   616,    -1,    -1,    13,   179,   609,
     788,   616,    -1,    -1,    13,  1235,  1231,  1236,   542,  1135,
     789,  1239,    18,  1241,  1244,    -1,    -1,  1141,    -1,    -1,
     124,   484,    -1,   215,   484,    -1,   793,    -1,   791,   575,
     793,    -1,     6,   797,    -1,   792,   720,   800,    -1,     6,
     721,    -1,   792,   573,   718,   574,    -1,    -1,    53,   797,
    1134,   794,   726,   800,    -1,    -1,    -1,   312,   797,  1134,
     795,   728,   745,   796,   800,    -1,   129,   797,  1134,   799,
      -1,   129,   170,   238,   781,    -1,   129,   372,   238,    -1,
     129,   773,  1134,    -1,   123,   237,    -1,   137,   237,    -1,
      13,   797,  1134,   436,   111,  1125,    -1,    13,   797,  1134,
     129,   111,    -1,   401,   801,  1135,    -1,    83,   498,   749,
     751,   756,    -1,   706,    -1,   169,    -1,   973,    -1,    -1,
      67,    -1,    -1,   214,    -1,    -1,   411,    -1,    49,    -1,
      -1,     8,  1141,    -1,   164,    -1,    -1,   498,    -1,   145,
      -1,    18,    -1,    -1,   465,   445,   807,   803,   811,    -1,
     469,   445,   807,    -1,    -1,   445,   465,   807,   804,   811,
      -1,   445,   469,   807,    -1,   465,   500,   806,    -1,    -1,
     548,    78,   447,    -1,    -1,   808,   809,    -1,   810,    -1,
     809,   575,   810,    -1,    -1,   462,    -1,   398,    -1,    -1,
     523,   812,    -1,   602,    -1,   812,   575,   602,    -1,    -1,
     410,  1166,   814,  1006,   175,  1138,    -1,    -1,    26,  1166,
     816,  1006,   498,  1138,    -1,    -1,    57,  1166,   818,  1006,
     819,    -1,    -1,   382,    -1,   156,    -1,    -1,   402,   834,
    1166,   821,  1006,   822,    -1,    -1,   823,    -1,   824,    -1,
     824,   823,    -1,   382,    -1,   156,    -1,   528,    -1,    -1,
      14,   834,  1166,   826,  1006,   829,    -1,    -1,    58,  1166,
     828,  1006,   829,    -1,    -1,   830,    -1,   831,    -1,   831,
     830,    -1,   382,    -1,   159,    -1,   299,    -1,   156,    -1,
      54,    -1,   172,   525,    -1,    -1,   348,   834,  1166,   833,
    1006,   829,    -1,    -1,   336,    -1,   258,    -1,    -1,   401,
    1166,   836,   838,    -1,   401,   527,   608,   837,    -1,  1144,
     498,  1144,    -1,   837,   575,  1144,   498,  1144,    -1,   839,
      -1,   838,   575,   839,    -1,  1135,   498,  1135,    -1,    47,
     217,   841,   229,   843,    -1,   842,    -1,   841,   575,   842,
      -1,  1135,   848,    -1,  1141,    -1,   111,    -1,    -1,   257,
     217,   226,    47,   845,   846,    -1,   847,    -1,   846,   575,
     847,    -1,  1135,   848,   851,    -1,    -1,   849,   850,    -1,
      -1,   774,   573,   957,   574,    -1,    -1,   214,   247,    -1,
     853,    -1,   430,   855,    -1,   573,   854,   574,  1219,    -1,
     430,   857,    -1,   573,   854,   574,    -1,    -1,   857,   856,
    1216,    -1,    -1,    -1,   858,   862,   866,   859,   860,   865,
      -1,   976,   982,    -1,   998,    -1,   861,    -1,   998,   861,
      -1,   861,   998,    -1,   175,   930,   965,   970,   967,   976,
     982,   989,    -1,   175,   130,   965,   982,    -1,    -1,   863,
      -1,   863,   864,    -1,   864,    -1,   471,    -1,   204,    -1,
     125,    -1,   460,    -1,   455,    -1,   456,    -1,   458,    -1,
     459,    -1,   457,    -1,    12,    -1,    -1,   172,   524,    -1,
     262,   229,   438,   310,    -1,   866,   575,   867,    -1,   867,
      -1,   567,    -1,   868,   870,   869,   871,    -1,    -1,    -1,
    1129,    -1,   873,    -1,    -1,    18,  1141,    -1,    18,  1138,
      -1,  1141,    -1,  1138,    -1,    -1,   573,   574,    -1,    -1,
     876,   874,   875,    -1,    -1,   875,   889,   876,    -1,   876,
     553,   876,    -1,    -1,   879,   877,   878,    -1,    -1,   878,
     890,   879,    -1,   333,   879,    -1,   880,    -1,   881,   232,
     504,    -1,   881,   232,   891,   504,    -1,   881,   232,   158,
      -1,   881,   232,   891,   158,    -1,   881,   232,   520,    -1,
     881,   232,   891,   520,    -1,   881,    -1,   881,   232,   337,
      -1,   881,   232,   891,   337,    -1,   881,   146,   882,    -1,
     881,   893,   882,    -1,   881,   893,   894,   573,  1224,   574,
      -1,   882,    -1,   883,   229,   573,  1224,   574,    -1,   883,
     891,   229,   573,  1224,   574,    -1,   883,   229,   573,   873,
     574,    -1,   883,   229,   573,   873,   575,   919,   574,    -1,
     883,   891,   229,   573,   873,   574,    -1,   883,   891,   229,
     573,   873,   575,   919,   574,    -1,   883,   562,   883,    16,
     882,    -1,   883,   891,   562,   883,    16,   882,    -1,   883,
     448,   252,   883,    -1,   883,   252,   896,   969,    -1,   883,
     891,   252,   896,   969,    -1,   883,   395,   883,    -1,   883,
     891,   395,   883,    -1,   883,    -1,   883,   563,   884,    -1,
     884,    -1,   884,   564,   885,    -1,   885,    -1,   885,   439,
     886,    -1,   885,   440,   886,    -1,   886,    -1,   886,   566,
     887,    -1,   886,   565,   887,    -1,   886,   566,   895,   959,
      -1,   886,   565,   895,   959,    -1,   887,    -1,   887,   567,
     888,    -1,   887,   568,   888,    -1,   887,   569,   888,    -1,
     887,   126,   888,    -1,   887,   313,   888,    -1,   888,    -1,
     888,   570,   896,    -1,   896,    -1,   354,    -1,   351,    -1,
      16,    -1,    15,    -1,   333,    -1,   332,    -1,   576,    -1,
     332,    -1,   145,    -1,   184,    -1,   198,    -1,   244,    -1,
     271,    -1,   328,    -1,    12,    -1,    17,    -1,   225,   873,
      -1,  1131,    -1,   896,    64,  1143,    -1,  1126,    -1,  1124,
      -1,   909,    -1,   905,    -1,   896,   353,   896,    -1,   566,
     896,    -1,   565,   896,    -1,   571,   896,    -1,   892,   896,
      -1,   573,  1224,   574,    -1,   573,   873,   574,    -1,   573,
     873,   575,   919,   574,    -1,   424,   573,   873,   575,   919,
     574,    -1,   152,   573,  1224,   574,    -1,   577,  1141,   873,
     578,    -1,   289,   922,     9,   573,   883,   899,   574,    -1,
      20,   573,   873,   574,    -1,    32,   896,    -1,    51,   573,
     873,    18,   917,   574,    -1,   561,   926,   928,   927,   141,
      -1,    83,   573,   873,   575,   917,   574,    -1,    83,   573,
     873,   530,   750,   574,    -1,   111,   573,  1131,   574,    -1,
     535,   573,  1132,   574,    -1,   180,   573,   574,    -1,   181,
     573,   873,   574,    -1,   182,   573,   873,   575,   873,   574,
      -1,   183,   573,   873,   575,   873,   575,   873,   574,    -1,
       7,   573,   873,   575,   873,   574,    -1,     7,   573,   873,
     575,   225,   873,   959,   574,    -1,   404,   573,   873,   575,
     873,   574,    -1,    22,   573,   873,   574,    -1,    22,   573,
     873,   575,   873,   574,    -1,    56,   573,   919,   574,    -1,
      56,   573,   919,   530,   750,   574,    -1,    55,   573,   873,
     574,    -1,    62,   573,   919,   574,    -1,    65,   573,   873,
     574,    -1,    73,   573,   919,   574,    -1,    74,   573,   873,
     575,   919,   574,    -1,    84,   573,   873,   575,   873,   575,
     873,   574,    -1,    90,   872,    -1,    93,   872,    -1,    93,
     573,   873,   574,    -1,    91,   872,    -1,    98,   573,   873,
     575,   895,   959,   574,    -1,    99,   573,   873,   575,   895,
     959,   574,    -1,    94,   573,   574,    -1,   100,   573,   873,
     574,    -1,   105,   573,   873,   574,    -1,   136,   573,   873,
     575,   919,   574,    -1,   272,   573,   873,   575,   919,   574,
      -1,   140,   573,   873,   574,    -1,   140,   573,   873,   575,
     873,   574,    -1,   110,   573,   873,   575,  1139,   574,    -1,
     139,   573,   873,   575,  1139,   574,    -1,   118,   573,   873,
     574,    -1,   118,   573,   873,   575,   873,   574,    -1,   119,
     573,   873,   574,    -1,   119,   573,   873,   575,   873,   574,
      -1,   155,   573,   873,   575,   873,   575,   873,   574,    -1,
     155,   573,   873,   575,   873,   575,   873,   575,   873,   574,
      -1,   155,   573,   873,   575,   873,   575,   873,   575,   873,
     575,   873,   574,    -1,   171,   573,   873,   575,   338,   574,
      -1,   176,   573,   873,   574,    -1,   176,   573,   873,   575,
     873,   574,    -1,   162,   573,   873,   575,   919,   574,    -1,
     898,    -1,   190,   573,   961,   575,   873,   574,    -1,   209,
     573,   873,   574,    -1,   213,   573,   873,   575,   873,   575,
     873,   574,    -1,   223,   573,   873,   575,   873,   575,   873,
     575,   873,   574,    -1,   895,   959,   566,   873,    -1,   895,
      -1,   242,   573,   574,    -1,   242,   573,   873,   574,    -1,
     249,   573,   873,   575,   873,   574,    -1,   259,   573,   873,
     575,   873,   574,    -1,   259,   573,   873,   575,   873,   575,
     873,   574,    -1,   194,   573,   873,   575,   919,   574,    -1,
     246,   573,   873,   575,   919,   574,    -1,   264,   573,   873,
     574,    -1,   264,   573,   873,   575,   873,   574,    -1,   279,
     573,   873,   575,   873,   574,    -1,   279,   573,   873,   575,
     873,   575,   873,   574,    -1,   302,   573,   873,   574,    -1,
     306,   573,   873,   574,    -1,   313,   573,   873,   575,   873,
     574,    -1,   314,   573,   873,   574,    -1,   334,   872,    -1,
     334,   573,   873,   574,    -1,   361,   573,   873,   574,    -1,
     343,   573,   873,   574,    -1,   368,   573,   883,   229,   873,
     574,    -1,   380,   573,   873,   574,    -1,   388,   573,   873,
     574,    -1,   388,   573,   574,    -1,   405,   573,   873,   575,
     873,   575,   873,   574,    -1,   416,   573,   873,   575,   873,
     574,    -1,   419,   573,   873,   574,    -1,   419,   573,   873,
     575,   873,   574,    -1,   422,   573,   574,    -1,   473,   573,
     873,   575,   873,   574,    -1,   473,   573,   873,   575,   225,
     873,   959,   574,    -1,   428,   573,   873,   574,    -1,   475,
     573,   873,   575,   873,   575,   873,   574,    -1,   475,   573,
     873,   575,   873,   574,    -1,   475,   573,   873,   175,   873,
     172,   873,   574,    -1,   475,   573,   873,   175,   873,   574,
      -1,   476,   573,   873,   575,   873,   575,   873,   574,    -1,
     482,   872,    -1,   482,   573,   873,   574,    -1,   494,   573,
     873,   574,    -1,   491,   573,   873,   574,    -1,   491,   573,
     873,   575,   873,   574,    -1,   492,   573,   960,   575,   873,
     575,   873,   574,    -1,   493,   573,   960,   575,   873,   575,
     873,   574,    -1,   503,   573,   873,   574,    -1,   503,   573,
     245,   873,   175,   873,   574,    -1,   503,   573,   499,   873,
     175,   873,   574,    -1,   503,   573,    43,   873,   175,   873,
     574,    -1,   503,   573,   245,   175,   873,   574,    -1,   503,
     573,   499,   175,   873,   574,    -1,   503,   573,    43,   175,
     873,   574,    -1,   503,   573,   873,   175,   873,   574,    -1,
     505,   573,   873,   575,   873,   574,    -1,  1141,   580,  1141,
     573,   918,   574,    -1,    -1,  1137,   573,   897,   900,   574,
      -1,   518,   573,  1122,   575,   338,   575,   338,   575,   919,
     574,    -1,   519,   573,   574,    -1,   519,   573,   873,   574,
      -1,   527,   573,   574,    -1,   531,   872,    -1,   533,   872,
      -1,   532,   872,    -1,   544,   573,   873,   574,    -1,   544,
     573,   873,   575,   873,   574,    -1,   556,   573,   873,   574,
      -1,   554,   573,   873,   574,    -1,   554,   573,   873,   575,
     873,   574,    -1,    29,   573,   987,   575,   873,   574,    -1,
     157,   573,   959,   175,   873,   574,    -1,    80,   573,   873,
     575,   873,   574,    -1,   188,   573,   873,   574,    -1,   188,
     573,   873,   575,   873,   574,    -1,   189,   573,   873,   574,
      -1,   189,   573,   873,   575,   873,   574,    -1,   186,   573,
     919,   574,    -1,   256,   573,   919,   574,    -1,   317,   573,
     919,   574,    -1,   309,   573,   873,   574,    -1,   309,   573,
     873,   575,   873,   574,    -1,   315,   573,   873,   574,    -1,
     315,   573,   873,   575,   873,   574,    -1,   316,   573,   873,
     574,    -1,   316,   573,   873,   575,   873,   574,    -1,   318,
     573,   919,   574,    -1,   319,   573,   919,   574,    -1,   365,
     573,   873,   575,   873,   574,    -1,   364,   573,   873,   574,
      -1,   364,   573,   873,   575,   873,   574,    -1,   366,   573,
     873,   574,    -1,   366,   573,   873,   575,   873,   574,    -1,
     367,   573,   919,   574,    -1,   185,   573,   873,   574,    -1,
     185,   573,   873,   575,   873,   574,    -1,   254,   573,   873,
     574,    -1,   254,   573,   873,   575,   873,   574,    -1,    -1,
     548,   381,   154,    -1,   229,    41,   310,    -1,    -1,   901,
      -1,    -1,   902,   903,    -1,   904,    -1,   903,   575,   904,
      -1,   868,   873,   869,   871,    -1,    25,   573,   915,   574,
      -1,    25,   573,   125,   915,   574,    -1,    35,   573,   915,
     574,    -1,    36,   573,   915,   574,    -1,    38,   573,   915,
     574,    -1,    85,   573,   964,   567,   574,    -1,    85,   573,
     915,   574,    -1,    -1,    -1,    85,   573,   125,   906,   919,
     907,   574,    -1,   197,   573,  1122,   575,   338,   575,   338,
     575,   915,   574,    -1,   308,   573,   915,   574,    -1,   308,
     573,   125,   915,   574,    -1,   293,   573,   915,   574,    -1,
     293,   573,   125,   915,   574,    -1,   467,   573,   915,   574,
      -1,   540,   573,   915,   574,    -1,   468,   573,   915,   574,
      -1,   534,   573,   915,   574,    -1,   477,   573,   915,   574,
      -1,   477,   573,   125,   915,   574,    -1,    -1,   196,   573,
     912,   908,   919,   914,   913,   574,    -1,    -1,   579,   910,
     911,    -1,  1143,   437,   873,    -1,  1143,    -1,   579,  1156,
    1143,   782,    -1,    -1,   125,    -1,    -1,   432,  1123,    -1,
      -1,   977,    -1,    -1,   964,   916,   873,    -1,    32,   743,
      -1,    56,   743,   759,    -1,   326,   743,    -1,   443,    -1,
     443,   227,    -1,   522,    -1,   522,   227,    -1,   100,    -1,
     494,    -1,    97,    -1,   108,   738,    -1,    -1,   919,    -1,
      -1,   920,   921,    -1,   873,    -1,   921,   575,   873,    -1,
     923,    -1,   573,   923,   574,    -1,    -1,   924,   925,    -1,
    1131,    -1,   925,   575,  1131,    -1,    -1,   873,    -1,    -1,
     559,   873,    -1,   545,   873,   560,   873,    -1,   928,   545,
     873,   560,   873,    -1,   941,    -1,   932,    -1,   931,    -1,
     929,    -1,   931,   575,   929,    -1,   929,   940,   929,    -1,
     929,   471,   941,    -1,    -1,   929,   940,   929,   344,   933,
     873,    -1,    -1,   929,   471,   941,   344,   934,   873,    -1,
      -1,   929,   940,   929,   530,   935,   573,   958,   574,    -1,
     929,   324,   236,   941,    -1,    -1,   929,   249,   951,   236,
     929,   344,   936,   873,    -1,    -1,   929,   249,   951,   236,
     941,   937,   530,   573,   958,   574,    -1,   929,   324,   249,
     951,   236,   941,    -1,    -1,   929,   416,   951,   236,   929,
     344,   938,   873,    -1,    -1,   929,   416,   951,   236,   941,
     939,   530,   573,   958,   574,    -1,   929,   324,   416,   951,
     236,   941,    -1,   236,    -1,   219,   236,    -1,    88,   236,
      -1,    -1,   942,  1135,   963,   953,    -1,    -1,   577,  1141,
     929,   249,   355,   236,   929,   344,   943,   873,   578,    -1,
     950,   949,   946,    -1,   573,   949,   944,  1219,   574,   963,
      -1,    -1,   949,   945,   931,    -1,    -1,    -1,   947,   862,
     866,   948,   715,    -1,    -1,   430,    -1,    -1,   355,    -1,
      -1,   172,   236,    -1,    -1,   529,   954,    -1,   169,   954,
      -1,   214,   954,    -1,    -1,   773,   952,   955,   573,   956,
     574,    -1,    -1,   957,    -1,   957,   575,  1141,    -1,  1141,
      -1,   372,    -1,  1141,    -1,   958,   575,  1141,    -1,   960,
      -1,   101,    -1,   102,    -1,   103,    -1,   104,    -1,   206,
      -1,   207,    -1,   208,    -1,   302,    -1,   304,    -1,   305,
      -1,   427,    -1,   555,    -1,   105,    -1,   544,    -1,   209,
      -1,   174,    -1,   306,    -1,   314,    -1,   380,    -1,   428,
      -1,   556,    -1,   100,    -1,   494,    -1,    97,    -1,   491,
      -1,    -1,    18,    -1,   145,    -1,    -1,   962,  1141,    -1,
      -1,    12,    -1,    -1,    -1,   546,   966,   873,    -1,    -1,
      -1,   201,   968,   873,    -1,   149,   896,    -1,    -1,    -1,
     195,    45,   971,   972,    -1,   971,   575,  1130,   980,    -1,
    1130,   980,    -1,    -1,   548,    89,    -1,   548,   418,    -1,
     352,    45,   974,    -1,   974,   575,   975,    -1,   975,    -1,
    1132,   980,    -1,    -1,   977,    -1,    -1,   352,    45,   978,
     979,    -1,   979,   575,  1130,   980,    -1,  1130,   980,    -1,
      -1,    19,    -1,   116,    -1,    -1,   983,    -1,    -1,   983,
      -1,   253,   984,    -1,   985,    -1,   985,   575,   985,    -1,
     985,   341,   985,    -1,  1124,    -1,   510,    -1,   267,    -1,
     338,    -1,    -1,   253,   985,    -1,   338,    -1,   203,    -1,
     267,    -1,   510,    -1,   107,    -1,   166,    -1,   338,    -1,
     510,    -1,   267,    -1,   107,    -1,   166,    -1,    -1,    -1,
     374,  1141,   990,   573,   991,   574,    -1,    -1,   992,    -1,
     992,   575,   993,    -1,   993,    -1,   868,   873,    -1,    -1,
     995,   996,    -1,   996,   575,   997,    -1,   997,    -1,   579,
    1143,    -1,  1143,    -1,    -1,   226,   999,  1000,    -1,    -1,
     356,  1140,  1001,  1111,  1114,    -1,   131,  1140,    -1,   994,
      -1,    -1,   128,  1003,   919,    -1,   129,  1009,  1166,  1008,
    1006,   799,    -1,    -1,   129,   217,  1141,   344,  1135,  1005,
      -1,   129,    94,  1008,  1141,    -1,   129,   179,  1008,   609,
      -1,   129,   374,  1008,   609,    -1,   129,   527,   608,  1196,
      -1,   129,   542,  1008,  1006,   799,    -1,   129,   501,  1008,
     609,    -1,  1007,    -1,  1006,   575,  1007,    -1,  1135,    -1,
      -1,   213,   152,    -1,    -1,   486,    -1,    -1,    -1,   223,
    1011,  1016,   798,  1018,  1012,  1020,  1036,    -1,    -1,    -1,
     405,  1014,  1017,  1018,  1015,  1020,    -1,    -1,   270,    -1,
     113,    -1,   204,    -1,  1045,    -1,   113,    -1,   226,  1019,
      -1,  1019,    -1,  1007,    -1,  1023,    -1,   573,   574,  1023,
      -1,   573,  1022,   574,  1023,    -1,    -1,   436,  1021,  1027,
      -1,  1022,   575,  1128,    -1,  1128,    -1,   535,  1026,    -1,
     536,  1026,    -1,    -1,   694,  1024,  1216,    -1,    -1,   573,
     694,   574,  1025,  1219,    -1,  1026,   575,  1031,    -1,  1031,
      -1,  1027,   575,  1028,    -1,  1028,    -1,  1132,  1029,  1035,
      -1,   145,    -1,   437,    -1,    -1,  1029,    -1,    -1,   573,
    1032,  1033,   574,    -1,    -1,  1034,    -1,  1034,   575,  1035,
      -1,  1035,    -1,   873,    -1,   111,    -1,    -1,    -1,   344,
     132,  1037,   238,   524,  1043,    -1,    -1,    -1,   524,  1039,
    1045,   798,   930,   436,  1041,  1040,   965,   976,   986,    -1,
    1041,   575,  1042,    -1,  1042,    -1,  1132,  1029,  1035,    -1,
    1043,   575,  1044,    -1,  1044,    -1,  1132,  1029,  1035,    -1,
      -1,   270,    -1,    -1,   115,  1047,  1055,  1048,    -1,    -1,
     175,  1135,  1049,   965,   976,   986,    -1,    -1,  1052,  1050,
     175,   930,   965,    -1,    -1,   175,  1052,  1051,   530,   930,
     965,    -1,  1053,    -1,  1052,   575,  1053,    -1,  1141,  1054,
     963,    -1,  1141,   580,  1141,  1054,   963,    -1,    -1,   580,
     567,    -1,    -1,  1056,  1055,    -1,   382,    -1,   270,    -1,
     214,    -1,   505,  1058,  1007,    -1,    -1,   485,    -1,    -1,
    1060,    -1,  1061,    -1,  1060,   575,  1061,    -1,    86,    -1,
     300,    -1,    40,   230,    -1,    81,   481,    -1,   359,   160,
      -1,   231,    -1,   480,    -1,   449,    -1,    12,    -1,    -1,
     172,   381,   338,    -1,    -1,   441,  1064,  1065,    -1,    95,
    1076,    -1,  1072,   483,  1071,  1076,    -1,  1072,   502,  1071,
    1076,    -1,   485,   466,  1071,  1076,    -1,   347,   483,  1071,
    1076,    -1,    -1,   143,   711,  1066,  1068,    -1,  1072,    66,
    1073,  1135,  1071,  1076,    -1,   329,   287,   172,   445,   548,
     275,   145,  1138,    16,   276,   145,   988,    16,   280,   145,
     987,    -1,  1069,   263,    -1,   445,   205,    -1,    -1,    33,
     150,  1074,  1075,  1067,   981,    -1,   775,  1073,  1135,  1071,
     965,    -1,    67,   506,    -1,   485,   506,    -1,  1070,   142,
      -1,   373,    -1,    85,   573,   567,   574,   543,    -1,    85,
     573,   567,   574,   147,    -1,   543,   981,    -1,   147,   981,
      -1,   378,    -1,   377,  1059,  1062,   981,    -1,  1155,   466,
    1076,    -1,   220,   466,    -1,   320,   466,    -1,  1072,   376,
      -1,  1155,   539,  1076,    -1,   749,  1076,    -1,    65,  1076,
      -1,    30,   263,    -1,   263,    -1,   193,    -1,   193,   172,
    1144,    -1,    87,    94,   704,  1141,    -1,    87,   485,  1135,
      -1,    87,   542,  1135,    -1,   287,   466,    -1,   445,   466,
      -1,    87,   374,   609,    -1,    87,   179,   609,    -1,   374,
     466,  1076,    -1,   179,   466,  1076,    -1,   374,    63,   609,
      -1,   179,    63,   609,    -1,   466,    -1,   263,    -1,   287,
      -1,    32,    -1,    -1,   470,    -1,    -1,  1073,  1141,    -1,
      -1,   177,    -1,   175,    -1,   229,    -1,    -1,   229,  1138,
      -1,    -1,   175,   988,    -1,    -1,   252,  1138,    -1,   546,
     873,    -1,    -1,  1080,  1135,  1078,  1082,    -1,    -1,  1080,
    1081,  1079,   852,    -1,   116,    -1,   117,    -1,    -1,   156,
      -1,    -1,  1123,    -1,  1141,    -1,    -1,   168,   834,  1084,
    1085,    -1,  1085,   575,  1086,    -1,  1086,    -1,    -1,  1166,
    1087,  1088,    -1,   483,   548,   390,   262,    -1,   381,    47,
      -1,   205,    -1,   373,    -1,   263,    -1,   466,    -1,   445,
      -1,   287,    -1,   120,    -1,   409,    -1,    -1,  1006,    -1,
      -1,   408,  1090,  1091,    -1,  1091,   575,  1092,    -1,  1092,
      -1,   445,    -1,   287,    -1,   381,    47,    -1,    -1,   379,
    1094,  1095,    -1,  1069,   263,  1096,    -1,   498,  1138,    -1,
      27,   873,    -1,    -1,   239,  1098,  1099,   873,    -1,    -1,
      77,    -1,   381,    -1,   529,  1141,    -1,    -1,   257,    96,
    1102,  1103,    -1,   257,   485,  1135,   175,   287,    -1,    -1,
      -1,    -1,    -1,  1109,  1108,   218,  1140,  1104,  1110,   226,
    1105,   485,  1135,  1106,   752,  1107,  1111,  1114,  1117,  1118,
    1121,    -1,   175,   287,    -1,    -1,   258,    -1,    -1,    75,
      -1,   270,    -1,    -1,   405,    -1,   214,    -1,    -1,    66,
    1112,    -1,  1112,  1113,    -1,  1113,    -1,   488,    45,  1123,
      -1,   350,   138,    45,  1123,    -1,   138,    45,  1123,    -1,
     148,    45,  1123,    -1,    -1,   255,  1115,    -1,  1115,  1116,
      -1,  1116,    -1,   488,    45,  1123,    -1,   464,    45,  1123,
      -1,    -1,   214,   338,   255,    -1,    -1,   573,  1119,   574,
      -1,   573,   574,    -1,  1119,   575,  1120,    -1,  1120,    -1,
    1132,    -1,   579,  1143,    -1,    -1,   436,  1043,    -1,  1139,
      -1,   325,    -1,   513,   489,    -1,  1122,  1139,    -1,  1139,
      -1,   203,    -1,    34,    -1,   362,    -1,  1126,    -1,   566,
    1127,    -1,   565,  1127,    -1,  1122,    -1,  1127,    -1,   337,
      -1,   158,    -1,   504,    -1,   203,    -1,    34,    -1,   513,
     203,    -1,   513,    34,    -1,   100,  1122,    -1,   494,  1122,
      -1,   491,  1122,    -1,   338,    -1,   267,    -1,   510,    -1,
     107,    -1,   166,    -1,  1132,    -1,  1129,    -1,  1141,   580,
     567,    -1,  1141,   580,  1141,   580,   567,    -1,   873,    -1,
    1141,    -1,  1133,    -1,  1141,    -1,  1133,    -1,  1141,   580,
    1141,    -1,   580,  1141,   580,  1141,    -1,  1141,   580,  1141,
     580,  1141,    -1,  1141,    -1,  1141,   580,  1141,   580,  1141,
      -1,  1141,   580,  1141,    -1,   580,  1141,    -1,  1141,    -1,
    1141,   580,  1141,    -1,   580,  1141,    -1,  1141,    -1,   210,
      -1,   212,    -1,   489,    -1,   489,    -1,   489,    -1,  1137,
      -1,  1145,    -1,  1137,    -1,  1146,    -1,  1141,    -1,  1138,
      -1,   251,    -1,  1143,    -1,  1143,   579,  1143,    -1,    91,
     872,    -1,  1146,    -1,    20,    -1,    26,    -1,    28,    -1,
      46,    -1,    47,    -1,    55,    -1,    57,    -1,    61,    -1,
      68,    -1,    70,    -1,    80,    -1,   106,    -1,   128,    -1,
     141,    -1,   151,    -1,   168,    -1,   199,    -1,   202,    -1,
     241,    -1,   335,    -1,   347,    -1,   370,    -1,   402,    -1,
     408,    -1,   410,    -1,   417,    -1,   426,    -1,   429,    -1,
     443,    -1,   445,    -1,   465,    -1,   469,    -1,   505,    -1,
     515,    -1,   552,    -1,   525,    -1,     5,    -1,     7,    -1,
       8,    -1,     9,    -1,    10,    -1,    11,    -1,    17,    -1,
      23,    -1,    24,    -1,    25,    -1,    30,    -1,    33,    -1,
      37,    -1,    40,    -1,    42,    -1,    41,    -1,    44,    -1,
      50,    -1,    52,    -1,    54,    -1,    59,    -1,    60,    -1,
      63,    -1,    65,    -1,    66,    -1,    69,    -1,    71,    -1,
      72,    -1,    75,    -1,    77,    -1,    78,    -1,    81,    -1,
      86,    -1,    89,    -1,    96,    -1,    97,    -1,   100,    -1,
     105,    -1,   112,    -1,   114,    -1,   120,    -1,   122,    -1,
     124,    -1,   131,    -1,   132,    -1,   133,    -1,   144,    -1,
     143,    -1,   142,    -1,   147,    -1,   149,    -1,   150,    -1,
     154,    -1,   156,    -1,   159,    -1,   160,    -1,   173,    -1,
     123,    -1,   137,    -1,   177,    -1,   163,    -1,   164,    -1,
     165,    -1,   174,    -1,   187,    -1,   186,    -1,   190,    -1,
     193,    -1,   191,    -1,   200,    -1,   205,    -1,   209,    -1,
     211,    -1,   228,    -1,   215,    -1,   216,    -1,   233,    -1,
     234,    -1,   220,    -1,   224,    -1,   230,    -1,   231,    -1,
     398,    -1,   243,    -1,   247,    -1,   250,    -1,   256,    -1,
     258,    -1,   261,    -1,   263,    -1,   292,    -1,   287,    -1,
     274,    -1,   278,    -1,   275,    -1,   276,    -1,   288,    -1,
     277,    -1,   280,    -1,   273,    -1,   286,    -1,   282,    -1,
     281,    -1,   283,    -1,   284,    -1,   285,    -1,   290,    -1,
     291,    -1,   294,    -1,   295,    -1,   299,    -1,   300,    -1,
     301,    -1,   302,    -1,   303,    -1,   306,    -1,   307,    -1,
     312,    -1,   310,    -1,   314,    -1,   317,    -1,   318,    -1,
     319,    -1,   320,    -1,   322,    -1,   321,    -1,   323,    -1,
     326,    -1,   327,    -1,   330,    -1,   329,    -1,   331,    -1,
     340,    -1,   341,    -1,   343,    -1,   345,    -1,   346,    -1,
     358,    -1,   359,    -1,   360,    -1,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,   371,    -1,   373,    -1,   375,    -1,
     376,    -1,   377,    -1,   378,    -1,   380,    -1,   381,    -1,
     382,    -1,   383,    -1,   384,    -1,   385,    -1,   386,    -1,
     387,    -1,   392,    -1,   393,    -1,   396,    -1,   397,    -1,
     400,    -1,   403,    -1,   406,    -1,   409,    -1,   412,    -1,
     413,    -1,   418,    -1,   420,    -1,   421,    -1,   423,    -1,
     424,    -1,   425,    -1,   428,    -1,   434,    -1,   433,    -1,
     435,    -1,   444,    -1,   438,    -1,   442,    -1,   447,    -1,
     448,    -1,   449,    -1,   457,    -1,   456,    -1,   459,    -1,
     462,    -1,   466,    -1,   470,    -1,   472,    -1,   473,    -1,
     474,    -1,   478,    -1,   479,    -1,   480,    -1,   481,    -1,
     483,    -1,   484,    -1,   486,    -1,   487,    -1,   490,    -1,
     500,    -1,   502,    -1,   491,    -1,   492,    -1,   493,    -1,
     494,    -1,   506,    -1,   507,    -1,   508,    -1,   179,    -1,
     511,    -1,   512,    -1,   520,    -1,   523,    -1,   527,    -1,
     528,    -1,   539,    -1,   542,    -1,   536,    -1,   543,    -1,
     544,    -1,   549,    -1,   551,    -1,   556,    -1,    -1,   436,
    1149,  1148,  1150,    -1,    -1,   349,    -1,  1151,    -1,  1150,
     575,  1151,    -1,    -1,  1152,  1157,    -1,  1154,    -1,   191,
      -1,   258,    -1,   435,    -1,    -1,   345,    -1,    -1,   191,
      -1,   258,    -1,   435,    -1,    -1,   191,   580,    -1,   258,
     580,    -1,   435,   580,    -1,  1158,    -1,  1154,  1159,    -1,
    1153,  1160,  1029,  1163,    -1,  1153,   500,   233,   250,  1161,
      -1,   579,  1143,  1029,   873,    -1,   579,   579,  1156,  1160,
    1029,  1163,    -1,   749,   754,    -1,   321,  1029,   873,    -1,
     321,   751,   756,    -1,   361,  1029,  1162,    -1,   361,   172,
    1144,  1029,  1162,    -1,  1141,    -1,  1141,   580,  1141,    -1,
     111,   580,  1141,    -1,   390,   511,    -1,   390,    69,    -1,
     403,   390,    -1,   433,    -1,   489,    -1,   361,   573,   489,
     574,    -1,   343,   573,   489,   574,    -1,   873,    -1,   111,
      -1,   344,    -1,    12,    -1,    32,    -1,    -1,   262,  1166,
    1165,  1167,    -1,   485,    -1,   483,    -1,  1168,    -1,  1167,
     575,  1168,    -1,  1135,   963,  1169,    -1,   390,    -1,   550,
      -1,   270,   550,    -1,   390,   258,    -1,    -1,   521,  1171,
    1166,    -1,   199,  1135,   347,   963,    -1,   199,  1136,    61,
      -1,    -1,   199,  1136,   390,  1173,  1174,   965,   982,    -1,
    1175,    -1,  1141,  1176,    -1,   164,    -1,   330,    -1,   164,
      -1,   330,    -1,   371,    -1,   243,    -1,    -1,  1178,  1177,
     573,  1034,   574,    -1,   145,    -1,   184,    -1,   244,    -1,
     198,    -1,   271,    -1,   415,   608,  1180,    -1,  1184,   344,
    1183,  1195,   175,  1197,    -1,  1184,   344,   179,  1195,   175,
    1197,    -1,  1184,   344,   374,  1195,   175,  1197,    -1,    12,
    1185,   575,   192,   349,   175,  1197,    -1,   192,   608,  1182,
      -1,  1184,   344,  1183,  1195,   498,  1197,  1202,  1203,    -1,
    1184,   344,   179,  1195,   498,  1197,  1202,  1203,    -1,  1184,
     344,   374,  1195,   498,  1197,  1202,  1203,    -1,    -1,   485,
      -1,  1186,    -1,    12,  1185,    -1,    -1,   373,    -1,  1187,
      -1,  1186,   575,  1187,    -1,    -1,   430,  1188,  1199,    -1,
      -1,   223,  1189,  1199,    -1,    -1,   524,  1190,  1199,    -1,
      -1,   394,  1191,  1199,    -1,   115,    -1,   526,    -1,   217,
      -1,    13,    -1,    87,    -1,   129,    -1,   151,    -1,   400,
      -1,   442,    -1,   375,    -1,   163,    -1,   192,   349,    -1,
     441,    95,    -1,   478,    -1,    87,   486,   483,    -1,   262,
     483,    -1,   406,   445,    -1,   406,    60,    -1,    87,   542,
      -1,   441,   542,    -1,    87,   420,    -1,    13,   420,    -1,
      87,   527,    -1,    -1,    16,    -1,  1194,  1192,  1193,    -1,
    1194,    -1,   474,   489,    -1,   234,   489,    -1,    59,   489,
      -1,   567,    -1,  1141,   580,   567,    -1,   567,   580,   567,
      -1,  1135,    -1,  1144,    -1,  1196,   575,  1144,    -1,  1198,
      -1,  1197,   575,  1198,    -1,  1144,   211,    45,   489,    -1,
    1144,   211,    45,   361,   489,    -1,  1144,    -1,    -1,   573,
    1200,   574,    -1,  1200,   575,  1201,    -1,  1201,    -1,  1141,
      -1,    -1,   407,  1193,    -1,   407,   463,    -1,   407,   551,
      -1,   407,   331,    -1,    -1,   548,  1204,    -1,  1204,  1205,
      -1,  1205,    -1,   192,   349,    -1,   291,   987,    -1,   294,
     987,    -1,   290,   987,    -1,   295,   987,    -1,    -1,    28,
    1207,  1208,    -1,    -1,   549,    -1,    -1,    16,   335,    52,
      -1,    16,    52,    -1,    -1,   399,    -1,   335,   399,    -1,
      -1,   426,    -1,    70,  1208,  1209,  1210,    -1,   417,  1208,
    1209,  1210,    -1,   417,  1208,   498,  1211,  1141,    -1,   426,
    1141,    -1,   399,   426,  1141,    -1,    -1,  1217,    -1,    -1,
     516,  1223,  1218,   853,    -1,    -1,  1217,    -1,  1220,    -1,
      -1,  1221,  1222,    -1,   977,   981,    -1,   983,    -1,    -1,
     125,    -1,    12,    -1,   430,  1227,  1226,  1228,    -1,    -1,
     573,  1227,  1224,   574,  1225,  1216,  1228,    -1,   855,    -1,
      -1,    -1,  1231,  1230,    -1,  1232,  1231,  1237,    -1,  1237,
      -1,  1245,    -1,  1247,    -1,    -1,   112,   145,  1144,    -1,
    1233,    -1,  1233,  1234,    -1,  1234,    -1,   354,   405,    -1,
      11,   145,   512,    -1,    11,   145,   301,    -1,    11,   145,
     487,    -1,    -1,  1234,    -1,    -1,   461,   429,   112,    -1,
     461,   429,   228,    -1,    -1,  1236,   542,  1135,  1238,  1239,
      18,  1241,  1244,    -1,    -1,   573,  1240,   574,    -1,  1141,
      -1,  1240,   575,  1141,    -1,    -1,  1242,  1243,    -1,   430,
     868,   855,    -1,   573,   868,   854,   574,  1219,    -1,    -1,
     548,    58,   349,    -1,   548,    50,    58,   349,    -1,   548,
     258,    58,   349,    -1,    -1,   501,   868,   609,   686,   687,
     344,   868,  1135,   172,   868,   134,   424,  1246,   650,    -1,
      -1,   716,   868,   179,   609,  1248,   610,    -1,    -1,    -1,
      -1,    -1,   374,   868,   609,  1249,   573,  1250,   630,   574,
    1251,   617,  1252,   650,    -1,   552,  1255,  1254,  1256,    -1,
     552,   141,  1254,  1258,    -1,   552,   370,  1254,    -1,   552,
      70,  1254,  1257,    -1,   552,   417,  1254,    -1,   552,   392,
      -1,  1123,    -1,  1123,   575,  1123,    -1,  1123,   575,  1123,
     575,   987,    -1,    28,    -1,   465,    -1,    -1,   236,    -1,
     412,    -1,    -1,   346,   363,    -1,    -1,    -1,   479,  1259,
    1260,    -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1215,  1215,  1229,  1232,  1233,  1238,  1239,  1240,  1241,
    1242,  1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,  1251,
    1252,  1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,  1261,
    1262,  1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,  1271,
    1272,  1273,  1274,  1275,  1276,  1277,  1278,  1279,  1280,  1281,
    1282,  1283,  1284,  1288,  1297,  1298,  1303,  1312,  1319,  1329,
    1328,  1339,  1341,  1345,  1346,  1349,  1362,  1361,  1380,  1379,
    1390,  1391,  1394,  1399,  1404,  1409,  1414,  1418,  1423,  1427,
    1431,  1435,  1439,  1444,  1448,  1452,  1468,  1472,  1484,  1483,
    1503,  1502,  1523,  1522,  1535,  1534,  1542,  1550,  1564,  1579,
    1597,  1617,  1656,  1664,  1672,  1684,  1616,  1715,  1716,  1720,
    1721,  1726,  1728,  1730,  1732,  1734,  1736,  1738,  1744,  1745,
    1746,  1750,  1754,  1762,  1761,  1774,  1776,  1779,  1781,  1785,
    1789,  1796,  1798,  1802,  1803,  1808,  1827,  1853,  1855,  1859,
    1860,  1864,  1890,  1891,  1892,  1893,  1897,  1898,  1902,  1903,
    1908,  1911,  1938,  1937,  1993,  2008,  2007,  2051,  2075,  2075,
    2106,  2107,  2112,  2114,  2119,  2142,  2148,  2163,  2164,  2168,
    2172,  2181,  2186,  2191,  2199,  2214,  2232,  2233,  2237,  2237,
    2287,  2286,  2310,  2309,  2313,  2314,  2316,  2316,  2327,  2356,
    2384,  2400,  2399,  2416,  2433,  2435,  2436,  2440,  2461,  2484,
    2486,  2500,  2484,  2518,  2520,  2521,  2525,  2526,  2531,  2537,
    2530,  2556,  2555,  2571,  2572,  2576,  2577,  2582,  2586,  2581,
    2603,  2607,  2602,  2622,  2630,  2635,  2634,  2672,  2673,  2678,
    2677,  2704,  2715,  2717,  2714,  2741,  2740,  2758,  2760,  2765,
    2767,  2769,  2774,  2775,  2776,  2782,  2791,  2792,  2792,  2796,
    2798,  2797,  2800,  2799,  2805,  2821,  2804,  2835,  2836,  2839,
    2840,  2843,  2844,  2847,  2848,  2851,  2852,  2855,  2856,  2859,
    2862,  2863,  2865,  2867,  2870,  2871,  2874,  2875,  2876,  2879,
    2880,  2881,  2882,  2883,  2884,  2885,  2886,  2887,  2902,  2908,
    2909,  2910,  2911,  2916,  2921,  2926,  2941,  2942,  2943,  2944,
    2945,  2946,  2950,  2967,  2983,  2993,  2994,  2995,  2996,  2997,
    2998,  3001,  3002,  3003,  3006,  3007,  3008,  3011,  3012,  3015,
    3016,  3019,  3020,  3021,  3022,  3025,  3026,  3030,  3031,  3035,
    3036,  3043,  3051,  3059,  3076,  3080,  3086,  3088,  3092,  3096,
    3097,  3101,  3106,  3105,  3127,  3128,  3129,  3130,  3132,  3134,
    3136,  3138,  3140,  3142,  3145,  3148,  3151,  3154,  3156,  3159,
    3162,  3163,  3164,  3165,  3178,  3179,  3181,  3183,  3195,  3197,
    3199,  3201,  3202,  3203,  3204,  3205,  3206,  3208,  3210,  3212,
    3212,  3214,  3214,  3216,  3217,  3226,  3227,  3228,  3231,  3232,
    3233,  3234,  3235,  3239,  3243,  3244,  3248,  3249,  3253,  3254,
    3255,  3256,  3257,  3261,  3262,  3263,  3264,  3265,  3268,  3270,
    3271,  3275,  3276,  3277,  3280,  3287,  3288,  3291,  3292,  3295,
    3296,  3297,  3300,  3301,  3304,  3305,  3308,  3309,  3312,  3313,
    3316,  3317,  3318,  3319,  3321,  3322,  3328,  3334,  3340,  3346,
    3347,  3363,  3364,  3368,  3369,  3373,  3381,  3385,  3386,  3389,
    3390,  3394,  3403,  3407,  3408,  3411,  3421,  3422,  3426,  3427,
    3430,  3431,  3434,  3435,  3436,  3437,  3446,  3447,  3450,  3451,
    3454,  3455,  3456,  3465,  3467,  3469,  3474,  3473,  3485,  3486,
    3489,  3490,  3494,  3495,  3498,  3499,  3502,  3503,  3504,  3505,
    3506,  3509,  3510,  3511,  3512,  3513,  3516,  3517,  3518,  3530,
    3531,  3534,  3535,  3538,  3539,  3543,  3544,  3545,  3548,  3549,
    3550,  3551,  3564,  3565,  3566,  3569,  3570,  3574,  3577,  3578,
    3581,  3582,  3593,  3594,  3597,  3598,  3601,  3602,  3610,  3609,
    3633,  3632,  3647,  3646,  3665,  3664,  3684,  3682,  3697,  3698,
    3700,  3701,  3702,  3703,  3704,  3707,  3715,  3716,  3720,  3725,
    3724,  3732,  3741,  3731,  3753,  3760,  3764,  3771,  3778,  3784,
    3790,  3796,  3803,  3822,  3843,  3848,  3852,  3859,  3860,  3863,
    3864,  3868,  3869,  3870,  3874,  3875,  3876,  3879,  3880,  3881,
    3882,  3890,  3889,  3900,  3908,  3907,  3917,  3927,  3936,  3937,
    3944,  3944,  3950,  3951,  3955,  3956,  3957,  3961,  3962,  3979,
    3980,  3985,  3984,  3995,  3994,  4005,  4004,  4014,  4015,  4016,
    4021,  4020,  4032,  4033,  4036,  4037,  4040,  4041,  4042,  4046,
    4045,  4058,  4057,  4074,  4075,  4078,  4079,  4082,  4083,  4084,
    4085,  4086,  4087,  4091,  4090,  4102,  4103,  4104,  4109,  4108,
    4114,  4121,  4126,  4134,  4135,  4138,  4150,  4159,  4160,  4163,
    4176,  4177,  4182,  4181,  4191,  4192,  4195,  4208,  4208,  4218,
    4219,  4228,  4229,  4238,  4247,  4249,  4252,  4274,  4278,  4277,
    4297,  4305,  4297,  4311,  4312,  4313,  4314,  4315,  4318,  4325,
    4332,  4334,  4345,  4346,  4349,  4350,  4356,  4357,  4358,  4359,
    4365,  4371,  4377,  4387,  4390,  4392,  4398,  4408,  4409,  4410,
    4423,  4443,  4450,  4457,  4458,  4461,  4462,  4463,  4464,  4465,
    4469,  4470,  4474,  4474,  4491,  4493,  4498,  4499,  4499,  4516,
    4518,  4523,  4524,  4527,  4529,  4531,  4533,  4535,  4536,  4537,
    4541,  4542,  4543,  4544,  4546,  4548,  4551,  4555,  4561,  4565,
    4571,  4575,  4583,  4585,  4591,  4594,  4596,  4598,  4599,  4601,
    4604,  4605,  4608,  4609,  4612,  4614,  4616,  4619,  4620,  4621,
    4623,  4625,  4628,  4629,  4630,  4631,  4632,  4633,  4636,  4637,
    4639,  4639,  4640,  4640,  4641,  4641,  4642,  4642,  4644,  4645,
    4646,  4647,  4648,  4649,  4652,  4653,  4657,  4661,  4662,  4669,
    4670,  4671,  4672,  4673,  4675,  4676,  4677,  4678,  4679,  4683,
    4684,  4689,  4694,  4698,  4699,  4703,  4704,  4708,  4715,  4717,
    4723,  4725,  4736,  4738,  4749,  4760,  4771,  4782,  4784,  4786,
    4788,  4790,  4792,  4794,  4796,  4798,  4800,  4802,  4804,  4806,
    4812,  4814,  4816,  4821,  4826,  4828,  4830,  4835,  4837,  4839,
    4841,  4843,  4848,  4849,  4851,  4853,  4855,  4857,  4859,  4861,
    4863,  4865,  4867,  4869,  4871,  4875,  4877,  4887,  4889,  4891,
    4893,  4895,  4898,  4907,  4912,  4917,  4919,  4921,  4923,  4925,
    4927,  4929,  4931,  4936,  4941,  4943,  4945,  4947,  4949,  4951,
    4953,  4959,  4961,  4963,  4965,  4967,  4969,  4971,  4973,  4975,
    4976,  4981,  4983,  4985,  4987,  4989,  4991,  4993,  4995,  4997,
    5004,  5011,  5013,  5015,  5017,  5019,  5021,  5023,  5025,  5027,
    5029,  5031,  5033,  5035,  5037,  5039,  5053,  5052,  5169,  5173,
    5178,  5180,  5182,  5184,  5186,  5188,  5193,  5195,  5197,  5199,
    5201,  5206,  5210,  5212,  5214,  5216,  5218,  5220,  5224,  5227,
    5230,  5232,  5234,  5236,  5238,  5240,  5242,  5245,  5248,  5250,
    5252,  5254,  5256,  5258,  5261,  5263,  5265,  5267,  5272,  5273,
    5274,  5278,  5279,  5283,  5283,  5289,  5293,  5300,  5331,  5333,
    5335,  5337,  5339,  5341,  5343,  5346,  5348,  5345,  5351,  5353,
    5360,  5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,  5379,
    5378,  5393,  5392,  5407,  5413,  5419,  5432,  5433,  5436,  5437,
    5442,  5445,  5457,  5456,  5472,  5473,  5474,  5475,  5476,  5477,
    5478,  5479,  5480,  5481,  5482,  5486,  5487,  5491,  5491,  5496,
    5497,  5500,  5501,  5504,  5504,  5509,  5510,  5513,  5514,  5517,
    5518,  5521,  5527,  5537,  5538,  5547,  5552,  5553,  5573,  5575,
    5579,  5577,  5594,  5592,  5610,  5608,  5615,  5624,  5622,  5640,
    5639,  5649,  5660,  5658,  5677,  5676,  5687,  5697,  5698,  5699,
    5704,  5704,  5723,  5721,  5740,  5762,  5810,  5809,  5832,  5850,
    5832,  5857,  5861,  5887,  5888,  5890,  5892,  5895,  5896,  5902,
    5909,  5918,  5917,  5924,  5925,  5929,  5933,  5937,  5943,  5951,
    5960,  5961,  5962,  5963,  5964,  5965,  5966,  5967,  5968,  5969,
    5970,  5971,  5972,  5975,  5976,  5977,  5978,  5979,  5980,  5981,
    5982,  5983,  5987,  5988,  5989,  5990,  5993,  5995,  5996,  5999,
    6000,  6003,  6005,  6009,  6011,  6010,  6024,  6027,  6026,  6041,
    6047,  6060,  6062,  6065,  6067,  6071,  6072,  6085,  6103,  6107,
    6108,  6112,  6125,  6127,  6131,  6130,  6162,  6164,  6168,  6169,
    6170,  6175,  6181,  6185,  6186,  6190,  6194,  6201,  6208,  6217,
    6221,  6222,  6223,  6228,  6232,  6240,  6241,  6242,  6243,  6244,
    6245,  6249,  6250,  6251,  6252,  6253,  6256,  6259,  6258,  6287,
    6288,  6291,  6292,  6295,  6310,  6310,  6320,  6321,  6325,  6337,
    6370,  6369,  6382,  6381,  6390,  6402,  6413,  6412,  6429,  6436,
    6436,  6448,  6455,  6467,  6479,  6483,  6489,  6499,  6500,  6503,
    6511,  6512,  6516,  6517,  6525,  6534,  6524,  6544,  6551,  6543,
    6561,  6573,  6574,  6575,  6579,  6580,  6583,  6584,  6587,  6596,
    6597,  6598,  6600,  6599,  6609,  6610,  6613,  6614,  6615,  6615,
    6616,  6616,  6620,  6621,  6624,  6626,  6629,  6637,  6638,  6642,
    6643,  6648,  6647,  6660,  6661,  6664,  6669,  6677,  6678,  6681,
    6683,  6683,  6691,  6700,  6690,  6722,  6723,  6726,  6733,  6734,
    6737,  6746,  6747,  6753,  6752,  6766,  6765,  6774,  6773,  6781,
    6780,  6790,  6791,  6794,  6801,  6814,  6815,  6819,  6820,  6823,
    6824,  6825,  6828,  6838,  6840,  6842,  6844,  6847,  6848,  6851,
    6855,  6859,  6863,  6867,  6871,  6875,  6879,  6883,  6891,  6894,
    6903,  6902,  6916,  6924,  6933,  6942,  6951,  6961,  6960,  6963,
    6973,  6983,  6987,  6992,  6991,  6996,  7006,  7011,  7017,  7022,
    7027,  7029,  7031,  7033,  7035,  7037,  7045,  7054,  7056,  7058,
    7060,  7069,  7077,  7085,  7087,  7089,  7099,  7106,  7112,  7120,
    7128,  7132,  7136,  7143,  7150,  7160,  7170,  7180,  7193,  7207,
    7220,  7221,  7223,  7225,  7228,  7229,  7232,  7233,  7236,  7237,
    7240,  7241,  7244,  7245,  7247,  7249,  7252,  7264,  7263,  7278,
    7277,  7287,  7288,  7291,  7292,  7296,  7297,  7298,  7306,  7305,
    7317,  7318,  7321,  7321,  7322,  7323,  7324,  7325,  7326,  7327,
    7328,  7329,  7330,  7331,  7334,  7335,  7339,  7338,  7347,  7348,
    7351,  7352,  7353,  7357,  7356,  7366,  7370,  7374,  7386,  7386,
    7394,  7395,  7396,  7401,  7411,  7410,  7426,  7444,  7455,  7462,
    7472,  7443,  7477,  7486,  7487,  7490,  7491,  7503,  7507,  7508,
    7509,  7511,  7513,  7516,  7517,  7520,  7525,  7532,  7537,  7543,
    7545,  7548,  7549,  7552,  7557,  7563,  7565,  7572,  7573,  7574,
    7577,  7579,  7584,  7585,  7590,  7591,  7597,  7602,  7604,  7606,
    7611,  7613,  7624,  7637,  7658,  7659,  7660,  7669,  7670,  7671,
    7676,  7677,  7678,  7679,  7680,  7694,  7708,  7709,  7710,  7713,
    7714,  7715,  7716,  7724,  7739,  7740,  7743,  7749,  7760,  7763,
    7799,  7803,  7811,  7815,  7883,  7898,  7922,  7923,  7939,  7949,
    7952,  7953,  7954,  7958,  7962,  7963,  7988,  8000,  8013,  8025,
    8026,  8035,  8036,  8045,  8046,  8047,  8050,  8063,  8076,  8090,
    8091,  8092,  8093,  8094,  8095,  8096,  8097,  8098,  8099,  8100,
    8101,  8102,  8103,  8104,  8105,  8106,  8107,  8108,  8109,  8110,
    8111,  8112,  8113,  8114,  8115,  8116,  8117,  8118,  8119,  8120,
    8121,  8122,  8123,  8124,  8125,  8126,  8136,  8137,  8138,  8139,
    8140,  8141,  8142,  8143,  8144,  8145,  8146,  8147,  8148,  8149,
    8150,  8151,  8152,  8153,  8154,  8155,  8156,  8157,  8158,  8159,
    8160,  8161,  8162,  8163,  8164,  8165,  8166,  8167,  8168,  8169,
    8170,  8171,  8172,  8173,  8174,  8175,  8176,  8177,  8178,  8179,
    8180,  8181,  8182,  8183,  8184,  8185,  8186,  8187,  8188,  8189,
    8190,  8191,  8192,  8193,  8194,  8195,  8196,  8197,  8198,  8199,
    8200,  8201,  8202,  8203,  8204,  8205,  8206,  8207,  8208,  8209,
    8210,  8211,  8212,  8213,  8214,  8215,  8216,  8217,  8218,  8219,
    8220,  8221,  8222,  8223,  8224,  8225,  8226,  8227,  8228,  8229,
    8230,  8231,  8232,  8233,  8234,  8235,  8236,  8237,  8238,  8239,
    8240,  8241,  8242,  8243,  8244,  8245,  8246,  8247,  8248,  8249,
    8250,  8251,  8252,  8253,  8254,  8255,  8256,  8257,  8258,  8259,
    8260,  8261,  8262,  8263,  8264,  8265,  8266,  8267,  8268,  8269,
    8270,  8271,  8272,  8273,  8274,  8275,  8276,  8277,  8278,  8279,
    8280,  8281,  8282,  8283,  8284,  8285,  8286,  8287,  8288,  8289,
    8290,  8291,  8292,  8293,  8294,  8295,  8296,  8297,  8298,  8299,
    8300,  8301,  8302,  8303,  8304,  8305,  8306,  8307,  8308,  8309,
    8310,  8311,  8312,  8313,  8314,  8315,  8316,  8317,  8318,  8319,
    8320,  8321,  8322,  8323,  8324,  8325,  8326,  8327,  8328,  8329,
    8330,  8331,  8332,  8333,  8334,  8335,  8336,  8337,  8338,  8339,
    8340,  8341,  8342,  8343,  8344,  8345,  8346,  8347,  8348,  8349,
    8350,  8351,  8352,  8353,  8354,  8355,  8356,  8357,  8358,  8359,
    8360,  8361,  8368,  8367,  8381,  8382,  8385,  8386,  8389,  8389,
    8466,  8467,  8468,  8469,  8473,  8474,  8478,  8479,  8480,  8481,
    8485,  8486,  8487,  8488,  8492,  8493,  8496,  8576,  8589,  8593,
    8598,  8605,  8620,  8633,  8654,  8661,  8699,  8742,  8756,  8757,
    8758,  8759,  8763,  8764,  8771,  8780,  8781,  8782,  8783,  8784,
    8792,  8791,  8807,  8808,  8811,  8812,  8815,  8823,  8824,  8825,
    8826,  8831,  8830,  8851,  8863,  8876,  8875,  8894,  8895,  8899,
    8900,  8904,  8905,  8906,  8907,  8909,  8908,  8919,  8920,  8921,
    8922,  8923,  8929,  8934,  8941,  8954,  8966,  8973,  8978,  8986,
    8999,  9013,  9015,  9018,  9019,  9026,  9028,  9032,  9033,  9036,
    9036,  9037,  9037,  9038,  9038,  9039,  9039,  9040,  9041,  9042,
    9043,  9044,  9045,  9046,  9047,  9048,  9049,  9050,  9051,  9052,
    9053,  9054,  9055,  9056,  9057,  9058,  9059,  9060,  9061,  9062,
    9067,  9068,  9072,  9073,  9077,  9087,  9097,  9110,  9125,  9138,
    9151,  9164,  9165,  9174,  9175,  9184,  9209,  9211,  9218,  9222,
    9225,  9226,  9229,  9250,  9251,  9255,  9259,  9263,  9270,  9271,
    9274,  9275,  9279,  9280,  9286,  9292,  9298,  9308,  9307,  9317,
    9318,  9322,  9323,  9324,  9328,  9329,  9330,  9334,  9335,  9339,
    9349,  9356,  9366,  9375,  9389,  9390,  9395,  9394,  9429,  9430,
    9431,  9435,  9435,  9459,  9460,  9464,  9465,  9466,  9470,  9475,
    9474,  9494,  9500,  9521,  9543,  9545,  9550,  9552,  9554,  9566,
    9576,  9589,  9591,  9593,  9598,  9603,  9605,  9607,  9613,  9614,
    9620,  9621,  9623,  9629,  9628,  9643,  9644,  9648,  9653,  9661,
    9661,  9679,  9688,  9701,  9702,  9704,  9706,  9719,  9717,  9794,
    9793,  9803,  9832,  9841,  9850,  9802,  9874,  9878,  9882,  9886,
    9890,  9894,  9900,  9907,  9914,  9923,  9924,  9928,  9929,  9930,
    9934,  9935,  9939,  9940,  9940,  9945,  9946
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STD_SYM", "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@46", "@47", "@48", "@49",
  "@50", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@51", "@52", "@53", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "@132", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@133", "opt_option", "option_value_list", "option_type_value",
  "@134", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@135",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@136", "handler", "@137", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@138",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@139", "@140", "@141",
  "@142", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@143", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@144",
  "union_opt", "union_order_or_limit", "@145", "order_or_limit",
  "union_option", "subselect", "@146", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@147", "view_list_opt",
  "view_list", "view_select", "@148", "view_select_aux",
  "view_check_option", "trigger_tail", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "@154", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@155",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   818,    40,    41,    44,    33,   123,   125,    64,
      46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   583,   584,   584,   585,   585,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   587,   588,   588,   589,   590,   590,   592,
     591,   593,   593,   594,   594,   595,   597,   596,   599,   598,
     600,   600,   601,   601,   601,   601,   601,   601,   601,   601,
     601,   601,   601,   601,   602,   602,   602,   602,   604,   603,
     605,   603,   606,   603,   607,   603,   603,   608,   609,   609,
     610,   611,   612,   613,   614,   615,   610,   616,   616,   617,
     617,   618,   618,   618,   618,   618,   618,   618,   619,   619,
     619,   620,   620,   622,   621,   623,   623,   624,   624,   625,
     625,   626,   626,   627,   627,   628,   629,   630,   630,   631,
     631,   632,   633,   633,   633,   633,   634,   634,   635,   635,
     636,   636,   638,   637,   637,   639,   637,   637,   641,   640,
     642,   642,   643,   643,   644,   645,   645,   646,   646,   647,
     647,   647,   647,   647,   648,   648,   649,   649,   651,   650,
     652,   650,   653,   650,   650,   650,   654,   650,   650,   650,
     650,   655,   650,   650,   656,   656,   656,   657,   657,   659,
     660,   661,   658,   662,   662,   662,   663,   663,   665,   666,
     664,   668,   667,   669,   669,   670,   670,   672,   673,   671,
     675,   676,   674,   677,   677,   679,   678,   680,   680,   682,
     681,   681,   683,   684,   681,   685,   681,   686,   686,   687,
     687,   687,   688,   688,   688,   688,   689,   690,   689,   691,
     692,   691,   693,   691,   695,   696,   694,   697,   697,   698,
     698,   699,   699,   700,   700,   701,   701,   702,   702,   703,
     704,   704,   705,   705,   706,   706,   707,   707,   707,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   709,   710,   711,   712,   712,   712,   712,   712,
     712,   713,   713,   713,   714,   714,   714,   715,   715,   716,
     716,   717,   717,   717,   717,   718,   718,   719,   719,   720,
     720,   721,   721,   721,   721,   721,   722,   722,   723,   724,
     724,   725,   727,   726,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   729,
     728,   730,   728,   728,   728,   731,   731,   731,   731,   731,
     731,   731,   731,   732,   733,   733,   734,   734,   735,   735,
     735,   735,   735,   736,   736,   736,   736,   736,   737,   737,
     737,   738,   738,   738,   739,   740,   740,   741,   741,   742,
     742,   742,   743,   743,   744,   744,   745,   745,   746,   746,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   748,   748,   749,   749,   750,   750,   751,   751,   752,
     752,   753,   753,   754,   754,   755,   756,   756,   757,   757,
     758,   758,   759,   759,   759,   759,   759,   759,   760,   760,
     761,   761,   761,   761,   762,   762,   764,   763,   765,   765,
     766,   766,   767,   767,   768,   768,   769,   769,   769,   769,
     769,   770,   770,   770,   770,   770,   771,   771,   771,   772,
     772,   773,   773,   774,   774,   775,   775,   775,   776,   776,
     776,   776,   777,   777,   777,   778,   778,   778,   779,   779,
     780,   780,   781,   781,   782,   782,   783,   783,   785,   784,
     786,   784,   787,   784,   788,   784,   789,   784,   790,   790,
     791,   791,   791,   791,   791,   792,   793,   793,   793,   794,
     793,   795,   796,   793,   793,   793,   793,   793,   793,   793,
     793,   793,   793,   793,   793,   793,   793,   797,   797,   798,
     798,   799,   799,   799,   800,   800,   800,   801,   801,   801,
     801,   803,   802,   802,   804,   802,   802,   805,   806,   806,
     808,   807,   809,   809,   810,   810,   810,   811,   811,   812,
     812,   814,   813,   816,   815,   818,   817,   819,   819,   819,
     821,   820,   822,   822,   823,   823,   824,   824,   824,   826,
     825,   828,   827,   829,   829,   830,   830,   831,   831,   831,
     831,   831,   831,   833,   832,   834,   834,   834,   836,   835,
     835,   837,   837,   838,   838,   839,   840,   841,   841,   842,
     843,   843,   845,   844,   846,   846,   847,   849,   848,   850,
     850,   851,   851,   852,   853,   853,   854,   854,   856,   855,
     858,   859,   857,   860,   860,   860,   860,   860,   861,   861,
     862,   862,   863,   863,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   865,   865,   865,   866,   866,   866,
     867,   868,   869,   870,   870,   871,   871,   871,   871,   871,
     872,   872,   874,   873,   875,   875,   876,   877,   876,   878,
     878,   879,   879,   880,   880,   880,   880,   880,   880,   880,
     881,   881,   881,   881,   881,   881,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     883,   883,   884,   884,   885,   885,   885,   886,   886,   886,
     886,   886,   887,   887,   887,   887,   887,   887,   888,   888,
     889,   889,   890,   890,   891,   891,   892,   892,   893,   893,
     893,   893,   893,   893,   894,   894,   895,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   897,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   898,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   898,   898,   898,   898,   899,   899,
     899,   900,   900,   902,   901,   903,   903,   904,   905,   905,
     905,   905,   905,   905,   905,   906,   907,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   908,
     905,   910,   909,   911,   911,   911,   912,   912,   913,   913,
     914,   914,   916,   915,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   918,   918,   920,   919,   921,
     921,   922,   922,   924,   923,   925,   925,   926,   926,   927,
     927,   928,   928,   929,   929,   930,   931,   931,   932,   932,
     933,   932,   934,   932,   935,   932,   932,   936,   932,   937,
     932,   932,   938,   932,   939,   932,   932,   940,   940,   940,
     942,   941,   943,   941,   941,   941,   945,   944,   947,   948,
     946,   949,   950,   951,   951,   952,   952,   953,   953,   953,
     953,   955,   954,   956,   956,   957,   957,   957,   958,   958,
     959,   959,   959,   959,   959,   959,   959,   959,   959,   959,
     959,   959,   959,   960,   960,   960,   960,   960,   960,   960,
     960,   960,   961,   961,   961,   961,   962,   962,   962,   963,
     963,   964,   964,   965,   966,   965,   967,   968,   967,   969,
     969,   970,   970,   971,   971,   972,   972,   972,   973,   974,
     974,   975,   976,   976,   978,   977,   979,   979,   980,   980,
     980,   981,   981,   982,   982,   983,   984,   984,   984,   985,
     985,   985,   985,   986,   986,   987,   987,   987,   987,   987,
     987,   988,   988,   988,   988,   988,   989,   990,   989,   991,
     991,   992,   992,   993,   995,   994,   996,   996,   997,   997,
     999,   998,  1001,  1000,  1000,  1000,  1003,  1002,  1004,  1005,
    1004,  1004,  1004,  1004,  1004,  1004,  1004,  1006,  1006,  1007,
    1008,  1008,  1009,  1009,  1011,  1012,  1010,  1014,  1015,  1013,
    1016,  1016,  1016,  1016,  1017,  1017,  1018,  1018,  1019,  1020,
    1020,  1020,  1021,  1020,  1022,  1022,  1023,  1023,  1024,  1023,
    1025,  1023,  1026,  1026,  1027,  1027,  1028,  1029,  1029,  1030,
    1030,  1032,  1031,  1033,  1033,  1034,  1034,  1035,  1035,  1036,
    1037,  1036,  1039,  1040,  1038,  1041,  1041,  1042,  1043,  1043,
    1044,  1045,  1045,  1047,  1046,  1049,  1048,  1050,  1048,  1051,
    1048,  1052,  1052,  1053,  1053,  1054,  1054,  1055,  1055,  1056,
    1056,  1056,  1057,  1058,  1058,  1059,  1059,  1060,  1060,  1061,
    1061,  1061,  1061,  1061,  1061,  1061,  1061,  1061,  1062,  1062,
    1064,  1063,  1065,  1065,  1065,  1065,  1065,  1066,  1065,  1065,
    1065,  1065,  1065,  1067,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1068,  1068,
    1069,  1069,  1070,  1070,  1071,  1071,  1072,  1072,  1073,  1073,
    1074,  1074,  1075,  1075,  1076,  1076,  1076,  1078,  1077,  1079,
    1077,  1080,  1080,  1081,  1081,  1082,  1082,  1082,  1084,  1083,
    1085,  1085,  1087,  1086,  1086,  1086,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1088,  1088,  1090,  1089,  1091,  1091,
    1092,  1092,  1092,  1094,  1093,  1095,  1096,  1096,  1098,  1097,
    1099,  1099,  1099,  1100,  1102,  1101,  1101,  1104,  1105,  1106,
    1107,  1103,  1103,  1108,  1108,  1109,  1109,  1109,  1110,  1110,
    1110,  1111,  1111,  1112,  1112,  1113,  1113,  1113,  1113,  1114,
    1114,  1115,  1115,  1116,  1116,  1117,  1117,  1118,  1118,  1118,
    1119,  1119,  1120,  1120,  1121,  1121,  1122,  1122,  1122,  1122,
    1123,  1123,  1123,  1124,  1125,  1125,  1125,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1127,
    1127,  1127,  1127,  1127,  1128,  1128,  1129,  1129,  1130,  1131,
    1131,  1132,  1132,  1133,  1133,  1133,  1134,  1134,  1134,  1134,
    1135,  1135,  1135,  1136,  1137,  1137,  1138,  1139,  1140,  1141,
    1141,  1142,  1142,  1143,  1143,  1143,  1144,  1144,  1144,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1148,  1147,  1149,  1149,  1150,  1150,  1152,  1151,
    1153,  1153,  1153,  1153,  1154,  1154,  1155,  1155,  1155,  1155,
    1156,  1156,  1156,  1156,  1157,  1157,  1158,  1158,  1159,  1159,
    1159,  1159,  1159,  1159,  1159,  1160,  1160,  1160,  1161,  1161,
    1161,  1161,  1162,  1162,  1162,  1163,  1163,  1163,  1163,  1163,
    1165,  1164,  1166,  1166,  1167,  1167,  1168,  1169,  1169,  1169,
    1169,  1171,  1170,  1172,  1172,  1173,  1172,  1174,  1174,  1175,
    1175,  1176,  1176,  1176,  1176,  1177,  1176,  1178,  1178,  1178,
    1178,  1178,  1179,  1180,  1180,  1180,  1180,  1181,  1182,  1182,
    1182,  1183,  1183,  1184,  1184,  1185,  1185,  1186,  1186,  1188,
    1187,  1189,  1187,  1190,  1187,  1191,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1192,  1192,  1193,  1193,  1194,  1194,  1194,  1195,  1195,  1195,
    1195,  1196,  1196,  1197,  1197,  1198,  1198,  1198,  1199,  1199,
    1200,  1200,  1201,  1202,  1202,  1202,  1202,  1202,  1203,  1203,
    1204,  1204,  1205,  1205,  1205,  1205,  1205,  1207,  1206,  1208,
    1208,  1209,  1209,  1209,  1210,  1210,  1210,  1211,  1211,  1212,
    1213,  1213,  1214,  1215,  1216,  1216,  1218,  1217,  1219,  1219,
    1219,  1221,  1220,  1222,  1222,  1223,  1223,  1223,  1224,  1225,
    1224,  1226,  1227,  1228,  1229,  1229,  1230,  1230,  1230,  1231,
    1231,  1232,  1232,  1232,  1233,  1234,  1234,  1234,  1235,  1235,
    1236,  1236,  1236,  1238,  1237,  1239,  1239,  1240,  1240,  1242,
    1241,  1243,  1243,  1244,  1244,  1244,  1244,  1246,  1245,  1248,
    1247,  1249,  1250,  1251,  1252,  1247,  1253,  1253,  1253,  1253,
    1253,  1253,  1254,  1254,  1254,  1255,  1255,  1256,  1256,  1256,
    1257,  1257,  1258,  1259,  1258,  1260,  1260
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     0,     2,     1,     3,     0,     6,
       0,     5,     0,     5,     0,     5,     0,    11,     0,     1,
       0,     2,     2,     1,     3,     2,     3,     2,     4,     0,
       6,     0,     0,     8,     4,     4,     3,     3,     2,     2,
       6,     5,     3,     5,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     2,     1,     0,     1,     1,
       1,     0,     5,     3,     0,     5,     3,     3,     0,     3,
       0,     2,     1,     3,     0,     1,     1,     0,     2,     1,
       3,     0,     6,     0,     6,     0,     5,     0,     1,     1,
       0,     6,     0,     1,     1,     2,     1,     1,     1,     0,
       6,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     6,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     5,     1,     3,     2,
       1,     1,     0,     6,     1,     3,     3,     0,     2,     0,
       4,     0,     2,     1,     2,     4,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     4,     3,     1,     1,
       4,     0,     0,     1,     1,     0,     2,     2,     1,     1,
       0,     2,     0,     3,     0,     3,     3,     0,     3,     0,
       3,     2,     1,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     1,     3,     1,     3,     3,     1,     3,     3,     4,
       4,     1,     3,     3,     3,     3,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     1,     1,     3,     2,     2,     2,     2,     3,     3,
       5,     6,     4,     4,     7,     4,     2,     6,     5,     6,
       6,     4,     4,     3,     4,     6,     8,     6,     8,     6,
       4,     6,     4,     6,     4,     4,     4,     4,     6,     8,
       2,     2,     4,     2,     7,     7,     3,     4,     4,     6,
       6,     4,     6,     6,     6,     4,     6,     4,     6,     8,
      10,    12,     6,     4,     6,     6,     1,     6,     4,     8,
      10,     4,     1,     3,     4,     6,     6,     8,     6,     6,
       4,     6,     6,     8,     4,     4,     6,     4,     2,     4,
       4,     4,     6,     4,     4,     3,     8,     6,     4,     6,
       3,     6,     8,     4,     8,     6,     8,     6,     8,     2,
       4,     4,     4,     6,     8,     8,     4,     7,     7,     7,
       6,     6,     6,     6,     6,     6,     0,     5,    10,     3,
       4,     3,     2,     2,     2,     4,     6,     4,     4,     6,
       6,     6,     6,     4,     6,     4,     6,     4,     4,     4,
       4,     6,     4,     6,     4,     6,     4,     4,     6,     4,
       6,     4,     6,     4,     4,     6,     4,     6,     0,     3,
       3,     0,     1,     0,     2,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,    10,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     1,     0,     3,     2,     3,     2,     1,     2,     1,
       2,     1,     1,     1,     2,     0,     1,     0,     2,     1,
       3,     1,     3,     0,     2,     1,     3,     0,     1,     0,
       2,     4,     5,     1,     1,     1,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     0,    11,     3,     6,     0,     3,     0,     0,
       5,     0,     1,     0,     1,     0,     2,     0,     2,     2,
       2,     0,     6,     0,     1,     3,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       2,     0,     1,     0,     0,     3,     0,     0,     3,     2,
       0,     0,     4,     4,     2,     0,     2,     2,     3,     3,
       1,     2,     0,     1,     0,     4,     4,     2,     0,     1,
       1,     0,     1,     0,     1,     2,     1,     3,     3,     1,
       1,     1,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     0,     6,     0,
       1,     3,     1,     2,     0,     2,     3,     1,     2,     1,
       0,     3,     0,     5,     2,     1,     0,     3,     6,     0,
       6,     4,     4,     4,     4,     5,     4,     1,     3,     1,
       0,     2,     0,     1,     0,     0,     8,     0,     0,     6,
       0,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       3,     4,     0,     3,     3,     1,     2,     2,     0,     3,
       0,     5,     3,     1,     3,     1,     3,     1,     1,     0,
       1,     0,     4,     0,     1,     3,     1,     1,     1,     0,
       0,     6,     0,     0,    11,     3,     1,     3,     3,     1,
       3,     0,     1,     0,     4,     0,     6,     0,     5,     0,
       6,     1,     3,     3,     5,     0,     2,     0,     2,     1,
       1,     1,     3,     0,     1,     0,     1,     1,     3,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     0,     3,
       0,     3,     2,     4,     4,     4,     4,     0,     4,     6,
      16,     2,     2,     0,     6,     5,     2,     2,     2,     1,
       5,     5,     2,     2,     1,     4,     3,     2,     2,     2,
       3,     2,     2,     2,     1,     1,     3,     4,     3,     3,
       2,     2,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     0,     1,     0,     2,     0,     1,     1,     1,
       0,     2,     0,     2,     0,     2,     2,     0,     4,     0,
       4,     1,     1,     0,     1,     0,     1,     1,     0,     4,
       3,     1,     0,     3,     4,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     3,     3,     1,
       1,     1,     2,     0,     3,     3,     2,     2,     0,     4,
       0,     1,     1,     2,     0,     4,     5,     0,     0,     0,
       0,    18,     2,     0,     1,     0,     1,     1,     0,     1,
       1,     0,     2,     2,     1,     3,     4,     3,     3,     0,
       2,     2,     1,     3,     3,     0,     3,     0,     3,     2,
       3,     1,     1,     2,     0,     2,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     3,     5,     1,     1,
       1,     1,     1,     3,     4,     5,     1,     5,     3,     2,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     0,     1,     1,     3,     0,     2,
       1,     1,     1,     1,     0,     1,     0,     1,     1,     1,
       0,     2,     2,     2,     1,     2,     4,     5,     4,     6,
       2,     3,     3,     3,     5,     1,     3,     3,     2,     2,
       2,     1,     1,     4,     4,     1,     1,     1,     1,     1,
       0,     4,     1,     1,     1,     3,     3,     1,     1,     2,
       2,     0,     3,     4,     3,     0,     7,     1,     2,     1,
       1,     1,     1,     1,     1,     0,     5,     1,     1,     1,
       1,     1,     3,     6,     6,     6,     7,     3,     8,     8,
       8,     0,     1,     1,     2,     0,     1,     1,     3,     0,
       3,     0,     3,     0,     3,     0,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       0,     1,     3,     1,     2,     2,     2,     1,     3,     3,
       1,     1,     3,     1,     3,     4,     5,     1,     0,     3,
       3,     1,     1,     0,     2,     2,     2,     2,     0,     2,
       2,     1,     2,     2,     2,     2,     2,     0,     3,     0,
       1,     0,     3,     2,     0,     1,     2,     0,     1,     4,
       4,     5,     2,     3,     0,     1,     0,     4,     0,     1,
       1,     0,     2,     2,     1,     0,     1,     1,     4,     0,
       7,     1,     0,     0,     2,     3,     1,     1,     1,     0,
       3,     1,     2,     1,     2,     3,     3,     3,     0,     1,
       0,     3,     3,     0,     8,     0,     3,     1,     3,     0,
       2,     3,     5,     0,     3,     4,     4,     0,    14,     0,
       6,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  2008,   635,     0,  1957,     0,     0,     0,     0,
       0,  1959,    94,    54,  1273,  1381,  1382,  1196,  1212,     0,
     635,    97,     0,    66,  1214,  1418,     0,     0,   635,     0,
    1413,     0,     0,   635,  1217,  1406,     0,    97,  1959,     0,
     670,  1794,  1310,     0,     0,     0,  1293,  1851,  1262,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   663,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1383,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   538,     0,   570,
       0,     0,  2009,  1999,   637,   636,     0,  1843,  1842,   603,
    1959,     0,  1566,  1567,  1568,  1569,  1570,  1571,  1572,  1530,
    1573,  1574,  1575,  1531,  1532,  1576,  1577,  1578,  1579,  1581,
    1580,  1582,  1533,  1534,  1583,  1584,  1585,  1535,  1536,  1586,
    1587,  1537,  1588,  1589,  1590,  1538,  1591,  1539,  1592,  1593,
    1594,  1595,  1596,  1540,  1597,  1598,  1599,  1600,  1601,  1602,
    1603,  1541,  1604,  1605,  1606,  1607,  1623,  1608,  1542,  1609,
    1610,  1611,  1624,  1543,  1614,  1613,  1612,  1615,  1616,  1617,
    1544,  1618,  1619,  1620,  1621,  1626,  1627,  1628,  1545,  1622,
    1629,  1625,  1777,  1631,  1630,  1632,  1634,  1633,  1546,  1635,
    1547,  1636,  1637,  1514,  1638,  1515,  1640,  1641,  1644,  1645,
    1639,  1646,  1647,  1642,  1643,  1548,  1649,  1650,  1651,  1652,
    1653,  1654,  1655,  1665,  1658,  1660,  1661,  1663,  1659,  1664,
    1668,  1667,  1669,  1670,  1671,  1666,  1657,  1662,  1672,  1673,
    1656,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,
    1684,  1683,  1685,  1686,  1687,  1688,  1689,  1691,  1690,  1692,
    1693,  1694,  1696,  1695,  1697,  1549,  1698,  1699,  1700,  1701,
    1702,  1550,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1551,
    1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1648,  1728,
    1552,  1729,  1730,  1553,  1731,  1554,  1732,  1733,  1555,  1734,
    1735,  1736,  1737,  1738,  1739,  1556,  1740,  1557,  1742,  1741,
    1743,  1745,  1746,  1558,  1744,  1559,  1747,  1748,  1749,  1751,
    1750,  1752,  1753,  1560,  1754,  1561,  1755,  1756,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1770,
    1771,  1772,  1773,  1768,  1769,  1562,  1774,  1775,  1776,  1778,
    1779,  1563,  1780,  1781,  1565,  1782,  1783,  1786,  1784,  1785,
    1787,  1788,  1789,  1790,  1564,  1791,   123,  1519,    99,  1520,
    1529,     0,   605,   621,  1960,  1961,   270,   510,   511,   269,
     509,    97,  1999,     0,   266,   267,     0,  1287,  1017,  1210,
    1210,     0,  1210,  1213,  1210,    97,  1210,     0,    59,  1388,
       0,     0,     0,     0,  1513,     0,  1220,  1420,  1424,     0,
       0,  1840,     0,     0,     0,     0,    97,   638,     0,  1271,
       0,   601,     0,  1961,  1972,   664,   668,   680,  1795,  1792,
    1366,   590,   590,   590,   588,   590,  1294,     0,     0,  1271,
    1423,  2045,     0,     0,     0,  2041,     0,  2046,     0,   670,
       0,     0,     1,     3,     0,  1619,  1379,  1377,  1510,     0,
     530,   539,   534,   532,     0,     0,  2010,   619,     0,  1958,
       0,   647,   657,   125,     0,    68,     0,     0,     0,  1964,
       0,     0,     0,     0,    95,   319,  1999,  2001,  2003,   270,
     268,     0,  1291,  1290,  1289,     0,  1287,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1210,    61,     0,
    1885,  1900,  1901,  1897,  1902,  1903,  1907,     0,  1899,  1891,
       0,  1906,  1895,  1904,     0,  1889,     0,  1905,  1910,  1893,
    1898,  1877,     0,  1883,  1887,  1512,  1116,  1854,  1855,     0,
    1525,  1516,  1524,  1523,    67,  1222,  1223,  1221,   569,  1421,
    1422,     0,  1435,     0,     0,     0,   633,     0,  1361,  1360,
       0,  1414,  1973,     0,     0,   610,  1225,  1272,     0,  1224,
    1411,     0,  1410,  1407,  1409,     0,  1885,  1872,     0,  1967,
    1964,  1974,   693,   686,   685,   688,   689,   692,   690,   691,
     687,   684,   701,   681,   683,  1798,     0,     0,   444,     0,
    1374,     0,     0,     0,  1374,     0,  1151,  1367,     0,  1807,
    1345,   507,   506,     0,   505,  1808,  1344,  1360,     0,     0,
       0,  1329,     0,  1295,  1334,  1809,     0,  1363,     0,  1151,
    1374,     0,  1311,     0,     0,     0,     0,   584,   594,   586,
     581,     0,   587,   583,  1292,  1209,  1852,   569,  1472,  1471,
    1517,  2042,  1470,  2050,  2052,  2038,  2040,  2047,   666,     0,
    1978,    53,     0,  1385,  2006,  2007,  2005,   460,   107,   107,
     528,     0,     0,     0,     0,     0,  1207,     0,     0,   649,
     659,   127,   124,    98,     0,   607,   623,  1963,     0,     0,
    1965,  1969,   775,   774,     0,    92,   710,  1526,  1937,    96,
    1933,  2004,   320,   701,   701,   701,  1994,     0,  1996,  1997,
    1998,  2010,  2002,     0,   512,     0,  1274,  1277,  1281,  1285,
    1288,  1567,  1530,     0,  1575,     0,     0,  1483,     0,     0,
       0,     0,  1535,     0,     0,  1589,     0,     0,  1540,     0,
       0,     0,   710,   710,   710,     0,     0,     0,  1602,  1603,
    1492,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1480,     0,  1493,     0,     0,     0,     0,     0,     0,
       0,  1631,     0,     0,  1632,     0,     0,     0,  1482,  1637,
       0,     0,     0,     0,     0,     0,     0,  1652,     0,     0,
    1490,     0,     0,  1023,     0,  1679,  1681,     0,     0,     0,
    1685,     0,     0,  1686,  1687,  1688,  1467,   777,     0,   710,
    1479,  1489,  1700,  1706,  1473,     0,  1708,     0,  1709,     0,
    1716,     0,     0,     0,     0,     0,     0,  1738,  1740,     0,
       0,  1757,     0,     0,     0,   710,  1770,  1771,  1772,  1773,
       0,  1481,  1562,  1491,     0,     0,     0,  1782,   710,   710,
     710,     0,     0,     0,  1788,     0,  1791,  1027,     0,     0,
       0,     0,   776,     0,   991,     0,  1019,   712,   717,   722,
     729,   735,   749,   751,   753,   756,   761,   767,     0,   862,
     769,   856,   792,   791,  1018,  1477,   790,   789,  1478,   787,
    1500,  1519,  1466,  1499,  1211,  1201,  1202,     0,  1203,  1206,
    1931,  1204,   571,     0,     0,    60,  1402,  1396,  1398,  1401,
    1397,     0,  1403,  1400,  1399,  1843,  1389,  1391,  1392,  1886,
    1884,  1918,  1917,     0,  1919,  1915,  1908,  1938,  1912,  1938,
    1914,  1913,  1938,  1909,  1916,  1938,  1881,     0,  1117,  1118,
       0,  1853,     0,  1511,     0,  1419,  1436,     0,  1437,  1425,
    1433,   652,     0,  1116,  1841,  1844,     0,     0,    56,    57,
       0,   640,     0,   639,   643,     0,     0,     0,  1228,  1218,
    1227,  1412,     0,     0,  1884,  1881,  1968,     0,  1970,  1985,
     669,  1975,   699,   671,   698,     0,   682,  1793,  1796,  1804,
    1343,  1370,   443,     0,     0,  1342,  1326,     0,   270,     0,
       0,     0,     0,  1312,  1317,   304,     0,  1333,  1152,     0,
    1374,     0,  1337,  1350,  1338,     0,  1364,     0,  1374,  1307,
       0,     0,  1299,  1304,  1300,     0,  1306,  1305,  1308,  1296,
    1297,  1322,  1351,  1364,  1327,  1332,  1341,  1368,  1369,     0,
    1321,  1328,     0,  1339,  1364,  1364,  1374,  1374,   597,   596,
     595,   591,   592,   597,     0,  1060,     0,     0,  2039,  2053,
    2037,  2048,  2049,  2036,   667,  1979,   665,  1980,     0,  1380,
    1378,  1386,  1387,   461,   531,   460,   261,   264,   263,     0,
     535,   533,   460,  2000,     0,     0,   623,     0,     0,   651,
     646,   650,   648,   502,   501,   504,     0,   658,     0,   128,
     130,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    69,    70,    83,   609,
     608,   606,   631,   630,   628,     0,   629,   627,   622,   624,
     625,  1962,  1966,   271,   460,     0,  1528,     0,     0,     0,
       0,     0,     0,     0,  1995,    88,     0,     0,     0,  1279,
    1275,  1285,     0,     0,     0,  1116,     0,     0,     0,  1121,
       0,   806,  1121,  1121,  1121,     0,     0,  1017,  1017,     0,
    1017,     0,     0,     0,     0,  1121,   830,   833,     0,   831,
       0,     0,     0,     0,     0,  1486,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1017,     0,     0,     0,     0,
     996,     0,     0,     0,     0,   786,     0,     0,     0,     0,
    1017,     0,     0,     0,     0,  1023,     0,  1021,     0,  1121,
       0,     0,  1121,     0,     0,     0,     0,     0,  1017,  1017,
    1017,   721,     0,   878,     0,     0,     0,     0,     0,  1017,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1121,  1121,     0,     0,     0,  1121,     0,   899,     0,  1488,
       0,     0,     0,  1487,     0,     0,  1485,  1484,  1468,     0,
       0,     0,   922,   924,   923,  1121,     0,  1121,     0,     0,
       0,  1028,     0,   795,   794,   796,  1992,     0,     0,     0,
       0,     0,     0,     0,   714,   719,   778,     0,   779,   780,
       0,   781,   782,   783,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   797,  1091,  1092,  1093,  1094,  1103,  1106,
    1095,  1096,  1097,  1105,  1098,  1099,  1100,  1107,  1108,  1109,
    1101,  1110,  1104,  1102,  1111,     0,  1090,     0,     0,     0,
    1469,   916,     0,  1199,     0,   573,   572,  1205,   571,     0,
      62,    64,  1395,     0,     0,  1404,  1911,     0,  1892,  1896,
    1890,  1894,     0,     0,  1882,     0,  1888,  1120,  1627,  1695,
       0,  1123,  1857,  1215,  1432,  1434,     0,     0,  1426,     0,
       0,   623,    58,     0,     0,  1415,     0,     0,     0,     0,
     612,  1226,     0,  1408,     0,     0,     0,     0,     0,  1971,
    1987,  1986,  1976,   701,  1142,   702,   704,   703,  1499,  1798,
    1801,  1802,  1805,  1803,     0,  1800,  1799,  1814,     0,  1372,
    1375,  1376,     0,     0,  1353,  1352,  1348,  1349,     0,  1161,
    1162,  1160,  1155,  1156,  1159,  1357,  1355,  1346,     0,  1374,
       0,  1356,  1354,  1301,  1302,  1303,     0,  1151,     0,  1374,
    1364,     0,  1374,  1374,  1336,  1340,     0,   585,   594,   582,
     589,  1072,  1071,     0,  1036,     0,  1035,  1034,  1033,     0,
    1071,  2043,  2051,  2055,     0,  1151,  1984,  1982,   262,  1249,
    1249,     0,     0,     0,     0,     0,     0,     0,   108,   117,
     567,   567,  1249,  1249,   567,  1249,  1249,  1249,     0,     0,
    1249,     0,     0,   567,     0,  1249,   565,     0,     0,  1249,
    1249,  1249,   567,     0,  1249,  1249,  1249,  1249,  1249,   577,
    1249,  1249,  1249,   564,   274,   296,   297,   529,     0,   543,
     566,  2011,  2012,   536,   620,   604,  1208,     0,   126,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   632,   626,    93,   711,
    1527,     0,  1934,  2031,     0,     0,  2013,   272,   515,   517,
     516,   514,   513,     0,     0,  1123,     0,  1282,  1060,  1286,
    1285,  1283,     0,     0,     0,  1122,  1121,     0,  1002,  1169,
    1170,  1166,  1167,  1165,  1168,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   975,
       0,  1002,     0,   836,     0,     0,     0,     0,     0,     0,
    1499,     0,     0,     0,     0,     0,  1992,     0,     0,     0,
       0,     0,     0,   813,     0,     0,     0,     0,     0,     0,
       0,  1114,  1112,  1115,  1113,     0,     0,   997,   989,     0,
       0,     0,     0,   863,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1024,  1025,  1121,     0,     0,
       0,  1121,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     885,     0,     0,     0,     0,     0,   890,     0,     0,     0,
       0,     0,     0,     0,  1121,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   919,     0,   921,
       0,     0,  1502,  1501,     0,     0,     0,     0,     0,  1029,
     670,     0,   799,  1017,   798,     0,  1810,   992,   994,     0,
     716,   713,   718,   732,   725,   730,   723,   727,     0,   784,
    1572,   733,     0,     0,  1130,   747,     0,     0,   750,     0,
       0,     0,     0,   752,   754,   755,   758,   862,   757,   862,
     765,   766,   762,   763,   764,   768,     0,   788,   793,  1020,
     963,  1503,  1200,  1932,  1198,    65,     0,     0,  1390,  1405,
    1393,  1942,     0,  1941,  1927,  1930,  1510,     0,     0,     0,
    1867,  1861,  1868,  1870,  1864,  1869,  1871,  1862,  1863,  1858,
    1865,  1124,  1153,     0,     0,   653,   654,   657,     0,  1847,
    1848,  1846,  1845,   634,  1417,  1416,     0,   641,   644,   645,
     617,   616,   618,   611,   613,   614,   254,  1232,     0,     0,
       0,  1238,  1219,  1229,   602,     0,     0,     0,     0,     0,
     697,  1060,  1190,   694,   675,  1153,  1143,   674,   705,     0,
    1797,     0,  1768,  1825,     0,     0,     0,     0,     0,  1815,
    1371,     0,  1323,     0,  1347,  1359,  1358,  1318,     0,     0,
       0,  1316,  1365,     0,  1335,  1298,  1315,  1123,  1364,  1313,
    1314,   599,   598,   593,  1071,  1060,     0,     0,  1057,  1073,
       0,  1073,  1060,  1060,     0,  1060,  1116,  1068,     0,     0,
    2054,  1144,  1983,  1247,  1248,  1250,     0,     0,   111,   114,
     112,     0,   113,     0,     0,   568,   522,   503,   503,   547,
       0,   336,   522,   496,   545,     0,     0,     0,     0,     0,
       0,     0,     0,  1249,     0,   558,   541,     0,     0,     0,
       0,   559,     0,   542,  1249,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   580,   579,   578,     0,     0,
       0,     0,   275,   460,   339,     0,   574,   336,   342,  1506,
    2015,  1087,     0,  1086,   129,    76,    72,    84,  1174,  1175,
    1173,  1171,  1172,    85,    74,    75,    79,    78,    80,    81,
      82,    77,    73,    86,    87,    71,     0,  1935,     0,   238,
     237,     0,  2029,  2015,     0,   339,    89,  1438,   273,   276,
      90,  1060,  1142,  1285,  1123,     0,  1116,     0,   805,   820,
       0,     0,   968,     0,     0,   970,   971,   972,     0,   824,
       0,   822,   825,   826,   827,  1017,     0,     0,     0,     0,
    1017,   974,     0,   832,     0,     0,   837,   838,     0,   811,
       0,   845,     0,   847,     0,  1017,     0,   841,     0,   802,
       0,     0,  1017,     0,   853,     0,   814,     0,     0,   954,
       0,   937,   933,     0,   935,     0,     0,  1017,  1017,     0,
     858,     0,     0,   864,  1017,     0,   956,     0,   938,     0,
     870,     0,  1017,     0,  1022,     0,     0,     0,   981,   874,
     875,     0,   979,   940,     0,     0,   877,   942,     0,   944,
       0,   939,   946,   947,   879,   881,   880,   949,     0,     0,
     951,     0,   953,     0,   883,   884,     0,     0,     0,   888,
       0,  1017,   893,   983,   985,     0,     0,     0,     0,     0,
     987,   900,   902,     0,     0,     0,   901,     0,     0,     0,
       0,     0,     0,     0,   906,     0,     0,   920,   986,   812,
     984,   925,     0,   928,     0,   927,     0,     0,     0,     0,
    1991,  1993,     0,     0,   803,     0,     0,     0,     0,     0,
    1504,   771,   770,     0,   773,   772,     0,   726,   731,   724,
     728,     0,     0,     0,     0,   745,   744,     0,     0,  1130,
     748,     0,   760,   759,   861,     0,   962,   701,  1017,     0,
      63,  1394,  1939,     0,     0,     0,     0,     0,     0,     0,
       0,  1856,  1154,  1259,  1518,  1427,     0,   661,  1849,  1850,
       0,   615,   680,     0,  1251,  1236,  1243,  1237,     0,     0,
       0,  1235,  1495,  1494,  1501,  1974,     0,     0,     0,     0,
    1977,  1123,  1123,  1184,     0,     0,   672,   677,   673,   676,
       0,   700,   709,   708,  1496,  1503,     0,     0,     0,     0,
     446,   448,   447,   456,     0,   445,     0,     0,  1810,     0,
     452,   454,   453,  1820,   451,  1373,  1151,  1331,  1330,  1158,
    1157,     0,  1309,  1325,  1374,     0,  1981,  1066,     0,  1059,
    1058,  1074,     0,  1060,  1073,  1073,     0,  1039,  1038,  1263,
    1266,     0,  1037,  1077,  1064,   680,  2044,  2056,     0,   459,
     458,   303,   455,   302,   116,   115,   121,   122,   341,   523,
     497,   498,     0,     0,     0,   503,   335,   522,   334,   337,
     512,     0,   286,   283,   549,   289,   285,   301,     0,     0,
     290,   522,   556,   557,   571,   279,     0,   315,   316,   314,
     298,   281,   282,   551,  1138,  1140,  1148,   288,   287,   284,
     293,   294,   312,   311,   292,   313,   562,   310,   308,   305,
     307,   306,   309,   291,   280,     0,   544,     0,   325,   327,
     328,  1509,     0,   576,   546,     0,   329,   330,     0,     0,
       0,     0,   660,     0,  1936,  2032,   241,   239,   240,     0,
       0,     0,   244,     0,   242,     0,     0,  1440,  1439,   243,
     257,   460,   277,     0,  1123,  1163,  1278,  1284,     0,     0,
       0,   969,  1003,     0,   422,   422,  1013,  1011,   411,   422,
    1007,  1012,  1009,     0,     0,     0,     0,     0,     0,     0,
     976,   973,     0,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1000,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   958,  1026,   982,   980,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1030,   808,  1988,  1989,   800,  1811,  1812,
    1813,   524,   993,   715,   720,     0,   738,  1017,   736,  1129,
     742,     0,     0,   746,     0,   917,     0,   964,   965,     0,
    1016,  1505,  1940,  1929,  1928,  1943,  1943,  1943,     0,  1125,
       0,  1216,  1438,   655,     0,   656,   642,   701,  1233,  1245,
       0,  1253,     0,     0,  1230,  1240,     0,     0,     0,  1239,
       0,  1874,  1875,  1873,  1153,  1131,     0,     0,  1195,     0,
    1191,   695,     0,   707,   706,     0,  1827,     0,  1826,  1838,
    1839,  1836,  1837,  1835,  1816,     0,  1822,  1821,     0,     0,
       0,  1832,  1823,     0,     0,  1324,     0,  1319,   600,     0,
    1060,  1073,  1060,  1046,     0,     0,  1060,  1042,  1040,  1044,
       0,  1123,     0,     0,     0,     0,  1061,   701,  1498,  1145,
    1148,   338,   522,   499,   500,   512,     0,     0,     0,     0,
     456,   299,   555,   554,   300,     0,     0,  1149,  1150,  1141,
       0,   548,   339,   575,   476,   407,   356,   347,   422,   350,
     349,   393,   364,   361,   411,   409,   379,   411,   411,   386,
     385,   403,   389,   369,   462,   462,   368,   406,   462,   390,
     388,   392,     0,   394,   411,   399,   387,   391,   408,   384,
     381,   405,   422,   422,   362,   365,   404,   462,     0,   397,
     422,   426,   367,   462,   468,     0,     0,   422,   424,  1508,
    2017,     0,  2019,  1085,   142,   701,     0,   101,  2030,  2019,
       0,   247,   272,   258,     0,   278,     0,  1280,     0,  1276,
     786,   817,   821,   930,     0,  1004,   462,     0,  1014,   413,
    1006,  1008,  1010,   807,   823,   828,   932,   810,   809,     0,
       0,     0,     0,   843,   846,   848,   839,   844,   842,     0,
     931,   855,   852,   854,   815,     0,   955,   934,   936,   857,
     868,   998,  1001,     0,     0,     0,   869,   865,   957,   866,
       0,   871,   840,   872,     0,     0,     0,     0,   941,   876,
     943,   945,   950,   948,   952,   882,   819,     0,   887,   889,
     801,   786,   891,     0,   897,   895,     0,     0,   903,     0,
       0,   912,     0,   910,     0,   911,     0,   913,   914,     0,
     926,   929,  1031,     0,  1974,     0,   995,   734,     0,   740,
    1017,   737,   743,   702,   701,   915,     0,  1948,  1948,  1948,
    1258,  1257,     0,  1256,  1260,     0,   662,   255,     0,     0,
       0,  1254,  1242,  1978,  1231,  1234,  1503,  1876,   679,     0,
    1126,  1194,  1192,     0,  1185,  1187,  1189,     0,  1497,     0,
       0,  1831,  1817,   457,     0,     0,     0,     0,  1818,     0,
    1116,  1067,     0,     0,  1033,  1060,  1060,     0,  1033,     0,
       0,     0,  1265,  1142,  1267,  1075,  1079,  1080,  1078,  1069,
       0,  1147,     0,     0,     0,   561,     0,   574,   563,   426,
    1139,   295,   326,   482,     0,     0,   366,   415,   410,     0,
     415,   415,   468,   470,   464,   468,     0,   375,   393,   370,
       0,   462,   383,   374,   395,   398,   400,   402,   415,     0,
     462,   363,   372,     0,   415,   434,     0,     0,     0,   430,
       0,   475,     0,   437,   343,   427,   429,     0,     0,   396,
       0,   352,   469,     0,   354,     0,     0,   415,     0,   425,
     415,     0,  2016,     0,  2023,     0,   145,   143,   144,     0,
     138,   140,   135,     0,   323,   324,   322,   321,     0,   131,
    2023,   245,  1978,  1438,     0,   250,     0,  1148,   520,  1164,
       0,     0,  1005,     0,     0,   977,   834,   835,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   804,
       0,     0,     0,     0,     0,     0,     0,   909,   907,   908,
       0,  1032,  1993,   525,   739,     0,   705,   966,     0,     0,
    1947,  1945,     0,  1946,  1944,  1920,     0,  1879,  1880,  1878,
    1866,     0,     0,  1428,  1153,  1244,  1246,  1252,  1241,     0,
    1127,  1142,  1441,  1188,     0,   696,  1829,  1828,  1830,  1824,
       0,     0,     0,     0,  1065,  1060,  1047,     0,  1051,  1056,
    1052,     0,  1043,  1041,     0,  1163,     0,  1081,  1153,  1148,
       0,     0,     0,     0,     0,     0,     0,     0,   560,  1474,
     550,   552,     0,     0,     0,   477,   478,   483,   485,     0,
       0,   419,   420,   421,   376,   416,   418,     0,   378,   346,
     463,   471,   472,     0,   467,   465,   468,   371,   401,   377,
       0,   373,     0,   360,   440,   439,   710,   432,   442,     0,
       0,   438,   428,   436,   431,     0,     0,     0,     0,   344,
       0,   345,  1507,  2018,     0,   537,   701,   701,  2020,  2033,
     142,     0,     0,     0,     0,   132,   134,   135,  2014,   248,
     246,     0,  1974,    91,     0,   519,     0,   818,   423,   412,
       0,   829,   849,     0,   816,   999,   990,  1121,   859,     0,
     867,   873,   960,   959,   886,   892,   896,   894,   898,   904,
     905,  1017,  1990,   741,   967,  1926,  1925,  1924,  1921,     0,
       0,     0,     0,     0,     0,  1949,  1951,  1255,     0,     0,
     256,   694,   317,  1135,  1148,     0,  1153,     0,  1449,  1186,
    1834,  1833,  1819,     0,     0,     0,     0,     0,     0,     0,
    1088,  1264,  1076,     0,  1070,  1146,     0,     0,   331,  1476,
    1475,   574,   488,   489,   490,     0,     0,     0,   481,   484,
     355,   348,   417,     0,   526,   473,   466,     0,   359,   441,
     710,   435,   462,   468,   462,   468,     0,     0,     0,   670,
       0,   109,   139,     0,   701,   100,   102,     0,     0,   252,
     251,  1148,     0,     0,     0,     0,     0,     0,  1922,  1952,
    1955,  1953,  1954,  1956,  1950,     0,     0,   318,     0,     0,
    1132,  1134,  1128,  1176,     0,     0,     0,     0,  1442,  1444,
       0,  1193,     0,  1062,  1048,     0,  1053,     0,  1045,     0,
    1083,     0,   332,   553,   492,     0,   491,     0,   486,   487,
     482,     0,   462,     0,   462,   433,   351,   353,   357,   358,
       0,  2024,     0,  2021,     0,  2034,   141,     0,     0,   133,
     136,  1978,   518,   521,   414,   850,     0,   978,   860,   918,
    1261,  1269,     0,  1429,  1136,  1137,  1148,     0,   678,     0,
       0,     0,     0,  1443,     0,     0,  1450,  1452,     0,     0,
       0,     0,  1089,     0,  1084,   333,   494,   495,   493,   479,
     480,   380,   527,   382,  2025,  2026,  1978,   119,   118,   110,
       0,   178,     0,   103,   253,     0,     0,     0,   449,  1133,
    1177,  1447,  1448,     0,  1445,     0,     0,  1451,     0,     0,
    1050,  1055,  1082,  2022,   120,     0,   194,   182,     0,     0,
       0,   180,   208,  2035,     0,     0,   184,   206,   207,   185,
    1521,     0,  1522,  2027,     0,   851,  1268,  1270,     0,  1430,
       0,  1446,  1454,  1453,     0,  1063,   193,   196,     0,     0,
     199,   189,   188,   190,     0,     0,     0,   179,   229,   178,
     178,   232,   187,   225,   178,   104,   450,  1441,   701,     0,
     195,     0,     0,     0,   181,   209,   220,   223,   215,   150,
     178,     0,   178,     0,     0,  2028,   109,  1449,     0,     0,
    1180,  1182,     0,   191,     0,     0,     0,     0,   178,   216,
       0,   146,     0,     0,   148,   235,     0,   227,   105,  1455,
    1183,  1178,   701,  1320,     0,   183,   200,   217,   223,   213,
     221,   178,     0,     0,   178,     0,   231,   149,     0,   233,
     226,   228,   178,     0,  1457,  1181,   192,   197,   178,     0,
     214,     0,     0,   212,   161,   160,     0,   152,   174,   230,
       0,   151,     0,   178,   106,     0,     0,  1464,     0,   178,
     218,     0,   178,     0,     0,     0,     0,     0,   147,     0,
     178,  1456,  1459,     0,     0,  1461,  1462,     0,  1431,   198,
     203,     0,   210,   178,   155,   175,   176,     0,   158,   236,
       0,  1463,  1458,     0,  1465,   199,   178,   202,   178,     0,
       0,   153,   167,   154,   165,   157,     0,   234,  1460,   204,
     178,   178,   173,   171,   178,   162,   169,   164,     0,   170,
     177,   168,     0,   159,     0,   156,   172,   166,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   978,    58,   528,
     925,  1390,  1391,    59,   425,    60,   704,  1136,  1137,  1138,
      61,  1607,  2473,  1154,   402,   420,   386,  2778,  3049,  3418,
    3514,  3566,  3612,  1100,  3415,  1528,  3469,  1529,    62,   493,
     702,  1118,  1119,  3224,  3225,  3221,  3226,  3039,  3040,  3041,
    3042,  3604,  3560,  3581,  3605,  3645,  3679,  3685,  3686,  3626,
    3694,  3695,  3696,  3702,  3697,  3627,  3681,  3561,  3504,  3534,
    3530,  3505,  3594,  3529,  3616,  3552,  3553,  3618,  3660,  3677,
    3506,  3507,  3535,  3576,  3508,  3536,  3598,  3557,  3599,  3619,
    3661,  3558,  3577,  3622,  3580,  3509,  3564,  3610,  3542,  3559,
    3563,  3633,  3608,  2051,  2459,  2056,  2464,  3052,  2469,  3232,
    3421,  1881,  2282,  3114,  2784,  1094,  1095,  1096,   403,   404,
     405,   501,  2057,  1563,  2058,  2059,  1565,  1566,  1024,  2433,
    2424,  2410,  3280,   725,  3048,  2437,  2438,  2439,  2440,  2388,
    2389,  1970,  1971,  2017,  2448,  2761,  2979,  2999,  2762,  2763,
    2764,  2765,  2766,  2767,  2768,  2798,  2799,  3174,  3175,  3176,
    2795,  3030,  3014,  3015,  3016,  3197,  2986,  2322,  2323,  3519,
    2332,  2333,  2370,  2656,  2371,  1099,  2987,  3024,  3184,  3017,
    2447,  2973,  3165,  3317,  3166,  3167,  3168,  3398,  1972,  2387,
    1115,  1116,   651,   406,  1168,  1611,  3056,  3057,  2378,  2886,
    3323,    63,  1102,   687,   689,   688,  2020,   480,  1567,  1568,
    1569,  2699,  2705,  3311,  1974,   111,  1387,  2444,  2008,    64,
    1073,  1068,    65,   662,   657,   658,  1071,  1072,  1497,  1932,
      66,   595,    67,   488,    68,   496,  1141,    69,   986,  1873,
    1874,  1875,    70,   694,    71,   497,  1148,  1149,  1150,    72,
     976,   116,    73,   584,   981,   983,   984,    74,   490,   491,
    1110,    75,  1417,  1855,  1856,   699,   700,  1117,  2615,    76,
      77,   471,   445,   601,   446,   447,  1444,  1893,  3281,   612,
     613,   614,  2306,  1003,  1004,  1005,  1898,  1445,  2311,  1156,
    2901,  1324,  1781,   887,  1325,  1782,   888,   889,   890,   891,
     892,   893,   894,   895,   896,   897,  2233,  2236,  3018,   898,
    1334,  1792,   899,   900,  1820,   901,  2847,  2255,  2256,  2257,
    2597,  2598,   902,  2090,  2810,  2128,   903,  1321,  1777,  1688,
    3071,  2831,  1627,  2073,  2493,  2599,   517,   518,   904,  1246,
    1247,  1248,  1705,  1312,  2219,  1769,  1504,  1505,  1506,  1507,
    2950,  2949,  2951,  3295,  3137,  3297,  3141,  1943,  1508,  1509,
    3449,  2346,  2670,  2364,  2365,  3148,  1934,  1510,  2352,  3147,
    2686,  2956,  3303,  3453,  2022,  3299,  1375,  1376,  1685,   960,
     961,  1628,  1852,  2270,  3121,  3285,  2245,  2920,  3283,  3370,
    1570,  2414,  2415,  1895,  1896,  2368,  2689,  2709,  1027,  3282,
    2272,  1472,  1473,  2789,  3684,  2033,  3438,  3520,  3569,  3570,
    3571,  2638,  2639,  2924,  2925,  1897,  2303,  2640,  3122,    78,
     408,    79,  1822,   695,   696,   520,   417,    80,   426,  1853,
      81,   439,  1432,   568,   588,   989,   990,  1882,  2283,  2290,
    1883,  2295,  2913,  2285,  2618,  2619,  1955,  1956,  2286,  2621,
    2910,  2902,  2903,  2611,  3112,    82,   459,  2681,  2359,  2360,
    3430,  3431,   589,    83,   407,   736,  1615,  1173,  1614,   737,
     738,  1175,   515,   516,    84,   457,  1048,  1049,  1050,  1487,
      85,   450,   652,  1468,  2336,  1917,   580,   654,  1479,   655,
    1480,  1459,  1912,  1015,    86,   683,   682,    87,   476,  1090,
      88,   529,   936,   937,  1395,  1830,    89,   440,   593,   594,
      90,   434,   581,  1425,    91,   427,   571,    92,    93,   572,
     969,  2612,  3279,  3478,  3547,  1416,   970,  2470,  3288,  3378,
    3379,  3381,  3446,  3447,  3614,  3637,  3654,  3655,  3658,   905,
     671,   906,  3158,   907,   908,  2291,  2292,  2690,   909,  3432,
     910,  2018,   665,   423,   911,   562,   912,  2275,   913,  3511,
     717,   718,   389,   390,    94,   615,   449,  1007,  1008,  1009,
    1454,  1455,   656,  2228,  1456,  1457,  1909,  1904,  2932,  2662,
    2654,    95,   575,   938,   974,   975,  1861,    96,   458,    97,
     962,  1411,  1412,  1849,  2269,  1850,    98,   597,    99,   551,
    1405,   552,   940,   553,   554,   952,   947,   955,   949,  3269,
    3104,  3105,  1837,   921,   719,   720,  1398,  1832,  1833,  2897,
    3107,  3275,  3276,   100,   120,   395,   499,   711,   997,   101,
     102,   103,   104,  1000,  1085,  1889,  1086,  1087,  1088,  1517,
    1442,  1319,  2884,  2221,  1771,  2575,   504,   726,   486,   506,
     507,   112,   113,   727,   728,  2053,  2451,  2771,  3034,  3035,
    3218,  3215,   729,  3544,   730,  2460,  2048,  2774,  3341,  3471,
     105,   673,   468,  1083,  1078,  1080,  1513,  1950
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3263
static const int yypact[] =
{
    3809, -3263,   171,   886,   619, -3263,   141, 43530,   525,   619,
     619,   300,   656, -3263, -3263, -3263, -3263, -3263,   604, 43530,
     886, -3263, 22003, -3263, -3263, -3263,   216,   619,   886, 43530,
   -3263,   413,   777,   886, -3263, -3263,   619, -3263,   300, 43530,
   -3263,   510, -3263,   415,   685,   442,   430, -3263, -3263, 43530,
     696,  -146,   945,   972, -3263, -3263,   631, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, 22556, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263,   926, 43530, 43530, -3263,
   43530,   591, -3263,   981, -3263, -3263,   619, -3263, -3263, -3263,
     300, 22003, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,   571, -3263,
   -3263,   668, -3263, -3263, -3263,  1156,   963, -3263, -3263, -3263,
   -3263, -3263,   351,   724, -3263,   734,  1023,   751, -3263,  1058,
    1058, 43530,  1058, -3263,  1058, -3263,  1058,   619, -3263, -3263,
    1701, 43530,   948,   361,  -116, 38580,   208,   177, -3263,  1056,
   22003, -3263,   619,  1122,   740, 43530, -3263, -3263,   619,   663,
     549, -3263,  1943,   106, -3263, -3263, -3263,   330, -3263, -3263,
    4334, -3263, -3263, -3263,   754, -3263, -3263, 22003,   619,  1036,
   -3263, -3263,   133,   133,   133, -3263,   133, -3263,   133, -3263,
    -146,   743, -3263, -3263, 43530,  -107, -3263, -3263,   728,   490,
   -3263, -3263, -3263, -3263, 22003,  1177,   863, -3263, 22003, -3263,
      -9, -3263, -3263,   758, 43530, -3263, 22003, 22003,   404,   748,
     542, 43530, 36380,   928, -3263,   166,   981,  1325, -3263,   963,
   -3263, 43530, -3263, -3263, -3263, 40230,   751, -3263, 14108,  1195,
   43530, 43530,  1007, 43530, 43530, 36380, 22003,  1058,   830,  1181,
     991,   967,   653, -3263, -3263, -3263, -3263,  1040, -3263, -3263,
     889, -3263, -3263, -3263,   137, -3263,    56, -3263, -3263, -3263,
   -3263, -3263,  1055,   828, -3263, -3263,    93, -3263, -3263, 43530,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,  1198, -3263,
   -3263, 14108,   176,  1367,  1259, 22003, -3263,  -193, -3263, -3263,
    1174, -3263, -3263, 36380, 22003, -3263, -3263, -3263, 19781, -3263,
   -3263,  1393, -3263,   868, -3263, 22003,   991, -3263,  1107,  1027,
     748,   951, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263,   888,   330, -3263, -3263,  1215,  1347, -3263,  1065,
     -25,   998,   938,    95,   -25, 38580,  1263, -3263,   135, -3263,
    1350, -3263, -3263,  1063, -3263, -3263, -3263,  1076,  1087,  1264,
    1077, -3263,   169,   267, -3263, -3263,     8, -3263,   -99,  1263,
     -25,   186, -3263,  1300,  1424,   247,  -162, -3263,   702, -3263,
   -3263,  1491, -3263, -3263, -3263, -3263, -3263,  1198, -3263, -3263,
   -3263,  1005, -3263,  1227,  1109, -3263, -3263,    36, -3263,  1017,
     643, -3263,  -101, 36930, -3263, -3263, -3263,    99, -3263, -3263,
   -3263, 36380,  1165,  1082, 22003,   318, -3263, 40780, 22003, -3263,
     192, 14108, -3263, -3263,  1593,    -3,   117, -3263,  1548,  1211,
   -3263, -3263, -3263, -3263,  1460, -3263,  1046,  1049,  1419,  1060,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263,  1096, -3263, -3263,
   -3263,   863, -3263, 22003,  -166, 22003, -3263,  1071, -3263,  1094,
   -3263,  1075,  1115,  1120,  1124,  1132, 16988, -3263,  1136,  1142,
    1147,  1162,  1168,  1183,  1187,  1188,  1192,  1193,  1202,  1203,
    1205,  1206,  1046,  1046,  1208,  1209,  1210,  1213,   561,  1216,
   -3263,  1217,  1218,  1219,  1220,  1221,  1225,  1228,  1229,  1230,
    1232, -3263,  1233, -3263,  1234,  1235,  1237,  1239,  1244,  1246,
    1247,  1248,  1249,  1252,  1253,  1254,  1255,  1260, -3263,  1261,
    1265,  1266, 14108,  1267,  1268,  1269,  1270,  1271,  1272,  1274,
   -3263,  1275,  1276,  1277,  1278,  1282,  1283,  1284,  1285,  1286,
    1287,  1288,  1289,  1290,  1292,  1299, -3263, -3263, 14108,  1307,
   -3263, -3263,  1309,  1311, -3263,  1312,  1313,  1314,  1315,  1316,
    1324,  1326,  1330,  1331,  1332,  1333,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,  1341,  1342,  1344,   673,  1348,  1349,   796,
    1352, -3263,  1353, -3263,   143,  1356,  1357,  1358,  1046,  1046,
    1046,  1359,  1360,  1361,  1362,  1363,  1365, 14108, 16988, 16988,
   16988,  9500, -3263, 43530, -3263, 43530, -3263,  1097, -3263, -3263,
    1439, -3263,  1069,  1139,   -71,   633,   228,  1112, 16988,  3240,
     357, -3263, -3263, -3263,  1092,  1279, -3263, -3263, -3263, -3263,
   -3263,  1366, -3263,  1111, -3263, -3263, -3263, 22003, -3263, -3263,
   -3263,  1196,    69, 22003,  1257, -3263, -3263, -3263, -3263, -3263,
   -3263,  1737, -3263, -3263, -3263,  1346,  1262, -3263, -3263, -3263,
   -3263, -3263, -3263,  1317, -3263, -3263, -3263,  1368, -3263,  1368,
   -3263, -3263,  1368, -3263, -3263,  1368,   535,  2777, -3263, -3263,
   43530, -3263, 44080, -3263, 19781, -3263, -3263,  1508, -3263, -3263,
    1662, -3263,  1636,   132,  1369, -3263, 22003, 38580, -3263, -3263,
     111,  1370,  1442,  1371, -3263,  1444, 22003, 22003, -3263, -3263,
   -3263, -3263,   549,    53,  1372,   675, -3263, 43530, -3263,   276,
   -3263, -3263, -3263,  1373, -3263, 14108, -3263,  1377, -3263,   664,
   -3263,  1714, -3263,  1465, 14108, -3263, -3263,  1390,   963, 43530,
   43530, 22003, 22003, -3263, -3263, -3263,   581, -3263, -3263, 43530,
     -25, 36380, -3263, -3263, -3263,  1788,   186, 43530,   -25, -3263,
    1732,  1483, -3263, -3263, -3263,  1806, -3263, -3263,  1797,  1392,
   -3263, -3263, -3263,   186, -3263, -3263, -3263, -3263, -3263, 22003,
   -3263, -3263,   186, -3263,   186,   186,   -25,   -25,  1447, -3263,
   -3263,  1397, -3263,  1447,  1528,   623,   133,  1613, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,   539, -3263,
   -3263, -3263, -3263, -3263, -3263,   104, -3263, -3263, -3263,  1222,
     814,   814,  1412, -3263,   226, 22003,   117,  1465, 22003, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263,  1405, -3263,  1406,  1404,
   -3263,  1839,  1841,  1843,  1849,  1850,  1852,  1854,  1855,  1857,
    1859,  1860,  1861,  1866,  1867,  1868,  1440, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,  1489, -3263, -3263, -3263, -3263,
     909, -3263, -3263, -3263,    99,  1443, -3263, 38580,  1971, 36380,
   43530, 43530,  1840, 22003, -3263, -3263,   253,   253,  1674,  1071,
   -3263,    84, 43530,  1845, 26422,    91, 14108, 14108, 14108,   815,
     162,  1957,  2010,  2010,  2010, 14108, 14108, -3263, -3263, 14108,
   -3263, 14108, 14108, 14108, 14108,   851, -3263, -3263, 10076, -3263,
    1449, 14108, 14108,  1536, 14108,  1279, 14108, 14108, 23109, 14108,
   14108, 14108, 14108, 14108,  -100, 14108,  3240, 14108, 14108, 14108,
    1457, 14108, 14108, 14108, 14108, -3263, 14108, 14108,   290, 14108,
    1907,   -54, 14108, 14108, 14108, -3263, 10652, 14108, 14108, 14108,
   -3263, 14108, 14108, 14108, 14108, -3263,  2024, -3263, 23109,   891,
   14108, 14108,   929, 14108, 14108, 14108, 14108, 14108, -3263, -3263,
   -3263, -3263, 10076, -3263, 14108, 14108, 14108, 14108, 14108, -3263,
   16988, 14108, 11228, 14108, 14108, 14108, 14108,  1461, 14108, 14108,
    2010,  2010, 14108, 14108, 14108,   995, 10076, -3263, 14108,  1279,
     151,   151, 14108,  1279,  8348, 14108, -3263, -3263, -3263,   -54,
   11804,  1462, -3263, -3263, -3263,  2010, 23109,  2010, 14108, 14108,
   14108, -3263,  1492,  1957,  1957,  1957, -3263,  9500,   766,  1464,
   14108, 24215,  1454, 14108, -3263, -3263, -3263, 16988, -3263, -3263,
     588, -3263, -3263, -3263, 14684,  1466, 16988, 16988,  1789, 16988,
   16988,   677, 16988, 16988, 16988, 16988, 16988, 16988, 16988, 16988,
   16988, 16988, 16988,  1957, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,  1474, -3263, 38580, 16988, 14108,
   -3263, -3263, 43530, -3263, 36380, -3263, -3263, -3263,    69, 38580,
    1467, -3263, -3263,  1653,  1181, 22003, -3263, 43530, -3263, -3263,
   -3263, -3263, 20334, 20334, -3263, 20334, -3263, -3263,    94,    96,
    1321,  1498, -3263, -3263, -3263, -3263,  1827, 22003, -3263,   547,
   22003,   117, -3263, 14108,  1465, -3263, 36380, 36380, 22003, 22003,
      18, -3263,   414, -3263,  1465,  1864, 20334, 20334, 20334, -3263,
   -3263, -3263, -3263, -3263,    92, -3263, -3263, -3263,  1469, -3263,
   -3263, -3263, -3263, -3263, 41330,   163, -3263, -3263,  1465,  1871,
   -3263, -3263,  1478, 43530, -3263, -3263, -3263, -3263,   -26, -3263,
   -3263, -3263, -3263,   -73, -3263, -3263, -3263, -3263,  1612,   -25,
   43530, -3263, -3263, -3263, -3263, -3263,  1678,  1263,   267,   -25,
     186, 22003,   -25,   -25, -3263, -3263,   914, -3263,   702, -3263,
   -3263, -3263, -3263, 43530,  1044,  1624,  1488, -3263, -3263, 22003,
   -3263,  1490, -3263,  1892,  2021,  1263, -3263, -3263, -3263,   433,
     433,  1465,  1606,  1608,  1610,  1616,  1617,  1645, -3263, -3263,
     690,  2012,   433,   433,  2012,   433,   433,   433,  1583,  1960,
     433,  1846,  1600,   747,  1848,   433, -3263,  1602,  1965,   433,
     433,   433,  2012,  2043,   433,   433,   433,   433,   433,   119,
     433,   433,   433, -3263,  3058, -3263, -3263,  1515, 20887, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, 41880, -3263, 14108,
     162,  1465,  1465,   672,  1465,   162,  1465,  1465,  1465,  1465,
    1465,   162,  1465,  1465,   162,  1593, -3263, -3263, -3263, -3263,
   -3263,   -86, -3263, -3263,  1102, 43530, -3263,  2090, -3263, -3263,
   -3263, -3263, -3263, 22003,  1561,  1498, 26422, -3263,   623, -3263,
    1512, -3263,  1521,  1529,   778, -3263,  2010,  1530, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,  1527,  1531,  1534,  1535,  2092,
    1537,  -186,  1538,  1542,  1543,  1540,  1544,  -203,  1546, -3263,
    1549,  1551,  1550, -3263,  1547,  1553,  1552,  1556,  1559,  1562,
    1545,   806,   818,  1563,  1565,   842, -3263,  1567,  1569,  1962,
    1573,  1574,   858, -3263,  1576,  1577,  1578,   871,  1581,   896,
     907, -3263, -3263, -3263, -3263,  1582,  1584, -3263, -3263,  -199,
    1587,  1588,  1589, -3263,  1591,  1594,  1595,   912,  1597,  1599,
     919,  1601,  1603,  1598,  1604,  1605, -3263,  2010,  1609,  1611,
    1614,  2010,  1615,   925,  1618,  1621,   932,   935,  1622,  1623,
    1625,  1626,  1628,  1629,   939,  1631,   950,  1633,    26,  1634,
   -3263,  1635,  1637,  1638,  1639,   953, -3263,  1640,  1642,  1643,
    1644,  1648,    87,  1649,  2010,  1646,  1652,   957,  1654,  1655,
    1657, 12380, 12956, 13532,    -5,  1659,   317, -3263,  1658, -3263,
    1661,  1663, -3263,  1545,  1665,   969,   973,  1668, 14108,  -189,
   -3263,  -100, -3263, -3263, -3263,  1590,    66, -3263,  1719, 43530,
   -3263,   823,  1541, -3263, -3263, -3263, -3263, -3263,   521, -3263,
    1619, -3263,  1667,  9500,   658,  1627, 16988,    82,  1139,  1670,
   16988, 16988, 16988,   -71,   633,   633,   228,  3240,   228,  3240,
    1112,  1112,  1112,  1112,  1112,  1957, 14108, -3263,  1957, -3263,
    1671,   262, -3263, -3263, -3263, -3263,  1257,  1889, -3263,  1669,
   -3263, -3263,   984, -3263,  1630, -3263,  1656,  1664,  1677,  1686,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263,  1263,   414,  1702,  1672, -3263, -3263,  1696,  1940,
   -3263, -3263, -3263, -3263, -3263, -3263,  1713, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,   175, -3263, -3263,  1675,  1675,
   18670, -3263, -3263, -3263, -3263,  1870,  2053,  2074,  2075,  -101,
   -3263,   140, -3263,   134,  2025,  1263, -3263,  2078, 39130, 26974,
   -3263,  1682,  2022,  1683,   433, 34730,   367, 24765, 35280, -3263,
   -3263,   672, -3263,    52, -3263, -3263, -3263, -3263,   581,   581,
    1706, -3263, -3263,  1919, -3263, -3263, -3263,  1498,   186, -3263,
   -3263, -3263,  1689, -3263, -3263,   623,  2029,  2030, -3263,  1912,
      45,  1912,   623,   623, 23109,   623,  1480, -3263,   162,  1967,
   -3263, -3263, -3263, -3263, -3263, -3263, 37480, 35830, -3263, -3263,
   -3263,  2172, -3263,  2175,   835, -3263, 23662,   605,   605, -3263,
      77,   121, 23662, -3263, -3263, 23662,   672,   162, 23662,   162,
    1465,  1465,  1516,   433,   162, -3263, -3263,  2034,  2036, 23662,
   23662, -3263, 38580, -3263,   433,   853,   672,   672, 23662, 23109,
      55,  1465,   162,   162,   952, -3263, -3263, -3263, 22003,  1099,
   38580,  1704, -3263,  2908, 18117, 43530,   306,   149, -3263,  1695,
    1705, -3263,  1002, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263,  1790, -3263,  1707, -3263,
   -3263,   129, -3263,  1705, 22003, 17564, -3263,   102, -3263,  1666,
   -3263,   623,  1929,    90,  1498,  1715,    91, 15260, -3263, -3263,
   14108,  1709, -3263, 14108, 14108, -3263, -3263, -3263,   203, -3263,
   38030, -3263, -3263, -3263, -3263, -3263, 14108, 38030,   203, 14108,
   -3263, -3263,  1711, -3263,  2063,  2063, -3263, -3263,  1279, -3263,
   43530, -3263, 14108, -3263, 14108, -3263,  1279, -3263, 14108, -3263,
   14108, 14108, -3263,  1955, -3263, 14108, -3263, 14108, 14108, -3263,
   14108, -3263, -3263, 14108, -3263, 14108, 14108, -3263, -3263,  1956,
   -3263, 14108, 14108, -3263, -3263, 14108, -3263, 14108, -3263, 14108,
   -3263, 14108, -3263, 14108, -3263, 16988, 23109,  1721, -3263, -3263,
   -3263,  1722, -3263, -3263, 14108, 14108, -3263, -3263, 14108, -3263,
   14108, -3263, -3263, -3263, -3263, -3263, -3263, -3263, 14108, 14108,
   -3263, 14108, -3263, 14108, -3263, -3263, 14108, 14108, 14108, -3263,
   14108, -3263, -3263, -3263, -3263, 15836, 14108, 14108, 14108,  1724,
   -3263, -3263, -3263, 14108, 14108, 14108, -3263, 14108,  2125, 14108,
    2126, 14108,  2127, 14108, -3263, 14108,  1966, -3263, -3263, -3263,
   -3263, -3263, 14108, -3263, 14108, -3263,  1746, 14108, 14108,  2169,
   -3263, -3263,  1738,  1739, -3263,  1735,  1736,  1740, 38580, 14108,
   -3263, -3263, -3263, 14108, -3263, -3263, 14108, -3263, -3263, -3263,
   -3263,  -100,  1004,  1743, 16988, -3263,  1627, 16988,  9500,   658,
    1627,    88, -3263, -3263, -3263,  1747, -3263, -3263,  1748, 43530,
   -3263, -3263, -3263, 43530,  1756, 27526, 36380, 36380, 36380,  1751,
   14108, -3263, -3263,  1981, -3263, -3263, 22003,  2112, -3263, -3263,
   36380, -3263,   330, 23109, -3263,  1752, -3263,  1752,   602,  1754,
    1012, -3263, -3263, -3263,  1749,   951,  2155, 36380, 36380, 36380,
   -3263,  1498,  1498,   636,  1807,  2103, -3263, -3263, -3263, -3263,
   42430, -3263, -3263, -3263, -3263,   284, 43530,  2083, 43530,  8924,
   -3263, -3263, -3263,  2270, 14108, -3263, 36380,   -44,    66,   433,
   -3263, -3263, -3263, -3263, -3263, -3263,  1263, -3263, -3263, -3263,
   -3263,  2060, -3263, -3263,   -25,   914,  -182, -3263,  1118, -3263,
   -3263, -3263,  2100,   623,  1912,  1912,  2102,  1996,   -42,  1769,
   -3263,   433,  1044,   157, -3263,   330, -3263, -3263, 14108, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, 14108,  2107,  2108,   605, -3263, 23662, -3263, -3263,
    -166,    61, -3263, -3263, -3263, -3263, -3263, -3263, 35830,  1465,
   -3263, 23662, -3263, -3263,   139, -3263,  1465, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263,  1772, -3263,  1029, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, 22003, -3263,  1022, -3263, -3263,
   -3263, -3263, 43530, -3263, -3263, 22003, -3263, -3263,  2516, 43530,
   43530,  2330, -3263, 43530, -3263, -3263, -3263, -3263, -3263,  2006,
    -165,  2333, -3263, 22003, -3263,  1778,  1028, -3263, -3263, -3263,
    2335,  2551, -3263,  1781,  1498,  2104, -3263, -3263, 14108,  1782,
    1784, -3263, -3263,  1785,  1791,  1791, -3263, -3263,  1792,  1791,
    2128, -3263,  2136,  1793,  1794,  1796,  1798,  1800,  1801,  1802,
   -3263, -3263,  3240,  3240,  1805,  1786,  1809,  1813,  1814,  1815,
    1816,  1818,  1821,  1822,  1825,  1826,  1828,  1829,  1831,  1832,
    1833,  1834,  1835,  1929,  1836,  1837,  1842,  1844,  1851,  1853,
    1030,  1856,  1858,  1033,   181, -3263, -3263, -3263,  1862,  1863,
    1865,  1873,  1875,  1876,  1878,  1881,  1883,  1847,  1884,  1885,
    1886, 14108,  1887,   114,  1043,  1869, -3263,  1888,  1890,  1893,
    1896, 14108,  1897, 14108,  1898, 14108,  1899,  1902,  1903,  1905,
    1906, 14108,  1811, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263,  1823, -3263,  1097, -3263,  1908, -3263, -3263, -3263,   357,
   -3263,  1066,  1909, -3263, 16988, -3263, 14108,  1910, -3263,  1913,
   -3263, -3263, -3263, -3263, -3263,  -144,  -144,  -144, 16412, -3263,
    2237, -3263,    47, -3263,  2134, -3263, -3263,   888,  1911, -3263,
     433, 16412,  1675,  1980, -3263, -3263,   602, 23109, 26974, -3263,
   36380,  1060,  1060,  1060,  1263,  2206,  1702,  1702, -3263, 25315,
   -3263, -3263,  1978, -3263, -3263, 28078, -3263,   812, -3263, -3263,
   16988,  1218, -3263, -3263, -3263, 37480, -3263, -3263,   433,  1872,
    1891, -3263, -3263, 42980, 14108, -3263,  2274, -3263, -3263,  1914,
     623,  2065,   623, -3263,  2187,  2188,   623, -3263, -3263, -3263,
   23109,  1498, 16412,   605,   605,   605, -3263,   888, -3263,  1915,
    1029, -3263, 23662, -3263, -3263,  -166,  1916,  2315,  2318, 23662,
    2270, -3263, -3263, -3263, -3263,  2516, 23109, -3263, -3263, -3263,
    1068, -3263, 18117, -3263, -3263, -3263,  1918,  1920,  1791, -3263,
   -3263, -3263, -3263, -3263,  1792,  2062, -3263,  1792,  1792, -3263,
   -3263, -3263, -3263, -3263,   148,   194, -3263, -3263,   148, -3263,
   -3263, -3263,    68,   735,  1792, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263,  1791,  1791, -3263, -3263, -3263,   148,  1921, -3263,
    1791,   714, -3263,   197,    85,  1922,  1923,  1791,  1924,  1901,
   -3263,  1070, -3263, -3263,   153, -3263,   635, -3263, -3263, -3263,
    1926, -3263,  3058, -3263,   369, -3263, 43530, -3263,   581, -3263,
    3240, -3263, -3263, -3263,  2095, -3263,   148,  2096, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, 14108,
    1927,  1928,  1930, -3263, -3263, -3263, -3263, -3263, -3263, 14108,
   -3263, -3263, -3263, -3263, -3263, 14108, -3263, -3263, -3263, -3263,
   -3263,  2008, -3263,  2154, 14108, 14108, -3263, -3263, -3263, -3263,
   14108, -3263, -3263, -3263, 14108,  2400,  2082,  1931, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, 14108, -3263, -3263,
   -3263,  3240, -3263, 14108, -3263, -3263, 14108, 14108, -3263, 14108,
   14108, -3263,  1933, -3263,  1934, -3263,  1937, -3263, -3263,  2160,
   -3263, -3263, -3263, 14108,   951, 43530, -3263, -3263,  1941, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263,    74,  1968,  1968,  1968,
    1218, -3263,  1079, -3263, -3263,  2277, -3263,  1373, 23109, 16412,
    1944,  1939, -3263,   643, -3263, -3263,  1942,  1060, -3263,  2472,
    2319, -3263, -3263, 38580,  1946, -3263, -3263,  2209, -3263,   100,
    2133, -3263, -3263, -3263,   -44,  2035,  2037,   433, -3263,  1465,
     337,  1488,  2289,   968,  1997,   623,   623,  1047,  1998, 14108,
   14108,  1958, -3263,  1929, -3263,  2357, -3263, -3263, -3263,  1373,
   14108, -3263,  1959,  1963, 43530, -3263,   790,   306, -3263,   714,
   -3263, -3263, -3263,   -11,  2192,  2195, -3263,   715, -3263,  1964,
     715,   715,  2503,   128, -3263,  2503, 38030, -3263,  1065, -3263,
    1999,   148, -3263, -3263,  2000, -3263, -3263, -3263,   715,  1969,
     148, -3263, -3263,  2200,   715, -3263, 38580,  1465,  1795, -3263,
    2015, -3263,  2433,  2307, -3263,   714, -3263,  2308,  2212, -3263,
    2213, -3263, -3263,  2214, -3263,  2216,  2218,   715,  2221, -3263,
     715, 43530, -3263, 43530,  2002,   388, -3263, -3263, -3263,  1986,
    1987, -3263, -3263, 22003, -3263, -3263, -3263, -3263,  2052, 43530,
    2002, -3263,   643,   102,  1980, -3263,  1081,  1029,  1990, -3263,
    1991,  1992, -3263,  1083,  1993, -3263, -3263, -3263,  1085,  1994,
     133,  2003,  1989,  2004,  1995,  2005,  2007,  2261,  2419, -3263,
    2009,  2011,  2014,  2016,  2017,  2018,  2019, -3263, -3263, -3263,
    2001, -3263, -3263, -3263, -3263,  2020, 39130, -3263,  2091,  2093,
   -3263, -3263,  2097, -3263, -3263,   112,  1067, -3263, -3263, -3263,
   -3263, 16412,  2346, -3263,   671, -3263, -3263, -3263, -3263, 14108,
   -3263,  1929,  2529, -3263, 25315, -3263, -3263, -3263, -3263, -3263,
    2026,  2027,  8924,  2580, -3263,   623, -3263,  2068, -3263, -3263,
   -3263,  2069, -3263, -3263, 43530,  2104,  2366, -3263,   671,  1029,
   43530, 43530,  1098,   -54,   -54,   -54,   706,   706, -3263, -3263,
   -3263, -3263,   575,   130, 43530, -3263, -3263,   879, -3263,  2031,
    2033, -3263, -3263, -3263, -3263,   715, -3263,   133, -3263, -3263,
   -3263, -3263, -3263, 38030, -3263, -3263,  2503, -3263, -3263, -3263,
     133, -3263,  2038, -3263, -3263, -3263,  1046, -3263, -3263,  2269,
    2073, -3263, -3263, -3263, -3263,  2040,  2041,  2044,  2048, -3263,
    2042, -3263, -3263, -3263,   811, -3263, -3263, -3263, -3263, -3263,
     779, 43530,  2432,  1465,  2051,  2054, -3263, -3263, -3263, -3263,
   -3263,  2056,   951, -3263, 43530, -3263,  2272, -3263, -3263, -3263,
    2273, -3263, -3263, 14108, -3263, -3263, -3263,  2010, -3263, 14108,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,   146,
    2278,   162,   162,   162,   162,  1067, -3263, -3263,  2110,  2141,
   -3263,   134, -3263,  -209,  1029, 14108,  1263,    63,  2376, -3263,
   -3263, -3263, -3263,  2360,  1130, 14108,  2066, 14108,  2067,  1103,
   -3263, -3263, -3263,  2071, -3263, -3263,  1105,  1121, -3263, -3263,
   -3263,   306, -3263, -3263, -3263,   383,   383,  1127, -3263, -3263,
   -3263, -3263, -3263,  1133, -3263, -3263, -3263,  1137, -3263, -3263,
    1046, -3263,   148,  2503,   148,  2503,  2583,  2293,  2587, -3263,
    -146, -3263, -3263,  2516, -3263, -3263, -3263, 43530,  2516, -3263,
   -3263,  1029,  2072,  2076,  1143,  2077,  2079,  2080, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, 23109, 22003, -3263,   302, 14108,
   -3263, -3263, -3263,  2275,  2607,  2610,  2519,  2613,    63, -3263,
    -129, -3263,  2514, -3263, -3263, 43530, -3263, 43530, -3263, 43530,
   41880,  2267, -3263, -3263, -3263,  2659, -3263,   660, -3263, -3263,
     879, 43530,   148,   133,   148, -3263, -3263, -3263, -3263, -3263,
    2317, -3263,  2320, -3263,  2094,   846, -3263,  2533,  2258, -3263,
   -3263,   643, -3263, -3263, -3263, -3263, 14108, -3263, -3263, -3263,
    2099, -3263,   433, -3263, -3263, -3263,  1029, 43530, -3263,   133,
     133,  2627,   133, -3263,  2630,  2631,  -129, -3263,   672, 14108,
    1152,  1157, -3263,  2105,  2109, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263,   643, -3263, -3263, -3263,
    2556, 33070,  2254, -3263, -3263,  2106, 23109, 16412,  1516, -3263,
   -3263, -3263, -3263,   133, -3263,   133,   133, -3263,  2666,  2111,
   -3263, -3263, -3263, -3263, -3263, 43530,   108, -3263, 44630, 44630,
   43530, -3263,  2142, -3263,  3970,   126, -3263, -3263, -3263, -3263,
   -3263,  2113, -3263, -3263,  2516, -3263, -3263, -3263, 35830, -3263,
    2115, -3263, -3263, -3263,  2406, -3263, -3263, -3263,  2515, 43530,
   -3263, -3263, -3263, -3263, 14108, 14108,  2146, -3263, -3263, 33070,
   33070, -3263, -3263, -3263, 33070, -3263, -3263,  2529,  2119,  2552,
   -3263,  2470,  2557, 14108, -3263, -3263, -3263,   519, -3263, -3263,
   30295,  2120, 33625, 14108,   126, -3263, -3263,  2376, 14108,  2130,
    2131, -3263,   162, -3263,  2487,  2148,  2164, 14108, 33070, -3263,
    2569,  2602,  2443,  2132, -3263,  2135,  2586, 44630,   846,  2501,
   -3263, -3263, -3263, -3263, 43530, -3263, -3263, -3263,   652, -3263,
   -3263, 30850,  2157, 39680, 31405,  2138, -3263, -3263, 14108, -3263,
   -3263, -3263, 33070,  2378,  2147, -3263,  2149, -3263, 33070, 14108,
   -3263,  2581,  2161, -3263, -3263, -3263,  2524,  2151,   281, -3263,
    2150, -3263,  2588, 33070, -3263,  2473, 19223,  2291, 43530, 28630,
   -3263,  2171, 33070,  2558, 43530,  2516,  2561,  2562, -3263,  2331,
   31960, -3263, -3263, 38580,  1163, -3263, -3263, 23109, -3263, -3263,
      51,  2176, -3263, 29185, -3263, -3263,  2626,   493, -3263, -3263,
    2191, -3263, -3263, 21445,  2099, -3263, 33070, -3263, 33070, 34180,
   14108, -3263,  2203, -3263, -3263, -3263,  3970, -3263, -3263, -3263,
   32515, 29740, -3263, -3263, 25865, -3263, -3263, -3263,  2568, -3263,
   -3263, -3263,  1279, -3263, 34180, -3263, -3263, -3263, -3263
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3263, -3263, -3263, -3262, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263,   916, -3263, -3263, -3263, -3263, -3263,  1149, -1418,
   -3263, -3263, -3263, -3263, -3263,   344,   -38, -3263, -3263, -3263,
   -3263, -3263, -3263,  2057,  -819, -3130, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,  -479,  -598, -3263, -3263,  -470,
   -3263, -3263, -2313, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263,  -953,  -915, -3263, -3263, -3263, -3263, -1876, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,  -921, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,  -843, -3263,
   -3263,  -801, -3263, -3263,  -840, -3263, -3263, -3263,  -805, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,  -290, -3263,
   -3263, -1830, -3263, -3263, -3263,  1620, -3263,  1676, -3263,  2364,
   -3263,  -370,   -17,  1212, -1900, -1029,  -551,  -540, -1647, -3263,
   -3263, -3263,  -378, -3263, -3263,   718,    71,  1223,  1250,   761,
     816, -3263, -3263,    86, -3263, -2649, -3263, -3263, -3263,    54,
   -3263,    58, -3263, -3263, -3263, -1385,    20, -1365, -3263,  -383,
   -1215, -3263,  -175, -3263,  -220, -3263,  -449, -2020, -1919, -3263,
   -3263, -3263,  -210,    97,   144, -3263, -2557, -2224, -3263, -3263,
    -593, -3263, -3263, -3263,  -600, -3263,  -366,  -514, -3263, -3263,
   -1491, -1744, -3263, -3263, -2168,  1650, -2056,  -431, -1859, -3263,
    -386, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
     793, -3263, -3263, -3263,  -218,  -270, -1334, -2737, -3263, -3263,
   -3263, -3263, -3263, -3263,  1024, -3263, -3263,  1318,  1742, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
     936, -3263, -3263, -3263, -3263, -3263,  -872,  1660, -3263, -3263,
   -3263,  1295, -3263, -3263, -3263, -3263,  1381, -3263, -3263,  2121,
   -3263, -3263, -3263, -3263,   544,   961, -3263, -3263, -3263,  2139,
     933,  -467, -1756, -3263,  2354, -3263, -3263, -3263, -1300, -1987,
   -3263,  2211,  -455, -2312,  1384,  -707,   -65, -3263,  -267,  -743,
    4756, -3263, -3263, -1244, -3263, -3263,  -784, -3263, -3263, -1276,
   -1194,  1496,  1495,   278,   394,    57, -3263, -3263,  -498, -3263,
   -3263, -3263, -1254,  -723, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263,   -64, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -1120, -3263,   744, -3263, -1067, -3263, -3263, -3263,
    1586, -3263, -3263, -3263, -3263, -3263, -1874, -1338,   168, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -1861, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -1315, -3263, -1621, -3263,
   -3263,  -939, -3263, -3263,  -550, -2173, -1176,   457, -3263, -3263,
    -963,  1673, -1538, -3263, -3263, -3263,   595, -3263, -3263, -3263,
   -3263, -3263,   145, -2009, -1051, -3263, -3263, -2616,  -636, -1811,
    -592, -3263, -1829,  -298, -1174, -1866, -3263, -3263, -3263, -3263,
    -742, -3263, -3263, -3263,  -275,   958, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263,  -461,  -372,   934, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263,  1925,  1874,  1000, -3263, -3263,
   -2079, -3263, -3263,   975, -3263,   -51, -1858,  -307,   238, -3263,
   -3263,   242, -2600, -3263, -3263, -3263, -3263, -3263, -3263,   182,
    -792,  -610,  2408, -3263, -3263, -3263, -3263, -3263, -3263,  2137,
    1697, -1479,  2355, -3263, -3263, -3263, -3263, -3263,  1382, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263,  2424, -3263,  -970, -3263,
    -410, -3263, -3263,  -591, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263,  1481, -3263, -3263, -3263, -3263, -3263,  1894,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263,   264,  -670, -3263,
    -499,  -687, -3263,  -564, -3263, -3263, -3263,  -789, -3263,  -740,
    -678, -1019,  -121, -2582, -1407,   261,  1895, -2700, -1142, -1297,
   -1295, -1826,    21, -3263,    -7,  -553,  -437,  -885,  2738, -2382,
    -417,  -495, -3263,   241, -3263, -3263, -3263, -3263,  1441, -3263,
   -3263, -3263, -3263,   563, -3263, -3263, -3263,   230, -3263,   -40,
    -237, -3263, -3263,   283, -3263,  1476, -3263, -3263, -3263, -3263,
   -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
    1904,  2455,  2302, -3263,  1945, -3263, -3263, -3263, -3263, -3263,
    -365, -3263,  -169, -3263, -1010,  1744,   445, -3263,   642,  -852,
   -1140, -3263,  -367, -3263, -3263,   263,  2467,  2311, -3263, -3263,
   -3263, -3263, -3263, -2227,  -597, -3263, -2297, -3263, -3263, -3263,
   -3263, -1159, -3263, -3263,  1607,  -179, -3263, -3263,   407, -3263,
   -3263,   -70, -3263,  2429,  2189, -3263,   865, -3263,   147, -3263,
   -3263,  -131, -3263, -3263, -3263, -3263, -3263, -3263, -3263, -3263,
   -3263,   910, -3263, -3263, -3263, -3263, -3263, -3263
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2011
static const short int yytable[] =
{
     387,   650,   714,   679,  1001,  1091,  1635,  1474,   564,  1761,
    1419,  1762,   387,  1055,  2220,   387,  1160,  1161,  1162,  1196,
    1197,  1199,   387,  1181,   979,   672,   672,   672,  1205,   672,
     920,   672,   387,  1023,  1028,   705,   706,  1515,  2373,  1973,
    1669,  2271,   387,   422,  1261,  2335,  2319,  2324,  2327,  2669,
    2289,  1783,  1989,  2475,  1824,  1667,  2969,  1028,  1791,  1056,
    2494,  2348,  1636,  1637,  1638,   922,  1659,  2497,  2629,  2358,
     482,  2362,   483,  1564,  2961,  1650,  1728,  2062,  1931,  1780,
     387,  2357,  2954,  1489,  2308,   664,  1263, -1510,   982,  2339,
    2340,  1807,  1809, -1511,  1492,  1493, -1119, -1859,  2247, -1860,
     387,   387,  -259,   387,  2594,  -249,  1706,  -260,   477,   958,
    2392,   958,  1287,  2390,   387, -1923,  1289,  3022,  1385,  1293,
    1641,  1642,   498,  1644,  2994,  1302,  1303,  1304,  3268,  1708,
    2411,  2412,  1712,  3098,   993,  2382,  1097,  2005,  1423,   733,
    2379,  2066,   492,  1795,  1894,  1797,  2379,  1098,  3181,  2391,
     958,   953,  2394,  1139,  3538,  1313,  1314,  1315,  1678,  2472,
    1739,  1740,  1629,  2403,  2404,  1745,  2417,   668,  2982,  3126,
    2203,  1142,  2413,  1698,  1870,  1353,   722,  1296,  2992,  2382,
    2983,  2993,   106,   618,   619,  1760,  3675,  1764,  1385,  1018,
    2697,  1718,  1719,  1720,  2984,  1947,  1103,   950,  1029,  2337,
    3002,  3374,  1727,   618,   619,  3098,  3021,  2382,  1025,  2624,
    1093,  3375,  1621,  1051,  2982,  1093,   988,  2982,   618,   619,
     697,  1630,  2696,  2380,  2381,  2465,  2983,  1013,  1434,  2983,
    3160, -1510,  1037,  1106,  1574,  2484,   959,  1915,   959,  3062,
    2984,  1059,  3537,  2984,  2456,  3315,   672,  2383,  2776,   618,
    2988,   966,   618,   619,   569,  2173,  1358,  2225,  1631,  2485,
    3149,  2467,  2186,  2896,  2006,   107, -1119,  1891,  1918,  1629,
    2301,   826,  1081,  1143,  1019,  2046,  1144,   959,  3162,  1039,
    2064,  2353,  1940,  3527,   469,  3468,  2863,   119,  1440,  1145,
     670,  -340,   392,   393,  2354,  2617,   561,  1608,   964,  2659,
    2486,   443,  2678,  2487,  1066,  2907,  2304,  1040,  3099,  3116,
     431,  2488,   428,  1062,  2442,   437,  2467,  2660,  1892,   441,
    2356,   565,  1632, -1384,  2226,  1359,  2683,  2087,  1630,    40,
    1316,  1870,   508,  3163,   999,  3444,   669, -1510,  1571,  3368,
   -1119,  1166,   602, -1511,  2080,  2405,  1297, -1859,  1041, -1860,
     108,   967,  2457,  1042,  1347,   958,  2217,  3646,   121,  3445,
    1363,  1057,   106,  2434,  1167,  1631,  3369,  1053,  1343,  1344,
    2218,  2684,  2088,  3647,  3036,  2959,  2129,  1067,  2687,  1140,
    3099,   442,  3037,   489,  3159,   109,   977,  1681,  2081,  2343,
    1682,  3434, -1978,  1633,  1341,  3539,  2305,  1075,  1511,   487,
    1871,  1441, -1119,  2047,   387,  3100,  2025,  1054,  2777,  1113,
    2845,  2035,   566,  3376,   387,  1058,  1146,  2041,   387,  3284,
    2044,  1377,   557,   387,  3703, -1119,  3159,   470,   387,  1632,
    1114,  1159,  3394,   429,  3187,   670, -1510,   732,  3528,  1476,
    1916,  3235, -1511,  3191,  1514,  2661,   968,  1482,  1082,  2384,
     387,   574,  2468,  1609,  1572,   603,   707,  1367,  3468,  1203,
    1460,  2355,  1388,   485,   559,  1368, -1384,   387,  1380,  1020,
    2443,  2664,    51,  1666,  1052,  1494,  1495,   387,   567,  2700,
    1386,   387,   959,   916,  1905,   918,   919,   387,  2679,   387,
     387,  1689,  2673,  -340,   387,   387,  1516,  2698,  1043,  1147,
    1633,  2227,  1919,  2682,   387,   690,  2071,  2468,   387, -1119,
    3038,  3277,  1953,   387,   387,  1421,   387,   387,   387,   387,
    1927,  1014, -1119,  1973,  1906,  1430,  2476,  2963,  2695,  2489,
    3540,  1369, -1119,  3305,   604,  1564,  1477,  3101, -1119,  2326,
     723,  1348,  2702,  2445,  1097,   110,  1872,  2914,  3102,  1863,
    1386,  3377,   387,  2302,  1575,  1098, -1119,  1871,   570,  1756,
    1422,  2379,  3164, -1119,  1973,  1634,   698,  1044,   387,  2204,
    1501,  2785,  1108, -1119,  3393,  2379,   387,   387,  1953,  1371,
    1021,   387,   951,  2293,  2066,  1762, -1119,  2147,   387,  1340,
   -1119,  2151,   988,  1108,  2385,  2338,   973,  2309,   954, -1119,
    1629,  1030,  2246,  1097,   599,   985,  2995,  2250,  2251,  1424,
    3676,  3127,  2222,  1794,  1098,   988,  3118,  2007,   387,  2347,
    3102, -1119,   670,  1063,  2189,  3103,  1045,   692,  1108,  1815,
   -1510,  2252,  1298,  2253,  2243,  1038, -1511,  1022,  -340,   672,
   -1859,  2694, -1860,  3182,  1108,  1340,  2490,  2361,  1463,  1762,
    1520,  1340,  1491,  2458,  3316,  1818,  -569,  3092,  3023,  1630,
   -1923, -1119,  2187,  2985,  1616, -1510, -1119,   724,  3371,  3436,
    2065, -1511,  1634,  3541, -1119, -1859,   387, -1860,  1610,  2237,
    -259, -1119, -1119,  -249,   387,  -260,  2685,   387,  2864, -1119,
     387,   387,  1108, -1923,  3416,  1372,  1631,  2491,   409,  3420,
     527,   430,  2416,  1872,  1762,   503,  2223,  1374, -2010,  2985,
    1378, -1119,  2985,  1502,  1402,   576,  1046,  1503,  3395,   492,
    3435,   585,  1377,  2474,   461,  2492,   387,  -137,   387,  2846,
    1064,  2989,  2759,  2674,  2675,  3422,  1576,  3005,  3019,   708,
    1600,   666,  1907,  3044,  1340,   502,  1784,  1047,  -339,  1065,
     396,   558,  3312, -1119,  1165,  3229,  1170,  1965,  3180,   525,
    1632,  3185,  2909,  2634,  2635,  -503,   462,  2636,  1380,  1966,
    3020,  3457,   578, -1119,  2366,  3406,   586,  3408,  3006,  2028,
     583,  1683,  3007,   410,  1684,   605,   606,   607,   608,   609,
     610,   684,  1026,  2289,  3396,  1349,  1350,  1351,  2943,  1876,
    2934,   611,  2947,  2393,  1954,  2395,   670,  2244, -1119,   505,
    2400,  2944,   391,   770,  1965,  2948,  1107,  1858,  3216,  3397,
    3479,   411,  1113,  2918,   747,  3008,  2418,  1625,  2420,  2421,
    2425,  1633,  1788,  2962,   397,  2258,   590,   463,  2029,   435,
    2502,  2503,  2259,  1114,  1876,  3461,  1891,  3463,  1469,   394,
    1877,  1924,  1380, -1119,  1436,  1450,  1380,  2258,  2238,   448,
    -339,  3336,  3045,  1625,  2645,  3545,  2379, -1119,  1967,  3337,
    1954,  1865,   783,  -508,   712,   713,   387,  3517,   387,  1952,
     451,  1884,  1521, -1119,   452, -1119,   826,   455,  1921,  1823,
    3153,  1514,  2206,  1108,  1522,  1028, -1981,   770,  1926,  1474,
    1474,  1929,  1930,  1625,  1778,  1910,  1799,  1113,  3152,  1403,
     387, -1119, -1119,   731,  1521,   456,   387,  1987, -1119,  1470,
     712,   713,  1451,  1028,  1026,  1785,  1522,  2668,  1114,  1800,
     591,  1866,  1867,   587,  1829,  3313,  2787,  1859,  1383,  2030,
    1626,  1625,  3054,   834,  3145,   472,  3682,  2376,   781,  1878,
    1879,  2534,  -474,   387,  3055,   387,   783,   387,  2344,  3059,
    1817,  3217,  3326,  1142,  1113,   512,  3186,  3467,  1958,   387,
     387,  2590,  1825,   810,   -55,   473,  1649,   685,   412,   387,
     387,  1464,  1465,  2363,  1564,  1114,  2620,  1880,  1762,  2583,
     387,  1475,  2637,   798,   592, -1981,  3666,  3458,   826,  1481,
    3036,   474,   686,  1634,  2535,  3350,  1908,  1625,  3037,  1452,
    2031,  1378,   387,   387,   387,   387,  1707,  2407,  2495,  3314,
    1404,   513,   387,  2500,   387,  2239,  3046,   579,  2026,  2027,
     387,  2034,  1876,  2036,  2037,  2038,  2039,  2040,  2508,  2042,
    2043,  2240,  1466,  1467,   831,  2513,   712,   713,  2707,  1437,
     670,  3009,   387,  1501,  1711,  1523,  1936,   810,  3010,  1629,
    2522,  2523,  -339,  2377,  3556,  1143,   464,  2527,  1144,  3338,
    2703,   479,  1801,   942,  1203,  2532,   484,  2249,  3578,  3132,
    1490,  1145,  2585,   709,  3138,  3139,  3011,  1523,   465,  2592,
     413,  1471,  1786,   485,  3306,  3307,  2408,  1860,   387,  1453,
    1069,   387,   117,  2477,   118,   414,   398,  3047,  1787,  3407,
    2049,  3409,  3286,   466,  2550,   826,  3531,  3532,  1630,  1988,
    1744,   826,  1603,  1604,  3474,  1524,  1573,   830,   831,  2050,
     453,   415,  1936,   514,  1204,  1936,  3038,  1878,  1879,   943,
    1968,  -265,   399,  2953,   114,  2708,   416,   710,  3012,  1525,
     387,   494,   387,   387,   387,  1631,   387,  1524,  3171,   999,
    1404,   467,   670,  3325,  1070,   387,   495,   387,  3162,  3493,
    2427,  2428,   498,   400,  2231,  2623,   500,  2232,   712,   713,
     944,  1525,  2032,   401,  1606,   454,  1203,  1937,  2409,  1123,
    1124,  2600,  2955,  2955,  2955,   945,  1502,  3597,  1345,  1346,
    1503,   387,  2929,  1526,  1938,  3611,  1936,  -339,  1146,   509,
    2429,  3578,  3450,  1957,  3451,  2930,   863,  1939,  1936,  1632,
     399,  1973,   115,  3163,  3231,  1976,  1977,  3562,  1979,  1980,
    1981,  3013,  2430,  1984,  1838,  1526,  1839,  3172,  1992,  1802,
     511,   387,  1995,  1996,  1997,  2931,  1288,  2000,  2001,  2002,
    2003,  2004,  1380,  2009,  2010,  2011,  2605,  2606,  2607,  3270,
     117,  3294,   118,  1937,  2431,  3601,  1937,  1886,  1887,  1888,
    2796,   519,  3173,  2996,  2800,  1527,  2997,   618,   619,   670,
    1938,  3154,   573,  1938,  3155,   670,  1519,  2631,  2632,  2633,
    1633,  1147,  1940,  1939,   861,   556,  1939,   577,  1335,   387,
     863,   926,   661,   864,   436,  3639,   587,  1527,   559,  1203,
    1134,  1135,  3136,  1975,   387,   419,  1978,   680,  2892,  1380,
    3650,  1336,   691,   432,   692,  1990,  2811,  2812,   438,  3663,
    2293,   701,  1762,   721,  1998,  2422,   106,  1937,  2423,  2977,
    1772,  1773,  2980,  2981,   521,  2312,   523,   914,   524,  1937,
     526,   917,  2069,  2070,  1938,  3156,  3157,  3271,  3272,  2998,
     924,  3273,  3274,  3690,   939,  3691,  1938,  2671,  1940,  1292,
     387,  1940,   948,   674,   675,   387,   676,   387,   677,  1939,
    2101,  2102,   387,  2361,  1941,  1762,   927,   941,   387,   946,
     387,  3140,  2103,  2104,  1399,   387,   387,  1400,   387,   956,
    1401,   712,   713,   957,  1810,  1811,  1812,  1813,  1814,  2416,
     387,  1762,   109,   387,   971,  -540,  2107,  2108,  1530,   387,
     387,   387,   387,  1835,  1835,  1531,  1835,  2396,  2397,   387,
     387,   387,  2114,  2115,   972,  1532,  1533,   980,  1857,  1942,
     991,   973,  1940,   992,   928,  2119,  2120,   387,  2419,   985,
    1869,   995,  2584,   996,  1940,  1002,   387,  1835,  1835,  1835,
    1941,   923,  1634,  1941,  1337,  1534,  1840,   999,   929,  1535,
    2122,  2123,  2832,   387,  3383,  3373,   659,   660,  1010,   663,
    1536,  2124,  2125, -1119,   387,  1841,  2136,  2137,  2325,  1537,
    2329,  2334,  2432,  2140,  2141,  1538,   387,  1011,   958,  2153,
    2154,  1012,   387,  2976,  1016,  1842,  2157,  2158,  1539,  2159,
    2160,  1017,  1928,  2167,  2168,  1942,  1026,  1338,  1942,  1843,
    2888,  2589,  1031,  1093,  2170,  2171,  1540,  2179,  2180,  1032,
    1946,  2192,  2193,  2398,  1941,  1541,  1542,  3000,  3001,  2372,
    2325,  1543,  1033,  2211,  2212,  3004,  1941,  2213,  2214,  1544,
    2596,  1035,  3027,  1034,   930,  1545,  2234,  2235,  2262,  2263,
    1036,   387,   931,  1060,  1844,  1845,  1061,  2052, -1119,  1074,
     387,   618,   619,  1077,  3477,  1025,  2452,  2453,  2586,  2587,
    1076,  1546,  3488,  3413,  1326,  1327,  2626,  2627,  1079,  1942,
     932,  1084,  1846,  1025,  1104,  3503,  2711,  2712,   387,  3546,
    1151,  1942,  2782,  2712,  2839,  2840,   387,  2843,  2844,   387,
    1152,  2620,  1153,  1762,  3060,  3178,  3179,  2865,  2866,  1155,
    2917,  1804,  1805,  1328,  1105,   959,   933,  1547,  1157,  1548,
    1158,  1339,  1340,  3189,  2060,  1159,  1549,  1329,  1163,  3193,
    2889,  2890,  2971,  1108,  3032,  3033,  1172,   934,  1176, -1119,
    1323,  1847, -1119,  3110,  3111,  3233,  3234,  3239,  3240,  3242,
    3243,  2504,  3209,  2325,   935,  3211,   118,  1379,  3565,  2509,
    2325,  1330,  3308,  3234,  1174, -1119,  2399,  3388,  3389,  3391,
    3234, -1119,  1352,  1331,  3583,  3081,  3583,  2406,  1177,  1532,
    1533,  1382,  1848,  1178, -1119,  3392,  3234,  1179,  1001, -1119,
    2665,  3400,  3401,  1342,  1550,  1180, -1119,  3402,  3403,  1182,
    1332,  3404,  3403,   530,   531,  1183, -1119,  3425,  3426,  1551,
    1184,  -460,  -460,  1535,  1552,  3583,  3490,  3389,  3630, -1119,
    -460,  3491,  3389, -1119,  1536,  1185,  3634,  3672,  3673,  1806,
    1808,  1186, -1119,  1537,  1028,  2957,  2958,  1748,  1749,  3309,
    3310,  2921,  2922,  2667,  2898,  2899,  1187,  2643,  3108,  3109,
    1188,  1189,  1539,  3583,  1553,  1190,  1191,  1333,   670,  1474,
    1554,  1384,   387,  1555,  3583,  1192,  1193,  1093,  1194,  1195,
    1540,  1198,  1200,  1201,  1392,  2616,  1202,  3583,   532,  1206,
    1207,  1208,  1209,  1210,  1211,  1414,  1556,  1557,  1212,  1558,
    1396,  1213,  1214,  1215, -1119,  1216,  1217,  1218,  1219,  1545,
    1220,  2581,  1221,  1559,  3583,  3583,   533,  1222,  3705,  1223,
    1224,  1225,  1226,  3095, -1119,  1227,  1228,  1229,  1230,   747,
     534,  2658, -1119,  1231,  1232,  1560,  1389,  1394,  1233,  1234,
    1236,  1237,  1238,  1239,  1240,  1241,  2701,  1242,  1243,  1244,
    1245,  1249,   535,  2704, -1119,  1250,  1251,  1252,  1253,  1254,
    1255,  1256,  1257,  1258,   536,  1259,  1121,  1122,  1123,  1124,
    1125,  1126,  1260,   387,  1127,  1128,  1129,  1130,  1131,  1132,
    1262,  1133,  1264,  1548,  1265,  1266,  1267,  1268,  1269,  1270,
    1549,   387,   387,   537,  1393,  3153, -1119,  1271,   387,  1272,
     387,   387,   770,  1273,  1274,  1275,  1276,  1277,  1278,  1279,
    1280,  1281,  1282,  1283,  1284,  1285, -1119,  1286,   538,  1561,
    1415,  1290,  1291,  1418,   539,  1294,  1295,  1181,  1562,  1299,
    1300,  1301,  1305,  1306,  1307,  1308,  1309,   387,  1310,  1381,
    1427,  1397,  1429,  1458,  1420,  1426,  1428,  1435,  1443,   387,
     387, -1119,  1449,   781,   561,   596,   531,  1462,  1550,   387,
    1478,   783,  1483,   540,  1484,   387,  1485,  1488,   387,  1486,
    1496,   387,  1498,  1551,  2710,  1500,  1512,  3134,  1577,  1579,
    1578,  2325,   387,   387,  1580,   387,  1581,  -540,  1582,  1134,
    1135,   387,   387,  -540,  1583,  1584, -1119,  1585,   798,  1586,
    1587,   387,  1588,   387,  1589,  1590,  1591,   387,   387, -1119,
   -1119,  1592,  1593,  1594,  1596,  1595,  1601,  1599,  1613,  1605,
    1618,  1377,  1625,  1653,  1554,  1298, -1119,  1555, -1119,  2426,
     532,  1673,  1687,  1704,  1779,  1736,  1759,  1768,  1774,  1793,
    1816,  1796,  1826,  1827,  1851,  1854,  1911,   387,   387,  1899,
    1556,  1557,  1913,  1558, -1119, -1119,  1885,  1920,   533,  1923,
    1944, -1119,   810,  1945,  1949,  1948,  1951,  1959,  3043,  1960,
    1762,  1961,   534,   387,  1964,  2462,   541,  1962,  1963,  1965,
     387,  1982,  1983,  1985,  1986,  1991,  1993,  1994,  1999,  1560,
    2013,  2061,  2065,   387,   535,   542,  2067,  3360,  3361,  3362,
    3363,   543,  2074,  2068,  2072,  2075,   536,   544,  2076,  2077,
    2078,  2079,  2082,  1532,  1533,  2085,  2083,  2084,  2092,  2086,
     826,  2089,  2094,  2091,  2093,  2100,  2096,  3355,  2095,  3196,
    2097,   545,   830,   831,  2098,   537,  2099,  2111,  2105,   387,
    2106,  2109,   546,   547,  2110,  -460,  -460,  1535,  2112,  2113,
    2116,  2261,  2117,  2118,  -460,  2121,  2229,  2126,  1536,  2127,
     538,  2130,  2266,  2131,  2132,  2133,   539,  1537,  2224,  2134,
    2135,  2138,  2144,  1561,  2139,  2267,  2142,  2145,  2143,   548,
    2146,  1762,  1562,  2148,  2268,  2149,  1539,  2596,  2150,  2152,
    1340,  2274,  -785,  2155,  3357,  2156,  2161,  2162,  2279,  2163,
    2164,  1093,  2165,  2166,  1540,   540,  2169,  2172,  2174,  2175,
    2264,  2280,  2176,  2177,  2178,  2181,  2182,  2183,  2184,  2296,
    2190,   387,  2926,  2185,  2188,   549,  2191,   550,  2297,  2194,
    2195,  2196,  2207,  1545,  2205,  2208,  2265,  2209,  2372,  2210,
    2241,  2471,  2215,  2248,  1108,  -961,  2278,  2276,  2284,  2298,
    2299,  1892,   387,  1891,  2341,  2317,   387,  2342,   387,   387,
     387,   387,  2316,  2318,  2345,  2349,  2350,  2351,  2374,   387,
    2367,  2375,  2401,   387,  2402,  2449,   387,  2435,  2450,  2454,
    2455,  1514,  1619,  2481,   670,  2501,  3154,  1001,   802,  3155,
     387,   387,   387,  2514,  2524,  2536,  2537,  1857,  2556,   861,
    2561,  2563,  2565,   387,  2568,   863,  2571,  1548,   864,   387,
    2574,   387,  2576,  2577,  1549,  2578,  2579,  2588,   541,   387,
    2580,  2595, -1015,  2603,  2608,  2610,  2614,  2622,  2625,  2628,
    2630,  2641,  2642,  2647,  2655,  2666,  2672,   542,  2676,  3656,
    2677,  1762,  2054,   543,  2680,  2692,  2693,  2706,  2772,   544,
    2775,  2779,  2781,  2783,  2786,  2801,  2791,  2788,  2792,  2793,
    3156,  3157,  1762,  2802,  2794,  2797,  2259,  2803,  2804,  2904,
    2805,  2883,  2806,   545,  2807,  2808,  3656,  2809,  1762,  2813,
     387,  2906,  1550,  2814,   546,   547,  3133,  2815,  2816,  2817,
    2818,   387,  3245,  2819,   387,  2820,  2821,  1551,  3593,  2822,
    2823,  2919,  2824,  2885,  2825,  2826,  2827,  2828,  2829,  2830,
    1876,  2833,  2834,  1205,  1289,  1293,  2927,  2835,  2836,  2939,
    2942,   548,  2857,  2945,  2946,  2837,  2965,  2838,   387,  2966,
    2841,  2978,  2842,  3061,  3063,   387,  2848,  2849,   387,  2850,
    3070,  3077,   387,   387,  2867,  2935,   387,  2851,  1554,  2852,
    2853,  1555,  2854,  3329,  3195,  2855,   387,  2856,  2858,  2859,
    2860,  2862,  2868,  3078,  2936,  2869,  2714,   549,  2870,   550,
    2871,  2873,  2875,  2877,  1556,  1557,  2878,  1558,  2879,  2880,
    2881,  3031,  2887,  2891,  2780,  2894,  2908,  2895,  2940,  2964,
    2960,  2974,  3072,  2975,  3003,  3025,  3026,  3028,  3090,  3324,
    3051,  3065,  3066,  3113,  3067,  3079,  3123,  3087,  3088,  3339,
    3340,  3089,  3324,  1560,  3111,  3094,  3106,  3119,  3117,  3125,
    3120,  3124,  2645,  3128,  3130,  3135,  3131, -1049, -1054,  3146,
    3169,  3144,  3150,  3170,  3183,  3022,  3151,  3177,  3192,  3199,
    3019,  3188,  3190,  2312,  3200,  3201,  3203,  2715,  2716,  3204,
    3214,  3205,  3206,  2717,  3207,  2718,  3208,  2719,  2720,  3210,
    3219,  3223,  3220,  3236,  3247,  3237,  3238,  3241,  3244,  2325,
    3249,  3252,  2721,  3253,  1532,  1533,  3261,  3246,  3248,  3250,
    3265,  3251,  3266,  3254,  3278,  3255,  3267,  3405,  3256,  2372,
    3257,  3258,  3259,  3260,  3263,  3287,  3293,  1561,  3296,  3298,
    3290,  3291,  3302,  3330,  3344,  3320,  1562,  3321,  1535,  3331,
    3352,  3353,  3328,  2722,  3332,  3333,  2723,  3240,  3334,  1536,
     387,   387,  3335,   387,  2724,  3346,  3366,  3359,  1537,  3347,
    3349,  3380,   387,   672,  3365,  1001,  3382,  3417,   387,  3385,
    3387,  3410,  3411,  2725,  3390,  3412,  3423,  1539,   387,  3437,
    3424,  3427,  3439,  3428,  3429,  3440,   387,  3441,  3442,  3448,
    2726,  2445,  1093,  2055,  3456,  1540,  3464,  3472,  3466,  3465,
    3345,  3473,  3483,   387,  3476,  3485,  3486,  3494,  3513,  3492,
    3515,  2727,  3524,  2728,  2453,   387,  3549,  -211,  3548,  3525,
    3550,  3556,   387, -1179,  1545,  3543,  3573,  3572,  3574,   387,
    3595,  3584,  2729,  2730,  3591,   387,  3592,  2926,  3596,  3597,
    3602,  3603,  3606,  3607,  3609,  3613,  3635, -1781,  3623,  3631,
    3636,  3642,  3641,  3643,  3638,  3462,  3644,  3657,  3651,  3649,
    3664,  3648,  3662,  3667,  3668,  3669,  3678,  3680,  3687,  3701,
     672,  3706,  2260,  2731,  2045,   388,  1101,  3588,  3348,  3419,
    3342,  3708,  3683,   672,  3689,  3620,  3579,   418,  3621,  3587,
     424,  3481,  3482,  3230,  3484,  3053,  2325,   433,  1548,   510,
    3304,  1518,  2732,  2466,  1598,  1549,  2012,   444,  2446,   387,
    1969,  2733,  2734,  2972,  2735,  2967,  2386,   460,  3029,  2990,
     531,  2016,  3322,  2991,  3161,  3202,  3194,  2968,  3455,  2933,
    3459,  3319,  3399,  3351,  3327,  3521,  2436,  3522,  3523,  1868,
    1597,  2281,  2736,  2737,  2738,  1499,  1933,  1612,  2277,  1112,
    2613,  1089,  2300,   678,  1006,   478,  3367,  1890,  3096,  3264,
    3097,  1703,  2498,  2739,  2740,  2741,  1798,  1803,  2941,  2742,
    3454,  3568,  2743,  1550,  2593,   481,   388,  3301,   388,  3289,
    3615,  2970,  2307,  2273,  2287,  2744,  2745,  3115,  1551,   478,
    2912,  1431,  2952,  2911,   532,  3674,  3516,   667,  1651,  1617,
    1925,   740,  1169,  3414,   653,  1828,  2905,  3567,   387,  3443,
    3589,  2746,  3487,  2747,  3688,  3568,  1433,  3198,  2915,  1413,
    1900,  2663,   533,  2937,  3129,  3292,  1862,   598,   994,  1438,
    1447,   387,  1406,  1602,  3358,  2602,   534,  2748,  3364,  1554,
     600,   998,  1555,  3262,  1530,   693,   387,  3470,  2461,  3228,
    1164,  1531,     0,  1770,     0,     0,  3050,     0,   535,     0,
       0,  1532,  1533,     0,     0,  1556,  1557,     0,  1558,     0,
     536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2749,     0,  2750,     0,     0,     0,     0,   387,     0,     0,
       0,  1534,  2751,     0,     0,  1535,   672,     0,     0,   537,
       0,     0,     0,     0,  1560,     0,  1536,     0,     0,   387,
       0,     0,     0,     0,     0,  1537,     0,     0,     0,     0,
       0,  1538,     0,     0,   538,     0,     0,     0,     0,   387,
     539,     0,   672,   672,  1539,   672,  2752,  2753,     0,     0,
    2754,  2755,  2756,  2757,     0,     0,     0,     0,     0,  1093,
       0,     0,  1540,     0,   387,     0,   387,     0,     0,  3518,
       0,  1541,     0,     0,     0,     0,   387,  1543,     0,   540,
       0,     0,   387,     0,     0,  1544,   672,     0,   672,   672,
       0,  1545,     0,  2758,  2759,     0,     0,     0,  1561,     0,
       0,     0,     0,     0,  3222,     0,     0,  1562,     0,     0,
       0,     0,  2760,     0,     0,     0,     0,  1546,     0,     0,
       0,  1532,  1533,     0,     0,     0,     0,     0,     0,   387,
    3470,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2325,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -460,  -460,  1535,     0,   387,     0,     0,
       0,     0,  -460,     0,     0,  1548,  1536,     0,     0,     0,
       0,     0,  1549,     0,     0,  1537,     0,   387,     0,     0,
       0,     0,     0,   387,   387,     0,     0,     0,     0,   522,
       0,     0,   541,     0,  1539,     0,     0,   387,     0,   555,
       0,     0,     0,   563,     0,     0,     0,     0,   478,  1093,
       0,   542,  1540,   582,     0,     0,   387,   543,     0,     0,
       0,  3698,     0,   544,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   478,     0,     0,     0,     0,
    1550,  1545,     0,     0,     0,     0,  3698,   545,     0,     0,
       0,     0,   681,     0,   387,  1551,     0,     0,   546,   547,
    1552,     0,   478,     0,     0,     0,   478,   387,     0,     0,
       0,     0,   703,     0,   478,   478,  3671,     0,     0,   715,
     563,     0,     0,     0,     0,     0,     0,     0,     0,   734,
       0,     0,     0,   739,     0,   548,     0,     0,   915,   388,
    1553,   388,   388,   563,   478,  3707,  1554,     0,     0,  1555,
       0,     0,     0,     0,     0,  1548,     0,     0,     0,     0,
       0,     0,  1549,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1556,  1557,     0,  1558,     0,   963,     0,     0,
       0,   549,     0,   550,     0,     0,     0,     0,     0,  1559,
       0,     0,     0,   478,     0,     0,     0,     0,     0,     0,
       0,   563,   478,     0,     0,     0,   478,     0,     0,     0,
       0,  1560,     0,   478,     0,     0,     0,     0,     0,     0,
     387,  1354,  1355,  1356,  1357,  1358,     0,     0,     0,     0,
    1550,     0,     0,     0,     0,     0,     0,     0,   387,   387,
       0,     0,     0,   563,     0,  1551,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   387,     0,
     387,     0,   387,   387,     0,     0,     0,  3433,     0,     0,
       0,     0,     0,     0,   387,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1359,  1561,  1554,     0,     0,  1555,
       0,  1092,     0,     0,  1562,     0,     0,     0,     0,   563,
     387,     0,   478,     0,     0,  1111,   478,     0,     0,     0,
       0,     0,  1556,  1557,     0,  1558,  1360,  1361,  1362,  1363,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3510,     0,     0,     0,     0,   387,
       0,   478,     0,  1171,     0,     0,     0,     0,     0,     0,
       0,  1560,     0,     0,     0,     0,     0,     0,   387,     0,
       0,  3510,  3510,   387,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3510,  3510,     0,     0,     0,  3510,     0,     0,
       0,     0,  1364,     0,  1365,  1366,  1367,     0,     0,     0,
       0,     0,     0,  3510,  1368,  3510,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1561,     0,     0,     0,     0,
       0,  3510,     0,     0,  1562,     0,     0,     0,     0,     0,
    3510,     0,     0,     0,     0,     0,     0,   387,     0,     0,
       0,     0,     0,     0,  3510,     0,   387,  3510,     0,     0,
       0,     0,     0,     0,     0,  3510,     0,     0,     0,     0,
       0,  3510,     0,     0,     0,     0,     0,     0,     0,     0,
    1369,  1320,     0,  1322,     0,     0,  3510,     0,     0,   387,
       0,   387,  3510,     0,     0,  3510,     0,   387,     0,     0,
       0,     0,     0,  3510,     0,     0,   387,     0,     0,     0,
     387,     0,     0,     0,     0,   478,  3510,     0,     0,     0,
       0,   478,     0,     0,     0,     0,   387,  1370,  1371,  3510,
       0,  3510,   387,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3510,  3510,     0,     0,  3510,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   387,  1407,     0,
    1410,     0,   478,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3512,     0,   478,   563,     0,     0,     0,     0,
       0,     0,     0,     0,   478,   478,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1439,     0,     0,     0,  3512,
    3512,     0,     0,  1448,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   388,   388,   478,
     478,     0,     0,     0,     0,     0,     0,   388,     0,   563,
       0,     0,     0,     0,     0,   388,     0,     0,     0,     0,
    3512,  3512,     0,     0,  1372,  3512,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1373,  1374,   478,     0,     0,
       0,  3512,     0,  3512,     0,     0,     0,     0,     0,     0,
       0,     0,     1,     0,     0,     0,     0,     0,     0,  3512,
       0,     0,     2,     3,     0,     0,     0,     0,  3512,     0,
       0,     0,     0,     0,     0,     4,     0,     5,     0,     0,
       0,     0,  3512,   478,     0,  3512,   478,     0,     0,     0,
       0,     0,     0,  3512,     0,     0,     6,     7,     0,  3512,
       0,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,     0,     0,     0,  3512,     0,     0,     0,     0,    11,
    3512,     0,     0,  3512,     0,     0,     0,     0,     0,     0,
       0,  3512,     0,     0,     0,   563,    12,   563,   388,   388,
       0,   478,     0,     0,  3512,     0,     0,     0,     0,     0,
     739,     0,  1620,     0,     0,    13,     0,  3512,     0,  3512,
       0,     0,     0,     0,    14,    15,    16,     0,     0,     0,
       0,  3512,  3512,     0,     0,  3512,     0,    17,    18,     0,
       0,     0,     0,     0,     0,     0,  1660,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      19,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    20,     0,     0,
       0,     0,     0,     2,     3,     0,  1660,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,    22,     0,
       0,    23,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     8,     0,     0,     0,     9,    10,     0,
       0,     0,    24,     0,     0,     0,     0,     0,     0,     0,
      11,     0,     0,     0,  1763,     0,     0,     0,    25,     0,
       0,     0,     0,     0,     0,     0,     0,    12,     0,   563,
       0,     0,     0,     0,     0,     0,    26,     0,     0,     0,
       0,    27,     0,     0,     0,     0,    13,     0,     0,     0,
       0,     0,     0,     0,     0,    14,    15,    16,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    17,    18,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   563,     0,     0,     0,     0,
    1821,    19,   563,     0,     0,     0,     0,   563,     0,     0,
       0,     0,     0,   478,     0,  1831,     0,     0,    20,     0,
    1836,  1836,     0,  1836,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   478,     0,    28,   478,     0,
       0,     0,    21,     0,   563,   563,   478,   478,     0,    22,
       0,     0,    23,     0,  1836,  1836,  1836,     0,     0,    29,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,  1903,    24,     0,     0,     0,     0,     0,     0,
       0,  1914,     0,     0,     0,     0,     0,     0,    31,    25,
      32,    33,     0,     0,    34,     0,     0,    35,  1922,    36,
       0,     0,     0,     0,    37,     0,    38,    26,     0,   478,
       0,     0,    27,     0,     0,    39,     0,     0,     0,    40,
       0,  1935,     0,     0,     0,    41,     0,   478,     0,     0,
      42,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2019,     0,     0,     0,
       0,     0,     0,     0,    46,  2023,     0,     0,    28,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,     0,     0,     0,     0,    49,     0,
      29,     0,     0,   388,     0,     0,     0,     0,     0,    30,
       0,   478,     0,     0,  2063,     0,     0,     0,     0,     0,
       0,    50,     0,     0,   616,     0,   578,   617,     0,    31,
       0,    32,    33,     0,     0,    34,     0,     0,    35,     0,
      36,     0,    51,     0,     0,    37,     0,    38,     0,   618,
     619,     0,     0,     0,     0,     0,    39,     0,     0,   620,
      40,   621,     0,     0,     0,     0,    41,     0,     0,     0,
       0,    42,     0,     0,     0,    43,     0,     0,     0,   622,
       0,   623,     0,     0,     0,     0,     0,     0,     0,   624,
       0,     0,     0,     0,     0,    44,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46, -1362,   625,     0,     0,
       0,   626,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    48,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   627,     0,   628,     0,     0,     0,  2230,     0,     0,
       0,     0,    50,     0,     0,   629,     0,   630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,     0,     0,     0,
     631,   632,     0,     0,   633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   635,     0,     0,     0,     0,   636,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2294,     0,
       0,   637,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2313,  2315,     0,     0,
       0,     0,     0,   563,     0,   563,   563,     0,     0,     0,
       0,     0,     0,     0,   638,     0,     0,     0,     0,     0,
       0,     0,     0,   639,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   640,  1763,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   563,   563,     0,     0,     0,     0,
       0,     0,     0,     0,  2019,     0,     0,   641,   642,     0,
    2019,   643,   644,  2019,     0,     0,  2019,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2019,  2019,     0,
     563,     0,     0,     0,     0,     0,  2019,  1763,     0,     0,
       0,     0,     0,     0,     0,     0,   478,     0,   563,     0,
       0,     0,  2019,  2441,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   645,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   646,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   478,  2019,     0,     0,     0,     0,     0,     0,
   -1806,     0,     0,     0,   647,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   563,   648,
       0,     0,     0,     0,     0,   563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2505,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1806,     0,     0,     0,   649,     0,     0,
       0,     0,     0,     0,  1660,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2601,     0,     0,
       0,  1831,     0,   963,   563,   563,   563,     0,     0,     0,
       0,     0,     0,     0,   478,     0,     0,     0,   563,     0,
       0,  1763,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   563,   563,   563,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2644,     0,
       0,     0,     0,     0,  2646,     0,  2648,     0,     0,     0,
       0,     0,     0,     0,   563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2019,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   563,     0,     0,  2019,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   478,     0,     0,     0,     0,     0,     0,
    2713,     0,     0,   478,     0,     0,     0,  2769,  2770,     0,
       0,  2773,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   478,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   965,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2294,  2916,     0,   563,     0,
       0,     0,     0,     0,     0,     0,     0,   563,     0,     0,
       0,     0,     0,  2601,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   563,     0,     0,     0,     0,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1763,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2019,     0,     0,     0,     0,     0,     0,  2019,     0,     0,
       0,     0,     0,     0,  1763,     0,     0,     0,     0,     0,
    2019,     0,     0,     0,     0,     0,     0,  1120,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1235,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3093,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1311,     0,     0,     0,  1318,     0,     0,
       0,     0,     0,     0,     0,     0,  1763,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   563,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3058,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1446,     0,     0,     0,     0,     0,     0,     0,  3212,
    1461,  3213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   478,     0,     0,     0,     0,     0,  3227,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2313,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3300,     0,     0,     0,     0,     0,  3058,  3058,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3318,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   563,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1622,  1623,  1624,     0,     0,     0,     0,     0,
       0,  1639,  1640,     0,     0,  1643,     0,  1645,  1646,  1647,
    1648,     0,     0,     0,  1652,     0,     0,  1654,  1655,  3343,
    1656,     0,  1657,  1658,     0,  1661,  1662,  1663,  1664,  1665,
       0,  1668,  3058,  1670,  1671,  1672,     0,  1674,  1675,  1676,
    1677,     0,  1679,  1680,     0,  1686,     0,     0,  1690,  1691,
    1692,     0,  1694,  1695,  1696,  1697,     0,  1699,  1700,  1701,
    1702,     0,     0,     0,     0,     0,  1709,  1710,     0,  1713,
    1714,  1715,  1716,  1717,     0,     0,     0,     0,  1721,     0,
    1722,  1723,  1724,  1725,  1726,     0,     0,  1729,  1731,  1732,
    1733,  1734,  1735,     0,  1737,  1738,     0,     0,  1741,  1742,
    1743,     0,  1746,     0,  1747,     0,     0,     0,  1750,     0,
    1754,  1755,     0,     0,     0,     0,  1758,     0,     0,     0,
       0,     0,     0,     0,  1765,  1766,  1767,     0,     0,     0,
       0,     0,     0,  1318,     0,     0,  1775,     0,     0,     0,
       0,     0,     0,     0,     0,  3227,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1763,   478,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3300,     0,  3300,     0,  3452,  2023,     0,
       0,     0,     0,     0,     0,  1819,     0,     0,     0,  3460,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3480,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1763,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3526,     0,     0,     0,     0,  3533,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3551,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3617,     0,     0,  2024,     0,     0,     0,     0,
       0,  3628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1763,     0,  3659,     0,     0,     0,
       0,     0,  3665,     0,     0,     0,     0,     0,     0,     0,
       0,   563,     0,     0,     0,  1763,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1763,     0,     0,     0,     0,     0,  3699,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3699,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2198,  2200,  2202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2216,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2242,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2479,     0,     0,  2480,     0,     0,  2482,
    2483,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2496,     0,     0,  2499,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2506,     0,
    2507,     0,     0,     0,  2510,     0,  2511,  2512,     0,     0,
       0,  2515,     0,  2516,  2517,     0,  2518,     0,     0,  2519,
       0,  2520,  2521,     0,     0,     0,     0,  2525,  2526,     0,
       0,  2528,     0,  2529,     0,  2530,     0,  2531,     0,  2533,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2538,  2539,     0,     0,  2540,     0,  2541,     0,     0,     0,
       0,     0,     0,     0,  2542,  2543,     0,  2544,     0,  2545,
       0,     0,  2546,  2547,  2548,     0,  2549,     0,     0,     0,
       0,  2552,  2553,  2554,  2555,     0,     0,     0,     0,  2557,
    2558,  2559,     0,  2560,     0,  2562,     0,  2564,     0,  2566,
       0,  2567,     0,     0,     0,     0,     0,     0,  2569,     0,
    2570,     0,     0,  2572,  2573,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2582,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2591,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2609,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2653,     0,     0,     0,     0,
    2657,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2688,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2691,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2790,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2861,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2872,     0,  2874,
       0,  2876,     0,     0,     0,     0,     0,  2882,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2938,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3064,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3068,     0,     0,     0,     0,
       0,  3069,     0,     0,     0,     0,     0,     0,     0,     0,
    3073,  3074,     0,     0,     0,     0,  3075,     0,     0,     0,
    3076,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3080,     0,     0,     0,     0,     0,  3082,
       0,     0,  3083,  3084,     0,  3085,  3086,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3091,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3142,  3143,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2688,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2688,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2653,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3354,
       0,     0,     0,     0,     0,  3356,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3372,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3384,     0,  3386,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2688,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3475,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3489,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3554,  3555,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3575,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3586,
       0,     0,     0,     0,  3590,     0,     0,     0,     0,     0,
       0,     0,     0,  3600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   122,     0,   741,   124,   125,   126,   127,
       0,     0,     0,     0,  3632,   128,     0,     0,   742,     0,
     743,   130,   131,   744,   133,  3640,   134,   745,   135,     0,
     746,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,  1751,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,  3700,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,   772,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,  1752,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,   828,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   670,   358,   856,
     857,   858,   859,     0,     0,     0,     0,  1753,   363,     0,
     364,   860,   861,   862,   366,   367,   368,     0,   863,   369,
     370,   864,     0,   371,     0,     0,   865,   866,   372,     0,
       0,   373,     0,   374,     0,   867,   376,     0,     0,   868,
     869,   870,   871,   872,   377,     0,     0,   378,   873,     0,
     379,   380,   874,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   875,     0,   876,     0,     0,     0,     0,   877,
       0,     0,     0,   878,   879,     0,     0,     0,     0,   880,
       0,   881,     0,     0,   882,   883,     0,   884,   885,   122,
       0,   741,   124,   125,   126,   127,  2649,     0,     0,     0,
       0,   128,     0,     0,   742,     0,   743,   130,   131,   744,
     133,     0,   134,   745,   135,     0,  2650,   136,   747,   748,
     749,   137,   750,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   751,   145,     0,   146,   752,
     753,   148,     0,   149,   150,   151,   754,   152,     0,   755,
     154,     0,   155,   156,   157,   158,   159,   756,   757,   160,
       0,   161,   162,     0,   758,   164,     0,   759,   760,   761,
     165,     0,     0,   166,   762,   763,     0,   764,   765,     0,
     167,   168,   766,   767,   768,     0,     0,     0,     0,   769,
     171,   770,     0,     0,   771,  2651,   172,     0,   173,     0,
       0,     0,   773,   774,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     775,   182,     0,   776,   777,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   778,     0,   191,   779,
     192,   780,   781,   193,   194,     0,   782,   195,   196,   197,
     783,     0,   198,     0,     0,   784,     0,   199,   200,     0,
     785,   201,     0,   202,   786,   787,   788,   789,     0,   790,
     791,   204,   792,   793,   794,   206,     0,   207,   795,     0,
     796,   797,     0,   208,   209,     0,   210,   798,     0,   211,
       0,     0,     0,   799,   213,   214,   215,   800,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   801,   219,   802,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   803,   226,     0,     0,
     804,   227,     0,   805,   228,     0,     0,     0,   806,     0,
     807,     0,   230,   808,     0,   231,     0,   232,   809,     0,
       0,   810,     0,     0,     0,     0,   811,   233,   234,   235,
     236,   237,   238,   812,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   813,   248,   249,   250,   814,   251,   252,
       0,     0,     0,   253,   254,   255,   815,   257,     0,     0,
     816,   259,   817,   818,   260,     0,   261,   819,   820,   821,
     822,   823,   824,   825,   266,   267,   268,   269,     0,   826,
     270,   271,     0,   272,   273,   274,   827,   828,   829,   275,
       0,   830,   831,     0,   276,   277,     0,   832,  2652,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   833,   834,   286,   835,   836,
     837,   838,   839,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   840,   297,   298,   299,   300,   301,
     302,   303,   841,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   842,   843,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     844,   318,   319,   845,   320,   321,   846,   322,   847,   324,
     325,     0,   848,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   849,   850,   345,   346,     0,   347,   851,   349,   852,
     853,   854,   350,   351,   352,   353,   855,   354,   355,     0,
     356,   357,     0,   670,   358,   856,   857,   858,   859,     0,
       0,     0,     0,     0,   363,     0,   364,   860,   861,   862,
     366,   367,   368,     0,   863,   369,   370,   864,     0,   371,
       0,     0,   865,   866,   372,     0,     0,   373,     0,   374,
       0,   867,   376,     0,     0,   868,   869,   870,   871,   872,
     377,     0,     0,   378,   873,     0,   379,   380,   874,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   875,     0,
     876,     0,     0,     0,     0,   877,     0,     0,     0,   878,
     879,     0,     0,     0,     0,   880,     0,   881,     0,     0,
     882,   883,     0,   884,   885,   122,     0,   741,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     742,     0,   743,   130,   131,   744,   133,     0,   134,   745,
     135,     0,   746,   136,   747,   748,   749,   137,   750,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   751,   145,     0,   146,   752,   753,   148,     0,   149,
     150,   151,   754,   152,     0,   755,   154,     0,   155,   156,
     157,   158,   159,   756,   757,   160,     0,   161,   162,     0,
     758,   164,     0,   759,   760,   761,   165,     0,     0,   166,
     762,   763,     0,   764,   765,     0,   167,   168,   766,   767,
     768,     0,     0,     0,     0,   769,   171,   770,     0,     0,
     771,   772,   172,     0,   173,     0,     0,     0,   773,   774,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   775,   182,     0,   776,
     777,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   778,     0,   191,   779,   192,   780,   781,   193,
     194,     0,   782,   195,   196,   197,   783,     0,   198,     0,
       0,   784,     0,   199,   200,     0,   785,   201,     0,   202,
     786,   787,   788,   789,     0,   790,   791,   204,   792,   793,
     794,   206,     0,   207,   795,     0,   796,   797,     0,   208,
     209,     0,   210,   798,     0,   211,     0,     0,     0,   799,
     213,   214,   215,   800,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   801,   219,   802,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   803,   226,     0,     0,   804,   227,     0,   805,
     228,     0,     0,     0,   806,     0,   807,     0,   230,   808,
       0,   231,     0,   232,   809,     0,     0,   810,     0,     0,
       0,     0,   811,   233,   234,   235,   236,   237,   238,   812,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   813,
     248,   249,   250,   814,   251,   252,     0,     0,     0,   253,
     254,   255,   815,   257,     0,     0,   816,   259,   817,   818,
     260,     0,   261,   819,   820,   821,   822,   823,   824,   825,
     266,   267,   268,   269,     0,   826,   270,   271,     0,   272,
     273,   274,   827,   828,   829,   275,     0,   830,   831,     0,
     276,   277,     0,   832,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   833,   834,   286,   835,   836,   837,   838,   839,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     840,   297,   298,   299,   300,   301,   302,   303,   841,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   842,   843,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   844,   318,   319,   845,
     320,   321,   846,   322,   847,   324,   325,     0,   848,   327,
    1316,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   849,   850,   345,
     346,     0,   347,   851,   349,   852,   853,   854,   350,   351,
     352,   353,   855,   354,   355,     0,   356,   357,     0,   670,
     358,   856,   857,   858,   859,     0,     0,     0,     0,     0,
     363,     0,   364,   860,   861,   862,   366,   367,   368,     0,
     863,   369,   370,   864,     0,   371,     0,     0,   865,   866,
     372,     0,     0,   373,     0,   374,     0,   867,   376,     0,
       0,   868,   869,   870,   871,   872,   377,     0,     0,   378,
     873,     0,   379,   380,   874,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   875,     0,   876,     0,     0,     0,
       0,   877,     0,     0,     0,   878,   879,     0,     0,     0,
       0,   880,     0,  1317,     0,     0,   882,   883,     0,   884,
     885,   122,     0,   741,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   742,     0,   743,   130,
     131,   744,   133,     0,   134,   745,   135,     0,   746,   136,
     747,   748,   749,   137,   750,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   751,   145,     0,
     146,   752,   753,   148,     0,   149,   150,   151,   754,   152,
       0,   755,   154,     0,   155,   156,   157,   158,   159,   756,
     757,   160,     0,   161,   162,     0,   758,   164,     0,   759,
     760,   761,   165,     0,     0,   166,   762,   763,     0,   764,
     765,     0,   167,   168,   766,   767,   768,     0,     0,     0,
       0,   769,   171,   770,     0,     0,   771,   772,   172,     0,
     173,     0,     0,     0,   773,   774,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   775,   182,     0,   776,   777,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   778,     0,
     191,   779,   192,   780,   781,   193,   194,     0,   782,   195,
     196,   197,   783,     0,   198,     0,     0,   784,     0,   199,
     200,     0,   785,   201,     0,   202,   786,   787,   788,   789,
       0,   790,   791,   204,   792,   793,   794,   206,     0,   207,
     795,     0,   796,   797,     0,   208,   209,     0,   210,   798,
       0,   211,     0,     0,     0,   799,   213,   214,   215,   800,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   801,
     219,   802,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   803,   226,
       0,     0,   804,   227,     0,   805,   228,     0,     0,     0,
     806,     0,   807,     0,   230,   808,     0,   231,     0,   232,
     809,     0,     0,   810,     0,     0,     0,     0,   811,   233,
     234,   235,   236,   237,   238,   812,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   813,   248,   249,   250,   814,
     251,   252,     0,     0,     0,   253,   254,   255,   815,   257,
       0,     0,   816,   259,   817,   818,   260,     0,   261,   819,
     820,   821,   822,   823,   824,   825,   266,   267,   268,   269,
       0,   826,   270,   271,     0,   272,   273,   274,   827,   828,
     829,   275,     0,   830,   831,     0,   276,   277,     0,   832,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   833,   834,   286,
     835,   836,   837,   838,   839,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   840,   297,   298,   299,
     300,   301,   302,   303,   841,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     842,   843,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   844,   318,   319,   845,   320,   321,   846,   322,
     847,   324,   325,     0,   848,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   849,   850,   345,   346,     0,   347,   851,
     349,   852,   853,   854,   350,   351,   352,   353,   855,   354,
     355,     0,   356,   357,     0,   670,   358,   856,   857,   858,
     859,     0,     0,     0,     0,     0,   363,     0,   364,   860,
     861,   862,   366,   367,   368,     0,   863,   369,   370,   864,
       0,   371,     0,     0,   865,   866,   372,     0,     0,   373,
       0,   374,     0,   867,   376,     0,     0,   868,   869,   870,
     871,   872,   377,     0,     0,   378,   873,     0,   379,   380,
     874,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     875,     0,   876,     0,     0,     0,     0,   877,     0,     0,
       0,   878,   879,     0,     0,     0,     0,   880,     0,   881,
    1599,     0,   882,   883,     0,   884,   885,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,     0,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
       0,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,   772,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,     0,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,     0,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,   828,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   670,   358,   856,   857,   858,   859,     0,     0,     0,
       0,     0,   363,     0,   364,   860,   861,   862,   366,   367,
     368,     0,   863,   369,   370,   864,     0,   371,     0,     0,
     865,   866,   372,     0,     0,   373,     0,   374,     0,   867,
     376,     0,     0,   868,   869,   870,   871,   872,   377,     0,
       0,   378,   873,     0,   379,   380,   874,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   875,     0,   876,     0,
       0,     0,     0,   877,     0,     0,     0,   878,   879,     0,
       0,     0,     0,   880,     0,   881,  1693,     0,   882,   883,
       0,   884,   885,   122,     0,   741,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   742,     0,
     743,   130,   131,   744,   133,     0,   134,   745,   135,     0,
     746,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,     0,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,   772,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,     0,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,   828,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   670,   358,   856,
     857,   858,   859,     0,     0,     0,     0,     0,   363,     0,
     364,   860,   861,   862,   366,   367,   368,     0,   863,   369,
     370,   864,     0,   371,     0,     0,   865,   866,   372,     0,
       0,   373,     0,   374,     0,   867,   376,     0,     0,   868,
     869,   870,   871,   872,   377,     0,     0,   378,   873,     0,
     379,   380,   874,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   875,     0,   876,     0,     0,     0,     0,   877,
       0,     0,     0,   878,   879,     0,     0,     0,     0,   880,
       0,   881,  1730,     0,   882,   883,     0,   884,   885,   122,
       0,   741,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   742,     0,   743,   130,   131,   744,
     133,     0,   134,   745,   135,     0,   746,   136,   747,   748,
     749,   137,   750,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   751,   145,     0,   146,   752,
     753,   148,     0,   149,   150,   151,   754,   152,     0,   755,
     154,     0,   155,   156,   157,   158,   159,   756,   757,   160,
       0,   161,   162,     0,   758,   164,     0,   759,   760,   761,
     165,     0,     0,   166,   762,   763,     0,   764,   765,     0,
     167,   168,   766,   767,   768,     0,     0,     0,     0,   769,
     171,   770,     0,     0,   771,   772,   172,     0,   173,     0,
       0,     0,   773,   774,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     775,   182,     0,   776,   777,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   778,     0,   191,   779,
     192,   780,   781,   193,   194,     0,   782,   195,   196,   197,
     783,     0,   198,     0,     0,   784,     0,   199,   200,     0,
     785,   201,     0,   202,   786,   787,   788,   789,     0,   790,
     791,   204,   792,   793,   794,   206,     0,   207,   795,     0,
     796,   797,     0,   208,   209,     0,   210,   798,     0,   211,
       0,     0,     0,   799,   213,   214,   215,   800,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   801,   219,   802,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   803,   226,     0,     0,
     804,   227,     0,   805,   228,     0,     0,     0,   806,     0,
     807,     0,   230,   808,     0,   231,     0,   232,   809,     0,
       0,   810,     0,     0,     0,     0,   811,   233,   234,   235,
     236,   237,   238,   812,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   813,   248,   249,   250,   814,   251,   252,
       0,     0,     0,   253,   254,   255,   815,   257,     0,     0,
     816,   259,   817,   818,   260,     0,   261,   819,   820,   821,
     822,   823,   824,   825,   266,   267,   268,   269,     0,   826,
     270,   271,     0,   272,   273,   274,   827,   828,   829,   275,
       0,   830,   831,     0,   276,   277,     0,   832,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   833,   834,   286,   835,   836,
     837,   838,   839,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   840,   297,   298,   299,   300,   301,
     302,   303,   841,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   842,   843,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     844,   318,   319,   845,   320,   321,   846,   322,   847,   324,
     325,     0,   848,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   849,   850,   345,   346,     0,   347,   851,   349,   852,
     853,   854,   350,   351,   352,   353,   855,   354,   355,     0,
     356,   357,     0,   670,   358,   856,   857,   858,   859,     0,
       0,     0,     0,     0,   363,     0,   364,   860,   861,   862,
     366,   367,   368,     0,   863,   369,   370,   864,     0,   371,
       0,     0,   865,   866,   372,     0,     0,   373,     0,   374,
       0,   867,   376,     0,     0,   868,   869,   870,   871,   872,
     377,     0,     0,   378,   873,     0,   379,   380,   874,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   875,     0,
     876,     0,     0,     0,     0,   877,     0,     0,     0,   878,
     879,     0,     0,     0,     0,   880,     0,   881,  1757,     0,
     882,   883,     0,   884,   885,   122,     0,   741,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     742,     0,   743,   130,   131,   744,   133,     0,   134,   745,
     135,     0,   746,   136,   747,   748,   749,   137,   750,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   751,   145,     0,   146,   752,   753,   148,     0,   149,
     150,   151,   754,   152,     0,   755,   154,     0,   155,   156,
     157,   158,   159,   756,   757,   160,     0,   161,   162,     0,
     758,   164,     0,   759,   760,   761,   165,     0,     0,   166,
     762,   763,     0,   764,   765,     0,   167,   168,   766,   767,
     768,     0,     0,     0,     0,   769,   171,   770,     0,     0,
     771,   772,   172,     0,   173,     0,     0,     0,   773,   774,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   775,   182,     0,   776,
     777,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   778,     0,   191,   779,   192,   780,   781,   193,
     194,     0,   782,   195,   196,   197,   783,     0,   198,     0,
       0,   784,     0,   199,   200,  2197,   785,   201,     0,   202,
     786,   787,   788,   789,     0,   790,   791,   204,   792,   793,
     794,   206,     0,   207,   795,     0,   796,   797,     0,   208,
     209,     0,   210,   798,     0,   211,     0,     0,     0,   799,
     213,   214,   215,   800,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   801,   219,   802,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   803,   226,     0,     0,   804,   227,     0,   805,
     228,     0,     0,     0,   806,     0,   807,     0,   230,   808,
       0,   231,     0,   232,   809,     0,     0,   810,     0,     0,
       0,     0,   811,   233,   234,   235,   236,   237,   238,   812,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   813,
     248,   249,   250,   814,   251,   252,     0,     0,     0,   253,
     254,   255,   815,   257,     0,     0,   816,   259,   817,   818,
     260,     0,   261,   819,   820,   821,   822,   823,   824,   825,
     266,   267,   268,   269,     0,   826,   270,   271,     0,   272,
     273,   274,   827,   828,   829,   275,     0,   830,   831,     0,
     276,   277,     0,   832,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   833,   834,   286,   835,   836,   837,   838,   839,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     840,   297,   298,   299,   300,   301,   302,   303,   841,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   842,   843,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   844,   318,   319,   845,
     320,   321,   846,   322,   847,   324,   325,     0,   848,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   849,   850,   345,
     346,     0,   347,   851,   349,   852,   853,   854,   350,   351,
     352,   353,   855,   354,   355,     0,   356,   357,     0,   670,
     358,   856,   857,   858,   859,     0,     0,     0,     0,     0,
     363,     0,   364,   860,   861,   862,   366,   367,   368,     0,
     863,   369,   370,   864,     0,   371,     0,     0,   865,   866,
     372,     0,     0,   373,     0,   374,     0,   867,   376,     0,
       0,   868,   869,   870,   871,   872,   377,     0,     0,   378,
     873,     0,   379,   380,   874,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   875,     0,   876,     0,     0,     0,
       0,   877,     0,     0,     0,   878,   879,     0,     0,     0,
       0,   880,     0,   881,     0,     0,   882,   883,     0,   884,
     885,   122,     0,   741,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   742,     0,   743,   130,
     131,   744,   133,     0,   134,   745,   135,     0,   746,   136,
     747,   748,   749,   137,   750,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   751,   145,     0,
     146,   752,   753,   148,     0,   149,   150,   151,   754,   152,
       0,   755,   154,     0,   155,   156,   157,   158,   159,   756,
     757,   160,     0,   161,   162,     0,   758,   164,     0,   759,
     760,   761,   165,     0,     0,   166,   762,   763,     0,   764,
     765,     0,   167,   168,   766,   767,   768,     0,     0,     0,
       0,   769,   171,   770,     0,     0,   771,   772,   172,     0,
     173,     0,     0,     0,   773,   774,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   775,   182,     0,   776,   777,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   778,     0,
     191,   779,   192,   780,   781,   193,   194,     0,   782,   195,
     196,   197,   783,     0,   198,     0,     0,   784,     0,   199,
     200,  2199,   785,   201,     0,   202,   786,   787,   788,   789,
       0,   790,   791,   204,   792,   793,   794,   206,     0,   207,
     795,     0,   796,   797,     0,   208,   209,     0,   210,   798,
       0,   211,     0,     0,     0,   799,   213,   214,   215,   800,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   801,
     219,   802,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   803,   226,
       0,     0,   804,   227,     0,   805,   228,     0,     0,     0,
     806,     0,   807,     0,   230,   808,     0,   231,     0,   232,
     809,     0,     0,   810,     0,     0,     0,     0,   811,   233,
     234,   235,   236,   237,   238,   812,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   813,   248,   249,   250,   814,
     251,   252,     0,     0,     0,   253,   254,   255,   815,   257,
       0,     0,   816,   259,   817,   818,   260,     0,   261,   819,
     820,   821,   822,   823,   824,   825,   266,   267,   268,   269,
       0,   826,   270,   271,     0,   272,   273,   274,   827,   828,
     829,   275,     0,   830,   831,     0,   276,   277,     0,   832,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   833,   834,   286,
     835,   836,   837,   838,   839,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   840,   297,   298,   299,
     300,   301,   302,   303,   841,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     842,   843,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   844,   318,   319,   845,   320,   321,   846,   322,
     847,   324,   325,     0,   848,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   849,   850,   345,   346,     0,   347,   851,
     349,   852,   853,   854,   350,   351,   352,   353,   855,   354,
     355,     0,   356,   357,     0,   670,   358,   856,   857,   858,
     859,     0,     0,     0,     0,     0,   363,     0,   364,   860,
     861,   862,   366,   367,   368,     0,   863,   369,   370,   864,
       0,   371,     0,     0,   865,   866,   372,     0,     0,   373,
       0,   374,     0,   867,   376,     0,     0,   868,   869,   870,
     871,   872,   377,     0,     0,   378,   873,     0,   379,   380,
     874,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     875,     0,   876,     0,     0,     0,     0,   877,     0,     0,
       0,   878,   879,     0,     0,     0,     0,   880,     0,   881,
       0,     0,   882,   883,     0,   884,   885,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,     0,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
       0,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,   772,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,  2201,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,     0,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,   828,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   670,   358,   856,   857,   858,   859,     0,     0,     0,
       0,     0,   363,     0,   364,   860,   861,   862,   366,   367,
     368,     0,   863,   369,   370,   864,     0,   371,     0,     0,
     865,   866,   372,     0,     0,   373,     0,   374,     0,   867,
     376,     0,     0,   868,   869,   870,   871,   872,   377,     0,
       0,   378,   873,     0,   379,   380,   874,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   875,     0,   876,     0,
       0,     0,     0,   877,     0,     0,     0,   878,   879,     0,
       0,     0,     0,   880,     0,   881,     0,     0,   882,   883,
       0,   884,   885,   122,     0,   741,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   742,     0,
     743,   130,   131,   744,   133,     0,   134,   745,   135,     0,
     746,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,     0,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,   772,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,     0,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,   828,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   670,   358,   856,
     857,   858,   859,     0,     0,     0,     0,     0,   363,     0,
     364,   860,   861,   862,   366,   367,   368,     0,   863,   369,
     370,   864,     0,   371,     0,     0,   865,   866,   372,     0,
       0,   373,     0,   374,     0,   867,   376,     0,     0,   868,
     869,   870,   871,   872,   377,     0,     0,   378,   873,     0,
     379,   380,   874,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   875,     0,   876,     0,     0,     0,     0,   877,
       0,     0,     0,   878,   879,     0,     0,     0,     0,   880,
       0,   881,     0,     0,   882,   883,     0,   884,   885,   122,
       0,   741,   124,   125,   126,   127,  1789,     0,     0,     0,
       0,  1790,     0,     0,   742,     0,   743,   130,   131,   744,
     133,     0,   134,   745,   135,     0,   746,   136,   747,   748,
     749,   137,   750,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   751,   145,     0,   146,   752,
     753,   148,     0,   149,   150,   151,   754,   152,     0,   755,
     154,     0,   155,   156,   157,   158,   159,   756,   757,   160,
       0,   161,   162,     0,   758,   164,     0,   759,   760,   761,
     165,     0,     0,   166,   762,   763,     0,   764,   765,     0,
     167,   168,   766,   767,   768,     0,     0,     0,     0,   769,
     171,   770,     0,     0,   771,   772,   172,     0,   173,     0,
       0,     0,   773,   774,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     775,   182,     0,   776,   777,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   778,     0,   191,   779,
     192,   780,   781,   193,   194,     0,   782,   195,   196,   197,
     783,     0,   198,     0,     0,   784,     0,   199,   200,     0,
     785,   201,     0,   202,   786,   787,   788,   789,     0,   790,
     791,   204,   792,   793,   794,   206,     0,   207,   795,     0,
     796,   797,     0,   208,   209,     0,   210,   798,     0,   211,
       0,     0,     0,   799,   213,   214,   215,   800,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   801,   219,   802,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   803,   226,     0,     0,
     804,   227,     0,   805,   228,     0,     0,     0,   806,     0,
     807,     0,   230,   808,     0,   231,     0,   232,   809,     0,
       0,   810,     0,     0,     0,     0,   811,   233,   234,   235,
     236,   237,   238,   812,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   813,   248,   249,   250,   814,   251,   252,
       0,     0,     0,   253,   254,   255,   815,   257,     0,     0,
     816,   259,   817,   818,   260,     0,   261,   819,   820,   821,
     822,   823,   824,   825,   266,   267,   268,   269,     0,   826,
     270,   271,     0,   272,   273,   274,   827,     0,   829,   275,
       0,   830,   831,     0,   276,   277,     0,   832,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   833,   834,   286,   835,   836,
     837,   838,   839,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   840,   297,   298,   299,   300,   301,
     302,   303,   841,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   842,   843,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     844,   318,   319,   845,   320,   321,   846,   322,   847,   324,
     325,     0,   848,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   849,   850,   345,   346,     0,   347,   851,   349,   852,
     853,   854,   350,   351,   352,   353,   855,   354,   355,     0,
     356,   357,     0,   670,   358,   856,   857,   858,   859,     0,
       0,     0,     0,     0,   363,     0,   364,   860,   861,   862,
     366,   367,   368,     0,   863,   369,   370,   864,     0,   371,
       0,     0,   865,   866,   372,     0,     0,   373,     0,   374,
       0,   867,   376,     0,     0,   868,   869,   870,   871,   872,
     377,     0,     0,   378,   873,     0,   379,   380,   874,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   875,     0,
     876,     0,     0,     0,     0,   877,     0,     0,     0,   878,
     879,     0,     0,     0,     0,   880,     0,   881,     0,     0,
     882,   883,     0,   884,   885,   122,     0,   741,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     742,     0,   743,   130,   131,   744,   133,     0,   134,   745,
     135,     0,   746,   136,   747,   748,   749,   137,   750,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   751,   145,     0,   146,   752,   753,   148,     0,   149,
     150,   151,   754,   152,     0,   755,   154,     0,   155,   156,
     157,   158,   159,   756,   757,   160,     0,   161,   162,     0,
     758,   164,     0,   759,   760,   761,   165,     0,     0,   166,
     762,   763,     0,   764,   765,     0,   167,   168,   766,   767,
     768,     0,     0,     0,     0,   769,   171,   770,     0,     0,
     771,   772,   172,     0,   173,     0,     0,     0,   773,   774,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   775,   182,     0,   776,
     777,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   778,     0,   191,   779,   192,   780,   781,   193,
     194,     0,   782,   195,   196,   197,   783,     0,   198,     0,
       0,   784,     0,   199,   200,     0,   785,   201,     0,   202,
     786,   787,   788,   789,     0,   790,   791,   204,   792,   793,
     794,   206,     0,   207,   795,     0,   796,   797,     0,   208,
     209,     0,   210,   798,     0,   211,     0,     0,     0,   799,
     213,   214,   215,   800,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   801,   219,  2478,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   803,   226,     0,     0,   804,   227,     0,   805,
     228,     0,     0,     0,   806,     0,   807,     0,   230,   808,
       0,   231,     0,   232,   809,     0,     0,   810,     0,     0,
       0,     0,   811,   233,   234,   235,   236,   237,   238,   812,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   813,
     248,   249,   250,   814,   251,   252,     0,     0,     0,   253,
     254,   255,   815,   257,     0,     0,   816,   259,   817,   818,
     260,     0,   261,   819,   820,   821,   822,   823,   824,   825,
     266,   267,   268,   269,     0,   826,   270,   271,     0,   272,
     273,   274,   827,   828,   829,   275,     0,   830,   831,     0,
     276,   277,     0,   832,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   833,   834,   286,   835,   836,   837,   838,   839,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     840,   297,   298,   299,   300,   301,   302,   303,   841,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   842,   843,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   844,   318,   319,   845,
     320,   321,   846,   322,   847,   324,   325,     0,   848,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   849,   850,   345,
     346,     0,   347,   851,   349,   852,   853,   854,   350,   351,
     352,   353,   855,   354,   355,     0,   356,   357,     0,   670,
     358,   856,   857,   858,   859,     0,     0,     0,     0,     0,
     363,     0,   364,   860,   861,   862,   366,   367,   368,     0,
     863,   369,   370,   864,     0,   371,     0,     0,   865,   866,
     372,     0,     0,   373,     0,   374,     0,   867,   376,     0,
       0,   868,   869,   870,   871,   872,   377,     0,     0,   378,
     873,     0,   379,   380,   874,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   875,     0,   876,     0,     0,     0,
       0,   877,     0,     0,     0,   878,   879,     0,     0,     0,
       0,   880,     0,   881,     0,     0,   882,   883,     0,   884,
     885,   122,     0,   741,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   742,     0,   743,   130,
     131,   744,   133,     0,   134,   745,   135,     0,   746,   136,
     747,   748,   749,   137,   750,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   751,   145,     0,
     146,   752,   753,   148,     0,   149,   150,   151,   754,   152,
       0,   755,   154,     0,   155,   156,   157,   158,   159,   756,
     757,   160,     0,   161,   162,     0,   758,   164,     0,   759,
     760,   761,   165,     0,     0,   166,   762,   763,     0,   764,
     765,     0,   167,   168,   766,   767,   768,     0,     0,     0,
       0,   769,   171,   770,     0,     0,   771,   772,   172,     0,
     173,     0,     0,     0,   773,   774,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   775,   182,     0,   776,   777,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   778,     0,
     191,   779,   192,   780,   781,   193,   194,     0,   782,   195,
     196,   197,   783,     0,   198,     0,     0,   784,     0,   199,
     200,     0,   785,   201,     0,   202,   786,   787,   788,   789,
       0,   790,   791,   204,   792,   793,   794,   206,     0,   207,
     795,     0,   796,   797,     0,   208,   209,     0,   210,   798,
       0,   211,     0,     0,     0,   799,   213,   214,   215,   800,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   801,
     219,  2551,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   803,   226,
       0,     0,   804,   227,     0,   805,   228,     0,     0,     0,
     806,     0,   807,     0,   230,   808,     0,   231,     0,   232,
     809,     0,     0,   810,     0,     0,     0,     0,   811,   233,
     234,   235,   236,   237,   238,   812,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   813,   248,   249,   250,   814,
     251,   252,     0,     0,     0,   253,   254,   255,   815,   257,
       0,     0,   816,   259,   817,   818,   260,     0,   261,   819,
     820,   821,   822,   823,   824,   825,   266,   267,   268,   269,
       0,   826,   270,   271,     0,   272,   273,   274,   827,   828,
     829,   275,     0,   830,   831,     0,   276,   277,     0,   832,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   833,   834,   286,
     835,   836,   837,   838,   839,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   840,   297,   298,   299,
     300,   301,   302,   303,   841,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     842,   843,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   844,   318,   319,   845,   320,   321,   846,   322,
     847,   324,   325,     0,   848,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   849,   850,   345,   346,     0,   347,   851,
     349,   852,   853,   854,   350,   351,   352,   353,   855,   354,
     355,     0,   356,   357,     0,   670,   358,   856,   857,   858,
     859,     0,     0,     0,     0,     0,   363,     0,   364,   860,
     861,   862,   366,   367,   368,     0,   863,   369,   370,   864,
       0,   371,     0,     0,   865,   866,   372,     0,     0,   373,
       0,   374,     0,   867,   376,     0,     0,   868,   869,   870,
     871,   872,   377,     0,     0,   378,   873,     0,   379,   380,
     874,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     875,     0,   876,     0,     0,     0,     0,   877,     0,     0,
       0,   878,   879,     0,     0,     0,     0,   880,     0,   881,
       0,     0,   882,   883,     0,   884,   885,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,     0,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
       0,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,  2900,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,     0,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,     0,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,   828,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   670,   358,   856,   857,   858,   859,     0,     0,     0,
       0,     0,   363,     0,   364,   860,   861,   862,   366,   367,
     368,     0,   863,   369,   370,   864,     0,   371,     0,     0,
     865,   866,   372,     0,     0,   373,     0,   374,     0,   867,
     376,     0,     0,   868,   869,   870,   871,   872,   377,     0,
       0,   378,   873,     0,   379,   380,   874,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   875,     0,   876,     0,
       0,     0,     0,   877,     0,     0,     0,   878,   879,     0,
       0,     0,     0,   880,     0,   881,     0,     0,   882,   883,
       0,   884,   885,   122,     0,   741,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   742,     0,
     743,   130,   131,   744,   133,     0,   134,   745,   135,     0,
     746,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,     0,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,   772,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,     0,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,     0,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   670,   358,   856,
     857,   858,   859,     0,     0,     0,     0,     0,   363,     0,
     364,   860,   861,   862,   366,   367,   368,     0,   863,   369,
     370,   864,     0,   371,     0,     0,   865,   866,   372,     0,
       0,   373,     0,   374,     0,   867,   376,     0,     0,   868,
     869,   870,   871,   872,   377,     0,     0,   378,   873,     0,
     379,   380,   874,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   875,     0,   876,     0,     0,     0,     0,   877,
       0,     0,     0,   878,   879,     0,     0,     0,     0,   880,
       0,   881,     0,     0,   882,   883,     0,   884,   885,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,  1966,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,  1967,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,  1113,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,  1114,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,  2463,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,  1876,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,  1968,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,     0,
     385,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,  2015,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,  1966,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,  1967,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,  1113,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,  1114,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,  1968,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,     0,     0,   345,   346,     0,   347,
     348,   349,     0,     0,     0,   350,   351,   352,   353,     0,
     354,   355,     0,   356,   357,     0,     0,   358,   359,   360,
     361,   362,     0,     0,     0,     0,     0,   363,     0,   364,
       0,     0,   365,   366,   367,   368,     0,     0,   369,   370,
       0,     0,   371,     0,     0,     0,     0,   372,     0,     0,
     373,     0,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,     0,     0,   378,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   382,     0,   383,   384,
       0,     0,     0,   385,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,  2015,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
    1876,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,     0,   385,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,  2288,     0,   130,   131,   132,   133,
     885,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,     0,   385,
       0,     0,     0,     0,     0,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,  3652,   128,     0,
       0,   129,  3653,   885,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,   987,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,   328,   329,   330,     0,     0,   331,
       0,     0,     0,   332,   333,   334,   335,     0,   336,   337,
     338,     0,     0,     0,     0,     0,     0,   339,   340,     0,
     341,     0,     0,   342,     0,     0,   343,   344,     0,     0,
     345,   346,     0,   347,   348,   349,     0,     0,     0,   350,
     351,   352,   353,     0,   354,   355,     0,   356,   357,     0,
       0,   358,   359,   360,   361,   362,     0,     0,     0,     0,
       0,   363,     0,   364,     0,     0,   365,   366,   367,   368,
       0,     0,   369,   370,     0,     0,   371,     0,     0,     0,
       0,   372,     0,     0,   373,     0,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,     0,     0,
     378,     0,     0,   379,   380,   381,     0,     0,     0,     0,
     382,     0,   383,   384,     0,     0,     0,   385,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   421,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,     0,
     385,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,  1834,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   421,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,     0,     0,   345,   346,     0,   347,
     348,   349,     0,     0,     0,   350,   351,   352,   353,     0,
     354,   355,     0,   356,   357,     0,     0,   358,   359,   360,
     361,   362,     0,     0,     0,     0,     0,   363,     0,   364,
       0,     0,   365,   366,   367,   368,     0,     0,   369,   370,
       0,     0,   371,     0,     0,     0,     0,   372,     0,     0,
     373,     0,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,     0,     0,   378,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   382,     0,   383,   384,
       0,     0,     0,   385,     0,     0,     0,     0,     0,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2014,     0,   128,     0,     0,   129,     0,  2015,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
       0,   385,     0,     0,     0,     0,     0,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,  3653,   885,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,     0,   385,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   421,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   475,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,     0,     0,   345,   346,     0,   347,   348,
     349,     0,     0,     0,   350,   351,   352,   353,     0,   354,
     355,     0,   356,   357,     0,     0,   358,   359,   360,   361,
     362,     0,     0,     0,     0,     0,   363,     0,   364,     0,
       0,   365,   366,   367,   368,     0,     0,   369,   370,     0,
       0,   371,     0,     0,     0,     0,   372,     0,     0,   373,
       0,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,     0,     0,   378,     0,     0,   379,   380,
     381,     0,     0,     0,     0,   382,     0,   383,   384,     0,
       0,     0,   385,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,   421,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,     0,   385,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,   885,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,     0,
       0,   345,   346,     0,   347,   348,   349,     0,     0,     0,
     350,   351,   352,   353,     0,   354,   355,     0,   356,   357,
       0,     0,   358,   359,   360,   361,   362,     0,     0,     0,
       0,     0,   363,     0,   364,     0,     0,   365,   366,   367,
     368,     0,     0,   369,   370,     0,     0,   371,     0,     0,
       0,     0,   372,     0,     0,   373,     0,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,     0,
       0,   378,     0,     0,   379,   380,   381,     0,     0,     0,
       0,   382,     0,   383,   384,     0,     0,     0,   385,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,  2015,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,   560,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,   561,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
     122,   385,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,  1776,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,   560,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,   561,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
     122,   385,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,  2328,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,   560,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,   561,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
     122,   385,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,  2923,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3495,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,     0,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3496,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3497,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3498,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3499,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3501,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,     0,   334,
       0,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
       0,   344,     0,     0,     0,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
       0,   366,   367,   368,     0,     0,   369,   370,     0,     0,
       0,     0,     0,     0,     0,   372,     0,     0,   373,     0,
       0,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,  -186,     0,   382,     0,   383,     0,     0,     0,
       0,   385,     0,     0,     0,     0,  3502,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
    3704,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,     0,
       0,   345,   346,     0,   347,   348,   349,     0,     0,     0,
     350,   351,   352,   353,     0,   354,   355,     0,   356,   357,
       0,     0,   358,   359,   360,   361,   362,     0,     0,     0,
       0,     0,   363,     0,   364,     0,     0,   365,   366,   367,
     368,     0,     0,   369,   370,     0,     0,   371,     0,     0,
       0,     0,   372,     0,     0,   373,     0,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,     0,
       0,   378,     0,     0,   379,   380,   381,     0,     0,     0,
       0,   382,     0,   383,   384,     0,     0,     0,   385,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,  1619,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,     0,
     385,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2314,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,     0,     0,   345,   346,     0,   347,   348,
     349,     0,     0,     0,   350,   351,   352,   353,     0,   354,
     355,     0,   356,   357,     0,     0,   358,   359,   360,   361,
     362,     0,     0,     0,     0,     0,   363,     0,   364,     0,
       0,   365,   366,   367,   368,     0,     0,   369,   370,     0,
       0,   371,     0,     0,     0,     0,   372,     0,     0,   373,
       0,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,     0,     0,   378,     0,     0,   379,   380,
     381,     0,     0,     0,     0,   382,     0,   383,   384,     0,
       0,     0,   385,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  2604,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,     0,     0,   345,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,   365,   366,   367,   368,     0,     0,   369,
     370,     0,     0,   371,     0,     0,     0,     0,   372,     0,
       0,   373,     0,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,     0,     0,   382,     0,   383,
     384,     0,     0,     0,   385,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  2928,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3495,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,  -201,     0,   182,     0,     0,
       0,  -201,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3496,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3497,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3498,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3499,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -186,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3501,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,     0,   334,     0,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,     0,   344,     0,     0,     0,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,     0,   366,   367,   368,     0,
       0,   369,   370,     0,     0,     0,     0,     0,     0,     0,
     372,     0,     0,   373,     0,     0,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,  -186,     0,   382,
       0,   383,     0,     0,     0,     0,   385,     0,     0,  -201,
     122,  3502,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3495,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  -222,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3496,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3497,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3498,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3499,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3501,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,     0,   334,
       0,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
       0,   344,     0,     0,     0,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
       0,   366,   367,   368,     0,     0,   369,   370,     0,     0,
       0,     0,     0,     0,     0,   372,     0,     0,   373,     0,
       0,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
    -222,     0,  -186,     0,   382,     0,   383,     0,     0,     0,
       0,   385,     0,     0,  -222,   122,  3502,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3495,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,  -219,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3496,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3497,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3498,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3499,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -186,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3501,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,     0,   334,     0,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,     0,   344,     0,     0,     0,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,     0,   366,   367,   368,     0,
       0,   369,   370,     0,     0,     0,     0,     0,     0,     0,
     372,     0,     0,   373,     0,     0,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,  -219,     0,  -186,     0,   382,
       0,   383,     0,     0,     0,     0,   385,     0,     0,  -219,
     122,  3502,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3495,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  3582,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3496,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3497,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3498,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3499,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3501,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,     0,   334,
       0,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
       0,   344,     0,     0,     0,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
       0,   366,   367,   368,     0,     0,   369,   370,     0,     0,
       0,     0,     0,     0,     0,   372,     0,     0,   373,     0,
       0,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,  -186,     0,   382,     0,   383,     0,     0,     0,
       0,   385,     0,     0,     0,   122,  3502,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3495,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,  -224,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3496,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3497,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3498,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3499,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -186,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3501,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,     0,   334,     0,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,     0,   344,     0,     0,     0,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,     0,   366,   367,   368,     0,
       0,   369,   370,     0,     0,     0,     0,     0,     0,     0,
     372,     0,     0,   373,     0,     0,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,  -186,     0,   382,
       0,   383,     0,     0,     0,     0,   385,     0,     0,     0,
     122,  3502,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3495,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  3629,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3496,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3497,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3498,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3499,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3501,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,     0,   334,
       0,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
       0,   344,     0,     0,     0,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
       0,   366,   367,   368,     0,     0,   369,   370,     0,     0,
       0,     0,     0,     0,     0,   372,     0,     0,   373,     0,
       0,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,  -186,     0,   382,     0,   383,     0,     0,     0,
       0,   385,     0,     0,     0,   122,  3502,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3495,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,  3670,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3496,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3497,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3498,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3499,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -186,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3501,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,     0,   334,     0,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,     0,   344,     0,     0,     0,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,     0,   366,   367,   368,     0,
       0,   369,   370,     0,     0,     0,     0,     0,     0,     0,
     372,     0,     0,   373,     0,     0,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,  -186,     0,   382,
       0,   383,     0,     0,     0,     0,   385,     0,     0,     0,
     122,  3502,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3495,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  -205,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3496,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3497,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3498,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3499,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3501,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,     0,   334,
       0,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
       0,   344,     0,     0,     0,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
       0,   366,   367,   368,     0,     0,   369,   370,     0,     0,
       0,     0,     0,     0,     0,   372,     0,     0,   373,     0,
       0,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,  -186,     0,   382,     0,   383,     0,     0,     0,
       0,   385,     0,     0,     0,   122,  3502,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3495,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,     0,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3496,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3497,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3498,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3499,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -186,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3501,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,     0,   334,     0,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,     0,   344,     0,     0,     0,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,     0,   366,   367,   368,     0,
       0,   369,   370,     0,     0,     0,     0,     0,     0,     0,
     372,     0,     0,   373,     0,     0,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,  -186,     0,   382,
       0,   383,     0,     0,     0,     0,   385,     0,     0,     0,
     122,  3502,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3495,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,     0,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3496,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3497,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3498,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3499,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3501,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,     0,   334,
       0,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
       0,   344,     0,     0,     0,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
       0,   366,   367,   368,     0,     0,   369,   370,     0,     0,
       0,     0,     0,     0,     0,   372,     0,     0,  3585,     0,
       0,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,  -186,     0,   382,     0,   383,     0,     0,     0,
       0,   385,     0,     0,     0,   122,  3502,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,  1629,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,  1630,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,  1631,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,  1632,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,   712,   713,     0,   275,     0,     0,  1633,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,  3692,  3682,  3693,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
    1634,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2320,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2321,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,  1953,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,  1954,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2330,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2331,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2320,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2321,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,   716,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,   668,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,   669,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   670,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2369,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2320,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   560,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,  2310,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,  3624,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,  3625,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,   735,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  1109,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  1901,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
    1902,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,  2021,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,   561,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  1901,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,  1408,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
    1409,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,   122,   385,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,     0,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,     0,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,     0,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,     0,     0,   312,     0,     0,   314,
       0,     0,   316,   317,     0,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,     0,   334,     0,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,     0,   344,     0,     0,     0,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,     0,   366,   367,   368,     0,
       0,   369,   370,     0,     0,     0,     0,     0,     0,     0,
     372,     0,     0,   373,     0,     0,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,     0,     0,     0,     0,   385
};

static const short int yycheck[] =
{
       7,   450,   500,   470,   601,   683,  1180,  1026,   425,  1306,
     973,  1306,    19,   649,  1770,    22,   723,   724,   725,   762,
     763,   764,    29,   746,   577,   462,   463,   464,   768,   466,
     525,   468,    39,   624,   626,   496,   497,  1088,  1957,  1530,
    1216,  1852,    49,    22,   828,  1911,  1904,  1905,  1906,  2346,
    1880,  1327,  1543,  2062,  1388,  1214,  2705,   649,  1334,   650,
    2080,  1935,  1182,  1183,  1184,   526,  1208,  2087,  2295,  1943,
     108,  1945,   110,  1102,  2690,  1195,  1270,  1615,  1496,  1323,
      87,  1942,  2682,  1053,  1895,   457,   829,     3,   583,  1918,
    1919,  1345,  1346,     3,  1064,  1065,     3,     3,    16,     3,
     107,   108,     3,   110,    16,     3,  1248,     3,    87,    18,
    1976,    18,   855,  1972,   121,     3,   856,    32,    49,   859,
    1187,  1188,    16,  1190,    56,   868,   869,   870,    16,  1249,
    1996,  1997,  1252,    59,   595,    58,   687,    18,    27,   509,
    1966,  1620,   121,  1337,  1444,  1339,  1972,   687,    20,  1975,
      18,    95,  1978,   156,    28,   878,   879,   880,  1225,  2059,
    1280,  1281,   107,  1989,  1990,  1285,   111,    34,    20,    69,
     175,    54,  1998,  1240,   156,   898,    10,    34,  2735,    58,
      32,  2738,    11,    55,    56,  1305,   135,  1307,    49,    94,
     129,  1258,  1259,  1260,    46,  1510,   691,    60,    63,   147,
    2757,   138,  1269,    55,    56,    59,  2763,    58,   625,  2288,
     111,   148,  1175,   205,    20,   111,   588,    20,    55,    56,
     229,   166,  2390,  1967,  1968,  2055,    32,   252,   175,    32,
    2967,   347,    63,   694,  1106,    32,   145,   263,   145,  2796,
      46,   651,  3504,    46,   115,   115,   683,   170,   413,    55,
      56,    75,    55,    56,    77,   229,   105,   191,   203,    56,
    2960,   214,   175,   407,   145,    94,   175,   175,   341,   107,
     130,   325,   236,   156,   179,   361,   159,   145,   289,    12,
    1618,   236,   324,   175,   430,  3415,   172,     4,    12,   172,
     489,   170,     9,    10,   249,  2282,   489,    44,   568,   343,
      97,    38,   344,   100,   466,  2617,   172,    40,   234,  2909,
      27,   108,    96,    66,     8,    32,   214,   361,   226,    36,
    1941,   113,   267,   430,   258,   174,   169,   530,   166,   430,
     430,   156,   402,   344,   516,   464,   203,   253,   112,   548,
       3,   507,    12,   253,   530,  1992,   203,   253,    81,   253,
     179,   175,   223,    86,   126,    18,   545,    76,   217,   488,
     209,   175,    11,  2010,   530,   203,   575,   466,   439,   440,
     559,   214,   575,    92,   221,  2687,   575,   539,  2365,   382,
     234,    37,   229,   120,  2966,   214,   579,    97,   574,  1927,
     100,    89,   574,   338,   892,   269,   262,   667,  1076,   116,
     382,   125,   270,   489,   411,   331,  1580,   506,   573,   217,
     229,  1585,   204,   350,   421,   229,   299,  1591,   425,  3119,
    1594,    64,    61,   430,  3686,    88,  3008,   573,   435,   267,
     238,   575,    49,   217,  2991,   489,   352,   507,   330,  1030,
     466,  3057,   352,  3000,   352,   489,   270,  1038,   412,   372,
     457,   430,   405,   200,   228,   125,    52,   306,  3588,   513,
    1013,   416,   923,   112,   580,   314,   573,   474,   905,   374,
     164,  2329,   573,   573,   466,  1066,  1067,   484,   270,  2398,
     411,   488,   145,   521,   321,   523,   524,   494,   530,   496,
     497,  1231,  2353,   372,   501,   502,  1088,   436,   231,   382,
     338,   435,   575,  2361,   511,   484,  1626,   405,   515,   172,
     357,  3111,   145,   520,   521,   976,   523,   524,   525,   526,
    1490,   546,   390,  2014,   361,   986,  2064,  2695,  2387,   326,
     404,   380,   195,  3149,   204,  1564,  1031,   463,   201,   172,
     374,   313,  2401,   394,  1095,   374,   528,  2626,   474,  1421,
     411,   488,   559,  1891,  1107,  1095,   219,   382,   381,  1299,
     977,  2387,   573,   226,  2055,   510,   575,   300,   575,   574,
     430,  2471,   575,   236,  3311,  2401,   583,   584,   145,   428,
     485,   588,   445,  1880,  2063,  1880,   249,  1707,   595,   563,
     253,  1711,   964,   575,   517,   543,   575,  1897,   542,   262,
     107,   466,  1796,  1154,   498,   584,   538,  1801,  1802,   498,
     559,   511,  1771,  1336,  1154,   987,  2913,   498,   625,  1934,
     474,   530,   489,   376,  1744,   551,   359,   461,   575,  1352,
     546,  1807,   489,  1809,  1793,   466,   546,   542,   517,  1076,
     546,  2385,   546,   515,   575,   563,   443,  1944,  1018,  1944,
    1099,   563,  1062,   524,   524,  1378,   485,  2884,   573,   166,
     548,   324,   575,   515,   580,   581,   575,   501,  3284,  3369,
     580,   581,   510,   547,   581,   581,   683,   581,   425,   158,
     581,   344,   550,   581,   691,   581,   529,   694,   574,   352,
     697,   698,   575,   581,  3343,   544,   203,   494,    94,  3348,
     417,   485,  1999,   528,  1999,   354,  1773,   556,   542,   515,
     353,   374,   515,   573,   179,   432,   449,   577,   335,   698,
     418,   438,    64,  2061,    28,   522,   733,   574,   735,   548,
     483,   537,   538,  2354,  2355,  3351,  1108,    23,   541,   335,
    1157,   458,   579,   108,   563,   401,   158,   480,    58,   502,
      94,   390,   177,   416,   733,  3052,   735,    67,  2982,   415,
     267,  2985,  2620,  2301,  2302,   573,    70,   131,  1205,    79,
     573,   111,    32,   436,  1948,  3332,   113,  3334,    64,   107,
     436,   491,    68,   179,   494,   455,   456,   457,   458,   459,
     460,   301,   253,  2623,   411,   567,   568,   569,  2672,   430,
    2658,   471,  2676,  1977,   437,  1979,   489,   149,   471,   402,
    1984,  2672,   287,   107,    67,  2676,   498,   270,   430,   436,
    3436,   217,   217,  2634,    34,   111,  2000,    12,  2002,  2003,
    2004,   338,  1330,  2692,   178,   573,   287,   141,   166,   426,
    2094,  2095,   580,   238,   430,  3402,   175,  3404,   267,   549,
     436,  1487,  1289,   516,   179,   191,  1293,   573,   337,   349,
     170,    50,   227,    12,   580,  3514,  2692,   530,   178,    58,
     437,  1424,   166,   217,   332,   333,   883,  3477,   885,  1515,
     465,  1434,    68,   546,   469,   548,   325,   445,  1479,  1384,
     100,   352,   575,   575,    80,  1487,   253,   107,  1489,  1918,
    1919,  1492,  1493,    12,  1321,  1458,   229,   217,  2964,   374,
     917,   574,   575,   506,    68,   485,   923,   170,   581,   338,
     332,   333,   258,  1515,   253,   337,    80,  2345,   238,   252,
     381,  1426,  1427,   270,  1395,   360,  2474,   390,   917,   267,
     125,    12,   573,   362,  2953,     0,   453,   112,   158,   535,
     536,  2145,   238,   960,  2784,   962,   166,   964,  1928,  2788,
    1377,   573,  3186,    54,   217,   214,  2986,   121,  1521,   976,
     977,  2247,  1389,   267,   370,     3,   125,   487,   374,   986,
     987,  1019,  1020,  1946,  2013,   238,  2283,   573,  2283,  2233,
     997,  1029,   356,   203,   445,   352,  3645,   337,   325,  1037,
     221,   370,   512,   510,  2146,  3232,  1455,    12,   229,   345,
     338,   353,  1019,  1020,  1021,  1022,   125,   164,  2085,   444,
     485,   270,  1029,  2090,  1031,   504,   391,   287,  1581,  1582,
    1037,  1584,   430,  1586,  1587,  1588,  1589,  1590,  2105,  1592,
    1593,   520,  1021,  1022,   338,  2112,   332,   333,    19,   374,
     489,   337,  1059,   430,   125,   241,    88,   267,   344,   107,
    2127,  2128,   372,   228,   545,   156,   370,  2134,   159,   258,
    2404,   145,   395,   420,   513,  2142,   485,  1800,   559,  2937,
    1059,   172,  2241,   335,  2945,  2946,   372,   241,   392,  2248,
     486,   510,   504,   112,  3150,  3151,   243,   550,  1105,   435,
     398,  1108,   483,  2066,   485,   501,   450,   472,   520,  3333,
       8,  3335,  3121,   417,  2181,   325,  3498,  3499,   166,   372,
     125,   325,  1160,  1161,  3421,   311,  1105,   337,   338,    27,
     445,   527,    88,   382,   573,    88,   357,   535,   536,   486,
     450,   485,   486,  2681,   258,   116,   542,   399,   434,   335,
    1157,   580,  1159,  1160,  1161,   203,  1163,   311,   443,   516,
     485,   465,   489,  3183,   462,  1172,   498,  1174,   289,  3466,
      71,    72,    16,   517,   351,   573,   213,   354,   332,   333,
     527,   335,   510,   527,  1163,   500,   513,   219,   335,   275,
     276,  2258,  2683,  2684,  2685,   542,   573,   545,   565,   566,
     577,  1208,   390,   389,   236,  3587,    88,   517,   299,   485,
     111,   559,  3385,  1520,  3387,   403,   510,   249,    88,   267,
     486,  2712,   336,   344,  3054,  1532,  1533,  3540,  1535,  1536,
    1537,   517,   133,  1540,  1403,   389,  1405,   522,  1545,   562,
     217,  1248,  1549,  1550,  1551,   433,   573,  1554,  1555,  1556,
    1557,  1558,  1689,  1560,  1561,  1562,  2266,  2267,  2268,   192,
     483,  3135,   485,   219,   165,  3578,   219,  1436,  1437,  1438,
    2485,   213,   557,   538,  2489,   461,   541,    55,    56,   489,
     236,   491,   226,   236,   494,   489,    64,  2297,  2298,  2299,
     338,   382,   324,   249,   504,   347,   249,   175,   229,  1306,
     510,   120,   548,   513,   527,  3618,   270,   461,   580,   513,
     396,   397,   344,  1531,  1321,    20,  1534,   574,  2594,  1756,
    3633,   252,   145,    28,   461,  1543,  2502,  2503,    33,  3642,
    2627,   573,  2627,   405,  1552,   383,    11,   219,   386,  2724,
     574,   575,  2727,  2728,   410,  1898,   412,   152,   414,   219,
     416,   344,   574,   575,   236,   565,   566,   290,   291,  2744,
     530,   294,   295,  3676,   373,  3678,   236,   249,   324,   573,
    1377,   324,   483,   463,   464,  1382,   466,  1384,   468,   249,
     574,   575,  1389,  2680,   416,  2680,   205,   420,  1395,   349,
    1397,   344,   574,   575,   949,  1402,  1403,   952,  1405,   344,
     955,   332,   333,   575,  1347,  1348,  1349,  1350,  1351,  2706,
    1417,  2706,   214,  1420,    47,     3,   574,   575,     6,  1426,
    1427,  1428,  1429,  1402,  1403,    13,  1405,  1980,  1981,  1436,
    1437,  1438,   574,   575,   175,    23,    24,   263,  1417,   471,
      47,  1420,   324,   575,   263,   574,   575,  1454,  2001,  1428,
    1429,   344,  2236,   426,   324,   567,  1463,  1436,  1437,  1438,
     416,   527,   510,   416,   395,    53,   145,   516,   287,    57,
     574,   575,  2523,  1480,   344,  3286,   452,   453,   263,   455,
      68,   574,   575,     3,  1491,   164,   574,   575,  1905,    77,
    1907,  1908,   393,   574,   575,    83,  1503,   150,    18,   574,
     575,   436,  1509,  2718,   506,   184,   574,   575,    96,   574,
     575,   573,  1491,   574,   575,   471,   253,   448,   471,   198,
    2587,  2244,   172,   111,   574,   575,   114,   574,   575,   466,
    1509,   574,   575,  1982,   416,   123,   124,  2752,  2753,  1956,
    1957,   129,   466,   574,   575,  2760,   416,   574,   575,   137,
    2257,   287,  2767,   466,   373,   143,    15,    16,   574,   575,
     483,  1568,   381,   263,   243,   244,   142,  1605,    88,    78,
    1577,    55,    56,   346,  3432,  1992,   574,   575,   574,   575,
     575,   169,  3448,  3339,   145,   146,   574,   575,   479,   471,
     409,   574,   271,  2010,   429,  3471,   574,   575,  1605,  3518,
      52,   471,   574,   575,   574,   575,  1613,   574,   575,  1616,
     399,  2908,   152,  2908,  2790,  2980,  2981,   574,   575,   573,
    2630,  1343,  1344,   184,   542,   145,   445,   215,   579,   217,
     211,   562,   563,  2998,  1613,   575,   224,   198,   542,  3004,
     574,   575,   574,   575,   574,   575,   575,   466,   573,   169,
     553,   330,   172,   574,   575,   574,   575,   574,   575,   574,
     575,  2098,  3027,  2080,   483,  3030,   485,   575,  3544,  2106,
    2087,   232,   574,   575,   580,   195,  1983,   574,   575,   574,
     575,   201,   570,   244,  3560,  2861,  3562,  1994,   573,    23,
      24,   580,   371,   573,   214,   574,   575,   573,  2295,   219,
    2336,   574,   575,   564,   292,   573,   226,   574,   575,   573,
     271,   574,   575,    12,    13,   573,   236,   574,   575,   307,
     573,    55,    56,    57,   312,  3601,   574,   575,  3604,   249,
      64,   574,   575,   253,    68,   573,  3612,   574,   575,  1345,
    1346,   573,   262,    77,  2336,  2684,  2685,  1290,  1291,  3156,
    3157,  2636,  2637,  2344,  2606,  2607,   573,  2310,  2898,  2899,
     573,   573,    96,  3639,   352,   573,   573,   328,   489,  2788,
     358,   575,  1779,   361,  3650,   573,   573,   111,   573,   573,
     114,   573,   573,   573,    47,  2280,   573,  3663,    87,   573,
     573,   573,   573,   573,   573,   287,   384,   385,   573,   387,
     483,   573,   573,   573,   324,   573,   573,   573,   573,   143,
     573,  2228,   573,   401,  3690,  3691,   115,   573,  3694,   573,
     573,   573,   573,  2890,   344,   573,   573,   573,   573,    34,
     129,  2326,   352,   573,   573,   423,   579,   575,   573,   573,
     573,   573,   573,   573,   573,   573,  2399,   573,   573,   573,
     573,   573,   151,  2406,   374,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   163,   573,   273,   274,   275,   276,
     277,   278,   573,  1880,   281,   282,   283,   284,   285,   286,
     573,   288,   573,   217,   573,   573,   573,   573,   573,   573,
     224,  1898,  1899,   192,   548,   100,   416,   573,  1905,   573,
    1907,  1908,   107,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   436,   573,   217,   507,
     258,   573,   573,   287,   223,   573,   573,  2650,   516,   573,
     573,   573,   573,   573,   573,   573,   573,  1944,   573,   573,
     498,   573,   498,   229,   575,   575,   575,   575,   575,  1956,
    1957,   471,   575,   158,   489,    12,    13,   567,   292,  1966,
     172,   166,   230,   262,   481,  1972,   160,   575,  1975,   172,
     523,  1978,   575,   307,  2435,   447,   363,  2940,   573,   575,
     574,  2398,  1989,  1990,   145,  1992,   145,   575,   145,   396,
     397,  1998,  1999,   581,   145,   145,   516,   145,   203,   145,
     145,  2008,   145,  2010,   145,   145,   145,  2014,  2015,   529,
     530,   145,   145,   145,   525,   575,    45,   574,   344,   179,
     175,    64,    12,   574,   358,   489,   546,   361,   548,  2008,
      87,   574,   125,     9,   580,   574,   574,   545,   574,   573,
     566,   252,   575,   390,   546,   218,   175,  2054,  2055,   580,
     384,   385,   574,   387,   574,   575,   192,   445,   115,   381,
     436,   581,   267,   575,   172,   575,    45,   461,  2775,   461,
    3365,   461,   129,  2080,   429,  2054,   375,   461,   461,    67,
    2087,   498,   122,   237,   484,   237,   484,   122,    45,   423,
     575,   530,   580,  2100,   151,   394,   575,  3271,  3272,  3273,
    3274,   400,   575,   574,   574,   574,   163,   406,   574,   574,
      18,   574,   574,    23,    24,   575,   574,   574,   567,   575,
     325,   575,   575,   574,   574,   580,   574,  3247,   575,   334,
     574,   430,   337,   338,   575,   192,   574,   175,   575,  2146,
     575,   574,   441,   442,   575,    55,    56,    57,   575,   575,
     574,   262,   575,   575,    64,   574,   437,   575,    68,   575,
     217,   574,   498,   575,   575,   574,   223,    77,   578,   575,
     575,   574,   574,   507,   575,   498,   575,   573,   575,   478,
     575,  3476,   516,   574,   498,   574,    96,  2894,   574,   574,
     563,   489,   573,   575,  3261,   574,   574,   574,   258,   574,
     574,   111,   574,   574,   114,   262,   575,   574,   574,   574,
     580,   498,   575,   575,   575,   575,   574,   574,   574,   349,
     574,  2228,  2639,   575,   575,   524,   574,   526,   175,   575,
     575,   574,   574,   143,   575,   574,   580,   574,  2655,   574,
     573,   575,   574,   573,   575,   574,   550,   575,   573,   175,
     175,   226,  2259,   175,   548,   233,  2263,   338,  2265,  2266,
    2267,  2268,   580,   580,   575,   236,   236,   355,    96,  2276,
     303,    96,   238,  2280,   238,   580,  2283,   573,   573,   489,
     573,   352,   567,   574,   489,   574,   491,  2884,   225,   494,
    2297,  2298,  2299,   338,   338,   574,   574,  2276,   574,   504,
     175,   175,   175,  2310,   338,   510,   560,   217,   513,  2316,
     141,  2318,   574,   574,   224,   580,   580,   574,   375,  2326,
     580,   574,   574,   567,   573,   344,   214,   575,   574,   580,
     175,   524,   229,   250,    64,   275,   236,   394,   236,  3636,
     344,  3636,   252,   400,   575,   238,   238,   575,    18,   406,
     344,    18,   574,    18,   573,   227,   574,   253,   574,   574,
     565,   566,  3657,   227,   573,   573,   580,   574,   574,   132,
     574,   560,   574,   430,   574,   574,  3673,   575,  3673,   574,
    2387,   247,   292,   574,   441,   442,  2939,   574,   574,   574,
     574,  2398,  3070,   575,  2401,   574,   574,   307,  3572,   574,
     574,   195,   574,   580,   575,   574,   574,   574,   574,   574,
     430,   575,   575,  3153,  3154,  3155,   438,   575,   574,   145,
     355,   478,   575,   236,   236,   574,   111,   574,  2435,   111,
     574,   369,   574,   338,   338,  2442,   574,   574,  2445,   574,
     432,    41,  2449,  2450,   575,   573,  2453,   574,   358,   574,
     574,   361,   574,  3196,  3007,   574,  2463,   574,   574,   574,
     574,   574,   574,   381,   573,   575,  2445,   524,   575,   526,
     574,   574,   574,   574,   384,   385,   574,   387,   575,   574,
     574,   580,   574,   574,  2463,   575,   575,   574,   574,   573,
     575,   573,   338,   573,   573,   573,   573,   573,   338,  3177,
     574,   574,   574,   226,   574,   574,  2923,   574,   574,  3216,
    3217,   574,  3190,   423,   575,   574,   548,    45,   574,   310,
     201,   575,   580,   390,   489,   236,   489,   530,   530,   172,
     338,   573,   573,   338,  2983,    32,   573,   573,   338,   524,
     541,   541,   573,  3096,   111,   238,   238,    31,    32,   337,
     548,   338,   338,    37,   338,    39,   338,    41,    42,   338,
     574,   509,   575,   573,   575,   574,   574,   574,   574,  2986,
     575,   310,    56,   154,    23,    24,   575,   574,   574,   574,
     489,   574,   489,   574,   238,   574,   489,  3330,   574,  3006,
     574,   574,   574,   574,   574,    66,    16,   507,   530,   530,
     574,   574,   236,   334,   172,   574,   516,   574,    57,   536,
     338,   338,   574,    97,   574,   574,   100,   575,   574,    68,
    2627,  2628,   574,  2630,   108,   574,   485,   349,    77,   575,
     574,   255,  2639,  3070,   524,  3232,   276,  3344,  2645,   573,
     573,    58,   349,   127,   573,    58,   574,    96,  2655,   374,
     574,   574,    45,   574,   574,    45,  2663,   138,    45,   145,
     144,   394,   111,   573,     5,   114,   349,   134,   574,   349,
    3223,   413,    45,  2680,   575,    45,    45,   121,   424,   574,
     574,   165,    16,   167,   575,  2692,   280,   545,   573,   578,
     175,   545,  2699,   574,   143,   582,   226,   145,   141,  2706,
     213,   581,   186,   187,   574,  2712,   575,  3124,   560,   545,
     141,   109,   269,   581,   128,   214,   338,   582,   561,   581,
     573,   560,   141,   199,   575,  3403,   575,   436,   255,   141,
     172,   581,   561,   172,   172,   404,   560,   111,   547,   536,
    3177,   173,  1826,   227,  1595,     7,   689,  3566,  3227,  3347,
    3220,  3704,  3667,  3190,  3675,  3598,  3557,    19,  3598,  3564,
      22,  3439,  3440,  3053,  3442,  2782,  3183,    29,   217,   405,
    3148,  1095,   256,  2055,  1154,   224,  1564,    39,  2017,  2786,
    1530,   265,   266,  2712,   268,  2699,  1970,    49,  2768,  2735,
      13,  1568,  3175,  2735,  2969,  3015,  3006,  2700,  3391,  2655,
    3400,  3167,  3316,  3234,  3190,  3483,  2013,  3485,  3486,  1428,
    1150,  1875,   296,   297,   298,  1073,  1498,  1167,  1857,   698,
    2276,   682,  1889,   469,   613,    87,  3281,  1443,  2893,  3096,
    2894,  1245,  2088,   317,   318,   319,  1340,  1342,  2670,   323,
    3390,  3548,   326,   292,  2249,   107,   108,  3145,   110,  3124,
    3592,  2706,  1894,  1853,  1879,   339,   340,  2908,   307,   121,
    2622,   987,  2680,  2621,    87,  3657,  3476,   459,  1195,  1172,
    1488,   516,   735,  3340,   450,  1394,  2612,  3547,  2885,  3378,
    3567,   365,  3446,   367,  3673,  3592,   992,  3008,  2627,   964,
    1449,  2328,   115,  2663,  2934,  3132,  1420,   442,   596,   995,
    1005,  2908,   957,  1159,  3269,  2263,   129,   391,  3275,   358,
     443,   600,   361,  3092,     6,   486,  2923,  3415,  2053,  3050,
     731,    13,    -1,  1316,    -1,    -1,  2779,    -1,   151,    -1,
      -1,    23,    24,    -1,    -1,   384,   385,    -1,   387,    -1,
     163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,    -1,   436,    -1,    -1,    -1,    -1,  2964,    -1,    -1,
      -1,    53,   446,    -1,    -1,    57,  3403,    -1,    -1,   192,
      -1,    -1,    -1,    -1,   423,    -1,    68,    -1,    -1,  2986,
      -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,   217,    -1,    -1,    -1,    -1,  3006,
     223,    -1,  3439,  3440,    96,  3442,   490,   491,    -1,    -1,
     494,   495,   496,   497,    -1,    -1,    -1,    -1,    -1,   111,
      -1,    -1,   114,    -1,  3031,    -1,  3033,    -1,    -1,  3478,
      -1,   123,    -1,    -1,    -1,    -1,  3043,   129,    -1,   262,
      -1,    -1,  3049,    -1,    -1,   137,  3483,    -1,  3485,  3486,
      -1,   143,    -1,   537,   538,    -1,    -1,    -1,   507,    -1,
      -1,    -1,    -1,    -1,  3043,    -1,    -1,   516,    -1,    -1,
      -1,    -1,   556,    -1,    -1,    -1,    -1,   169,    -1,    -1,
      -1,    23,    24,    -1,    -1,    -1,    -1,    -1,    -1,  3096,
    3588,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3518,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    55,    56,    57,    -1,  3124,    -1,    -1,
      -1,    -1,    64,    -1,    -1,   217,    68,    -1,    -1,    -1,
      -1,    -1,   224,    -1,    -1,    77,    -1,  3144,    -1,    -1,
      -1,    -1,    -1,  3150,  3151,    -1,    -1,    -1,    -1,   411,
      -1,    -1,   375,    -1,    96,    -1,    -1,  3164,    -1,   421,
      -1,    -1,    -1,   425,    -1,    -1,    -1,    -1,   430,   111,
      -1,   394,   114,   435,    -1,    -1,  3183,   400,    -1,    -1,
      -1,  3679,    -1,   406,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   457,    -1,    -1,    -1,    -1,
     292,   143,    -1,    -1,    -1,    -1,  3704,   430,    -1,    -1,
      -1,    -1,   474,    -1,  3221,   307,    -1,    -1,   441,   442,
     312,    -1,   484,    -1,    -1,    -1,   488,  3234,    -1,    -1,
      -1,    -1,   494,    -1,   496,   497,  3653,    -1,    -1,   501,
     502,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,
      -1,    -1,    -1,   515,    -1,   478,    -1,    -1,   520,   521,
     352,   523,   524,   525,   526,  3702,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
      -1,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   384,   385,    -1,   387,    -1,   559,    -1,    -1,
      -1,   524,    -1,   526,    -1,    -1,    -1,    -1,    -1,   401,
      -1,    -1,    -1,   575,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,    -1,    -1,   588,    -1,    -1,    -1,
      -1,   423,    -1,   595,    -1,    -1,    -1,    -1,    -1,    -1,
    3347,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3365,  3366,
      -1,    -1,    -1,   625,    -1,   307,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3385,    -1,
    3387,    -1,  3389,  3390,    -1,    -1,    -1,  3366,    -1,    -1,
      -1,    -1,    -1,    -1,  3401,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,   507,   358,    -1,    -1,   361,
      -1,   683,    -1,    -1,   516,    -1,    -1,    -1,    -1,   691,
    3437,    -1,   694,    -1,    -1,   697,   698,    -1,    -1,    -1,
      -1,    -1,   384,   385,    -1,   387,   206,   207,   208,   209,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3471,    -1,    -1,    -1,    -1,  3476,
      -1,   733,    -1,   735,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,  3495,    -1,
      -1,  3498,  3499,  3500,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3518,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3539,  3540,    -1,    -1,    -1,  3544,    -1,    -1,
      -1,    -1,   302,    -1,   304,   305,   306,    -1,    -1,    -1,
      -1,    -1,    -1,  3560,   314,  3562,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,    -1,    -1,
      -1,  3578,    -1,    -1,   516,    -1,    -1,    -1,    -1,    -1,
    3587,    -1,    -1,    -1,    -1,    -1,    -1,  3594,    -1,    -1,
      -1,    -1,    -1,    -1,  3601,    -1,  3603,  3604,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3612,    -1,    -1,    -1,    -1,
      -1,  3618,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     380,   883,    -1,   885,    -1,    -1,  3633,    -1,    -1,  3636,
      -1,  3638,  3639,    -1,    -1,  3642,    -1,  3644,    -1,    -1,
      -1,    -1,    -1,  3650,    -1,    -1,  3653,    -1,    -1,    -1,
    3657,    -1,    -1,    -1,    -1,   917,  3663,    -1,    -1,    -1,
      -1,   923,    -1,    -1,    -1,    -1,  3673,   427,   428,  3676,
      -1,  3678,  3679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3690,  3691,    -1,    -1,  3694,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3704,   960,    -1,
     962,    -1,   964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3471,    -1,   976,   977,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   986,   987,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   997,    -1,    -1,    -1,  3498,
    3499,    -1,    -1,  1005,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1019,  1020,  1021,
    1022,    -1,    -1,    -1,    -1,    -1,    -1,  1029,    -1,  1031,
      -1,    -1,    -1,    -1,    -1,  1037,    -1,    -1,    -1,    -1,
    3539,  3540,    -1,    -1,   544,  3544,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   555,   556,  1059,    -1,    -1,
      -1,  3560,    -1,  3562,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,  3578,
      -1,    -1,    13,    14,    -1,    -1,    -1,    -1,  3587,    -1,
      -1,    -1,    -1,    -1,    -1,    26,    -1,    28,    -1,    -1,
      -1,    -1,  3601,  1105,    -1,  3604,  1108,    -1,    -1,    -1,
      -1,    -1,    -1,  3612,    -1,    -1,    47,    48,    -1,  3618,
      -1,    -1,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,  3633,    -1,    -1,    -1,    -1,    70,
    3639,    -1,    -1,  3642,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3650,    -1,    -1,    -1,  1157,    87,  1159,  1160,  1161,
      -1,  1163,    -1,    -1,  3663,    -1,    -1,    -1,    -1,    -1,
    1172,    -1,  1174,    -1,    -1,   106,    -1,  3676,    -1,  3678,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,    -1,
      -1,  3690,  3691,    -1,    -1,  3694,    -1,   128,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1208,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,    -1,    -1,    13,    14,    -1,  1248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      -1,   192,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    -1,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    -1,    -1,  1306,    -1,    -1,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,  1321,
      -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,    -1,
      -1,   262,    -1,    -1,    -1,    -1,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1377,    -1,    -1,    -1,    -1,
    1382,   151,  1384,    -1,    -1,    -1,    -1,  1389,    -1,    -1,
      -1,    -1,    -1,  1395,    -1,  1397,    -1,    -1,   168,    -1,
    1402,  1403,    -1,  1405,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1417,    -1,   348,  1420,    -1,
      -1,    -1,   192,    -1,  1426,  1427,  1428,  1429,    -1,   199,
      -1,    -1,   202,    -1,  1436,  1437,  1438,    -1,    -1,   370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,
      -1,    -1,  1454,   223,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1463,    -1,    -1,    -1,    -1,    -1,    -1,   399,   239,
     401,   402,    -1,    -1,   405,    -1,    -1,   408,  1480,   410,
      -1,    -1,    -1,    -1,   415,    -1,   417,   257,    -1,  1491,
      -1,    -1,   262,    -1,    -1,   426,    -1,    -1,    -1,   430,
      -1,  1503,    -1,    -1,    -1,   436,    -1,  1509,    -1,    -1,
     441,    -1,    -1,    -1,   445,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   465,    -1,    -1,    -1,   469,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1568,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   505,  1577,    -1,    -1,   348,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,
     370,    -1,    -1,  1605,    -1,    -1,    -1,    -1,    -1,   379,
      -1,  1613,    -1,    -1,  1616,    -1,    -1,    -1,    -1,    -1,
      -1,   552,    -1,    -1,    30,    -1,    32,    33,    -1,   399,
      -1,   401,   402,    -1,    -1,   405,    -1,    -1,   408,    -1,
     410,    -1,   573,    -1,    -1,   415,    -1,   417,    -1,    55,
      56,    -1,    -1,    -1,    -1,    -1,   426,    -1,    -1,    65,
     430,    67,    -1,    -1,    -1,    -1,   436,    -1,    -1,    -1,
      -1,   441,    -1,    -1,    -1,   445,    -1,    -1,    -1,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,    -1,   465,    -1,    -1,    -1,   469,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   505,   142,   143,    -1,    -1,
      -1,   147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,  1779,    -1,    -1,
      -1,    -1,   552,    -1,    -1,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   573,    -1,    -1,    -1,    -1,    -1,    -1,
     216,   217,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1880,    -1,
      -1,   287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1898,  1899,    -1,    -1,
      -1,    -1,    -1,  1905,    -1,  1907,  1908,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   347,  1944,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1956,  1957,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1966,    -1,    -1,   373,   374,    -1,
    1972,   377,   378,  1975,    -1,    -1,  1978,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1989,  1990,    -1,
    1992,    -1,    -1,    -1,    -1,    -1,  1998,  1999,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2008,    -1,  2010,    -1,
      -1,    -1,  2014,  2015,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   445,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2054,  2055,    -1,    -1,    -1,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2080,   485,
      -1,    -1,    -1,    -1,    -1,  2087,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   539,    -1,    -1,    -1,   543,    -1,    -1,
      -1,    -1,    -1,    -1,  2146,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2228,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2259,    -1,    -1,
      -1,  2263,    -1,  2265,  2266,  2267,  2268,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2276,    -1,    -1,    -1,  2280,    -1,
      -1,  2283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2297,  2298,  2299,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2310,    -1,
      -1,    -1,    -1,    -1,  2316,    -1,  2318,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2326,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2387,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2398,    -1,    -1,  2401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2435,    -1,    -1,    -1,    -1,    -1,    -1,
    2442,    -1,    -1,  2445,    -1,    -1,    -1,  2449,  2450,    -1,
      -1,  2453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2463,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   518,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   571,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2627,  2628,    -1,  2630,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2639,    -1,    -1,
      -1,    -1,    -1,  2645,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2655,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2663,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2680,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2692,    -1,    -1,    -1,    -1,    -1,    -1,  2699,    -1,    -1,
      -1,    -1,    -1,    -1,  2706,    -1,    -1,    -1,    -1,    -1,
    2712,    -1,    -1,    -1,    -1,    -1,    -1,   701,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2786,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   802,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   877,    -1,    -1,    -1,   881,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2908,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2986,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3006,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1005,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3031,
    1014,  3033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3043,    -1,    -1,    -1,    -1,    -1,  3049,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3096,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3144,    -1,    -1,    -1,    -1,    -1,  3150,  3151,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3183,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1176,  1177,  1178,    -1,    -1,    -1,    -1,    -1,
      -1,  1185,  1186,    -1,    -1,  1189,    -1,  1191,  1192,  1193,
    1194,    -1,    -1,    -1,  1198,    -1,    -1,  1201,  1202,  3221,
    1204,    -1,  1206,  1207,    -1,  1209,  1210,  1211,  1212,  1213,
      -1,  1215,  3234,  1217,  1218,  1219,    -1,  1221,  1222,  1223,
    1224,    -1,  1226,  1227,    -1,  1229,    -1,    -1,  1232,  1233,
    1234,    -1,  1236,  1237,  1238,  1239,    -1,  1241,  1242,  1243,
    1244,    -1,    -1,    -1,    -1,    -1,  1250,  1251,    -1,  1253,
    1254,  1255,  1256,  1257,    -1,    -1,    -1,    -1,  1262,    -1,
    1264,  1265,  1266,  1267,  1268,    -1,    -1,  1271,  1272,  1273,
    1274,  1275,  1276,    -1,  1278,  1279,    -1,    -1,  1282,  1283,
    1284,    -1,  1286,    -1,  1288,    -1,    -1,    -1,  1292,    -1,
    1294,  1295,    -1,    -1,    -1,    -1,  1300,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1308,  1309,  1310,    -1,    -1,    -1,
      -1,    -1,    -1,  1317,    -1,    -1,  1320,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3365,  3366,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3385,    -1,  3387,    -1,  3389,  3390,    -1,
      -1,    -1,    -1,    -1,    -1,  1379,    -1,    -1,    -1,  3401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3437,    -1,    -1,    -1,  1423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3476,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3495,    -1,    -1,    -1,    -1,  3500,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3518,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3529,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3594,    -1,    -1,  1579,    -1,    -1,    -1,    -1,
      -1,  3603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3636,    -1,  3638,    -1,    -1,    -1,
      -1,    -1,  3644,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3653,    -1,    -1,    -1,  3657,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3673,    -1,    -1,    -1,    -1,    -1,  3679,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3704,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1751,  1752,  1753,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1768,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1793,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1816,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2067,    -1,    -1,  2070,    -1,    -1,  2073,
    2074,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2086,    -1,    -1,  2089,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2102,    -1,
    2104,    -1,    -1,    -1,  2108,    -1,  2110,  2111,    -1,    -1,
      -1,  2115,    -1,  2117,  2118,    -1,  2120,    -1,    -1,  2123,
      -1,  2125,  2126,    -1,    -1,    -1,    -1,  2131,  2132,    -1,
      -1,  2135,    -1,  2137,    -1,  2139,    -1,  2141,    -1,  2143,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2154,  2155,    -1,    -1,  2158,    -1,  2160,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2168,  2169,    -1,  2171,    -1,  2173,
      -1,    -1,  2176,  2177,  2178,    -1,  2180,    -1,    -1,    -1,
      -1,  2185,  2186,  2187,  2188,    -1,    -1,    -1,    -1,  2193,
    2194,  2195,    -1,  2197,    -1,  2199,    -1,  2201,    -1,  2203,
      -1,  2205,    -1,    -1,    -1,    -1,    -1,    -1,  2212,    -1,
    2214,    -1,    -1,  2217,  2218,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2270,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2319,    -1,    -1,    -1,    -1,
    2324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2478,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2551,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2561,    -1,  2563,
      -1,  2565,    -1,    -1,    -1,    -1,    -1,  2571,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2664,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2809,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2819,    -1,    -1,    -1,    -1,
      -1,  2825,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2834,  2835,    -1,    -1,    -1,    -1,  2840,    -1,    -1,    -1,
    2844,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2857,    -1,    -1,    -1,    -1,    -1,  2863,
      -1,    -1,  2866,  2867,    -1,  2869,  2870,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2883,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2949,  2950,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2960,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3132,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3243,
      -1,    -1,    -1,    -1,    -1,  3249,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3295,    -1,  3297,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3449,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3534,  3535,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3553,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3563,
      -1,    -1,    -1,    -1,  3568,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3577,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,  3608,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,  3619,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    43,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,  3680,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,   245,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,   499,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,   344,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,
     576,   577,    -1,   579,   580,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
     430,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,
     580,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
     574,    -1,   576,   577,    -1,   579,   580,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,   574,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,   574,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,   574,    -1,
     576,   577,    -1,   579,   580,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,
     580,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
      -1,    -1,   576,   577,    -1,   579,   580,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,
     576,   577,    -1,   579,   580,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,
     580,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
      -1,    -1,   576,   577,    -1,   579,   580,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    79,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,   178,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,   217,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,   238,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,   252,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,   430,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,   450,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,
     556,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   580,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    79,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,   178,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,   217,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,   238,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,   450,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   580,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
     430,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,    -1,   556,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   574,    -1,    23,    24,    25,    26,
     580,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,   574,    17,    -1,
      -1,    20,   579,   580,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,   226,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,
     469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,
     479,   480,   481,    -1,   483,   484,    -1,   486,   487,    -1,
      -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,   508,
      -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,
      -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,
     539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,    -1,    -1,   556,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   580,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,
     556,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,   567,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   580,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     573,    -1,    17,    -1,    -1,    20,    -1,   580,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   579,   580,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   580,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   580,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,    -1,   556,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,   580,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,
      -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,
     478,   479,   480,   481,    -1,   483,   484,    -1,   486,   487,
      -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,
     508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,
      -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,
      -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   580,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
       5,   556,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,   579,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
       5,   556,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,   579,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
       5,   556,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,   579,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,
      -1,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
      -1,   466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
      -1,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,    -1,   561,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
     575,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,
      -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,
     478,   479,   480,   481,    -1,   483,   484,    -1,   486,   487,
      -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,
     508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,
      -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,
      -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   567,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,
     556,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   567,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   567,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,    -1,   556,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   567,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,   135,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,
      -1,   551,    -1,    -1,    -1,    -1,   556,    -1,    -1,   559,
       5,   561,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,
      -1,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
      -1,   466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
      -1,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
     545,    -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,
      -1,   556,    -1,    -1,   559,     5,   561,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,   545,    -1,   547,    -1,   549,
      -1,   551,    -1,    -1,    -1,    -1,   556,    -1,    -1,   559,
       5,   561,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,
      -1,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
      -1,   466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
      -1,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,     5,   561,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,
      -1,   551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,
       5,   561,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,
      -1,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
      -1,   466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
      -1,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,     5,   561,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,
      -1,   551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,
       5,   561,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,
      -1,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
      -1,   466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
      -1,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,     5,   561,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,
      -1,   551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,
       5,   561,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,
      -1,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
      -1,   466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
      -1,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,     5,   561,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,   166,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,   267,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,   332,   333,    -1,   335,    -1,    -1,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,   452,   453,   454,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
     510,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,   145,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    91,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    34,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    18,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    82,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,   153,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,   175,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,     5,   556,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    -1,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,    -1,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,    -1,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,    -1,    -1,    -1,    -1,   556
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   436,   441,   445,   465,   469,   505,   521,   524,   529,
     552,   573,   584,   585,   586,   587,   588,   589,   591,   596,
     598,   603,   621,   784,   802,   805,   813,   815,   817,   820,
     825,   827,   832,   835,   840,   844,   852,   853,  1002,  1004,
    1010,  1013,  1038,  1046,  1057,  1063,  1077,  1080,  1083,  1089,
    1093,  1097,  1100,  1101,  1147,  1164,  1170,  1172,  1179,  1181,
    1206,  1212,  1213,  1214,  1215,  1253,    11,    94,   179,   214,
     374,   798,  1234,  1235,   258,   336,   834,   483,   485,  1166,
    1207,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   433,   434,
     435,   438,   442,   443,   444,   445,   447,   448,   449,   456,
     457,   459,   462,   465,   466,   469,   470,   472,   473,   474,
     478,   479,   480,   481,   483,   484,   486,   487,   490,   491,
     492,   493,   494,   500,   502,   505,   506,   507,   508,   511,
     512,   515,   520,   523,   525,   527,   528,   536,   539,   542,
     543,   544,   549,   551,   552,   556,   609,  1137,  1141,  1145,
    1146,   287,  1166,  1166,   549,  1208,    94,   178,   450,   486,
     517,   527,   607,   701,   702,   703,   776,  1047,  1003,    94,
     179,   217,   374,   486,   501,   527,   542,  1009,  1141,   834,
     608,   580,  1135,  1136,  1141,   597,  1011,  1098,    96,   217,
     485,  1166,   834,  1141,  1094,   426,   527,  1166,   834,  1014,
    1090,  1166,   608,  1208,  1141,   855,   857,   858,   349,  1149,
    1064,   465,   469,   445,   500,   445,   485,  1058,  1171,  1039,
    1141,    28,    70,   141,   370,   392,   417,   465,  1255,   430,
     573,   854,     0,     3,   370,   156,  1081,  1135,  1141,   145,
     790,  1141,   609,   609,   485,   112,  1231,  1166,   816,  1208,
     841,   842,  1135,   622,   580,   498,   818,   828,    16,  1209,
     213,   704,   608,   354,  1229,  1231,  1232,  1233,  1234,   485,
     702,   217,   214,   270,   382,  1055,  1056,   919,   920,   213,
    1008,  1008,  1141,  1008,  1008,   608,  1008,  1166,   592,  1084,
      12,    13,    87,   115,   129,   151,   163,   192,   217,   223,
     262,   375,   394,   400,   406,   430,   441,   442,   478,   524,
     526,  1182,  1184,  1186,  1187,  1141,   347,    61,   390,   580,
     251,   489,  1138,  1141,  1143,   113,   204,   270,  1016,    77,
     381,  1099,  1102,   226,  1135,  1165,  1166,   175,    32,   287,
    1069,  1095,  1141,   608,   836,  1166,   113,   270,  1017,  1045,
     287,   381,   445,  1091,  1092,   814,    12,  1180,  1184,   498,
    1209,   856,    12,   125,   204,   455,   456,   457,   458,   459,
     460,   471,   862,   863,   864,  1148,    30,    33,    55,    56,
      65,    67,    85,    87,    95,   143,   147,   177,   179,   191,
     193,   216,   217,   220,   237,   258,   263,   287,   320,   329,
     347,   373,   374,   377,   378,   435,   445,   470,   485,   543,
     749,   775,  1065,  1069,  1070,  1072,  1155,   807,   808,   807,
     807,   548,   806,   807,  1007,  1135,  1166,  1045,    34,   203,
     489,  1123,  1139,  1254,  1254,  1254,  1254,  1254,   857,   854,
     574,  1141,  1079,  1078,   301,   487,   512,   786,   788,   787,
    1135,   145,   461,  1236,   826,  1006,  1007,   229,   575,   848,
     849,   573,   623,  1141,   599,  1006,  1006,    52,   335,   335,
     399,  1210,   332,   333,   891,  1141,    91,  1143,  1144,  1197,
    1198,   405,    10,   374,   501,   716,  1230,  1236,  1237,  1245,
    1247,  1231,  1234,   704,  1141,   175,  1048,  1052,  1053,  1141,
    1055,     7,    20,    22,    25,    29,    32,    34,    35,    36,
      38,    51,    55,    56,    62,    65,    73,    74,    80,    83,
      84,    85,    90,    91,    93,    94,    98,    99,   100,   105,
     107,   110,   111,   118,   119,   136,   139,   140,   152,   155,
     157,   158,   162,   166,   171,   176,   180,   181,   182,   183,
     185,   186,   188,   189,   190,   194,   196,   197,   203,   209,
     213,   223,   225,   242,   246,   249,   254,   256,   259,   264,
     267,   272,   279,   289,   293,   302,   306,   308,   309,   313,
     314,   315,   316,   317,   318,   319,   325,   332,   333,   334,
     337,   338,   343,   361,   362,   364,   365,   366,   367,   368,
     380,   388,   404,   405,   416,   419,   422,   424,   428,   467,
     468,   473,   475,   476,   477,   482,   491,   492,   493,   494,
     503,   504,   505,   510,   513,   518,   519,   527,   531,   532,
     533,   534,   535,   540,   544,   554,   556,   561,   565,   566,
     571,   573,   576,   577,   579,   580,   873,   876,   879,   880,
     881,   882,   883,   884,   885,   886,   887,   888,   892,   895,
     896,   898,   905,   909,   921,  1122,  1124,  1126,  1127,  1131,
    1133,  1137,  1139,  1141,   152,  1141,   609,   344,   609,   609,
    1144,  1196,  1006,  1008,   530,   593,   120,   205,   263,   287,
     373,   381,   409,   445,   466,   483,  1085,  1086,  1166,   373,
    1185,   420,   420,   486,   527,   542,   349,  1189,   483,  1191,
      60,   445,  1188,    95,   542,  1190,   344,   575,    18,   145,
     962,   963,  1173,  1141,   798,   873,    75,   175,   270,  1103,
    1109,    47,   175,  1135,  1167,  1168,   833,   579,   590,  1138,
     263,   837,  1144,   838,   839,  1135,   821,   226,  1007,  1018,
    1019,    47,   575,  1006,  1185,   344,   426,  1211,  1210,   516,
    1216,  1217,   567,   866,   867,   868,   864,  1150,  1151,  1152,
     263,   150,   436,   252,   546,  1076,   506,   573,    94,   179,
     374,   485,   542,  1076,   711,  1143,   253,   981,   983,    63,
     466,   172,   466,   466,   466,   287,   483,    63,   466,    12,
      40,    81,    86,   231,   300,   359,   449,   480,  1059,  1060,
    1061,   205,   466,   466,   506,   981,  1076,   175,   229,  1073,
     263,   142,    66,   376,   483,   502,   466,   539,   804,   398,
     462,   809,   810,   803,    78,   798,   575,   346,  1257,   479,
    1258,   236,   412,  1256,   574,  1217,  1219,  1220,  1221,   852,
    1082,  1123,  1141,   111,   698,   699,   700,   709,   710,   758,
     616,   616,   785,  1144,   429,   542,  1006,   498,   575,   111,
     843,  1141,   842,   217,   238,   773,   774,   850,   624,   625,
     873,   273,   274,   275,   276,   277,   278,   281,   282,   283,
     284,   285,   286,   288,   396,   397,   600,   601,   602,   156,
     382,   819,    54,   156,   159,   172,   299,   382,   829,   830,
     831,    52,   399,   152,   606,   573,   872,   579,   211,   575,
     868,   868,   868,   542,  1237,  1135,   507,   530,   777,  1052,
    1135,  1141,   575,  1050,   580,  1054,   573,   573,   573,   573,
     573,   896,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   872,   872,   573,   872,
     573,   573,   573,   513,   573,  1122,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   873,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   922,   923,   924,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   879,   573,   872,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   872,   573,  1122,
     573,   573,   573,  1122,   573,   573,    34,   203,   489,   573,
     573,   573,   872,   872,   872,   573,   573,   573,   573,   573,
     573,   873,   926,   896,   896,   896,   430,   573,   873,  1224,
    1141,   910,  1141,   553,   874,   877,   145,   146,   184,   198,
     232,   244,   271,   328,   893,   229,   252,   395,   448,   562,
     563,   891,   564,   439,   440,   565,   566,   126,   313,   567,
     568,   569,   570,   896,   101,   102,   103,   104,   105,   174,
     206,   207,   208,   209,   302,   304,   305,   306,   314,   380,
     427,   428,   544,   555,   556,   959,   960,    64,   353,   575,
    1139,   573,   580,  1135,   575,    49,   411,   799,  1006,   579,
     594,   595,    47,   548,   575,  1087,   483,   573,  1199,  1199,
    1199,  1199,   179,   374,   485,  1183,  1187,  1141,   164,   330,
    1141,  1174,  1175,  1018,   287,   258,  1108,   845,   287,   963,
     575,  1006,  1143,    27,   498,  1096,   575,   498,   575,   498,
    1006,  1019,  1015,  1092,   175,   575,   179,   374,  1183,  1141,
      12,   125,  1223,   575,   859,   870,   873,  1129,  1141,   575,
     191,   258,   345,   435,  1153,  1154,  1157,  1158,   229,  1074,
    1138,   873,   567,   704,   609,   609,  1135,  1135,  1066,   267,
     338,   510,   984,   985,  1124,   609,  1076,  1144,   172,  1071,
    1073,   609,  1076,   230,   481,   160,   172,  1062,   575,  1071,
    1135,  1073,  1071,  1071,  1076,  1076,   523,   811,   575,   811,
     447,   430,   573,   577,   929,   930,   931,   932,   941,   942,
     950,  1123,   363,  1259,   352,   977,   983,  1222,   700,    64,
     749,    68,    80,   241,   311,   335,   389,   461,   618,   620,
       6,    13,    23,    24,    53,    57,    68,    77,    83,    96,
     114,   123,   124,   129,   137,   143,   169,   215,   217,   224,
     292,   307,   312,   352,   358,   361,   384,   385,   387,   401,
     423,   507,   516,   706,   708,   709,   710,   791,   792,   793,
     973,   112,   228,  1135,   829,  1138,  1007,   573,   574,   575,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   575,   525,   830,   698,   574,
    1143,    45,  1198,   609,   609,   179,  1135,   604,    44,   200,
     425,   778,   778,   344,  1051,  1049,   580,  1053,   175,   567,
    1141,   963,   873,   873,   873,    12,   125,   915,   964,   107,
     166,   203,   267,   338,   510,   987,   915,   915,   915,   873,
     873,   919,   919,   873,   919,   873,   873,   873,   873,   125,
     915,   964,   873,   574,   873,   873,   873,   873,   873,  1131,
    1141,   873,   873,   873,   873,   873,   573,  1224,   873,   959,
     873,   873,   873,   574,   873,   873,   873,   873,   919,   873,
     873,    97,   100,   491,   494,   961,   873,   125,   912,  1122,
     873,   873,   873,   574,   873,   873,   873,   873,   919,   873,
     873,   873,   873,   923,     9,   925,  1131,   125,   915,   873,
     873,   125,   915,   873,   873,   873,   873,   873,   919,   919,
     919,   873,   873,   873,   873,   873,   873,   919,   883,   873,
     574,   873,   873,   873,   873,   873,   574,   873,   873,   915,
     915,   873,   873,   873,   125,   915,   873,   873,   960,   960,
     873,    43,   245,   499,   873,   873,  1122,   574,   873,   574,
     915,  1132,  1133,  1141,   915,   873,   873,   873,   545,   928,
    1227,  1227,   574,   575,   574,   873,   579,   911,  1143,   580,
     876,   875,   878,   882,   158,   337,   504,   520,   891,    12,
      17,   882,   894,   573,   896,   883,   252,   883,   884,   229,
     252,   395,   562,   885,   886,   886,   887,   895,   887,   895,
     888,   888,   888,   888,   888,   896,   566,  1143,   896,   873,
     897,  1141,  1005,  1144,   799,  1143,   575,   390,  1086,  1006,
    1088,  1141,  1200,  1201,   567,  1135,  1141,  1195,  1195,  1195,
     145,   164,   184,   198,   243,   244,   271,   330,   371,  1176,
    1178,   546,   965,  1012,   218,   846,   847,  1135,   270,   390,
     550,  1169,  1168,   829,   873,  1138,  1144,  1144,   839,  1135,
     156,   382,   528,   822,   823,   824,   430,   436,   535,   536,
     573,   694,  1020,  1023,  1138,   192,  1195,  1195,  1195,  1218,
     867,   175,   226,   860,   861,   976,   977,   998,   869,   580,
    1151,   111,   500,  1141,  1160,   321,   361,   579,   749,  1159,
    1138,   175,  1075,   574,  1141,   263,   466,  1068,   341,   575,
     445,  1076,  1141,   381,   981,  1061,  1076,  1071,  1135,  1076,
    1076,   602,   812,   810,   949,  1141,    88,   219,   236,   249,
     324,   416,   471,   940,   436,   575,  1135,   949,   575,   172,
    1260,    45,   981,   145,   437,  1029,  1030,  1030,  1138,   461,
     461,   461,   461,   461,   429,    67,    79,   178,   450,   721,
     724,   725,   771,   773,   797,   797,  1030,  1030,   797,  1030,
    1030,  1030,   498,   122,  1030,   237,   484,   170,   372,   773,
     797,   237,  1030,   484,   122,  1030,  1030,  1030,   797,    45,
    1030,  1030,  1030,  1030,  1030,    18,   145,   498,   801,  1030,
    1030,  1030,   706,   575,   573,   580,   720,   726,  1134,  1141,
     789,   372,   957,  1141,   873,   987,  1138,  1138,   107,   166,
     267,   338,   510,   988,  1138,   987,  1138,  1138,  1138,  1138,
    1138,   987,  1138,  1138,   987,   601,   361,   489,  1249,     8,
      27,   686,   609,  1238,   252,   573,   688,   705,   707,   708,
    1135,   530,   965,  1141,   930,   580,  1054,   575,   574,   574,
     575,   915,   574,   916,   575,   574,   574,   574,    18,   574,
     530,   574,   574,   574,   574,   575,   575,   530,   575,   575,
     906,   574,   567,   574,   575,   575,   574,   574,   575,   574,
     580,   574,   575,   574,   575,   575,   575,   574,   575,   574,
     575,   175,   575,   575,   574,   575,   574,   575,   575,   574,
     575,   574,   574,   575,   574,   575,   575,   575,   908,   575,
     574,   575,   575,   574,   575,   575,   574,   575,   574,   575,
     574,   575,   575,   575,   574,   573,   575,   915,   574,   574,
     574,   915,   574,   574,   575,   575,   574,   574,   575,   574,
     575,   574,   574,   574,   574,   574,   574,   574,   575,   575,
     574,   575,   574,   229,   574,   574,   575,   575,   575,   574,
     575,   575,   574,   574,   574,   575,   175,   575,   575,   915,
     574,   574,   574,   575,   575,   575,   574,   175,   873,   175,
     873,   175,   873,   175,   574,   575,   575,   574,   574,   574,
     574,   574,   575,   574,   575,   574,   873,   545,   559,   927,
     855,  1226,  1224,   919,   578,   191,   258,   435,  1156,   437,
    1141,   351,   354,   889,    15,    16,   890,   158,   337,   504,
     520,   573,   873,  1224,   149,   969,   883,    16,   573,   896,
     883,   883,   959,   959,   873,   900,   901,   902,   573,   580,
     595,   262,   574,   575,   580,   580,   498,   498,   498,  1177,
     966,   982,   983,  1020,   489,  1140,   575,   848,   550,   258,
     498,   823,   695,  1021,   573,  1026,  1031,  1026,   574,   694,
    1022,  1128,  1129,  1132,  1141,  1024,   349,   175,   175,   175,
     853,   130,   930,   999,   172,   262,   865,   998,   982,   861,
      18,   871,  1138,  1141,   567,  1141,   580,   233,   580,  1029,
      32,   111,   750,   751,  1029,  1143,   172,  1029,   579,  1143,
      32,   111,   753,   754,  1143,   988,  1067,   147,   543,   985,
     985,   548,   338,   965,  1071,   575,   944,   949,   929,   236,
     236,   355,   951,   236,   249,   416,   951,   941,   929,  1041,
    1042,  1132,   929,   963,   946,   947,   987,   303,   978,   111,
     755,   757,  1143,   751,    96,    96,   112,   228,   781,  1134,
     774,   774,    58,   170,   372,   517,   723,   772,   722,   723,
     781,  1134,   988,   987,  1134,   987,  1138,  1138,   749,  1030,
     987,   238,   238,  1134,  1134,   711,  1030,   164,   243,   335,
     714,   988,   988,  1134,   974,   975,  1132,   111,   987,  1138,
     987,   987,   383,   386,   713,   987,  1135,    71,    72,   111,
     133,   165,   393,   712,   711,   573,   793,   718,   719,   720,
     721,  1141,     8,   164,   800,   394,   722,   763,   727,   580,
     573,  1239,   574,   575,   489,   573,   115,   223,   524,   687,
    1248,  1239,  1135,   252,   689,   694,   718,   214,   405,   691,
    1110,   575,   707,   605,   930,   976,   965,   963,   225,   873,
     873,   574,   873,   873,    32,    56,    97,   100,   108,   326,
     443,   494,   522,   917,   750,   919,   873,   750,   917,   873,
     919,   574,   895,   895,  1139,  1141,   873,   873,   919,  1139,
     873,   873,   873,   919,   338,   873,   873,   873,   873,   873,
     873,   873,   919,   919,   338,   873,   873,   919,   873,   873,
     873,   873,   919,   873,   883,  1131,   574,   574,   873,   873,
     873,   873,   873,   873,   873,   873,   873,   873,   873,   873,
     919,   225,   873,   873,   873,   873,   574,   873,   873,   873,
     873,   175,   873,   175,   873,   175,   873,   873,   338,   873,
     873,   560,   873,   873,   141,  1228,   574,   574,   580,   580,
     580,  1143,   873,   876,   879,  1224,   574,   575,   574,   896,
     882,   873,  1224,   969,    16,   574,   868,   903,   904,   918,
     919,  1141,  1201,   567,   567,  1197,  1197,  1197,   573,   873,
     344,  1036,  1104,   847,   214,   851,  1144,   862,  1027,  1028,
    1132,  1032,   575,   573,  1023,   574,   574,   575,   580,  1216,
     175,  1197,  1197,  1197,   965,   965,   131,   356,   994,   995,
    1000,   524,   229,  1138,  1141,   580,  1141,   250,  1141,    12,
      32,   111,   344,   873,  1163,    64,   756,   873,  1144,   343,
     361,   489,  1162,  1156,  1029,   981,   275,  1076,   602,  1219,
     945,   249,   236,   941,   951,   951,   236,   344,   344,   530,
     575,  1040,  1029,   169,   214,   529,   953,   862,   873,   979,
    1130,   873,   238,   238,   774,   781,   777,   129,   436,   794,
     751,  1138,   781,   799,  1138,   795,   575,    19,   116,   980,
    1006,   574,   575,  1141,  1135,    31,    32,    37,    39,    41,
      42,    56,    97,   100,   108,   127,   144,   165,   167,   186,
     187,   227,   256,   265,   266,   268,   296,   297,   298,   317,
     318,   319,   323,   326,   339,   340,   365,   367,   391,   434,
     436,   446,   490,   491,   494,   495,   496,   497,   537,   538,
     556,   728,   731,   732,   733,   734,   735,   736,   737,  1141,
    1141,  1240,    18,  1141,  1250,   344,   413,   573,   610,    18,
    1135,   574,   574,    18,   697,   707,   573,   965,   253,   986,
     873,   574,   574,   574,   573,   743,   743,   573,   738,   739,
     743,   227,   227,   574,   574,   574,   574,   574,   574,   575,
     907,   959,   959,   574,   574,   574,   574,   574,   574,   575,
     574,   574,   574,   574,   574,   575,   574,   574,   574,   574,
     574,   914,   977,   575,   575,   575,   574,   574,   574,   574,
     575,   574,   574,   574,   575,   229,   548,   899,   574,   574,
     574,   574,   574,   574,   574,   574,   574,   575,   574,   574,
     574,   873,   574,   172,   574,   574,   575,   575,   574,   575,
     575,   574,   873,   574,   873,   574,   873,   574,   574,   575,
     574,   574,   873,   560,  1225,   580,   782,   574,   919,   574,
     575,   574,   882,   873,   575,   574,   407,  1202,  1202,  1202,
     111,   873,  1034,  1035,   132,  1110,   247,   866,   575,  1029,
    1033,  1034,  1031,  1025,  1023,  1128,  1141,  1197,   982,   195,
     970,  1140,  1140,   579,   996,   997,  1143,   438,   567,   390,
     403,   433,  1161,   757,  1029,   573,   573,  1160,   873,   145,
     574,   931,   355,   929,   941,   236,   236,   929,   941,   934,
     933,   935,  1042,   965,  1035,   773,   954,   954,   954,   866,
     575,   980,   781,   777,   573,   111,   111,   726,   756,   728,
     975,   574,   719,   764,   573,   573,   743,   738,   369,   729,
     738,   738,    20,    32,    46,   515,   749,   759,    56,   537,
     732,   734,   759,   759,    56,   538,   538,   541,   738,   730,
     743,   743,   759,   573,   743,    23,    64,    68,   111,   337,
     344,   372,   434,   517,   745,   746,   747,   762,   891,   541,
     573,   759,    32,   573,   760,   573,   573,   743,   573,   739,
     744,   580,   574,   575,  1241,  1242,   221,   229,   357,   630,
     631,   632,   633,   868,   108,   227,   391,   472,   717,   611,
    1241,   574,   690,   705,   573,   694,   779,   780,  1141,   985,
     959,   338,   759,   338,   873,   574,   574,   574,   873,   873,
     432,   913,   338,   873,   873,   873,   873,    41,   381,   574,
     873,   959,   873,   873,   873,   873,   873,   574,   574,   574,
     338,   873,  1216,  1141,   574,   919,   869,   904,    59,   234,
     331,   463,   474,   551,  1193,  1194,   548,  1203,  1203,  1203,
     574,   575,  1037,   226,   696,  1028,  1035,   574,  1219,    45,
     201,   967,  1001,  1143,   575,   310,    69,   511,   390,  1162,
     489,   489,  1029,  1138,   963,   236,   344,   937,   941,   941,
     344,   939,   873,   873,   573,   976,   172,   952,   948,  1130,
     573,   573,   779,   100,   491,   494,   565,   566,  1125,  1126,
     800,   745,   289,   344,   573,   765,   767,   768,   769,   338,
     338,   443,   522,   557,   740,   741,   742,   573,   740,   740,
     760,    20,   515,   749,   761,   760,   750,   759,   541,   740,
     573,   759,   338,   740,   755,  1138,   334,   748,  1125,   524,
     111,   238,   747,   238,   337,   338,   338,   338,   338,   740,
     338,   740,  1141,  1141,   548,  1244,   430,   573,  1243,   574,
     575,   628,  1135,   509,   626,   627,   629,  1141,  1244,  1219,
     691,   694,   692,   574,   575,   980,   573,   574,   574,   574,
     575,   574,   574,   575,   574,  1123,   574,   575,   574,   575,
     574,   574,   310,   154,   574,   574,   574,   574,   574,   574,
     574,   575,  1228,   574,   871,   489,   489,   489,    16,  1192,
     192,   290,   291,   294,   295,  1204,  1205,  1035,   238,  1105,
     715,   861,   982,   971,  1130,   968,   976,    66,  1111,   997,
     574,   574,  1163,    16,   929,   936,   530,   938,   530,   958,
    1141,   986,   236,   955,   715,   980,   779,   779,   574,  1127,
    1127,   796,   177,   360,   444,   115,   524,   766,  1141,   769,
     574,   574,   742,   783,  1123,   750,   760,   783,   574,   872,
     334,   536,   574,   574,   574,   574,    50,    58,   258,   868,
     868,  1251,   632,  1141,   172,  1138,   574,   575,   628,   574,
    1216,   780,   338,   338,   873,   915,   873,   919,  1193,   349,
     987,   987,   987,   987,  1205,   524,   485,   865,   548,   575,
     972,   980,   873,   982,   138,   148,   350,   488,  1112,  1113,
     255,  1114,   276,   344,   873,   573,   873,   573,   574,   575,
     573,   574,   574,   800,    49,   335,   411,   436,   770,   770,
     574,   575,   574,   575,   574,   872,   759,   760,   759,   760,
      58,   349,    58,   855,   854,   617,   728,   868,   612,   629,
     728,   693,   980,   574,   574,   574,   575,   574,   574,   574,
    1043,  1044,  1132,  1135,    89,   418,  1130,   374,   989,    45,
      45,   138,    45,  1113,   464,   488,  1115,  1116,   145,   943,
     958,   958,  1141,   956,   957,   763,     5,   111,   337,   767,
    1141,   759,  1123,   759,   349,   349,   574,   121,   618,   619,
     891,  1252,   134,   413,  1219,   873,   575,  1029,  1106,   980,
    1141,  1123,  1123,    45,  1123,    45,    45,  1116,   988,   873,
     574,   574,   574,  1219,   121,    61,   161,   213,   235,   248,
     347,   414,   561,   650,   651,   654,   663,   664,   667,   678,
    1137,  1142,  1146,   424,   613,   574,  1044,  1035,   749,   752,
     990,  1123,  1123,  1123,    16,   578,  1141,   175,   330,   656,
     653,  1142,  1142,  1141,   652,   665,   668,   586,    28,   269,
     404,   547,   681,   582,  1246,   728,   751,  1107,   573,   280,
     175,  1141,   658,   659,   873,   873,   545,   670,   674,   682,
     635,   650,   635,   683,   679,   650,   614,  1111,   868,   991,
     992,   993,   145,   226,   141,   873,   666,   675,   559,   674,
     677,   636,   141,   650,   581,   523,   873,   681,   617,  1114,
     873,   574,   575,   987,   655,   213,   560,   545,   669,   671,
     873,   635,   141,   109,   634,   637,   269,   581,   685,   128,
     680,  1142,   615,   214,  1117,   993,   657,  1141,   660,   672,
     671,   677,   676,   561,    82,   153,   642,   648,  1141,   141,
     650,   581,   873,   684,   650,   338,   573,  1118,   575,   635,
     873,   141,   560,   199,   575,   638,    76,    92,   581,   141,
     635,   255,   574,   579,  1119,  1120,  1132,   436,  1121,  1141,
     661,   673,   561,   635,   172,  1141,   728,   172,   172,   404,
     141,  1143,   574,   575,  1043,   135,   559,   662,   560,   639,
     111,   649,   453,   645,   987,   640,   641,   547,  1120,   658,
     635,   635,   452,   454,   643,   644,   645,   647,   891,  1141,
     873,   536,   646,   586,   575,   650,   173,  1139,   644
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1216 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1229 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1289 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1304 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1313 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1320 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1329 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1336 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1350 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1362 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1370 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1380 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1386 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1395 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1400 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1405 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1410 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1415 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1419 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1424 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1428 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1432 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1436 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1440 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1449 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1453 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1469 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1473 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1484 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1501 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1503 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1515 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1523 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1528 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1535 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1541 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1543 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1550 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1565 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1580 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1598 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 101:
#line 1617 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(thd);
	    sp->init(lex);
            sp->init_sp_name(thd, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= thd->client_capabilities & CLIENT_MULTI_QUERIES;
	    thd->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lip->tok_start+1;
	  }
    break;

  case 102:
#line 1656 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_param_end= lip->tok_start;
	  }
    break;

  case 103:
#line 1664 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1672 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1684 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lip->tok_start;
	  }
    break;

  case 106:
#line 1693 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1715 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1716 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1720 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1721 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1727 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 112:
#line 1729 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1731 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1733 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1735 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1737 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1739 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1744 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1745 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1746 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1751 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1755 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1762 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1770 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1786 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 130:
#line 1790 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 135:
#line 1808 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1828 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1865 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1890 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1891 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1892 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1893 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1897 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1902 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1908 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1912 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 152:
#line 1938 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 153:
#line 1946 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 1994 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 2008 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2023 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    lex->spcont->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 157:
#line 2052 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 2075 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2084 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2106 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2107 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2113 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 163:
#line 2115 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 164:
#line 2120 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	    }
	  }
    break;

  case 165:
#line 2143 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 166:
#line 2149 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2163 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2164 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2169 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 170:
#line 2173 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2182 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2187 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2192 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2200 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 175:
#line 2215 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 176:
#line 2232 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 177:
#line 2233 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 178:
#line 2237 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->reset_lex(thd);
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 179:
#line 2246 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 180:
#line 2287 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2289 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2310 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2312 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2315 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2316 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2322 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2328 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2357 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2385 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2400 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2415 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2417 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2441 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2462 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2484 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2486 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2500 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2511 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2531 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2537 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2548 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2556 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2564 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2582 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2586 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2595 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2603 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2607 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2614 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2622 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2635 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2653 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2672 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 228:
#line 2673 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 229:
#line 2678 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2690 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2706 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2715 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2717 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2731 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2741 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2743 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2759 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2761 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2766 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2768 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2770 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2774 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2775 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2777 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[0].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2783 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[-1].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 246:
#line 2791 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2792 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2792 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2796 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2798 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2798 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2800 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2800 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2805 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2821 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2825 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2835 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2836 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2839 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2840 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2843 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2844 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2847 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2848 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2851 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 266:
#line 2852 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 267:
#line 2855 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 268:
#line 2856 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 269:
#line 2859 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2862 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 271:
#line 2863 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2879 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2880 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2881 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2882 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2883 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2884 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2885 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2886 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2888 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2903 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2908 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2909 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2910 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2912 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2917 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2922 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2927 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2943 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2944 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2945 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2946 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2951 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2968 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 2984 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 2993 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 2994 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 2995 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 2996 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 2997 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 2998 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3001 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3002 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 313:
#line 3003 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 314:
#line 3006 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3007 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3008 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3011 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3015 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3016 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3019 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 322:
#line 3020 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 323:
#line 3021 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3022 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 330:
#line 3037 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3044 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyv