# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200411-16.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(15691);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200411-16");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200411-16
(zip: Path name buffer overflow)


    zip does not check the resulting path length when doing recursive folder compression.
  
Impact

    An attacker could exploit this by enticing another user or web application to create an archive including a specially-crafted path name, potentially resulting in the execution of arbitrary code with the permissions of the user running zip.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.hexview.com/docs/20041103-1.txt


Solution: 
    All zip users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/zip-2.3-r4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200411-16] zip: Path name buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'zip: Path name buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-arch/zip", unaffected: make_list("ge 2.3-r4"), vulnerable: make_list("le 2.3-r3")
)) { security_warning(0); exit(0); }
