#TRUSTED 0948776ee74a22edff2f3661ec19065652f135a4b6380b100dfee04ca8ea489840e11b9943047ec7f56f1b4276fd17de19b2fbea11bd720ead4e3c8564f4e3108a8e41d61c465a454d3b34e7b82ba59c5b1c0470920bd27fc3d91c9b883a01ba63f60c350a272cb243081e354424c25ba77c87499292a31686dd47d338091ece0494e75039f08be65030dc13c2e5e181572b7a9d1857633dbdcc607f83519490b129e7dd470dc51e12eafc39e25c73c67052015de1969eb80903e5bf807b5e63045a2ac01e8f917e3d7d17044790eb4754ce278dd70c4580d020eb21e6aca25515e34f31f9b88e33e878b7eb7470570362eb9df85ecb22283559e692274bde1cf9e763cd18dca942467be4f103f30b87c9b9bd56899dee6bb7d93870eedbfb31311fc2f52bbbc621ee3a30f2e2029c33760cbe68eda77032a59abbba425de669a91be0c85ddf15dc7ca452134600ab60e2eaa367ec494e381e723d08695e5faadd5159c8c07999ec13092ae535a551893d970fa832b59e1e8e91a603a7c35b0c3a55584a135a4e760162c6609ee2edae36eb67f6bbc72b7454268643b9307fc986209f66d2555cae9e8df6f8069ed4a74b73d35350844b785eb9000d1d92459941ea43fc410ecea00ceef6ce3662977f138e44990fa69e04e88c815e2264d0063a24d349d720cef329dcf9d645d267d2f5747da39792f0934aec1353550d8ace
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15888);
 script_version ("1.1");
 name["english"] = "Hydra: SSH2";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SSH2 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SSH2 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ssh", 22);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ssh");
if (! port) port = 22;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ssh2";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ssh2/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SSH accounts:\n' + report);
