#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#

if (description) {
  script_id(14218);
  script_bugtraq_id(5060);
  script_version("$Revision: 1.8 $");

# script_cve_id("CVE-MAP-NOMATCH");
# NOTE: no CVE id assigned (gat, August 2004)
 
  name["english"] = "BasiliX Message Content Script Injection Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
The target is running at least one instance of BasiliX whose version
number is 1.1.0 or lower.  Such versions are vulnerable to
cross-scripting attacks since they do not filter HTML tags when showing
a message.  As a result, an attacker can include Javascript code in a
message and have that code executed by the user's browser when it is
viewed. 

***** Nessus has determined the vulnerability exists on the target
***** simply by looking at the version number(s) of BasiliX
***** installed there.

Solution : Upgrade to BasiliX version 1.1.1 or later.

Risk factor : Medium";

  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for Message Content Script Injection Vulnerability in BasiliX";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 George A. Theall");

  family["english"] = "CGI abuses";
  script_family(english:family["english"]);

  script_dependencie("basilix_detect.nasl", "global_settings.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}

include("global_settings.inc");
include("http_func.inc");

host = get_host_name();
port = get_http_port(default:80);
if (debug_level) 
    display("debug: searching for Message Content Script Injection vulnerability in BasiliX on ", host, ":", port, ".\n");

if (!get_port_state(port)) 
	exit(0);

# Check each installed instance, stopping if we find a vulnerability.
installs = get_kb_list(string("www/", port, "/basilix"));
if (isnull(installs)) 
	exit(0);
foreach install (installs) 
{
	matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
  	if (!isnull(matches)) 
	{
    		ver = matches[1];
    		dir = matches[2];
    		if (debug_level) 
			display("debug: checking version ", ver, " under ", dir, ".\n");

    		if (ereg(pattern:"^(0\..*|1\.0.*|1\.1\.0)$", string:ver)) 
		{
      			security_warning(port);
      			exit(0);
    		}
  	}
}
