# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200501-43.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(16434);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200501-43");
 script_cve_id("CAN-2005-0017");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200501-43
(f2c: Insecure temporary file creation)


    Javier Fernandez-Sanguino Pena from the Debian Security Audit Team
    discovered that f2c creates temporary files in world-writeable
    directories with predictable names.
  
Impact

    A local attacker could create symbolic links in the temporary
    files directory, pointing to a valid file somewhere on the filesystem.
    When f2c is executed, this would result in the file being overwritten
    with the rights of the user running the software, which could be the
    root user.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2005-0017


Solution: 
    All f2c users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/f2c-20030320-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200501-43] f2c: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'f2c: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/f2c", unaffected: make_list("ge 20030320-r1"), vulnerable: make_list("le 20030320")
)) { security_warning(0); exit(0); }
