/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "nl-scroll-view.h"

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/clutk.h>

#include "nl-defines.h"
#include "nl-texture-frame.h"

G_DEFINE_TYPE (NlScrollView, nl_scroll_view, CTK_TYPE_SCROLL_VIEW);

#define TROUGH_FILE PKGDATADIR"/scroll_view_trough.png"
#define SLIDER_FILE PKGDATADIR"/scroll_view_slider.png"

/* Globals */

/* Forwards */

/* GObject stuff */
static void
nl_scroll_view_constructed (GObject *object)
{
  GObjectClass        *klass;
  static ClutterActor *trough_texture = NULL;
  static ClutterActor *slider_texture = NULL;
  CtkPadding           padding = { 12, 12, 12, 0 };
  ClutterActor        *trough, *slider;

  klass = G_OBJECT_CLASS (nl_scroll_view_parent_class);
  if (klass->constructed)
    klass->constructed (object);

  if (!CLUTTER_IS_ACTOR (trough_texture))
    trough_texture = clutter_texture_new_from_file (TROUGH_FILE, NULL);
  if (!CLUTTER_IS_ACTOR (slider_texture))
    slider_texture = clutter_texture_new_from_file (SLIDER_FILE, NULL);

  trough = nl_texture_frame_new (CLUTTER_TEXTURE (trough_texture), 5, 5, 5, 5);
  clutter_actor_set_size (trough, 18, 18);

  slider = nl_texture_frame_new (CLUTTER_TEXTURE (slider_texture), 5, 5, 5, 5);
  clutter_actor_set_size (slider, 18, 18);

  ctk_scroll_view_set_scroll_bar (CTK_SCROLL_VIEW (object), trough, slider);

  ctk_actor_set_padding (CTK_ACTOR (object), &padding);
}

static void
nl_scroll_view_class_init (NlScrollViewClass *klass)
{
  GObjectClass      *obj_class      = G_OBJECT_CLASS (klass);

  obj_class->constructed = nl_scroll_view_constructed;
}

static void
nl_scroll_view_init (NlScrollView *scroll_view)
{

}

/*
 * Private methods
 */

/*
 * Public methods
 */
ClutterActor *
nl_scroll_view_new (void)

{
  ClutterActor *scroll_view = NULL;

  scroll_view = g_object_new (NL_TYPE_SCROLL_VIEW,
                              NULL);

  return scroll_view;
}
