/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_SIDEBAR_ITEM_H_
#define _NL_SIDEBAR_ITEM_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/clutk.h>

#define NL_TYPE_SIDEBAR_ITEM (nl_sidebar_item_get_type ())

#define NL_SIDEBAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_SIDEBAR_ITEM, NlSidebarItem))

#define NL_SIDEBAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_SIDEBAR_ITEM, NlSidebarItemClass))

#define NL_IS_SIDEBAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_SIDEBAR_ITEM))

#define NL_IS_SIDEBAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_SIDEBAR_ITEM))

#define NL_SIDEBAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_SIDEBAR_ITEM, NlSidebarItemClass))

typedef struct _NlSidebarItem        NlSidebarItem;
typedef struct _NlSidebarItemClass   NlSidebarItemClass;
typedef struct _NlSidebarItemPrivate NlSidebarItemPrivate;
 
struct _NlSidebarItem
{
  CtkButton        parent;	

  NlSidebarItemPrivate *priv;
};

struct _NlSidebarItemClass
{
  CtkButtonClass   parent_class;

};

GType          nl_sidebar_item_get_type (void) G_GNUC_CONST;

ClutterActor * nl_sidebar_item_new        (const gchar *title,
                                           const gchar *tooltip,
                                           GdkPixbuf   *icon,
                                           gint         pos);

/*
 * This is the preferred position of the item on the sidebar, where
 * 0 is the "Favourites" item. Feel free to leave padding between the start of
 * the numbers, i.e. Places returns 100 as it's preferred pos, and the
 * menu items start from 200
 */
gint           nl_sidebar_item_get_pos    (NlSidebarItem *item);

void           nl_sidebar_item_set_pos    (NlSidebarItem *item,
                                           gint           pos);

void           nl_sidebar_item_set_active (NlSidebarItem *item,
                                           gboolean       is_active);

gboolean       nl_sidebar_item_get_active (NlSidebarItem *item);

#endif /* _NL_SIDEBAR_ITEM_H_ */

