/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import java.net.SocketAddress;
import java.util.Map;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.DefaultChildChannelStateEvent;
import org.jboss.netty.channel.DefaultExceptionEvent;
import org.jboss.netty.channel.DefaultWriteCompletionEvent;
import org.jboss.netty.channel.DownstreamChannelStateEvent;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.FailedChannelFuture;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SucceededChannelFuture;
import org.jboss.netty.channel.UpstreamChannelStateEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;

public class Channels {
    public static ChannelPipeline pipeline() {
        return new DefaultChannelPipeline();
    }

    public static ChannelPipeline pipeline(ChannelPipeline pipeline) {
        ChannelPipeline newPipeline = Channels.pipeline();
        for (Map.Entry<String, ChannelHandler> e : pipeline.toMap().entrySet()) {
            newPipeline.addLast(e.getKey(), e.getValue());
        }
        return newPipeline;
    }

    public static ChannelPipelineFactory pipelineFactory(final ChannelPipeline pipeline) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                return Channels.pipeline(pipeline);
            }
        };
    }

    public static ChannelFuture future(Channel channel) {
        return Channels.future(channel, false);
    }

    public static ChannelFuture future(Channel channel, boolean cancellable) {
        return new DefaultChannelFuture(channel, cancellable);
    }

    public static ChannelFuture succeededFuture(Channel channel) {
        if (channel instanceof AbstractChannel) {
            return ((AbstractChannel)channel).getSucceededFuture();
        }
        return new SucceededChannelFuture(channel);
    }

    public static ChannelFuture failedFuture(Channel channel, Throwable cause) {
        return new FailedChannelFuture(channel, cause);
    }

    @Deprecated
    public static MessageEvent messageEvent(Channel channel, ChannelFuture future, Object message) {
        return Channels.messageEvent(channel, future, message, null);
    }

    @Deprecated
    public static MessageEvent messageEvent(Channel channel, ChannelFuture future, Object message, SocketAddress remoteAddress) {
        return new DownstreamMessageEvent(channel, future, message, remoteAddress);
    }

    public static void fireChannelOpen(Channel channel) {
        if (channel.getParent() != null) {
            Channels.fireChildChannelStateChanged(channel.getParent(), channel);
        }
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.OPEN, Boolean.TRUE));
    }

    public static void fireChannelOpen(ChannelHandlerContext ctx) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.OPEN, Boolean.TRUE));
    }

    @Deprecated
    public static void fireChannelOpen(ChannelHandlerContext ctx, Channel channel) {
        Channels.fireChannelOpen(ctx);
    }

    public static void fireChannelBound(Channel channel, SocketAddress localAddress) {
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.BOUND, localAddress));
    }

    public static void fireChannelBound(ChannelHandlerContext ctx, SocketAddress localAddress) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.BOUND, localAddress));
    }

    @Deprecated
    public static void fireChannelBound(ChannelHandlerContext ctx, Channel channel, SocketAddress localAddress) {
        Channels.fireChannelBound(ctx, localAddress);
    }

    public static void fireChannelConnected(Channel channel, SocketAddress remoteAddress) {
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.CONNECTED, remoteAddress));
    }

    public static void fireChannelConnected(ChannelHandlerContext ctx, SocketAddress remoteAddress) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.CONNECTED, remoteAddress));
    }

    @Deprecated
    public static void fireChannelConnected(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress) {
        Channels.fireChannelConnected(ctx, remoteAddress);
    }

    public static void fireMessageReceived(Channel channel, Object message) {
        Channels.fireMessageReceived(channel, message, null);
    }

    public static void fireMessageReceived(Channel channel, Object message, SocketAddress remoteAddress) {
        channel.getPipeline().sendUpstream(new UpstreamMessageEvent(channel, message, remoteAddress));
    }

    public static void fireMessageReceived(ChannelHandlerContext ctx, Object message) {
        ctx.sendUpstream(new UpstreamMessageEvent(ctx.getChannel(), message, null));
    }

    @Deprecated
    public static void fireMessageReceived(ChannelHandlerContext ctx, Channel channel, Object message) {
        Channels.fireMessageReceived(ctx, message);
    }

    public static void fireMessageReceived(ChannelHandlerContext ctx, Object message, SocketAddress remoteAddress) {
        ctx.sendUpstream(new UpstreamMessageEvent(ctx.getChannel(), message, remoteAddress));
    }

    @Deprecated
    public static void fireMessageReceived(ChannelHandlerContext ctx, Channel channel, Object message, SocketAddress remoteAddress) {
        Channels.fireMessageReceived(ctx, message, remoteAddress);
    }

    public static void fireWriteComplete(Channel channel, int amount) {
        if (amount == 0) {
            return;
        }
        channel.getPipeline().sendUpstream(new DefaultWriteCompletionEvent(channel, amount));
    }

    public static void fireWriteComplete(ChannelHandlerContext ctx, int amount) {
        ctx.sendUpstream(new DefaultWriteCompletionEvent(ctx.getChannel(), amount));
    }

    public static void fireChannelInterestChanged(Channel channel) {
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.INTEREST_OPS, 1));
    }

    @Deprecated
    public static void fireChannelInterestChanged(Channel channel, int interestOps) {
        Channels.fireChannelInterestChanged(channel);
    }

    public static void fireChannelInterestChanged(ChannelHandlerContext ctx) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.INTEREST_OPS, 1));
    }

    @Deprecated
    public static void fireChannelInterestChanged(ChannelHandlerContext ctx, Channel channel, int interestOps) {
        Channels.fireChannelInterestChanged(ctx);
    }

    public static void fireChannelDisconnected(Channel channel) {
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.CONNECTED, null));
    }

    public static void fireChannelDisconnected(ChannelHandlerContext ctx) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.CONNECTED, null));
    }

    @Deprecated
    public static void fireChannelDisconnected(ChannelHandlerContext ctx, Channel channel) {
        Channels.fireChannelDisconnected(ctx);
    }

    public static void fireChannelUnbound(Channel channel) {
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.BOUND, null));
    }

    public static void fireChannelUnbound(ChannelHandlerContext ctx) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.BOUND, null));
    }

    @Deprecated
    public static void fireChannelUnbound(ChannelHandlerContext ctx, Channel channel) {
        Channels.fireChannelUnbound(ctx);
    }

    public static void fireChannelClosed(Channel channel) {
        channel.getPipeline().sendUpstream(new UpstreamChannelStateEvent(channel, ChannelState.OPEN, Boolean.FALSE));
        if (channel.getParent() != null) {
            Channels.fireChildChannelStateChanged(channel.getParent(), channel);
        }
    }

    public static void fireChannelClosed(ChannelHandlerContext ctx) {
        ctx.sendUpstream(new UpstreamChannelStateEvent(ctx.getChannel(), ChannelState.OPEN, Boolean.FALSE));
    }

    @Deprecated
    public static void fireChannelClosed(ChannelHandlerContext ctx, Channel channel) {
        Channels.fireChannelClosed(ctx);
    }

    public static void fireExceptionCaught(Channel channel, Throwable cause) {
        channel.getPipeline().sendUpstream(new DefaultExceptionEvent(channel, cause));
    }

    public static void fireExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.sendUpstream(new DefaultExceptionEvent(ctx.getChannel(), cause));
    }

    @Deprecated
    public static void fireExceptionCaught(ChannelHandlerContext ctx, Channel channel, Throwable cause) {
        Channels.fireExceptionCaught(ctx, cause);
    }

    private static void fireChildChannelStateChanged(Channel channel, Channel childChannel) {
        channel.getPipeline().sendUpstream(new DefaultChildChannelStateEvent(channel, childChannel));
    }

    public static ChannelFuture bind(Channel channel, SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        ChannelFuture future = Channels.future(channel);
        channel.getPipeline().sendDownstream(new DownstreamChannelStateEvent(channel, future, ChannelState.BOUND, localAddress));
        return future;
    }

    public static void bind(ChannelHandlerContext ctx, ChannelFuture future, SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        ctx.sendDownstream(new DownstreamChannelStateEvent(ctx.getChannel(), future, ChannelState.BOUND, localAddress));
    }

    @Deprecated
    public static void bind(ChannelHandlerContext ctx, Channel channel, ChannelFuture future, SocketAddress localAddress) {
        Channels.bind(ctx, future, localAddress);
    }

    public static void unbind(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream(new DownstreamChannelStateEvent(ctx.getChannel(), future, ChannelState.BOUND, null));
    }

    @Deprecated
    public static void unbind(ChannelHandlerContext ctx, Channel channel, ChannelFuture future) {
        Channels.unbind(ctx, future);
    }

    public static ChannelFuture unbind(Channel channel) {
        ChannelFuture future = Channels.future(channel);
        channel.getPipeline().sendDownstream(new DownstreamChannelStateEvent(channel, future, ChannelState.BOUND, null));
        return future;
    }

    public static ChannelFuture connect(Channel channel, SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        ChannelFuture future = Channels.future(channel, true);
        channel.getPipeline().sendDownstream(new DownstreamChannelStateEvent(channel, future, ChannelState.CONNECTED, remoteAddress));
        return future;
    }

    public static void connect(ChannelHandlerContext ctx, ChannelFuture future, SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        ctx.sendDownstream(new DownstreamChannelStateEvent(ctx.getChannel(), future, ChannelState.CONNECTED, remoteAddress));
    }

    @Deprecated
    public static void connect(ChannelHandlerContext ctx, Channel channel, ChannelFuture future, SocketAddress remoteAddress) {
        Channels.connect(ctx, future, remoteAddress);
    }

    public static ChannelFuture write(Channel channel, Object message) {
        return Channels.write(channel, message, null);
    }

    public static void write(ChannelHandlerContext ctx, ChannelFuture future, Object message) {
        Channels.write(ctx, future, message, null);
    }

    @Deprecated
    public static void write(ChannelHandlerContext ctx, Channel channel, ChannelFuture future, Object message) {
        Channels.write(ctx, future, message, null);
    }

    public static ChannelFuture write(Channel channel, Object message, SocketAddress remoteAddress) {
        ChannelFuture future = Channels.future(channel);
        channel.getPipeline().sendDownstream(new DownstreamMessageEvent(channel, future, message, remoteAddress));
        return future;
    }

    public static void write(ChannelHandlerContext ctx, ChannelFuture future, Object message, SocketAddress remoteAddress) {
        ctx.sendDownstream(new DownstreamMessageEvent(ctx.getChannel(), future, message, remoteAddress));
    }

    @Deprecated
    public static void write(ChannelHandlerContext ctx, Channel channel, ChannelFuture future, Object message, SocketAddress remoteAddress) {
        Channels.write(ctx, future, message, remoteAddress);
    }

    public static ChannelFuture setInterestOps(Channel channel, int interestOps) {
        Channels.validateInterestOps(interestOps);
        interestOps = Channels.filterDownstreamInterestOps(interestOps);
        ChannelFuture future = Channels.future(channel);
        channel.getPipeline().sendDownstream(new DownstreamChannelStateEvent(channel, future, ChannelState.INTEREST_OPS, interestOps));
        return future;
    }

    public static void setInterestOps(ChannelHandlerContext ctx, ChannelFuture future, int interestOps) {
        Channels.validateInterestOps(interestOps);
        interestOps = Channels.filterDownstreamInterestOps(interestOps);
        ctx.sendDownstream(new DownstreamChannelStateEvent(ctx.getChannel(), future, ChannelState.INTEREST_OPS, interestOps));
    }

    @Deprecated
    public static void setInterestOps(ChannelHandlerContext ctx, Channel channel, ChannelFuture future, int interestOps) {
        Channels.setInterestOps(ctx, future, interestOps);
    }

    public static ChannelFuture disconnect(Channel channel) {
        ChannelFuture future = Channels.future(channel);
        channel.getPipeline().sendDownstream(new DownstreamChannelStateEvent(channel, future, ChannelState.CONNECTED, null));
        return future;
    }

    public static void disconnect(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream(new DownstreamChannelStateEvent(ctx.getChannel(), future, ChannelState.CONNECTED, null));
    }

    @Deprecated
    public static void disconnect(ChannelHandlerContext ctx, Channel channel, ChannelFuture future) {
        Channels.disconnect(ctx, future);
    }

    public static ChannelFuture close(Channel channel) {
        ChannelFuture future = channel.getCloseFuture();
        channel.getPipeline().sendDownstream(new DownstreamChannelStateEvent(channel, future, ChannelState.OPEN, Boolean.FALSE));
        return future;
    }

    public static void close(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream(new DownstreamChannelStateEvent(ctx.getChannel(), future, ChannelState.OPEN, Boolean.FALSE));
    }

    @Deprecated
    public static void close(ChannelHandlerContext ctx, Channel channel, ChannelFuture future) {
        Channels.close(ctx, future);
    }

    private static void validateInterestOps(int interestOps) {
        switch (interestOps) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid interestOps: " + interestOps);
            }
        }
    }

    private static int filterDownstreamInterestOps(int interestOps) {
        return interestOps & 0xFFFFFFFB;
    }

    private Channels() {
    }
}

