/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannel;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketPipelineSink;
import org.jboss.netty.util.internal.ExecutorUtil;

public class HttpTunnelingClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private final Executor workerExecutor;
    private final ChannelSink sink;
    ClientSocketChannelFactory clientSocketChannelFactory;

    public HttpTunnelingClientSocketChannelFactory(ClientSocketChannelFactory clientSocketChannelFactory, Executor workerExecutor) {
        this(workerExecutor, Runtime.getRuntime().availableProcessors());
        this.clientSocketChannelFactory = clientSocketChannelFactory;
    }

    public HttpTunnelingClientSocketChannelFactory(Executor workerExecutor, int workerCount) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new HttpTunnelingClientSocketPipelineSink(workerExecutor);
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new HttpTunnelingClientSocketChannel(this, pipeline, this.sink, this.clientSocketChannelFactory);
    }

    public void releaseExternalResources() {
        this.clientSocketChannelFactory.releaseExternalResources();
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

