/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.DefaultSocketChannelConfig;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.SocketChannelConfig;

abstract class OioSocketChannel
extends AbstractChannel
implements SocketChannel {
    final Socket socket;
    final Object interestOpsLock = new Object();
    private final SocketChannelConfig config;
    volatile Thread workerThread;

    OioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink);
        this.socket = socket;
        this.config = new DefaultSocketChannelConfig(socket);
    }

    public SocketChannelConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    public boolean isBound() {
        return this.isOpen() && this.socket.isBound();
    }

    public boolean isConnected() {
        return this.isOpen() && this.socket.isConnected();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    protected void setInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    abstract PushbackInputStream getInputStream();

    abstract OutputStream getOutputStream();

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }
}

