/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.io.Closeable;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.xnio.AbstractXnioChannelHandler;
import org.jboss.netty.channel.xnio.DefaultXnioServerChannel;
import org.jboss.netty.channel.xnio.XnioAcceptedChannel;
import org.jboss.netty.channel.xnio.XnioChannelRegistry;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.MultipointMessageChannel;

final class XnioAcceptedChannelHandler
extends AbstractXnioChannelHandler {
    XnioAcceptedChannelHandler() {
    }

    public void handleOpened(Channel channel) {
        DefaultXnioServerChannel parent = null;
        if (channel instanceof BoundChannel) {
            SocketAddress localAddress = (SocketAddress)((BoundChannel)channel).getLocalAddress();
            parent = XnioChannelRegistry.getServerChannel(localAddress);
            if (parent == null) {
                IoUtils.safeClose((Closeable)channel);
                return;
            }
        } else {
            IoUtils.safeClose((Closeable)channel);
            return;
        }
        if (parent.xnioChannel instanceof MultipointMessageChannel) {
            XnioChannelRegistry.registerChannelMapping(parent);
        } else {
            try {
                XnioAcceptedChannel c = new XnioAcceptedChannel(parent, parent.getFactory(), parent.getConfig().getPipelineFactory().getPipeline(), (ChannelSink)parent.getFactory().sink);
                c.xnioChannel = channel;
                Channels.fireChannelOpen(c);
                if (c.isBound()) {
                    Channels.fireChannelBound(c, c.getLocalAddress());
                    if (c.isConnected()) {
                        Channels.fireChannelConnected(c, c.getRemoteAddress());
                    }
                }
                XnioChannelRegistry.registerChannelMapping(c);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.resumeRead(channel);
    }
}

