/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.util.concurrent.ConcurrentMap;
import org.jboss.netty.channel.xnio.BaseXnioChannel;
import org.jboss.netty.channel.xnio.DefaultXnioServerChannel;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.jboss.netty.util.internal.ConcurrentIdentityHashMap;

final class XnioChannelRegistry {
    private static final ConcurrentMap<SocketAddress, DefaultXnioServerChannel> serverChannels = new ConcurrentHashMap<SocketAddress, DefaultXnioServerChannel>();
    private static final ConcurrentMap<Channel, BaseXnioChannel> mapping = new ConcurrentIdentityHashMap<Channel, BaseXnioChannel>();
    private static final InetAddress ANY_IPV4;
    private static final InetAddress ANY_IPV6;

    static void registerServerChannel(DefaultXnioServerChannel channel) {
        SocketAddress localAddress = channel.getLocalAddress();
        if (localAddress == null) {
            throw new IllegalStateException("cannot register an unbound channel");
        }
        if (serverChannels.putIfAbsent(localAddress, channel) != null) {
            throw new IllegalStateException("duplicate local address: " + localAddress);
        }
    }

    static void unregisterServerChannel(SocketAddress localAddress) {
        if (localAddress == null) {
            return;
        }
        serverChannels.remove(localAddress);
    }

    static DefaultXnioServerChannel getServerChannel(SocketAddress localAddress) {
        InetSocketAddress a;
        DefaultXnioServerChannel answer = (DefaultXnioServerChannel)serverChannels.get(localAddress);
        if (answer == null && localAddress instanceof InetSocketAddress && (answer = (DefaultXnioServerChannel)serverChannels.get(new InetSocketAddress(ANY_IPV6, (a = (InetSocketAddress)localAddress).getPort()))) == null) {
            answer = (DefaultXnioServerChannel)serverChannels.get(new InetSocketAddress(ANY_IPV4, a.getPort()));
        }
        return answer;
    }

    static void registerChannelMapping(BaseXnioChannel channel) {
        if (mapping.putIfAbsent(channel.xnioChannel, channel) != null) {
            throw new IllegalStateException("duplicate mapping: " + channel);
        }
    }

    static void unregisterChannelMapping(BaseXnioChannel channel) {
        Channel xnioChannel = channel.xnioChannel;
        if (xnioChannel != null) {
            mapping.remove(xnioChannel);
        }
    }

    static BaseXnioChannel getChannel(Channel channel) {
        return (BaseXnioChannel)mapping.get(channel);
    }

    private XnioChannelRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InetAddress any4 = null;
        try {
            any4 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ANY_IPV4 = any4;
            throw throwable;
        }
    }
}

