/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.container.microcontainer;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.JBossLoggerFactory;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.jboss.netty.util.internal.UnterminatableExecutor;

public class NettyResourceFactory {
    private Executor executor;
    private Executor unterminatableExecutor;

    public synchronized void create() {
        if (this.executor != null) {
            return;
        }
        this.executor = Executors.newCachedThreadPool();
        this.unterminatableExecutor = new UnterminatableExecutor(this.executor);
    }

    public void start() {
        InternalLoggerFactory.setDefaultFactory(new JBossLoggerFactory());
    }

    public synchronized void stop() {
        if (this.executor != null) {
            ExecutorUtil.terminate(this.executor);
        }
    }

    public synchronized void destroy() {
        this.executor = null;
        this.unterminatableExecutor = null;
    }

    public synchronized Executor getChannelFactoryExecutor() {
        return this.unterminatableExecutor;
    }
}

